/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.FieldInitAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ClassModifier;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@JadxVisitor(name="ExtractFieldInit", desc="Move duplicated field initialization from constructors", runAfter={ModVisitor.class}, runBefore={ClassModifier.class})
public class ExtractFieldInit
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        for (ClassNode inner : cls.getInnerClasses()) {
            this.visit(inner);
        }
        ExtractFieldInit.checkStaticFieldsInit(cls);
        ExtractFieldInit.moveStaticFieldsInit(cls);
        ExtractFieldInit.moveCommonFieldsInit(cls);
        return false;
    }

    private static void checkStaticFieldsInit(ClassNode cls) {
        MethodNode clinit = cls.getClassInitMth();
        if (clinit == null || !clinit.getAccessFlags().isStatic() || clinit.isNoCode() || clinit.getBasicBlocks() == null) {
            return;
        }
        for (BlockNode block : clinit.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                if (insn.getType() != InsnType.SPUT) continue;
                ExtractFieldInit.processStaticFieldAssign(cls, (IndexInsnNode)insn);
            }
        }
    }

    private static void processStaticFieldAssign(ClassNode cls, IndexInsnNode insn) {
        FieldNode fn;
        FieldInfo field = (FieldInfo)insn.getIndex();
        if (field.getDeclClass().equals(cls.getClassInfo()) && (fn = cls.searchField(field)) != null && fn.getAccessFlags().isFinal()) {
            fn.remove(AType.FIELD_INIT);
        }
    }

    private static void moveStaticFieldsInit(ClassNode cls) {
        MethodNode classInitMth = cls.getClassInitMth();
        if (classInitMth == null) {
            return;
        }
        for (FieldNode field : cls.getFields()) {
            InsnNode insn;
            List<InsnNode> initInsns;
            if (field.contains(AFlag.DONT_GENERATE) || !field.getAccessFlags().isStatic() || (initInsns = ExtractFieldInit.getFieldAssigns(classInitMth, field, InsnType.SPUT)).size() != 1 || !ExtractFieldInit.checkInsn(cls, insn = initInsns.get(0))) continue;
            InsnArg arg = insn.getArg(0);
            if (arg instanceof InsnWrapArg) {
                ((InsnWrapArg)arg).getWrapInsn().add(AFlag.DECLARE_VAR);
            }
            InsnRemover.remove(classInitMth, insn);
            ExtractFieldInit.addFieldInitAttr(classInitMth, field, insn);
        }
    }

    private static void moveCommonFieldsInit(ClassNode cls) {
        FieldNode field;
        Object fieldInfo;
        List<MethodNode> constrList = ExtractFieldInit.getConstructorsList(cls);
        if (constrList.isEmpty()) {
            return;
        }
        ArrayList<InitInfo> infoList = new ArrayList<InitInfo>(constrList.size());
        block0: for (MethodNode methodNode : constrList) {
            if (methodNode.isNoCode() || methodNode.getBasicBlocks().isEmpty()) {
                return;
            }
            InitInfo info = new InitInfo(methodNode);
            infoList.add(info);
            BlockNode blockNode = methodNode.getBasicBlocks().get(0);
            for (InsnNode insn : blockNode.getInstructions()) {
                if (insn.getType() == InsnType.IPUT && ExtractFieldInit.checkInsn(cls, insn)) {
                    info.getPutInsns().add(insn);
                    continue;
                }
                if (info.getPutInsns().isEmpty()) continue;
                continue block0;
            }
        }
        InitInfo common = null;
        for (InitInfo info : infoList) {
            if (common == null) {
                common = info;
                continue;
            }
            if (ExtractFieldInit.compareInsns(common.getPutInsns(), info.getPutInsns())) continue;
            return;
        }
        if (common == null) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (InsnNode insn : common.getPutInsns()) {
            fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
            field = cls.root().resolveField((FieldInfo)fieldInfo);
            if (field == null) {
                return;
            }
            if (hashSet.add(fieldInfo)) continue;
            return;
        }
        for (InitInfo info : infoList) {
            for (InsnNode putInsn : info.getPutInsns()) {
                InsnArg arg = putInsn.getArg(0);
                if (arg instanceof InsnWrapArg) {
                    ((InsnWrapArg)arg).getWrapInsn().add(AFlag.DECLARE_VAR);
                }
                InsnRemover.remove(info.getConstrMth(), putInsn);
            }
        }
        for (InsnNode insn : common.getPutInsns()) {
            fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
            field = cls.root().resolveField((FieldInfo)fieldInfo);
            ExtractFieldInit.addFieldInitAttr(common.getConstrMth(), field, insn);
        }
    }

    private static boolean compareInsns(List<InsnNode> base, List<InsnNode> other) {
        if (base.size() != other.size()) {
            return false;
        }
        int count = base.size();
        for (int i = 0; i < count; ++i) {
            InsnNode otherInsn;
            InsnNode baseInsn = base.get(i);
            if (baseInsn.isSame(otherInsn = other.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkInsn(ClassNode cls, InsnNode insn) {
        if (insn instanceof IndexInsnNode) {
            FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
            if (!fieldInfo.getDeclClass().equals(cls.getClassInfo())) {
                return false;
            }
            FieldNode fieldNode = cls.root().resolveField(fieldInfo);
            if (fieldNode == null) {
                return false;
            }
        } else {
            return false;
        }
        InsnArg arg = insn.getArg(0);
        if (arg.isInsnWrap()) {
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            if (!wrapInsn.canReorderRecursive() && insn.contains(AType.CATCH_BLOCK)) {
                return false;
            }
        } else {
            return arg.isLiteral() || arg.isThis();
        }
        HashSet<RegisterArg> regs = new HashSet<RegisterArg>();
        insn.getRegisterArgs(regs);
        if (!regs.isEmpty()) {
            for (RegisterArg reg : regs) {
                if (reg.isThis()) continue;
                return false;
            }
        }
        return true;
    }

    private static List<MethodNode> getConstructorsList(ClassNode cls) {
        ArrayList<MethodNode> list = new ArrayList<MethodNode>();
        for (MethodNode mth : cls.getMethods()) {
            AccessInfo accFlags = mth.getAccessFlags();
            if (accFlags.isStatic() || !accFlags.isConstructor()) continue;
            list.add(mth);
            if (!BlockUtils.isAllBlocksEmpty(mth.getBasicBlocks())) continue;
            return Collections.emptyList();
        }
        return list;
    }

    private static List<InsnNode> getFieldAssigns(MethodNode mth, FieldNode field, InsnType putInsn) {
        if (mth.isNoCode() || mth.getBasicBlocks() == null) {
            return Collections.emptyList();
        }
        ArrayList<InsnNode> assignInsns = new ArrayList<InsnNode>();
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                FieldInfo putNode;
                if (insn.getType() != putInsn || !(putNode = (FieldInfo)((IndexInsnNode)insn).getIndex()).equals(field.getFieldInfo())) continue;
                assignInsns.add(insn);
            }
        }
        return assignInsns;
    }

    private static void addFieldInitAttr(MethodNode classInitMth, FieldNode field, InsnNode insn) {
        InsnNode assignInsn = InsnNode.wrapArg(insn.getArg(0));
        field.addAttr(FieldInitAttr.insnValue(classInitMth, assignInsn));
    }

    private static class InitInfo {
        private final MethodNode constrMth;
        private final List<InsnNode> putInsns = new ArrayList<InsnNode>();

        private InitInfo(MethodNode constrMth) {
            this.constrMth = constrMth;
        }

        public MethodNode getConstrMth() {
            return this.constrMth;
        }

        public List<InsnNode> getPutInsns() {
            return this.putInsns;
        }
    }
}

