/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.mods;

import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.InsnUtils;
import java.util.Collection;

public final class TernaryInsn
extends InsnNode {
    private IfCondition condition;

    public TernaryInsn(IfCondition condition, RegisterArg result, InsnArg th, InsnArg els) {
        this();
        this.setResult(result);
        if (th.isFalse() && els.isTrue()) {
            this.condition = IfCondition.invert(condition);
            this.addArg(els);
            this.addArg(th);
        } else {
            this.condition = condition;
            this.addArg(th);
            this.addArg(els);
        }
    }

    private TernaryInsn() {
        super(InsnType.TERNARY, 2);
    }

    public IfCondition getCondition() {
        return this.condition;
    }

    public void simplifyCondition() {
        this.condition = IfCondition.simplify(this.condition);
        if (this.condition.getMode() == IfCondition.Mode.NOT) {
            this.invert();
        }
    }

    private void invert() {
        this.condition = IfCondition.invert(this.condition);
        InsnArg tmp = this.getArg(0);
        this.setArg(0, this.getArg(1));
        this.setArg(1, tmp);
    }

    @Override
    public void getRegisterArgs(Collection<RegisterArg> list) {
        super.getRegisterArgs(list);
        list.addAll(this.condition.getRegisterArgs());
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TernaryInsn) || !super.isSame(obj)) {
            return false;
        }
        TernaryInsn that = (TernaryInsn)obj;
        return this.condition.equals(that.condition);
    }

    @Override
    public InsnNode copy() {
        TernaryInsn copy = new TernaryInsn();
        copy.condition = this.condition;
        return this.copyCommonParams(copy);
    }

    @Override
    public void rebindArgs() {
        super.rebindArgs();
        for (RegisterArg reg : this.condition.getRegisterArgs()) {
            InsnNode parentInsn = reg.getParentInsn();
            if (parentInsn == null) continue;
            parentInsn.rebindArgs();
        }
    }

    @Override
    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": TERNARY" + this.getResult() + " = (" + this.condition + ") ? " + this.getArg(0) + " : " + this.getArg(1);
    }
}

