/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum ResourceType {
    CODE(".dex", ".jar", ".class"),
    XML(".xml"),
    ARSC(".arsc"),
    FONT(".ttf", ".otf"),
    IMG(".png", ".gif", ".jpg"),
    MEDIA(".mp3", ".wav"),
    LIB(".so"),
    MANIFEST(new String[0]),
    UNKNOWN(new String[0]);

    private final String[] exts;
    private static final Map<String, ResourceType> EXT_MAP;

    private ResourceType(String ... exts) {
        this.exts = exts;
    }

    public String[] getExts() {
        return this.exts;
    }

    public static ResourceType getFileType(String fileName) {
        String ext;
        ResourceType resType;
        int dot = fileName.lastIndexOf(46);
        if (dot != -1 && (resType = EXT_MAP.get(ext = fileName.substring(dot).toLowerCase(Locale.ROOT))) != null) {
            if (resType == XML && fileName.equals("AndroidManifest.xml")) {
                return MANIFEST;
            }
            return resType;
        }
        return UNKNOWN;
    }

    static {
        EXT_MAP = new HashMap<String, ResourceType>();
        for (ResourceType type : ResourceType.values()) {
            for (String ext : type.getExts()) {
                ResourceType prev = EXT_MAP.put(ext, type);
                if (prev == null) continue;
                throw new JadxRuntimeException("Duplicate extension in ResourceType: " + ext);
            }
        }
    }
}

