
/*!
 * Query DOM (m4q, https://metroui.org.ua)
 * Copyright 2012-2025 by Serhii Pimenov
 * Licensed under MIT
 */

"use strict";(()=>{var dt=["opacity","zIndex"];function pt(){return null}function mt(t){return typeof t=="string"||typeof t=="boolean"||typeof t=="number"}function N(t){return!!(t.offsetWidth||t.offsetHeight||t.getClientRects().length)}function gt(t){let e=getComputedStyle(t);return!N(t)||+e.opacity==0||t.hidden||e.visibility==="hidden"}function u(t){return t==null}function b(t){return t.replace(/-([a-z])/g,function(e,n){return n.toUpperCase()})}function C(t){let e;return!t||Object.prototype.toString.call(t)!=="[object Object]"?!1:(e=t.prototype!==void 0,e?e.constructor&&typeof e.constructor=="function":!0)}function H(t){for(let e in t)if(O(t,e))return!1;return!0}function P(t){return t instanceof Object&&"length"in t}function M(t,e){return e=e||" ",t.split(e).map(function(n){return(""+n).trim()}).filter(function(n){return n!==""})}function E(t,e){return e||(e=[0,""]),t=String(t),e[0]=parseFloat(t),e[1]=t.match(/[\d.\-+]*\s*(.*)/)[1]||"",e}function st(t,e){let n=/[+-]?\d*\.?\d+(?:\.\d+)?(?:[eE][+-]?\d+)?(%|px|pt|em|rem|in|cm|mm|ex|ch|pc|vw|vh|vmin|vmax|deg|rad|turn)?$/.exec(t);return typeof n[1]<"u"?n[1]:e}function tt(t,e,n){e=b(e),["scrollLeft","scrollTop"].indexOf(e)>-1?t[e]=parseInt(n):t.style[e]=isNaN(n)||dt.indexOf(""+e)>-1?n:n+"px"}function at(t){return t.nodeType===1||t.nodeType===9||!+t.nodeType}function yt(t){try{return JSON.parse(t)}catch{return t}}function wt(t,e,n){let o;return u(n)&&t.nodeType===1&&(o="data-"+e.replace(/[A-Z]/g,"-$&").toLowerCase(),n=t.getAttribute(o),typeof n=="string"?(n=yt(n),A.set(t,e,n)):n=void 0),n}function W(t){return typeof t!="string"?void 0:t.replace(/-/g,"").toLowerCase()}function O(t,e){return Object.prototype.hasOwnProperty.call(t,e)}function et(t){let e=t||globalThis.location.hostname;return e==="localhost"||e==="127.0.0.1"||e==="[::1]"||e===""||e.match(/^127(?:\.(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)){3}$/)!==null}function bt(){return"ontouchstart"in window||navigator.maxTouchPoints>0}function xt(t){let e=t||globalThis.location.hostname;return/(^localhost)|(^127\.)|(^192\.168\.)|(^10\.)|(^172\.1[6-9]\.)|(^172\.2\d\.)|(^172\.3[0-1]\.)|(^::1$)|(^[fF][cCdD])/.test(e)}var w=Element.prototype.matches,i=(t,e)=>new i.init(t,e);i.version="3.2.0";i.build_time="04.01.2025, 00:15:02";i.info=()=>console.info(`%c M4Q %c v${i.version} %c ${i.build_time} `,"color: white; font-weight: bold; background: #fd6a02","color: white; background: darkgreen","color: white; background: #0080fe;");i.fn=i.prototype=Object.create(Array.prototype);i.prototype.constructor=i;i.prototype.uid="";i.extend=i.fn.extend=function(){let t,e,n=arguments[0]||{},o=1,r=arguments.length;for(typeof n!="object"&&typeof n!="function"&&(n={}),o===r&&(n=this,o--);o<r;o++)if((t=arguments[o])!=null)for(e in t)O(t,e)&&(n[e]=t[e]);return n};i.assign=function(){let t,e,n=arguments[0]||{},o=1,r=arguments.length;for(typeof n!="object"&&typeof n!="function"&&(n={}),o===r&&(n=this,o--);o<r;o++)if((t=arguments[o])!=null)for(e in t)O(t,e)&&t[e]!==void 0&&(n[e]=t[e]);return n};(function(t){try{let f=new Blob([`
            var fakeIdToId = {};
            onmessage = function (event) {
                var data = event.data,
                    name = data.name,
                    fakeId = data.fakeId,
                    time;
                if(data.hasOwnProperty('time')) {
                    time = data.time;
                }
                switch (name) {
                    case 'setInterval':
                        fakeIdToId[fakeId] = setInterval(function () {
                            postMessage({fakeId: fakeId});
                        }, time);
                        break;
                    case 'clearInterval':
                        if (fakeIdToId.hasOwnProperty (fakeId)) {
                            clearInterval(fakeIdToId[fakeId]);
                            delete fakeIdToId[fakeId];
                        }
                        break;
                    case 'setTimeout':
                        fakeIdToId[fakeId] = setTimeout(function () {
                            postMessage({fakeId: fakeId});
                            if (fakeIdToId.hasOwnProperty (fakeId)) {
                                delete fakeIdToId[fakeId];
                            }
                        }, time);
                        break;
                    case 'clearTimeout':
                        if (fakeIdToId.hasOwnProperty (fakeId)) {
                            clearTimeout(fakeIdToId[fakeId]);
                            delete fakeIdToId[fakeId];
                        }
                        break;
                }
            }
        `]);t=window.URL.createObjectURL(f)}catch{}let e,n={},o=0,r=2147483647,s="";function a(){do o===r?o=0:o++;while(n.hasOwnProperty(o));return o}if(!(typeof Worker>"u"))try{e=new Worker(t),window.setInterval=function(f,c){let d=a();return n[d]={callback:f,parameters:Array.prototype.slice.call(arguments,2)},e.postMessage({name:"setInterval",fakeId:d,time:c}),d},window.clearInterval=function(f){n.hasOwnProperty(f)&&(delete n[f],e.postMessage({name:"clearInterval",fakeId:f}))},window.setTimeout=function(f,c){let d=a();return n[d]={callback:f,parameters:Array.prototype.slice.call(arguments,2),isTimeout:!0},e.postMessage({name:"setTimeout",fakeId:d,time:c}),d},window.clearTimeout=function(f){n.hasOwnProperty(f)&&(delete n[f],e.postMessage({name:"clearTimeout",fakeId:f}))},window.setImmediate=function(f){return setTimeout(f,0)},window.clearImmediate=function(f){clearTimeout(f)},e.onmessage=function(f){let c=f.data,d=c.fakeId,p,m,l;if(n.hasOwnProperty(d)&&(p=n[d],l=p.callback,m=p.parameters,p.hasOwnProperty("isTimeout")&&p.isTimeout&&delete n[d]),typeof l=="string")try{l=new Function(l)}catch(h){console.error(s+"Error parsing callback code string: ",h)}typeof l=="function"&&l.apply(window,m)},e.onerror=function(f){console.error(f)}}catch{console.log("Can't create worker for Intervals, use standard functions.")}})();i.fn.extend({index:function(t){let e,n=-1;return this.length===0||(u(t)?e=this[0]:t instanceof i&&t.length>0?e=t[0]:typeof t=="string"?e=i(t)[0]:e=void 0,u(e))||e&&e.parentNode&&i.each(e.parentNode.children,function(o){this===e&&(n=o)}),n},indexOf:function(t){let e,n=-1;return this.length===0||(u(t)?e=this[0]:t instanceof i&&t.length>0?e=t[0]:typeof t=="string"?e=i(t)[0]:e=void 0,u(e))||this.each(function(o){this===e&&(n=o)}),n},get:function(t){return t===void 0?this.items():t<0?this[t+this.length]:this[t]},eq:function(t){return!u(t)&&this.length>0?i.extend(i(this.get(t)),{_prevObj:this}):this},is:function(t){let e=!1;return this.length===0?!1:t instanceof i?this.same(t):(t===":selected"?this.each(function(){this.selected&&(e=!0)}):t===":checked"?this.each(function(){this.checked&&(e=!0)}):t===":visible"?this.each(function(){N(this)&&(e=!0)}):t===":hidden"?this.each(function(){let n=getComputedStyle(this);(this.getAttribute("type")==="hidden"||this.hidden||n.display==="none"||n.visibility==="hidden"||parseInt(n.opacity)===0)&&(e=!0)}):typeof t=="string"&&[":selected"].indexOf(t)===-1?this.each(function(){w.call(this,t)&&(e=!0)}):P(t)?this.each(function(){let n=this;i.each(t,function(){n===this&&(e=!0)})}):typeof t=="object"&&t.nodeType===1&&this.each(function(){this===t&&(e=!0)}),e)},same:function(t){let e=!0;return t instanceof i||(t=i(t)),this.length!==t.length?!1:(this.each(function(){t.items().indexOf(this)===-1&&(e=!1)}),e)},last:function(){return this.eq(this.length-1)},first:function(){return this.eq(0)},odd:function(){let t=this.filter(function(e,n){return n%2===0});return i.extend(t,{_prevObj:this})},even:function(){let t=this.filter(function(e,n){return n%2!==0});return i.extend(t,{_prevObj:this})},filter:function(t){if(typeof t=="string"){let e=t;t=function(n){return w.call(n,e)}}return i.extend(i.merge(i(),[].filter.call(this,t)),{_prevObj:this})},find:function(t){let e=[],n;return t instanceof i?t:(this.length===0?n=this:(this.each(function(){let o=this;typeof o.querySelectorAll>"u"||(e=e.concat([].slice.call(o.querySelectorAll(t))))}),n=i.merge(i(),e)),i.extend(n,{_prevObj:this}))},contains:function(t){return this.find(t).length>0},children:function(t){let e,n=[];return t instanceof i?t:(this.each(function(){let o=this;for(e=0;e<o.children.length;e++)o.children[e].nodeType===1&&n.push(o.children[e])}),n=t?n.filter(function(o){return w.call(o,t)}):n,i.extend(i.merge(i(),n),{_prevObj:this}))},parent:function(t){let e=[];if(this.length!==0)return t instanceof i?t:(this.each(function(){this.parentNode&&e.indexOf(this.parentNode)===-1&&e.push(this.parentNode)}),e=t?e.filter(function(n){return w.call(n,t)}):e,i.extend(i.merge(i(),e),{_prevObj:this}))},parents:function(t){let e=[];if(this.length!==0)return t instanceof i?t:(this.each(function(){let n=this.parentNode;for(;n;)n.nodeType===1&&e.indexOf(n)===-1&&(u(t)||w.call(n,t))&&e.push(n),n=n.parentNode}),i.extend(i.merge(i(),e),{_prevObj:this}))},siblings:function(t){let e=[];if(this.length!==0)return t instanceof i?t:(this.each(function(){let n=this;n.parentNode&&i.each(n.parentNode.children,function(){n!==this&&e.push(this)})}),t&&(e=e.filter(function(n){return w.call(n,t)})),i.extend(i.merge(i(),e),{_prevObj:this}))},_siblingAll:function(t,e){let n=[];if(this.length!==0)return e instanceof i?e:(this.each(function(){let o=this;for(;o&&(o=o[t],!!o);)n.push(o)}),e&&(n=n.filter(function(o){return w.call(o,e)})),i.extend(i.merge(i(),n),{_prevObj:this}))},_sibling:function(t,e){let n=[];if(this.length!==0)return e instanceof i?e:(this.each(function(){let o=this[t];o&&o.nodeType===1&&n.push(o)}),e&&(n=n.filter(function(o){return w.call(o,e)})),i.extend(i.merge(i(),n),{_prevObj:this}))},prev:function(t){return this._sibling("previousElementSibling",t)},next:function(t){return this._sibling("nextElementSibling",t)},prevAll:function(t){return this._siblingAll("previousElementSibling",t)},nextAll:function(t){return this._siblingAll("nextElementSibling",t)},closest:function(t){let e=[];if(this.length!==0)return t instanceof i?t:t?(this.each(function(){let n=this;for(;n&&n;){if(w.call(n,t)){e.push(n);return}n=n.parentElement}}),i.extend(i.merge(i(),e.reverse()),{_prevObj:this})):this.parent(t)},has:function(t){let e=[];if(this.length!==0)return this.each(function(){i(this).children(t).length>0&&e.push(this)}),i.extend(i.merge(i(),e),{_prevObj:this})},back:function(t){let e;if(t===!0)for(e=this._prevObj;e&&e._prevObj;)e=e._prevObj;else e=this._prevObj?this._prevObj:this;return e}});function nt(t,e=document.body){let n=document.createElement("script");if(n.type="text/javascript",u(t))return i(n);let o=i(t)[0];return o.src?n.src=o.src:n.textContent=o.innerText,o.type&&(n.type=o.type),o.async&&(n.async=o.async),e.appendChild(n),o.parentNode&&o.parentNode.removeChild(o),n}i.extend({script:function(t,e){if(!u(t))if(t instanceof i&&(t=t[0]),t.tagName&&t.tagName==="SCRIPT")nt(t,e);else{let n=i(t).find("script");i.each(n,function(){nt(this,e)})}}});i.fn.extend({script:function(){return this.each(function(){i.script(this)})}});i.fn.extend({_prop:function(t,e){return arguments.length===1?this.length===0?void 0:this[0][t]:(u(e)&&(e=""),this.each(function(){let n=this;n[t]=e,t==="innerHTML"&&i.script(n,n)}))},prop:function(t,e){return arguments.length===1?this._prop(t):this._prop(t,typeof e>"u"?"":e)},val:function(t){return u(t)?this.length===0?void 0:this[0].value:this.each(function(){let e=i(this);typeof this.value<"u"?this.value=t:e.html(t)})},html:function(t){let e=this,n=[];return arguments.length===0?this._prop("innerHTML"):(t instanceof i?t.each(function(){n.push(i(this).outerHTML())}):n.push(t),e._prop("innerHTML",n.join(`
`)),this)},outerHTML:function(){return this._prop("outerHTML")},text:function(t){return arguments.length===0?this._prop("textContent"):this._prop("textContent",typeof t>"u"?"":t)},innerText:function(t){return arguments.length===0?this._prop("innerText"):this._prop("innerText",typeof t>"u"?"":t)},empty:function(){return this.each(function(){typeof this.innerHTML<"u"&&(this.innerHTML="")})},clear:function(){return this.empty()}});i.each=function(t,e){let n=0;if(P(t))[].forEach.call(t,function(o,r){e.apply(o,[r,o])});else for(let o in t)O(t,o)&&e.apply(t[o],[o,t[o],n++]);return t};i.fn.extend({each:function(t){return i.each(this,t)}});var $=function(t){this.expando="DATASET:UID:"+t.toUpperCase(),$.uid++};$.uid=-1;$.prototype={cache:function(t){let e=t[this.expando];return e||(e={},at(t)&&(t.nodeType?t[this.expando]=e:Object.defineProperty(t,this.expando,{value:e,configurable:!0}))),e},set:function(t,e,n){let o,r=this.cache(t);if(typeof e=="string")r[b(e)]=n;else for(o in e)O(e,o)&&(r[b(o)]=e[o]);return r},get:function(t,e){return e===void 0?this.cache(t):t[this.expando]&&t[this.expando][b(e)]},access:function(t,e,n){return e===void 0||e&&typeof e=="string"&&n===void 0?this.get(t,e):(this.set(t,e,n),n!==void 0?n:e)},remove:function(t,e){let n,o=t[this.expando];if(o!==void 0){if(e!==void 0)for(Array.isArray(e)?e=e.map(b):(e=b(e),e=e in o?[e]:e.match(/[^\x20\t\r\n\f]+/g)||[]),n=e.length;n--;)delete o[e[n]];return(e===void 0||H(o))&&(t.nodeType?t[this.expando]=void 0:delete t[this.expando]),!0}},hasData:function(t){let e=t[this.expando];return e!==void 0&&!H(e)}};var A=new $("m4q");i.extend({hasData:function(t){return A.hasData(t)},data:function(t,e,n){return A.access(t,e,n)},removeData:function(t,e){return A.remove(t,e)},dataSet:function(t){if(u(t))return A;if(["INTERNAL","M4Q"].indexOf(t.toUpperCase())>-1)throw Error("You can not use reserved name for your dataset");return new $(t)}});i.fn.extend({data:function(t,e){let n,o,r,s,a,f;if(this.length!==0){if(o=this[0],arguments.length===0){if(this.length&&(r=A.get(o),o.nodeType===1))for(s=o.attributes,f=s.length;f--;)s[f]&&(a=s[f].name,a.indexOf("data-")===0&&(a=b(a.slice(5)),wt(o,a,r[a])));return r}return arguments.length===1?(n=A.get(o,t),n===void 0&&o.nodeType===1&&o.hasAttribute("data-"+t)&&(n=o.getAttribute("data-"+t)),n):this.each(function(){A.set(this,t,e)})}},removeData:function(t){return this.each(function(){A.remove(this,t)})},origin:function(t,e,n){if(this.length===0)return this;if(u(t)&&u(e))return i.data(this[0]);if(u(e)){let o=i.data(this[0],"origin-"+t);return u(o)?n:o}return this.data("origin-"+t,e),this}});i.extend({device:/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(navigator.userAgent.toLowerCase()),localhost:et(),isLocalhost:et,touchable:bt(),isPrivateAddress:xt,uniqueId:function(t){let e=new Date().getTime();return u(t)&&(t="m4q"),(t!==""?t+"-":"")+"xxxx-xxxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(n){let o=(e+Math.random()*16)%16|0;return e=Math.floor(e/16),(n==="x"?o:o&3|8).toString(16)})},toArray:function(t){let e,n=[];for(e=0;e<t.length;e++)n.push(t[e]);return n},import:function(t){let e=[];return this.each(t,function(){e.push(this)}),this.merge(i(),e)},merge:function(t,e){let n=+e.length,o=0,r=t.length;for(;o<n;o++)t[r++]=e[o];return t.length=r,t},type:function(t){return Object.prototype.toString.call(t).replace(/^\[object (.+)]$/,"$1").toLowerCase()},sleep:function(t){for(t+=new Date().getTime();new Date<t;);},isSelector:function(t){if(typeof t!="string")return!1;try{return document.querySelector(t),!0}catch{return!1}},remove:function(t){return i(t).remove()},isPlainObject:C,isEmptyObject:H,isArrayLike:P,acceptData:at,not:u,parseUnit:E,getUnit:st,unit:E,isVisible:N,isHidden:gt,matches:function(t,e){return w.call(t,e)},random:function(t,e){return arguments.length===1&&P(t)?t[Math.floor(Math.random()*t.length)]:Math.floor(Math.random()*(e-t+1)+t)},hasProp:O,dark:globalThis.matchMedia&&globalThis.matchMedia("(prefers-color-scheme: dark)").matches,serializeToArray:function(t){let e=i(t)[0];if(!e||e.nodeName!=="FORM"){console.warn("Element is not a HTMLFromElement");return}let n,o,r=[];for(n=e.elements.length-1;n>=0;n=n-1)if(e.elements[n].name!=="")switch(e.elements[n].nodeName){case"INPUT":switch(e.elements[n].type){case"checkbox":case"radio":e.elements[n].checked&&r.push(e.elements[n].name+"="+encodeURIComponent(e.elements[n].value));break;case"file":break;default:r.push(e.elements[n].name+"="+encodeURIComponent(e.elements[n].value))}break;case"TEXTAREA":r.push(e.elements[n].name+"="+encodeURIComponent(e.elements[n].value));break;case"SELECT":switch(e.elements[n].type){case"select-one":r.push(e.elements[n].name+"="+encodeURIComponent(e.elements[n].value));break;case"select-multiple":for(o=e.elements[n].options.length-1;o>=0;o=o-1)e.elements[n].options[o].selected&&r.push(e.elements[n].name+"="+encodeURIComponent(e.elements[n].options[o].value));break}break;case"BUTTON":switch(e.elements[n].type){case"reset":case"submit":case"button":r.push(e.elements[n].name+"="+encodeURIComponent(e.elements[n].value));break}break}return r},serialize:function(t){return i.serializeToArray(t).join("&")},viewport:function(){let t=window,e=document,n=e.documentElement,o=e.getElementsByTagName("body")[0],r=t.innerWidth||n.clientWidth||o.clientWidth,s=t.innerHeight||n.clientHeight||o.clientHeight;return{width:r,height:s}}});i.fn.extend({items:function(){return i.toArray(this)}});var It=Event.prototype.stopPropagation,Tt=Event.prototype.preventDefault;Event.prototype.stopPropagation=function(){this.isPropagationStopped=!0,It.apply(this,arguments)};Event.prototype.preventDefault=function(){this.isPreventedDefault=!0,Tt.apply(this,arguments)};Event.prototype.stop=function(t){return t?this.stopImmediatePropagation():this.stopPropagation()};i.extend({events:[],eventHooks:{},eventUID:-1,setEventHandler:function(t){let e,n=-1,o,r;if(this.events.length>0){for(e=0;e<this.events.length;e++)if(this.events[e].handler===null){n=e;break}}return o={element:t.el,event:t.event,handler:t.handler,selector:t.selector,ns:t.ns,id:t.id,options:t.options},n===-1?(this.events.push(o),r=this.events.length-1):(this.events[n]=o,r=n),r},getEventHandler:function(t){if(this.events[t]!==void 0&&this.events[t]!==null)return this.events[t]=null,this.events[t].handler},off:function(){return i.each(this.events,function(){this.element.removeEventListener(this.event,this.handler,!0)}),this.events=[],this},getEvents:function(){return this.events},getEventHooks:function(){return this.eventHooks},addEventHook:function(t,e,n){return u(n)&&(n="before"),i.each(M(t),function(){this.eventHooks[b(n+"-"+this)]=e}),this},removeEventHook:function(t,e){return u(e)&&(e="before"),i.each(M(t),function(){delete this.eventHooks[b(e+"-"+this)]}),this},removeEventHooks:function(t){let e=this;return u(t)?this.eventHooks={}:i.each(M(t),function(){delete e.eventHooks[b("before-"+this)],delete e.eventHooks[b("after-"+this)]}),this}});i.fn.extend({on:function(t,e,n,o){if(this.length!==0)return typeof e=="function"&&(o=n,n=e,e=void 0),C(o)||(o={}),this.each(function(){let r=this;i.each(M(t),function(){let s,a=this,f=a.split("."),c=W(f[0]),d=o.ns?o.ns:f[1],p,m;i.eventUID++,s=function(l){let h=l.target,x=i.eventHooks[b("before-"+c)],g=i.eventHooks[b("after-"+c)];if(typeof x=="function"&&x.call(h,l),!e)n.call(r,l);else for(;h&&h!==r;){if(w.call(h,e)&&(n.call(h,l),l.isPropagationStopped)){l.stopImmediatePropagation();break}h=h.parentNode}typeof g=="function"&&g.call(h,l),o.once&&(p=+i(r).origin("event-"+l.type+(e?":"+e:"")+(d?":"+d:"")),isNaN(p)||i.events.splice(p,1))},Object.defineProperty(s,"name",{value:n.name&&n.name!==""?n.name:"func_event_"+c+"_"+i.eventUID}),m=c+(e?":"+e:"")+(d?":"+d:""),r.addEventListener(c,s,H(o)?!1:o),p=i.setEventHandler({el:r,event:c,handler:s,selector:e,ns:d,id:i.eventUID,options:H(o)?!1:o}),i(r).origin("event-"+m,p)})})},one:function(t,e,n,o){return C(o)||(o={}),o.once=!0,this.on.apply(this,[t,e,n,o])},off:function(t,e,n){return C(e)&&(n=e,e=null),C(n)||(n={}),u(t)||t.toLowerCase()==="all"?this.each(function(){let o=this;i.each(i.events,function(){let r=this;r.element===o&&(o.removeEventListener(r.event,r.handler,r.options),r.handler=null,i(o).origin("event-"+name+(r.selector?":"+r.selector:"")+(r.ns?":"+r.ns:""),null))})}):this.each(function(){let o=this;i.each(M(t),function(){let r=this.split("."),s=W(r[0]),a=n.ns?n.ns:r[1],f,c;f="event-"+s+(e?":"+e:"")+(a?":"+a:""),c=i(o).origin(f),c!==void 0&&i.events[c].handler&&(o.removeEventListener(s,i.events[c].handler,i.events[c].options),i.events[c].handler=null),i(o).origin(f,null)})})},trigger:function(t,e){return this.fire(t,e)},fire:function(t,e){let n,o;if(this.length!==0)return n=W(t),["focus","blur"].indexOf(n)>-1?(this[0][n](),this):(o=new CustomEvent(n,{bubbles:!0,cancelable:!0,detail:e}),this.each(function(){this.dispatchEvent(o)}))}});"blur focus resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu touchstart touchend touchmove touchcancel".split(" ").forEach(function(t){i.fn[t]=function(e,n,o){return arguments.length>0?this.on(t,e,n,o):this.fire(t)}});i.fn.extend({hover:function(t,e){return this.mouseenter(t).mouseleave(e||t)}});i.ready=function(t,e){document.addEventListener("DOMContentLoaded",t,e||!1)};i.load=function(t){return i(window).on("load",t)};i.unload=function(t){return i(window).on("unload",t)};i.fn.extend({unload:function(t){return this.length===0||this[0].self!==window?void 0:i.unload(t)}});i.beforeunload=function(t){return typeof t=="string"?i(window).on("beforeunload",function(e){return e.returnValue=t,t}):i(window).on("beforeunload",t)};i.fn.extend({beforeunload:function(t){return this.length===0||this[0].self!==window?void 0:i.beforeunload(t)}});i.fn.extend({ready:function(t){if(this.length&&this[0]===document&&typeof t=="function")return i.ready(t)}});i.ajax=function(t){return new Promise(function(e,n){let o=new XMLHttpRequest,r=(t.method||"GET").toUpperCase(),s=[],a=u(t.async)?!0:t.async,f=t.url,c,d=function(l,h){typeof l=="function"&&l.apply(null,h)},p=function(l){return["GET","JSON"].indexOf(l)!==-1},m=function(l){let h=[];return i.each(l,function(x,g){let j=mt(g)?g:JSON.stringify(g);h.push(x+"="+j)}),h.join("&")};if(t.data instanceof HTMLFormElement){let l=t.data.getAttribute("action").trim(),h=t.data.getAttribute("method").trim();u(f)&&l&&(f=l),h&&(r=h.toUpperCase())}if(t.timeout&&(o.timeout=t.timeout),t.withCredentials&&(o.withCredentials=t.withCredentials),t.data instanceof HTMLFormElement)c=i.serialize(t.data);else if(t.data instanceof HTMLElement&&t.data.getAttribute("type")&&t.data.getAttribute("type").toLowerCase()==="file"){let l=t.data.getAttribute("name");c=new FormData;for(let h=0;h<t.data.files.length;h++)c.append(l,t.data.files[h])}else C(t.data)?c=m(t.data):t.data instanceof FormData||typeof t.data=="string"?c=t.data:(c=new FormData,c.append("_data",JSON.stringify(t.data)));p(r)&&(f+=typeof c=="string"?"?"+c:H(c)?"":"?"+JSON.stringify(c)),o.open(r,f,a,t.user,t.password),t.headers&&i.each(t.headers,function(l,h){o.setRequestHeader(l,h),s.push(l)}),p(r)||s.indexOf("Content-type")===-1&&t.contentType!==!1&&o.setRequestHeader("Content-type","application/x-www-form-urlencoded"),o.send(c),o.addEventListener("load",function(l){if(o.readyState===4&&o.status<300){let h=t.returnValue&&t.returnValue==="xhr"?o:o.response;if(t.parseJson)try{h=JSON.parse(h)}catch{h={}}d(e,[h]),d(t.onSuccess,[l,o])}else d(n,[o]),d(t.onFail,[l,o]);d(t.onLoad,[l,o])}),i.each(["readystatechange","error","timeout","progress","loadstart","loadend","abort"],function(){let l=b("on-"+(this==="readystatechange"?"state":this));o.addEventListener(l,function(h){d(t[l],[h,o])})})})};["GET","POST","PUT","PATCH","DELETE","JSON"].forEach(function(t){i[t.toLowerCase()]=function(e,n,o){let r={method:t==="JSON"?"GET":t,url:e,data:n,parseJson:t==="JSON"};return i.ajax(i.extend({},r,o))}});i.fn.extend({load:function(t,e,n){let o=this;return this.length&&this[0].self===window?i.load(t):i.get(t,e,n).then(function(r){o.each(function(){this.innerHTML=r})})}});i.fn.extend({style:function(t,e){let n;function o(r,s,a){return["scrollLeft","scrollTop"].indexOf(s)>-1?i(r)[s]():getComputedStyle(r,a)[s]}if(!(typeof t=="string"&&this.length===0)){if(this.length===0)return this;if(n=this[0],u(t)||t==="all")return getComputedStyle(n,e);{let r={},s=t.split(", ").map(function(a){return(""+a).trim()});return s.length===1?o(n,s[0],e):(i.each(s,function(){let a=this;r[this]=o(n,a,e)}),r)}}},removeStyleProperty:function(t){if(u(t)||this.length===0)return this;let e=t.split(", ").map(function(n){return(""+n).trim()});return this.each(function(){let n=this;i.each(e,function(){n.style.removeProperty(this)})})},css:function(t,e){return t=t||"all",typeof t=="string"&&u(e)?this.style(t):this.each(function(){let n=this;typeof t=="object"?i.each(t,function(o,r){tt(n,o,r)}):typeof t=="string"&&tt(n,t,e)})},scrollTop:function(t){return u(t)?this.length===0?void 0:this[0]===window?scrollY:this[0].scrollTop:this.each(function(){this.scrollTop=t})},scrollLeft:function(t){return u(t)?this.length===0?void 0:this[0]===window?scrollX:this[0].scrollLeft:this.each(function(){this.scrollLeft=t})}});i.fn.extend({addClass:function(){},removeClass:function(){},toggleClass:function(){},containsClass:function(t){return this.hasClass(t)},hasClass:function(t){let e=!1,n=t.split(" ").filter(function(o){return(""+o).trim()!==""});return u(t)?!1:(this.each(function(){let o=this;i.each(n,function(){!e&&o.classList&&o.classList.contains(this)&&(e=!0)})}),e)},clearClasses:function(){return this.each(function(){this.className=""})},cls:function(t){return this.length===0?void 0:t?this[0].className.split(" "):this[0].className},removeClassBy:function(t){return this.each(function(){let e=i(this),n=e.cls(!0);i.each(n,function(){let o=this;o.indexOf(t)>-1&&e.removeClass(o)})})},classNames:function(){let t=Array.prototype.slice.call(arguments,0),e=[];return i.each(t,function(n,o){typeof o=="string"?e.push(o):C(o)?i.each(o,function(r,s){s&&e.push(r)}):pt()}),this.each(function(){this.className+=" "+e.join(" ")})}});["add","remove","toggle"].forEach(function(t){i.fn[t+"Class"]=function(e){let n=e?Array.isArray(e)?e:e.split(" ").filter(function(o){return!!o}):[];return n.length?this.each(function(){let o=this;typeof o.classList<"u"?i.each(n,function(s,a){o.classList[t](a)}):o.className+=n.join(" ")}):this}});i.parseHTML=function(t){let e,n,o=[],r,s,a=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;if(typeof t!="string")return[];if(t=t.trim(),r=document.implementation.createHTMLDocument(""),e=r.createElement("base"),e.href=document.location.href,r.head.appendChild(e),s=r.body,n=a.exec(t),n)o.push(document.createElement(n[1]));else{s.innerHTML=t;for(let f=0;f<s.childNodes.length;f++)o.push(s.childNodes[f])}return o};i.fn.extend({_size:function(t,e){if(this.length!==0){if(u(e)){let n=this[0];if(t==="height")return n===window?window.innerHeight:n===document?n.body.clientHeight:parseInt(getComputedStyle(n).height);if(t==="width")return n===window?window.innerWidth:n===document?n.body.clientWidth:parseInt(getComputedStyle(n).width)}return this.each(function(){let n=this;n===window||n===document||(n.style[t]=isNaN(e)?e:e+"px")})}},height:function(t){return this._size("height",t)},width:function(t){return this._size("width",t)},_sizeOut:function(t,e){let n,o,r,s;if(this.length!==0)return!u(e)&&typeof e!="boolean"?this.each(function(){let a=this;if(a===window||a===document)return;let f,c=getComputedStyle(a),d=t==="width"?parseInt(c["border-left-width"])+parseInt(c["border-right-width"]):parseInt(c["border-top-width"])+parseInt(c["border-bottom-width"]),p=t==="width"?parseInt(c["padding-left"])+parseInt(c["padding-right"]):parseInt(c["padding-top"])+parseInt(c["padding-bottom"]);f=i(this)[t](e)[t]()-d-p,a.style[t]=f+"px"}):(n=this[0],o=n[t==="width"?"offsetWidth":"offsetHeight"],r=getComputedStyle(n),s=o+parseInt(r[t==="width"?"margin-left":"margin-top"])+parseInt(r[t==="width"?"margin-right":"margin-bottom"]),e===!0?s:o)},outerWidth:function(t){return this._sizeOut("width",t)},outerHeight:function(t){return this._sizeOut("height",t)},padding:function(t){if(this.length===0)return;let e=getComputedStyle(this[0],t);return{top:parseInt(e["padding-top"]),right:parseInt(e["padding-right"]),bottom:parseInt(e["padding-bottom"]),left:parseInt(e["padding-left"])}},margin:function(t){if(this.length===0)return;let e=getComputedStyle(this[0],t);return{top:parseInt(e["margin-top"]),right:parseInt(e["margin-right"]),bottom:parseInt(e["margin-bottom"]),left:parseInt(e["margin-left"])}},border:function(t){if(this.length===0)return;let e=getComputedStyle(this[0],t);return{top:parseInt(e["border-top-width"]),right:parseInt(e["border-right-width"]),bottom:parseInt(e["border-bottom-width"]),left:parseInt(e["border-left-width"])}}});i.fn.extend({offset:function(t){let e;return u(t)?this.length===0?void 0:(e=this[0].getBoundingClientRect(),{top:e.top+scrollY,left:e.left+scrollX}):this.each(function(){let n=i(this),o=t.top,r=t.left,s=getComputedStyle(this).position,a=n.offset();s==="static"&&n.css("position","relative"),["absolute","fixed"].indexOf(s)===-1&&(o=o-a.top,r=r-a.left),n.css({top:o,left:r})})},position:function(t){let e=0,n=0,o,r;if((u(t)||typeof t!="boolean")&&(t=!1),this.length!==0)return o=this[0],r=getComputedStyle(o),t&&(e=parseInt(r["margin-left"]),n=parseInt(r["margin-top"])),{left:o.offsetLeft-e,top:o.offsetTop-n}},left:function(t,e){if(this.length!==0)return u(t)?this.position(e).left:typeof t=="boolean"?(e=t,this.position(e).left):this.each(function(){i(this).css({left:t})})},top:function(t,e){if(this.length!==0)return u(t)?this.position(e).top:typeof t=="boolean"?(e=t,this.position(e).top):this.each(function(){i(this).css({top:t})})},coord:function(){return this.length===0?void 0:this[0].getBoundingClientRect()},pos:function(){if(this.length!==0)return{top:parseInt(i(this[0]).style("top")),left:parseInt(i(this[0]).style("left"))}}});i.fn.extend({attr:function(t,e){let n={};if(!(this.length===0&&arguments.length===0))return this.length&&arguments.length===0?(i.each(this[0].attributes,function(){n[this.nodeName]=this.nodeValue}),n):arguments.length===1&&typeof t=="string"?this.length&&this[0].nodeType===1&&this[0].hasAttribute(t)?this[0].getAttribute(t):void 0:this.each(function(){let o=this;C(t)?i.each(t,function(r,s){o.setAttribute(r,s)}):o.setAttribute(t,e)})},removeAttr:function(t){let e;return u(t)?this.each(function(){let n=this;i.each(this.attributes,function(){n.removeAttribute(this)})}):(e=typeof t=="string"?t.split(",").map(function(n){return n.trim()}):t,this.each(function(){let n=this;i.each(e,function(){n.hasAttribute(this)&&n.removeAttribute(this)})}))},toggleAttr:function(t,e){return this.each(function(){let n=this;u(e)?n.removeAttribute(t):n.setAttribute(t,e)})},id:function(t){return typeof t>"u"?this.length===1?i(this[0]).attr("id"):this.map(e=>i(e).attr("id")):this.each(function(){i(this).attr("id",t)})}});i.extend({meta:function(t){return u(t)?i("meta"):i("meta[name='$name']".replace("$name",t))},metaBy:function(t){return u(t)?i("meta"):i("meta[$name]".replace("$name",t))},doctype:function(){return i("doctype")},html:function(){return i("html")},head:function(){return i("html").find("head")},body:function(){return i("body")},document:function(){return i(document)},window:function(){return i(window)},charset:function(t){if(t){let e=i("meta[charset]");e.length>0&&e.attr("charset",t)}return document.characterSet}});i.extend({bind:(t,e)=>t.bind(e)});(function(t){t.forEach(function(e){["append","prepend"].forEach(function(n){O(e,n)||Object.defineProperty(e,n,{configurable:!0,enumerable:!0,writable:!0,value:function(){let o=Array.prototype.slice.call(arguments),r=document.createDocumentFragment();o.forEach(function(s){let a=s instanceof Node;r.appendChild(a?s:document.createTextNode(String(s)))}),n==="prepend"?this.insertBefore(r,this.firstChild):this.appendChild(r)}})})})})([Element.prototype,Document.prototype,DocumentFragment.prototype]);var v=function(t){let e;return typeof t=="string"?e=i.isSelector(t)?i(t):i.parseHTML(t):t instanceof HTMLElement?e=[t]:P(t)&&(e=t),e};i.fn.extend({appendText:function(t){return this.each(function(e,n){n.innerHTML+=t})},prependText:function(t){return this.each(function(e,n){n.innerHTML=t+n.innerHTML})},append:function(t){let e=v(t);return this.each(function(n,o){i.each(e,function(){if(o===this)return;let r=n===0?this:this.cloneNode(!0);r.tagName&&r.tagName==="SCRIPT"?i.script(r,o):o.append(r)})})},appendTo:function(t){let e=v(t);return this.each(function(){let n=this;i.each(e,function(o,r){n!==this&&r.append(o===0?n:n.cloneNode(!0))})})},prepend:function(t){let e=v(t);return this.each(function(n,o){i.each(e,function(){if(o===this)return;let r=n===0?this:this.cloneNode(!0);i.script(r),r.tagName&&r.tagName!=="SCRIPT"&&o.prepend(r)})})},prependTo:function(t){let e=v(t);return this.each(function(){let n=this;i.each(e,function(o,r){n!==this&&i(r).prepend(o===0?n:n.cloneNode(!0))})})},insertBefore:function(t){let e=v(t);return this.each(function(){let n=this;i.each(e,function(o){if(n===this)return;let r=this.parentNode;r&&r.insertBefore(o===0?n:n.cloneNode(!0),this)})})},insertAfter:function(t){let e=v(t);return this.each(function(){let n=this;i.each(e,function(o,r){if(n===this)return;let s=this.parentNode;s&&s.insertBefore(o===0?n:n.cloneNode(!0),r.nextSibling)})})},after:function(t){return this.each(function(){let e=this;typeof t=="string"?e.insertAdjacentHTML("afterend",t):i(t).insertAfter(e)})},before:function(t){return this.each(function(){let e=this;typeof t=="string"?e.insertAdjacentHTML("beforebegin",t):i(t).insertBefore(e)})},clone:function(t,e){let n=[];return u(t)&&(t=!1),u(e)&&(e=!1),this.each(function(){let o=this.cloneNode(t),r=i(o),s;e&&i.hasData(this)&&(s=i(this).data(),i.each(s,function(a,f){r.data(a,f)})),n.push(o)}),i.merge(i(),n)},import:function(t){let e=[];return u(t)&&(t=!1),this.each(function(){e.push(document.importNode(this,t))}),i.merge(i(),e)},adopt:function(){let t=[];return this.each(function(){t.push(document.adoptNode(this))}),i.merge(i(),t)},remove:function(t){let e=0,n,o,r=[];if(this.length!==0){for(o=t?this.filter(function(s){return w.call(s,t)}):this.items();(n=o[e])!=null;e++)n.parentNode&&(r.push(n.parentNode.removeChild(n)),i.removeData(n));return i.merge(i(),r)}},wrap:function(t){if(this.length===0)return;let e=i(v(t));if(!e.length)return;let n=[];return this.each(function(){let o,r;for(r=e.clone(!0,!0),r.insertBefore(this),o=r;o.children().length;)o=o.children().eq(0);o.append(this),n.push(r)}),i(n)},wrapAll:function(t){let e,n,o;if(this.length!==0&&(e=i(v(t)),!!e.length)){for(n=e.clone(!0,!0),n.insertBefore(this[0]),o=n;o.children().length;)o=o.children().eq(0);return this.each(function(){o.append(this)}),n}},wrapInner:function(t){if(this.length===0)return;let e=i(v(t));if(!e.length)return;let n=[];return this.each(function(){let o=i(this),r=o.html(),s=e.clone(!0,!0);o.html(s.html(r)),n.push(s)}),i(n)}});i.extend({animation:{duration:1e3,ease:"linear",elements:{}}});typeof window.setupAnimation=="object"&&i.each(window.setupAnimation,function(t,e){typeof i.animation[t]<"u"&&!u(e)&&(i.animation[t]=e)});var vt=["translateX","translateY","translateZ","rotate","rotateX","rotateY","rotateZ","scale","scaleX","scaleY","scaleZ","skew","skewX","skewY"],Ct=["opacity","zIndex"],At=["opacity","volume"],Ot=["scrollLeft","scrollTop"],Et=["opacity","volume"];function ft(t){return t instanceof HTMLElement||t instanceof SVGElement}function _t(t,e){let n=/^(\*=|\+=|-=)/.exec(t);if(!n)return t;let o=st(t)||0,r=parseFloat(e),s=parseFloat(t.replace(n[0],""));switch(n[0][0]){case"+":return r+s+o;case"-":return r-s+o;case"*":return r*s+o;case"/":return r/s+o}}function St(t,e,n){return typeof t[e]<"u"?Ot.indexOf(e)>-1?e==="scrollLeft"?t===window?scrollX:t.scrollLeft:t===window?scrollY:t.scrollTop:t[e]||0:t.style[e]||getComputedStyle(t,n)[e]}function Lt(t,e,n,o,r){u(r)&&(r=!1),e=b(e),r&&(n=parseInt(n)),ft(t)?typeof t[e]<"u"?t[e]=n:t.style[e]=e==="transform"||e.toLowerCase().indexOf("color")>-1?n:n+o:t[e]=n}function Nt(t,e,n){i.each(e,function(o,r){Lt(t,o,r[0]+r[2]*n,r[3],r[4])})}function ut(t){if(!ft(t))return{};let e=t.style.transform||"",n=/(\w+)\(([^)]*)\)/g,o={},r;for(;r=n.exec(e);)o[r[1]]=r[2];return o}function V(t){return/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(t||"#000000").slice(1).map(function(n){return parseInt(n,16)})}function Mt(t,e){return getComputedStyle(t)[e].replace(/[^\d.,]/g,"").split(",").map(function(n){return parseInt(n)})}function Ht(t,e,n){let o=[],r=ut(t);i.each(e,function(s,a){let f=a[0],c=a[1],d=a[2],p=a[3];s=""+s,(s.indexOf("rotate")>-1||s.indexOf("skew")>-1)&&p===""&&(p="deg"),s.indexOf("scale")>-1&&(p=""),s.indexOf("translate")>-1&&p===""&&(p="px"),p==="turn"?o.push(s+"("+c*n+p+")"):o.push(s+"("+(f+d*n)+p+")")}),i.each(r,function(s,a){e[s]===void 0&&o.push(s+"("+a+")")}),t.style.transform=o.join(" ")}function Pt(t,e,n){i.each(e,function(o,r){let s,a=[0,0,0],f;for(s=0;s<3;s++)a[s]=Math.floor(r[0][s]+r[2][s]*n);f="rgb("+a.join(",")+")",t.style[o]=f})}function it(t){let e=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;return t[0]==="#"&&t.length===4?"#"+t.replace(e,function(n,o,r,s){return o+o+r+r+s+s}):t[0]==="#"?t:"#"+t}function ot(t,e,n){Nt(t,e.props,n),Ht(t,e.transform,n),Pt(t,e.color,n)}function jt(t,e,n){let o={props:{},transform:{},color:{}},r,s,a,f,c,d,p=ut(t);return u(n)&&(n="normal"),i.each(e,function(m,l){let h=vt.indexOf(""+m)>-1,x=Ct.indexOf(""+m)>-1,g=(""+m).toLowerCase().indexOf("color")>-1;if(Array.isArray(l)&&l.length===1&&(l=l[0]),Array.isArray(l)?(s=g?V(it(l[0])):E(l[0]),a=g?V(it(l[1])):E(l[1])):(h?s=p[m]||m==="scale"?1:0:g?s=Mt(t,m):s=St(t,m,void 0),s=g?s:E(s),a=g?V(l):E(_t(l,Array.isArray(s)?s[0]:s))),Et.indexOf(""+m)>-1&&s[0]===a[0]&&(s[0]=a[0]>0?0:1),n==="reverse"&&(d=s,s=a,a=d),c=t instanceof HTMLElement&&a[1]===""&&!x&&!h?"px":a[1],g)for(f=[0,0,0],r=0;r<3;r++)f[r]=a[r]-s[r];else f=a[0]-s[0];h?o.transform[m]=[s[0],a[0],f,c]:g?o.color[m]=[s,a,f,c]:o.props[m]=[s[0],a[0],f,c,At.indexOf(""+m)===-1]}),o}function rt(t,e,n){return Math.min(Math.max(t,e),n)}var T={linear:function(){return function(t){return t}}};T.default=T.linear;var X={Sine:function(){return function(t){return 1-Math.cos(t*Math.PI/2)}},Circ:function(){return function(t){return 1-Math.sqrt(1-t*t)}},Back:function(){return function(t){return t*t*(3*t-2)}},Bounce:function(){return function(t){let e,n=4;for(;t<((e=Math.pow(2,--n))-1)/11;);return 1/Math.pow(4,3-n)-7.5625*Math.pow((e*3-2)/22-t,2)}},Elastic:function(t,e){u(t)&&(t=1),u(e)&&(e=.5);let n=rt(t,1,10),o=rt(e,.1,2);return function(r){return r===0||r===1?r:-n*Math.pow(2,10*(r-1))*Math.sin((r-1-o/(Math.PI*2)*Math.asin(1/n))*(Math.PI*2)/o)}}};["Quad","Cubic","Quart","Quint","Expo"].forEach(function(t,e){X[t]=function(){return function(n){return Math.pow(n,e+2)}}});Object.keys(X).forEach(function(t){let e=X[t];T["easeIn"+t]=e,T["easeOut"+t]=function(n,o){return function(r){return 1-e(n,o)(1-r)}},T["easeInOut"+t]=function(n,o){return function(r){return r<.5?e(n,o)(r*2)/2:1-e(n,o)(r*-2+2)/2}}});var Dt={id:null,el:null,draw:{},dur:i.animation.duration,ease:i.animation.ease,loop:0,pause:0,dir:"normal",defer:0,onStart:function(){},onStop:function(){},onStopAll:function(){},onPause:function(){},onPauseAll:function(){},onResume:function(){},onResumeAll:function(){},onFrame:function(){},onDone:function(){}};function Y(t){return new Promise(function(e){let n=this,o=i.assign({},Dt,{dur:i.animation.duration,ease:i.animation.ease},t),r=o.id,s=o.el,a=o.draw,f=o.dur,c=o.ease,d=o.loop,p=o.onStart,m=o.onFrame,l=o.onDone,h=o.pause,x=o.dir,g=o.defer,j={},G="linear",Q=[],U=T.linear,q,D=x==="alternate"?"normal":x,Z=!1,y=r||+(performance.now()*Math.pow(10,14));if(u(s))throw new Error("Unknown element!");if(typeof s=="string"&&(s=document.querySelector(s)),typeof a!="function"&&typeof a!="object")throw new Error("Unknown draw object. Must be a function or object!");f===0&&(f=1),x==="alternate"&&typeof d=="number"&&(d*=2),typeof c=="string"?(q=/\(([^)]+)\)/.exec(c),G=c.split("(")[0],Q=q?q[1].split(",").map(function(R){return parseFloat(R)}):[],U=T[G]||T.linear):typeof c=="function"?U=c:U=T.linear,i.animation.elements[y]={element:s,id:null,stop:0,pause:0,loop:0,t:-1,started:0,paused:0};let k=function(){typeof a=="object"&&(j=jt(s,a,D)),typeof p=="function"&&p.apply(s),i.animation.elements[y].loop+=1,i.animation.elements[y].started=performance.now(),i.animation.elements[y].duration=f,i.animation.elements[y].id=requestAnimationFrame(B)},z=function(){cancelAnimationFrame(i.animation.elements[y].id),delete i.animation.elements[r],typeof l=="function"&&l.apply(s),e(n)},B=function(R){let F,I,{stop:K,pause:ht,started:J}=i.animation.elements[y];if(i.animation.elements[y].paused&&(J=R-i.animation.elements[y].t*f,i.animation.elements[y].started=J),I=((R-J)/f).toFixed(4),I>1&&(I=1),I<0&&(I=0),F=U.apply(null,Q)(I),i.animation.elements[y].t=I,i.animation.elements[y].p=F,ht){i.animation.elements[y].id=requestAnimationFrame(B);return}if(K>0){K===2&&(typeof a=="function"?a.bind(s)(1,1):ot(s,j,1)),z();return}typeof a=="function"?a.bind(s)(I,F):ot(s,j,F),typeof m=="function"&&m.apply(s,[I,F]),I<1&&(i.animation.elements[y].id=requestAnimationFrame(B)),parseInt(I)===1&&(d?(x==="alternate"&&(D=D==="normal"?"reverse":"normal"),typeof d=="boolean"?setTimeout(function(){k()},h):d>i.animation.elements[y].loop?setTimeout(function(){k()},h):z()):x==="alternate"&&!Z?(D=D==="normal"?"reverse":"normal",Z=!0,k()):z())};g>0?setTimeout(function(){k()},g):k()})}function _(t,e){let n=i.animation.elements[t];typeof n>"u"||(u(e)&&(e=!0),n.stop=e===!0?2:1,typeof n.onStop=="function"&&n.onStop.apply(n.element))}function kt(t,e){i.each(i.animation.elements,function(n,o){e?typeof e=="string"?w.call(o.element,e)&&_(n,t):e.length?i.each(e,function(){o.element===this&&_(n,t)}):e instanceof Element&&o.element===e&&_(n,t):_(n,t)})}function S(t){let e=i.animation.elements[t];typeof e>"u"||(e.pause=1,e.paused=performance.now(),typeof e.onPause=="function"&&e.onPause.apply(e.element))}function Ft(t){i.each(i.animation.elements,function(e,n){t?typeof t=="string"?w.call(n.element,t)&&S(e):t.length?i.each(t,function(){n.element===this&&S(e)}):t instanceof Element&&n.element===t&&S(e):S(e)})}function L(t){let e=i.animation.elements[t];typeof e>"u"||(e.pause=0,e.paused=0,typeof e.onResume=="function"&&e.onResume.apply(e.element))}function $t(t){i.each(i.animation.elements,function(e,n){t?typeof t=="string"?w.call(n.element,t)&&L(e):t.length?i.each(t,function(){n.element===this&&L(e)}):t instanceof Element&&n.element===t&&L(e):L(e)})}var Ut={loop:!1,onChainItem:null,onChainItemComplete:null,onChainComplete:null};function ct(t,e){let n=i.extend({},Ut,e);if(typeof n.loop!="boolean"&&n.loop--,!Array.isArray(t))return console.warn("Chain array is not defined!"),!1;let o=function(r,s){return r.then(function(){return typeof n.onChainItem=="function"&&n.onChainItem(s),Y(s).then(function(){typeof n.onChainItemComplete=="function"&&n.onChainItemComplete(s)})})};t.reduce(o,Promise.resolve()).then(function(){typeof n.onChainComplete=="function"&&n.onChainComplete(),n.loop&&ct(t,n)})}i.easing={};i.extend(i.easing,T);i.extend({animate:function(t){let e,n,o,r,s;return arguments.length>1?(e=i(arguments[0])[0],n=arguments[1],o=arguments[2]||i.animation.duration,r=arguments[3]||i.animation.ease,s=arguments[4],typeof o=="function"&&(s=o,r=i.animation.ease,o=i.animation.duration),typeof r=="function"&&(s=r,r=i.animation.ease),Y({el:e,draw:n,dur:o,ease:r,onDone:s})):Y(t)},chain:ct,stop:_,stopAll:kt,resume:L,resumeAll:$t,pause:S,pauseAll:Ft});i.fn.extend({animate:function(t){let e=this,n,o,r,s,a=t,f;return f=!Array.isArray(t)&&(arguments.length>1||arguments.length===1&&typeof arguments[0].draw>"u"),f?(n=arguments[0],o=arguments[1]||i.animation.duration,r=arguments[2]||i.animation.ease,s=arguments[3],typeof o=="function"&&(s=o,o=i.animation.duration,r=i.animation.ease),typeof r=="function"&&(s=r,r=i.animation.ease),this.each(function(){return i.animate({el:this,draw:n,dur:o,ease:r,onDone:s})})):Array.isArray(t)?(i.each(t,function(){let c=this;e.each(function(){c.el=this,i.animate(c)})}),this):this.each(function(){a.el=this,i.animate(a)})},chain:function(t,e){return this.each(function(){let n=this;i.each(t,function(){this.el=n}),i.chain(t,e)})},stop:function(t){return this.each(function(){let e=this;i.each(i.animation.elements,function(n,o){o.element===e&&_(n,t)})})},pause:function(){return this.each(function(){let t=this;i.each(i.animation.elements,function(e,n){n.element===t&&S(e)})})},resume:function(){return this.each(function(){let t=this;i.each(i.animation.elements,function(e,n){n.element===t&&L(e)})})}});i.extend({hidden:function(t,e,n){return t=i(t)[0],typeof e=="string"&&(e=e.toLowerCase()==="true"),typeof e=="function"&&(n=e,e=!t.hidden),t.hidden=e,typeof n=="function"&&(i.bind(n,t),n.call(t,arguments)),this},hide:function(t,e){let n=i(t);t=n[0];let o=t.style.display,r=getComputedStyle(t,null).display;return n.origin("display",{inline:o,css:r}),t.style.display="none",typeof e=="function"&&(i.bind(e,t),e.call(t,arguments)),this},show:function(t,e){let o=i(t).origin("display");if(t=i(t)[0],t.style.display="",o){let r=o.inline||"",s=o.css||"";r&&r!=="none"?t.style.display=r:s==="none"&&(t.style.display="block")}else t.style.display="block";return parseInt(t.style.opacity)===0&&(t.style.opacity="1"),typeof e=="function"&&(i.bind(e,t),e.call(t,arguments)),this},visible:function(t,e,n){return e===void 0&&(e=!0),t.style.visibility=e?"visible":"hidden",typeof n=="function"&&(i.bind(n,t),n.call(t,arguments)),this},toggle:function(t,e){let n=getComputedStyle(t,null).display!=="none"?"hide":"show";return i[n](t,e)}});i.fn.extend({hide:function(){let t;return i.each(arguments,function(){typeof this=="function"&&(t=this)}),this.each(function(){i.hide(this,t)})},show:function(){let t;return i.each(arguments,function(){typeof this=="function"&&(t=this)}),this.each(function(){i.show(this,t)})},visible:function(t,e){return this.each(function(){i.visible(this,t,e)})},toggle:function(t){return this.each(function(){i.toggle(this,t)})},hidden:function(t,e){return this.each(function(){i.hidden(this,t,e)})}});i.extend({fx:{off:!1}});i.fn.extend({fadeIn:function(t,e,n){return this.each(function(){let o=this,r=i(o),s=!(!N(o)||N(o)&&+r.style("opacity")==0);if(u(t)&&u(e)&&u(n)?(n=null,t=i.animation.duration):typeof t=="function"&&(n=t,t=i.animation.duration),typeof e=="function"&&(n=e,e=i.animation.ease),i.fx.off&&(t=0),s)return typeof n=="function"&&i.bind(n,this)(),this;let a=r.origin("display",void 0,"block");return o.style.opacity="0",o.style.display=a,i.animate({el:o,draw:{opacity:1},dur:t,ease:e,onDone:function(){typeof n=="function"&&i.bind(n,this)()}})})},fadeOut:function(t,e,n){return this.each(function(){let o=this,r=i(o);return u(t)&&u(e)&&u(n)?(n=null,t=i.animation.duration):typeof t=="function"&&(n=t,t=i.animation.duration),typeof e=="function"&&(n=e,e=i.animation.ease),r.origin("display",r.style("display")),N(o)?i.animate({el:o,draw:{opacity:0},dur:t,ease:e,onDone:function(){this.style.display="none",typeof n=="function"&&i.bind(n,this)()}}):(typeof n=="function"&&i.bind(n,this)(),this)})},slideUp:function(t,e,n){return this.each(function(){let o=this,r=i(o),s;if(r.height()!==0)return u(t)&&u(e)&&u(n)?(n=null,t=i.animation.duration):typeof t=="function"&&(n=t,t=i.animation.duration),typeof e=="function"&&(n=e,e=i.animation.ease),s=r.height(),r.origin("height",s),r.origin("display",i(o).style("display")),r.css({overflow:"hidden"}),i.animate({el:o,draw:{height:0},dur:t,ease:e,onDone:function(){r.hide().removeStyleProperty("overflow, height"),typeof n=="function"&&i.bind(n,this)()}})})},slideDown:function(t,e,n){return this.each(function(){let o=this,r=i(o),s,a;return u(t)&&u(e)&&u(n)?(n=null,t=i.animation.duration):typeof t=="function"&&(n=t,t=i.animation.duration),typeof e=="function"&&(n=e,e=i.animation.ease),r.show().visible(!1),s=+r.origin("height",void 0,r.height()),parseInt(s)===0&&(s=o.scrollHeight),a=r.origin("display",r.style("display"),"block"),r.height(0).visible(!0),r.css({overflow:"hidden",display:a==="none"?"block":a}),i.animate({el:o,draw:{height:s},dur:t,ease:e,onDone:function(){i(o).removeStyleProperty("overflow, height, visibility"),typeof n=="function"&&i.bind(n,this)()}})})},moveTo:function(t,e,n,o,r){let s={top:e,left:t};return typeof n=="function"&&(r=n,n=i.animation.duration,o=i.animation.ease),typeof o=="function"&&(r=o,o=i.animation.ease),this.each(function(){i.animate({el:this,draw:s,dur:n,ease:o,onDone:r})})},centerTo:function(t,e,n,o,r){return typeof n=="function"&&(r=n,n=i.animation.duration,o=i.animation.ease),typeof o=="function"&&(r=o,o=i.animation.ease),this.each(function(){let s={left:t-this.clientWidth/2,top:e-this.clientHeight/2};i.animate({el:this,draw:s,dur:n,ease:o,onDone:r})})},colorTo:function(t,e,n,o){let r={color:t};return typeof e=="function"&&(o=e,e=i.animation.duration,n=i.animation.ease),typeof n=="function"&&(o=n,n=i.animation.ease),this.each(function(){i.animate({el:this,draw:r,dur:e,ease:n,onDone:o})})},backgroundTo:function(t,e,n,o){let r={backgroundColor:t};return typeof e=="function"&&(o=e,e=i.animation.duration,n=i.animation.ease),typeof n=="function"&&(o=n,n=i.animation.ease),this.each(function(){i.animate({el:this,draw:r,dur:e,ease:n,onDone:o})})},zoomIn:function(t,e,n){let o={scale:[0,1]};return typeof t=="function"&&(n=t,t=i.animation.duration,e=i.animation.ease),typeof e=="function"&&(n=e,e=i.animation.ease),this.each(function(){i.animate({el:this,draw:o,dur:t,ease:e,onDone:n})})},zoomOut:function(t=1e3,e="linear",n=()=>{}){return typeof t=="function"&&(n=t,t=i.animation.duration,e=i.animation.ease),typeof e=="function"&&(n=e,e=i.animation.ease),this.each(function(){i.animate({el:this,draw:{scale:0},dur:t,ease:e,onDone:n})})}});i.init=function(t,e){let n,o=this;if(typeof t=="string"&&(t=t.trim()),this.uid=i.uniqueId(),!t)return this;if(typeof t=="function")return i.ready(t);if(t instanceof Element)return this.push(t),this;if(t instanceof i)return i.each(t,function(){o.push(this)}),this;if(t==="window"&&(t=window),t==="document"&&(t=document),t==="body"&&(t=document.body),t==="html"&&(t=document.documentElement),t==="doctype"&&(t=document.doctype),t&&(t.nodeType||t.self===window))return this.push(t),this;if(P(t))return i.each(t,function(){i(this).each(function(){o.push(this)})}),this;if(typeof t!="string"&&t.self&&t.self!==window)return this;if(t==="#"||t===".")return console.error("Selector can't be # or ."),this;if(t[0]==="@")i("[data-role]").each(function(){M(i(this).attr("data-role"),",").indexOf(t.slice(1))>-1&&o.push(this)});else if(n=i.parseHTML(t),n.length===1&&n[0].nodeType===3)try{[].push.apply(this,document.querySelectorAll(t))}catch{}else i.merge(this,n);return e!==void 0&&(e instanceof i?this.each(function(){i(e).append(o)}):e instanceof HTMLElement?i(e).append(o):C(e)&&i.each(this,function(){for(let r in e)O(e,r)&&this.setAttribute(r,e[r])})),this};i.init.prototype=i.fn;var lt=window.$;window.m4q=i;window.$=i;i.global=function(){lt=window.$,window.$=i};i.noConflict=function(){return window.$===i&&(window.$=lt),i};})();
