// The Module object: Our interface to the outside world. We import
// and export values on it. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to check if Module already exists (e.g. case 3 above).
// Substitution will be replaced with actual code on later stage of the build,
// this way Closure Compiler will not mangle it (e.g. case 4. above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module = typeof Module !== 'undefined' ? Module : {};

// --pre-jses are emitted after the Module integration code, so that they can
// refer to Module (if they choose; they can also define Module)
// {{PRE_JSES}}

// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
var key;
for (key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}

Module['arguments'] = [];
Module['thisProgram'] = './this.program';
Module['quit'] = function(status, toThrow) {
  throw toThrow;
};
Module['preRun'] = [];
Module['postRun'] = [];

// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_WEB = false;
var ENVIRONMENT_IS_WORKER = false;
var ENVIRONMENT_IS_NODE = false;
var ENVIRONMENT_IS_SHELL = false;

// Three configurations we can be running in:
// 1) We could be the application main() thread running in the main JS UI thread. (ENVIRONMENT_IS_WORKER == false and ENVIRONMENT_IS_PTHREAD == false)
// 2) We could be the application main() thread proxied to worker. (with Emscripten -s PROXY_TO_WORKER=1) (ENVIRONMENT_IS_WORKER == true, ENVIRONMENT_IS_PTHREAD == false)
// 3) We could be an application pthread running in a worker. (ENVIRONMENT_IS_WORKER == true and ENVIRONMENT_IS_PTHREAD == true)

if (Module['ENVIRONMENT']) {
  if (Module['ENVIRONMENT'] === 'WEB') {
    ENVIRONMENT_IS_WEB = true;
  } else if (Module['ENVIRONMENT'] === 'WORKER') {
    ENVIRONMENT_IS_WORKER = true;
  } else if (Module['ENVIRONMENT'] === 'NODE') {
    ENVIRONMENT_IS_NODE = true;
  } else if (Module['ENVIRONMENT'] === 'SHELL') {
    ENVIRONMENT_IS_SHELL = true;
  } else {
    throw new Error('Module[\'ENVIRONMENT\'] value is not valid. must be one of: WEB|WORKER|NODE|SHELL.');
  }
} else {
  ENVIRONMENT_IS_WEB = typeof window === 'object';
  ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
  ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function' && !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_WORKER;
  ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
}


if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  var nodeFS;
  var nodePath;

  Module['read'] = function shell_read(filename, binary) {
    var ret;
      if (!nodeFS) nodeFS = require('fs');
      if (!nodePath) nodePath = require('path');
      filename = nodePath['normalize'](filename);
      ret = nodeFS['readFileSync'](filename);
    return binary ? ret : ret.toString();
  };

  Module['readBinary'] = function readBinary(filename) {
    var ret = Module['read'](filename, true);
    if (!ret.buffer) {
      ret = new Uint8Array(ret);
    }
    assert(ret.buffer);
    return ret;
  };

  if (process['argv'].length > 1) {
    Module['thisProgram'] = process['argv'][1].replace(/\\/g, '/');
  }

  Module['arguments'] = process['argv'].slice(2);

  if (typeof module !== 'undefined') {
    module['exports'] = Module;
  }

  process['on']('uncaughtException', function(ex) {
    // suppress ExitStatus exceptions from showing an error
    if (!(ex instanceof ExitStatus)) {
      throw ex;
    }
  });
  // Currently node will swallow unhandled rejections, but this behavior is
  // deprecated, and in the future it will exit with error status.
  process['on']('unhandledRejection', function(reason, p) {
    Module['printErr']('node.js exiting due to unhandled promise rejection');
    process['exit'](1);
  });

  Module['inspect'] = function () { return '[Emscripten Module object]'; };
}
else if (ENVIRONMENT_IS_SHELL) {
  if (typeof read != 'undefined') {
    Module['read'] = function shell_read(f) {
      return read(f);
    };
  }

  Module['readBinary'] = function readBinary(f) {
    var data;
    if (typeof readbuffer === 'function') {
      return new Uint8Array(readbuffer(f));
    }
    data = read(f, 'binary');
    assert(typeof data === 'object');
    return data;
  };

  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }

  if (typeof quit === 'function') {
    Module['quit'] = function(status, toThrow) {
      quit(status);
    }
  }
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function shell_read(url) {
      var xhr = new XMLHttpRequest();
      xhr.open('GET', url, false);
      xhr.send(null);
      return xhr.responseText;
  };

  if (ENVIRONMENT_IS_WORKER) {
    Module['readBinary'] = function readBinary(url) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, false);
        xhr.responseType = 'arraybuffer';
        xhr.send(null);
        return new Uint8Array(xhr.response);
    };
  }

  Module['readAsync'] = function readAsync(url, onload, onerror) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'arraybuffer';
    xhr.onload = function xhr_onload() {
      if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
        onload(xhr.response);
        return;
      }
      onerror();
    };
    xhr.onerror = onerror;
    xhr.send(null);
  };

  Module['setWindowTitle'] = function(title) { document.title = title };
}
else {
  // Unreachable because SHELL is dependent on the others
  throw new Error('unknown runtime environment');
}

// console.log is checked first, as 'print' on the web will open a print dialogue
// printErr is preferable to console.warn (works better in shells)
// bind(console) is necessary to fix IE/Edge closed dev tools panel behavior.
Module['print'] = typeof console !== 'undefined' ? console.log.bind(console) : (typeof print !== 'undefined' ? print : null);
Module['printErr'] = typeof printErr !== 'undefined' ? printErr : ((typeof console !== 'undefined' && console.warn.bind(console)) || Module['print']);

// *** Environment setup code ***

// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];

// Merge back in the overrides
for (key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// Free the object hierarchy contained in the overrides, this lets the GC
// reclaim data used e.g. in memoryInitializerRequest, which is a large typed array.
moduleOverrides = undefined;



// {{PREAMBLE_ADDITIONS}}

var STACK_ALIGN = 16;

// stack management, and other functionality that is provided by the compiled code,
// should not be used before it is ready
stackSave = stackRestore = stackAlloc = setTempRet0 = getTempRet0 = function() {
  abort('cannot use the stack before compiled code is ready to run, and has provided stack access');
};

function staticAlloc(size) {
  assert(!staticSealed);
  var ret = STATICTOP;
  STATICTOP = (STATICTOP + size + 15) & -16;
  return ret;
}

function dynamicAlloc(size) {
  assert(DYNAMICTOP_PTR);
  var ret = HEAP32[DYNAMICTOP_PTR>>2];
  var end = (ret + size + 15) & -16;
  HEAP32[DYNAMICTOP_PTR>>2] = end;
  if (end >= TOTAL_MEMORY) {
    var success = enlargeMemory();
    if (!success) {
      HEAP32[DYNAMICTOP_PTR>>2] = ret;
      return 0;
    }
  }
  return ret;
}

function alignMemory(size, factor) {
  if (!factor) factor = STACK_ALIGN; // stack alignment (16-byte) by default
  var ret = size = Math.ceil(size / factor) * factor;
  return ret;
}

function getNativeTypeSize(type) {
  switch (type) {
    case 'i1': case 'i8': return 1;
    case 'i16': return 2;
    case 'i32': return 4;
    case 'i64': return 8;
    case 'float': return 4;
    case 'double': return 8;
    default: {
      if (type[type.length-1] === '*') {
        return 4; // A pointer
      } else if (type[0] === 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 === 0);
        return bits / 8;
      } else {
        return 0;
      }
    }
  }
}

function warnOnce(text) {
  if (!warnOnce.shown) warnOnce.shown = {};
  if (!warnOnce.shown[text]) {
    warnOnce.shown[text] = 1;
    Module.printErr(text);
  }
}



var jsCallStartIndex = 1;
var functionPointers = new Array(0);

// 'sig' parameter is only used on LLVM wasm backend
function addFunction(func, sig) {
  if (typeof sig === 'undefined') {
    Module.printErr('Warning: addFunction: Provide a wasm function signature ' +
                    'string as a second argument');
  }
  var base = 0;
  for (var i = base; i < base + 0; i++) {
    if (!functionPointers[i]) {
      functionPointers[i] = func;
      return jsCallStartIndex + i;
    }
  }
  throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
}

function removeFunction(index) {
  functionPointers[index-jsCallStartIndex] = null;
}

var funcWrappers = {};

function getFuncWrapper(func, sig) {
  if (!func) return; // on null pointer, return undefined
  assert(sig);
  if (!funcWrappers[sig]) {
    funcWrappers[sig] = {};
  }
  var sigCache = funcWrappers[sig];
  if (!sigCache[func]) {
    // optimize away arguments usage in common cases
    if (sig.length === 1) {
      sigCache[func] = function dynCall_wrapper() {
        return dynCall(sig, func);
      };
    } else if (sig.length === 2) {
      sigCache[func] = function dynCall_wrapper(arg) {
        return dynCall(sig, func, [arg]);
      };
    } else {
      // general case
      sigCache[func] = function dynCall_wrapper() {
        return dynCall(sig, func, Array.prototype.slice.call(arguments));
      };
    }
  }
  return sigCache[func];
}


function makeBigInt(low, high, unsigned) {
  return unsigned ? ((+((low>>>0)))+((+((high>>>0)))*4294967296.0)) : ((+((low>>>0)))+((+((high|0)))*4294967296.0));
}

function dynCall(sig, ptr, args) {
  if (args && args.length) {
    assert(args.length == sig.length-1);
    assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
    return Module['dynCall_' + sig].apply(null, [ptr].concat(args));
  } else {
    assert(sig.length == 1);
    assert(('dynCall_' + sig) in Module, 'bad function pointer type - no table for sig \'' + sig + '\'');
    return Module['dynCall_' + sig].call(null, ptr);
  }
}


function getCompilerSetting(name) {
  throw 'You must build with -s RETAIN_COMPILER_SETTINGS=1 for getCompilerSetting or emscripten_get_compiler_setting to work';
}

var Runtime = {
  // FIXME backwards compatibility layer for ports. Support some Runtime.*
  //       for now, fix it there, then remove it from here. That way we
  //       can minimize any period of breakage.
  dynCall: dynCall, // for SDL2 port
  // helpful errors
  getTempRet0: function() { abort('getTempRet0() is now a top-level function, after removing the Runtime object. Remove "Runtime."') },
  staticAlloc: function() { abort('staticAlloc() is now a top-level function, after removing the Runtime object. Remove "Runtime."') },
  stackAlloc: function() { abort('stackAlloc() is now a top-level function, after removing the Runtime object. Remove "Runtime."') },
};

// The address globals begin at. Very low in memory, for code size and optimization opportunities.
// Above 0 is static memory, starting with globals.
// Then the stack.
// Then 'dynamic' memory for sbrk.
var GLOBAL_BASE = 8;



// === Preamble library stuff ===

// Documentation for the public APIs defined in this file must be updated in:
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at:
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html



//========================================
// Runtime essentials
//========================================

var ABORT = 0; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;

/** @type {function(*, string=)} */
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}

var globalScope = this;

// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  var func = Module['_' + ident]; // closure exported function
  assert(func, 'Cannot call unknown function ' + ident + ', make sure it is exported');
  return func;
}

var JSfuncs = {
  // Helpers for cwrap -- it can't refer to Runtime directly because it might
  // be renamed by closure, instead it calls JSfuncs['stackSave'].body to find
  // out what the minified function name is.
  'stackSave': function() {
    stackSave()
  },
  'stackRestore': function() {
    stackRestore()
  },
  // type conversion from js to c
  'arrayToC' : function(arr) {
    var ret = stackAlloc(arr.length);
    writeArrayToMemory(arr, ret);
    return ret;
  },
  'stringToC' : function(str) {
    var ret = 0;
    if (str !== null && str !== undefined && str !== 0) { // null string
      // at most 4 bytes per UTF-8 code point, +1 for the trailing '\0'
      var len = (str.length << 2) + 1;
      ret = stackAlloc(len);
      stringToUTF8(str, ret, len);
    }
    return ret;
  }
};

// For fast lookup of conversion functions
var toC = {
  'string': JSfuncs['stringToC'], 'array': JSfuncs['arrayToC']
};

// C calling interface.
function ccall (ident, returnType, argTypes, args, opts) {
  var func = getCFunc(ident);
  var cArgs = [];
  var stack = 0;
  assert(returnType !== 'array', 'Return type should not be "array".');
  if (args) {
    for (var i = 0; i < args.length; i++) {
      var converter = toC[argTypes[i]];
      if (converter) {
        if (stack === 0) stack = stackSave();
        cArgs[i] = converter(args[i]);
      } else {
        cArgs[i] = args[i];
      }
    }
  }
  var ret = func.apply(null, cArgs);
  if (returnType === 'string') ret = Pointer_stringify(ret);
  else if (returnType === 'boolean') ret = Boolean(ret);
  if (stack !== 0) {
    stackRestore(stack);
  }
  return ret;
}

function cwrap (ident, returnType, argTypes) {
  argTypes = argTypes || [];
  var cfunc = getCFunc(ident);
  // When the function takes numbers and returns a number, we can just return
  // the original function
  var numericArgs = argTypes.every(function(type){ return type === 'number'});
  var numericRet = returnType !== 'string';
  if (numericRet && numericArgs) {
    return cfunc;
  }
  return function() {
    return ccall(ident, returnType, argTypes, arguments);
  }
}

/** @type {function(number, number, string, boolean=)} */
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[((ptr)>>0)]=value; break;
      case 'i8': HEAP8[((ptr)>>0)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}

/** @type {function(number, string, boolean=)} */
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[((ptr)>>0)];
      case 'i8': return HEAP8[((ptr)>>0)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for getValue: ' + type);
    }
  return null;
}

var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate

// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
/** @type {function((TypedArray|Array<number>|number), string, number, number=)} */
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }

  var singleType = typeof types === 'string' ? types : null;

  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [typeof _malloc === 'function' ? _malloc : staticAlloc, stackAlloc, staticAlloc, dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }

  if (zeroinit) {
    var stop;
    ptr = ret;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)>>0)]=0;
    }
    return ret;
  }

  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(/** @type {!Uint8Array} */ (slab), ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }

  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];

    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    assert(type, 'Must know what type to store in allocate!');

    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later

    setValue(ret+i, curr, type);

    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }

  return ret;
}

// Allocate memory during any stage of startup - static memory early on, dynamic memory later, malloc when ready
function getMemory(size) {
  if (!staticSealed) return staticAlloc(size);
  if (!runtimeInitialized) return dynamicAlloc(size);
  return _malloc(size);
}

/** @type {function(number, number=)} */
function Pointer_stringify(ptr, length) {
  if (length === 0 || !ptr) return '';
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = 0;
  var t;
  var i = 0;
  while (1) {
    assert(ptr + i < TOTAL_MEMORY);
    t = HEAPU8[(((ptr)+(i))>>0)];
    hasUtf |= t;
    if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;

  var ret = '';

  if (hasUtf < 128) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  return UTF8ToString(ptr);
}

// Given a pointer 'ptr' to a null-terminated ASCII-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function AsciiToString(ptr) {
  var str = '';
  while (1) {
    var ch = HEAP8[((ptr++)>>0)];
    if (!ch) return str;
    str += String.fromCharCode(ch);
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in ASCII form. The copy will require at most str.length+1 bytes of space in the HEAP.

function stringToAscii(str, outPtr) {
  return writeAsciiToMemory(str, outPtr, false);
}

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the given array that contains uint8 values, returns
// a copy of that string as a Javascript String object.

var UTF8Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf8') : undefined;
function UTF8ArrayToString(u8Array, idx) {
  var endPtr = idx;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  while (u8Array[endPtr]) ++endPtr;

  if (endPtr - idx > 16 && u8Array.subarray && UTF8Decoder) {
    return UTF8Decoder.decode(u8Array.subarray(idx, endPtr));
  } else {
    var u0, u1, u2, u3, u4, u5;

    var str = '';
    while (1) {
      // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
      u0 = u8Array[idx++];
      if (!u0) return str;
      if (!(u0 & 0x80)) { str += String.fromCharCode(u0); continue; }
      u1 = u8Array[idx++] & 63;
      if ((u0 & 0xE0) == 0xC0) { str += String.fromCharCode(((u0 & 31) << 6) | u1); continue; }
      u2 = u8Array[idx++] & 63;
      if ((u0 & 0xF0) == 0xE0) {
        u0 = ((u0 & 15) << 12) | (u1 << 6) | u2;
      } else {
        u3 = u8Array[idx++] & 63;
        if ((u0 & 0xF8) == 0xF0) {
          u0 = ((u0 & 7) << 18) | (u1 << 12) | (u2 << 6) | u3;
        } else {
          u4 = u8Array[idx++] & 63;
          if ((u0 & 0xFC) == 0xF8) {
            u0 = ((u0 & 3) << 24) | (u1 << 18) | (u2 << 12) | (u3 << 6) | u4;
          } else {
            u5 = u8Array[idx++] & 63;
            u0 = ((u0 & 1) << 30) | (u1 << 24) | (u2 << 18) | (u3 << 12) | (u4 << 6) | u5;
          }
        }
      }
      if (u0 < 0x10000) {
        str += String.fromCharCode(u0);
      } else {
        var ch = u0 - 0x10000;
        str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
      }
    }
  }
}

// Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

function UTF8ToString(ptr) {
  return UTF8ArrayToString(HEAPU8,ptr);
}

// Copies the given Javascript String object 'str' to the given byte array at address 'outIdx',
// encoded in UTF8 form and null-terminated. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outU8Array: the array to copy to. Each index in this array is assumed to be one 8-byte element.
//   outIdx: The starting offset in the array to begin the copying.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=1, only the null terminator will be written and nothing else.
//                    maxBytesToWrite=0 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8Array(str, outU8Array, outIdx, maxBytesToWrite) {
  if (!(maxBytesToWrite > 0)) // Parameter maxBytesToWrite is not optional. Negative values, 0, null, undefined and false each don't write out any bytes.
    return 0;

  var startIdx = outIdx;
  var endIdx = outIdx + maxBytesToWrite - 1; // -1 for string null terminator.
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    // For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description and https://www.ietf.org/rfc/rfc2279.txt and https://tools.ietf.org/html/rfc3629
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      if (outIdx >= endIdx) break;
      outU8Array[outIdx++] = u;
    } else if (u <= 0x7FF) {
      if (outIdx + 1 >= endIdx) break;
      outU8Array[outIdx++] = 0xC0 | (u >> 6);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0xFFFF) {
      if (outIdx + 2 >= endIdx) break;
      outU8Array[outIdx++] = 0xE0 | (u >> 12);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x1FFFFF) {
      if (outIdx + 3 >= endIdx) break;
      outU8Array[outIdx++] = 0xF0 | (u >> 18);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else if (u <= 0x3FFFFFF) {
      if (outIdx + 4 >= endIdx) break;
      outU8Array[outIdx++] = 0xF8 | (u >> 24);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    } else {
      if (outIdx + 5 >= endIdx) break;
      outU8Array[outIdx++] = 0xFC | (u >> 30);
      outU8Array[outIdx++] = 0x80 | ((u >> 24) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 18) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 12) & 63);
      outU8Array[outIdx++] = 0x80 | ((u >> 6) & 63);
      outU8Array[outIdx++] = 0x80 | (u & 63);
    }
  }
  // Null-terminate the pointer to the buffer.
  outU8Array[outIdx] = 0;
  return outIdx - startIdx;
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF8 form. The copy will require at most str.length*4+1 bytes of space in the HEAP.
// Use the function lengthBytesUTF8 to compute the exact number of bytes (excluding null terminator) that this function will write.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF8(str, outPtr, maxBytesToWrite) {
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF8(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  return stringToUTF8Array(str, HEAPU8,outPtr, maxBytesToWrite);
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF8 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF8(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! So decode UTF16->UTF32->UTF8.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var u = str.charCodeAt(i); // possibly a lead surrogate
    if (u >= 0xD800 && u <= 0xDFFF) u = 0x10000 + ((u & 0x3FF) << 10) | (str.charCodeAt(++i) & 0x3FF);
    if (u <= 0x7F) {
      ++len;
    } else if (u <= 0x7FF) {
      len += 2;
    } else if (u <= 0xFFFF) {
      len += 3;
    } else if (u <= 0x1FFFFF) {
      len += 4;
    } else if (u <= 0x3FFFFFF) {
      len += 5;
    } else {
      len += 6;
    }
  }
  return len;
}

// Given a pointer 'ptr' to a null-terminated UTF16LE-encoded string in the emscripten HEAP, returns
// a copy of that string as a Javascript String object.

var UTF16Decoder = typeof TextDecoder !== 'undefined' ? new TextDecoder('utf-16le') : undefined;
function UTF16ToString(ptr) {
  assert(ptr % 2 == 0, 'Pointer passed to UTF16ToString must be aligned to two bytes!');
  var endPtr = ptr;
  // TextDecoder needs to know the byte length in advance, it doesn't stop on null terminator by itself.
  // Also, use the length info to avoid running tiny strings through TextDecoder, since .subarray() allocates garbage.
  var idx = endPtr >> 1;
  while (HEAP16[idx]) ++idx;
  endPtr = idx << 1;

  if (endPtr - ptr > 32 && UTF16Decoder) {
    return UTF16Decoder.decode(HEAPU8.subarray(ptr, endPtr));
  } else {
    var i = 0;

    var str = '';
    while (1) {
      var codeUnit = HEAP16[(((ptr)+(i*2))>>1)];
      if (codeUnit == 0) return str;
      ++i;
      // fromCharCode constructs a character from a UTF-16 code unit, so we can pass the UTF16 string right through.
      str += String.fromCharCode(codeUnit);
    }
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF16 form. The copy will require at most str.length*4+2 bytes of space in the HEAP.
// Use the function lengthBytesUTF16() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=2, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<2 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF16(str, outPtr, maxBytesToWrite) {
  assert(outPtr % 2 == 0, 'Pointer passed to stringToUTF16 must be aligned to two bytes!');
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF16(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 2) return 0;
  maxBytesToWrite -= 2; // Null terminator.
  var startPtr = outPtr;
  var numCharsToWrite = (maxBytesToWrite < str.length*2) ? (maxBytesToWrite / 2) : str.length;
  for (var i = 0; i < numCharsToWrite; ++i) {
    // charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    HEAP16[((outPtr)>>1)]=codeUnit;
    outPtr += 2;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP16[((outPtr)>>1)]=0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF16(str) {
  return str.length*2;
}

function UTF32ToString(ptr) {
  assert(ptr % 4 == 0, 'Pointer passed to UTF32ToString must be aligned to four bytes!');
  var i = 0;

  var str = '';
  while (1) {
    var utf32 = HEAP32[(((ptr)+(i*4))>>2)];
    if (utf32 == 0)
      return str;
    ++i;
    // Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    if (utf32 >= 0x10000) {
      var ch = utf32 - 0x10000;
      str += String.fromCharCode(0xD800 | (ch >> 10), 0xDC00 | (ch & 0x3FF));
    } else {
      str += String.fromCharCode(utf32);
    }
  }
}

// Copies the given Javascript String object 'str' to the emscripten HEAP at address 'outPtr',
// null-terminated and encoded in UTF32 form. The copy will require at most str.length*4+4 bytes of space in the HEAP.
// Use the function lengthBytesUTF32() to compute the exact number of bytes (excluding null terminator) that this function will write.
// Parameters:
//   str: the Javascript string to copy.
//   outPtr: Byte address in Emscripten HEAP where to write the string to.
//   maxBytesToWrite: The maximum number of bytes this function can write to the array. This count should include the null
//                    terminator, i.e. if maxBytesToWrite=4, only the null terminator will be written and nothing else.
//                    maxBytesToWrite<4 does not write any bytes to the output, not even the null terminator.
// Returns the number of bytes written, EXCLUDING the null terminator.

function stringToUTF32(str, outPtr, maxBytesToWrite) {
  assert(outPtr % 4 == 0, 'Pointer passed to stringToUTF32 must be aligned to four bytes!');
  assert(typeof maxBytesToWrite == 'number', 'stringToUTF32(str, outPtr, maxBytesToWrite) is missing the third parameter that specifies the length of the output buffer!');
  // Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
  if (maxBytesToWrite === undefined) {
    maxBytesToWrite = 0x7FFFFFFF;
  }
  if (maxBytesToWrite < 4) return 0;
  var startPtr = outPtr;
  var endPtr = startPtr + maxBytesToWrite - 4;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i); // possibly a lead surrogate
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) {
      var trailSurrogate = str.charCodeAt(++i);
      codeUnit = 0x10000 + ((codeUnit & 0x3FF) << 10) | (trailSurrogate & 0x3FF);
    }
    HEAP32[((outPtr)>>2)]=codeUnit;
    outPtr += 4;
    if (outPtr + 4 > endPtr) break;
  }
  // Null-terminate the pointer to the HEAP.
  HEAP32[((outPtr)>>2)]=0;
  return outPtr - startPtr;
}

// Returns the number of bytes the given Javascript string takes if encoded as a UTF16 byte array, EXCLUDING the null terminator byte.

function lengthBytesUTF32(str) {
  var len = 0;
  for (var i = 0; i < str.length; ++i) {
    // Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
    // See http://unicode.org/faq/utf_bom.html#utf16-3
    var codeUnit = str.charCodeAt(i);
    if (codeUnit >= 0xD800 && codeUnit <= 0xDFFF) ++i; // possibly a lead surrogate, so skip over the tail surrogate.
    len += 4;
  }

  return len;
}

// Allocate heap space for a JS string, and write it there.
// It is the responsibility of the caller to free() that memory.
function allocateUTF8(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = _malloc(size);
  if (ret) stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

// Allocate stack space for a JS string, and write it there.
function allocateUTF8OnStack(str) {
  var size = lengthBytesUTF8(str) + 1;
  var ret = stackAlloc(size);
  stringToUTF8Array(str, HEAP8, ret, size);
  return ret;
}

function demangle(func) {
  var __cxa_demangle_func = Module['___cxa_demangle'] || Module['__cxa_demangle'];
  assert(__cxa_demangle_func);
  try {
    var s =
      func.substr(1);
    var len = lengthBytesUTF8(s)+1;
    var buf = _malloc(len);
    stringToUTF8(s, buf, len);
    var status = _malloc(4);
    var ret = __cxa_demangle_func(buf, 0, 0, status);
    if (HEAP32[((status)>>2)] === 0 && ret) {
      return Pointer_stringify(ret);
    }
    // otherwise, libcxxabi failed
  } catch(e) {
    // ignore problems here
  } finally {
    if (buf) _free(buf);
    if (status) _free(status);
    if (ret) _free(ret);
  }
  // failure when using libcxxabi, don't demangle
  return func;
}

function demangleAll(text) {
  var regex =
    /__Z[\w\d_]+/g;
  return text.replace(regex,
    function(x) {
      var y = demangle(x);
      return x === y ? x : (x + ' [' + y + ']');
    });
}

function jsStackTrace() {
  var err = new Error();
  if (!err.stack) {
    // IE10+ special cases: It does have callstack info, but it is only populated if an Error object is thrown,
    // so try that as a special-case.
    try {
      throw new Error(0);
    } catch(e) {
      err = e;
    }
    if (!err.stack) {
      return '(no stack trace available)';
    }
  }
  return err.stack.toString();
}

function stackTrace() {
  var js = jsStackTrace();
  if (Module['extraStackTrace']) js += '\n' + Module['extraStackTrace']();
  return demangleAll(js);
}

// Memory management

var PAGE_SIZE = 16384;
var WASM_PAGE_SIZE = 65536;
var ASMJS_PAGE_SIZE = 16777216;
var MIN_TOTAL_MEMORY = 16777216;

function alignUp(x, multiple) {
  if (x % multiple > 0) {
    x += multiple - (x % multiple);
  }
  return x;
}

var HEAP,
/** @type {ArrayBuffer} */
  buffer,
/** @type {Int8Array} */
  HEAP8,
/** @type {Uint8Array} */
  HEAPU8,
/** @type {Int16Array} */
  HEAP16,
/** @type {Uint16Array} */
  HEAPU16,
/** @type {Int32Array} */
  HEAP32,
/** @type {Uint32Array} */
  HEAPU32,
/** @type {Float32Array} */
  HEAPF32,
/** @type {Float64Array} */
  HEAPF64;

function updateGlobalBuffer(buf) {
  Module['buffer'] = buffer = buf;
}

function updateGlobalBufferViews() {
  Module['HEAP8'] = HEAP8 = new Int8Array(buffer);
  Module['HEAP16'] = HEAP16 = new Int16Array(buffer);
  Module['HEAP32'] = HEAP32 = new Int32Array(buffer);
  Module['HEAPU8'] = HEAPU8 = new Uint8Array(buffer);
  Module['HEAPU16'] = HEAPU16 = new Uint16Array(buffer);
  Module['HEAPU32'] = HEAPU32 = new Uint32Array(buffer);
  Module['HEAPF32'] = HEAPF32 = new Float32Array(buffer);
  Module['HEAPF64'] = HEAPF64 = new Float64Array(buffer);
}

var STATIC_BASE, STATICTOP, staticSealed; // static area
var STACK_BASE, STACKTOP, STACK_MAX; // stack area
var DYNAMIC_BASE, DYNAMICTOP_PTR; // dynamic area handled by sbrk

  STATIC_BASE = STATICTOP = STACK_BASE = STACKTOP = STACK_MAX = DYNAMIC_BASE = DYNAMICTOP_PTR = 0;
  staticSealed = false;


// Initializes the stack cookie. Called at the startup of main and at the startup of each thread in pthreads mode.
function writeStackCookie() {
  assert((STACK_MAX & 3) == 0);
  HEAPU32[(STACK_MAX >> 2)-1] = 0x02135467;
  HEAPU32[(STACK_MAX >> 2)-2] = 0x89BACDFE;
}

function checkStackCookie() {
  if (HEAPU32[(STACK_MAX >> 2)-1] != 0x02135467 || HEAPU32[(STACK_MAX >> 2)-2] != 0x89BACDFE) {
    abort('Stack overflow! Stack cookie has been overwritten, expected hex dwords 0x89BACDFE and 0x02135467, but received 0x' + HEAPU32[(STACK_MAX >> 2)-2].toString(16) + ' ' + HEAPU32[(STACK_MAX >> 2)-1].toString(16));
  }
  // Also test the global address 0 for integrity. This check is not compatible with SAFE_SPLIT_MEMORY though, since that mode already tests all address 0 accesses on its own.
  if (HEAP32[0] !== 0x63736d65 /* 'emsc' */) throw 'Runtime error: The application has corrupted its heap memory area (address zero)!';
}

function abortStackOverflow(allocSize) {
  abort('Stack overflow! Attempted to allocate ' + allocSize + ' bytes on the stack, but stack has only ' + (STACK_MAX - stackSave() + allocSize) + ' bytes available!');
}

function abortOnCannotGrowMemory() {
  abort('Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value ' + TOTAL_MEMORY + ', (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ');
}


function enlargeMemory() {
  abortOnCannotGrowMemory();
}


var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 536870912;
if (TOTAL_MEMORY < TOTAL_STACK) Module.printErr('TOTAL_MEMORY should be larger than TOTAL_STACK, was ' + TOTAL_MEMORY + '! (TOTAL_STACK=' + TOTAL_STACK + ')');

// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(typeof Int32Array !== 'undefined' && typeof Float64Array !== 'undefined' && Int32Array.prototype.subarray !== undefined && Int32Array.prototype.set !== undefined,
       'JS engine does not provide full typed array support');



// Use a provided buffer, if there is one, or else allocate a new one
if (Module['buffer']) {
  buffer = Module['buffer'];
  assert(buffer.byteLength === TOTAL_MEMORY, 'provided buffer should be ' + TOTAL_MEMORY + ' bytes, but it is ' + buffer.byteLength);
} else {
  // Use a WebAssembly memory where available
  {
    buffer = new ArrayBuffer(TOTAL_MEMORY);
  }
  assert(buffer.byteLength === TOTAL_MEMORY);
  Module['buffer'] = buffer;
}
updateGlobalBufferViews();


function getTotalMemory() {
  return TOTAL_MEMORY;
}

// Endianness check (note: assumes compiler arch was little-endian)
  HEAP32[0] = 0x63736d65; /* 'emsc' */
HEAP16[1] = 0x6373;
if (HEAPU8[2] !== 0x73 || HEAPU8[3] !== 0x63) throw 'Runtime error: expected the system to be little-endian!';

function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Module['dynCall_v'](func);
      } else {
        Module['dynCall_vi'](func, callback.arg);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}

var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited

var runtimeInitialized = false;
var runtimeExited = false;


function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}

function ensureInitRuntime() {
  checkStackCookie();
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}

function preMain() {
  checkStackCookie();
  callRuntimeCallbacks(__ATMAIN__);
}

function exitRuntime() {
  checkStackCookie();
  callRuntimeCallbacks(__ATEXIT__);
  runtimeExited = true;
}

function postRun() {
  checkStackCookie();
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}

function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}

function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}

function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}

function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}

function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}

// Deprecated: This function should not be called because it is unsafe and does not provide
// a maximum length limit of how many bytes it is allowed to write. Prefer calling the
// function stringToUTF8Array() instead, which takes in a maximum length that can be used
// to be secure from out of bounds writes.
/** @deprecated */
function writeStringToMemory(string, buffer, dontAddNull) {
  warnOnce('writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!');

  var /** @type {number} */ lastChar, /** @type {number} */ end;
  if (dontAddNull) {
    // stringToUTF8Array always appends null. If we don't want to do that, remember the
    // character that existed at the location where the null will be placed, and restore
    // that after the write (below).
    end = buffer + lengthBytesUTF8(string);
    lastChar = HEAP8[end];
  }
  stringToUTF8(string, buffer, Infinity);
  if (dontAddNull) HEAP8[end] = lastChar; // Restore the value under the null character.
}

function writeArrayToMemory(array, buffer) {
  assert(array.length >= 0, 'writeArrayToMemory array must have a length (should be an array or typed array)')
  HEAP8.set(array, buffer);
}

function writeAsciiToMemory(str, buffer, dontAddNull) {
  for (var i = 0; i < str.length; ++i) {
    assert(str.charCodeAt(i) === str.charCodeAt(i)&0xff);
    HEAP8[((buffer++)>>0)]=str.charCodeAt(i);
  }
  // Null-terminate the pointer to the HEAP.
  if (!dontAddNull) HEAP8[((buffer)>>0)]=0;
}

function unSign(value, bits, ignore) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}

assert(Math['imul'] && Math['fround'] && Math['clz32'] && Math['trunc'], 'this is a legacy browser, build with LEGACY_VM_SUPPORT');

var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_round = Math.round;
var Math_min = Math.min;
var Math_max = Math.max;
var Math_clz32 = Math.clz32;
var Math_trunc = Math.trunc;

// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null; // overridden to take different actions when all run dependencies are fulfilled
var runDependencyTracking = {};

function getUniqueRunDependency(id) {
  var orig = id;
  while (1) {
    if (!runDependencyTracking[id]) return id;
    id = orig + Math.random();
  }
  return id;
}

function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
    if (runDependencyWatcher === null && typeof setInterval !== 'undefined') {
      // Check for missing dependencies every few seconds
      runDependencyWatcher = setInterval(function() {
        if (ABORT) {
          clearInterval(runDependencyWatcher);
          runDependencyWatcher = null;
          return;
        }
        var shown = false;
        for (var dep in runDependencyTracking) {
          if (!shown) {
            shown = true;
            Module.printErr('still waiting on run dependencies:');
          }
          Module.printErr('dependency: ' + dep);
        }
        if (shown) {
          Module.printErr('(end of list)');
        }
      }, 10000);
    }
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}

function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    }
    if (dependenciesFulfilled) {
      var callback = dependenciesFulfilled;
      dependenciesFulfilled = null;
      callback(); // can add another dependenciesFulfilled
    }
  }
}

Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data



var memoryInitializer = null;






// Prefix of data URIs emitted by SINGLE_FILE and related options.
var dataURIPrefix = 'data:application/octet-stream;base64,';

// Indicates whether filename is a base64 data URI.
function isDataURI(filename) {
  return String.prototype.startsWith ?
      filename.startsWith(dataURIPrefix) :
      filename.indexOf(dataURIPrefix) === 0;
}





// === Body ===

var ASM_CONSTS = [function($0) { Module.debugPointer($0); },
 function($0, $1, $2, $3) { Module.summarizeBuffer($0, $1, $2, $3); },
 function($0, $1, $2, $3, $4) { Module.blit($0, $1, $2, $3, $4); },
 function() { return Module.screenWidth(); },
 function() { return Module.screenHeight(); },
 function() { return Module.acquireInputLock(); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.mouseButtonStateAddr); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.mouseMoveFlagAddr); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.mouseMoveXDeltaAddr); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.mouseMoveYDeltaAddr); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.keyEventFlagAddr); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.keyCodeAddr); },
 function() { return Module.getInputValue(Module.InputBufferAddresses.keyStateAddr); },
 function() { Module.releaseInputLock(); },
 function($0, $1) { Module.send($0, $1); },
 function($0) { return Module.recv($0, 1514); },
 function() { Module.print("no net_protocols") },
 function() { Module.print("no net_protocols handler") },
 function($0, $1, $2, $3) { Module.openAudio($0, $1, $2, $3); },
 function($0, $1, $2) { return Module.enqueueAudio($0, $1, $2); }];

function _emscripten_asm_const_i(code) {
  return ASM_CONSTS[code]();
}

function _emscripten_asm_const_iiiiii(code, a0, a1, a2, a3, a4) {
  return ASM_CONSTS[code](a0, a1, a2, a3, a4);
}

function _emscripten_asm_const_ii(code, a0) {
  return ASM_CONSTS[code](a0);
}

function _emscripten_asm_const_iiiii(code, a0, a1, a2, a3) {
  return ASM_CONSTS[code](a0, a1, a2, a3);
}

function _emscripten_asm_const_iii(code, a0, a1) {
  return ASM_CONSTS[code](a0, a1);
}

function _emscripten_asm_const_iiii(code, a0, a1, a2) {
  return ASM_CONSTS[code](a0, a1, a2);
}




STATIC_BASE = GLOBAL_BASE;

STATICTOP = STATIC_BASE + 663504;
/* global initializers */  __ATINIT__.push({ func: function() { __GLOBAL__sub_I_sony_cpp() } }, { func: function() { __GLOBAL__sub_I_disk_cpp() } }, { func: function() { __GLOBAL__sub_I_cdrom_cpp() } }, { func: function() { __GLOBAL__sub_I_video_cpp() } }, { func: function() { __GLOBAL__sub_I_audio_cpp() } }, { func: function() { __GLOBAL__sub_I_video_sdl_cpp() } });


/* memory initializer */ allocate([96,91,1,0,170,119,1,0,136,91,1,0,92,123,1,0,32,0,0,0,0,0,0,0,96,91,1,0,112,123,1,0,96,91,1,0,108,124,1,0,136,91,1,0,198,123,1,0,40,0,0,0,0,0,0,0,96,91,1,0,172,123,1,0,136,91,1,0,222,123,1,0,40,0,0,0,0,0,0,0,136,91,1,0,250,123,1,0,40,0,0,0,0,0,0,0,136,91,1,0,18,124,1,0,40,0,0,0,0,0,0,0,136,91,1,0,80,124,1,0,40,0,0,0,0,0,0,0,136,91,1,0,4,125,1,0,40,0,0,0,0,0,0,0,136,91,1,0,128,124,1,0,168,0,0,0,0,0,0,0,96,91,1,0,156,124,1,0,136,91,1,0,176,124,1,0,168,0,0,0,0,0,0,0,136,91,1,0,204,124,1,0,168,0,0,0,0,0,0,0,136,91,1,0,232,124,1,0,168,0,0,0,0,0,0,0,96,91,1,0,85,143,1,0,136,91,1,0,99,143,1,0,224,0,0,0,0,0,0,0,136,91,1,0,115,143,1,0,224,0,0,0,0,0,0,0,136,91,1,0,83,146,1,0,8,0,0,0,0,0,0,0,136,91,1,0,73,151,1,0,40,1,0,0,0,0,0,0,96,91,1,0,84,151,1,0,96,91,1,0,129,185,1,0,136,91,1,0,225,185,1,0,72,1,0,0,0,0,0,0,136,91,1,0,142,185,1,0,88,1,0,0,0,0,0,0,96,91,1,0,175,185,1,0,136,91,1,0,188,185,1,0,56,1,0,0,0,0,0,0,136,91,1,0,195,186,1,0,48,1,0,0,0,0,0,0,136,91,1,0,211,186,1,0,112,1,0,0,0,0,0,0,136,91,1,0,8,187,1,0,72,1,0,0,0,0,0,0,136,91,1,0,228,186,1,0,144,1,0,0,0,0,0,0,187,112,1,0,0,0,0,0,1,0,0,0,85,93,1,0,111,111,1,0,0,0,0,0,1,0,0,0,116,93,1,0,30,115,1,0,0,0,0,0,1,0,0,0,153,93,1,0,18,157,1,0,0,0,0,0,0,0,0,0,191,93,1,0,210,93,1,0,0,0,0,0,0,0,0,0,216,93,1,0,246,93,1,0,0,0,0,0,0,0,0,0,252,93,1,0,26,94,1,0,0,0,0,0,0,0,0,0,32,94,1,0,62,94,1,0,0,0,0,0,0,0,0,0,68,94,1,0,98,94,1,0,0,0,0,0,0,0,0,0,104,94,1,0,134,94,1,0,0,0,0,0,0,0,0,0,140,94,1,0,170,94,1,0,0,0,0,0,0,0,0,0,176,94,1,0,209,146,1,0,0,0,0,0,0,0,0,0,206,94,1,0,94,151,1,0,0,0,0,0,0,0,0,0,217,94,1,0,102,151,1,0,0,0,0,0,0,0,0,0,250,94,1,0,110,151,1,0,0,0,0,0,0,0,0,0,27,95,1,0,63,95,1,0,0,0,0,0,0,0,0,0,75,95,1,0,210,109,1,0,1,0,0,0,0,0,0,0,105,95,1,0,220,109,1,0,2,0,0,0,0,0,0,0,141,95,1,0,170,95,1,0,0,0,0,0,1,0,0,0,176,95,1,0,243,153,1,0,0,0,0,0,0,0,0,0,202,95,1,0,219,95,1,0,2,0,0,0,0,0,0,0,229,95,1,0,247,95,1,0,2,0,0,0,0,0,0,0,2,96,1,0,235,153,1,0,2,0,0,0,0,0,0,0,21,96,1,0,199,146,1,0,2,0,0,0,0,0,0,0,46,96,1,0,224,102,1,0,2,0,0,0,0,0,0,0,96,96,1,0,136,96,1,0,2,0,0,0,0,0,0,0,140,96,1,0,177,96,1,0,1,0,0,0,0,0,0,0,181,96,1,0,207,98,1,0,1,0,0,0,0,0,0,0,202,96,1,0,49,152,1,0,1,0,0,0,0,0,0,0,230,96,1,0,0,97,1,0,1,0,0,0,0,0,0,0,17,97,1,0,229,153,1,0,1,0,0,0,0,0,0,0,50,97,1,0,62,97,1,0,1,0,0,0,0,0,0,0,66,97,1,0,86,97,1,0,1,0,0,0,0,0,0,0,93,97,1,0,136,97,1,0,1,0,0,0,0,0,0,0,145,97,1,0,188,97,1,0,2,0,0,0,0,0,0,0,201,97,1,0,230,97,1,0,1,0,0,0,0,0,0,0,243,97,1,0,33,98,1,0,1,0,0,0,0,0,0,0,43,98,1,0,85,98,1,0,0,0,0,0,0,0,0,0,98,98,1,0,80,109,1,0,2,0,0,0,0,0,0,0,133,98,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,243,103,1,0,1,0,0,0,251,103,1,0,2,0,0,0,2,104,1,0,3,0,0,0,12,104,1,0,4,0,0,0,21,104,1,0,5,0,0,0,28,104,1,0,6,0,0,0,35,104,1,0,7,0,0,0,43,104,1,0,8,0,0,0,52,104,1,0,9,0,0,0,63,104,1,0,10,0,0,0,76,104,1,0,11,0,0,0,85,104,1,0,13,0,0,0,94,104,1,0,17,0,0,0,106,104,1,0,18,0,0,0,115,104,1,0,19,0,0,0,122,104,1,0,20,0,0,0,133,104,1,0,21,0,0,0,147,104,1,0,22,0,0,0,158,104,1,0,23,0,0,0,169,104,1,0,24,0,0,0,183,104,1,0,25,0,0,0,197,104,1,0,26,0,0,0,208,104,1,0,27,0,0,0,231,104,1,0,29,0,0,0,249,104,1,0,30,0,0,0,5,105,1,0,32,0,0,0,23,105,1,0,33,0,0,0,37,105,1,0,34,0,0,0,51,105,1,0,35,0,0,0,62,105,1,0,36,0,0,0,73,105,1,0,37,0,0,0,82,105,1,0,38,0,0,0,100,105,1,0,44,0,0,0,109,105,1,0,45,0,0,0,131,105,1,0,48,0,0,0,140,105,1,0,49,0,0,0,167,105,1,0,50,0,0,0,182,105,1,0,52,0,0,0,194,105,1,0,53,0,0,0,205,105,1,0,54,0,0,0,219,105,1,0,56,0,0,0,229,105,1,0,60,0,0,0,250,105,1,0,62,0,0,0,7,106,1,0,71,0,0,0,22,106,1,0,72,0,0,0,50,106,1,0,77,0,0,0,69,106,1,0,78,0,0,0,82,106,1,0,80,0,0,0,95,106,1,0,84,0,0,0,109,106,1,0,85,0,0,0,123,106,1,0,88,0,0,0,130,106,1,0,89,0,0,0,153,106,1,0,92,0,0,0,163,106,1,0,94,0,0,0,174,106,1,0,98,0,0,0,185,106,1,0,99,0,0,0,195,106,1,0,102,0,0,0,213,106,1,0,103,0,0,0,232,106,1,0,115,0,0,0,240,99,1,0,255,255,255,255,20,6,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,170,170,170,170,204,204,204,204,240,240,240,240,0,255,0,255,0,0,255,255,255,255,255,255,16,0,0,0,0,0,0,0,16,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,40,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,131,123,1,0,4,0,0,0,34,0,0,0,136,123,1,0,3,0,0,0,38,0,0,0,140,123,1,0,4,0,0,0,39,0,0,0,145,123,1,0,2,0,0,0,60,0,0,0,148,123,1,0,2,0,0,0,62,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,224,0,0,0,240,0,0,0,248,0,0,0,252,0,0,0,0,0,0,0,120,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,25,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,26,0,0,0,21,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,23,0,0,0,31,0,0,0,0,0,0,0,104,0,0,0,10,0,0,0,11,0,0,0,32,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,33,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,23,0,0,0,38,0,0,0,0,0,0,0,88,0,0,0,10,0,0,0,39,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,40,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,23,0,0,0,45,0,0,0,0,0,0,0,72,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,46,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,23,0,0,0,52,0,0,0,0,0,0,0,48,0,0,0,53,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,54,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,0,0,0,0,64,0,0,0,61,0,0,0,62,0,0,0,0,0,0,0,136,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,63,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,64,0,0,0,20,0,0,0,21,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,22,0,0,0,68,0,0,0,69,0,0,0,0,0,0,0,208,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,0,0,0,0,192,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,0,0,0,0,176,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,0,0,0,0,152,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,0,0,0,0,32,125,1,0,1,0,0,0,51,125,1,0,2,0,0,0,77,125,1,0,3,0,0,0,98,125,1,0,4,0,0,0,109,125,1,0,5,0,0,0,131,125,1,0,6,0,0,0,149,125,1,0,7,0,0,0,162,125,1,0,8,0,0,0,186,125,1,0,9,0,0,0,206,125,1,0,10,0,0,0,225,125,1,0,11,0,0,0,243,125,1,0,12,0,0,0,246,125,1,0,13,0,0,0,61,154,1,0,14,0,0,0,252,125,1,0,232,3,0,0,3,126,1,0,233,3,0,0,27,126,1,0,234,3,0,0,89,126,1,0,235,3,0,0,127,126,1,0,236,3,0,0,165,126,1,0,237,3,0,0,187,126,1,0,238,3,0,0,209,126,1,0,239,3,0,0,22,127,1,0,240,3,0,0,44,127,1,0,241,3,0,0,68,127,1,0,242,3,0,0,92,127,1,0,243,3,0,0,153,127,1,0,208,7,0,0,196,127,1,0,209,7,0,0,239,127,1,0,210,7,0,0,12,128,1,0,211,7,0,0,76,128,1,0,184,11,0,0,145,128,1,0,204,11,0,0,166,128,1,0,205,11,0,0,175,128,1,0,206,11,0,0,196,128,1,0,207,11,0,0,214,128,1,0,208,11,0,0,228,128,1,0,28,12,0,0,245,128,1,0,128,12,0,0,252,128,1,0,129,12,0,0,4,129,1,0,130,12,0,0,16,129,1,0,131,12,0,0,23,129,1,0,132,12,0,0,33,129,1,0,133,12,0,0,41,129,1,0,134,12,0,0,48,129,1,0,135,12,0,0,52,129,1,0,136,12,0,0,59,129,1,0,137,12,0,0,72,129,1,0,138,12,0,0,82,129,1,0,139,12,0,0,86,129,1,0,140,12,0,0,93,129,1,0,141,12,0,0,115,129,1,0,142,12,0,0,125,129,1,0,143,12,0,0,132,129,1,0,144,12,0,0,137,129,1,0,145,12,0,0,148,129,1,0,146,12,0,0,164,129,1,0,147,12,0,0,176,129,1,0,148,12,0,0,186,129,1,0,149,12,0,0,196,129,1,0,150,12,0,0,201,129,1,0,151,12,0,0,125,129,1,0,152,12,0,0,206,129,1,0,153,12,0,0,217,129,1,0,154,12,0,0,229,129,1,0,155,12,0,0,243,129,1,0,156,12,0,0,201,129,1,0,228,12,0,0,254,129,1,0,229,12,0,0,3,130,1,0,230,12,0,0,8,130,1,0,231,12,0,0,13,130,1,0,232,12,0,0,18,130,1,0,233,12,0,0,23,130,1,0,234,12,0,0,28,130,1,0,235,12,0,0,33,130,1,0,72,13,0,0,38,130,1,0,73,13,0,0,53,130,1,0,74,13,0,0,62,130,1,0,75,13,0,0,73,130,1,0,76,13,0,0,80,130,1,0,77,13,0,0,91,130,1,0,78,13,0,0,95,130,1,0,79,13,0,0,115,130,1,0,80,13,0,0,120,130,1,0,81,13,0,0,127,130,1,0,82,13,0,0,133,130,1,0,83,13,0,0,139,130,1,0,84,13,0,0,145,130,1,0,85,13,0,0,151,130,1,0,86,13,0,0,159,130,1,0,87,13,0,0,165,130,1,0,88,13,0,0,172,130,1,0,89,13,0,0,176,130,1,0,90,13,0,0,180,130,1,0,91,13,0,0,184,130,1,0,92,13,0,0,188,130,1,0,93,13,0,0,192,130,1,0,94,13,0,0,196,130,1,0,95,13,0,0,200,130,1,0,96,13,0,0,205,130,1,0,97,13,0,0,213,130,1,0,98,13,0,0,225,130,1,0,99,13,0,0,237,130,1,0,100,13,0,0,247,130,1,0,101,13,0,0,2,131,1,0,102,13,0,0,14,131,1,0,103,13,0,0,33,131,1,0,104,13,0,0,51,131,1,0,105,13,0,0,63,131,1,0,106,13,0,0,78,131,1,0,107,13,0,0,93,131,1,0,108,13,0,0,109,131,1,0,109,13,0,0,125,131,1,0,110,13,0,0,142,131,1,0,111,13,0,0,159,131,1,0,112,13,0,0,175,131,1,0,113,13,0,0,191,131,1,0,114,13,0,0,208,131,1,0,115,13,0,0,225,131,1,0,116,13,0,0,243,131,1,0,117,13,0,0,5,132,1,0,118,13,0,0,21,132,1,0,119,13,0,0,37,132,1,0,120,13,0,0,54,132,1,0,121,13,0,0,71,132,1,0,122,13,0,0,89,132,1,0,123,13,0,0,107,132,1,0,124,13,0,0,113,132,1,0,172,13,0,0,134,132,1,0,173,13,0,0,149,132,1,0,174,13,0,0,160,132,1,0,175,13,0,0,173,132,1,0,176,13,0,0,189,132,1,0,177,13,0,0,205,132,1,0,178,13,0,0,224,132,1,0,179,13,0,0,1,133,1,0,16,14,0,0,17,133,1,0,17,14,0,0,29,133,1,0,18,14,0,0,49,133,1,0,19,14,0,0,51,133,1,0,20,14,0,0,53,133,1,0,21,14,0,0,55,133,1,0,22,14,0,0,58,133,1,0,23,14,0,0,61,133,1,0,24,14,0,0,64,133,1,0,25,14,0,0,68,133,1,0,26,14,0,0,180,130,1,0,27,14,0,0,200,130,1,0,28,14,0,0,72,133,1,0,29,14,0,0,88,133,1,0,30,14,0,0,95,133,1,0,31,14,0,0,108,133,1,0,32,14,0,0,129,133,1,0,33,14,0,0,152,133,1,0,34,14,0,0,161,133,1,0,35,14,0,0,167,133,1,0,36,14,0,0,182,133,1,0,37,14,0,0,188,133,1,0,38,14,0,0,203,133,1,0,39,14,0,0,209,133,1,0,40,14,0,0,218,133,1,0,116,14,0,0,242,133,1,0,117,14,0,0,255,133,1,0,118,14,0,0,19,134,1,0,120,14,0,0,44,134,1,0,121,14,0,0,72,134,1,0,122,14,0,0,77,134,1,0,123,14,0,0,82,134,1,0,124,14,0,0,87,134,1,0,125,14,0,0,93,134,1,0,126,14,0,0,139,134,1,0,160,15,0,0,188,134,1,0,161,15,0,0,200,134,1,0,210,15,0,0,188,134,1,0,211,15,0,0,175,128,1,0,212,15,0,0,227,134,1,0,213,15,0,0,240,134,1,0,214,15,0,0,246,134,1,0,136,19,0,0,40,135,1,0,137,19,0,0,60,135,1,0,255,255,255,255,0,0,0,0,210,7,0,0,65,135,1,0,141,12,0,0,140,135,1,0,136,19,0,0,150,135,1,0,137,19,0,0,170,135,1,0,16,39,0,0,175,135,1,0,17,39,0,0,208,135,1,0,18,39,0,0,244,135,1,0,19,39,0,0,23,136,1,0,20,39,0,0,83,136,1,0,21,39,0,0,136,136,1,0,22,39,0,0,180,136,1,0,23,39,0,0,221,136,1,0,24,39,0,0,249,136,1,0,25,39,0,0,29,137,1,0,26,39,0,0,73,137,1,0,27,39,0,0,105,137,1,0,28,39,0,0,131,137,1,0,29,39,0,0,156,137,1,0,30,39,0,0,188,137,1,0,31,39,0,0,12,138,1,0,32,39,0,0,65,138,1,0,33,39,0,0,134,138,1,0,34,39,0,0,204,138,1,0,35,39,0,0,4,139,1,0,36,39,0,0,78,139,1,0,37,39,0,0,182,139,1,0,38,39,0,0,234,139,1,0,39,39,0,0,32,140,1,0,40,39,0,0,120,140,1,0,41,39,0,0,166,140,1,0,42,39,0,0,222,140,1,0,43,39,0,0,229,140,1,0,44,39,0,0,254,140,1,0,45,39,0,0,19,141,1,0,46,39,0,0,30,141,1,0,47,39,0,0,54,141,1,0,48,39,0,0,61,141,1,0,49,39,0,0,86,141,1,0,50,39,0,0,104,141,1,0,51,39,0,0,127,141,1,0,52,39,0,0,147,141,1,0,54,39,0,0,166,141,1,0,53,39,0,0,178,141,1,0,55,39,0,0,188,141,1,0,56,39,0,0,203,141,1,0,57,39,0,0,220,141,1,0,58,39,0,0,245,141,1,0,59,39,0,0,10,142,1,0,60,39,0,0,23,142,1,0,61,39,0,0,38,142,1,0,62,39,0,0,54,142,1,0,63,39,0,0,85,142,1,0,64,39,0,0,139,142,1,0,255,255,255,255,0,0,0,0,0,0,0,0,224,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,0,0,0,0,232,0,0,0,94,0,0,0,103,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,0,0,0,0,248,0,0,0,108,0,0,0,109,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,0,0,0,0,8,1,0,0,1,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,255,255,255,255,255,255,255,255,128,0,0,0,0,2,0,0,128,1,0,0,128,0,0,0,128,2,0,0,224,1,0,0,129,0,0,0,32,3,0,0,88,2,0,0,130,0,0,0,0,4,0,0,0,3,0,0,131,0,0,0,128,4,0,0,102,3,0,0,132,0,0,0,0,5,0,0,0,4,0,0,133,0,0,0,64,6,0,0,176,4,0,0,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,150,1,0,77,86,73,90,86,73,90,76,38,150,1,0,112,105,122,71,112,105,122,71,42,150,1,0,84,88,69,84,120,84,73,83,47,150,1,0,84,88,69,84,120,84,73,83,52,150,1,0,32,70,68,80,79,82,65,67,57,150,1,0,84,88,69,84,116,120,116,116,61,150,1,0,33,84,73,83,120,84,73,83,66,150,1,0,70,82,65,84,32,82,65,84,71,150,1,0,84,88,69,84,120,84,73,83,75,150,1,0,84,88,69,84,120,84,73,83,80,150,1,0,32,80,73,90,32,80,73,90,85,150,1,0,88,86,83,56,77,68,78,83,91,150,1,0,67,70,73,65,68,79,86,84,97,150,1,0,70,70,73,65,68,79,86,84,103,150,1,0,87,65,76,85,68,79,86,84,107,150,1,0,73,68,73,77,68,79,86,84,112,150,1,0,73,68,73,77,68,79,86,84,118,150,1,0,32,71,80,77,68,79,86,84,123,150,1,0,32,71,80,77,68,79,86,84,128,150,1,0,69,86,65,87,68,79,86,84,133,150,1,0,102,80,77,66,101,108,103,111,138,150,1,0,102,70,73,71,101,108,103,111,143,150,1,0,77,66,76,73,78,79,75,71,148,150,1,0,77,66,76,73,78,79,75,71,154,150,1,0,71,69,80,74,101,108,103,111,159,150,1,0,71,69,80,74,101,108,103,111,165,150,1,0,84,67,73,80,101,108,103,111,171,150,1,0,102,71,78,80,101,108,103,111,176,150,1,0,73,71,83,46,101,108,103,111,181,150,1,0,67,73,80,84,101,108,103,111,186,150,1,0,70,70,73,84,101,108,103,111,191,150,1,0,70,70,73,84,101,108,103,111,197,150,1,0,84,88,69,84,83,83,79,77,202,150,1,0,84,88,69,84,83,83,79,77,208,150,1,0,84,88,69,84,116,120,116,116,213,150,1,0,84,88,69,84,68,87,83,77,218,150,1,0,84,88,69,84,104,99,42,82,221,150,1,0,84,88,69,84,104,99,42,82,224,150,1,0,84,88,69,84,104,99,42,82,228,150,1,0,84,88,69,84,104,99,42,82,233,150,1,0,84,88,69,84,104,99,42,82,238,150,1,0,84,88,69,84,104,99,42,82,241,150,1,0,84,88,69,84,104,99,42,82,245,150,1,0,84,88,69,84,104,99,42,82,250,150,1,0,84,88,69,84,104,99,42,82,255,150,1,0,84,88,69,84,104,99,42,82,2,151,1,0,84,88,69,84,104,99,42,82,5,151,1,0,84,88,69,84,104,99,42,82,8,151,1,0,71,69,80,77,68,79,86,84,13,151,1,0,71,69,80,77,68,79,86,84,19,151,1,0,86,111,111,77,68,79,86,84,24,151,1,0,32,73,76,70,68,79,86,84,29,151,1,0,32,87,102,86,68,79,86,84,34,151,1,0,67,79,68,88,51,82,80,88,39,151,1,0,109,105,68,68,107,115,100,100,44,151,1,0,109,105,68,68,107,115,100,100,49,151,1,0,100,104,111,114,107,115,100,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,1,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,208,20,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,232,3,0,0,232,3,0,0,79,155,1,0,1,0,0,0,0,0,0,0,88,155,1,0,140,155,1,0,0,0,0,0,0,0,0,0,152,155,1,0,185,155,1,0,0,0,0,0,0,0,0,0,198,155,1,0,245,155,1,0,2,0,0,0,0,0,0,0,4,156,1,0,64,156,1,0,2,0,0,0,0,0,0,0,80,156,1,0,128,156,1,0,0,0,0,0,0,0,0,0,132,156,1,0,163,156,1,0,0,0,0,0,0,0,0,0,169,156,1,0,193,156,1,0,1,0,0,0,0,0,0,0,202,156,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,121,0,0,0,122,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127,0,0,0,128,0,0,0,129,0,0,0,130,0,0,0,131,0,0,0,132,0,0,0,133,0,0,0,134,0,0,0,135,0,0,0,136,0,0,0,137,0,0,0,138,0,0,0,139,0,0,0,140,0,0,0,141,0,0,0,142,0,0,0,143,0,0,0,144,0,0,0,145,0,0,0,146,0,0,0,147,0,0,0,148,0,0,0,149,0,0,0,150,0,0,0,151,0,0,0,145,0,0,0,146,0,0,0,147,0,0,0,152,0,0,0,153,0,0,0,154,0,0,0,155,0,0,0,156,0,0,0,157,0,0,0,158,0,0,0,159,0,0,0,160,0,0,0,161,0,0,0,155,0,0,0,162,0,0,0,163,0,0,0,158,0,0,0,159,0,0,0,164,0,0,0,165,0,0,0,155,0,0,0,166,0,0,0,167,0,0,0,158,0,0,0,159,0,0,0,168,0,0,0,154,0,0,0,155,0,0,0,169,0,0,0,157,0,0,0,158,0,0,0,159,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,56,165,1,0,1,0,0,0,195,157,1,0,80,0,0,0,198,157,1,0,81,0,0,0,202,157,1,0,2,0,0,0,207,157,1,0,3,0,0,0,211,157,1,0,4,0,0,0,215,157,1,0,5,0,0,0,220,157,1,0,6,0,0,0,226,157,1,0,7,0,0,0,232,157,1,0,8,0,0,0,236,157,1,0,9,0,0,0,241,157,1,0,10,0,0,0,246,157,1,0,11,0,0,0,251,157,1,0,12,0,0,0,255,157,1,0,13,0,0,0,4,158,1,0,14,0,0,0,9,158,1,0,15,0,0,0,14,158,1,0,16,0,0,0,18,158,1,0,17,0,0,0,23,158,1,0,18,0,0,0,28,158,1,0,19,0,0,0,32,158,1,0,20,0,0,0,36,158,1,0,21,0,0,0,40,158,1,0,22,0,0,0,45,158,1,0,23,0,0,0,50,158,1,0,24,0,0,0,55,158,1,0,25,0,0,0,60,158,1,0,26,0,0,0,64,158,1,0,27,0,0,0,69,158,1,0,28,0,0,0,74,158,1,0,29,0,0,0,80,158,1,0,30,0,0,0,86,158,1,0,31,0,0,0,91,158,1,0,32,0,0,0,97,158,1,0,33,0,0,0,103,158,1,0,34,0,0,0,109,158,1,0,35,0,0,0,114,158,1,0,36,0,0,0,118,158,1,0,37,0,0,0,122,158,1,0,38,0,0,0,128,158,1,0,39,0,0,0,134,158,1,0,40,0,0,0,139,158,1,0,41,0,0,0,147,158,1,0,43,0,0,0,242,165,1,0,42,0,0,0,236,165,1,0,45,0,0,0,1,166,1,0,46,0,0,0,155,158,1,0,47,0,0,0,159,158,1,0,48,0,0,0,164,158,1,0,49,0,0,0,16,166,1,0,44,0,0,0,169,158,1,0,50,0,0,0,20,166,1,0,51,0,0,0,26,166,1,0,52,0,0,0,174,158,1,0,53,0,0,0,178,158,1,0,54,0,0,0,182,158,1,0,55,0,0,0,186,158,1,0,56,0,0,0,190,158,1,0,57,0,0,0,194,158,1,0,58,0,0,0,198,158,1,0,59,0,0,0,203,158,1,0,60,0,0,0,207,158,1,0,61,0,0,0,212,158,1,0,62,0,0,0,217,158,1,0,63,0,0,0,222,158,1,0,64,0,0,0,227,158,1,0,65,0,0,0,231,158,1,0,66,0,0,0,235,158,1,0,67,0,0,0,239,158,1,0,68,0,0,0,243,158,1,0,69,0,0,0,247,158,1,0,70,0,0,0,251,158,1,0,71,0,0,0,0,159,1,0,72,0,0,0,5,159,1,0,73,0,0,0,10,159,1,0,74,0,0,0,15,159,1,0,75,0,0,0,20,159,1,0,76,0,0,0,25,159,1,0,77,0,0,0,30,159,1,0,78,0,0,0,35,159,1,0,79,0,0,0,41,159,1,0,83,0,0,0,47,159,1,0,82,0,0,0,54,159,1,0,84,0,0,0,61,159,1,0,85,0,0,0,65,159,1,0,87,0,0,0,70,159,1,0,86,0,0,0,75,159,1,0,88,0,0,0,80,159,1,0,89,0,0,0,86,159,1,0,90,0,0,0,93,159,1,0,91,0,0,0,99,159,1,0,92,0,0,0,106,159,1,0,93,0,0,0,112,159,1,0,94,0,0,0,118,159,1,0,95,0,0,0,124,159,1,0,96,0,0,0,130,159,1,0,97,0,0,0,135,159,1,0,98,0,0,0,140,159,1,0,99,0,0,0,144,159,1,0,100,0,0,0,149,159,1,0,101,0,0,0,155,159,1,0,102,0,0,0,119,167,1,0,103,0,0,0,159,159,1,0,104,0,0,0,165,159,1,0,105,0,0,0,169,159,1,0,106,0,0,0,175,159,1,0,107,0,0,0,248,172,1,0,108,0,0,0,180,159,1,0,108,0,0,0,180,159,1,0,109,0,0,0,185,159,1,0,110,0,0,0,191,159,1,0,111,0,0,0,200,159,1,0,112,0,0,0,206,159,1,0,113,0,0,0,212,159,1,0,114,0,0,0,218,159,1,0,115,0,0,0,225,159,1,0,116,0,0,0,232,159,1,0,117,0,0,0,239,159,1,0,119,0,0,0,56,174,1,0,120,0,0,0,246,159,1,0,118,0,0,0,253,159,1,0,0,0,0,0,197,31,10,0,4,0,0,0,4,0,0,0,12,0,0,0,12,0,0,0,2,0,0,0,8,0,0,0,2,0,0,0,0,0,0,0,4,0,0,0,4,0,0,0,12,0,0,0,12,0,0,0,2,0,0,0,8,0,0,0,1,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,171,0,0,0,0,0,16,0,172,0,0,0,0,0,24,0,173,0,0,0,0,0,32,0,174,0,0,0,0,0,40,0,175,0,0,0,0,0,48,0,176,0,0,0,0,0,56,0,177,0,0,0,0,0,57,0,178,0,0,0,0,0,60,0,179,0,0,0,0,0,64,0,180,0,0,0,0,0,80,0,181,0,0,0,0,0,88,0,182,0,0,0,0,0,96,0,183,0,0,0,0,0,104,0,184,0,0,0,0,0,112,0,185,0,0,0,0,0,120,0,186,0,0,0,0,0,121,0,187,0,0,0,0,0,124,0,188,0,0,0,0,0,128,0,189,0,0,0,0,0,144,0,190,0,0,0,0,0,152,0,191,0,0,0,0,0,160,0,192,0,0,0,0,0,168,0,193,0,0,0,0,0,176,0,194,0,0,0,0,0,184,0,195,0,0,0,0,0,185,0,196,0,0,0,0,0,208,0,197,0,0,0,0,0,232,0,198,0,0,0,0,0,240,0,199,0,0,0,0,0,248,0,200,0,0,0,0,0,249,0,201,0,0,0,0,0,250,0,202,0,0,0,0,0,251,0,203,0,0,0,0,0,0,1,204,0,0,0,0,0,8,1,205,0,0,0,0,0,16,1,206,0,0,0,0,0,24,1,207,0,0,0,0,0,32,1,208,0,0,0,0,0,40,1,209,0,0,0,0,0,48,1,210,0,0,0,0,0,56,1,211,0,0,0,0,0,57,1,212,0,0,0,0,0,58,1,213,0,0,0,0,0,59,1,214,0,0,0,0,0,60,1,215,0,0,0,0,0,64,1,216,0,0,0,0,0,72,1,217,0,0,0,0,0,80,1,218,0,0,0,0,0,88,1,219,0,0,0,0,0,96,1,220,0,0,0,0,0,104,1,221,0,0,0,0,0,112,1,222,0,0,0,0,0,120,1,223,0,0,0,0,0,121,1,224,0,0,0,0,0,122,1,225,0,0,0,0,0,123,1,226,0,0,0,0,0,128,1,227,0,0,0,0,0,136,1,228,0,0,0,0,0,144,1,229,0,0,0,0,0,152,1,230,0,0,0,0,0,160,1,231,0,0,0,0,0,168,1,232,0,0,0,0,0,176,1,233,0,0,0,0,0,184,1,234,0,0,0,0,0,185,1,235,0,0,0,0,0,186,1,236,0,0,0,0,0,187,1,237,0,0,0,0,0,192,1,238,0,0,0,0,0,200,1,239,0,0,0,0,0,208,1,240,0,0,0,0,0,216,1,241,0,0,0,0,0,224,1,242,0,0,0,0,0,232,1,243,0,0,0,0,0,240,1,244,0,0,0,0,0,248,1,245,0,0,0,0,0,249,1,246,0,0,0,0,0,250,1,247,0,0,0,0,0,251,1,248,0,0,0,0,0,0,2,249,0,0,0,0,0,16,2,250,0,0,0,0,0,24,2,251,0,0,0,0,0,32,2,252,0,0,0,0,0,40,2,253,0,0,0,0,0,48,2,254,0,0,0,0,0,56,2,255,0,0,0,0,0,57,2,0,1,0,0,0,0,60,2,1,1,0,0,0,0,64,2,2,1,0,0,0,0,80,2,3,1,0,0,0,0,88,2,4,1,0,0,0,0,96,2,5,1,0,0,0,0,104,2,6,1,0,0,0,0,112,2,7,1,0,0,0,0,120,2,8,1,0,0,0,0,121,2,9,1,0,0,0,0,124,2,10,1,0,0,0,0,128,2,11,1,0,0,0,0,144,2,12,1,0,0,0,0,152,2,13,1,0,0,0,0,160,2,14,1,0,0,0,0,168,2,15,1,0,0,0,0,176,2,16,1,0,0,0,0,184,2,17,1,0,0,0,0,185,2,18,1,0,0,0,0,208,2,19,1,0,0,0,0,232,2,20,1,0,0,0,0,240,2,21,1,0,0,0,0,248,2,22,1,0,0,0,0,249,2,23,1,0,0,0,0,250,2,24,1,0,0,0,0,251,2,25,1,0,0,0,0,0,4,26,1,0,0,0,0,16,4,27,1,0,0,0,0,24,4,28,1,0,0,0,0,32,4,29,1,0,0,0,0,40,4,30,1,0,0,0,0,48,4,31,1,0,0,0,0,56,4,32,1,0,0,0,0,57,4,33,1,0,0,0,0,64,4,34,1,0,0,0,0,80,4,35,1,0,0,0,0,88,4,36,1,0,0,0,0,96,4,37,1,0,0,0,0,104,4,38,1,0,0,0,0,112,4,39,1,0,0,0,0,120,4,40,1,0,0,0,0,121,4,41,1,0,0,0,0,128,4,42,1,0,0,0,0,144,4,43,1,0,0,0,0,152,4,44,1,0,0,0,0,160,4,45,1,0,0,0,0,168,4,46,1,0,0,0,0,176,4,47,1,0,0,0,0,184,4,48,1,0,0,0,0,185,4,49,1,0,0,0,0,208,4,50,1,0,0,0,0,232,4,51,1,0,0,0,0,240,4,52,1,0,0,0,0,248,4,53,1,0,0,0,0,249,4,54,1,0,0,0,0,250,4,55,1,0,0,0,0,251,4,56,1,0,0,0,0,0,6,57,1,0,0,0,0,16,6,58,1,0,0,0,0,24,6,59,1,0,0,0,0,32,6,60,1,0,0,0,0,40,6,61,1,0,0,0,0,48,6,62,1,0,0,0,0,56,6,63,1,0,0,0,0,57,6,64,1,0,0,0,0,64,6,65,1,0,0,0,0,80,6,66,1,0,0,0,0,88,6,67,1,0,0,0,0,96,6,68,1,0,0,0,0,104,6,69,1,0,0,0,0,112,6,70,1,0,0,0,0,120,6,71,1,0,0,0,0,121,6,72,1,0,0,0,0,128,6,73,1,0,0,0,0,144,6,74,1,0,0,0,0,152,6,75,1,0,0,0,0,160,6,76,1,0,0,0,0,168,6,77,1,0,0,0,0,176,6,78,1,0,0,0,0,184,6,79,1,0,0,0,0,185,6,80,1,0,0,0,0,192,6,81,1,0,0,0,0,200,6,82,1,0,0,0,0,208,6,83,1,0,0,0,0,232,6,84,1,0,0,0,0,240,6,85,1,0,0,0,0,248,6,86,1,0,0,0,0,249,6,87,1,0,0,0,0,250,6,88,1,0,0,0,0,251,6,89,1,0,0,0,0,0,8,90,1,0,0,0,0,16,8,91,1,0,0,0,0,24,8,92,1,0,0,0,0,32,8,93,1,0,0,0,0,40,8,94,1,0,0,0,0,48,8,95,1,0,0,0,0,56,8,96,1,0,0,0,0,57,8,97,1,0,0,0,0,58,8,98,1,0,0,0,0,59,8,99,1,0,0,0,0,60,8,100,1,0,0,0,0,64,8,101,1,0,0,0,0,80,8,102,1,0,0,0,0,88,8,103,1,0,0,0,0,96,8,104,1,0,0,0,0,104,8,105,1,0,0,0,0,112,8,106,1,0,0,0,0,120,8,107,1,0,0,0,0,121,8,108,1,0,0,0,0,122,8,109,1,0,0,0,0,123,8,110,1,0,0,0,0,128,8,111,1,0,0,0,0,144,8,112,1,0,0,0,0,152,8,113,1,0,0,0,0,160,8,114,1,0,0,0,0,168,8,115,1,0,0,0,0,176,8,116,1,0,0,0,0,184,8,117,1,0,0,0,0,185,8,118,1,0,0,0,0,186,8,119,1,0,0,0,0,187,8,120,1,0,0,0,0,192,8,121,1,0,0,0,0,208,8,122,1,0,0,0,0,216,8,123,1,0,0,0,0,224,8,124,1,0,0,0,0,232,8,125,1,0,0,0,0,240,8,126,1,0,0,0,0,248,8,127,1,0,0,0,0,249,8,128,1,0,0,0,0,250,8,129,1,0,0,0,0,251,8,130,1,0,0,0,0,0,10,131,1,0,0,0,0,16,10,132,1,0,0,0,0,24,10,133,1,0,0,0,0,32,10,134,1,0,0,0,0,40,10,135,1,0,0,0,0,48,10,136,1,0,0,0,0,56,10,137,1,0,0,0,0,57,10,138,1,0,0,0,0,60,10,139,1,0,0,0,0,64,10,140,1,0,0,0,0,80,10,141,1,0,0,0,0,88,10,142,1,0,0,0,0,96,10,143,1,0,0,0,0,104,10,144,1,0,0,0,0,112,10,145,1,0,0,0,0,120,10,146,1,0,0,0,0,121,10,147,1,0,0,0,0,124,10,148,1,0,0,0,0,128,10,149,1,0,0,0,0,144,10,150,1,0,0,0,0,152,10,151,1,0,0,0,0,160,10,152,1,0,0,0,0,168,10,153,1,0,0,0,0,176,10,154,1,0,0,0,0,184,10,155,1,0,0,0,0,185,10,156,1,0,0,0,0,208,10,157,1,0,0,0,0,216,10,158,1,0,0,0,0,224,10,159,1,0,0,0,0,232,10,160,1,0,0,0,0,240,10,161,1,0,0,0,0,248,10,162,1,0,0,0,0,249,10,163,1,0,0,0,0,0,12,164,1,0,0,0,0,16,12,165,1,0,0,0,0,24,12,166,1,0,0,0,0,32,12,167,1,0,0,0,0,40,12,168,1,0,0,0,0,48,12,169,1,0,0,0,0,56,12,170,1,0,0,0,0,57,12,171,1,0,0,0,0,58,12,172,1,0,0,0,0,59,12,173,1,0,0,0,0,64,12,174,1,0,0,0,0,80,12,175,1,0,0,0,0,88,12,176,1,0,0,0,0,96,12,177,1,0,0,0,0,104,12,178,1,0,0,0,0,112,12,179,1,0,0,0,0,120,12,180,1,0,0,0,0,121,12,181,1,0,0,0,0,122,12,182,1,0,0,0,0,123,12,183,1,0,0,0,0,128,12,184,1,0,0,0,0,144,12,185,1,0,0,0,0,152,12,186,1,0,0,0,0,160,12,187,1,0,0,0,0,168,12,188,1,0,0,0,0,176,12,189,1,0,0,0,0,184,12,190,1,0,0,0,0,185,12,191,1,0,0,0,0,186,12,192,1,0,0,0,0,187,12,193,1,0,0,0,0,208,12,194,1,0,0,0,0,216,12,195,1,0,0,0,0,224,12,196,1,0,0,0,0,232,12,197,1,0,0,0,0,240,12,198,1,0,0,0,0,248,12,199,1,0,0,0,0,249,12,200,1,0,0,0,0,252,12,201,1,0,0,0,0,16,14,202,1,0,0,0,0,24,14,203,1,0,0,0,0,32,14,204,1,0,0,0,0,40,14,205,1,0,0,0,0,48,14,206,1,0,0,0,0,56,14,207,1,0,0,0,0,57,14,208,1,0,0,0,0,80,14,209,1,0,0,0,0,88,14,210,1,0,0,0,0,96,14,211,1,0,0,0,0,104,14,212,1,0,0,0,0,112,14,213,1,0,0,0,0,120,14,214,1,0,0,0,0,121,14,215,1,0,0,0,0,144,14,216,1,0,0,0,0,152,14,217,1,0,0,0,0,160,14,218,1,0,0,0,0,168,14,219,1,0,0,0,0,176,14,220,1,0,0,0,0,184,14,221,1,0,0,0,0,185,14,222,1,0,0,0,0,208,14,223,1,0,0,0,0,216,14,224,1,0,0,0,0,224,14,225,1,0,0,0,0,232,14,226,1,0,0,0,0,240,14,227,1,0,0,0,0,248,14,228,1,0,0,0,0,249,14,229,1,0,0,0,0,252,14,230,1,0,0,0,0,0,16,231,1,0,0,0,0,16,16,232,1,0,0,0,0,24,16,233,1,0,0,0,0,32,16,234,1,0,0,0,0,40,16,235,1,0,0,0,0,48,16,236,1,0,0,0,0,56,16,237,1,0,0,0,0,57,16,238,1,0,0,0,0,58,16,239,1,0,0,0,0,59,16,240,1,0,0,0,0,60,16,241,1,0,0,0,0,128,16,242,1,0,0,0,0,144,16,243,1,0,0,0,0,152,16,244,1,0,0,0,0,160,16,245,1,0,0,0,0,168,16,246,1,0,0,0,0,176,16,247,1,0,0,0,0,184,16,248,1,0,0,0,0,185,16,249,1,0,0,0,0,186,16,250,1,0,0,0,0,187,16,251,1,0,0,0,0,188,16,252,1,0,0,0,0,192,16,253,1,0,0,0,0,208,16,254,1,0,0,0,0,216,16,255,1,0,0,0,0,224,16,0,2,0,0,0,0,232,16,1,2,0,0,0,0,240,16,2,2,0,0,0,0,248,16,3,2,0,0,0,0,249,16,4,2,0,0,0,0,250,16,5,2,0,0,0,0,251,16,6,2,0,0,0,0,252,16,7,2,0,0,0,0,0,17,8,2,0,0,0,0,16,17,9,2,0,0,0,0,24,17,10,2,0,0,0,0,32,17,11,2,0,0,0,0,40,17,12,2,0,0,0,0,48,17,13,2,0,0,0,0,56,17,14,2,0,0,0,0,57,17,15,2,0,0,0,0,58,17,16,2,0,0,0,0,59,17,17,2,0,0,0,0,60,17,18,2,0,0,0,0,64,17,19,2,0,0,0,0,80,17,20,2,0,0,0,0,88,17,21,2,0,0,0,0,96,17,22,2,0,0,0,0,104,17,23,2,0,0,0,0,112,17,24,2,0,0,0,0,120,17,25,2,0,0,0,0,121,17,26,2,0,0,0,0,122,17,27,2,0,0,0,0,123,17,28,2,0,0,0,0,124,17,29,2,0,0,0,0,128,17,30,2,0,0,0,0,144,17,31,2,0,0,0,0,152,17,32,2,0,0,0,0,160,17,33,2,0,0,0,0,168,17,34,2,0,0,0,0,176,17,35,2,0,0,0,0,184,17,36,2,0,0,0,0,185,17,37,2,0,0,0,0,186,17,38,2,0,0,0,0,187,17,39,2,0,0,0,0,188,17,40,2,0,0,0,0,192,17,41,2,0,0,0,0,208,17,42,2,0,0,0,0,216,17,43,2,0,0,0,0,224,17,44,2,0,0,0,0,232,17,45,2,0,0,0,0,240,17,46,2,0,0,0,0,248,17,47,2,0,0,0,0,249,17,48,2,0,0,0,0,250,17,49,2,0,0,0,0,251,17,50,2,0,0,0,0,252,17,51,2,0,0,0,0,192,19,52,2,0,0,0,0,208,19,53,2,0,0,0,0,216,19,54,2,0,0,0,0,224,19,55,2,0,0,0,0,232,19,56,2,0,0,0,0,240,19,57,2,0,0,0,0,248,19,58,2,0,0,0,0,249,19,59,2,0,0,0,0,250,19,60,2,0,0,0,0,251,19,61,2,0,0,0,0,252,19,62,2,0,0,0,0,0,32,63,2,0,0,0,0,8,32,64,2,0,0,0,0,16,32,65,2,0,0,0,0,24,32,66,2,0,0,0,0,32,32,67,2,0,0,0,0,40,32,68,2,0,0,0,0,48,32,69,2,0,0,0,0,56,32,70,2,0,0,0,0,57,32,71,2,0,0,0,0,58,32,72,2,0,0,0,0,59,32,73,2,0,0,0,0,60,32,74,2,0,0,0,0,64,32,75,2,0,0,0,0,72,32,76,2,0,0,0,0,80,32,77,2,0,0,0,0,88,32,78,2,0,0,0,0,96,32,79,2,0,0,0,0,104,32,80,2,0,0,0,0,112,32,81,2,0,0,0,0,120,32,82,2,0,0,0,0,121,32,83,2,0,0,0,0,122,32,84,2,0,0,0,0,123,32,85,2,0,0,0,0,124,32,86,2,0,0,0,0,128,32,87,2,0,0,0,0,136,32,88,2,0,0,0,0,144,32,89,2,0,0,0,0,152,32,90,2,0,0,0,0,160,32,91,2,0,0,0,0,168,32,92,2,0,0,0,0,176,32,93,2,0,0,0,0,184,32,94,2,0,0,0,0,185,32,95,2,0,0,0,0,186,32,96,2,0,0,0,0,187,32,97,2,0,0,0,0,188,32,98,2,0,0,0,0,192,32,99,2,0,0,0,0,200,32,100,2,0,0,0,0,208,32,101,2,0,0,0,0,216,32,102,2,0,0,0,0,224,32,103,2,0,0,0,0,232,32,104,2,0,0,0,0,240,32,105,2,0,0,0,0,248,32,106,2,0,0,0,0,249,32,107,2,0,0,0,0,250,32,108,2,0,0,0,0,251,32,109,2,0,0,0,0,252,32,110,2,0,0,0,0,0,33,111,2,0,0,0,0,8,33,112,2,0,0,0,0,16,33,113,2,0,0,0,0,24,33,114,2,0,0,0,0,32,33,115,2,0,0,0,0,40,33,116,2,0,0,0,0,48,33,117,2,0,0,0,0,56,33,118,2,0,0,0,0,57,33,119,2,0,0,0,0,58,33,120,2,0,0,0,0,59,33,121,2,0,0,0,0,60,33,122,2,0,0,0,0,64,33,123,2,0,0,0,0,72,33,124,2,0,0,0,0,80,33,125,2,0,0,0,0,88,33,126,2,0,0,0,0,96,33,127,2,0,0,0,0,104,33,128,2,0,0,0,0,112,33,129,2,0,0,0,0,120,33,130,2,0,0,0,0,121,33,131,2,0,0,0,0,122,33,132,2,0,0,0,0,123,33,133,2,0,0,0,0,124,33,134,2,0,0,0,0,128,33,135,2,0,0,0,0,136,33,136,2,0,0,0,0,144,33,137,2,0,0,0,0,152,33,138,2,0,0,0,0,160,33,139,2,0,0,0,0,168,33,140,2,0,0,0,0,176,33,141,2,0,0,0,0,184,33,142,2,0,0,0,0,185,33,143,2,0,0,0,0,186,33,144,2,0,0,0,0,187,33,145,2,0,0,0,0,188,33,146,2,0,0,0,0,192,33,147,2,0,0,0,0,200,33,148,2,0,0,0,0,208,33,149,2,0,0,0,0,216,33,150,2,0,0,0,0,224,33,151,2,0,0,0,0,232,33,152,2,0,0,0,0,240,33,153,2,0,0,0,0,248,33,154,2,0,0,0,0,249,33,155,2,0,0,0,0,250,33,156,2,0,0,0,0,251,33,157,2,0,0,0,0,252,33,158,2,0,0,0,0,192,35,159,2,0,0,0,0,200,35,160,2,0,0,0,0,208,35,161,2,0,0,0,0,216,35,162,2,0,0,0,0,224,35,163,2,0,0,0,0,232,35,164,2,0,0,0,0,240,35,165,2,0,0,0,0,248,35,166,2,0,0,0,0,249,35,167,2,0,0,0,0,250,35,168,2,0,0,0,0,251,35,169,2,0,0,0,0,252,35,170,2,0,0,0,0,0,48,171,2,0,0,0,0,8,48,172,2,0,0,0,0,16,48,173,2,0,0,0,0,24,48,174,2,0,0,0,0,32,48,175,2,0,0,0,0,40,48,176,2,0,0,0,0,48,48,177,2,0,0,0,0,56,48,178,2,0,0,0,0,57,48,179,2,0,0,0,0,58,48,180,2,0,0,0,0,59,48,181,2,0,0,0,0,60,48,182,2,0,0,0,0,64,48,183,2,0,0,0,0,72,48,184,2,0,0,0,0,80,48,185,2,0,0,0,0,88,48,186,2,0,0,0,0,96,48,187,2,0,0,0,0,104,48,188,2,0,0,0,0,112,48,189,2,0,0,0,0,120,48,190,2,0,0,0,0,121,48,191,2,0,0,0,0,122,48,192,2,0,0,0,0,123,48,193,2,0,0,0,0,124,48,194,2,0,0,0,0,128,48,195,2,0,0,0,0,136,48,196,2,0,0,0,0,144,48,197,2,0,0,0,0,152,48,198,2,0,0,0,0,160,48,199,2,0,0,0,0,168,48,200,2,0,0,0,0,176,48,201,2,0,0,0,0,184,48,202,2,0,0,0,0,185,48,203,2,0,0,0,0,186,48,204,2,0,0,0,0,187,48,205,2,0,0,0,0,188,48,206,2,0,0,0,0,192,48,207,2,0,0,0,0,200,48,208,2,0,0,0,0,208,48,209,2,0,0,0,0,216,48,210,2,0,0,0,0,224,48,211,2,0,0,0,0,232,48,212,2,0,0,0,0,240,48,213,2,0,0,0,0,248,48,214,2,0,0,0,0,249,48,215,2,0,0,0,0,250,48,216,2,0,0,0,0,251,48,217,2,0,0,0,0,252,48,218,2,0,0,0,0,0,49,219,2,0,0,0,0,8,49,220,2,0,0,0,0,16,49,221,2,0,0,0,0,24,49,222,2,0,0,0,0,32,49,223,2,0,0,0,0,40,49,224,2,0,0,0,0,48,49,225,2,0,0,0,0,56,49,226,2,0,0,0,0,57,49,227,2,0,0,0,0,58,49,228,2,0,0,0,0,59,49,229,2,0,0,0,0,60,49,230,2,0,0,0,0,64,49,231,2,0,0,0,0,72,49,232,2,0,0,0,0,80,49,233,2,0,0,0,0,88,49,234,2,0,0,0,0,96,49,235,2,0,0,0,0,104,49,236,2,0,0,0,0,112,49,237,2,0,0,0,0,120,49,238,2,0,0,0,0,121,49,239,2,0,0,0,0,122,49,240,2,0,0,0,0,123,49,241,2,0,0,0,0,124,49,242,2,0,0,0,0,128,49,243,2,0,0,0,0,136,49,244,2,0,0,0,0,144,49,245,2,0,0,0,0,152,49,246,2,0,0,0,0,160,49,247,2,0,0,0,0,168,49,248,2,0,0,0,0,176,49,249,2,0,0,0,0,184,49,250,2,0,0,0,0,185,49,251,2,0,0,0,0,186,49,252,2,0,0,0,0,187,49,253,2,0,0,0,0,188,49,254,2,0,0,0,0,192,49,255,2,0,0,0,0,200,49,0,3,0,0,0,0,208,49,1,3,0,0,0,0,216,49,2,3,0,0,0,0,224,49,3,3,0,0,0,0,232,49,4,3,0,0,0,0,240,49,5,3,0,0,0,0,248,49,6,3,0,0,0,0,249,49,7,3,0,0,0,0,250,49,8,3,0,0,0,0,251,49,9,3,0,0,0,0,252,49,10,3,0,0,0,0,192,51,11,3,0,0,0,0,200,51,12,3,0,0,0,0,208,51,13,3,0,0,0,0,216,51,14,3,0,0,0,0,224,51,15,3,0,0,0,0,232,51,16,3,0,0,0,0,240,51,17,3,0,0,0,0,248,51,18,3,0,0,0,0,249,51,19,3,0,0,0,0,250,51,20,3,0,0,0,0,251,51,21,3,0,0,0,0,252,51,22,3,0,0,0,0,0,64,23,3,0,0,0,0,16,64,24,3,0,0,0,0,24,64,25,3,0,0,0,0,32,64,26,3,0,0,0,0,40,64,27,3,0,0,0,0,48,64,28,3,0,0,0,0,56,64,29,3,0,0,0,0,57,64,30,3,0,0,0,0,64,64,31,3,0,0,0,0,80,64,32,3,0,0,0,0,88,64,33,3,0,0,0,0,96,64,34,3,0,0,0,0,104,64,35,3,0,0,0,0,112,64,36,3,0,0,0,0,120,64,37,3,0,0,0,0,121,64,38,3,0,0,0,0,128,64,39,3,0,0,0,0,144,64,40,3,0,0,0,0,152,64,41,3,0,0,0,0,160,64,42,3,0,0,0,0,168,64,43,3,0,0,0,0,176,64,44,3,0,0,0,0,184,64,45,3,0,0,0,0,185,64,46,3,0,0,0,0,192,64,47,3,0,0,0,0,208,64,48,3,0,0,0,0,216,64,49,3,0,0,0,0,224,64,50,3,0,0,0,0,232,64,51,3,0,0,0,0,240,64,52,3,0,0,0,0,248,64,53,3,0,0,0,0,249,64,54,3,0,0,0,0,0,65,55,3,0,0,0,0,16,65,56,3,0,0,0,0,24,65,57,3,0,0,0,0,32,65,58,3,0,0,0,0,40,65,59,3,0,0,0,0,48,65,60,3,0,0,0,0,56,65,61,3,0,0,0,0,57,65,62,3,0,0,0,0,58,65,63,3,0,0,0,0,59,65,64,3,0,0,0,0,60,65,65,3,0,0,0,0,128,65,66,3,0,0,0,0,144,65,67,3,0,0,0,0,152,65,68,3,0,0,0,0,160,65,69,3,0,0,0,0,168,65,70,3,0,0,0,0,176,65,71,3,0,0,0,0,184,65,72,3,0,0,0,0,185,65,73,3,0,0,0,0,186,65,74,3,0,0,0,0,187,65,75,3,0,0,0,0,188,65,76,3,0,0,0,0,208,65,77,3,0,0,0,0,232,65,78,3,0,0,0,0,240,65,79,3,0,0,0,0,248,65,80,3,0,0,0,0,249,65,81,3,0,0,0,0,250,65,82,3,0,0,0,0,251,65,83,3,0,0,0,0,0,66,84,3,0,0,0,0,16,66,85,3,0,0,0,0,24,66,86,3,0,0,0,0,32,66,87,3,0,0,0,0,40,66,88,3,0,0,0,0,48,66,89,3,0,0,0,0,56,66,90,3,0,0,0,0,57,66,91,3,0,0,0,0,64,66,92,3,0,0,0,0,80,66,93,3,0,0,0,0,88,66,94,3,0,0,0,0,96,66,95,3,0,0,0,0,104,66,96,3,0,0,0,0,112,66,97,3,0,0,0,0,120,66,98,3,0,0,0,0,121,66,99,3,0,0,0,0,128,66,100,3,0,0,0,0,144,66,101,3,0,0,0,0,152,66,102,3,0,0,0,0,160,66,103,3,0,0,0,0,168,66,104,3,0,0,0,0,176,66,105,3,0,0,0,0,184,66,106,3,0,0,0,0,185,66,107,3,0,0,0,0,192,66,108,3,0,0,0,0,208,66,109,3,0,0,0,0,216,66,110,3,0,0,0,0,224,66,111,3,0,0,0,0,232,66,112,3,0,0,0,0,240,66,113,3,0,0,0,0,248,66,114,3,0,0,0,0,249,66,115,3,0,0,0,0,0,68,116,3,0,0,0,0,16,68,117,3,0,0,0,0,24,68,118,3,0,0,0,0,32,68,119,3,0,0,0,0,40,68,120,3,0,0,0,0,48,68,121,3,0,0,0,0,56,68,122,3,0,0,0,0,57,68,123,3,0,0,0,0,64,68,124,3,0,0,0,0,80,68,125,3,0,0,0,0,88,68,126,3,0,0,0,0,96,68,127,3,0,0,0,0,104,68,128,3,0,0,0,0,112,68,129,3,0,0,0,0,120,68,130,3,0,0,0,0,121,68,131,3,0,0,0,0,128,68,132,3,0,0,0,0,144,68,133,3,0,0,0,0,152,68,134,3,0,0,0,0,160,68,135,3,0,0,0,0,168,68,136,3,0,0,0,0,176,68,137,3,0,0,0,0,184,68,138,3,0,0,0,0,185,68,139,3,0,0,0,0,192,68,140,3,0,0,0,0,208,68,141,3,0,0,0,0,216,68,142,3,0,0,0,0,224,68,143,3,0,0,0,0,232,68,144,3,0,0,0,0,240,68,145,3,0,0,0,0,248,68,146,3,0,0,0,0,249,68,147,3,0,0,0,0,250,68,148,3,0,0,0,0,251,68,149,3,0,0,0,0,252,68,150,3,0,0,0,0,0,70,151,3,0,0,0,0,16,70,152,3,0,0,0,0,24,70,153,3,0,0,0,0,32,70,154,3,0,0,0,0,40,70,155,3,0,0,0,0,48,70,156,3,0,0,0,0,56,70,157,3,0,0,0,0,57,70,158,3,0,0,0,0,64,70,159,3,0,0,0,0,80,70,160,3,0,0,0,0,88,70,161,3,0,0,0,0,96,70,162,3,0,0,0,0,104,70,163,3,0,0,0,0,112,70,164,3,0,0,0,0,120,70,165,3,0,0,0,0,121,70,166,3,0,0,0,0,128,70,167,3,0,0,0,0,144,70,168,3,0,0,0,0,152,70,169,3,0,0,0,0,160,70,170,3,0,0,0,0,168,70,171,3,0,0,0,0,176,70,172,3,0,0,0,0,184,70,173,3,0,0,0,0,185,70,174,3,0,0,0,0,192,70,175,3,0,0,0,0,208,70,176,3,0,0,0,0,216,70,177,3,0,0,0,0,224,70,178,3,0,0,0,0,232,70,179,3,0,0,0,0,240,70,180,3,0,0,0,0,248,70,181,3,0,0,0,0,249,70,182,3,0,0,0,0,250,70,183,3,0,0,0,0,251,70,184,3,0,0,0,0,252,70,185,3,0,0,0,0,0,72,186,3,0,0,0,0,8,72,187,3,0,0,0,0,16,72,188,3,0,0,0,0,24,72,189,3,0,0,0,0,32,72,190,3,0,0,0,0,40,72,191,3,0,0,0,0,48,72,192,3,0,0,0,0,56,72,193,3,0,0,0,0,57,72,194,3,0,0,0,0,64,72,195,3,0,0,0,0,72,72,196,3,0,0,0,0,80,72,197,3,0,0,0,0,104,72,198,3,0,0,0,0,112,72,199,3,0,0,0,0,120,72,200,3,0,0,0,0,121,72,201,3,0,0,0,0,122,72,202,3,0,0,0,0,123,72,203,3,0,0,0,0,128,72,204,3,0,0,0,0,144,72,205,3,0,0,0,0,160,72,206,3,0,0,0,0,168,72,207,3,0,0,0,0,176,72,208,3,0,0,0,0,184,72,209,3,0,0,0,0,185,72,210,3,0,0,0,0,192,72,211,3,0,0,0,0,208,72,212,3,0,0,0,0,224,72,213,3,0,0,0,0,232,72,214,3,0,0,0,0,240,72,215,3,0,0,0,0,248,72,216,3,0,0,0,0,249,72,217,3,0,0,0,0,192,73,218,3,0,0,0,0,0,74,219,3,0,0,0,0,16,74,220,3,0,0,0,0,24,74,221,3,0,0,0,0,32,74,222,3,0,0,0,0,40,74,223,3,0,0,0,0,48,74,224,3,0,0,0,0,56,74,225,3,0,0,0,0,57,74,226,3,0,0,0,0,58,74,227,3,0,0,0,0,59,74,228,3,0,0,0,0,60,74,229,3,0,0,0,0,64,74,230,3,0,0,0,0,72,74,231,3,0,0,0,0,80,74,232,3,0,0,0,0,88,74,233,3,0,0,0,0,96,74,234,3,0,0,0,0,104,74,235,3,0,0,0,0,112,74,236,3,0,0,0,0,120,74,237,3,0,0,0,0,121,74,238,3,0,0,0,0,122,74,239,3,0,0,0,0,123,74,240,3,0,0,0,0,124,74,241,3,0,0,0,0,128,74,242,3,0,0,0,0,136,74,243,3,0,0,0,0,144,74,244,3,0,0,0,0,152,74,245,3,0,0,0,0,160,74,246,3,0,0,0,0,168,74,247,3,0,0,0,0,176,74,248,3,0,0,0,0,184,74,249,3,0,0,0,0,185,74,250,3,0,0,0,0,186,74,251,3,0,0,0,0,187,74,252,3,0,0,0,0,188,74,253,3,0,0,0,0,192,74,254,3,0,0,0,0,208,74,255,3,0,0,0,0,216,74,0,4,0,0,0,0,224,74,1,4,0,0,0,0,232,74,2,4,0,0,0,0,240,74,3,4,0,0,0,0,248,74,4,4,0,0,0,0,249,74,5,4,0,0,0,0,0,76,6,4,0,0,0,0,16,76,7,4,0,0,0,0,24,76,8,4,0,0,0,0,32,76,9,4,0,0,0,0,40,76,10,4,0,0,0,0,48,76,11,4,0,0,0,0,56,76,12,4,0,0,0,0,57,76,13,4,0,0,0,0,58,76,14,4,0,0,0,0,59,76,15,4,0,0,0,0,60,76,16,4,0,0,0,0,64,76,17,4,0,0,0,0,80,76,18,4,0,0,0,0,88,76,19,4,0,0,0,0,96,76,20,4,0,0,0,0,104,76,21,4,0,0,0,0,112,76,22,4,0,0,0,0,120,76,23,4,0,0,0,0,121,76,24,4,0,0,0,0,122,76,25,4,0,0,0,0,123,76,26,4,0,0,0,0,124,76,27,4,0,0,0,0,144,76,28,4,0,0,0,0,152,76,29,4,0,0,0,0,168,76,30,4,0,0,0,0,176,76,31,4,0,0,0,0,184,76,32,4,0,0,0,0,185,76,33,4,0,0,0,0,186,76,34,4,0,0,0,0,187,76,35,4,0,0,0,0,208,76,36,4,0,0,0,0,216,76,37,4,0,0,0,0,232,76,38,4,0,0,0,0,240,76,39,4,0,0,0,0,248,76,40,4,0,0,0,0,249,76,41,4,0,0,0,0,250,76,42,4,0,0,0,0,251,76,43,4,0,0,0,0,64,78,44,4,0,0,0,0,80,78,45,4,0,0,0,0,88,78,46,4,0,0,0,0,96,78,47,4,0,0,0,0,104,78,48,4,0,0,0,0,112,78,49,4,0,0,0,0,113,78,50,4,0,0,0,0,114,78,51,4,0,0,0,0,115,78,52,4,0,0,0,0,116,78,53,4,0,0,0,0,117,78,54,4,0,0,0,0,118,78,55,4,0,0,0,0,119,78,56,4,0,0,0,0,122,78,57,4,0,0,0,0,123,78,58,4,0,0,0,0,144,78,59,4,0,0,0,0,168,78,60,4,0,0,0,0,176,78,61,4,0,0,0,0,184,78,62,4,0,0,0,0,185,78,63,4,0,0,0,0,186,78,64,4,0,0,0,0,187,78,65,4,0,0,0,0,208,78,66,4,0,0,0,0,232,78,67,4,0,0,0,0,240,78,68,4,0,0,0,0,248,78,69,4,0,0,0,0,249,78,70,4,0,0,0,0,250,78,71,4,0,0,0,0,251,78,72,4,0,0,0,0,0,80,73,4,0,0,0,0,16,80,74,4,0,0,0,0,24,80,75,4,0,0,0,0,32,80,76,4,0,0,0,0,40,80,77,4,0,0,0,0,48,80,78,4,0,0,0,0,56,80,79,4,0,0,0,0,57,80,80,4,0,0,0,0,64,80,81,4,0,0,0,0,72,80,82,4,0,0,0,0,80,80,83,4,0,0,0,0,88,80,84,4,0,0,0,0,96,80,85,4,0,0,0,0,104,80,86,4,0,0,0,0,112,80,87,4,0,0,0,0,120,80,88,4,0,0,0,0,121,80,89,4,0,0,0,0,128,80,90,4,0,0,0,0,136,80,91,4,0,0,0,0,144,80,92,4,0,0,0,0,152,80,93,4,0,0,0,0,160,80,94,4,0,0,0,0,168,80,95,4,0,0,0,0,176,80,96,4,0,0,0,0,184,80,97,4,0,0,0,0,185,80,98,4,0,0,0,0,192,80,99,4,0,0,0,0,200,80,100,4,0,0,0,0,208,80,101,4,0,0,0,0,216,80,102,4,0,0,0,0,224,80,103,4,0,0,0,0,232,80,104,4,0,0,0,0,240,80,105,4,0,0,0,0,248,80,106,4,0,0,0,0,249,80,107,4,0,0,0,0,250,80,108,4,0,0,0,0,251,80,109,4,0,0,0,0,252,80,110,4,0,0,0,0,0,81,111,4,0,0,0,0,16,81,112,4,0,0,0,0,24,81,113,4,0,0,0,0,32,81,114,4,0,0,0,0,40,81,115,4,0,0,0,0,48,81,116,4,0,0,0,0,56,81,117,4,0,0,0,0,57,81,118,4,0,0,0,0,64,81,119,4,0,0,0,0,72,81,120,4,0,0,0,0,80,81,121,4,0,0,0,0,88,81,122,4,0,0,0,0,96,81,123,4,0,0,0,0,104,81,124,4,0,0,0,0,112,81,125,4,0,0,0,0,120,81,126,4,0,0,0,0,121,81,127,4,0,0,0,0,128,81,128,4,0,0,0,0,136,81,129,4,0,0,0,0,144,81,130,4,0,0,0,0,152,81,131,4,0,0,0,0,160,81,132,4,0,0,0,0,168,81,133,4,0,0,0,0,176,81,134,4,0,0,0,0,184,81,135,4,0,0,0,0,185,81,136,4,0,0,0,0,192,81,137,4,0,0,0,0,200,81,138,4,0,0,0,0,208,81,139,4,0,0,0,0,216,81,140,4,0,0,0,0,224,81,141,4,0,0,0,0,232,81,142,4,0,0,0,0,240,81,143,4,0,0,0,0,248,81,144,4,0,0,0,0,249,81,145,4,0,0,0,0,250,81,146,4,0,0,0,0,251,81,147,4,0,0,0,0,252,81,148,4,0,0,0,0,192,82,149,4,0,0,0,0,200,82,150,4,0,0,0,0,208,82,151,4,0,0,0,0,216,82,152,4,0,0,0,0,224,82,153,4,0,0,0,0,232,82,154,4,0,0,0,0,240,82,155,4,0,0,0,0,248,82,156,4,0,0,0,0,249,82,157,4,0,0,0,0,250,82,158,4,0,0,0,0,251,82,159,4,0,0,0,0,252,82,160,4,0,0,0,0,192,83,161,4,0,0,0,0,200,83,162,4,0,0,0,0,208,83,163,4,0,0,0,0,216,83,164,4,0,0,0,0,224,83,165,4,0,0,0,0,232,83,166,4,0,0,0,0,240,83,167,4,0,0,0,0,248,83,168,4,0,0,0,0,249,83,169,4,0,0,0,0,250,83,170,4,0,0,0,0,251,83,171,4,0,0,0,0,252,83,172,4,0,0,0,0,192,84,173,4,0,0,0,0,200,84,174,4,0,0,0,0,208,84,175,4,0,0,0,0,216,84,176,4,0,0,0,0,224,84,177,4,0,0,0,0,232,84,178,4,0,0,0,0,240,84,179,4,0,0,0,0,248,84,180,4,0,0,0,0,249,84,181,4,0,0,0,0,250,84,182,4,0,0,0,0,251,84,183,4,0,0,0,0,252,84,184,4,0,0,0,0,192,85,185,4,0,0,0,0,200,85,186,4,0,0,0,0,208,85,187,4,0,0,0,0,216,85,188,4,0,0,0,0,224,85,189,4,0,0,0,0,232,85,190,4,0,0,0,0,240,85,191,4,0,0,0,0,248,85,192,4,0,0,0,0,249,85,193,4,0,0,0,0,250,85,194,4,0,0,0,0,251,85,195,4,0,0,0,0,252,85,196,4,0,0,0,0,192,86,197,4,0,0,0,0,200,86,198,4,0,0,0,0,208,86,199,4,0,0,0,0,216,86,200,4,0,0,0,0,224,86,201,4,0,0,0,0,232,86,202,4,0,0,0,0,240,86,203,4,0,0,0,0,248,86,204,4,0,0,0,0,249,86,205,4,0,0,0,0,250,86,206,4,0,0,0,0,251,86,207,4,0,0,0,0,252,86,208,4,0,0,0,0,192,87,209,4,0,0,0,0,200,87,210,4,0,0,0,0,208,87,211,4,0,0,0,0,216,87,212,4,0,0,0,0,224,87,213,4,0,0,0,0,232,87,214,4,0,0,0,0,240,87,215,4,0,0,0,0,248,87,216,4,0,0,0,0,249,87,217,4,0,0,0,0,250,87,218,4,0,0,0,0,251,87,219,4,0,0,0,0,252,87,220,4,0,0,0,0,192,88,221,4,0,0,0,0,200,88,222,4,0,0,0,0,208,88,223,4,0,0,0,0,216,88,224,4,0,0,0,0,224,88,225,4,0,0,0,0,232,88,226,4,0,0,0,0,240,88,227,4,0,0,0,0,248,88,228,4,0,0,0,0,249,88,229,4,0,0,0,0,250,88,230,4,0,0,0,0,251,88,231,4,0,0,0,0,252,88,232,4,0,0,0,0,192,89,233,4,0,0,0,0,200,89,234,4,0,0,0,0,208,89,235,4,0,0,0,0,216,89,236,4,0,0,0,0,224,89,237,4,0,0,0,0,232,89,238,4,0,0,0,0,240,89,239,4,0,0,0,0,248,89,240,4,0,0,0,0,249,89,241,4,0,0,0,0,250,89,242,4,0,0,0,0,251,89,243,4,0,0,0,0,252,89,244,4,0,0,0,0,192,90,245,4,0,0,0,0,200,90,246,4,0,0,0,0,208,90,247,4,0,0,0,0,216,90,248,4,0,0,0,0,224,90,249,4,0,0,0,0,232,90,250,4,0,0,0,0,240,90,251,4,0,0,0,0,248,90,252,4,0,0,0,0,249,90,253,4,0,0,0,0,250,90,254,4,0,0,0,0,251,90,255,4,0,0,0,0,252,90,0,5,0,0,0,0,192,91,1,5,0,0,0,0,200,91,2,5,0,0,0,0,208,91,3,5,0,0,0,0,216,91,4,5,0,0,0,0,224,91,5,5,0,0,0,0,232,91,6,5,0,0,0,0,240,91,7,5,0,0,0,0,248,91,8,5,0,0,0,0,249,91,9,5,0,0,0,0,250,91,10,5,0,0,0,0,251,91,11,5,0,0,0,0,252,91,12,5,0,0,0,0,192,92,13,5,0,0,0,0,200,92,14,5,0,0,0,0,208,92,15,5,0,0,0,0,216,92,16,5,0,0,0,0,224,92,17,5,0,0,0,0,232,92,18,5,0,0,0,0,240,92,19,5,0,0,0,0,248,92,20,5,0,0,0,0,249,92,21,5,0,0,0,0,250,92,22,5,0,0,0,0,251,92,23,5,0,0,0,0,252,92,24,5,0,0,0,0,192,93,25,5,0,0,0,0,200,93,26,5,0,0,0,0,208,93,27,5,0,0,0,0,216,93,28,5,0,0,0,0,224,93,29,5,0,0,0,0,232,93,30,5,0,0,0,0,240,93,31,5,0,0,0,0,248,93,32,5,0,0,0,0,249,93,33,5,0,0,0,0,250,93,34,5,0,0,0,0,251,93,35,5,0,0,0,0,252,93,36,5,0,0,0,0,192,94,37,5,0,0,0,0,200,94,38,5,0,0,0,0,208,94,39,5,0,0,0,0,216,94,40,5,0,0,0,0,224,94,41,5,0,0,0,0,232,94,42,5,0,0,0,0,240,94,43,5,0,0,0,0,248,94,44,5,0,0,0,0,249,94,45,5,0,0,0,0,250,94,46,5,0,0,0,0,251,94,47,5,0,0,0,0,252,94,48,5,0,0,0,0,192,95,49,5,0,0,0,0,200,95,50,5,0,0,0,0,208,95,51,5,0,0,0,0,216,95,52,5,0,0,0,0,224,95,53,5,0,0,0,0,232,95,54,5,0,0,0,0,240,95,55,5,0,0,0,0,248,95,56,5,0,0,0,0,249,95,57,5,0,0,0,0,250,95,58,5,0,0,0,0,251,95,59,5,0,0,0,0,252,95,60,5,0,0,0,0,0,96,61,5,0,0,0,0,1,96,62,5,0,0,0,0,255,96,63,5,0,0,0,0,0,97,64,5,0,0,0,0,1,97,65,5,0,0,0,0,255,97,66,5,0,0,0,0,0,98,67,5,0,0,0,0,1,98,68,5,0,0,0,0,255,98,69,5,0,0,0,0,0,99,70,5,0,0,0,0,1,99,71,5,0,0,0,0,255,99,72,5,0,0,0,0,0,100,73,5,0,0,0,0,1,100,74,5,0,0,0,0,255,100,75,5,0,0,0,0,0,101,76,5,0,0,0,0,1,101,77,5,0,0,0,0,255,101,78,5,0,0,0,0,0,102,79,5,0,0,0,0,1,102,80,5,0,0,0,0,255,102,81,5,0,0,0,0,0,103,82,5,0,0,0,0,1,103,83,5,0,0,0,0,255,103,84,5,0,0,0,0,0,104,85,5,0,0,0,0,1,104,86,5,0,0,0,0,255,104,87,5,0,0,0,0,0,105,88,5,0,0,0,0,1,105,89,5,0,0,0,0,255,105,90,5,0,0,0,0,0,106,91,5,0,0,0,0,1,106,92,5,0,0,0,0,255,106,93,5,0,0,0,0,0,107,94,5,0,0,0,0,1,107,95,5,0,0,0,0,255,107,96,5,0,0,0,0,0,108,97,5,0,0,0,0,1,108,98,5,0,0,0,0,255,108,99,5,0,0,0,0,0,109,100,5,0,0,0,0,1,109,101,5,0,0,0,0,255,109,102,5,0,0,0,0,0,110,103,5,0,0,0,0,1,110,104,5,0,0,0,0,255,110,105,5,0,0,0,0,0,111,106,5,0,0,0,0,1,111,107,5,0,0,0,0,255,111,108,5,0,0,0,0,0,112,109,5,0,0,0,0,0,113,110,5,0,0,0,0,1,113,111,5,0,0,0,0,0,128,112,5,0,0,0,0,16,128,113,5,0,0,0,0,24,128,114,5,0,0,0,0,32,128,115,5,0,0,0,0,40,128,116,5,0,0,0,0,48,128,117,5,0,0,0,0,56,128,118,5,0,0,0,0,57,128,119,5,0,0,0,0,58,128,120,5,0,0,0,0,59,128,121,5,0,0,0,0,60,128,122,5,0,0,0,0,64,128,123,5,0,0,0,0,80,128,124,5,0,0,0,0,88,128,125,5,0,0,0,0,96,128,126,5,0,0,0,0,104,128,127,5,0,0,0,0,112,128,128,5,0,0,0,0,120,128,129,5,0,0,0,0,121,128,130,5,0,0,0,0,122,128,131,5,0,0,0,0,123,128,132,5,0,0,0,0,124,128,133,5,0,0,0,0,128,128,134,5,0,0,0,0,144,128,135,5,0,0,0,0,152,128,136,5,0,0,0,0,160,128,137,5,0,0,0,0,168,128,138,5,0,0,0,0,176,128,139,5,0,0,0,0,184,128,140,5,0,0,0,0,185,128,141,5,0,0,0,0,186,128,142,5,0,0,0,0,187,128,143,5,0,0,0,0,188,128,144,5,0,0,0,0,192,128,145,5,0,0,0,0,208,128,146,5,0,0,0,0,216,128,147,5,0,0,0,0,224,128,148,5,0,0,0,0,232,128,149,5,0,0,0,0,240,128,150,5,0,0,0,0,248,128,151,5,0,0,0,0,249,128,152,5,0,0,0,0,250,128,153,5,0,0,0,0,251,128,154,5,0,0,0,0,252,128,155,5,0,0,0,0,0,129,156,5,0,0,0,0,8,129,157,5,0,0,0,0,16,129,158,5,0,0,0,0,24,129,159,5,0,0,0,0,32,129,160,5,0,0,0,0,40,129,161,5,0,0,0,0,48,129,162,5,0,0,0,0,56,129,163,5,0,0,0,0,57,129,164,5,0,0,0,0,64,129,165,5,0,0,0,0,72,129,166,5,0,0,0,0,80,129,167,5,0,0,0,0,88,129,168,5,0,0,0,0,96,129,169,5,0,0,0,0,104,129,170,5,0,0,0,0,112,129,171,5,0,0,0,0,120,129,172,5,0,0,0,0,121,129,173,5,0,0,0,0,128,129,174,5,0,0,0,0,136,129,175,5,0,0,0,0,144,129,176,5,0,0,0,0,152,129,177,5,0,0,0,0,160,129,178,5,0,0,0,0,168,129,179,5,0,0,0,0,176,129,180,5,0,0,0,0,184,129,181,5,0,0,0,0,185,129,182,5,0,0,0,0,192,129,183,5,0,0,0,0,208,129,184,5,0,0,0,0,216,129,185,5,0,0,0,0,224,129,186,5,0,0,0,0,232,129,187,5,0,0,0,0,240,129,188,5,0,0,0,0,248,129,189,5,0,0,0,0,249,129,190,5,0,0,0,0,250,129,191,5,0,0,0,0,251,129,192,5,0,0,0,0,252,129,193,5,0,0,0,0,0,144,194,5,0,0,0,0,16,144,195,5,0,0,0,0,24,144,196,5,0,0,0,0,32,144,197,5,0,0,0,0,40,144,198,5,0,0,0,0,48,144,199,5,0,0,0,0,56,144,200,5,0,0,0,0,57,144,201,5,0,0,0,0,58,144,202,5,0,0,0,0,59,144,203,5,0,0,0,0,60,144,204,5,0,0,0,0,64,144,205,5,0,0,0,0,72,144,206,5,0,0,0,0,80,144,207,5,0,0,0,0,88,144,208,5,0,0,0,0,96,144,209,5,0,0,0,0,104,144,210,5,0,0,0,0,112,144,211,5,0,0,0,0,120,144,212,5,0,0,0,0,121,144,213,5,0,0,0,0,122,144,214,5,0,0,0,0,123,144,215,5,0,0,0,0,124,144,216,5,0,0,0,0,128,144,217,5,0,0,0,0,136,144,218,5,0,0,0,0,144,144,219,5,0,0,0,0,152,144,220,5,0,0,0,0,160,144,221,5,0,0,0,0,168,144,222,5,0,0,0,0,176,144,223,5,0,0,0,0,184,144,224,5,0,0,0,0,185,144,225,5,0,0,0,0,186,144,226,5,0,0,0,0,187,144,227,5,0,0,0,0,188,144,228,5,0,0,0,0,192,144,229,5,0,0,0,0,200,144,230,5,0,0,0,0,208,144,231,5,0,0,0,0,216,144,232,5,0,0,0,0,224,144,233,5,0,0,0,0,232,144,234,5,0,0,0,0,240,144,235,5,0,0,0,0,248,144,236,5,0,0,0,0,249,144,237,5,0,0,0,0,250,144,238,5,0,0,0,0,251,144,239,5,0,0,0,0,252,144,240,5,0,0,0,0,0,145,241,5,0,0,0,0,8,145,242,5,0,0,0,0,16,145,243,5,0,0,0,0,24,145,244,5,0,0,0,0,32,145,245,5,0,0,0,0,40,145,246,5,0,0,0,0,48,145,247,5,0,0,0,0,56,145,248,5,0,0,0,0,57,145,249,5,0,0,0,0,64,145,250,5,0,0,0,0,72,145,251,5,0,0,0,0,80,145,252,5,0,0,0,0,88,145,253,5,0,0,0,0,96,145,254,5,0,0,0,0,104,145,255,5,0,0,0,0,112,145,0,6,0,0,0,0,120,145,1,6,0,0,0,0,121,145,2,6,0,0,0,0,128,145,3,6,0,0,0,0,136,145,4,6,0,0,0,0,144,145,5,6,0,0,0,0,152,145,6,6,0,0,0,0,160,145,7,6,0,0,0,0,168,145,8,6,0,0,0,0,176,145,9,6,0,0,0,0,184,145,10,6,0,0,0,0,185,145,11,6,0,0,0,0,192,145,12,6,0,0,0,0,200,145,13,6,0,0,0,0,208,145,14,6,0,0,0,0,216,145,15,6,0,0,0,0,224,145,16,6,0,0,0,0,232,145,17,6,0,0,0,0,240,145,18,6,0,0,0,0,248,145,19,6,0,0,0,0,249,145,20,6,0,0,0,0,250,145,21,6,0,0,0,0,251,145,22,6,0,0,0,0,252,145,23,6,0,0,0,0,0,176,24,6,0,0,0,0,16,176,25,6,0,0,0,0,24,176,26,6,0,0,0,0,32,176,27,6,0,0,0,0,40,176,28,6,0,0,0,0,48,176,29,6,0,0,0,0,56,176,30,6,0,0,0,0,57,176,31,6,0,0,0,0,58,176,32,6,0,0,0,0,59,176,33,6,0,0,0,0,60,176,34,6,0,0,0,0,64,176,35,6,0,0,0,0,72,176,36,6,0,0,0,0,80,176,37,6,0,0,0,0,88,176,38,6,0,0,0,0,96,176,39,6,0,0,0,0,104,176,40,6,0,0,0,0,112,176,41,6,0,0,0,0,120,176,42,6,0,0,0,0,121,176,43,6,0,0,0,0,122,176,44,6,0,0,0,0,123,176,45,6,0,0,0,0,124,176,46,6,0,0,0,0,128,176,47,6,0,0,0,0,136,176,48,6,0,0,0,0,144,176,49,6,0,0,0,0,152,176,50,6,0,0,0,0,160,176,51,6,0,0,0,0,168,176,52,6,0,0,0,0,176,176,53,6,0,0,0,0,184,176,54,6,0,0,0,0,185,176,55,6,0,0,0,0,186,176,56,6,0,0,0,0,187,176,57,6,0,0,0,0,188,176,58,6,0,0,0,0,192,176,59,6,0,0,0,0,200,176,60,6,0,0,0,0,208,176,61,6,0,0,0,0,216,176,62,6,0,0,0,0,224,176,63,6,0,0,0,0,232,176,64,6,0,0,0,0,240,176,65,6,0,0,0,0,248,176,66,6,0,0,0,0,249,176,67,6,0,0,0,0,250,176,68,6,0,0,0,0,251,176,69,6,0,0,0,0,252,176,70,6,0,0,0,0,0,177,71,6,0,0,0,0,8,177,72,6,0,0,0,0,16,177,73,6,0,0,0,0,24,177,74,6,0,0,0,0,32,177,75,6,0,0,0,0,40,177,76,6,0,0,0,0,48,177,77,6,0,0,0,0,56,177,78,6,0,0,0,0,57,177,79,6,0,0,0,0,64,177,80,6,0,0,0,0,72,177,81,6,0,0,0,0,80,177,82,6,0,0,0,0,88,177,83,6,0,0,0,0,96,177,84,6,0,0,0,0,104,177,85,6,0,0,0,0,112,177,86,6,0,0,0,0,120,177,87,6,0,0,0,0,121,177,88,6,0,0,0,0,128,177,89,6,0,0,0,0,136,177,90,6,0,0,0,0,144,177,91,6,0,0,0,0,152,177,92,6,0,0,0,0,160,177,93,6,0,0,0,0,168,177,94,6,0,0,0,0,176,177,95,6,0,0,0,0,184,177,96,6,0,0,0,0,185,177,97,6,0,0,0,0,192,177,98,6,0,0,0,0,200,177,99,6,0,0,0,0,208,177,100,6,0,0,0,0,216,177,101,6,0,0,0,0,224,177,102,6,0,0,0,0,232,177,103,6,0,0,0,0,240,177,104,6,0,0,0,0,248,177,105,6,0,0,0,0,249,177,106,6,0,0,0,0,250,177,107,6,0,0,0,0,251,177,108,6,0,0,0,0,252,177,109,6,0,0,0,0,0,192,110,6,0,0,0,0,16,192,111,6,0,0,0,0,24,192,112,6,0,0,0,0,32,192,113,6,0,0,0,0,40,192,114,6,0,0,0,0,48,192,115,6,0,0,0,0,56,192,116,6,0,0,0,0,57,192,117,6,0,0,0,0,58,192,118,6,0,0,0,0,59,192,119,6,0,0,0,0,60,192,120,6,0,0,0,0,64,192,121,6,0,0,0,0,80,192,122,6,0,0,0,0,88,192,123,6,0,0,0,0,96,192,124,6,0,0,0,0,104,192,125,6,0,0,0,0,112,192,126,6,0,0,0,0,120,192,127,6,0,0,0,0,121,192,128,6,0,0,0,0,122,192,129,6,0,0,0,0,123,192,130,6,0,0,0,0,124,192,131,6,0,0,0,0,128,192,132,6,0,0,0,0,144,192,133,6,0,0,0,0,152,192,134,6,0,0,0,0,160,192,135,6,0,0,0,0,168,192,136,6,0,0,0,0,176,192,137,6,0,0,0,0,184,192,138,6,0,0,0,0,185,192,139,6,0,0,0,0,186,192,140,6,0,0,0,0,187,192,141,6,0,0,0,0,188,192,142,6,0,0,0,0,192,192,143,6,0,0,0,0,208,192,144,6,0,0,0,0,216,192,145,6,0,0,0,0,224,192,146,6,0,0,0,0,232,192,147,6,0,0,0,0,240,192,148,6,0,0,0,0,248,192,149,6,0,0,0,0,249,192,150,6,0,0,0,0,250,192,151,6,0,0,0,0,251,192,152,6,0,0,0,0,252,192,153,6,0,0,0,0,0,193,154,6,0,0,0,0,8,193,155,6,0,0,0,0,16,193,156,6,0,0,0,0,24,193,157,6,0,0,0,0,32,193,158,6,0,0,0,0,40,193,159,6,0,0,0,0,48,193,160,6,0,0,0,0,56,193,161,6,0,0,0,0,57,193,162,6,0,0,0,0,64,193,163,6,0,0,0,0,72,193,164,6,0,0,0,0,80,193,165,6,0,0,0,0,88,193,166,6,0,0,0,0,96,193,167,6,0,0,0,0,104,193,168,6,0,0,0,0,112,193,169,6,0,0,0,0,120,193,170,6,0,0,0,0,121,193,171,6,0,0,0,0,136,193,172,6,0,0,0,0,144,193,173,6,0,0,0,0,152,193,174,6,0,0,0,0,160,193,175,6,0,0,0,0,168,193,176,6,0,0,0,0,176,193,177,6,0,0,0,0,184,193,178,6,0,0,0,0,185,193,179,6,0,0,0,0,192,193,180,6,0,0,0,0,208,193,181,6,0,0,0,0,216,193,182,6,0,0,0,0,224,193,183,6,0,0,0,0,232,193,184,6,0,0,0,0,240,193,185,6,0,0,0,0,248,193,186,6,0,0,0,0,249,193,187,6,0,0,0,0,250,193,188,6,0,0,0,0,251,193,189,6,0,0,0,0,252,193,190,6,0,0,0,0,0,208,191,6,0,0,0,0,16,208,192,6,0,0,0,0,24,208,193,6,0,0,0,0,32,208,194,6,0,0,0,0,40,208,195,6,0,0,0,0,48,208,196,6,0,0,0,0,56,208,197,6,0,0,0,0,57,208,198,6,0,0,0,0,58,208,199,6,0,0,0,0,59,208,200,6,0,0,0,0,60,208,201,6,0,0,0,0,64,208,202,6,0,0,0,0,72,208,203,6,0,0,0,0,80,208,204,6,0,0,0,0,88,208,205,6,0,0,0,0,96,208,206,6,0,0,0,0,104,208,207,6,0,0,0,0,112,208,208,6,0,0,0,0,120,208,209,6,0,0,0,0,121,208,210,6,0,0,0,0,122,208,211,6,0,0,0,0,123,208,212,6,0,0,0,0,124,208,213,6,0,0,0,0,128,208,214,6,0,0,0,0,136,208,215,6,0,0,0,0,144,208,216,6,0,0,0,0,152,208,217,6,0,0,0,0,160,208,218,6,0,0,0,0,168,208,219,6,0,0,0,0,176,208,220,6,0,0,0,0,184,208,221,6,0,0,0,0,185,208,222,6,0,0,0,0,186,208,223,6,0,0,0,0,187,208,224,6,0,0,0,0,188,208,225,6,0,0,0,0,192,208,226,6,0,0,0,0,200,208,227,6,0,0,0,0,208,208,228,6,0,0,0,0,216,208,229,6,0,0,0,0,224,208,230,6,0,0,0,0,232,208,231,6,0,0,0,0,240,208,232,6,0,0,0,0,248,208,233,6,0,0,0,0,249,208,234,6,0,0,0,0,250,208,235,6,0,0,0,0,251,208,236,6,0,0,0,0,252,208,237,6,0,0,0,0,0,209,238,6,0,0,0,0,8,209,239,6,0,0,0,0,16,209,240,6,0,0,0,0,24,209,241,6,0,0,0,0,32,209,242,6,0,0,0,0,40,209,243,6,0,0,0,0,48,209,244,6,0,0,0,0,56,209,245,6,0,0,0,0,57,209,246,6,0,0,0,0,64,209,247,6,0,0,0,0,72,209,248,6,0,0,0,0,80,209,249,6,0,0,0,0,88,209,250,6,0,0,0,0,96,209,251,6,0,0,0,0,104,209,252,6,0,0,0,0,112,209,253,6,0,0,0,0,120,209,254,6,0,0,0,0,121,209,255,6,0,0,0,0,128,209,0,7,0,0,0,0,136,209,1,7,0,0,0,0,144,209,2,7,0,0,0,0,152,209,3,7,0,0,0,0,160,209,4,7,0,0,0,0,168,209,5,7,0,0,0,0,176,209,6,7,0,0,0,0,184,209,7,7,0,0,0,0,185,209,8,7,0,0,0,0,192,209,9,7,0,0,0,0,200,209,10,7,0,0,0,0,208,209,11,7,0,0,0,0,216,209,12,7,0,0,0,0,224,209,13,7,0,0,0,0,232,209,14,7,0,0,0,0,240,209,15,7,0,0,0,0,248,209,16,7,0,0,0,0,249,209,17,7,0,0,0,0,250,209,18,7,0,0,0,0,251,209,19,7,0,0,0,0,252,209,20,7,0,0,0,0,0,224,21,7,0,0,0,0,8,224,22,7,0,0,0,0,16,224,23,7,0,0,0,0,24,224,24,7,0,0,0,0,32,224,25,7,0,0,0,0,40,224,26,7,0,0,0,0,48,224,27,7,0,0,0,0,56,224,28,7,0,0,0,0,64,224,29,7,0,0,0,0,72,224,30,7,0,0,0,0,80,224,31,7,0,0,0,0,88,224,32,7,0,0,0,0,96,224,33,7,0,0,0,0,104,224,34,7,0,0,0,0,112,224,35,7,0,0,0,0,120,224,36,7,0,0,0,0,128,224,37,7,0,0,0,0,136,224,38,7,0,0,0,0,144,224,39,7,0,0,0,0,152,224,40,7,0,0,0,0,160,224,41,7,0,0,0,0,168,224,42,7,0,0,0,0,176,224,43,7,0,0,0,0,184,224,44,7,0,0,0,0,208,224,45,7,0,0,0,0,216,224,46,7,0,0,0,0,224,224,47,7,0,0,0,0,232,224,48,7,0,0,0,0,240,224,49,7,0,0,0,0,248,224,50,7,0,0,0,0,249,224,51,7,0,0,0,0,0,225,52,7,0,0,0,0,8,225,53,7,0,0,0,0,16,225,54,7,0,0,0,0,24,225,55,7,0,0,0,0,32,225,56,7,0,0,0,0,40,225,57,7,0,0,0,0,48,225,58,7,0,0,0,0,56,225,59,7,0,0,0,0,64,225,60,7,0,0,0,0,72,225,61,7,0,0,0,0,80,225,62,7,0,0,0,0,88,225,63,7,0,0,0,0,96,225,64,7,0,0,0,0,104,225,65,7,0,0,0,0,112,225,66,7,0,0,0,0,120,225,67,7,0,0,0,0,128,225,68,7,0,0,0,0,136,225,69,7,0,0,0,0,144,225,70,7,0,0,0,0,152,225,71,7,0,0,0,0,160,225,72,7,0,0,0,0,168,225,73,7,0,0,0,0,176,225,74,7,0,0,0,0,184,225,75,7,0,0,0,0,208,225,76,7,0,0,0,0,216,225,77,7,0,0,0,0,224,225,78,7,0,0,0,0,232,225,79,7,0,0,0,0,240,225,80,7,0,0,0,0,248,225,81,7,0,0,0,0,249,225,82,7,0,0,0,0,208,226,83,7,0,0,0,0,216,226,84,7,0,0,0,0,224,226,85,7,0,0,0,0,232,226,86,7,0,0,0,0,240,226,87,7,0,0,0,0,248,226,88,7,0,0,0,0,249,226,89,7,0,0,0,0,208,227,90,7,0,0,0,0,216,227,91,7,0,0,0,0,224,227,92,7,0,0,0,0,232,227,93,7,0,0,0,0,240,227,94,7,0,0,0,0,248,227,95,7,0,0,0,0,249,227,96,7,0,0,0,0,208,228,97,7,0,0,0,0,216,228,98,7,0,0,0,0,224,228,99,7,0,0,0,0,232,228,100,7,0,0,0,0,240,228,101,7,0,0,0,0,248,228,102,7,0,0,0,0,249,228,103,7,0,0,0,0,208,229,104,7,0,0,0,0,216,229,105,7,0,0,0,0,224,229,106,7,0,0,0,0,232,229,107,7,0,0,0,0,240,229,108,7,0,0,0,0,248,229,109,7,0,0,0,0,249,229,110,7,0,0,0,0,208,230,111,7,0,0,0,0,216,230,112,7,0,0,0,0,224,230,113,7,0,0,0,0,232,230,114,7,0,0,0,0,240,230,115,7,0,0,0,0,248,230,116,7,0,0,0,0,249,230,117,7,0,0,0,0,208,231,118,7,0,0,0,0,216,231,119,7,0,0,0,0,224,231,120,7,0,0,0,0,232,231,121,7,0,0,0,0,240,231,122,7,0,0,0,0,248,231,123,7,0,0,0,0,249,231,124,7,0,0,0,0,192,232,125,7,0,0,0,0,208,232,126,7,0,0,0,0,232,232,127,7,0,0,0,0,240,232,128,7,0,0,0,0,248,232,129,7,0,0,0,0,249,232,130,7,0,0,0,0,250,232,131,7,0,0,0,0,251,232,132,7,0,0,0,0,192,233,133,7,0,0,0,0,208,233,134,7,0,0,0,0,232,233,135,7,0,0,0,0,240,233,136,7,0,0,0,0,248,233,137,7,0,0,0,0,249,233,138,7,0,0,0,0,250,233,139,7,0,0,0,0,251,233,140,7,0,0,0,0,192,234,141,7,0,0,0,0,208,234,142,7,0,0,0,0,232,234,143,7,0,0,0,0,240,234,144,7,0,0,0,0,248,234,145,7,0,0,0,0,249,234,146,7,0,0,0,0,192,235,147,7,0,0,0,0,208,235,148,7,0,0,0,0,232,235,149,7,0,0,0,0,240,235,150,7,0,0,0,0,248,235,151,7,0,0,0,0,249,235,152,7,0,0,0,0,250,235,153,7,0,0,0,0,251,235,154,7,0,0,0,0,192,236,155,7,0,0,0,0,208,236,156,7,0,0,0,0,232,236,157,7,0,0,0,0,240,236,158,7,0,0,0,0,248,236,159,7,0,0,0,0,249,236,160,7,0,0,0,0,192,237,161,7,0,0,0,0,208,237,162,7,0,0,0,0,232,237,163,7,0,0,0,0,240,237,164,7,0,0,0,0,248,237,165,7,0,0,0,0,249,237,166,7,0,0,0,0,250,237,167,7,0,0,0,0,251,237,168,7,0,0,0,0,192,238,169,7,0,0,0,0,208,238,170,7,0,0,0,0,232,238,171,7,0,0,0,0,240,238,172,7,0,0,0,0,248,238,173,7,0,0,0,0,249,238,174,7,0,0,0,0,192,239,175,7,0,0,0,0,208,239,176,7,0,0,0,0,232,239,177,7,0,0,0,0,240,239,178,7,0,0,0,0,248,239,179,7,0,0,0,0,249,239,180,7,0,0,0,0,0,242,181,7,0,0,0,0,8,242,182,7,0,0,0,0,16,242,183,7,0,0,0,0,24,242,184,7,0,0,0,0,32,242,185,7,0,0,0,0,40,242,186,7,0,0,0,0,48,242,187,7,0,0,0,0,56,242,188,7,0,0,0,0,57,242,189,7,0,0,0,0,58,242,190,7,0,0,0,0,59,242,191,7,0,0,0,0,60,242,192,7,0,0,0,0,64,242,193,7,0,0,0,0,72,242,194,7,0,0,0,0,80,242,195,7,0,0,0,0,88,242,196,7,0,0,0,0,96,242,197,7,0,0,0,0,104,242,198,7,0,0,0,0,112,242,199,7,0,0,0,0,120,242,200,7,0,0,0,0,121,242,201,7,0,0,0,0,122,242,202,7,0,0,0,0,123,242,203,7,0,0,0,0,124,242,204,7,0,0,0,0,128,242,205,7,0,0,0,0,192,242,206,7,0,0,0,0,16,243,207,7,0,0,0,0,32,243,208,7,0,0,0,0,40,243,209,7,0,0,0,0,48,243,210,7,0,0,0,0,56,243,211,7,0,0,0,0,57,243,212,7,0,0,0,0,80,243,213,7,0,0,0,0,88,243,214,7,0,0,0,0,104,243,215,7,0,0,0,0,112,243,216,7,0,0,0,0,120,243,217,7,0,0,0,0,121,243,218,7,0,0,0,0,122,243,219,7,0,0,0,0,123,243,220,7,0,0,0,0,8,244,221,7,0,0,0,0,16,244,222,7,0,0,0,0,24,244,223,7,0,0,0,0,25,244,224,7,0,0,0,0,26,244,225,7,0,0,0,0,27,244,226,7,0,0,0,0,28,244,227,7,0,0,0,0,29,244,228,7,0,0,0,0,30,244,229,7,0,0,0,0,31,244,230,7,0,0,0,0,40,244,231,7,0,0,0,0,48,244,232,7,0,0,0,0,56,244,233,7,0,0,0,0,57,244,234,7,0,0,0,0,58,244,235,7,0,0,0,0,59,244,236,7,0,0,0,0,60,244,237,7,0,0,0,0,61,244,238,7,0,0,0,0,62,244,239,7,0,0,0,0,63,244,240,7,0,0,0,0,0,245,241,7,0,0,0,0,0,246,242,7,0,0,0,0,8,246,243,7,0,0,0,0,16,246,244,7,0,0,0,0,24,246,245,7,0,0,0,0,32,246,0,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,171,0,0,0,0,0,16,0,172,0,0,0,0,0,24,0,173,0,0,0,0,0,32,0,174,0,0,0,0,0,40,0,175,0,0,0,0,0,48,0,176,0,0,0,0,0,56,0,177,0,0,0,0,0,57,0,178,0,0,0,0,0,60,0,179,0,0,0,0,0,64,0,180,0,0,0,0,0,80,0,181,0,0,0,0,0,88,0,182,0,0,0,0,0,96,0,183,0,0,0,0,0,104,0,184,0,0,0,0,0,112,0,185,0,0,0,0,0,120,0,186,0,0,0,0,0,121,0,187,0,0,0,0,0,124,0,188,0,0,0,0,0,128,0,189,0,0,0,0,0,144,0,190,0,0,0,0,0,152,0,191,0,0,0,0,0,160,0,192,0,0,0,0,0,168,0,193,0,0,0,0,0,176,0,194,0,0,0,0,0,184,0,195,0,0,0,0,0,185,0,196,0,0,0,0,0,208,0,197,0,0,0,0,0,232,0,198,0,0,0,0,0,240,0,199,0,0,0,0,0,248,0,200,0,0,0,0,0,249,0,201,0,0,0,0,0,250,0,202,0,0,0,0,0,251,0,203,0,0,0,0,0,0,1,204,0,0,0,0,0,8,1,205,0,0,0,0,0,16,1,206,0,0,0,0,0,24,1,207,0,0,0,0,0,32,1,208,0,0,0,0,0,40,1,209,0,0,0,0,0,48,1,210,0,0,0,0,0,56,1,211,0,0,0,0,0,57,1,212,0,0,0,0,0,58,1,213,0,0,0,0,0,59,1,214,0,0,0,0,0,60,1,215,0,0,0,0,0,64,1,216,0,0,0,0,0,72,1,217,0,0,0,0,0,80,1,218,0,0,0,0,0,88,1,219,0,0,0,0,0,96,1,220,0,0,0,0,0,104,1,221,0,0,0,0,0,112,1,222,0,0,0,0,0,120,1,223,0,0,0,0,0,121,1,224,0,0,0,0,0,122,1,225,0,0,0,0,0,123,1,226,0,0,0,0,0,128,1,227,0,0,0,0,0,136,1,228,0,0,0,0,0,144,1,229,0,0,0,0,0,152,1,230,0,0,0,0,0,160,1,231,0,0,0,0,0,168,1,232,0,0,0,0,0,176,1,233,0,0,0,0,0,184,1,234,0,0,0,0,0,185,1,235,0,0,0,0,0,186,1,236,0,0,0,0,0,187,1,237,0,0,0,0,0,192,1,238,0,0,0,0,0,200,1,239,0,0,0,0,0,208,1,240,0,0,0,0,0,216,1,241,0,0,0,0,0,224,1,242,0,0,0,0,0,232,1,243,0,0,0,0,0,240,1,244,0,0,0,0,0,248,1,245,0,0,0,0,0,249,1,246,0,0,0,0,0,250,1,247,0,0,0,0,0,251,1,248,0,0,0,0,0,0,2,249,0,0,0,0,0,16,2,250,0,0,0,0,0,24,2,251,0,0,0,0,0,32,2,252,0,0,0,0,0,40,2,253,0,0,0,0,0,48,2,254,0,0,0,0,0,56,2,255,0,0,0,0,0,57,2,0,1,0,0,0,0,60,2,1,1,0,0,0,0,64,2,2,1,0,0,0,0,80,2,3,1,0,0,0,0,88,2,4,1,0,0,0,0,96,2,5,1,0,0,0,0,104,2,6,1,0,0,0,0,112,2,7,1,0,0,0,0,120,2,8,1,0,0,0,0,121,2,9,1,0,0,0,0,124,2,10,1,0,0,0,0,128,2,11,1,0,0,0,0,144,2,12,1,0,0,0,0,152,2,13,1,0,0,0,0,160,2,14,1,0,0,0,0,168,2,15,1,0,0,0,0,176,2,16,1,0,0,0,0,184,2,17,1,0,0,0,0,185,2,18,1,0,0,0,0,208,2,19,1,0,0,0,0,232,2,20,1,0,0,0,0,240,2,21,1,0,0,0,0,248,2,22,1,0,0,0,0,249,2,23,1,0,0,0,0,250,2,24,1,0,0,0,0,251,2,25,1,0,0,0,0,0,4,26,1,0,0,0,0,16,4,27,1,0,0,0,0,24,4,28,1,0,0,0,0,32,4,29,1,0,0,0,0,40,4,30,1,0,0,0,0,48,4,31,1,0,0,0,0,56,4,32,1,0,0,0,0,57,4,33,1,0,0,0,0,64,4,34,1,0,0,0,0,80,4,35,1,0,0,0,0,88,4,36,1,0,0,0,0,96,4,37,1,0,0,0,0,104,4,38,1,0,0,0,0,112,4,39,1,0,0,0,0,120,4,40,1,0,0,0,0,121,4,41,1,0,0,0,0,128,4,42,1,0,0,0,0,144,4,43,1,0,0,0,0,152,4,44,1,0,0,0,0,160,4,45,1,0,0,0,0,168,4,46,1,0,0,0,0,176,4,47,1,0,0,0,0,184,4,48,1,0,0,0,0,185,4,49,1,0,0,0,0,208,4,50,1,0,0,0,0,232,4,51,1,0,0,0,0,240,4,52,1,0,0,0,0,248,4,53,1,0,0,0,0,249,4,54,1,0,0,0,0,250,4,55,1,0,0,0,0,251,4,56,1,0,0,0,0,0,6,57,1,0,0,0,0,16,6,58,1,0,0,0,0,24,6,59,1,0,0,0,0,32,6,60,1,0,0,0,0,40,6,61,1,0,0,0,0,48,6,62,1,0,0,0,0,56,6,63,1,0,0,0,0,57,6,64,1,0,0,0,0,64,6,65,1,0,0,0,0,80,6,66,1,0,0,0,0,88,6,67,1,0,0,0,0,96,6,68,1,0,0,0,0,104,6,69,1,0,0,0,0,112,6,70,1,0,0,0,0,120,6,71,1,0,0,0,0,121,6,72,1,0,0,0,0,128,6,73,1,0,0,0,0,144,6,74,1,0,0,0,0,152,6,75,1,0,0,0,0,160,6,76,1,0,0,0,0,168,6,77,1,0,0,0,0,176,6,78,1,0,0,0,0,184,6,79,1,0,0,0,0,185,6,80,1,0,0,0,0,192,6,81,1,0,0,0,0,200,6,82,1,0,0,0,0,208,6,83,1,0,0,0,0,232,6,84,1,0,0,0,0,240,6,85,1,0,0,0,0,248,6,86,1,0,0,0,0,249,6,87,1,0,0,0,0,250,6,88,1,0,0,0,0,251,6,89,1,0,0,0,0,0,8,90,1,0,0,0,0,16,8,91,1,0,0,0,0,24,8,92,1,0,0,0,0,32,8,93,1,0,0,0,0,40,8,94,1,0,0,0,0,48,8,95,1,0,0,0,0,56,8,96,1,0,0,0,0,57,8,97,1,0,0,0,0,58,8,98,1,0,0,0,0,59,8,99,1,0,0,0,0,60,8,100,1,0,0,0,0,64,8,101,1,0,0,0,0,80,8,102,1,0,0,0,0,88,8,103,1,0,0,0,0,96,8,104,1,0,0,0,0,104,8,105,1,0,0,0,0,112,8,106,1,0,0,0,0,120,8,107,1,0,0,0,0,121,8,108,1,0,0,0,0,122,8,109,1,0,0,0,0,123,8,110,1,0,0,0,0,128,8,111,1,0,0,0,0,144,8,112,1,0,0,0,0,152,8,113,1,0,0,0,0,160,8,114,1,0,0,0,0,168,8,115,1,0,0,0,0,176,8,116,1,0,0,0,0,184,8,117,1,0,0,0,0,185,8,118,1,0,0,0,0,186,8,119,1,0,0,0,0,187,8,120,1,0,0,0,0,192,8,121,1,0,0,0,0,208,8,122,1,0,0,0,0,216,8,123,1,0,0,0,0,224,8,124,1,0,0,0,0,232,8,125,1,0,0,0,0,240,8,126,1,0,0,0,0,248,8,127,1,0,0,0,0,249,8,128,1,0,0,0,0,250,8,129,1,0,0,0,0,251,8,130,1,0,0,0,0,0,10,131,1,0,0,0,0,16,10,132,1,0,0,0,0,24,10,133,1,0,0,0,0,32,10,134,1,0,0,0,0,40,10,135,1,0,0,0,0,48,10,136,1,0,0,0,0,56,10,137,1,0,0,0,0,57,10,138,1,0,0,0,0,60,10,139,1,0,0,0,0,64,10,140,1,0,0,0,0,80,10,141,1,0,0,0,0,88,10,142,1,0,0,0,0,96,10,143,1,0,0,0,0,104,10,144,1,0,0,0,0,112,10,145,1,0,0,0,0,120,10,146,1,0,0,0,0,121,10,147,1,0,0,0,0,124,10,148,1,0,0,0,0,128,10,149,1,0,0,0,0,144,10,150,1,0,0,0,0,152,10,151,1,0,0,0,0,160,10,152,1,0,0,0,0,168,10,153,1,0,0,0,0,176,10,154,1,0,0,0,0,184,10,155,1,0,0,0,0,185,10,156,1,0,0,0,0,208,10,157,1,0,0,0,0,216,10,158,1,0,0,0,0,224,10,159,1,0,0,0,0,232,10,160,1,0,0,0,0,240,10,161,1,0,0,0,0,248,10,162,1,0,0,0,0,249,10,163,1,0,0,0,0,0,12,164,1,0,0,0,0,16,12,165,1,0,0,0,0,24,12,166,1,0,0,0,0,32,12,167,1,0,0,0,0,40,12,168,1,0,0,0,0,48,12,169,1,0,0,0,0,56,12,170,1,0,0,0,0,57,12,171,1,0,0,0,0,58,12,172,1,0,0,0,0,59,12,173,1,0,0,0,0,64,12,174,1,0,0,0,0,80,12,175,1,0,0,0,0,88,12,176,1,0,0,0,0,96,12,177,1,0,0,0,0,104,12,178,1,0,0,0,0,112,12,179,1,0,0,0,0,120,12,180,1,0,0,0,0,121,12,181,1,0,0,0,0,122,12,182,1,0,0,0,0,123,12,183,1,0,0,0,0,128,12,184,1,0,0,0,0,144,12,185,1,0,0,0,0,152,12,186,1,0,0,0,0,160,12,187,1,0,0,0,0,168,12,188,1,0,0,0,0,176,12,189,1,0,0,0,0,184,12,190,1,0,0,0,0,185,12,191,1,0,0,0,0,186,12,192,1,0,0,0,0,187,12,193,1,0,0,0,0,208,12,194,1,0,0,0,0,216,12,195,1,0,0,0,0,224,12,196,1,0,0,0,0,232,12,197,1,0,0,0,0,240,12,198,1,0,0,0,0,248,12,199,1,0,0,0,0,249,12,200,1,0,0,0,0,252,12,201,1,0,0,0,0,16,14,202,1,0,0,0,0,24,14,203,1,0,0,0,0,32,14,204,1,0,0,0,0,40,14,205,1,0,0,0,0,48,14,206,1,0,0,0,0,56,14,207,1,0,0,0,0,57,14,208,1,0,0,0,0,80,14,209,1,0,0,0,0,88,14,210,1,0,0,0,0,96,14,211,1,0,0,0,0,104,14,212,1,0,0,0,0,112,14,213,1,0,0,0,0,120,14,214,1,0,0,0,0,121,14,215,1,0,0,0,0,144,14,216,1,0,0,0,0,152,14,217,1,0,0,0,0,160,14,218,1,0,0,0,0,168,14,219,1,0,0,0,0,176,14,220,1,0,0,0,0,184,14,221,1,0,0,0,0,185,14,222,1,0,0,0,0,208,14,223,1,0,0,0,0,216,14,224,1,0,0,0,0,224,14,225,1,0,0,0,0,232,14,226,1,0,0,0,0,240,14,227,1,0,0,0,0,248,14,228,1,0,0,0,0,249,14,229,1,0,0,0,0,252,14,230,1,0,0,0,0,0,16,231,1,0,0,0,0,16,16,232,1,0,0,0,0,24,16,233,1,0,0,0,0,32,16,234,1,0,0,0,0,40,16,235,1,0,0,0,0,48,16,236,1,0,0,0,0,56,16,237,1,0,0,0,0,57,16,238,1,0,0,0,0,58,16,239,1,0,0,0,0,59,16,240,1,0,0,0,0,60,16,241,1,0,0,0,0,128,16,242,1,0,0,0,0,144,16,243,1,0,0,0,0,152,16,244,1,0,0,0,0,160,16,245,1,0,0,0,0,168,16,246,1,0,0,0,0,176,16,247,1,0,0,0,0,184,16,248,1,0,0,0,0,185,16,249,1,0,0,0,0,186,16,250,1,0,0,0,0,187,16,251,1,0,0,0,0,188,16,252,1,0,0,0,0,192,16,253,1,0,0,0,0,208,16,254,1,0,0,0,0,216,16,255,1,0,0,0,0,224,16,0,2,0,0,0,0,232,16,1,2,0,0,0,0,240,16,2,2,0,0,0,0,248,16,3,2,0,0,0,0,249,16,4,2,0,0,0,0,250,16,5,2,0,0,0,0,251,16,6,2,0,0,0,0,252,16,7,2,0,0,0,0,0,17,8,2,0,0,0,0,16,17,9,2,0,0,0,0,24,17,10,2,0,0,0,0,32,17,11,2,0,0,0,0,40,17,12,2,0,0,0,0,48,17,13,2,0,0,0,0,56,17,14,2,0,0,0,0,57,17,15,2,0,0,0,0,58,17,16,2,0,0,0,0,59,17,17,2,0,0,0,0,60,17,18,2,0,0,0,0,64,17,19,2,0,0,0,0,80,17,20,2,0,0,0,0,88,17,21,2,0,0,0,0,96,17,22,2,0,0,0,0,104,17,23,2,0,0,0,0,112,17,24,2,0,0,0,0,120,17,25,2,0,0,0,0,121,17,26,2,0,0,0,0,122,17,27,2,0,0,0,0,123,17,28,2,0,0,0,0,124,17,29,2,0,0,0,0,128,17,30,2,0,0,0,0,144,17,31,2,0,0,0,0,152,17,32,2,0,0,0,0,160,17,33,2,0,0,0,0,168,17,34,2,0,0,0,0,176,17,35,2,0,0,0,0,184,17,36,2,0,0,0,0,185,17,37,2,0,0,0,0,186,17,38,2,0,0,0,0,187,17,39,2,0,0,0,0,188,17,40,2,0,0,0,0,192,17,41,2,0,0,0,0,208,17,42,2,0,0,0,0,216,17,43,2,0,0,0,0,224,17,44,2,0,0,0,0,232,17,45,2,0,0,0,0,240,17,46,2,0,0,0,0,248,17,47,2,0,0,0,0,249,17,48,2,0,0,0,0,250,17,49,2,0,0,0,0,251,17,50,2,0,0,0,0,252,17,51,2,0,0,0,0,192,19,52,2,0,0,0,0,208,19,53,2,0,0,0,0,216,19,54,2,0,0,0,0,224,19,55,2,0,0,0,0,232,19,56,2,0,0,0,0,240,19,57,2,0,0,0,0,248,19,58,2,0,0,0,0,249,19,59,2,0,0,0,0,250,19,60,2,0,0,0,0,251,19,61,2,0,0,0,0,252,19,62,2,0,0,0,0,0,32,63,2,0,0,0,0,8,32,64,2,0,0,0,0,16,32,65,2,0,0,0,0,24,32,66,2,0,0,0,0,32,32,67,2,0,0,0,0,40,32,68,2,0,0,0,0,48,32,69,2,0,0,0,0,56,32,70,2,0,0,0,0,57,32,71,2,0,0,0,0,58,32,72,2,0,0,0,0,59,32,73,2,0,0,0,0,60,32,74,2,0,0,0,0,64,32,75,2,0,0,0,0,72,32,76,2,0,0,0,0,80,32,77,2,0,0,0,0,88,32,78,2,0,0,0,0,96,32,79,2,0,0,0,0,104,32,80,2,0,0,0,0,112,32,81,2,0,0,0,0,120,32,82,2,0,0,0,0,121,32,83,2,0,0,0,0,122,32,84,2,0,0,0,0,123,32,85,2,0,0,0,0,124,32,86,2,0,0,0,0,128,32,87,2,0,0,0,0,136,32,88,2,0,0,0,0,144,32,89,2,0,0,0,0,152,32,90,2,0,0,0,0,160,32,91,2,0,0,0,0,168,32,92,2,0,0,0,0,176,32,93,2,0,0,0,0,184,32,94,2,0,0,0,0,185,32,95,2,0,0,0,0,186,32,96,2,0,0,0,0,187,32,97,2,0,0,0,0,188,32,98,2,0,0,0,0,192,32,99,2,0,0,0,0,200,32,100,2,0,0,0,0,208,32,101,2,0,0,0,0,216,32,102,2,0,0,0,0,224,32,103,2,0,0,0,0,232,32,104,2,0,0,0,0,240,32,105,2,0,0,0,0,248,32,106,2,0,0,0,0,249,32,107,2,0,0,0,0,250,32,108,2,0,0,0,0,251,32,109,2,0,0,0,0,252,32,110,2,0,0,0,0,0,33,111,2,0,0,0,0,8,33,112,2,0,0,0,0,16,33,113,2,0,0,0,0,24,33,114,2,0,0,0,0,32,33,115,2,0,0,0,0,40,33,116,2,0,0,0,0,48,33,117,2,0,0,0,0,56,33,118,2,0,0,0,0,57,33,119,2,0,0,0,0,58,33,120,2,0,0,0,0,59,33,121,2,0,0,0,0,60,33,122,2,0,0,0,0,64,33,123,2,0,0,0,0,72,33,124,2,0,0,0,0,80,33,125,2,0,0,0,0,88,33,126,2,0,0,0,0,96,33,127,2,0,0,0,0,104,33,128,2,0,0,0,0,112,33,129,2,0,0,0,0,120,33,130,2,0,0,0,0,121,33,131,2,0,0,0,0,122,33,132,2,0,0,0,0,123,33,133,2,0,0,0,0,124,33,134,2,0,0,0,0,128,33,135,2,0,0,0,0,136,33,136,2,0,0,0,0,144,33,137,2,0,0,0,0,152,33,138,2,0,0,0,0,160,33,139,2,0,0,0,0,168,33,140,2,0,0,0,0,176,33,141,2,0,0,0,0,184,33,142,2,0,0,0,0,185,33,143,2,0,0,0,0,186,33,144,2,0,0,0,0,187,33,145,2,0,0,0,0,188,33,146,2,0,0,0,0,192,33,147,2,0,0,0,0,200,33,148,2,0,0,0,0,208,33,149,2,0,0,0,0,216,33,150,2,0,0,0,0,224,33,151,2,0,0,0,0,232,33,152,2,0,0,0,0,240,33,153,2,0,0,0,0,248,33,154,2,0,0,0,0,249,33,155,2,0,0,0,0,250,33,156,2,0,0,0,0,251,33,157,2,0,0,0,0,252,33,158,2,0,0,0,0,192,35,159,2,0,0,0,0,200,35,160,2,0,0,0,0,208,35,161,2,0,0,0,0,216,35,162,2,0,0,0,0,224,35,163,2,0,0,0,0,232,35,164,2,0,0,0,0,240,35,165,2,0,0,0,0,248,35,166,2,0,0,0,0,249,35,167,2,0,0,0,0,250,35,168,2,0,0,0,0,251,35,169,2,0,0,0,0,252,35,170,2,0,0,0,0,0,48,171,2,0,0,0,0,8,48,172,2,0,0,0,0,16,48,173,2,0,0,0,0,24,48,174,2,0,0,0,0,32,48,175,2,0,0,0,0,40,48,176,2,0,0,0,0,48,48,177,2,0,0,0,0,56,48,178,2,0,0,0,0,57,48,179,2,0,0,0,0,58,48,180,2,0,0,0,0,59,48,181,2,0,0,0,0,60,48,182,2,0,0,0,0,64,48,183,2,0,0,0,0,72,48,184,2,0,0,0,0,80,48,185,2,0,0,0,0,88,48,186,2,0,0,0,0,96,48,187,2,0,0,0,0,104,48,188,2,0,0,0,0,112,48,189,2,0,0,0,0,120,48,190,2,0,0,0,0,121,48,191,2,0,0,0,0,122,48,192,2,0,0,0,0,123,48,193,2,0,0,0,0,124,48,194,2,0,0,0,0,128,48,195,2,0,0,0,0,136,48,196,2,0,0,0,0,144,48,197,2,0,0,0,0,152,48,198,2,0,0,0,0,160,48,199,2,0,0,0,0,168,48,200,2,0,0,0,0,176,48,201,2,0,0,0,0,184,48,202,2,0,0,0,0,185,48,203,2,0,0,0,0,186,48,204,2,0,0,0,0,187,48,205,2,0,0,0,0,188,48,206,2,0,0,0,0,192,48,207,2,0,0,0,0,200,48,208,2,0,0,0,0,208,48,209,2,0,0,0,0,216,48,210,2,0,0,0,0,224,48,211,2,0,0,0,0,232,48,212,2,0,0,0,0,240,48,213,2,0,0,0,0,248,48,214,2,0,0,0,0,249,48,215,2,0,0,0,0,250,48,216,2,0,0,0,0,251,48,217,2,0,0,0,0,252,48,218,2,0,0,0,0,0,49,219,2,0,0,0,0,8,49,220,2,0,0,0,0,16,49,221,2,0,0,0,0,24,49,222,2,0,0,0,0,32,49,223,2,0,0,0,0,40,49,224,2,0,0,0,0,48,49,225,2,0,0,0,0,56,49,226,2,0,0,0,0,57,49,227,2,0,0,0,0,58,49,228,2,0,0,0,0,59,49,229,2,0,0,0,0,60,49,230,2,0,0,0,0,64,49,231,2,0,0,0,0,72,49,232,2,0,0,0,0,80,49,233,2,0,0,0,0,88,49,234,2,0,0,0,0,96,49,235,2,0,0,0,0,104,49,236,2,0,0,0,0,112,49,237,2,0,0,0,0,120,49,238,2,0,0,0,0,121,49,239,2,0,0,0,0,122,49,240,2,0,0,0,0,123,49,241,2,0,0,0,0,124,49,242,2,0,0,0,0,128,49,243,2,0,0,0,0,136,49,244,2,0,0,0,0,144,49,245,2,0,0,0,0,152,49,246,2,0,0,0,0,160,49,247,2,0,0,0,0,168,49,248,2,0,0,0,0,176,49,249,2,0,0,0,0,184,49,250,2,0,0,0,0,185,49,251,2,0,0,0,0,186,49,252,2,0,0,0,0,187,49,253,2,0,0,0,0,188,49,254,2,0,0,0,0,192,49,255,2,0,0,0,0,200,49,0,3,0,0,0,0,208,49,1,3,0,0,0,0,216,49,2,3,0,0,0,0,224,49,3,3,0,0,0,0,232,49,4,3,0,0,0,0,240,49,5,3,0,0,0,0,248,49,6,3,0,0,0,0,249,49,7,3,0,0,0,0,250,49,8,3,0,0,0,0,251,49,9,3,0,0,0,0,252,49,10,3,0,0,0,0,192,51,11,3,0,0,0,0,200,51,12,3,0,0,0,0,208,51,13,3,0,0,0,0,216,51,14,3,0,0,0,0,224,51,15,3,0,0,0,0,232,51,16,3,0,0,0,0,240,51,17,3,0,0,0,0,248,51,18,3,0,0,0,0,249,51,19,3,0,0,0,0,250,51,20,3,0,0,0,0,251,51,21,3,0,0,0,0,252,51,22,3,0,0,0,0,0,64,23,3,0,0,0,0,16,64,24,3,0,0,0,0,24,64,25,3,0,0,0,0,32,64,26,3,0,0,0,0,40,64,27,3,0,0,0,0,48,64,28,3,0,0,0,0,56,64,29,3,0,0,0,0,57,64,30,3,0,0,0,0,64,64,31,3,0,0,0,0,80,64,32,3,0,0,0,0,88,64,33,3,0,0,0,0,96,64,34,3,0,0,0,0,104,64,35,3,0,0,0,0,112,64,36,3,0,0,0,0,120,64,37,3,0,0,0,0,121,64,38,3,0,0,0,0,128,64,39,3,0,0,0,0,144,64,40,3,0,0,0,0,152,64,41,3,0,0,0,0,160,64,42,3,0,0,0,0,168,64,43,3,0,0,0,0,176,64,44,3,0,0,0,0,184,64,45,3,0,0,0,0,185,64,46,3,0,0,0,0,192,64,47,3,0,0,0,0,208,64,48,3,0,0,0,0,216,64,49,3,0,0,0,0,224,64,50,3,0,0,0,0,232,64,51,3,0,0,0,0,240,64,52,3,0,0,0,0,248,64,53,3,0,0,0,0,249,64,54,3,0,0,0,0,0,65,55,3,0,0,0,0,16,65,56,3,0,0,0,0,24,65,57,3,0,0,0,0,32,65,58,3,0,0,0,0,40,65,59,3,0,0,0,0,48,65,60,3,0,0,0,0,56,65,61,3,0,0,0,0,57,65,62,3,0,0,0,0,58,65,63,3,0,0,0,0,59,65,64,3,0,0,0,0,60,65,65,3,0,0,0,0,128,65,66,3,0,0,0,0,144,65,67,3,0,0,0,0,152,65,68,3,0,0,0,0,160,65,69,3,0,0,0,0,168,65,70,3,0,0,0,0,176,65,71,3,0,0,0,0,184,65,72,3,0,0,0,0,185,65,73,3,0,0,0,0,186,65,74,3,0,0,0,0,187,65,75,3,0,0,0,0,188,65,76,3,0,0,0,0,208,65,77,3,0,0,0,0,232,65,78,3,0,0,0,0,240,65,79,3,0,0,0,0,248,65,80,3,0,0,0,0,249,65,81,3,0,0,0,0,250,65,82,3,0,0,0,0,251,65,83,3,0,0,0,0,0,66,84,3,0,0,0,0,16,66,85,3,0,0,0,0,24,66,86,3,0,0,0,0,32,66,87,3,0,0,0,0,40,66,88,3,0,0,0,0,48,66,89,3,0,0,0,0,56,66,90,3,0,0,0,0,57,66,91,3,0,0,0,0,64,66,92,3,0,0,0,0,80,66,93,3,0,0,0,0,88,66,94,3,0,0,0,0,96,66,95,3,0,0,0,0,104,66,96,3,0,0,0,0,112,66,97,3,0,0,0,0,120,66,98,3,0,0,0,0,121,66,99,3,0,0,0,0,128,66,100,3,0,0,0,0,144,66,101,3,0,0,0,0,152,66,102,3,0,0,0,0,160,66,103,3,0,0,0,0,168,66,104,3,0,0,0,0,176,66,105,3,0,0,0,0,184,66,106,3,0,0,0,0,185,66,107,3,0,0,0,0,192,66,108,3,0,0,0,0,208,66,109,3,0,0,0,0,216,66,110,3,0,0,0,0,224,66,111,3,0,0,0,0,232,66,112,3,0,0,0,0,240,66,113,3,0,0,0,0,248,66,114,3,0,0,0,0,249,66,115,3,0,0,0,0,0,68,116,3,0,0,0,0,16,68,117,3,0,0,0,0,24,68,118,3,0,0,0,0,32,68,119,3,0,0,0,0,40,68,120,3,0,0,0,0,48,68,121,3,0,0,0,0,56,68,122,3,0,0,0,0,57,68,123,3,0,0,0,0,64,68,124,3,0,0,0,0,80,68,125,3,0,0,0,0,88,68,126,3,0,0,0,0,96,68,127,3,0,0,0,0,104,68,128,3,0,0,0,0,112,68,129,3,0,0,0,0,120,68,130,3,0,0,0,0,121,68,131,3,0,0,0,0,128,68,132,3,0,0,0,0,144,68,133,3,0,0,0,0,152,68,134,3,0,0,0,0,160,68,135,3,0,0,0,0,168,68,136,3,0,0,0,0,176,68,137,3,0,0,0,0,184,68,138,3,0,0,0,0,185,68,139,3,0,0,0,0,192,68,140,3,0,0,0,0,208,68,141,3,0,0,0,0,216,68,142,3,0,0,0,0,224,68,143,3,0,0,0,0,232,68,144,3,0,0,0,0,240,68,145,3,0,0,0,0,248,68,146,3,0,0,0,0,249,68,147,3,0,0,0,0,250,68,148,3,0,0,0,0,251,68,149,3,0,0,0,0,252,68,150,3,0,0,0,0,0,70,151,3,0,0,0,0,16,70,152,3,0,0,0,0,24,70,153,3,0,0,0,0,32,70,154,3,0,0,0,0,40,70,155,3,0,0,0,0,48,70,156,3,0,0,0,0,56,70,157,3,0,0,0,0,57,70,158,3,0,0,0,0,64,70,159,3,0,0,0,0,80,70,160,3,0,0,0,0,88,70,161,3,0,0,0,0,96,70,162,3,0,0,0,0,104,70,163,3,0,0,0,0,112,70,164,3,0,0,0,0,120,70,165,3,0,0,0,0,121,70,166,3,0,0,0,0,128,70,167,3,0,0,0,0,144,70,168,3,0,0,0,0,152,70,169,3,0,0,0,0,160,70,170,3,0,0,0,0,168,70,171,3,0,0,0,0,176,70,172,3,0,0,0,0,184,70,173,3,0,0,0,0,185,70,174,3,0,0,0,0,192,70,175,3,0,0,0,0,208,70,176,3,0,0,0,0,216,70,177,3,0,0,0,0,224,70,178,3,0,0,0,0,232,70,179,3,0,0,0,0,240,70,180,3,0,0,0,0,248,70,181,3,0,0,0,0,249,70,182,3,0,0,0,0,250,70,183,3,0,0,0,0,251,70,184,3,0,0,0,0,252,70,246,7,0,0,0,0,0,72,186,3,0,0,0,0,8,72,247,7,0,0,0,0,16,72,248,7,0,0,0,0,24,72,249,7,0,0,0,0,32,72,250,7,0,0,0,0,40,72,251,7,0,0,0,0,48,72,252,7,0,0,0,0,56,72,253,7,0,0,0,0,57,72,194,3,0,0,0,0,64,72,195,3,0,0,0,0,72,72,196,3,0,0,0,0,80,72,197,3,0,0,0,0,104,72,198,3,0,0,0,0,112,72,199,3,0,0,0,0,120,72,200,3,0,0,0,0,121,72,201,3,0,0,0,0,122,72,202,3,0,0,0,0,123,72,203,3,0,0,0,0,128,72,204,3,0,0,0,0,144,72,205,3,0,0,0,0,160,72,206,3,0,0,0,0,168,72,207,3,0,0,0,0,176,72,208,3,0,0,0,0,184,72,209,3,0,0,0,0,185,72,210,3,0,0,0,0,192,72,211,3,0,0,0,0,208,72,212,3,0,0,0,0,224,72,213,3,0,0,0,0,232,72,214,3,0,0,0,0,240,72,215,3,0,0,0,0,248,72,216,3,0,0,0,0,249,72,217,3,0,0,0,0,192,73,218,3,0,0,0,0,0,74,219,3,0,0,0,0,16,74,220,3,0,0,0,0,24,74,221,3,0,0,0,0,32,74,222,3,0,0,0,0,40,74,223,3,0,0,0,0,48,74,224,3,0,0,0,0,56,74,225,3,0,0,0,0,57,74,226,3,0,0,0,0,58,74,227,3,0,0,0,0,59,74,228,3,0,0,0,0,60,74,229,3,0,0,0,0,64,74,230,3,0,0,0,0,72,74,231,3,0,0,0,0,80,74,232,3,0,0,0,0,88,74,233,3,0,0,0,0,96,74,234,3,0,0,0,0,104,74,235,3,0,0,0,0,112,74,236,3,0,0,0,0,120,74,237,3,0,0,0,0,121,74,238,3,0,0,0,0,122,74,239,3,0,0,0,0,123,74,240,3,0,0,0,0,124,74,241,3,0,0,0,0,128,74,242,3,0,0,0,0,136,74,243,3,0,0,0,0,144,74,244,3,0,0,0,0,152,74,245,3,0,0,0,0,160,74,246,3,0,0,0,0,168,74,247,3,0,0,0,0,176,74,248,3,0,0,0,0,184,74,249,3,0,0,0,0,185,74,250,3,0,0,0,0,186,74,251,3,0,0,0,0,187,74,252,3,0,0,0,0,188,74,253,3,0,0,0,0,192,74,254,3,0,0,0,0,208,74,255,3,0,0,0,0,216,74,0,4,0,0,0,0,224,74,1,4,0,0,0,0,232,74,2,4,0,0,0,0,240,74,3,4,0,0,0,0,248,74,4,4,0,0,0,0,249,74,5,4,0,0,0,0,0,76,6,4,0,0,0,0,16,76,7,4,0,0,0,0,24,76,8,4,0,0,0,0,32,76,9,4,0,0,0,0,40,76,10,4,0,0,0,0,48,76,11,4,0,0,0,0,56,76,12,4,0,0,0,0,57,76,13,4,0,0,0,0,58,76,14,4,0,0,0,0,59,76,15,4,0,0,0,0,60,76,16,4,0,0,0,0,64,76,17,4,0,0,0,0,80,76,18,4,0,0,0,0,88,76,19,4,0,0,0,0,96,76,20,4,0,0,0,0,104,76,21,4,0,0,0,0,112,76,22,4,0,0,0,0,120,76,23,4,0,0,0,0,121,76,24,4,0,0,0,0,122,76,25,4,0,0,0,0,123,76,26,4,0,0,0,0,124,76,27,4,0,0,0,0,144,76,28,4,0,0,0,0,152,76,29,4,0,0,0,0,168,76,30,4,0,0,0,0,176,76,31,4,0,0,0,0,184,76,32,4,0,0,0,0,185,76,33,4,0,0,0,0,186,76,34,4,0,0,0,0,187,76,35,4,0,0,0,0,208,76,36,4,0,0,0,0,216,76,37,4,0,0,0,0,232,76,38,4,0,0,0,0,240,76,39,4,0,0,0,0,248,76,40,4,0,0,0,0,249,76,41,4,0,0,0,0,250,76,42,4,0,0,0,0,251,76,43,4,0,0,0,0,64,78,44,4,0,0,0,0,80,78,45,4,0,0,0,0,88,78,46,4,0,0,0,0,96,78,47,4,0,0,0,0,104,78,48,4,0,0,0,0,112,78,49,4,0,0,0,0,113,78,50,4,0,0,0,0,114,78,51,4,0,0,0,0,115,78,52,4,0,0,0,0,116,78,53,4,0,0,0,0,117,78,54,4,0,0,0,0,118,78,55,4,0,0,0,0,119,78,56,4,0,0,0,0,122,78,57,4,0,0,0,0,123,78,58,4,0,0,0,0,144,78,59,4,0,0,0,0,168,78,60,4,0,0,0,0,176,78,61,4,0,0,0,0,184,78,62,4,0,0,0,0,185,78,63,4,0,0,0,0,186,78,64,4,0,0,0,0,187,78,65,4,0,0,0,0,208,78,66,4,0,0,0,0,232,78,67,4,0,0,0,0,240,78,68,4,0,0,0,0,248,78,69,4,0,0,0,0,249,78,70,4,0,0,0,0,250,78,71,4,0,0,0,0,251,78,72,4,0,0,0,0,0,80,73,4,0,0,0,0,16,80,74,4,0,0,0,0,24,80,75,4,0,0,0,0,32,80,76,4,0,0,0,0,40,80,77,4,0,0,0,0,48,80,78,4,0,0,0,0,56,80,79,4,0,0,0,0,57,80,80,4,0,0,0,0,64,80,81,4,0,0,0,0,72,80,82,4,0,0,0,0,80,80,83,4,0,0,0,0,88,80,84,4,0,0,0,0,96,80,85,4,0,0,0,0,104,80,86,4,0,0,0,0,112,80,87,4,0,0,0,0,120,80,88,4,0,0,0,0,121,80,89,4,0,0,0,0,128,80,90,4,0,0,0,0,136,80,91,4,0,0,0,0,144,80,92,4,0,0,0,0,152,80,93,4,0,0,0,0,160,80,94,4,0,0,0,0,168,80,95,4,0,0,0,0,176,80,96,4,0,0,0,0,184,80,97,4,0,0,0,0,185,80,98,4,0,0,0,0,192,80,99,4,0,0,0,0,200,80,100,4,0,0,0,0,208,80,101,4,0,0,0,0,216,80,102,4,0,0,0,0,224,80,103,4,0,0,0,0,232,80,104,4,0,0,0,0,240,80,105,4,0,0,0,0,248,80,106,4,0,0,0,0,249,80,107,4,0,0,0,0,250,80,108,4,0,0,0,0,251,80,109,4,0,0,0,0,252,80,110,4,0,0,0,0,0,81,111,4,0,0,0,0,16,81,112,4,0,0,0,0,24,81,113,4,0,0,0,0,32,81,114,4,0,0,0,0,40,81,115,4,0,0,0,0,48,81,116,4,0,0,0,0,56,81,117,4,0,0,0,0,57,81,118,4,0,0,0,0,64,81,119,4,0,0,0,0,72,81,120,4,0,0,0,0,80,81,121,4,0,0,0,0,88,81,122,4,0,0,0,0,96,81,123,4,0,0,0,0,104,81,124,4,0,0,0,0,112,81,125,4,0,0,0,0,120,81,126,4,0,0,0,0,121,81,127,4,0,0,0,0,128,81,128,4,0,0,0,0,136,81,129,4,0,0,0,0,144,81,130,4,0,0,0,0,152,81,131,4,0,0,0,0,160,81,132,4,0,0,0,0,168,81,133,4,0,0,0,0,176,81,134,4,0,0,0,0,184,81,135,4,0,0,0,0,185,81,136,4,0,0,0,0,192,81,137,4,0,0,0,0,200,81,138,4,0,0,0,0,208,81,139,4,0,0,0,0,216,81,140,4,0,0,0,0,224,81,141,4,0,0,0,0,232,81,142,4,0,0,0,0,240,81,143,4,0,0,0,0,248,81,144,4,0,0,0,0,249,81,145,4,0,0,0,0,250,81,146,4,0,0,0,0,251,81,147,4,0,0,0,0,252,81,148,4,0,0,0,0,192,82,149,4,0,0,0,0,200,82,150,4,0,0,0,0,208,82,151,4,0,0,0,0,216,82,152,4,0,0,0,0,224,82,153,4,0,0,0,0,232,82,154,4,0,0,0,0,240,82,155,4,0,0,0,0,248,82,156,4,0,0,0,0,249,82,157,4,0,0,0,0,250,82,158,4,0,0,0,0,251,82,159,4,0,0,0,0,252,82,160,4,0,0,0,0,192,83,161,4,0,0,0,0,200,83,162,4,0,0,0,0,208,83,163,4,0,0,0,0,216,83,164,4,0,0,0,0,224,83,165,4,0,0,0,0,232,83,166,4,0,0,0,0,240,83,167,4,0,0,0,0,248,83,168,4,0,0,0,0,249,83,169,4,0,0,0,0,250,83,170,4,0,0,0,0,251,83,171,4,0,0,0,0,252,83,172,4,0,0,0,0,192,84,173,4,0,0,0,0,200,84,174,4,0,0,0,0,208,84,175,4,0,0,0,0,216,84,176,4,0,0,0,0,224,84,177,4,0,0,0,0,232,84,178,4,0,0,0,0,240,84,179,4,0,0,0,0,248,84,180,4,0,0,0,0,249,84,181,4,0,0,0,0,250,84,182,4,0,0,0,0,251,84,183,4,0,0,0,0,252,84,184,4,0,0,0,0,192,85,185,4,0,0,0,0,200,85,186,4,0,0,0,0,208,85,187,4,0,0,0,0,216,85,188,4,0,0,0,0,224,85,189,4,0,0,0,0,232,85,190,4,0,0,0,0,240,85,191,4,0,0,0,0,248,85,192,4,0,0,0,0,249,85,193,4,0,0,0,0,250,85,194,4,0,0,0,0,251,85,195,4,0,0,0,0,252,85,196,4,0,0,0,0,192,86,197,4,0,0,0,0,200,86,198,4,0,0,0,0,208,86,199,4,0,0,0,0,216,86,200,4,0,0,0,0,224,86,201,4,0,0,0,0,232,86,202,4,0,0,0,0,240,86,203,4,0,0,0,0,248,86,204,4,0,0,0,0,249,86,205,4,0,0,0,0,250,86,206,4,0,0,0,0,251,86,207,4,0,0,0,0,252,86,208,4,0,0,0,0,192,87,209,4,0,0,0,0,200,87,210,4,0,0,0,0,208,87,211,4,0,0,0,0,216,87,212,4,0,0,0,0,224,87,213,4,0,0,0,0,232,87,214,4,0,0,0,0,240,87,215,4,0,0,0,0,248,87,216,4,0,0,0,0,249,87,217,4,0,0,0,0,250,87,218,4,0,0,0,0,251,87,219,4,0,0,0,0,252,87,220,4,0,0,0,0,192,88,221,4,0,0,0,0,200,88,222,4,0,0,0,0,208,88,223,4,0,0,0,0,216,88,224,4,0,0,0,0,224,88,225,4,0,0,0,0,232,88,226,4,0,0,0,0,240,88,227,4,0,0,0,0,248,88,228,4,0,0,0,0,249,88,229,4,0,0,0,0,250,88,230,4,0,0,0,0,251,88,231,4,0,0,0,0,252,88,232,4,0,0,0,0,192,89,233,4,0,0,0,0,200,89,234,4,0,0,0,0,208,89,235,4,0,0,0,0,216,89,236,4,0,0,0,0,224,89,237,4,0,0,0,0,232,89,238,4,0,0,0,0,240,89,239,4,0,0,0,0,248,89,240,4,0,0,0,0,249,89,241,4,0,0,0,0,250,89,242,4,0,0,0,0,251,89,243,4,0,0,0,0,252,89,244,4,0,0,0,0,192,90,245,4,0,0,0,0,200,90,246,4,0,0,0,0,208,90,247,4,0,0,0,0,216,90,248,4,0,0,0,0,224,90,249,4,0,0,0,0,232,90,250,4,0,0,0,0,240,90,251,4,0,0,0,0,248,90,252,4,0,0,0,0,249,90,253,4,0,0,0,0,250,90,254,4,0,0,0,0,251,90,255,4,0,0,0,0,252,90,0,5,0,0,0,0,192,91,1,5,0,0,0,0,200,91,2,5,0,0,0,0,208,91,3,5,0,0,0,0,216,91,4,5,0,0,0,0,224,91,5,5,0,0,0,0,232,91,6,5,0,0,0,0,240,91,7,5,0,0,0,0,248,91,8,5,0,0,0,0,249,91,9,5,0,0,0,0,250,91,10,5,0,0,0,0,251,91,11,5,0,0,0,0,252,91,12,5,0,0,0,0,192,92,13,5,0,0,0,0,200,92,14,5,0,0,0,0,208,92,15,5,0,0,0,0,216,92,16,5,0,0,0,0,224,92,17,5,0,0,0,0,232,92,18,5,0,0,0,0,240,92,19,5,0,0,0,0,248,92,20,5,0,0,0,0,249,92,21,5,0,0,0,0,250,92,22,5,0,0,0,0,251,92,23,5,0,0,0,0,252,92,24,5,0,0,0,0,192,93,25,5,0,0,0,0,200,93,26,5,0,0,0,0,208,93,27,5,0,0,0,0,216,93,28,5,0,0,0,0,224,93,29,5,0,0,0,0,232,93,30,5,0,0,0,0,240,93,31,5,0,0,0,0,248,93,32,5,0,0,0,0,249,93,33,5,0,0,0,0,250,93,34,5,0,0,0,0,251,93,35,5,0,0,0,0,252,93,36,5,0,0,0,0,192,94,37,5,0,0,0,0,200,94,38,5,0,0,0,0,208,94,39,5,0,0,0,0,216,94,40,5,0,0,0,0,224,94,41,5,0,0,0,0,232,94,42,5,0,0,0,0,240,94,43,5,0,0,0,0,248,94,44,5,0,0,0,0,249,94,45,5,0,0,0,0,250,94,46,5,0,0,0,0,251,94,47,5,0,0,0,0,252,94,48,5,0,0,0,0,192,95,49,5,0,0,0,0,200,95,50,5,0,0,0,0,208,95,51,5,0,0,0,0,216,95,52,5,0,0,0,0,224,95,53,5,0,0,0,0,232,95,54,5,0,0,0,0,240,95,55,5,0,0,0,0,248,95,56,5,0,0,0,0,249,95,57,5,0,0,0,0,250,95,58,5,0,0,0,0,251,95,59,5,0,0,0,0,252,95,60,5,0,0,0,0,0,96,61,5,0,0,0,0,1,96,62,5,0,0,0,0,255,96,63,5,0,0,0,0,0,97,64,5,0,0,0,0,1,97,65,5,0,0,0,0,255,97,66,5,0,0,0,0,0,98,67,5,0,0,0,0,1,98,68,5,0,0,0,0,255,98,69,5,0,0,0,0,0,99,70,5,0,0,0,0,1,99,71,5,0,0,0,0,255,99,72,5,0,0,0,0,0,100,73,5,0,0,0,0,1,100,74,5,0,0,0,0,255,100,75,5,0,0,0,0,0,101,76,5,0,0,0,0,1,101,77,5,0,0,0,0,255,101,78,5,0,0,0,0,0,102,79,5,0,0,0,0,1,102,80,5,0,0,0,0,255,102,81,5,0,0,0,0,0,103,82,5,0,0,0,0,1,103,83,5,0,0,0,0,255,103,84,5,0,0,0,0,0,104,85,5,0,0,0,0,1,104,86,5,0,0,0,0,255,104,87,5,0,0,0,0,0,105,88,5,0,0,0,0,1,105,89,5,0,0,0,0,255,105,90,5,0,0,0,0,0,106,91,5,0,0,0,0,1,106,92,5,0,0,0,0,255,106,93,5,0,0,0,0,0,107,94,5,0,0,0,0,1,107,95,5,0,0,0,0,255,107,96,5,0,0,0,0,0,108,97,5,0,0,0,0,1,108,98,5,0,0,0,0,255,108,99,5,0,0,0,0,0,109,100,5,0,0,0,0,1,109,101,5,0,0,0,0,255,109,102,5,0,0,0,0,0,110,103,5,0,0,0,0,1,110,104,5,0,0,0,0,255,110,105,5,0,0,0,0,0,111,106,5,0,0,0,0,1,111,107,5,0,0,0,0,255,111,108,5,0,0,0,0,0,112,109,5,0,0,0,0,0,113,110,5,0,0,0,0,1,113,111,5,0,0,0,0,0,128,112,5,0,0,0,0,16,128,113,5,0,0,0,0,24,128,114,5,0,0,0,0,32,128,115,5,0,0,0,0,40,128,116,5,0,0,0,0,48,128,117,5,0,0,0,0,56,128,118,5,0,0,0,0,57,128,119,5,0,0,0,0,58,128,120,5,0,0,0,0,59,128,121,5,0,0,0,0,60,128,122,5,0,0,0,0,64,128,123,5,0,0,0,0,80,128,124,5,0,0,0,0,88,128,125,5,0,0,0,0,96,128,126,5,0,0,0,0,104,128,127,5,0,0,0,0,112,128,128,5,0,0,0,0,120,128,129,5,0,0,0,0,121,128,130,5,0,0,0,0,122,128,131,5,0,0,0,0,123,128,132,5,0,0,0,0,124,128,133,5,0,0,0,0,128,128,134,5,0,0,0,0,144,128,135,5,0,0,0,0,152,128,136,5,0,0,0,0,160,128,137,5,0,0,0,0,168,128,138,5,0,0,0,0,176,128,139,5,0,0,0,0,184,128,140,5,0,0,0,0,185,128,141,5,0,0,0,0,186,128,142,5,0,0,0,0,187,128,143,5,0,0,0,0,188,128,144,5,0,0,0,0,192,128,145,5,0,0,0,0,208,128,146,5,0,0,0,0,216,128,147,5,0,0,0,0,224,128,148,5,0,0,0,0,232,128,149,5,0,0,0,0,240,128,150,5,0,0,0,0,248,128,151,5,0,0,0,0,249,128,152,5,0,0,0,0,250,128,153,5,0,0,0,0,251,128,154,5,0,0,0,0,252,128,254,7,0,0,0,0,0,129,255,7,0,0,0,0,8,129,157,5,0,0,0,0,16,129,158,5,0,0,0,0,24,129,159,5,0,0,0,0,32,129,160,5,0,0,0,0,40,129,161,5,0,0,0,0,48,129,162,5,0,0,0,0,56,129,163,5,0,0,0,0,57,129,164,5,0,0,0,0,64,129,165,5,0,0,0,0,72,129,166,5,0,0,0,0,80,129,167,5,0,0,0,0,88,129,168,5,0,0,0,0,96,129,169,5,0,0,0,0,104,129,170,5,0,0,0,0,112,129,171,5,0,0,0,0,120,129,172,5,0,0,0,0,121,129,173,5,0,0,0,0,128,129,174,5,0,0,0,0,136,129,175,5,0,0,0,0,144,129,176,5,0,0,0,0,152,129,177,5,0,0,0,0,160,129,178,5,0,0,0,0,168,129,179,5,0,0,0,0,176,129,180,5,0,0,0,0,184,129,181,5,0,0,0,0,185,129,182,5,0,0,0,0,192,129,183,5,0,0,0,0,208,129,184,5,0,0,0,0,216,129,185,5,0,0,0,0,224,129,186,5,0,0,0,0,232,129,187,5,0,0,0,0,240,129,188,5,0,0,0,0,248,129,189,5,0,0,0,0,249,129,190,5,0,0,0,0,250,129,191,5,0,0,0,0,251,129,192,5,0,0,0,0,252,129,193,5,0,0,0,0,0,144,194,5,0,0,0,0,16,144,195,5,0,0,0,0,24,144,196,5,0,0,0,0,32,144,197,5,0,0,0,0,40,144,198,5,0,0,0,0,48,144,199,5,0,0,0,0,56,144,200,5,0,0,0,0,57,144,201,5,0,0,0,0,58,144,202,5,0,0,0,0,59,144,203,5,0,0,0,0,60,144,204,5,0,0,0,0,64,144,205,5,0,0,0,0,72,144,206,5,0,0,0,0,80,144,207,5,0,0,0,0,88,144,208,5,0,0,0,0,96,144,209,5,0,0,0,0,104,144,210,5,0,0,0,0,112,144,211,5,0,0,0,0,120,144,212,5,0,0,0,0,121,144,213,5,0,0,0,0,122,144,214,5,0,0,0,0,123,144,215,5,0,0,0,0,124,144,216,5,0,0,0,0,128,144,217,5,0,0,0,0,136,144,218,5,0,0,0,0,144,144,219,5,0,0,0,0,152,144,220,5,0,0,0,0,160,144,221,5,0,0,0,0,168,144,222,5,0,0,0,0,176,144,223,5,0,0,0,0,184,144,224,5,0,0,0,0,185,144,225,5,0,0,0,0,186,144,226,5,0,0,0,0,187,144,227,5,0,0,0,0,188,144,228,5,0,0,0,0,192,144,229,5,0,0,0,0,200,144,230,5,0,0,0,0,208,144,231,5,0,0,0,0,216,144,232,5,0,0,0,0,224,144,233,5,0,0,0,0,232,144,234,5,0,0,0,0,240,144,235,5,0,0,0,0,248,144,236,5,0,0,0,0,249,144,237,5,0,0,0,0,250,144,238,5,0,0,0,0,251,144,239,5,0,0,0,0,252,144,240,5,0,0,0,0,0,145,241,5,0,0,0,0,8,145,242,5,0,0,0,0,16,145,243,5,0,0,0,0,24,145,244,5,0,0,0,0,32,145,245,5,0,0,0,0,40,145,246,5,0,0,0,0,48,145,247,5,0,0,0,0,56,145,248,5,0,0,0,0,57,145,249,5,0,0,0,0,64,145,250,5,0,0,0,0,72,145,251,5,0,0,0,0,80,145,252,5,0,0,0,0,88,145,253,5,0,0,0,0,96,145,254,5,0,0,0,0,104,145,255,5,0,0,0,0,112,145,0,6,0,0,0,0,120,145,1,6,0,0,0,0,121,145,2,6,0,0,0,0,128,145,3,6,0,0,0,0,136,145,4,6,0,0,0,0,144,145,5,6,0,0,0,0,152,145,6,6,0,0,0,0,160,145,7,6,0,0,0,0,168,145,8,6,0,0,0,0,176,145,9,6,0,0,0,0,184,145,10,6,0,0,0,0,185,145,11,6,0,0,0,0,192,145,12,6,0,0,0,0,200,145,13,6,0,0,0,0,208,145,14,6,0,0,0,0,216,145,15,6,0,0,0,0,224,145,16,6,0,0,0,0,232,145,17,6,0,0,0,0,240,145,18,6,0,0,0,0,248,145,19,6,0,0,0,0,249,145,20,6,0,0,0,0,250,145,21,6,0,0,0,0,251,145,22,6,0,0,0,0,252,145,23,6,0,0,0,0,0,176,24,6,0,0,0,0,16,176,25,6,0,0,0,0,24,176,26,6,0,0,0,0,32,176,27,6,0,0,0,0,40,176,28,6,0,0,0,0,48,176,29,6,0,0,0,0,56,176,30,6,0,0,0,0,57,176,31,6,0,0,0,0,58,176,32,6,0,0,0,0,59,176,33,6,0,0,0,0,60,176,34,6,0,0,0,0,64,176,35,6,0,0,0,0,72,176,36,6,0,0,0,0,80,176,37,6,0,0,0,0,88,176,38,6,0,0,0,0,96,176,39,6,0,0,0,0,104,176,40,6,0,0,0,0,112,176,41,6,0,0,0,0,120,176,42,6,0,0,0,0,121,176,43,6,0,0,0,0,122,176,44,6,0,0,0,0,123,176,45,6,0,0,0,0,124,176,46,6,0,0,0,0,128,176,47,6,0,0,0,0,136,176,48,6,0,0,0,0,144,176,49,6,0,0,0,0,152,176,50,6,0,0,0,0,160,176,51,6,0,0,0,0,168,176,52,6,0,0,0,0,176,176,53,6,0,0,0,0,184,176,54,6,0,0,0,0,185,176,55,6,0,0,0,0,186,176,56,6,0,0,0,0,187,176,57,6,0,0,0,0,188,176,58,6,0,0,0,0,192,176,59,6,0,0,0,0,200,176,60,6,0,0,0,0,208,176,61,6,0,0,0,0,216,176,62,6,0,0,0,0,224,176,63,6,0,0,0,0,232,176,64,6,0,0,0,0,240,176,65,6,0,0,0,0,248,176,66,6,0,0,0,0,249,176,67,6,0,0,0,0,250,176,68,6,0,0,0,0,251,176,69,6,0,0,0,0,252,176,70,6,0,0,0,0,0,177,71,6,0,0,0,0,8,177,72,6,0,0,0,0,16,177,73,6,0,0,0,0,24,177,74,6,0,0,0,0,32,177,75,6,0,0,0,0,40,177,76,6,0,0,0,0,48,177,77,6,0,0,0,0,56,177,78,6,0,0,0,0,57,177,79,6,0,0,0,0,64,177,80,6,0,0,0,0,72,177,81,6,0,0,0,0,80,177,82,6,0,0,0,0,88,177,83,6,0,0,0,0,96,177,84,6,0,0,0,0,104,177,85,6,0,0,0,0,112,177,86,6,0,0,0,0,120,177,87,6,0,0,0,0,121,177,88,6,0,0,0,0,128,177,89,6,0,0,0,0,136,177,90,6,0,0,0,0,144,177,91,6,0,0,0,0,152,177,92,6,0,0,0,0,160,177,93,6,0,0,0,0,168,177,94,6,0,0,0,0,176,177,95,6,0,0,0,0,184,177,96,6,0,0,0,0,185,177,97,6,0,0,0,0,192,177,98,6,0,0,0,0,200,177,99,6,0,0,0,0,208,177,100,6,0,0,0,0,216,177,101,6,0,0,0,0,224,177,102,6,0,0,0,0,232,177,103,6,0,0,0,0,240,177,104,6,0,0,0,0,248,177,105,6,0,0,0,0,249,177,106,6,0,0,0,0,250,177,107,6,0,0,0,0,251,177,108,6,0,0,0,0,252,177,109,6,0,0,0,0,0,192,110,6,0,0,0,0,16,192,111,6,0,0,0,0,24,192,112,6,0,0,0,0,32,192,113,6,0,0,0,0,40,192,114,6,0,0,0,0,48,192,115,6,0,0,0,0,56,192,116,6,0,0,0,0,57,192,117,6,0,0,0,0,58,192,118,6,0,0,0,0,59,192,119,6,0,0,0,0,60,192,120,6,0,0,0,0,64,192,121,6,0,0,0,0,80,192,122,6,0,0,0,0,88,192,123,6,0,0,0,0,96,192,124,6,0,0,0,0,104,192,125,6,0,0,0,0,112,192,126,6,0,0,0,0,120,192,127,6,0,0,0,0,121,192,128,6,0,0,0,0,122,192,129,6,0,0,0,0,123,192,130,6,0,0,0,0,124,192,131,6,0,0,0,0,128,192,132,6,0,0,0,0,144,192,133,6,0,0,0,0,152,192,134,6,0,0,0,0,160,192,135,6,0,0,0,0,168,192,136,6,0,0,0,0,176,192,137,6,0,0,0,0,184,192,138,6,0,0,0,0,185,192,139,6,0,0,0,0,186,192,140,6,0,0,0,0,187,192,141,6,0,0,0,0,188,192,142,6,0,0,0,0,192,192,143,6,0,0,0,0,208,192,144,6,0,0,0,0,216,192,145,6,0,0,0,0,224,192,146,6,0,0,0,0,232,192,147,6,0,0,0,0,240,192,148,6,0,0,0,0,248,192,149,6,0,0,0,0,249,192,150,6,0,0,0,0,250,192,151,6,0,0,0,0,251,192,152,6,0,0,0,0,252,192,0,8,0,0,0,0,0,193,1,8,0,0,0,0,8,193,155,6,0,0,0,0,16,193,156,6,0,0,0,0,24,193,157,6,0,0,0,0,32,193,158,6,0,0,0,0,40,193,159,6,0,0,0,0,48,193,160,6,0,0,0,0,56,193,161,6,0,0,0,0,57,193,162,6,0,0,0,0,64,193,163,6,0,0,0,0,72,193,164,6,0,0,0,0,80,193,165,6,0,0,0,0,88,193,166,6,0,0,0,0,96,193,167,6,0,0,0,0,104,193,168,6,0,0,0,0,112,193,169,6,0,0,0,0,120,193,170,6,0,0,0,0,121,193,171,6,0,0,0,0,136,193,172,6,0,0,0,0,144,193,173,6,0,0,0,0,152,193,174,6,0,0,0,0,160,193,175,6,0,0,0,0,168,193,176,6,0,0,0,0,176,193,177,6,0,0,0,0,184,193,178,6,0,0,0,0,185,193,179,6,0,0,0,0,192,193,180,6,0,0,0,0,208,193,181,6,0,0,0,0,216,193,182,6,0,0,0,0,224,193,183,6,0,0,0,0,232,193,184,6,0,0,0,0,240,193,185,6,0,0,0,0,248,193,186,6,0,0,0,0,249,193,187,6,0,0,0,0,250,193,188,6,0,0,0,0,251,193,189,6,0,0,0,0,252,193,190,6,0,0,0,0,0,208,191,6,0,0,0,0,16,208,192,6,0,0,0,0,24,208,193,6,0,0,0,0,32,208,194,6,0,0,0,0,40,208,195,6,0,0,0,0,48,208,196,6,0,0,0,0,56,208,197,6,0,0,0,0,57,208,198,6,0,0,0,0,58,208,199,6,0,0,0,0,59,208,200,6,0,0,0,0,60,208,201,6,0,0,0,0,64,208,202,6,0,0,0,0,72,208,203,6,0,0,0,0,80,208,204,6,0,0,0,0,88,208,205,6,0,0,0,0,96,208,206,6,0,0,0,0,104,208,207,6,0,0,0,0,112,208,208,6,0,0,0,0,120,208,209,6,0,0,0,0,121,208,210,6,0,0,0,0,122,208,211,6,0,0,0,0,123,208,212,6,0,0,0,0,124,208,213,6,0,0,0,0,128,208,214,6,0,0,0,0,136,208,215,6,0,0,0,0,144,208,216,6,0,0,0,0,152,208,217,6,0,0,0,0,160,208,218,6,0,0,0,0,168,208,219,6,0,0,0,0,176,208,220,6,0,0,0,0,184,208,221,6,0,0,0,0,185,208,222,6,0,0,0,0,186,208,223,6,0,0,0,0,187,208,224,6,0,0,0,0,188,208,225,6,0,0,0,0,192,208,226,6,0,0,0,0,200,208,227,6,0,0,0,0,208,208,228,6,0,0,0,0,216,208,229,6,0,0,0,0,224,208,230,6,0,0,0,0,232,208,231,6,0,0,0,0,240,208,232,6,0,0,0,0,248,208,233,6,0,0,0,0,249,208,234,6,0,0,0,0,250,208,235,6,0,0,0,0,251,208,236,6,0,0,0,0,252,208,237,6,0,0,0,0,0,209,238,6,0,0,0,0,8,209,239,6,0,0,0,0,16,209,240,6,0,0,0,0,24,209,241,6,0,0,0,0,32,209,242,6,0,0,0,0,40,209,243,6,0,0,0,0,48,209,244,6,0,0,0,0,56,209,245,6,0,0,0,0,57,209,246,6,0,0,0,0,64,209,247,6,0,0,0,0,72,209,248,6,0,0,0,0,80,209,249,6,0,0,0,0,88,209,250,6,0,0,0,0,96,209,251,6,0,0,0,0,104,209,252,6,0,0,0,0,112,209,253,6,0,0,0,0,120,209,254,6,0,0,0,0,121,209,255,6,0,0,0,0,128,209,0,7,0,0,0,0,136,209,1,7,0,0,0,0,144,209,2,7,0,0,0,0,152,209,3,7,0,0,0,0,160,209,4,7,0,0,0,0,168,209,5,7,0,0,0,0,176,209,6,7,0,0,0,0,184,209,7,7,0,0,0,0,185,209,8,7,0,0,0,0,192,209,9,7,0,0,0,0,200,209,10,7,0,0,0,0,208,209,11,7,0,0,0,0,216,209,12,7,0,0,0,0,224,209,13,7,0,0,0,0,232,209,14,7,0,0,0,0,240,209,15,7,0,0,0,0,248,209,16,7,0,0,0,0,249,209,17,7,0,0,0,0,250,209,18,7,0,0,0,0,251,209,19,7,0,0,0,0,252,209,20,7,0,0,0,0,0,224,21,7,0,0,0,0,8,224,22,7,0,0,0,0,16,224,23,7,0,0,0,0,24,224,24,7,0,0,0,0,32,224,25,7,0,0,0,0,40,224,26,7,0,0,0,0,48,224,27,7,0,0,0,0,56,224,28,7,0,0,0,0,64,224,29,7,0,0,0,0,72,224,30,7,0,0,0,0,80,224,31,7,0,0,0,0,88,224,32,7,0,0,0,0,96,224,33,7,0,0,0,0,104,224,34,7,0,0,0,0,112,224,35,7,0,0,0,0,120,224,36,7,0,0,0,0,128,224,37,7,0,0,0,0,136,224,38,7,0,0,0,0,144,224,39,7,0,0,0,0,152,224,40,7,0,0,0,0,160,224,41,7,0,0,0,0,168,224,42,7,0,0,0,0,176,224,43,7,0,0,0,0,184,224,44,7,0,0,0,0,208,224,45,7,0,0,0,0,216,224,46,7,0,0,0,0,224,224,47,7,0,0,0,0,232,224,48,7,0,0,0,0,240,224,49,7,0,0,0,0,248,224,50,7,0,0,0,0,249,224,51,7,0,0,0,0,0,225,52,7,0,0,0,0,8,225,53,7,0,0,0,0,16,225,54,7,0,0,0,0,24,225,55,7,0,0,0,0,32,225,56,7,0,0,0,0,40,225,57,7,0,0,0,0,48,225,58,7,0,0,0,0,56,225,59,7,0,0,0,0,64,225,60,7,0,0,0,0,72,225,61,7,0,0,0,0,80,225,62,7,0,0,0,0,88,225,63,7,0,0,0,0,96,225,64,7,0,0,0,0,104,225,65,7,0,0,0,0,112,225,66,7,0,0,0,0,120,225,67,7,0,0,0,0,128,225,68,7,0,0,0,0,136,225,69,7,0,0,0,0,144,225,70,7,0,0,0,0,152,225,71,7,0,0,0,0,160,225,72,7,0,0,0,0,168,225,73,7,0,0,0,0,176,225,74,7,0,0,0,0,184,225,75,7,0,0,0,0,208,225,76,7,0,0,0,0,216,225,77,7,0,0,0,0,224,225,78,7,0,0,0,0,232,225,79,7,0,0,0,0,240,225,80,7,0,0,0,0,248,225,81,7,0,0,0,0,249,225,82,7,0,0,0,0,208,226,83,7,0,0,0,0,216,226,84,7,0,0,0,0,224,226,85,7,0,0,0,0,232,226,86,7,0,0,0,0,240,226,87,7,0,0,0,0,248,226,88,7,0,0,0,0,249,226,89,7,0,0,0,0,208,227,90,7,0,0,0,0,216,227,91,7,0,0,0,0,224,227,92,7,0,0,0,0,232,227,93,7,0,0,0,0,240,227,94,7,0,0,0,0,248,227,95,7,0,0,0,0,249,227,96,7,0,0,0,0,208,228,97,7,0,0,0,0,216,228,98,7,0,0,0,0,224,228,99,7,0,0,0,0,232,228,100,7,0,0,0,0,240,228,101,7,0,0,0,0,248,228,102,7,0,0,0,0,249,228,103,7,0,0,0,0,208,229,104,7,0,0,0,0,216,229,105,7,0,0,0,0,224,229,106,7,0,0,0,0,232,229,107,7,0,0,0,0,240,229,108,7,0,0,0,0,248,229,109,7,0,0,0,0,249,229,110,7,0,0,0,0,208,230,111,7,0,0,0,0,216,230,112,7,0,0,0,0,224,230,113,7,0,0,0,0,232,230,114,7,0,0,0,0,240,230,115,7,0,0,0,0,248,230,116,7,0,0,0,0,249,230,117,7,0,0,0,0,208,231,118,7,0,0,0,0,216,231,119,7,0,0,0,0,224,231,120,7,0,0,0,0,232,231,121,7,0,0,0,0,240,231,122,7,0,0,0,0,248,231,123,7,0,0,0,0,249,231,124,7,0,0,0,0,192,232,125,7,0,0,0,0,208,232,126,7,0,0,0,0,232,232,127,7,0,0,0,0,240,232,128,7,0,0,0,0,248,232,129,7,0,0,0,0,249,232,130,7,0,0,0,0,250,232,131,7,0,0,0,0,251,232,132,7,0,0,0,0,192,233,133,7,0,0,0,0,208,233,134,7,0,0,0,0,232,233,135,7,0,0,0,0,240,233,136,7,0,0,0,0,248,233,137,7,0,0,0,0,249,233,138,7,0,0,0,0,250,233,139,7,0,0,0,0,251,233,140,7,0,0,0,0,192,234,141,7,0,0,0,0,208,234,142,7,0,0,0,0,232,234,143,7,0,0,0,0,240,234,144,7,0,0,0,0,248,234,145,7,0,0,0,0,249,234,146,7,0,0,0,0,192,235,147,7,0,0,0,0,208,235,148,7,0,0,0,0,232,235,149,7,0,0,0,0,240,235,150,7,0,0,0,0,248,235,151,7,0,0,0,0,249,235,152,7,0,0,0,0,250,235,153,7,0,0,0,0,251,235,154,7,0,0,0,0,192,236,155,7,0,0,0,0,208,236,156,7,0,0,0,0,232,236,157,7,0,0,0,0,240,236,158,7,0,0,0,0,248,236,159,7,0,0,0,0,249,236,160,7,0,0,0,0,192,237,161,7,0,0,0,0,208,237,162,7,0,0,0,0,232,237,163,7,0,0,0,0,240,237,164,7,0,0,0,0,248,237,165,7,0,0,0,0,249,237,166,7,0,0,0,0,250,237,167,7,0,0,0,0,251,237,168,7,0,0,0,0,192,238,169,7,0,0,0,0,208,238,170,7,0,0,0,0,232,238,171,7,0,0,0,0,240,238,172,7,0,0,0,0,248,238,173,7,0,0,0,0,249,238,174,7,0,0,0,0,192,239,175,7,0,0,0,0,208,239,176,7,0,0,0,0,232,239,177,7,0,0,0,0,240,239,178,7,0,0,0,0,248,239,179,7,0,0,0,0,249,239,180,7,0,0,0,0,0,242,181,7,0,0,0,0,8,242,182,7,0,0,0,0,16,242,183,7,0,0,0,0,24,242,184,7,0,0,0,0,32,242,185,7,0,0,0,0,40,242,186,7,0,0,0,0,48,242,187,7,0,0,0,0,56,242,188,7,0,0,0,0,57,242,189,7,0,0,0,0,58,242,190,7,0,0,0,0,59,242,191,7,0,0,0,0,60,242,192,7,0,0,0,0,64,242,193,7,0,0,0,0,72,242,194,7,0,0,0,0,80,242,195,7,0,0,0,0,88,242,196,7,0,0,0,0,96,242,197,7,0,0,0,0,104,242,198,7,0,0,0,0,112,242,199,7,0,0,0,0,120,242,200,7,0,0,0,0,121,242,201,7,0,0,0,0,122,242,202,7,0,0,0,0,123,242,203,7,0,0,0,0,124,242,204,7,0,0,0,0,128,242,205,7,0,0,0,0,192,242,206,7,0,0,0,0,16,243,207,7,0,0,0,0,32,243,208,7,0,0,0,0,40,243,209,7,0,0,0,0,48,243,210,7,0,0,0,0,56,243,211,7,0,0,0,0,57,243,212,7,0,0,0,0,80,243,213,7,0,0,0,0,88,243,214,7,0,0,0,0,104,243,215,7,0,0,0,0,112,243,216,7,0,0,0,0,120,243,217,7,0,0,0,0,121,243,218,7,0,0,0,0,122,243,219,7,0,0,0,0,123,243,0,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,171,0,0,0,0,0,16,0,172,0,0,0,0,0,24,0,173,0,0,0,0,0,32,0,174,0,0,0,0,0,40,0,175,0,0,0,0,0,48,0,176,0,0,0,0,0,56,0,177,0,0,0,0,0,57,0,178,0,0,0,0,0,60,0,179,0,0,0,0,0,64,0,180,0,0,0,0,0,80,0,181,0,0,0,0,0,88,0,182,0,0,0,0,0,96,0,183,0,0,0,0,0,104,0,184,0,0,0,0,0,112,0,185,0,0,0,0,0,120,0,186,0,0,0,0,0,121,0,187,0,0,0,0,0,124,0,188,0,0,0,0,0,128,0,189,0,0,0,0,0,144,0,190,0,0,0,0,0,152,0,191,0,0,0,0,0,160,0,192,0,0,0,0,0,168,0,193,0,0,0,0,0,176,0,194,0,0,0,0,0,184,0,195,0,0,0,0,0,185,0,196,0,0,0,0,0,208,0,197,0,0,0,0,0,232,0,198,0,0,0,0,0,240,0,199,0,0,0,0,0,248,0,200,0,0,0,0,0,249,0,201,0,0,0,0,0,250,0,202,0,0,0,0,0,251,0,203,0,0,0,0,0,0,1,204,0,0,0,0,0,8,1,205,0,0,0,0,0,16,1,206,0,0,0,0,0,24,1,207,0,0,0,0,0,32,1,208,0,0,0,0,0,40,1,209,0,0,0,0,0,48,1,210,0,0,0,0,0,56,1,211,0,0,0,0,0,57,1,212,0,0,0,0,0,58,1,213,0,0,0,0,0,59,1,214,0,0,0,0,0,60,1,215,0,0,0,0,0,64,1,216,0,0,0,0,0,72,1,217,0,0,0,0,0,80,1,218,0,0,0,0,0,88,1,219,0,0,0,0,0,96,1,220,0,0,0,0,0,104,1,221,0,0,0,0,0,112,1,222,0,0,0,0,0,120,1,223,0,0,0,0,0,121,1,224,0,0,0,0,0,122,1,225,0,0,0,0,0,123,1,226,0,0,0,0,0,128,1,227,0,0,0,0,0,136,1,228,0,0,0,0,0,144,1,229,0,0,0,0,0,152,1,230,0,0,0,0,0,160,1,231,0,0,0,0,0,168,1,232,0,0,0,0,0,176,1,233,0,0,0,0,0,184,1,234,0,0,0,0,0,185,1,235,0,0,0,0,0,186,1,236,0,0,0,0,0,187,1,237,0,0,0,0,0,192,1,238,0,0,0,0,0,200,1,239,0,0,0,0,0,208,1,240,0,0,0,0,0,216,1,241,0,0,0,0,0,224,1,242,0,0,0,0,0,232,1,243,0,0,0,0,0,240,1,244,0,0,0,0,0,248,1,245,0,0,0,0,0,249,1,246,0,0,0,0,0,250,1,247,0,0,0,0,0,251,1,248,0,0,0,0,0,0,2,249,0,0,0,0,0,16,2,250,0,0,0,0,0,24,2,251,0,0,0,0,0,32,2,252,0,0,0,0,0,40,2,253,0,0,0,0,0,48,2,254,0,0,0,0,0,56,2,255,0,0,0,0,0,57,2,0,1,0,0,0,0,60,2,1,1,0,0,0,0,64,2,2,1,0,0,0,0,80,2,3,1,0,0,0,0,88,2,4,1,0,0,0,0,96,2,5,1,0,0,0,0,104,2,6,1,0,0,0,0,112,2,7,1,0,0,0,0,120,2,8,1,0,0,0,0,121,2,9,1,0,0,0,0,124,2,10,1,0,0,0,0,128,2,11,1,0,0,0,0,144,2,12,1,0,0,0,0,152,2,13,1,0,0,0,0,160,2,14,1,0,0,0,0,168,2,15,1,0,0,0,0,176,2,16,1,0,0,0,0,184,2,17,1,0,0,0,0,185,2,18,1,0,0,0,0,208,2,19,1,0,0,0,0,232,2,20,1,0,0,0,0,240,2,21,1,0,0,0,0,248,2,22,1,0,0,0,0,249,2,23,1,0,0,0,0,250,2,24,1,0,0,0,0,251,2,25,1,0,0,0,0,0,4,26,1,0,0,0,0,16,4,27,1,0,0,0,0,24,4,28,1,0,0,0,0,32,4,29,1,0,0,0,0,40,4,30,1,0,0,0,0,48,4,31,1,0,0,0,0,56,4,32,1,0,0,0,0,57,4,33,1,0,0,0,0,64,4,34,1,0,0,0,0,80,4,35,1,0,0,0,0,88,4,36,1,0,0,0,0,96,4,37,1,0,0,0,0,104,4,38,1,0,0,0,0,112,4,39,1,0,0,0,0,120,4,40,1,0,0,0,0,121,4,41,1,0,0,0,0,128,4,42,1,0,0,0,0,144,4,43,1,0,0,0,0,152,4,44,1,0,0,0,0,160,4,45,1,0,0,0,0,168,4,46,1,0,0,0,0,176,4,47,1,0,0,0,0,184,4,48,1,0,0,0,0,185,4,49,1,0,0,0,0,208,4,50,1,0,0,0,0,232,4,51,1,0,0,0,0,240,4,52,1,0,0,0,0,248,4,53,1,0,0,0,0,249,4,54,1,0,0,0,0,250,4,55,1,0,0,0,0,251,4,56,1,0,0,0,0,0,6,57,1,0,0,0,0,16,6,58,1,0,0,0,0,24,6,59,1,0,0,0,0,32,6,60,1,0,0,0,0,40,6,61,1,0,0,0,0,48,6,62,1,0,0,0,0,56,6,63,1,0,0,0,0,57,6,64,1,0,0,0,0,64,6,65,1,0,0,0,0,80,6,66,1,0,0,0,0,88,6,67,1,0,0,0,0,96,6,68,1,0,0,0,0,104,6,69,1,0,0,0,0,112,6,70,1,0,0,0,0,120,6,71,1,0,0,0,0,121,6,72,1,0,0,0,0,128,6,73,1,0,0,0,0,144,6,74,1,0,0,0,0,152,6,75,1,0,0,0,0,160,6,76,1,0,0,0,0,168,6,77,1,0,0,0,0,176,6,78,1,0,0,0,0,184,6,79,1,0,0,0,0,185,6,80,1,0,0,0,0,192,6,81,1,0,0,0,0,200,6,82,1,0,0,0,0,208,6,83,1,0,0,0,0,232,6,84,1,0,0,0,0,240,6,85,1,0,0,0,0,248,6,86,1,0,0,0,0,249,6,87,1,0,0,0,0,250,6,88,1,0,0,0,0,251,6,89,1,0,0,0,0,0,8,90,1,0,0,0,0,16,8,91,1,0,0,0,0,24,8,92,1,0,0,0,0,32,8,93,1,0,0,0,0,40,8,94,1,0,0,0,0,48,8,95,1,0,0,0,0,56,8,96,1,0,0,0,0,57,8,97,1,0,0,0,0,58,8,98,1,0,0,0,0,59,8,99,1,0,0,0,0,60,8,100,1,0,0,0,0,64,8,101,1,0,0,0,0,80,8,102,1,0,0,0,0,88,8,103,1,0,0,0,0,96,8,104,1,0,0,0,0,104,8,105,1,0,0,0,0,112,8,106,1,0,0,0,0,120,8,107,1,0,0,0,0,121,8,108,1,0,0,0,0,122,8,109,1,0,0,0,0,123,8,110,1,0,0,0,0,128,8,111,1,0,0,0,0,144,8,112,1,0,0,0,0,152,8,113,1,0,0,0,0,160,8,114,1,0,0,0,0,168,8,115,1,0,0,0,0,176,8,116,1,0,0,0,0,184,8,117,1,0,0,0,0,185,8,118,1,0,0,0,0,186,8,119,1,0,0,0,0,187,8,120,1,0,0,0,0,192,8,121,1,0,0,0,0,208,8,122,1,0,0,0,0,216,8,123,1,0,0,0,0,224,8,124,1,0,0,0,0,232,8,125,1,0,0,0,0,240,8,126,1,0,0,0,0,248,8,127,1,0,0,0,0,249,8,128,1,0,0,0,0,250,8,129,1,0,0,0,0,251,8,130,1,0,0,0,0,0,10,131,1,0,0,0,0,16,10,132,1,0,0,0,0,24,10,133,1,0,0,0,0,32,10,134,1,0,0,0,0,40,10,135,1,0,0,0,0,48,10,136,1,0,0,0,0,56,10,137,1,0,0,0,0,57,10,138,1,0,0,0,0,60,10,139,1,0,0,0,0,64,10,140,1,0,0,0,0,80,10,141,1,0,0,0,0,88,10,142,1,0,0,0,0,96,10,143,1,0,0,0,0,104,10,144,1,0,0,0,0,112,10,145,1,0,0,0,0,120,10,146,1,0,0,0,0,121,10,147,1,0,0,0,0,124,10,148,1,0,0,0,0,128,10,149,1,0,0,0,0,144,10,150,1,0,0,0,0,152,10,151,1,0,0,0,0,160,10,152,1,0,0,0,0,168,10,153,1,0,0,0,0,176,10,154,1,0,0,0,0,184,10,155,1,0,0,0,0,185,10,156,1,0,0,0,0,208,10,157,1,0,0,0,0,216,10,158,1,0,0,0,0,224,10,159,1,0,0,0,0,232,10,160,1,0,0,0,0,240,10,161,1,0,0,0,0,248,10,162,1,0,0,0,0,249,10,163,1,0,0,0,0,0,12,164,1,0,0,0,0,16,12,165,1,0,0,0,0,24,12,166,1,0,0,0,0,32,12,167,1,0,0,0,0,40,12,168,1,0,0,0,0,48,12,169,1,0,0,0,0,56,12,170,1,0,0,0,0,57,12,171,1,0,0,0,0,58,12,172,1,0,0,0,0,59,12,173,1,0,0,0,0,64,12,174,1,0,0,0,0,80,12,175,1,0,0,0,0,88,12,176,1,0,0,0,0,96,12,177,1,0,0,0,0,104,12,178,1,0,0,0,0,112,12,179,1,0,0,0,0,120,12,180,1,0,0,0,0,121,12,181,1,0,0,0,0,122,12,182,1,0,0,0,0,123,12,183,1,0,0,0,0,128,12,184,1,0,0,0,0,144,12,185,1,0,0,0,0,152,12,186,1,0,0,0,0,160,12,187,1,0,0,0,0,168,12,188,1,0,0,0,0,176,12,189,1,0,0,0,0,184,12,190,1,0,0,0,0,185,12,191,1,0,0,0,0,186,12,192,1,0,0,0,0,187,12,193,1,0,0,0,0,208,12,194,1,0,0,0,0,216,12,195,1,0,0,0,0,224,12,196,1,0,0,0,0,232,12,197,1,0,0,0,0,240,12,198,1,0,0,0,0,248,12,199,1,0,0,0,0,249,12,200,1,0,0,0,0,252,12,201,1,0,0,0,0,16,14,202,1,0,0,0,0,24,14,203,1,0,0,0,0,32,14,204,1,0,0,0,0,40,14,205,1,0,0,0,0,48,14,206,1,0,0,0,0,56,14,207,1,0,0,0,0,57,14,208,1,0,0,0,0,80,14,209,1,0,0,0,0,88,14,210,1,0,0,0,0,96,14,211,1,0,0,0,0,104,14,212,1,0,0,0,0,112,14,213,1,0,0,0,0,120,14,214,1,0,0,0,0,121,14,215,1,0,0,0,0,144,14,216,1,0,0,0,0,152,14,217,1,0,0,0,0,160,14,218,1,0,0,0,0,168,14,219,1,0,0,0,0,176,14,220,1,0,0,0,0,184,14,221,1,0,0,0,0,185,14,222,1,0,0,0,0,208,14,223,1,0,0,0,0,216,14,224,1,0,0,0,0,224,14,225,1,0,0,0,0,232,14,226,1,0,0,0,0,240,14,227,1,0,0,0,0,248,14,228,1,0,0,0,0,249,14,229,1,0,0,0,0,252,14,230,1,0,0,0,0,0,16,231,1,0,0,0,0,16,16,232,1,0,0,0,0,24,16,233,1,0,0,0,0,32,16,234,1,0,0,0,0,40,16,235,1,0,0,0,0,48,16,236,1,0,0,0,0,56,16,237,1,0,0,0,0,57,16,238,1,0,0,0,0,58,16,239,1,0,0,0,0,59,16,240,1,0,0,0,0,60,16,241,1,0,0,0,0,128,16,242,1,0,0,0,0,144,16,243,1,0,0,0,0,152,16,244,1,0,0,0,0,160,16,245,1,0,0,0,0,168,16,246,1,0,0,0,0,176,16,247,1,0,0,0,0,184,16,248,1,0,0,0,0,185,16,249,1,0,0,0,0,186,16,250,1,0,0,0,0,187,16,251,1,0,0,0,0,188,16,252,1,0,0,0,0,192,16,253,1,0,0,0,0,208,16,254,1,0,0,0,0,216,16,255,1,0,0,0,0,224,16,0,2,0,0,0,0,232,16,1,2,0,0,0,0,240,16,2,2,0,0,0,0,248,16,3,2,0,0,0,0,249,16,4,2,0,0,0,0,250,16,5,2,0,0,0,0,251,16,6,2,0,0,0,0,252,16,7,2,0,0,0,0,0,17,8,2,0,0,0,0,16,17,9,2,0,0,0,0,24,17,10,2,0,0,0,0,32,17,11,2,0,0,0,0,40,17,12,2,0,0,0,0,48,17,13,2,0,0,0,0,56,17,14,2,0,0,0,0,57,17,15,2,0,0,0,0,58,17,16,2,0,0,0,0,59,17,17,2,0,0,0,0,60,17,18,2,0,0,0,0,64,17,19,2,0,0,0,0,80,17,20,2,0,0,0,0,88,17,21,2,0,0,0,0,96,17,22,2,0,0,0,0,104,17,23,2,0,0,0,0,112,17,24,2,0,0,0,0,120,17,25,2,0,0,0,0,121,17,26,2,0,0,0,0,122,17,27,2,0,0,0,0,123,17,28,2,0,0,0,0,124,17,29,2,0,0,0,0,128,17,30,2,0,0,0,0,144,17,31,2,0,0,0,0,152,17,32,2,0,0,0,0,160,17,33,2,0,0,0,0,168,17,34,2,0,0,0,0,176,17,35,2,0,0,0,0,184,17,36,2,0,0,0,0,185,17,37,2,0,0,0,0,186,17,38,2,0,0,0,0,187,17,39,2,0,0,0,0,188,17,40,2,0,0,0,0,192,17,41,2,0,0,0,0,208,17,42,2,0,0,0,0,216,17,43,2,0,0,0,0,224,17,44,2,0,0,0,0,232,17,45,2,0,0,0,0,240,17,46,2,0,0,0,0,248,17,47,2,0,0,0,0,249,17,48,2,0,0,0,0,250,17,49,2,0,0,0,0,251,17,50,2,0,0,0,0,252,17,51,2,0,0,0,0,192,19,52,2,0,0,0,0,208,19,53,2,0,0,0,0,216,19,54,2,0,0,0,0,224,19,55,2,0,0,0,0,232,19,56,2,0,0,0,0,240,19,57,2,0,0,0,0,248,19,58,2,0,0,0,0,249,19,59,2,0,0,0,0,250,19,60,2,0,0,0,0,251,19,61,2,0,0,0,0,252,19,62,2,0,0,0,0,0,32,63,2,0,0,0,0,8,32,64,2,0,0,0,0,16,32,65,2,0,0,0,0,24,32,66,2,0,0,0,0,32,32,67,2,0,0,0,0,40,32,68,2,0,0,0,0,48,32,69,2,0,0,0,0,56,32,70,2,0,0,0,0,57,32,71,2,0,0,0,0,58,32,72,2,0,0,0,0,59,32,73,2,0,0,0,0,60,32,74,2,0,0,0,0,64,32,75,2,0,0,0,0,72,32,76,2,0,0,0,0,80,32,77,2,0,0,0,0,88,32,78,2,0,0,0,0,96,32,79,2,0,0,0,0,104,32,80,2,0,0,0,0,112,32,81,2,0,0,0,0,120,32,82,2,0,0,0,0,121,32,83,2,0,0,0,0,122,32,84,2,0,0,0,0,123,32,85,2,0,0,0,0,124,32,86,2,0,0,0,0,128,32,87,2,0,0,0,0,136,32,88,2,0,0,0,0,144,32,89,2,0,0,0,0,152,32,90,2,0,0,0,0,160,32,91,2,0,0,0,0,168,32,92,2,0,0,0,0,176,32,93,2,0,0,0,0,184,32,94,2,0,0,0,0,185,32,95,2,0,0,0,0,186,32,96,2,0,0,0,0,187,32,97,2,0,0,0,0,188,32,98,2,0,0,0,0,192,32,99,2,0,0,0,0,200,32,100,2,0,0,0,0,208,32,101,2,0,0,0,0,216,32,102,2,0,0,0,0,224,32,103,2,0,0,0,0,232,32,104,2,0,0,0,0,240,32,105,2,0,0,0,0,248,32,106,2,0,0,0,0,249,32,107,2,0,0,0,0,250,32,108,2,0,0,0,0,251,32,109,2,0,0,0,0,252,32,110,2,0,0,0,0,0,33,111,2,0,0,0,0,8,33,112,2,0,0,0,0,16,33,113,2,0,0,0,0,24,33,114,2,0,0,0,0,32,33,115,2,0,0,0,0,40,33,116,2,0,0,0,0,48,33,117,2,0,0,0,0,56,33,118,2,0,0,0,0,57,33,119,2,0,0,0,0,58,33,120,2,0,0,0,0,59,33,121,2,0,0,0,0,60,33,122,2,0,0,0,0,64,33,123,2,0,0,0,0,72,33,124,2,0,0,0,0,80,33,125,2,0,0,0,0,88,33,126,2,0,0,0,0,96,33,127,2,0,0,0,0,104,33,128,2,0,0,0,0,112,33,129,2,0,0,0,0,120,33,130,2,0,0,0,0,121,33,131,2,0,0,0,0,122,33,132,2,0,0,0,0,123,33,133,2,0,0,0,0,124,33,134,2,0,0,0,0,128,33,135,2,0,0,0,0,136,33,136,2,0,0,0,0,144,33,137,2,0,0,0,0,152,33,138,2,0,0,0,0,160,33,139,2,0,0,0,0,168,33,140,2,0,0,0,0,176,33,141,2,0,0,0,0,184,33,142,2,0,0,0,0,185,33,143,2,0,0,0,0,186,33,144,2,0,0,0,0,187,33,145,2,0,0,0,0,188,33,146,2,0,0,0,0,192,33,147,2,0,0,0,0,200,33,148,2,0,0,0,0,208,33,149,2,0,0,0,0,216,33,150,2,0,0,0,0,224,33,151,2,0,0,0,0,232,33,152,2,0,0,0,0,240,33,153,2,0,0,0,0,248,33,154,2,0,0,0,0,249,33,155,2,0,0,0,0,250,33,156,2,0,0,0,0,251,33,157,2,0,0,0,0,252,33,158,2,0,0,0,0,192,35,159,2,0,0,0,0,200,35,160,2,0,0,0,0,208,35,161,2,0,0,0,0,216,35,162,2,0,0,0,0,224,35,163,2,0,0,0,0,232,35,164,2,0,0,0,0,240,35,165,2,0,0,0,0,248,35,166,2,0,0,0,0,249,35,167,2,0,0,0,0,250,35,168,2,0,0,0,0,251,35,169,2,0,0,0,0,252,35,170,2,0,0,0,0,0,48,171,2,0,0,0,0,8,48,172,2,0,0,0,0,16,48,173,2,0,0,0,0,24,48,174,2,0,0,0,0,32,48,175,2,0,0,0,0,40,48,176,2,0,0,0,0,48,48,177,2,0,0,0,0,56,48,178,2,0,0,0,0,57,48,179,2,0,0,0,0,58,48,180,2,0,0,0,0,59,48,181,2,0,0,0,0,60,48,182,2,0,0,0,0,64,48,183,2,0,0,0,0,72,48,184,2,0,0,0,0,80,48,185,2,0,0,0,0,88,48,186,2,0,0,0,0,96,48,187,2,0,0,0,0,104,48,188,2,0,0,0,0,112,48,189,2,0,0,0,0,120,48,190,2,0,0,0,0,121,48,191,2,0,0,0,0,122,48,192,2,0,0,0,0,123,48,193,2,0,0,0,0,124,48,194,2,0,0,0,0,128,48,195,2,0,0,0,0,136,48,196,2,0,0,0,0,144,48,197,2,0,0,0,0,152,48,198,2,0,0,0,0,160,48,199,2,0,0,0,0,168,48,200,2,0,0,0,0,176,48,201,2,0,0,0,0,184,48,202,2,0,0,0,0,185,48,203,2,0,0,0,0,186,48,204,2,0,0,0,0,187,48,205,2,0,0,0,0,188,48,206,2,0,0,0,0,192,48,207,2,0,0,0,0,200,48,208,2,0,0,0,0,208,48,209,2,0,0,0,0,216,48,210,2,0,0,0,0,224,48,211,2,0,0,0,0,232,48,212,2,0,0,0,0,240,48,213,2,0,0,0,0,248,48,214,2,0,0,0,0,249,48,215,2,0,0,0,0,250,48,216,2,0,0,0,0,251,48,217,2,0,0,0,0,252,48,218,2,0,0,0,0,0,49,219,2,0,0,0,0,8,49,220,2,0,0,0,0,16,49,221,2,0,0,0,0,24,49,222,2,0,0,0,0,32,49,223,2,0,0,0,0,40,49,224,2,0,0,0,0,48,49,225,2,0,0,0,0,56,49,226,2,0,0,0,0,57,49,227,2,0,0,0,0,58,49,228,2,0,0,0,0,59,49,229,2,0,0,0,0,60,49,230,2,0,0,0,0,64,49,231,2,0,0,0,0,72,49,232,2,0,0,0,0,80,49,233,2,0,0,0,0,88,49,234,2,0,0,0,0,96,49,235,2,0,0,0,0,104,49,236,2,0,0,0,0,112,49,237,2,0,0,0,0,120,49,238,2,0,0,0,0,121,49,239,2,0,0,0,0,122,49,240,2,0,0,0,0,123,49,241,2,0,0,0,0,124,49,242,2,0,0,0,0,128,49,243,2,0,0,0,0,136,49,244,2,0,0,0,0,144,49,245,2,0,0,0,0,152,49,246,2,0,0,0,0,160,49,247,2,0,0,0,0,168,49,248,2,0,0,0,0,176,49,249,2,0,0,0,0,184,49,250,2,0,0,0,0,185,49,251,2,0,0,0,0,186,49,252,2,0,0,0,0,187,49,253,2,0,0,0,0,188,49,254,2,0,0,0,0,192,49,255,2,0,0,0,0,200,49,0,3,0,0,0,0,208,49,1,3,0,0,0,0,216,49,2,3,0,0,0,0,224,49,3,3,0,0,0,0,232,49,4,3,0,0,0,0,240,49,5,3,0,0,0,0,248,49,6,3,0,0,0,0,249,49,7,3,0,0,0,0,250,49,8,3,0,0,0,0,251,49,9,3,0,0,0,0,252,49,10,3,0,0,0,0,192,51,11,3,0,0,0,0,200,51,12,3,0,0,0,0,208,51,13,3,0,0,0,0,216,51,14,3,0,0,0,0,224,51,15,3,0,0,0,0,232,51,16,3,0,0,0,0,240,51,17,3,0,0,0,0,248,51,18,3,0,0,0,0,249,51,19,3,0,0,0,0,250,51,20,3,0,0,0,0,251,51,21,3,0,0,0,0,252,51,22,3,0,0,0,0,0,64,23,3,0,0,0,0,16,64,24,3,0,0,0,0,24,64,25,3,0,0,0,0,32,64,26,3,0,0,0,0,40,64,27,3,0,0,0,0,48,64,28,3,0,0,0,0,56,64,29,3,0,0,0,0,57,64,30,3,0,0,0,0,64,64,31,3,0,0,0,0,80,64,32,3,0,0,0,0,88,64,33,3,0,0,0,0,96,64,34,3,0,0,0,0,104,64,35,3,0,0,0,0,112,64,36,3,0,0,0,0,120,64,37,3,0,0,0,0,121,64,38,3,0,0,0,0,128,64,39,3,0,0,0,0,144,64,40,3,0,0,0,0,152,64,41,3,0,0,0,0,160,64,42,3,0,0,0,0,168,64,43,3,0,0,0,0,176,64,44,3,0,0,0,0,184,64,45,3,0,0,0,0,185,64,46,3,0,0,0,0,192,64,47,3,0,0,0,0,208,64,48,3,0,0,0,0,216,64,49,3,0,0,0,0,224,64,50,3,0,0,0,0,232,64,51,3,0,0,0,0,240,64,52,3,0,0,0,0,248,64,53,3,0,0,0,0,249,64,54,3,0,0,0,0,0,65,55,3,0,0,0,0,16,65,56,3,0,0,0,0,24,65,57,3,0,0,0,0,32,65,58,3,0,0,0,0,40,65,59,3,0,0,0,0,48,65,60,3,0,0,0,0,56,65,61,3,0,0,0,0,57,65,62,3,0,0,0,0,58,65,63,3,0,0,0,0,59,65,64,3,0,0,0,0,60,65,65,3,0,0,0,0,128,65,66,3,0,0,0,0,144,65,67,3,0,0,0,0,152,65,68,3,0,0,0,0,160,65,69,3,0,0,0,0,168,65,70,3,0,0,0,0,176,65,71,3,0,0,0,0,184,65,72,3,0,0,0,0,185,65,73,3,0,0,0,0,186,65,74,3,0,0,0,0,187,65,75,3,0,0,0,0,188,65,76,3,0,0,0,0,208,65,77,3,0,0,0,0,232,65,78,3,0,0,0,0,240,65,79,3,0,0,0,0,248,65,80,3,0,0,0,0,249,65,81,3,0,0,0,0,250,65,82,3,0,0,0,0,251,65,83,3,0,0,0,0,0,66,84,3,0,0,0,0,16,66,85,3,0,0,0,0,24,66,86,3,0,0,0,0,32,66,87,3,0,0,0,0,40,66,88,3,0,0,0,0,48,66,89,3,0,0,0,0,56,66,90,3,0,0,0,0,57,66,91,3,0,0,0,0,64,66,92,3,0,0,0,0,80,66,93,3,0,0,0,0,88,66,94,3,0,0,0,0,96,66,95,3,0,0,0,0,104,66,96,3,0,0,0,0,112,66,97,3,0,0,0,0,120,66,98,3,0,0,0,0,121,66,99,3,0,0,0,0,128,66,100,3,0,0,0,0,144,66,101,3,0,0,0,0,152,66,102,3,0,0,0,0,160,66,103,3,0,0,0,0,168,66,104,3,0,0,0,0,176,66,105,3,0,0,0,0,184,66,106,3,0,0,0,0,185,66,107,3,0,0,0,0,192,66,108,3,0,0,0,0,208,66,109,3,0,0,0,0,216,66,110,3,0,0,0,0,224,66,111,3,0,0,0,0,232,66,112,3,0,0,0,0,240,66,113,3,0,0,0,0,248,66,114,3,0,0,0,0,249,66,115,3,0,0,0,0,0,68,116,3,0,0,0,0,16,68,117,3,0,0,0,0,24,68,118,3,0,0,0,0,32,68,119,3,0,0,0,0,40,68,120,3,0,0,0,0,48,68,121,3,0,0,0,0,56,68,122,3,0,0,0,0,57,68,123,3,0,0,0,0,64,68,124,3,0,0,0,0,80,68,125,3,0,0,0,0,88,68,126,3,0,0,0,0,96,68,127,3,0,0,0,0,104,68,128,3,0,0,0,0,112,68,129,3,0,0,0,0,120,68,130,3,0,0,0,0,121,68,131,3,0,0,0,0,128,68,132,3,0,0,0,0,144,68,133,3,0,0,0,0,152,68,134,3,0,0,0,0,160,68,135,3,0,0,0,0,168,68,136,3,0,0,0,0,176,68,137,3,0,0,0,0,184,68,138,3,0,0,0,0,185,68,139,3,0,0,0,0,192,68,140,3,0,0,0,0,208,68,141,3,0,0,0,0,216,68,142,3,0,0,0,0,224,68,143,3,0,0,0,0,232,68,144,3,0,0,0,0,240,68,145,3,0,0,0,0,248,68,146,3,0,0,0,0,249,68,147,3,0,0,0,0,250,68,148,3,0,0,0,0,251,68,149,3,0,0,0,0,252,68,150,3,0,0,0,0,0,70,151,3,0,0,0,0,16,70,152,3,0,0,0,0,24,70,153,3,0,0,0,0,32,70,154,3,0,0,0,0,40,70,155,3,0,0,0,0,48,70,156,3,0,0,0,0,56,70,157,3,0,0,0,0,57,70,158,3,0,0,0,0,64,70,159,3,0,0,0,0,80,70,160,3,0,0,0,0,88,70,161,3,0,0,0,0,96,70,162,3,0,0,0,0,104,70,163,3,0,0,0,0,112,70,164,3,0,0,0,0,120,70,165,3,0,0,0,0,121,70,166,3,0,0,0,0,128,70,167,3,0,0,0,0,144,70,168,3,0,0,0,0,152,70,169,3,0,0,0,0,160,70,170,3,0,0,0,0,168,70,171,3,0,0,0,0,176,70,172,3,0,0,0,0,184,70,173,3,0,0,0,0,185,70,174,3,0,0,0,0,192,70,175,3,0,0,0,0,208,70,176,3,0,0,0,0,216,70,177,3,0,0,0,0,224,70,178,3,0,0,0,0,232,70,179,3,0,0,0,0,240,70,180,3,0,0,0,0,248,70,181,3,0,0,0,0,249,70,182,3,0,0,0,0,250,70,183,3,0,0,0,0,251,70,184,3,0,0,0,0,252,70,246,7,0,0,0,0,0,72,186,3,0,0,0,0,8,72,247,7,0,0,0,0,16,72,248,7,0,0,0,0,24,72,249,7,0,0,0,0,32,72,250,7,0,0,0,0,40,72,251,7,0,0,0,0,48,72,252,7,0,0,0,0,56,72,253,7,0,0,0,0,57,72,194,3,0,0,0,0,64,72,195,3,0,0,0,0,72,72,196,3,0,0,0,0,80,72,197,3,0,0,0,0,104,72,198,3,0,0,0,0,112,72,199,3,0,0,0,0,120,72,200,3,0,0,0,0,121,72,201,3,0,0,0,0,122,72,202,3,0,0,0,0,123,72,203,3,0,0,0,0,128,72,204,3,0,0,0,0,144,72,205,3,0,0,0,0,160,72,206,3,0,0,0,0,168,72,207,3,0,0,0,0,176,72,208,3,0,0,0,0,184,72,209,3,0,0,0,0,185,72,210,3,0,0,0,0,192,72,211,3,0,0,0,0,208,72,212,3,0,0,0,0,224,72,213,3,0,0,0,0,232,72,214,3,0,0,0,0,240,72,215,3,0,0,0,0,248,72,216,3,0,0,0,0,249,72,217,3,0,0,0,0,192,73,218,3,0,0,0,0,0,74,219,3,0,0,0,0,16,74,220,3,0,0,0,0,24,74,221,3,0,0,0,0,32,74,222,3,0,0,0,0,40,74,223,3,0,0,0,0,48,74,224,3,0,0,0,0,56,74,225,3,0,0,0,0,57,74,226,3,0,0,0,0,58,74,227,3,0,0,0,0,59,74,228,3,0,0,0,0,60,74,229,3,0,0,0,0,64,74,230,3,0,0,0,0,72,74,231,3,0,0,0,0,80,74,232,3,0,0,0,0,88,74,233,3,0,0,0,0,96,74,234,3,0,0,0,0,104,74,235,3,0,0,0,0,112,74,236,3,0,0,0,0,120,74,237,3,0,0,0,0,121,74,238,3,0,0,0,0,122,74,239,3,0,0,0,0,123,74,240,3,0,0,0,0,124,74,241,3,0,0,0,0,128,74,242,3,0,0,0,0,136,74,243,3,0,0,0,0,144,74,244,3,0,0,0,0,152,74,245,3,0,0,0,0,160,74,246,3,0,0,0,0,168,74,247,3,0,0,0,0,176,74,248,3,0,0,0,0,184,74,249,3,0,0,0,0,185,74,250,3,0,0,0,0,186,74,251,3,0,0,0,0,187,74,252,3,0,0,0,0,188,74,253,3,0,0,0,0,192,74,254,3,0,0,0,0,208,74,255,3,0,0,0,0,216,74,0,4,0,0,0,0,224,74,1,4,0,0,0,0,232,74,2,4,0,0,0,0,240,74,3,4,0,0,0,0,248,74,4,4,0,0,0,0,249,74,5,4,0,0,0,0,0,76,6,4,0,0,0,0,16,76,7,4,0,0,0,0,24,76,8,4,0,0,0,0,32,76,9,4,0,0,0,0,40,76,10,4,0,0,0,0,48,76,11,4,0,0,0,0,56,76,12,4,0,0,0,0,57,76,13,4,0,0,0,0,58,76,14,4,0,0,0,0,59,76,15,4,0,0,0,0,60,76,16,4,0,0,0,0,64,76,17,4,0,0,0,0,80,76,18,4,0,0,0,0,88,76,19,4,0,0,0,0,96,76,20,4,0,0,0,0,104,76,21,4,0,0,0,0,112,76,22,4,0,0,0,0,120,76,23,4,0,0,0,0,121,76,24,4,0,0,0,0,122,76,25,4,0,0,0,0,123,76,26,4,0,0,0,0,124,76,27,4,0,0,0,0,144,76,28,4,0,0,0,0,152,76,29,4,0,0,0,0,168,76,30,4,0,0,0,0,176,76,31,4,0,0,0,0,184,76,32,4,0,0,0,0,185,76,33,4,0,0,0,0,186,76,34,4,0,0,0,0,187,76,35,4,0,0,0,0,208,76,36,4,0,0,0,0,216,76,37,4,0,0,0,0,232,76,38,4,0,0,0,0,240,76,39,4,0,0,0,0,248,76,40,4,0,0,0,0,249,76,41,4,0,0,0,0,250,76,42,4,0,0,0,0,251,76,43,4,0,0,0,0,64,78,44,4,0,0,0,0,80,78,45,4,0,0,0,0,88,78,46,4,0,0,0,0,96,78,47,4,0,0,0,0,104,78,48,4,0,0,0,0,112,78,49,4,0,0,0,0,113,78,50,4,0,0,0,0,114,78,51,4,0,0,0,0,115,78,52,4,0,0,0,0,116,78,53,4,0,0,0,0,117,78,54,4,0,0,0,0,118,78,55,4,0,0,0,0,119,78,56,4,0,0,0,0,122,78,57,4,0,0,0,0,123,78,58,4,0,0,0,0,144,78,59,4,0,0,0,0,168,78,60,4,0,0,0,0,176,78,61,4,0,0,0,0,184,78,62,4,0,0,0,0,185,78,63,4,0,0,0,0,186,78,64,4,0,0,0,0,187,78,65,4,0,0,0,0,208,78,66,4,0,0,0,0,232,78,67,4,0,0,0,0,240,78,68,4,0,0,0,0,248,78,69,4,0,0,0,0,249,78,70,4,0,0,0,0,250,78,71,4,0,0,0,0,251,78,72,4,0,0,0,0,0,80,73,4,0,0,0,0,16,80,74,4,0,0,0,0,24,80,75,4,0,0,0,0,32,80,76,4,0,0,0,0,40,80,77,4,0,0,0,0,48,80,78,4,0,0,0,0,56,80,79,4,0,0,0,0,57,80,80,4,0,0,0,0,64,80,81,4,0,0,0,0,72,80,82,4,0,0,0,0,80,80,83,4,0,0,0,0,88,80,84,4,0,0,0,0,96,80,85,4,0,0,0,0,104,80,86,4,0,0,0,0,112,80,87,4,0,0,0,0,120,80,88,4,0,0,0,0,121,80,89,4,0,0,0,0,128,80,90,4,0,0,0,0,136,80,91,4,0,0,0,0,144,80,92,4,0,0,0,0,152,80,93,4,0,0,0,0,160,80,94,4,0,0,0,0,168,80,95,4,0,0,0,0,176,80,96,4,0,0,0,0,184,80,97,4,0,0,0,0,185,80,98,4,0,0,0,0,192,80,99,4,0,0,0,0,200,80,100,4,0,0,0,0,208,80,101,4,0,0,0,0,216,80,102,4,0,0,0,0,224,80,103,4,0,0,0,0,232,80,104,4,0,0,0,0,240,80,105,4,0,0,0,0,248,80,106,4,0,0,0,0,249,80,107,4,0,0,0,0,250,80,108,4,0,0,0,0,251,80,109,4,0,0,0,0,252,80,110,4,0,0,0,0,0,81,111,4,0,0,0,0,16,81,112,4,0,0,0,0,24,81,113,4,0,0,0,0,32,81,114,4,0,0,0,0,40,81,115,4,0,0,0,0,48,81,116,4,0,0,0,0,56,81,117,4,0,0,0,0,57,81,118,4,0,0,0,0,64,81,119,4,0,0,0,0,72,81,120,4,0,0,0,0,80,81,121,4,0,0,0,0,88,81,122,4,0,0,0,0,96,81,123,4,0,0,0,0,104,81,124,4,0,0,0,0,112,81,125,4,0,0,0,0,120,81,126,4,0,0,0,0,121,81,127,4,0,0,0,0,128,81,128,4,0,0,0,0,136,81,129,4,0,0,0,0,144,81,130,4,0,0,0,0,152,81,131,4,0,0,0,0,160,81,132,4,0,0,0,0,168,81,133,4,0,0,0,0,176,81,134,4,0,0,0,0,184,81,135,4,0,0,0,0,185,81,136,4,0,0,0,0,192,81,137,4,0,0,0,0,200,81,138,4,0,0,0,0,208,81,139,4,0,0,0,0,216,81,140,4,0,0,0,0,224,81,141,4,0,0,0,0,232,81,142,4,0,0,0,0,240,81,143,4,0,0,0,0,248,81,144,4,0,0,0,0,249,81,145,4,0,0,0,0,250,81,146,4,0,0,0,0,251,81,147,4,0,0,0,0,252,81,148,4,0,0,0,0,192,82,149,4,0,0,0,0,200,82,150,4,0,0,0,0,208,82,151,4,0,0,0,0,216,82,152,4,0,0,0,0,224,82,153,4,0,0,0,0,232,82,154,4,0,0,0,0,240,82,155,4,0,0,0,0,248,82,156,4,0,0,0,0,249,82,157,4,0,0,0,0,250,82,158,4,0,0,0,0,251,82,159,4,0,0,0,0,252,82,160,4,0,0,0,0,192,83,161,4,0,0,0,0,200,83,162,4,0,0,0,0,208,83,163,4,0,0,0,0,216,83,164,4,0,0,0,0,224,83,165,4,0,0,0,0,232,83,166,4,0,0,0,0,240,83,167,4,0,0,0,0,248,83,168,4,0,0,0,0,249,83,169,4,0,0,0,0,250,83,170,4,0,0,0,0,251,83,171,4,0,0,0,0,252,83,172,4,0,0,0,0,192,84,173,4,0,0,0,0,200,84,174,4,0,0,0,0,208,84,175,4,0,0,0,0,216,84,176,4,0,0,0,0,224,84,177,4,0,0,0,0,232,84,178,4,0,0,0,0,240,84,179,4,0,0,0,0,248,84,180,4,0,0,0,0,249,84,181,4,0,0,0,0,250,84,182,4,0,0,0,0,251,84,183,4,0,0,0,0,252,84,184,4,0,0,0,0,192,85,185,4,0,0,0,0,200,85,186,4,0,0,0,0,208,85,187,4,0,0,0,0,216,85,188,4,0,0,0,0,224,85,189,4,0,0,0,0,232,85,190,4,0,0,0,0,240,85,191,4,0,0,0,0,248,85,192,4,0,0,0,0,249,85,193,4,0,0,0,0,250,85,194,4,0,0,0,0,251,85,195,4,0,0,0,0,252,85,196,4,0,0,0,0,192,86,197,4,0,0,0,0,200,86,198,4,0,0,0,0,208,86,199,4,0,0,0,0,216,86,200,4,0,0,0,0,224,86,201,4,0,0,0,0,232,86,202,4,0,0,0,0,240,86,203,4,0,0,0,0,248,86,204,4,0,0,0,0,249,86,205,4,0,0,0,0,250,86,206,4,0,0,0,0,251,86,207,4,0,0,0,0,252,86,208,4,0,0,0,0,192,87,209,4,0,0,0,0,200,87,210,4,0,0,0,0,208,87,211,4,0,0,0,0,216,87,212,4,0,0,0,0,224,87,213,4,0,0,0,0,232,87,214,4,0,0,0,0,240,87,215,4,0,0,0,0,248,87,216,4,0,0,0,0,249,87,217,4,0,0,0,0,250,87,218,4,0,0,0,0,251,87,219,4,0,0,0,0,252,87,220,4,0,0,0,0,192,88,221,4,0,0,0,0,200,88,222,4,0,0,0,0,208,88,223,4,0,0,0,0,216,88,224,4,0,0,0,0,224,88,225,4,0,0,0,0,232,88,226,4,0,0,0,0,240,88,227,4,0,0,0,0,248,88,228,4,0,0,0,0,249,88,229,4,0,0,0,0,250,88,230,4,0,0,0,0,251,88,231,4,0,0,0,0,252,88,232,4,0,0,0,0,192,89,233,4,0,0,0,0,200,89,234,4,0,0,0,0,208,89,235,4,0,0,0,0,216,89,236,4,0,0,0,0,224,89,237,4,0,0,0,0,232,89,238,4,0,0,0,0,240,89,239,4,0,0,0,0,248,89,240,4,0,0,0,0,249,89,241,4,0,0,0,0,250,89,242,4,0,0,0,0,251,89,243,4,0,0,0,0,252,89,244,4,0,0,0,0,192,90,245,4,0,0,0,0,200,90,246,4,0,0,0,0,208,90,247,4,0,0,0,0,216,90,248,4,0,0,0,0,224,90,249,4,0,0,0,0,232,90,250,4,0,0,0,0,240,90,251,4,0,0,0,0,248,90,252,4,0,0,0,0,249,90,253,4,0,0,0,0,250,90,254,4,0,0,0,0,251,90,255,4,0,0,0,0,252,90,0,5,0,0,0,0,192,91,1,5,0,0,0,0,200,91,2,5,0,0,0,0,208,91,3,5,0,0,0,0,216,91,4,5,0,0,0,0,224,91,5,5,0,0,0,0,232,91,6,5,0,0,0,0,240,91,7,5,0,0,0,0,248,91,8,5,0,0,0,0,249,91,9,5,0,0,0,0,250,91,10,5,0,0,0,0,251,91,11,5,0,0,0,0,252,91,12,5,0,0,0,0,192,92,13,5,0,0,0,0,200,92,14,5,0,0,0,0,208,92,15,5,0,0,0,0,216,92,16,5,0,0,0,0,224,92,17,5,0,0,0,0,232,92,18,5,0,0,0,0,240,92,19,5,0,0,0,0,248,92,20,5,0,0,0,0,249,92,21,5,0,0,0,0,250,92,22,5,0,0,0,0,251,92,23,5,0,0,0,0,252,92,24,5,0,0,0,0,192,93,25,5,0,0,0,0,200,93,26,5,0,0,0,0,208,93,27,5,0,0,0,0,216,93,28,5,0,0,0,0,224,93,29,5,0,0,0,0,232,93,30,5,0,0,0,0,240,93,31,5,0,0,0,0,248,93,32,5,0,0,0,0,249,93,33,5,0,0,0,0,250,93,34,5,0,0,0,0,251,93,35,5,0,0,0,0,252,93,36,5,0,0,0,0,192,94,37,5,0,0,0,0,200,94,38,5,0,0,0,0,208,94,39,5,0,0,0,0,216,94,40,5,0,0,0,0,224,94,41,5,0,0,0,0,232,94,42,5,0,0,0,0,240,94,43,5,0,0,0,0,248,94,44,5,0,0,0,0,249,94,45,5,0,0,0,0,250,94,46,5,0,0,0,0,251,94,47,5,0,0,0,0,252,94,48,5,0,0,0,0,192,95,49,5,0,0,0,0,200,95,50,5,0,0,0,0,208,95,51,5,0,0,0,0,216,95,52,5,0,0,0,0,224,95,53,5,0,0,0,0,232,95,54,5,0,0,0,0,240,95,55,5,0,0,0,0,248,95,56,5,0,0,0,0,249,95,57,5,0,0,0,0,250,95,58,5,0,0,0,0,251,95,59,5,0,0,0,0,252,95,60,5,0,0,0,0,0,96,61,5,0,0,0,0,1,96,62,5,0,0,0,0,255,96,63,5,0,0,0,0,0,97,64,5,0,0,0,0,1,97,65,5,0,0,0,0,255,97,66,5,0,0,0,0,0,98,67,5,0,0,0,0,1,98,68,5,0,0,0,0,255,98,69,5,0,0,0,0,0,99,70,5,0,0,0,0,1,99,71,5,0,0,0,0,255,99,72,5,0,0,0,0,0,100,73,5,0,0,0,0,1,100,74,5,0,0,0,0,255,100,75,5,0,0,0,0,0,101,76,5,0,0,0,0,1,101,77,5,0,0,0,0,255,101,78,5,0,0,0,0,0,102,79,5,0,0,0,0,1,102,80,5,0,0,0,0,255,102,81,5,0,0,0,0,0,103,82,5,0,0,0,0,1,103,83,5,0,0,0,0,255,103,84,5,0,0,0,0,0,104,85,5,0,0,0,0,1,104,86,5,0,0,0,0,255,104,87,5,0,0,0,0,0,105,88,5,0,0,0,0,1,105,89,5,0,0,0,0,255,105,90,5,0,0,0,0,0,106,91,5,0,0,0,0,1,106,92,5,0,0,0,0,255,106,93,5,0,0,0,0,0,107,94,5,0,0,0,0,1,107,95,5,0,0,0,0,255,107,96,5,0,0,0,0,0,108,97,5,0,0,0,0,1,108,98,5,0,0,0,0,255,108,99,5,0,0,0,0,0,109,100,5,0,0,0,0,1,109,101,5,0,0,0,0,255,109,102,5,0,0,0,0,0,110,103,5,0,0,0,0,1,110,104,5,0,0,0,0,255,110,105,5,0,0,0,0,0,111,106,5,0,0,0,0,1,111,107,5,0,0,0,0,255,111,108,5,0,0,0,0,0,112,109,5,0,0,0,0,0,113,110,5,0,0,0,0,1,113,111,5,0,0,0,0,0,128,112,5,0,0,0,0,16,128,113,5,0,0,0,0,24,128,114,5,0,0,0,0,32,128,115,5,0,0,0,0,40,128,116,5,0,0,0,0,48,128,117,5,0,0,0,0,56,128,118,5,0,0,0,0,57,128,119,5,0,0,0,0,58,128,120,5,0,0,0,0,59,128,121,5,0,0,0,0,60,128,122,5,0,0,0,0,64,128,123,5,0,0,0,0,80,128,124,5,0,0,0,0,88,128,125,5,0,0,0,0,96,128,126,5,0,0,0,0,104,128,127,5,0,0,0,0,112,128,128,5,0,0,0,0,120,128,129,5,0,0,0,0,121,128,130,5,0,0,0,0,122,128,131,5,0,0,0,0,123,128,132,5,0,0,0,0,124,128,133,5,0,0,0,0,128,128,134,5,0,0,0,0,144,128,135,5,0,0,0,0,152,128,136,5,0,0,0,0,160,128,137,5,0,0,0,0,168,128,138,5,0,0,0,0,176,128,139,5,0,0,0,0,184,128,140,5,0,0,0,0,185,128,141,5,0,0,0,0,186,128,142,5,0,0,0,0,187,128,143,5,0,0,0,0,188,128,144,5,0,0,0,0,192,128,145,5,0,0,0,0,208,128,146,5,0,0,0,0,216,128,147,5,0,0,0,0,224,128,148,5,0,0,0,0,232,128,149,5,0,0,0,0,240,128,150,5,0,0,0,0,248,128,151,5,0,0,0,0,249,128,152,5,0,0,0,0,250,128,153,5,0,0,0,0,251,128,154,5,0,0,0,0,252,128,254,7,0,0,0,0,0,129,255,7,0,0,0,0,8,129,157,5,0,0,0,0,16,129,158,5,0,0,0,0,24,129,159,5,0,0,0,0,32,129,160,5,0,0,0,0,40,129,161,5,0,0,0,0,48,129,162,5,0,0,0,0,56,129,163,5,0,0,0,0,57,129,164,5,0,0,0,0,64,129,165,5,0,0,0,0,72,129,166,5,0,0,0,0,80,129,167,5,0,0,0,0,88,129,168,5,0,0,0,0,96,129,169,5,0,0,0,0,104,129,170,5,0,0,0,0,112,129,171,5,0,0,0,0,120,129,172,5,0,0,0,0,121,129,173,5,0,0,0,0,128,129,174,5,0,0,0,0,136,129,175,5,0,0,0,0,144,129,176,5,0,0,0,0,152,129,177,5,0,0,0,0,160,129,178,5,0,0,0,0,168,129,179,5,0,0,0,0,176,129,180,5,0,0,0,0,184,129,181,5,0,0,0,0,185,129,182,5,0,0,0,0,192,129,183,5,0,0,0,0,208,129,184,5,0,0,0,0,216,129,185,5,0,0,0,0,224,129,186,5,0,0,0,0,232,129,187,5,0,0,0,0,240,129,188,5,0,0,0,0,248,129,189,5,0,0,0,0,249,129,190,5,0,0,0,0,250,129,191,5,0,0,0,0,251,129,192,5,0,0,0,0,252,129,193,5,0,0,0,0,0,144,194,5,0,0,0,0,16,144,195,5,0,0,0,0,24,144,196,5,0,0,0,0,32,144,197,5,0,0,0,0,40,144,198,5,0,0,0,0,48,144,199,5,0,0,0,0,56,144,200,5,0,0,0,0,57,144,201,5,0,0,0,0,58,144,202,5,0,0,0,0,59,144,203,5,0,0,0,0,60,144,204,5,0,0,0,0,64,144,205,5,0,0,0,0,72,144,206,5,0,0,0,0,80,144,207,5,0,0,0,0,88,144,208,5,0,0,0,0,96,144,209,5,0,0,0,0,104,144,210,5,0,0,0,0,112,144,211,5,0,0,0,0,120,144,212,5,0,0,0,0,121,144,213,5,0,0,0,0,122,144,214,5,0,0,0,0,123,144,215,5,0,0,0,0,124,144,216,5,0,0,0,0,128,144,217,5,0,0,0,0,136,144,218,5,0,0,0,0,144,144,219,5,0,0,0,0,152,144,220,5,0,0,0,0,160,144,221,5,0,0,0,0,168,144,222,5,0,0,0,0,176,144,223,5,0,0,0,0,184,144,224,5,0,0,0,0,185,144,225,5,0,0,0,0,186,144,226,5,0,0,0,0,187,144,227,5,0,0,0,0,188,144,228,5,0,0,0,0,192,144,229,5,0,0,0,0,200,144,230,5,0,0,0,0,208,144,231,5,0,0,0,0,216,144,232,5,0,0,0,0,224,144,233,5,0,0,0,0,232,144,234,5,0,0,0,0,240,144,235,5,0,0,0,0,248,144,236,5,0,0,0,0,249,144,237,5,0,0,0,0,250,144,238,5,0,0,0,0,251,144,239,5,0,0,0,0,252,144,240,5,0,0,0,0,0,145,241,5,0,0,0,0,8,145,242,5,0,0,0,0,16,145,243,5,0,0,0,0,24,145,244,5,0,0,0,0,32,145,245,5,0,0,0,0,40,145,246,5,0,0,0,0,48,145,247,5,0,0,0,0,56,145,248,5,0,0,0,0,57,145,249,5,0,0,0,0,64,145,250,5,0,0,0,0,72,145,251,5,0,0,0,0,80,145,252,5,0,0,0,0,88,145,253,5,0,0,0,0,96,145,254,5,0,0,0,0,104,145,255,5,0,0,0,0,112,145,0,6,0,0,0,0,120,145,1,6,0,0,0,0,121,145,2,6,0,0,0,0,128,145,3,6,0,0,0,0,136,145,4,6,0,0,0,0,144,145,5,6,0,0,0,0,152,145,6,6,0,0,0,0,160,145,7,6,0,0,0,0,168,145,8,6,0,0,0,0,176,145,9,6,0,0,0,0,184,145,10,6,0,0,0,0,185,145,11,6,0,0,0,0,192,145,12,6,0,0,0,0,200,145,13,6,0,0,0,0,208,145,14,6,0,0,0,0,216,145,15,6,0,0,0,0,224,145,16,6,0,0,0,0,232,145,17,6,0,0,0,0,240,145,18,6,0,0,0,0,248,145,19,6,0,0,0,0,249,145,20,6,0,0,0,0,250,145,21,6,0,0,0,0,251,145,22,6,0,0,0,0,252,145,23,6,0,0,0,0,0,176,24,6,0,0,0,0,16,176,25,6,0,0,0,0,24,176,26,6,0,0,0,0,32,176,27,6,0,0,0,0,40,176,28,6,0,0,0,0,48,176,29,6,0,0,0,0,56,176,30,6,0,0,0,0,57,176,31,6,0,0,0,0,58,176,32,6,0,0,0,0,59,176,33,6,0,0,0,0,60,176,34,6,0,0,0,0,64,176,35,6,0,0,0,0,72,176,36,6,0,0,0,0,80,176,37,6,0,0,0,0,88,176,38,6,0,0,0,0,96,176,39,6,0,0,0,0,104,176,40,6,0,0,0,0,112,176,41,6,0,0,0,0,120,176,42,6,0,0,0,0,121,176,43,6,0,0,0,0,122,176,44,6,0,0,0,0,123,176,45,6,0,0,0,0,124,176,46,6,0,0,0,0,128,176,47,6,0,0,0,0,136,176,48,6,0,0,0,0,144,176,49,6,0,0,0,0,152,176,50,6,0,0,0,0,160,176,51,6,0,0,0,0,168,176,52,6,0,0,0,0,176,176,53,6,0,0,0,0,184,176,54,6,0,0,0,0,185,176,55,6,0,0,0,0,186,176,56,6,0,0,0,0,187,176,57,6,0,0,0,0,188,176,58,6,0,0,0,0,192,176,59,6,0,0,0,0,200,176,60,6,0,0,0,0,208,176,61,6,0,0,0,0,216,176,62,6,0,0,0,0,224,176,63,6,0,0,0,0,232,176,64,6,0,0,0,0,240,176,65,6,0,0,0,0,248,176,66,6,0,0,0,0,249,176,67,6,0,0,0,0,250,176,68,6,0,0,0,0,251,176,69,6,0,0,0,0,252,176,70,6,0,0,0,0,0,177,71,6,0,0,0,0,8,177,72,6,0,0,0,0,16,177,73,6,0,0,0,0,24,177,74,6,0,0,0,0,32,177,75,6,0,0,0,0,40,177,76,6,0,0,0,0,48,177,77,6,0,0,0,0,56,177,78,6,0,0,0,0,57,177,79,6,0,0,0,0,64,177,80,6,0,0,0,0,72,177,81,6,0,0,0,0,80,177,82,6,0,0,0,0,88,177,83,6,0,0,0,0,96,177,84,6,0,0,0,0,104,177,85,6,0,0,0,0,112,177,86,6,0,0,0,0,120,177,87,6,0,0,0,0,121,177,88,6,0,0,0,0,128,177,89,6,0,0,0,0,136,177,90,6,0,0,0,0,144,177,91,6,0,0,0,0,152,177,92,6,0,0,0,0,160,177,93,6,0,0,0,0,168,177,94,6,0,0,0,0,176,177,95,6,0,0,0,0,184,177,96,6,0,0,0,0,185,177,97,6,0,0,0,0,192,177,98,6,0,0,0,0,200,177,99,6,0,0,0,0,208,177,100,6,0,0,0,0,216,177,101,6,0,0,0,0,224,177,102,6,0,0,0,0,232,177,103,6,0,0,0,0,240,177,104,6,0,0,0,0,248,177,105,6,0,0,0,0,249,177,106,6,0,0,0,0,250,177,107,6,0,0,0,0,251,177,108,6,0,0,0,0,252,177,109,6,0,0,0,0,0,192,110,6,0,0,0,0,16,192,111,6,0,0,0,0,24,192,112,6,0,0,0,0,32,192,113,6,0,0,0,0,40,192,114,6,0,0,0,0,48,192,115,6,0,0,0,0,56,192,116,6,0,0,0,0,57,192,117,6,0,0,0,0,58,192,118,6,0,0,0,0,59,192,119,6,0,0,0,0,60,192,120,6,0,0,0,0,64,192,121,6,0,0,0,0,80,192,122,6,0,0,0,0,88,192,123,6,0,0,0,0,96,192,124,6,0,0,0,0,104,192,125,6,0,0,0,0,112,192,126,6,0,0,0,0,120,192,127,6,0,0,0,0,121,192,128,6,0,0,0,0,122,192,129,6,0,0,0,0,123,192,130,6,0,0,0,0,124,192,131,6,0,0,0,0,128,192,132,6,0,0,0,0,144,192,133,6,0,0,0,0,152,192,134,6,0,0,0,0,160,192,135,6,0,0,0,0,168,192,136,6,0,0,0,0,176,192,137,6,0,0,0,0,184,192,138,6,0,0,0,0,185,192,139,6,0,0,0,0,186,192,140,6,0,0,0,0,187,192,141,6,0,0,0,0,188,192,142,6,0,0,0,0,192,192,143,6,0,0,0,0,208,192,144,6,0,0,0,0,216,192,145,6,0,0,0,0,224,192,146,6,0,0,0,0,232,192,147,6,0,0,0,0,240,192,148,6,0,0,0,0,248,192,149,6,0,0,0,0,249,192,150,6,0,0,0,0,250,192,151,6,0,0,0,0,251,192,152,6,0,0,0,0,252,192,0,8,0,0,0,0,0,193,1,8,0,0,0,0,8,193,155,6,0,0,0,0,16,193,156,6,0,0,0,0,24,193,157,6,0,0,0,0,32,193,158,6,0,0,0,0,40,193,159,6,0,0,0,0,48,193,160,6,0,0,0,0,56,193,161,6,0,0,0,0,57,193,162,6,0,0,0,0,64,193,163,6,0,0,0,0,72,193,164,6,0,0,0,0,80,193,165,6,0,0,0,0,88,193,166,6,0,0,0,0,96,193,167,6,0,0,0,0,104,193,168,6,0,0,0,0,112,193,169,6,0,0,0,0,120,193,170,6,0,0,0,0,121,193,171,6,0,0,0,0,136,193,172,6,0,0,0,0,144,193,173,6,0,0,0,0,152,193,174,6,0,0,0,0,160,193,175,6,0,0,0,0,168,193,176,6,0,0,0,0,176,193,177,6,0,0,0,0,184,193,178,6,0,0,0,0,185,193,179,6,0,0,0,0,192,193,180,6,0,0,0,0,208,193,181,6,0,0,0,0,216,193,182,6,0,0,0,0,224,193,183,6,0,0,0,0,232,193,184,6,0,0,0,0,240,193,185,6,0,0,0,0,248,193,186,6,0,0,0,0,249,193,187,6,0,0,0,0,250,193,188,6,0,0,0,0,251,193,189,6,0,0,0,0,252,193,190,6,0,0,0,0,0,208,191,6,0,0,0,0,16,208,192,6,0,0,0,0,24,208,193,6,0,0,0,0,32,208,194,6,0,0,0,0,40,208,195,6,0,0,0,0,48,208,196,6,0,0,0,0,56,208,197,6,0,0,0,0,57,208,198,6,0,0,0,0,58,208,199,6,0,0,0,0,59,208,200,6,0,0,0,0,60,208,201,6,0,0,0,0,64,208,202,6,0,0,0,0,72,208,203,6,0,0,0,0,80,208,204,6,0,0,0,0,88,208,205,6,0,0,0,0,96,208,206,6,0,0,0,0,104,208,207,6,0,0,0,0,112,208,208,6,0,0,0,0,120,208,209,6,0,0,0,0,121,208,210,6,0,0,0,0,122,208,211,6,0,0,0,0,123,208,212,6,0,0,0,0,124,208,213,6,0,0,0,0,128,208,214,6,0,0,0,0,136,208,215,6,0,0,0,0,144,208,216,6,0,0,0,0,152,208,217,6,0,0,0,0,160,208,218,6,0,0,0,0,168,208,219,6,0,0,0,0,176,208,220,6,0,0,0,0,184,208,221,6,0,0,0,0,185,208,222,6,0,0,0,0,186,208,223,6,0,0,0,0,187,208,224,6,0,0,0,0,188,208,225,6,0,0,0,0,192,208,226,6,0,0,0,0,200,208,227,6,0,0,0,0,208,208,228,6,0,0,0,0,216,208,229,6,0,0,0,0,224,208,230,6,0,0,0,0,232,208,231,6,0,0,0,0,240,208,232,6,0,0,0,0,248,208,233,6,0,0,0,0,249,208,234,6,0,0,0,0,250,208,235,6,0,0,0,0,251,208,236,6,0,0,0,0,252,208,237,6,0,0,0,0,0,209,238,6,0,0,0,0,8,209,239,6,0,0,0,0,16,209,240,6,0,0,0,0,24,209,241,6,0,0,0,0,32,209,242,6,0,0,0,0,40,209,243,6,0,0,0,0,48,209,244,6,0,0,0,0,56,209,245,6,0,0,0,0,57,209,246,6,0,0,0,0,64,209,247,6,0,0,0,0,72,209,248,6,0,0,0,0,80,209,249,6,0,0,0,0,88,209,250,6,0,0,0,0,96,209,251,6,0,0,0,0,104,209,252,6,0,0,0,0,112,209,253,6,0,0,0,0,120,209,254,6,0,0,0,0,121,209,255,6,0,0,0,0,128,209,0,7,0,0,0,0,136,209,1,7,0,0,0,0,144,209,2,7,0,0,0,0,152,209,3,7,0,0,0,0,160,209,4,7,0,0,0,0,168,209,5,7,0,0,0,0,176,209,6,7,0,0,0,0,184,209,7,7,0,0,0,0,185,209,8,7,0,0,0,0,192,209,9,7,0,0,0,0,200,209,10,7,0,0,0,0,208,209,11,7,0,0,0,0,216,209,12,7,0,0,0,0,224,209,13,7,0,0,0,0,232,209,14,7,0,0,0,0,240,209,15,7,0,0,0,0,248,209,16,7,0,0,0,0,249,209,17,7,0,0,0,0,250,209,18,7,0,0,0,0,251,209,19,7,0,0,0,0,252,209,20,7,0,0,0,0,0,224,21,7,0,0,0,0,8,224,22,7,0,0,0,0,16,224,23,7,0,0,0,0,24,224,24,7,0,0,0,0,32,224,25,7,0,0,0,0,40,224,26,7,0,0,0,0,48,224,27,7,0,0,0,0,56,224,28,7,0,0,0,0,64,224,29,7,0,0,0,0,72,224,30,7,0,0,0,0,80,224,31,7,0,0,0,0,88,224,32,7,0,0,0,0,96,224,33,7,0,0,0,0,104,224,34,7,0,0,0,0,112,224,35,7,0,0,0,0,120,224,36,7,0,0,0,0,128,224,37,7,0,0,0,0,136,224,38,7,0,0,0,0,144,224,39,7,0,0,0,0,152,224,40,7,0,0,0,0,160,224,41,7,0,0,0,0,168,224,42,7,0,0,0,0,176,224,43,7,0,0,0,0,184,224,44,7,0,0,0,0,208,224,45,7,0,0,0,0,216,224,46,7,0,0,0,0,224,224,47,7,0,0,0,0,232,224,48,7,0,0,0,0,240,224,49,7,0,0,0,0,248,224,50,7,0,0,0,0,249,224,51,7,0,0,0,0,0,225,52,7,0,0,0,0,8,225,53,7,0,0,0,0,16,225,54,7,0,0,0,0,24,225,55,7,0,0,0,0,32,225,56,7,0,0,0,0,40,225,57,7,0,0,0,0,48,225,58,7,0,0,0,0,56,225,59,7,0,0,0,0,64,225,60,7,0,0,0,0,72,225,61,7,0,0,0,0,80,225,62,7,0,0,0,0,88,225,63,7,0,0,0,0,96,225,64,7,0,0,0,0,104,225,65,7,0,0,0,0,112,225,66,7,0,0,0,0,120,225,67,7,0,0,0,0,128,225,68,7,0,0,0,0,136,225,69,7,0,0,0,0,144,225,70,7,0,0,0,0,152,225,71,7,0,0,0,0,160,225,72,7,0,0,0,0,168,225,73,7,0,0,0,0,176,225,74,7,0,0,0,0,184,225,75,7,0,0,0,0,208,225,76,7,0,0,0,0,216,225,77,7,0,0,0,0,224,225,78,7,0,0,0,0,232,225,79,7,0,0,0,0,240,225,80,7,0,0,0,0,248,225,81,7,0,0,0,0,249,225,82,7,0,0,0,0,208,226,83,7,0,0,0,0,216,226,84,7,0,0,0,0,224,226,85,7,0,0,0,0,232,226,86,7,0,0,0,0,240,226,87,7,0,0,0,0,248,226,88,7,0,0,0,0,249,226,89,7,0,0,0,0,208,227,90,7,0,0,0,0,216,227,91,7,0,0,0,0,224,227,92,7,0,0,0,0,232,227,93,7,0,0,0,0,240,227,94,7,0,0,0,0,248,227,95,7,0,0,0,0,249,227,96,7,0,0,0,0,208,228,97,7,0,0,0,0,216,228,98,7,0,0,0,0,224,228,99,7,0,0,0,0,232,228,100,7,0,0,0,0,240,228,101,7,0,0,0,0,248,228,102,7,0,0,0,0,249,228,103,7,0,0,0,0,208,229,104,7,0,0,0,0,216,229,105,7,0,0,0,0,224,229,106,7,0,0,0,0,232,229,107,7,0,0,0,0,240,229,108,7,0,0,0,0,248,229,109,7,0,0,0,0,249,229,110,7,0,0,0,0,208,230,111,7,0,0,0,0,216,230,112,7,0,0,0,0,224,230,113,7,0,0,0,0,232,230,114,7,0,0,0,0,240,230,115,7,0,0,0,0,248,230,116,7,0,0,0,0,249,230,117,7,0,0,0,0,208,231,118,7,0,0,0,0,216,231,119,7,0,0,0,0,224,231,120,7,0,0,0,0,232,231,121,7,0,0,0,0,240,231,122,7,0,0,0,0,248,231,123,7,0,0,0,0,249,231,124,7,0,0,0,0,192,232,125,7,0,0,0,0,208,232,126,7,0,0,0,0,232,232,127,7,0,0,0,0,240,232,128,7,0,0,0,0,248,232,129,7,0,0,0,0,249,232,130,7,0,0,0,0,250,232,131,7,0,0,0,0,251,232,132,7,0,0,0,0,192,233,133,7,0,0,0,0,208,233,134,7,0,0,0,0,232,233,135,7,0,0,0,0,240,233,136,7,0,0,0,0,248,233,137,7,0,0,0,0,249,233,138,7,0,0,0,0,250,233,139,7,0,0,0,0,251,233,140,7,0,0,0,0,192,234,141,7,0,0,0,0,208,234,142,7,0,0,0,0,232,234,143,7,0,0,0,0,240,234,144,7,0,0,0,0,248,234,145,7,0,0,0,0,249,234,146,7,0,0,0,0,192,235,147,7,0,0,0,0,208,235,148,7,0,0,0,0,232,235,149,7,0,0,0,0,240,235,150,7,0,0,0,0,248,235,151,7,0,0,0,0,249,235,152,7,0,0,0,0,250,235,153,7,0,0,0,0,251,235,154,7,0,0,0,0,192,236,155,7,0,0,0,0,208,236,156,7,0,0,0,0,232,236,157,7,0,0,0,0,240,236,158,7,0,0,0,0,248,236,159,7,0,0,0,0,249,236,160,7,0,0,0,0,192,237,161,7,0,0,0,0,208,237,162,7,0,0,0,0,232,237,163,7,0,0,0,0,240,237,164,7,0,0,0,0,248,237,165,7,0,0,0,0,249,237,166,7,0,0,0,0,250,237,167,7,0,0,0,0,251,237,168,7,0,0,0,0,192,238,169,7,0,0,0,0,208,238,170,7,0,0,0,0,232,238,171,7,0,0,0,0,240,238,172,7,0,0,0,0,248,238,173,7,0,0,0,0,249,238,174,7,0,0,0,0,192,239,175,7,0,0,0,0,208,239,176,7,0,0,0,0,232,239,177,7,0,0,0,0,240,239,178,7,0,0,0,0,248,239,179,7,0,0,0,0,249,239,0,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,171,0,0,0,0,0,16,0,172,0,0,0,0,0,24,0,173,0,0,0,0,0,32,0,174,0,0,0,0,0,40,0,2,8,0,0,0,0,48,0,176,0,0,0,0,0,56,0,177,0,0,0,0,0,57,0,178,0,0,0,0,0,60,0,179,0,0,0,0,0,64,0,180,0,0,0,0,0,80,0,181,0,0,0,0,0,88,0,182,0,0,0,0,0,96,0,183,0,0,0,0,0,104,0,3,8,0,0,0,0,112,0,185,0,0,0,0,0,120,0,186,0,0,0,0,0,121,0,187,0,0,0,0,0,124,0,188,0,0,0,0,0,128,0,189,0,0,0,0,0,144,0,190,0,0,0,0,0,152,0,191,0,0,0,0,0,160,0,192,0,0,0,0,0,168,0,4,8,0,0,0,0,176,0,194,0,0,0,0,0,184,0,195,0,0,0,0,0,185,0,203,0,0,0,0,0,0,1,204,0,0,0,0,0,8,1,205,0,0,0,0,0,16,1,206,0,0,0,0,0,24,1,207,0,0,0,0,0,32,1,208,0,0,0,0,0,40,1,5,8,0,0,0,0,48,1,210,0,0,0,0,0,56,1,211,0,0,0,0,0,57,1,212,0,0,0,0,0,58,1,6,8,0,0,0,0,59,1,214,0,0,0,0,0,60,1,215,0,0,0,0,0,64,1,216,0,0,0,0,0,72,1,217,0,0,0,0,0,80,1,218,0,0,0,0,0,88,1,219,0,0,0,0,0,96,1,220,0,0,0,0,0,104,1,7,8,0,0,0,0,112,1,222,0,0,0,0,0,120,1,223,0,0,0,0,0,121,1,224,0,0,0,0,0,122,1,8,8,0,0,0,0,123,1,226,0,0,0,0,0,128,1,227,0,0,0,0,0,136,1,228,0,0,0,0,0,144,1,229,0,0,0,0,0,152,1,230,0,0,0,0,0,160,1,231,0,0,0,0,0,168,1,9,8,0,0,0,0,176,1,233,0,0,0,0,0,184,1,234,0,0,0,0,0,185,1,235,0,0,0,0,0,186,1,10,8,0,0,0,0,187,1,237,0,0,0,0,0,192,1,238,0,0,0,0,0,200,1,239,0,0,0,0,0,208,1,240,0,0,0,0,0,216,1,241,0,0,0,0,0,224,1,242,0,0,0,0,0,232,1,11,8,0,0,0,0,240,1,244,0,0,0,0,0,248,1,245,0,0,0,0,0,249,1,246,0,0,0,0,0,250,1,12,8,0,0,0,0,251,1,248,0,0,0,0,0,0,2,249,0,0,0,0,0,16,2,250,0,0,0,0,0,24,2,251,0,0,0,0,0,32,2,252,0,0,0,0,0,40,2,13,8,0,0,0,0,48,2,254,0,0,0,0,0,56,2,255,0,0,0,0,0,57,2,0,1,0,0,0,0,60,2,1,1,0,0,0,0,64,2,2,1,0,0,0,0,80,2,3,1,0,0,0,0,88,2,4,1,0,0,0,0,96,2,5,1,0,0,0,0,104,2,14,8,0,0,0,0,112,2,7,1,0,0,0,0,120,2,8,1,0,0,0,0,121,2,9,1,0,0,0,0,124,2,10,1,0,0,0,0,128,2,11,1,0,0,0,0,144,2,12,1,0,0,0,0,152,2,13,1,0,0,0,0,160,2,14,1,0,0,0,0,168,2,15,8,0,0,0,0,176,2,16,1,0,0,0,0,184,2,17,1,0,0,0,0,185,2,25,1,0,0,0,0,0,4,26,1,0,0,0,0,16,4,27,1,0,0,0,0,24,4,28,1,0,0,0,0,32,4,29,1,0,0,0,0,40,4,16,8,0,0,0,0,48,4,31,1,0,0,0,0,56,4,32,1,0,0,0,0,57,4,33,1,0,0,0,0,64,4,34,1,0,0,0,0,80,4,35,1,0,0,0,0,88,4,36,1,0,0,0,0,96,4,37,1,0,0,0,0,104,4,17,8,0,0,0,0,112,4,39,1,0,0,0,0,120,4,40,1,0,0,0,0,121,4,41,1,0,0,0,0,128,4,42,1,0,0,0,0,144,4,43,1,0,0,0,0,152,4,44,1,0,0,0,0,160,4,45,1,0,0,0,0,168,4,18,8,0,0,0,0,176,4,47,1,0,0,0,0,184,4,48,1,0,0,0,0,185,4,56,1,0,0,0,0,0,6,57,1,0,0,0,0,16,6,58,1,0,0,0,0,24,6,59,1,0,0,0,0,32,6,60,1,0,0,0,0,40,6,19,8,0,0,0,0,48,6,62,1,0,0,0,0,56,6,63,1,0,0,0,0,57,6,64,1,0,0,0,0,64,6,65,1,0,0,0,0,80,6,66,1,0,0,0,0,88,6,67,1,0,0,0,0,96,6,68,1,0,0,0,0,104,6,20,8,0,0,0,0,112,6,70,1,0,0,0,0,120,6,71,1,0,0,0,0,121,6,72,1,0,0,0,0,128,6,73,1,0,0,0,0,144,6,74,1,0,0,0,0,152,6,75,1,0,0,0,0,160,6,76,1,0,0,0,0,168,6,21,8,0,0,0,0,176,6,78,1,0,0,0,0,184,6,79,1,0,0,0,0,185,6,89,1,0,0,0,0,0,8,90,1,0,0,0,0,16,8,91,1,0,0,0,0,24,8,92,1,0,0,0,0,32,8,93,1,0,0,0,0,40,8,22,8,0,0,0,0,48,8,95,1,0,0,0,0,56,8,96,1,0,0,0,0,57,8,97,1,0,0,0,0,58,8,23,8,0,0,0,0,59,8,99,1,0,0,0,0,60,8,100,1,0,0,0,0,64,8,101,1,0,0,0,0,80,8,102,1,0,0,0,0,88,8,103,1,0,0,0,0,96,8,104,1,0,0,0,0,104,8,24,8,0,0,0,0,112,8,106,1,0,0,0,0,120,8,107,1,0,0,0,0,121,8,108,1,0,0,0,0,122,8,25,8,0,0,0,0,123,8,110,1,0,0,0,0,128,8,111,1,0,0,0,0,144,8,112,1,0,0,0,0,152,8,113,1,0,0,0,0,160,8,114,1,0,0,0,0,168,8,26,8,0,0,0,0,176,8,116,1,0,0,0,0,184,8,117,1,0,0,0,0,185,8,118,1,0,0,0,0,186,8,27,8,0,0,0,0,187,8,120,1,0,0,0,0,192,8,121,1,0,0,0,0,208,8,122,1,0,0,0,0,216,8,123,1,0,0,0,0,224,8,124,1,0,0,0,0,232,8,28,8,0,0,0,0,240,8,126,1,0,0,0,0,248,8,127,1,0,0,0,0,249,8,128,1,0,0,0,0,250,8,29,8,0,0,0,0,251,8,130,1,0,0,0,0,0,10,131,1,0,0,0,0,16,10,132,1,0,0,0,0,24,10,133,1,0,0,0,0,32,10,134,1,0,0,0,0,40,10,30,8,0,0,0,0,48,10,136,1,0,0,0,0,56,10,137,1,0,0,0,0,57,10,138,1,0,0,0,0,60,10,139,1,0,0,0,0,64,10,140,1,0,0,0,0,80,10,141,1,0,0,0,0,88,10,142,1,0,0,0,0,96,10,143,1,0,0,0,0,104,10,31,8,0,0,0,0,112,10,145,1,0,0,0,0,120,10,146,1,0,0,0,0,121,10,147,1,0,0,0,0,124,10,148,1,0,0,0,0,128,10,149,1,0,0,0,0,144,10,150,1,0,0,0,0,152,10,151,1,0,0,0,0,160,10,152,1,0,0,0,0,168,10,32,8,0,0,0,0,176,10,154,1,0,0,0,0,184,10,155,1,0,0,0,0,185,10,163,1,0,0,0,0,0,12,164,1,0,0,0,0,16,12,165,1,0,0,0,0,24,12,166,1,0,0,0,0,32,12,167,1,0,0,0,0,40,12,33,8,0,0,0,0,48,12,169,1,0,0,0,0,56,12,170,1,0,0,0,0,57,12,171,1,0,0,0,0,58,12,34,8,0,0,0,0,59,12,173,1,0,0,0,0,64,12,174,1,0,0,0,0,80,12,175,1,0,0,0,0,88,12,176,1,0,0,0,0,96,12,177,1,0,0,0,0,104,12,35,8,0,0,0,0,112,12,179,1,0,0,0,0,120,12,180,1,0,0,0,0,121,12,181,1,0,0,0,0,122,12,36,8,0,0,0,0,123,12,183,1,0,0,0,0,128,12,184,1,0,0,0,0,144,12,185,1,0,0,0,0,152,12,186,1,0,0,0,0,160,12,187,1,0,0,0,0,168,12,37,8,0,0,0,0,176,12,189,1,0,0,0,0,184,12,190,1,0,0,0,0,185,12,191,1,0,0,0,0,186,12,38,8,0,0,0,0,187,12,230,1,0,0,0,0,0,16,231,1,0,0,0,0,16,16,232,1,0,0,0,0,24,16,233,1,0,0,0,0,32,16,234,1,0,0,0,0,40,16,39,8,0,0,0,0,48,16,236,1,0,0,0,0,56,16,237,1,0,0,0,0,57,16,238,1,0,0,0,0,58,16,40,8,0,0,0,0,59,16,240,1,0,0,0,0,60,16,241,1,0,0,0,0,128,16,242,1,0,0,0,0,144,16,243,1,0,0,0,0,152,16,244,1,0,0,0,0,160,16,245,1,0,0,0,0,168,16,41,8,0,0,0,0,176,16,247,1,0,0,0,0,184,16,248,1,0,0,0,0,185,16,249,1,0,0,0,0,186,16,42,8,0,0,0,0,187,16,251,1,0,0,0,0,188,16,252,1,0,0,0,0,192,16,253,1,0,0,0,0,208,16,254,1,0,0,0,0,216,16,255,1,0,0,0,0,224,16,0,2,0,0,0,0,232,16,43,8,0,0,0,0,240,16,2,2,0,0,0,0,248,16,3,2,0,0,0,0,249,16,4,2,0,0,0,0,250,16,44,8,0,0,0,0,251,16,6,2,0,0,0,0,252,16,7,2,0,0,0,0,0,17,8,2,0,0,0,0,16,17,9,2,0,0,0,0,24,17,10,2,0,0,0,0,32,17,11,2,0,0,0,0,40,17,45,8,0,0,0,0,48,17,13,2,0,0,0,0,56,17,14,2,0,0,0,0,57,17,15,2,0,0,0,0,58,17,46,8,0,0,0,0,59,17,17,2,0,0,0,0,60,17,18,2,0,0,0,0,64,17,19,2,0,0,0,0,80,17,20,2,0,0,0,0,88,17,21,2,0,0,0,0,96,17,22,2,0,0,0,0,104,17,47,8,0,0,0,0,112,17,24,2,0,0,0,0,120,17,25,2,0,0,0,0,121,17,26,2,0,0,0,0,122,17,48,8,0,0,0,0,123,17,28,2,0,0,0,0,124,17,49,8,0,0,0,0,128,17,50,8,0,0,0,0,144,17,51,8,0,0,0,0,152,17,52,8,0,0,0,0,160,17,53,8,0,0,0,0,168,17,54,8,0,0,0,0,176,17,55,8,0,0,0,0,184,17,56,8,0,0,0,0,185,17,57,8,0,0,0,0,186,17,58,8,0,0,0,0,187,17,59,8,0,0,0,0,188,17,40,2,0,0,0,0,192,17,41,2,0,0,0,0,208,17,42,2,0,0,0,0,216,17,43,2,0,0,0,0,224,17,44,2,0,0,0,0,232,17,60,8,0,0,0,0,240,17,46,2,0,0,0,0,248,17,47,2,0,0,0,0,249,17,48,2,0,0,0,0,250,17,61,8,0,0,0,0,251,17,50,2,0,0,0,0,252,17,51,2,0,0,0,0,192,19,52,2,0,0,0,0,208,19,53,2,0,0,0,0,216,19,54,2,0,0,0,0,224,19,55,2,0,0,0,0,232,19,62,8,0,0,0,0,240,19,57,2,0,0,0,0,248,19,58,2,0,0,0,0,249,19,59,2,0,0,0,0,250,19,63,8,0,0,0,0,251,19,61,2,0,0,0,0,252,19,62,2,0,0,0,0,0,32,63,2,0,0,0,0,8,32,64,2,0,0,0,0,16,32,65,2,0,0,0,0,24,32,66,2,0,0,0,0,32,32,67,2,0,0,0,0,40,32,64,8,0,0,0,0,48,32,69,2,0,0,0,0,56,32,70,2,0,0,0,0,57,32,71,2,0,0,0,0,58,32,65,8,0,0,0,0,59,32,73,2,0,0,0,0,60,32,74,2,0,0,0,0,64,32,75,2,0,0,0,0,72,32,76,2,0,0,0,0,80,32,77,2,0,0,0,0,88,32,78,2,0,0,0,0,96,32,79,2,0,0,0,0,104,32,66,8,0,0,0,0,112,32,81,2,0,0,0,0,120,32,82,2,0,0,0,0,121,32,83,2,0,0,0,0,122,32,67,8,0,0,0,0,123,32,85,2,0,0,0,0,124,32,86,2,0,0,0,0,128,32,87,2,0,0,0,0,136,32,88,2,0,0,0,0,144,32,89,2,0,0,0,0,152,32,90,2,0,0,0,0,160,32,91,2,0,0,0,0,168,32,68,8,0,0,0,0,176,32,93,2,0,0,0,0,184,32,94,2,0,0,0,0,185,32,95,2,0,0,0,0,186,32,69,8,0,0,0,0,187,32,97,2,0,0,0,0,188,32,98,2,0,0,0,0,192,32,99,2,0,0,0,0,200,32,100,2,0,0,0,0,208,32,101,2,0,0,0,0,216,32,102,2,0,0,0,0,224,32,103,2,0,0,0,0,232,32,70,8,0,0,0,0,240,32,105,2,0,0,0,0,248,32,106,2,0,0,0,0,249,32,107,2,0,0,0,0,250,32,71,8,0,0,0,0,251,32,109,2,0,0,0,0,252,32,110,2,0,0,0,0,0,33,111,2,0,0,0,0,8,33,112,2,0,0,0,0,16,33,113,2,0,0,0,0,24,33,114,2,0,0,0,0,32,33,115,2,0,0,0,0,40,33,72,8,0,0,0,0,48,33,117,2,0,0,0,0,56,33,118,2,0,0,0,0,57,33,119,2,0,0,0,0,58,33,73,8,0,0,0,0,59,33,121,2,0,0,0,0,60,33,122,2,0,0,0,0,64,33,123,2,0,0,0,0,72,33,124,2,0,0,0,0,80,33,125,2,0,0,0,0,88,33,126,2,0,0,0,0,96,33,127,2,0,0,0,0,104,33,74,8,0,0,0,0,112,33,129,2,0,0,0,0,120,33,130,2,0,0,0,0,121,33,131,2,0,0,0,0,122,33,75,8,0,0,0,0,123,33,133,2,0,0,0,0,124,33,76,8,0,0,0,0,128,33,77,8,0,0,0,0,136,33,78,8,0,0,0,0,144,33,79,8,0,0,0,0,152,33,80,8,0,0,0,0,160,33,81,8,0,0,0,0,168,33,82,8,0,0,0,0,176,33,83,8,0,0,0,0,184,33,84,8,0,0,0,0,185,33,85,8,0,0,0,0,186,33,86,8,0,0,0,0,187,33,87,8,0,0,0,0,188,33,146,2,0,0,0,0,192,33,147,2,0,0,0,0,200,33,148,2,0,0,0,0,208,33,149,2,0,0,0,0,216,33,150,2,0,0,0,0,224,33,151,2,0,0,0,0,232,33,88,8,0,0,0,0,240,33,153,2,0,0,0,0,248,33,154,2,0,0,0,0,249,33,155,2,0,0,0,0,250,33,89,8,0,0,0,0,251,33,157,2,0,0,0,0,252,33,158,2,0,0,0,0,192,35,159,2,0,0,0,0,200,35,160,2,0,0,0,0,208,35,161,2,0,0,0,0,216,35,162,2,0,0,0,0,224,35,163,2,0,0,0,0,232,35,90,8,0,0,0,0,240,35,165,2,0,0,0,0,248,35,166,2,0,0,0,0,249,35,167,2,0,0,0,0,250,35,91,8,0,0,0,0,251,35,169,2,0,0,0,0,252,35,170,2,0,0,0,0,0,48,171,2,0,0,0,0,8,48,172,2,0,0,0,0,16,48,173,2,0,0,0,0,24,48,174,2,0,0,0,0,32,48,175,2,0,0,0,0,40,48,92,8,0,0,0,0,48,48,177,2,0,0,0,0,56,48,178,2,0,0,0,0,57,48,179,2,0,0,0,0,58,48,93,8,0,0,0,0,59,48,181,2,0,0,0,0,60,48,182,2,0,0,0,0,64,48,183,2,0,0,0,0,72,48,184,2,0,0,0,0,80,48,185,2,0,0,0,0,88,48,186,2,0,0,0,0,96,48,187,2,0,0,0,0,104,48,94,8,0,0,0,0,112,48,189,2,0,0,0,0,120,48,190,2,0,0,0,0,121,48,191,2,0,0,0,0,122,48,95,8,0,0,0,0,123,48,193,2,0,0,0,0,124,48,194,2,0,0,0,0,128,48,195,2,0,0,0,0,136,48,196,2,0,0,0,0,144,48,197,2,0,0,0,0,152,48,198,2,0,0,0,0,160,48,199,2,0,0,0,0,168,48,96,8,0,0,0,0,176,48,201,2,0,0,0,0,184,48,202,2,0,0,0,0,185,48,203,2,0,0,0,0,186,48,97,8,0,0,0,0,187,48,205,2,0,0,0,0,188,48,206,2,0,0,0,0,192,48,207,2,0,0,0,0,200,48,208,2,0,0,0,0,208,48,209,2,0,0,0,0,216,48,210,2,0,0,0,0,224,48,211,2,0,0,0,0,232,48,98,8,0,0,0,0,240,48,213,2,0,0,0,0,248,48,214,2,0,0,0,0,249,48,215,2,0,0,0,0,250,48,99,8,0,0,0,0,251,48,217,2,0,0,0,0,252,48,218,2,0,0,0,0,0,49,219,2,0,0,0,0,8,49,220,2,0,0,0,0,16,49,221,2,0,0,0,0,24,49,222,2,0,0,0,0,32,49,223,2,0,0,0,0,40,49,100,8,0,0,0,0,48,49,225,2,0,0,0,0,56,49,226,2,0,0,0,0,57,49,227,2,0,0,0,0,58,49,101,8,0,0,0,0,59,49,229,2,0,0,0,0,60,49,230,2,0,0,0,0,64,49,231,2,0,0,0,0,72,49,232,2,0,0,0,0,80,49,233,2,0,0,0,0,88,49,234,2,0,0,0,0,96,49,235,2,0,0,0,0,104,49,102,8,0,0,0,0,112,49,237,2,0,0,0,0,120,49,238,2,0,0,0,0,121,49,239,2,0,0,0,0,122,49,103,8,0,0,0,0,123,49,241,2,0,0,0,0,124,49,104,8,0,0,0,0,128,49,105,8,0,0,0,0,136,49,106,8,0,0,0,0,144,49,107,8,0,0,0,0,152,49,108,8,0,0,0,0,160,49,109,8,0,0,0,0,168,49,110,8,0,0,0,0,176,49,111,8,0,0,0,0,184,49,112,8,0,0,0,0,185,49,113,8,0,0,0,0,186,49,114,8,0,0,0,0,187,49,115,8,0,0,0,0,188,49,254,2,0,0,0,0,192,49,255,2,0,0,0,0,200,49,0,3,0,0,0,0,208,49,1,3,0,0,0,0,216,49,2,3,0,0,0,0,224,49,3,3,0,0,0,0,232,49,116,8,0,0,0,0,240,49,5,3,0,0,0,0,248,49,6,3,0,0,0,0,249,49,7,3,0,0,0,0,250,49,117,8,0,0,0,0,251,49,9,3,0,0,0,0,252,49,10,3,0,0,0,0,192,51,11,3,0,0,0,0,200,51,12,3,0,0,0,0,208,51,13,3,0,0,0,0,216,51,14,3,0,0,0,0,224,51,15,3,0,0,0,0,232,51,118,8,0,0,0,0,240,51,17,3,0,0,0,0,248,51,18,3,0,0,0,0,249,51,19,3,0,0,0,0,250,51,119,8,0,0,0,0,251,51,21,3,0,0,0,0,252,51,22,3,0,0,0,0,0,64,23,3,0,0,0,0,16,64,24,3,0,0,0,0,24,64,25,3,0,0,0,0,32,64,26,3,0,0,0,0,40,64,120,8,0,0,0,0,48,64,28,3,0,0,0,0,56,64,29,3,0,0,0,0,57,64,30,3,0,0,0,0,64,64,31,3,0,0,0,0,80,64,32,3,0,0,0,0,88,64,33,3,0,0,0,0,96,64,34,3,0,0,0,0,104,64,121,8,0,0,0,0,112,64,36,3,0,0,0,0,120,64,37,3,0,0,0,0,121,64,38,3,0,0,0,0,128,64,39,3,0,0,0,0,144,64,40,3,0,0,0,0,152,64,41,3,0,0,0,0,160,64,42,3,0,0,0,0,168,64,122,8,0,0,0,0,176,64,44,3,0,0,0,0,184,64,45,3,0,0,0,0,185,64,46,3,0,0,0,0,192,64,47,3,0,0,0,0,208,64,48,3,0,0,0,0,216,64,49,3,0,0,0,0,224,64,50,3,0,0,0,0,232,64,123,8,0,0,0,0,240,64,52,3,0,0,0,0,248,64,53,3,0,0,0,0,249,64,54,3,0,0,0,0,0,65,55,3,0,0,0,0,16,65,56,3,0,0,0,0,24,65,57,3,0,0,0,0,32,65,58,3,0,0,0,0,40,65,124,8,0,0,0,0,48,65,60,3,0,0,0,0,56,65,61,3,0,0,0,0,57,65,62,3,0,0,0,0,58,65,125,8,0,0,0,0,59,65,64,3,0,0,0,0,60,65,65,3,0,0,0,0,128,65,66,3,0,0,0,0,144,65,67,3,0,0,0,0,152,65,68,3,0,0,0,0,160,65,69,3,0,0,0,0,168,65,126,8,0,0,0,0,176,65,71,3,0,0,0,0,184,65,72,3,0,0,0,0,185,65,73,3,0,0,0,0,186,65,127,8,0,0,0,0,187,65,75,3,0,0,0,0,188,65,76,3,0,0,0,0,208,65,77,3,0,0,0,0,232,65,128,8,0,0,0,0,240,65,79,3,0,0,0,0,248,65,80,3,0,0,0,0,249,65,81,3,0,0,0,0,250,65,129,8,0,0,0,0,251,65,83,3,0,0,0,0,0,66,84,3,0,0,0,0,16,66,85,3,0,0,0,0,24,66,86,3,0,0,0,0,32,66,87,3,0,0,0,0,40,66,130,8,0,0,0,0,48,66,89,3,0,0,0,0,56,66,90,3,0,0,0,0,57,66,91,3,0,0,0,0,64,66,92,3,0,0,0,0,80,66,93,3,0,0,0,0,88,66,94,3,0,0,0,0,96,66,95,3,0,0,0,0,104,66,131,8,0,0,0,0,112,66,97,3,0,0,0,0,120,66,98,3,0,0,0,0,121,66,99,3,0,0,0,0,128,66,100,3,0,0,0,0,144,66,101,3,0,0,0,0,152,66,102,3,0,0,0,0,160,66,103,3,0,0,0,0,168,66,132,8,0,0,0,0,176,66,105,3,0,0,0,0,184,66,106,3,0,0,0,0,185,66,107,3,0,0,0,0,192,66,108,3,0,0,0,0,208,66,109,3,0,0,0,0,216,66,110,3,0,0,0,0,224,66,111,3,0,0,0,0,232,66,133,8,0,0,0,0,240,66,113,3,0,0,0,0,248,66,114,3,0,0,0,0,249,66,115,3,0,0,0,0,0,68,116,3,0,0,0,0,16,68,117,3,0,0,0,0,24,68,118,3,0,0,0,0,32,68,119,3,0,0,0,0,40,68,134,8,0,0,0,0,48,68,121,3,0,0,0,0,56,68,122,3,0,0,0,0,57,68,123,3,0,0,0,0,64,68,124,3,0,0,0,0,80,68,125,3,0,0,0,0,88,68,126,3,0,0,0,0,96,68,127,3,0,0,0,0,104,68,135,8,0,0,0,0,112,68,129,3,0,0,0,0,120,68,130,3,0,0,0,0,121,68,131,3,0,0,0,0,128,68,132,3,0,0,0,0,144,68,133,3,0,0,0,0,152,68,134,3,0,0,0,0,160,68,135,3,0,0,0,0,168,68,136,8,0,0,0,0,176,68,137,3,0,0,0,0,184,68,138,3,0,0,0,0,185,68,139,3,0,0,0,0,192,68,140,3,0,0,0,0,208,68,141,3,0,0,0,0,216,68,142,3,0,0,0,0,224,68,143,3,0,0,0,0,232,68,137,8,0,0,0,0,240,68,145,3,0,0,0,0,248,68,146,3,0,0,0,0,249,68,147,3,0,0,0,0,250,68,138,8,0,0,0,0,251,68,149,3,0,0,0,0,252,68,150,3,0,0,0,0,0,70,151,3,0,0,0,0,16,70,152,3,0,0,0,0,24,70,153,3,0,0,0,0,32,70,154,3,0,0,0,0,40,70,139,8,0,0,0,0,48,70,156,3,0,0,0,0,56,70,157,3,0,0,0,0,57,70,158,3,0,0,0,0,64,70,159,3,0,0,0,0,80,70,160,3,0,0,0,0,88,70,161,3,0,0,0,0,96,70,162,3,0,0,0,0,104,70,140,8,0,0,0,0,112,70,164,3,0,0,0,0,120,70,165,3,0,0,0,0,121,70,166,3,0,0,0,0,128,70,167,3,0,0,0,0,144,70,168,3,0,0,0,0,152,70,169,3,0,0,0,0,160,70,170,3,0,0,0,0,168,70,141,8,0,0,0,0,176,70,172,3,0,0,0,0,184,70,173,3,0,0,0,0,185,70,174,3,0,0,0,0,192,70,175,3,0,0,0,0,208,70,176,3,0,0,0,0,216,70,177,3,0,0,0,0,224,70,178,3,0,0,0,0,232,70,142,8,0,0,0,0,240,70,180,3,0,0,0,0,248,70,181,3,0,0,0,0,249,70,182,3,0,0,0,0,250,70,143,8,0,0,0,0,251,70,184,3,0,0,0,0,252,70,246,7,0,0,0,0,0,72,247,7,0,0,0,0,16,72,248,7,0,0,0,0,24,72,249,7,0,0,0,0,32,72,250,7,0,0,0,0,40,72,144,8,0,0,0,0,48,72,252,7,0,0,0,0,56,72,253,7,0,0,0,0,57,72,194,3,0,0,0,0,64,72,196,3,0,0,0,0,80,72,197,3,0,0,0,0,104,72,145,8,0,0,0,0,112,72,199,3,0,0,0,0,120,72,200,3,0,0,0,0,121,72,201,3,0,0,0,0,122,72,146,8,0,0,0,0,123,72,203,3,0,0,0,0,128,72,204,3,0,0,0,0,144,72,205,3,0,0,0,0,160,72,206,3,0,0,0,0,168,72,147,8,0,0,0,0,176,72,208,3,0,0,0,0,184,72,209,3,0,0,0,0,185,72,210,3,0,0,0,0,192,72,211,3,0,0,0,0,208,72,212,3,0,0,0,0,224,72,213,3,0,0,0,0,232,72,148,8,0,0,0,0,240,72,215,3,0,0,0,0,248,72,216,3,0,0,0,0,249,72,217,3,0,0,0,0,192,73,218,3,0,0,0,0,0,74,219,3,0,0,0,0,16,74,220,3,0,0,0,0,24,74,221,3,0,0,0,0,32,74,222,3,0,0,0,0,40,74,149,8,0,0,0,0,48,74,224,3,0,0,0,0,56,74,225,3,0,0,0,0,57,74,226,3,0,0,0,0,58,74,150,8,0,0,0,0,59,74,228,3,0,0,0,0,60,74,229,3,0,0,0,0,64,74,230,3,0,0,0,0,72,74,231,3,0,0,0,0,80,74,232,3,0,0,0,0,88,74,233,3,0,0,0,0,96,74,234,3,0,0,0,0,104,74,151,8,0,0,0,0,112,74,236,3,0,0,0,0,120,74,237,3,0,0,0,0,121,74,238,3,0,0,0,0,122,74,152,8,0,0,0,0,123,74,240,3,0,0,0,0,124,74,241,3,0,0,0,0,128,74,242,3,0,0,0,0,136,74,243,3,0,0,0,0,144,74,244,3,0,0,0,0,152,74,245,3,0,0,0,0,160,74,246,3,0,0,0,0,168,74,153,8,0,0,0,0,176,74,248,3,0,0,0,0,184,74,249,3,0,0,0,0,185,74,250,3,0,0,0,0,186,74,154,8,0,0,0,0,187,74,252,3,0,0,0,0,188,74,253,3,0,0,0,0,192,74,254,3,0,0,0,0,208,74,255,3,0,0,0,0,216,74,0,4,0,0,0,0,224,74,1,4,0,0,0,0,232,74,155,8,0,0,0,0,240,74,3,4,0,0,0,0,248,74,4,4,0,0,0,0,249,74,27,4,0,0,0,0,144,76,28,4,0,0,0,0,152,76,29,4,0,0,0,0,168,76,156,8,0,0,0,0,176,76,31,4,0,0,0,0,184,76,32,4,0,0,0,0,185,76,33,4,0,0,0,0,186,76,157,8,0,0,0,0,187,76,35,4,0,0,0,0,208,76,36,4,0,0,0,0,216,76,37,4,0,0,0,0,232,76,158,8,0,0,0,0,240,76,39,4,0,0,0,0,248,76,40,4,0,0,0,0,249,76,41,4,0,0,0,0,250,76,159,8,0,0,0,0,251,76,43,4,0,0,0,0,64,78,44,4,0,0,0,0,80,78,45,4,0,0,0,0,88,78,46,4,0,0,0,0,96,78,47,4,0,0,0,0,104,78,48,4,0,0,0,0,112,78,49,4,0,0,0,0,113,78,50,4,0,0,0,0,114,78,51,4,0,0,0,0,115,78,52,4,0,0,0,0,116,78,53,4,0,0,0,0,117,78,54,4,0,0,0,0,118,78,55,4,0,0,0,0,119,78,56,4,0,0,0,0,122,78,57,4,0,0,0,0,123,78,58,4,0,0,0,0,144,78,59,4,0,0,0,0,168,78,160,8,0,0,0,0,176,78,61,4,0,0,0,0,184,78,62,4,0,0,0,0,185,78,63,4,0,0,0,0,186,78,161,8,0,0,0,0,187,78,65,4,0,0,0,0,208,78,66,4,0,0,0,0,232,78,162,8,0,0,0,0,240,78,68,4,0,0,0,0,248,78,69,4,0,0,0,0,249,78,70,4,0,0,0,0,250,78,163,8,0,0,0,0,251,78,72,4,0,0,0,0,0,80,73,4,0,0,0,0,16,80,74,4,0,0,0,0,24,80,75,4,0,0,0,0,32,80,76,4,0,0,0,0,40,80,164,8,0,0,0,0,48,80,78,4,0,0,0,0,56,80,79,4,0,0,0,0,57,80,80,4,0,0,0,0,64,80,81,4,0,0,0,0,72,80,82,4,0,0,0,0,80,80,83,4,0,0,0,0,88,80,84,4,0,0,0,0,96,80,85,4,0,0,0,0,104,80,165,8,0,0,0,0,112,80,87,4,0,0,0,0,120,80,88,4,0,0,0,0,121,80,89,4,0,0,0,0,128,80,90,4,0,0,0,0,136,80,91,4,0,0,0,0,144,80,92,4,0,0,0,0,152,80,93,4,0,0,0,0,160,80,94,4,0,0,0,0,168,80,166,8,0,0,0,0,176,80,96,4,0,0,0,0,184,80,97,4,0,0,0,0,185,80,98,4,0,0,0,0,192,80,99,4,0,0,0,0,200,80,100,4,0,0,0,0,208,80,101,4,0,0,0,0,216,80,102,4,0,0,0,0,224,80,103,4,0,0,0,0,232,80,167,8,0,0,0,0,240,80,105,4,0,0,0,0,248,80,106,4,0,0,0,0,249,80,110,4,0,0,0,0,0,81,111,4,0,0,0,0,16,81,112,4,0,0,0,0,24,81,113,4,0,0,0,0,32,81,114,4,0,0,0,0,40,81,168,8,0,0,0,0,48,81,116,4,0,0,0,0,56,81,117,4,0,0,0,0,57,81,118,4,0,0,0,0,64,81,119,4,0,0,0,0,72,81,120,4,0,0,0,0,80,81,121,4,0,0,0,0,88,81,122,4,0,0,0,0,96,81,123,4,0,0,0,0,104,81,169,8,0,0,0,0,112,81,125,4,0,0,0,0,120,81,126,4,0,0,0,0,121,81,127,4,0,0,0,0,128,81,128,4,0,0,0,0,136,81,129,4,0,0,0,0,144,81,130,4,0,0,0,0,152,81,131,4,0,0,0,0,160,81,132,4,0,0,0,0,168,81,170,8,0,0,0,0,176,81,134,4,0,0,0,0,184,81,135,4,0,0,0,0,185,81,136,4,0,0,0,0,192,81,137,4,0,0,0,0,200,81,138,4,0,0,0,0,208,81,139,4,0,0,0,0,216,81,140,4,0,0,0,0,224,81,141,4,0,0,0,0,232,81,171,8,0,0,0,0,240,81,143,4,0,0,0,0,248,81,144,4,0,0,0,0,249,81,148,4,0,0,0,0,192,82,149,4,0,0,0,0,200,82,150,4,0,0,0,0,208,82,151,4,0,0,0,0,216,82,152,4,0,0,0,0,224,82,153,4,0,0,0,0,232,82,172,8,0,0,0,0,240,82,155,4,0,0,0,0,248,82,156,4,0,0,0,0,249,82,160,4,0,0,0,0,192,83,161,4,0,0,0,0,200,83,162,4,0,0,0,0,208,83,163,4,0,0,0,0,216,83,164,4,0,0,0,0,224,83,165,4,0,0,0,0,232,83,173,8,0,0,0,0,240,83,167,4,0,0,0,0,248,83,168,4,0,0,0,0,249,83,172,4,0,0,0,0,192,84,173,4,0,0,0,0,200,84,174,4,0,0,0,0,208,84,175,4,0,0,0,0,216,84,176,4,0,0,0,0,224,84,177,4,0,0,0,0,232,84,174,8,0,0,0,0,240,84,179,4,0,0,0,0,248,84,180,4,0,0,0,0,249,84,184,4,0,0,0,0,192,85,185,4,0,0,0,0,200,85,186,4,0,0,0,0,208,85,187,4,0,0,0,0,216,85,188,4,0,0,0,0,224,85,189,4,0,0,0,0,232,85,175,8,0,0,0,0,240,85,191,4,0,0,0,0,248,85,192,4,0,0,0,0,249,85,196,4,0,0,0,0,192,86,197,4,0,0,0,0,200,86,198,4,0,0,0,0,208,86,199,4,0,0,0,0,216,86,200,4,0,0,0,0,224,86,201,4,0,0,0,0,232,86,176,8,0,0,0,0,240,86,203,4,0,0,0,0,248,86,204,4,0,0,0,0,249,86,208,4,0,0,0,0,192,87,209,4,0,0,0,0,200,87,210,4,0,0,0,0,208,87,211,4,0,0,0,0,216,87,212,4,0,0,0,0,224,87,213,4,0,0,0,0,232,87,177,8,0,0,0,0,240,87,215,4,0,0,0,0,248,87,216,4,0,0,0,0,249,87,220,4,0,0,0,0,192,88,221,4,0,0,0,0,200,88,222,4,0,0,0,0,208,88,223,4,0,0,0,0,216,88,224,4,0,0,0,0,224,88,225,4,0,0,0,0,232,88,178,8,0,0,0,0,240,88,227,4,0,0,0,0,248,88,228,4,0,0,0,0,249,88,232,4,0,0,0,0,192,89,233,4,0,0,0,0,200,89,234,4,0,0,0,0,208,89,235,4,0,0,0,0,216,89,236,4,0,0,0,0,224,89,237,4,0,0,0,0,232,89,179,8,0,0,0,0,240,89,239,4,0,0,0,0,248,89,240,4,0,0,0,0,249,89,244,4,0,0,0,0,192,90,245,4,0,0,0,0,200,90,246,4,0,0,0,0,208,90,247,4,0,0,0,0,216,90,248,4,0,0,0,0,224,90,249,4,0,0,0,0,232,90,180,8,0,0,0,0,240,90,251,4,0,0,0,0,248,90,252,4,0,0,0,0,249,90,0,5,0,0,0,0,192,91,1,5,0,0,0,0,200,91,2,5,0,0,0,0,208,91,3,5,0,0,0,0,216,91,4,5,0,0,0,0,224,91,5,5,0,0,0,0,232,91,181,8,0,0,0,0,240,91,7,5,0,0,0,0,248,91,8,5,0,0,0,0,249,91,12,5,0,0,0,0,192,92,13,5,0,0,0,0,200,92,14,5,0,0,0,0,208,92,15,5,0,0,0,0,216,92,16,5,0,0,0,0,224,92,17,5,0,0,0,0,232,92,182,8,0,0,0,0,240,92,19,5,0,0,0,0,248,92,20,5,0,0,0,0,249,92,24,5,0,0,0,0,192,93,25,5,0,0,0,0,200,93,26,5,0,0,0,0,208,93,27,5,0,0,0,0,216,93,28,5,0,0,0,0,224,93,29,5,0,0,0,0,232,93,183,8,0,0,0,0,240,93,31,5,0,0,0,0,248,93,32,5,0,0,0,0,249,93,36,5,0,0,0,0,192,94,37,5,0,0,0,0,200,94,38,5,0,0,0,0,208,94,39,5,0,0,0,0,216,94,40,5,0,0,0,0,224,94,41,5,0,0,0,0,232,94,184,8,0,0,0,0,240,94,43,5,0,0,0,0,248,94,44,5,0,0,0,0,249,94,48,5,0,0,0,0,192,95,49,5,0,0,0,0,200,95,50,5,0,0,0,0,208,95,51,5,0,0,0,0,216,95,52,5,0,0,0,0,224,95,53,5,0,0,0,0,232,95,185,8,0,0,0,0,240,95,55,5,0,0,0,0,248,95,56,5,0,0,0,0,249,95,60,5,0,0,0,0,0,96,61,5,0,0,0,0,1,96,186,8,0,0,0,0,255,96,63,5,0,0,0,0,0,97,64,5,0,0,0,0,1,97,65,5,0,0,0,0,255,97,66,5,0,0,0,0,0,98,67,5,0,0,0,0,1,98,187,8,0,0,0,0,255,98,69,5,0,0,0,0,0,99,70,5,0,0,0,0,1,99,188,8,0,0,0,0,255,99,72,5,0,0,0,0,0,100,73,5,0,0,0,0,1,100,189,8,0,0,0,0,255,100,75,5,0,0,0,0,0,101,76,5,0,0,0,0,1,101,190,8,0,0,0,0,255,101,78,5,0,0,0,0,0,102,79,5,0,0,0,0,1,102,191,8,0,0,0,0,255,102,81,5,0,0,0,0,0,103,82,5,0,0,0,0,1,103,192,8,0,0,0,0,255,103,84,5,0,0,0,0,0,104,85,5,0,0,0,0,1,104,193,8,0,0,0,0,255,104,87,5,0,0,0,0,0,105,88,5,0,0,0,0,1,105,194,8,0,0,0,0,255,105,90,5,0,0,0,0,0,106,91,5,0,0,0,0,1,106,195,8,0,0,0,0,255,106,93,5,0,0,0,0,0,107,94,5,0,0,0,0,1,107,196,8,0,0,0,0,255,107,96,5,0,0,0,0,0,108,97,5,0,0,0,0,1,108,197,8,0,0,0,0,255,108,99,5,0,0,0,0,0,109,100,5,0,0,0,0,1,109,198,8,0,0,0,0,255,109,102,5,0,0,0,0,0,110,103,5,0,0,0,0,1,110,199,8,0,0,0,0,255,110,105,5,0,0,0,0,0,111,106,5,0,0,0,0,1,111,200,8,0,0,0,0,255,111,108,5,0,0,0,0,0,112,109,5,0,0,0,0,0,113,110,5,0,0,0,0,1,113,111,5,0,0,0,0,0,128,112,5,0,0,0,0,16,128,113,5,0,0,0,0,24,128,114,5,0,0,0,0,32,128,115,5,0,0,0,0,40,128,201,8,0,0,0,0,48,128,117,5,0,0,0,0,56,128,118,5,0,0,0,0,57,128,119,5,0,0,0,0,58,128,202,8,0,0,0,0,59,128,121,5,0,0,0,0,60,128,122,5,0,0,0,0,64,128,123,5,0,0,0,0,80,128,124,5,0,0,0,0,88,128,125,5,0,0,0,0,96,128,126,5,0,0,0,0,104,128,203,8,0,0,0,0,112,128,128,5,0,0,0,0,120,128,129,5,0,0,0,0,121,128,130,5,0,0,0,0,122,128,204,8,0,0,0,0,123,128,132,5,0,0,0,0,124,128,133,5,0,0,0,0,128,128,134,5,0,0,0,0,144,128,135,5,0,0,0,0,152,128,136,5,0,0,0,0,160,128,137,5,0,0,0,0,168,128,205,8,0,0,0,0,176,128,139,5,0,0,0,0,184,128,140,5,0,0,0,0,185,128,141,5,0,0,0,0,186,128,206,8,0,0,0,0,187,128,143,5,0,0,0,0,188,128,144,5,0,0,0,0,192,128,145,5,0,0,0,0,208,128,146,5,0,0,0,0,216,128,147,5,0,0,0,0,224,128,148,5,0,0,0,0,232,128,207,8,0,0,0,0,240,128,150,5,0,0,0,0,248,128,151,5,0,0,0,0,249,128,152,5,0,0,0,0,250,128,208,8,0,0,0,0,251,128,154,5,0,0,0,0,252,128,254,7,0,0,0,0,0,129,255,7,0,0,0,0,8,129,157,5,0,0,0,0,16,129,158,5,0,0,0,0,24,129,159,5,0,0,0,0,32,129,160,5,0,0,0,0,40,129,209,8,0,0,0,0,48,129,162,5,0,0,0,0,56,129,163,5,0,0,0,0,57,129,166,5,0,0,0,0,80,129,167,5,0,0,0,0,88,129,168,5,0,0,0,0,96,129,169,5,0,0,0,0,104,129,210,8,0,0,0,0,112,129,171,5,0,0,0,0,120,129,172,5,0,0,0,0,121,129,175,5,0,0,0,0,144,129,176,5,0,0,0,0,152,129,177,5,0,0,0,0,160,129,178,5,0,0,0,0,168,129,211,8,0,0,0,0,176,129,180,5,0,0,0,0,184,129,181,5,0,0,0,0,185,129,182,5,0,0,0,0,192,129,183,5,0,0,0,0,208,129,184,5,0,0,0,0,216,129,185,5,0,0,0,0,224,129,186,5,0,0,0,0,232,129,212,8,0,0,0,0,240,129,188,5,0,0,0,0,248,129,189,5,0,0,0,0,249,129,190,5,0,0,0,0,250,129,213,8,0,0,0,0,251,129,192,5,0,0,0,0,252,129,193,5,0,0,0,0,0,144,194,5,0,0,0,0,16,144,195,5,0,0,0,0,24,144,196,5,0,0,0,0,32,144,197,5,0,0,0,0,40,144,214,8,0,0,0,0,48,144,199,5,0,0,0,0,56,144,200,5,0,0,0,0,57,144,201,5,0,0,0,0,58,144,215,8,0,0,0,0,59,144,203,5,0,0,0,0,60,144,204,5,0,0,0,0,64,144,205,5,0,0,0,0,72,144,206,5,0,0,0,0,80,144,207,5,0,0,0,0,88,144,208,5,0,0,0,0,96,144,209,5,0,0,0,0,104,144,216,8,0,0,0,0,112,144,211,5,0,0,0,0,120,144,212,5,0,0,0,0,121,144,213,5,0,0,0,0,122,144,217,8,0,0,0,0,123,144,215,5,0,0,0,0,124,144,216,5,0,0,0,0,128,144,217,5,0,0,0,0,136,144,218,5,0,0,0,0,144,144,219,5,0,0,0,0,152,144,220,5,0,0,0,0,160,144,221,5,0,0,0,0,168,144,218,8,0,0,0,0,176,144,223,5,0,0,0,0,184,144,224,5,0,0,0,0,185,144,225,5,0,0,0,0,186,144,219,8,0,0,0,0,187,144,227,5,0,0,0,0,188,144,228,5,0,0,0,0,192,144,229,5,0,0,0,0,200,144,230,5,0,0,0,0,208,144,231,5,0,0,0,0,216,144,232,5,0,0,0,0,224,144,233,5,0,0,0,0,232,144,220,8,0,0,0,0,240,144,235,5,0,0,0,0,248,144,236,5,0,0,0,0,249,144,237,5,0,0,0,0,250,144,221,8,0,0,0,0,251,144,239,5,0,0,0,0,252,144,240,5,0,0,0,0,0,145,241,5,0,0,0,0,8,145,242,5,0,0,0,0,16,145,243,5,0,0,0,0,24,145,244,5,0,0,0,0,32,145,245,5,0,0,0,0,40,145,222,8,0,0,0,0,48,145,247,5,0,0,0,0,56,145,248,5,0,0,0,0,57,145,249,5,0,0,0,0,64,145,250,5,0,0,0,0,72,145,251,5,0,0,0,0,80,145,252,5,0,0,0,0,88,145,253,5,0,0,0,0,96,145,254,5,0,0,0,0,104,145,223,8,0,0,0,0,112,145,0,6,0,0,0,0,120,145,1,6,0,0,0,0,121,145,2,6,0,0,0,0,128,145,3,6,0,0,0,0,136,145,4,6,0,0,0,0,144,145,5,6,0,0,0,0,152,145,6,6,0,0,0,0,160,145,7,6,0,0,0,0,168,145,224,8,0,0,0,0,176,145,9,6,0,0,0,0,184,145,10,6,0,0,0,0,185,145,11,6,0,0,0,0,192,145,12,6,0,0,0,0,200,145,13,6,0,0,0,0,208,145,14,6,0,0,0,0,216,145,15,6,0,0,0,0,224,145,16,6,0,0,0,0,232,145,225,8,0,0,0,0,240,145,18,6,0,0,0,0,248,145,19,6,0,0,0,0,249,145,20,6,0,0,0,0,250,145,226,8,0,0,0,0,251,145,22,6,0,0,0,0,252,145,23,6,0,0,0,0,0,176,24,6,0,0,0,0,16,176,25,6,0,0,0,0,24,176,26,6,0,0,0,0,32,176,27,6,0,0,0,0,40,176,227,8,0,0,0,0,48,176,29,6,0,0,0,0,56,176,30,6,0,0,0,0,57,176,31,6,0,0,0,0,58,176,228,8,0,0,0,0,59,176,33,6,0,0,0,0,60,176,34,6,0,0,0,0,64,176,35,6,0,0,0,0,72,176,36,6,0,0,0,0,80,176,37,6,0,0,0,0,88,176,38,6,0,0,0,0,96,176,39,6,0,0,0,0,104,176,229,8,0,0,0,0,112,176,41,6,0,0,0,0,120,176,42,6,0,0,0,0,121,176,43,6,0,0,0,0,122,176,230,8,0,0,0,0,123,176,45,6,0,0,0,0,124,176,46,6,0,0,0,0,128,176,47,6,0,0,0,0,136,176,48,6,0,0,0,0,144,176,49,6,0,0,0,0,152,176,50,6,0,0,0,0,160,176,51,6,0,0,0,0,168,176,231,8,0,0,0,0,176,176,53,6,0,0,0,0,184,176,54,6,0,0,0,0,185,176,55,6,0,0,0,0,186,176,232,8,0,0,0,0,187,176,57,6,0,0,0,0,188,176,58,6,0,0,0,0,192,176,59,6,0,0,0,0,200,176,60,6,0,0,0,0,208,176,61,6,0,0,0,0,216,176,62,6,0,0,0,0,224,176,63,6,0,0,0,0,232,176,233,8,0,0,0,0,240,176,65,6,0,0,0,0,248,176,66,6,0,0,0,0,249,176,67,6,0,0,0,0,250,176,234,8,0,0,0,0,251,176,69,6,0,0,0,0,252,176,70,6,0,0,0,0,0,177,71,6,0,0,0,0,8,177,72,6,0,0,0,0,16,177,73,6,0,0,0,0,24,177,74,6,0,0,0,0,32,177,75,6,0,0,0,0,40,177,235,8,0,0,0,0,48,177,77,6,0,0,0,0,56,177,78,6,0,0,0,0,57,177,79,6,0,0,0,0,64,177,80,6,0,0,0,0,72,177,81,6,0,0,0,0,80,177,82,6,0,0,0,0,88,177,83,6,0,0,0,0,96,177,84,6,0,0,0,0,104,177,236,8,0,0,0,0,112,177,86,6,0,0,0,0,120,177,87,6,0,0,0,0,121,177,88,6,0,0,0,0,128,177,89,6,0,0,0,0,136,177,90,6,0,0,0,0,144,177,91,6,0,0,0,0,152,177,92,6,0,0,0,0,160,177,93,6,0,0,0,0,168,177,237,8,0,0,0,0,176,177,95,6,0,0,0,0,184,177,96,6,0,0,0,0,185,177,97,6,0,0,0,0,192,177,98,6,0,0,0,0,200,177,99,6,0,0,0,0,208,177,100,6,0,0,0,0,216,177,101,6,0,0,0,0,224,177,102,6,0,0,0,0,232,177,238,8,0,0,0,0,240,177,104,6,0,0,0,0,248,177,105,6,0,0,0,0,249,177,106,6,0,0,0,0,250,177,239,8,0,0,0,0,251,177,108,6,0,0,0,0,252,177,109,6,0,0,0,0,0,192,110,6,0,0,0,0,16,192,111,6,0,0,0,0,24,192,112,6,0,0,0,0,32,192,113,6,0,0,0,0,40,192,240,8,0,0,0,0,48,192,115,6,0,0,0,0,56,192,116,6,0,0,0,0,57,192,117,6,0,0,0,0,58,192,241,8,0,0,0,0,59,192,119,6,0,0,0,0,60,192,120,6,0,0,0,0,64,192,121,6,0,0,0,0,80,192,122,6,0,0,0,0,88,192,123,6,0,0,0,0,96,192,124,6,0,0,0,0,104,192,242,8,0,0,0,0,112,192,126,6,0,0,0,0,120,192,127,6,0,0,0,0,121,192,128,6,0,0,0,0,122,192,243,8,0,0,0,0,123,192,130,6,0,0,0,0,124,192,131,6,0,0,0,0,128,192,132,6,0,0,0,0,144,192,133,6,0,0,0,0,152,192,134,6,0,0,0,0,160,192,135,6,0,0,0,0,168,192,244,8,0,0,0,0,176,192,137,6,0,0,0,0,184,192,138,6,0,0,0,0,185,192,139,6,0,0,0,0,186,192,245,8,0,0,0,0,187,192,141,6,0,0,0,0,188,192,142,6,0,0,0,0,192,192,143,6,0,0,0,0,208,192,144,6,0,0,0,0,216,192,145,6,0,0,0,0,224,192,146,6,0,0,0,0,232,192,246,8,0,0,0,0,240,192,148,6,0,0,0,0,248,192,149,6,0,0,0,0,249,192,150,6,0,0,0,0,250,192,247,8,0,0,0,0,251,192,152,6,0,0,0,0,252,192,0,8,0,0,0,0,0,193,1,8,0,0,0,0,8,193,155,6,0,0,0,0,16,193,156,6,0,0,0,0,24,193,157,6,0,0,0,0,32,193,158,6,0,0,0,0,40,193,248,8,0,0,0,0,48,193,160,6,0,0,0,0,56,193,161,6,0,0,0,0,57,193,162,6,0,0,0,0,64,193,163,6,0,0,0,0,72,193,164,6,0,0,0,0,80,193,165,6,0,0,0,0,88,193,166,6,0,0,0,0,96,193,167,6,0,0,0,0,104,193,249,8,0,0,0,0,112,193,169,6,0,0,0,0,120,193,170,6,0,0,0,0,121,193,171,6,0,0,0,0,136,193,172,6,0,0,0,0,144,193,173,6,0,0,0,0,152,193,174,6,0,0,0,0,160,193,175,6,0,0,0,0,168,193,250,8,0,0,0,0,176,193,177,6,0,0,0,0,184,193,178,6,0,0,0,0,185,193,179,6,0,0,0,0,192,193,180,6,0,0,0,0,208,193,181,6,0,0,0,0,216,193,182,6,0,0,0,0,224,193,183,6,0,0,0,0,232,193,251,8,0,0,0,0,240,193,185,6,0,0,0,0,248,193,186,6,0,0,0,0,249,193,187,6,0,0,0,0,250,193,252,8,0,0,0,0,251,193,189,6,0,0,0,0,252,193,190,6,0,0,0,0,0,208,191,6,0,0,0,0,16,208,192,6,0,0,0,0,24,208,193,6,0,0,0,0,32,208,194,6,0,0,0,0,40,208,253,8,0,0,0,0,48,208,196,6,0,0,0,0,56,208,197,6,0,0,0,0,57,208,198,6,0,0,0,0,58,208,254,8,0,0,0,0,59,208,200,6,0,0,0,0,60,208,201,6,0,0,0,0,64,208,202,6,0,0,0,0,72,208,203,6,0,0,0,0,80,208,204,6,0,0,0,0,88,208,205,6,0,0,0,0,96,208,206,6,0,0,0,0,104,208,255,8,0,0,0,0,112,208,208,6,0,0,0,0,120,208,209,6,0,0,0,0,121,208,210,6,0,0,0,0,122,208,0,9,0,0,0,0,123,208,212,6,0,0,0,0,124,208,213,6,0,0,0,0,128,208,214,6,0,0,0,0,136,208,215,6,0,0,0,0,144,208,216,6,0,0,0,0,152,208,217,6,0,0,0,0,160,208,218,6,0,0,0,0,168,208,1,9,0,0,0,0,176,208,220,6,0,0,0,0,184,208,221,6,0,0,0,0,185,208,222,6,0,0,0,0,186,208,2,9,0,0,0,0,187,208,224,6,0,0,0,0,188,208,225,6,0,0,0,0,192,208,226,6,0,0,0,0,200,208,227,6,0,0,0,0,208,208,228,6,0,0,0,0,216,208,229,6,0,0,0,0,224,208,230,6,0,0,0,0,232,208,3,9,0,0,0,0,240,208,232,6,0,0,0,0,248,208,233,6,0,0,0,0,249,208,234,6,0,0,0,0,250,208,4,9,0,0,0,0,251,208,236,6,0,0,0,0,252,208,237,6,0,0,0,0,0,209,238,6,0,0,0,0,8,209,239,6,0,0,0,0,16,209,240,6,0,0,0,0,24,209,241,6,0,0,0,0,32,209,242,6,0,0,0,0,40,209,5,9,0,0,0,0,48,209,244,6,0,0,0,0,56,209,245,6,0,0,0,0,57,209,246,6,0,0,0,0,64,209,247,6,0,0,0,0,72,209,248,6,0,0,0,0,80,209,249,6,0,0,0,0,88,209,250,6,0,0,0,0,96,209,251,6,0,0,0,0,104,209,6,9,0,0,0,0,112,209,253,6,0,0,0,0,120,209,254,6,0,0,0,0,121,209,255,6,0,0,0,0,128,209,0,7,0,0,0,0,136,209,1,7,0,0,0,0,144,209,2,7,0,0,0,0,152,209,3,7,0,0,0,0,160,209,4,7,0,0,0,0,168,209,7,9,0,0,0,0,176,209,6,7,0,0,0,0,184,209,7,7,0,0,0,0,185,209,8,7,0,0,0,0,192,209,9,7,0,0,0,0,200,209,10,7,0,0,0,0,208,209,11,7,0,0,0,0,216,209,12,7,0,0,0,0,224,209,13,7,0,0,0,0,232,209,8,9,0,0,0,0,240,209,15,7,0,0,0,0,248,209,16,7,0,0,0,0,249,209,17,7,0,0,0,0,250,209,9,9,0,0,0,0,251,209,19,7,0,0,0,0,252,209,20,7,0,0,0,0,0,224,21,7,0,0,0,0,8,224,22,7,0,0,0,0,16,224,23,7,0,0,0,0,24,224,24,7,0,0,0,0,32,224,25,7,0,0,0,0,40,224,26,7,0,0,0,0,48,224,27,7,0,0,0,0,56,224,28,7,0,0,0,0,64,224,29,7,0,0,0,0,72,224,30,7,0,0,0,0,80,224,31,7,0,0,0,0,88,224,32,7,0,0,0,0,96,224,33,7,0,0,0,0,104,224,34,7,0,0,0,0,112,224,35,7,0,0,0,0,120,224,36,7,0,0,0,0,128,224,37,7,0,0,0,0,136,224,38,7,0,0,0,0,144,224,39,7,0,0,0,0,152,224,40,7,0,0,0,0,160,224,41,7,0,0,0,0,168,224,42,7,0,0,0,0,176,224,43,7,0,0,0,0,184,224,44,7,0,0,0,0,208,224,45,7,0,0,0,0,216,224,46,7,0,0,0,0,224,224,47,7,0,0,0,0,232,224,10,9,0,0,0,0,240,224,49,7,0,0,0,0,248,224,50,7,0,0,0,0,249,224,51,7,0,0,0,0,0,225,52,7,0,0,0,0,8,225,53,7,0,0,0,0,16,225,54,7,0,0,0,0,24,225,55,7,0,0,0,0,32,225,56,7,0,0,0,0,40,225,57,7,0,0,0,0,48,225,58,7,0,0,0,0,56,225,59,7,0,0,0,0,64,225,60,7,0,0,0,0,72,225,61,7,0,0,0,0,80,225,62,7,0,0,0,0,88,225,63,7,0,0,0,0,96,225,64,7,0,0,0,0,104,225,65,7,0,0,0,0,112,225,66,7,0,0,0,0,120,225,67,7,0,0,0,0,128,225,68,7,0,0,0,0,136,225,69,7,0,0,0,0,144,225,70,7,0,0,0,0,152,225,71,7,0,0,0,0,160,225,72,7,0,0,0,0,168,225,73,7,0,0,0,0,176,225,74,7,0,0,0,0,184,225,75,7,0,0,0,0,208,225,76,7,0,0,0,0,216,225,77,7,0,0,0,0,224,225,78,7,0,0,0,0,232,225,11,9,0,0,0,0,240,225,80,7,0,0,0,0,248,225,81,7,0,0,0,0,249,225,82,7,0,0,0,0,208,226,83,7,0,0,0,0,216,226,84,7,0,0,0,0,224,226,85,7,0,0,0,0,232,226,12,9,0,0,0,0,240,226,87,7,0,0,0,0,248,226,88,7,0,0,0,0,249,226,89,7,0,0,0,0,208,227,90,7,0,0,0,0,216,227,91,7,0,0,0,0,224,227,92,7,0,0,0,0,232,227,13,9,0,0,0,0,240,227,94,7,0,0,0,0,248,227,95,7,0,0,0,0,249,227,96,7,0,0,0,0,208,228,97,7,0,0,0,0,216,228,98,7,0,0,0,0,224,228,99,7,0,0,0,0,232,228,14,9,0,0,0,0,240,228,101,7,0,0,0,0,248,228,102,7,0,0,0,0,249,228,103,7,0,0,0,0,208,229,104,7,0,0,0,0,216,229,105,7,0,0,0,0,224,229,106,7,0,0,0,0,232,229,15,9,0,0,0,0,240,229,108,7,0,0,0,0,248,229,109,7,0,0,0,0,249,229,110,7,0,0,0,0,208,230,111,7,0,0,0,0,216,230,112,7,0,0,0,0,224,230,113,7,0,0,0,0,232,230,16,9,0,0,0,0,240,230,115,7,0,0,0,0,248,230,116,7,0,0,0,0,249,230,117,7,0,0,0,0,208,231,118,7,0,0,0,0,216,231,119,7,0,0,0,0,224,231,120,7,0,0,0,0,232,231,17,9,0,0,0,0,240,231,122,7,0,0,0,0,248,231,123,7,0,0,0,0,249,231,0,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,171,0,0,0,0,0,16,0,172,0,0,0,0,0,24,0,173,0,0,0,0,0,32,0,174,0,0,0,0,0,40,0,2,8,0,0,0,0,48,0,176,0,0,0,0,0,56,0,177,0,0,0,0,0,57,0,178,0,0,0,0,0,60,0,179,0,0,0,0,0,64,0,180,0,0,0,0,0,80,0,181,0,0,0,0,0,88,0,182,0,0,0,0,0,96,0,183,0,0,0,0,0,104,0,3,8,0,0,0,0,112,0,185,0,0,0,0,0,120,0,186,0,0,0,0,0,121,0,187,0,0,0,0,0,124,0,188,0,0,0,0,0,128,0,189,0,0,0,0,0,144,0,190,0,0,0,0,0,152,0,191,0,0,0,0,0,160,0,192,0,0,0,0,0,168,0,4,8,0,0,0,0,176,0,194,0,0,0,0,0,184,0,195,0,0,0,0,0,185,0,203,0,0,0,0,0,0,1,204,0,0,0,0,0,8,1,205,0,0,0,0,0,16,1,206,0,0,0,0,0,24,1,207,0,0,0,0,0,32,1,208,0,0,0,0,0,40,1,5,8,0,0,0,0,48,1,210,0,0,0,0,0,56,1,211,0,0,0,0,0,57,1,212,0,0,0,0,0,58,1,6,8,0,0,0,0,59,1,214,0,0,0,0,0,60,1,215,0,0,0,0,0,64,1,216,0,0,0,0,0,72,1,217,0,0,0,0,0,80,1,218,0,0,0,0,0,88,1,219,0,0,0,0,0,96,1,220,0,0,0,0,0,104,1,7,8,0,0,0,0,112,1,222,0,0,0,0,0,120,1,223,0,0,0,0,0,121,1,224,0,0,0,0,0,122,1,8,8,0,0,0,0,123,1,226,0,0,0,0,0,128,1,227,0,0,0,0,0,136,1,228,0,0,0,0,0,144,1,229,0,0,0,0,0,152,1,230,0,0,0,0,0,160,1,231,0,0,0,0,0,168,1,9,8,0,0,0,0,176,1,233,0,0,0,0,0,184,1,234,0,0,0,0,0,185,1,235,0,0,0,0,0,186,1,10,8,0,0,0,0,187,1,237,0,0,0,0,0,192,1,238,0,0,0,0,0,200,1,239,0,0,0,0,0,208,1,240,0,0,0,0,0,216,1,241,0,0,0,0,0,224,1,242,0,0,0,0,0,232,1,11,8,0,0,0,0,240,1,244,0,0,0,0,0,248,1,245,0,0,0,0,0,249,1,246,0,0,0,0,0,250,1,12,8,0,0,0,0,251,1,248,0,0,0,0,0,0,2,249,0,0,0,0,0,16,2,250,0,0,0,0,0,24,2,251,0,0,0,0,0,32,2,252,0,0,0,0,0,40,2,13,8,0,0,0,0,48,2,254,0,0,0,0,0,56,2,255,0,0,0,0,0,57,2,0,1,0,0,0,0,60,2,1,1,0,0,0,0,64,2,2,1,0,0,0,0,80,2,3,1,0,0,0,0,88,2,4,1,0,0,0,0,96,2,5,1,0,0,0,0,104,2,14,8,0,0,0,0,112,2,7,1,0,0,0,0,120,2,8,1,0,0,0,0,121,2,9,1,0,0,0,0,124,2,10,1,0,0,0,0,128,2,11,1,0,0,0,0,144,2,12,1,0,0,0,0,152,2,13,1,0,0,0,0,160,2,14,1,0,0,0,0,168,2,15,8,0,0,0,0,176,2,16,1,0,0,0,0,184,2,17,1,0,0,0,0,185,2,25,1,0,0,0,0,0,4,26,1,0,0,0,0,16,4,27,1,0,0,0,0,24,4,28,1,0,0,0,0,32,4,29,1,0,0,0,0,40,4,16,8,0,0,0,0,48,4,31,1,0,0,0,0,56,4,32,1,0,0,0,0,57,4,33,1,0,0,0,0,64,4,34,1,0,0,0,0,80,4,35,1,0,0,0,0,88,4,36,1,0,0,0,0,96,4,37,1,0,0,0,0,104,4,17,8,0,0,0,0,112,4,39,1,0,0,0,0,120,4,40,1,0,0,0,0,121,4,41,1,0,0,0,0,128,4,42,1,0,0,0,0,144,4,43,1,0,0,0,0,152,4,44,1,0,0,0,0,160,4,45,1,0,0,0,0,168,4,18,8,0,0,0,0,176,4,47,1,0,0,0,0,184,4,48,1,0,0,0,0,185,4,56,1,0,0,0,0,0,6,57,1,0,0,0,0,16,6,58,1,0,0,0,0,24,6,59,1,0,0,0,0,32,6,60,1,0,0,0,0,40,6,19,8,0,0,0,0,48,6,62,1,0,0,0,0,56,6,63,1,0,0,0,0,57,6,64,1,0,0,0,0,64,6,65,1,0,0,0,0,80,6,66,1,0,0,0,0,88,6,67,1,0,0,0,0,96,6,68,1,0,0,0,0,104,6,20,8,0,0,0,0,112,6,70,1,0,0,0,0,120,6,71,1,0,0,0,0,121,6,72,1,0,0,0,0,128,6,73,1,0,0,0,0,144,6,74,1,0,0,0,0,152,6,75,1,0,0,0,0,160,6,76,1,0,0,0,0,168,6,21,8,0,0,0,0,176,6,78,1,0,0,0,0,184,6,79,1,0,0,0,0,185,6,89,1,0,0,0,0,0,8,90,1,0,0,0,0,16,8,91,1,0,0,0,0,24,8,92,1,0,0,0,0,32,8,93,1,0,0,0,0,40,8,22,8,0,0,0,0,48,8,95,1,0,0,0,0,56,8,96,1,0,0,0,0,57,8,97,1,0,0,0,0,58,8,23,8,0,0,0,0,59,8,99,1,0,0,0,0,60,8,100,1,0,0,0,0,64,8,101,1,0,0,0,0,80,8,102,1,0,0,0,0,88,8,103,1,0,0,0,0,96,8,104,1,0,0,0,0,104,8,24,8,0,0,0,0,112,8,106,1,0,0,0,0,120,8,107,1,0,0,0,0,121,8,108,1,0,0,0,0,122,8,25,8,0,0,0,0,123,8,110,1,0,0,0,0,128,8,111,1,0,0,0,0,144,8,112,1,0,0,0,0,152,8,113,1,0,0,0,0,160,8,114,1,0,0,0,0,168,8,26,8,0,0,0,0,176,8,116,1,0,0,0,0,184,8,117,1,0,0,0,0,185,8,118,1,0,0,0,0,186,8,27,8,0,0,0,0,187,8,120,1,0,0,0,0,192,8,121,1,0,0,0,0,208,8,122,1,0,0,0,0,216,8,123,1,0,0,0,0,224,8,124,1,0,0,0,0,232,8,28,8,0,0,0,0,240,8,126,1,0,0,0,0,248,8,127,1,0,0,0,0,249,8,128,1,0,0,0,0,250,8,29,8,0,0,0,0,251,8,130,1,0,0,0,0,0,10,131,1,0,0,0,0,16,10,132,1,0,0,0,0,24,10,133,1,0,0,0,0,32,10,134,1,0,0,0,0,40,10,30,8,0,0,0,0,48,10,136,1,0,0,0,0,56,10,137,1,0,0,0,0,57,10,138,1,0,0,0,0,60,10,139,1,0,0,0,0,64,10,140,1,0,0,0,0,80,10,141,1,0,0,0,0,88,10,142,1,0,0,0,0,96,10,143,1,0,0,0,0,104,10,31,8,0,0,0,0,112,10,145,1,0,0,0,0,120,10,146,1,0,0,0,0,121,10,147,1,0,0,0,0,124,10,148,1,0,0,0,0,128,10,149,1,0,0,0,0,144,10,150,1,0,0,0,0,152,10,151,1,0,0,0,0,160,10,152,1,0,0,0,0,168,10,32,8,0,0,0,0,176,10,154,1,0,0,0,0,184,10,155,1,0,0,0,0,185,10,163,1,0,0,0,0,0,12,164,1,0,0,0,0,16,12,165,1,0,0,0,0,24,12,166,1,0,0,0,0,32,12,167,1,0,0,0,0,40,12,33,8,0,0,0,0,48,12,169,1,0,0,0,0,56,12,170,1,0,0,0,0,57,12,171,1,0,0,0,0,58,12,34,8,0,0,0,0,59,12,173,1,0,0,0,0,64,12,174,1,0,0,0,0,80,12,175,1,0,0,0,0,88,12,176,1,0,0,0,0,96,12,177,1,0,0,0,0,104,12,35,8,0,0,0,0,112,12,179,1,0,0,0,0,120,12,180,1,0,0,0,0,121,12,181,1,0,0,0,0,122,12,36,8,0,0,0,0,123,12,183,1,0,0,0,0,128,12,184,1,0,0,0,0,144,12,185,1,0,0,0,0,152,12,186,1,0,0,0,0,160,12,187,1,0,0,0,0,168,12,37,8,0,0,0,0,176,12,189,1,0,0,0,0,184,12,190,1,0,0,0,0,185,12,191,1,0,0,0,0,186,12,38,8,0,0,0,0,187,12,230,1,0,0,0,0,0,16,231,1,0,0,0,0,16,16,232,1,0,0,0,0,24,16,233,1,0,0,0,0,32,16,234,1,0,0,0,0,40,16,39,8,0,0,0,0,48,16,236,1,0,0,0,0,56,16,237,1,0,0,0,0,57,16,238,1,0,0,0,0,58,16,40,8,0,0,0,0,59,16,240,1,0,0,0,0,60,16,241,1,0,0,0,0,128,16,242,1,0,0,0,0,144,16,243,1,0,0,0,0,152,16,244,1,0,0,0,0,160,16,245,1,0,0,0,0,168,16,41,8,0,0,0,0,176,16,247,1,0,0,0,0,184,16,248,1,0,0,0,0,185,16,249,1,0,0,0,0,186,16,42,8,0,0,0,0,187,16,251,1,0,0,0,0,188,16,252,1,0,0,0,0,192,16,253,1,0,0,0,0,208,16,254,1,0,0,0,0,216,16,255,1,0,0,0,0,224,16,0,2,0,0,0,0,232,16,43,8,0,0,0,0,240,16,2,2,0,0,0,0,248,16,3,2,0,0,0,0,249,16,4,2,0,0,0,0,250,16,44,8,0,0,0,0,251,16,6,2,0,0,0,0,252,16,7,2,0,0,0,0,0,17,8,2,0,0,0,0,16,17,9,2,0,0,0,0,24,17,10,2,0,0,0,0,32,17,11,2,0,0,0,0,40,17,45,8,0,0,0,0,48,17,13,2,0,0,0,0,56,17,14,2,0,0,0,0,57,17,15,2,0,0,0,0,58,17,46,8,0,0,0,0,59,17,17,2,0,0,0,0,60,17,18,2,0,0,0,0,64,17,19,2,0,0,0,0,80,17,20,2,0,0,0,0,88,17,21,2,0,0,0,0,96,17,22,2,0,0,0,0,104,17,47,8,0,0,0,0,112,17,24,2,0,0,0,0,120,17,25,2,0,0,0,0,121,17,26,2,0,0,0,0,122,17,48,8,0,0,0,0,123,17,28,2,0,0,0,0,124,17,49,8,0,0,0,0,128,17,50,8,0,0,0,0,144,17,51,8,0,0,0,0,152,17,52,8,0,0,0,0,160,17,53,8,0,0,0,0,168,17,54,8,0,0,0,0,176,17,55,8,0,0,0,0,184,17,56,8,0,0,0,0,185,17,57,8,0,0,0,0,186,17,58,8,0,0,0,0,187,17,59,8,0,0,0,0,188,17,40,2,0,0,0,0,192,17,41,2,0,0,0,0,208,17,42,2,0,0,0,0,216,17,43,2,0,0,0,0,224,17,44,2,0,0,0,0,232,17,60,8,0,0,0,0,240,17,46,2,0,0,0,0,248,17,47,2,0,0,0,0,249,17,48,2,0,0,0,0,250,17,61,8,0,0,0,0,251,17,50,2,0,0,0,0,252,17,51,2,0,0,0,0,192,19,52,2,0,0,0,0,208,19,53,2,0,0,0,0,216,19,54,2,0,0,0,0,224,19,55,2,0,0,0,0,232,19,62,8,0,0,0,0,240,19,57,2,0,0,0,0,248,19,58,2,0,0,0,0,249,19,59,2,0,0,0,0,250,19,63,8,0,0,0,0,251,19,61,2,0,0,0,0,252,19,62,2,0,0,0,0,0,32,63,2,0,0,0,0,8,32,64,2,0,0,0,0,16,32,65,2,0,0,0,0,24,32,66,2,0,0,0,0,32,32,67,2,0,0,0,0,40,32,64,8,0,0,0,0,48,32,69,2,0,0,0,0,56,32,70,2,0,0,0,0,57,32,71,2,0,0,0,0,58,32,65,8,0,0,0,0,59,32,73,2,0,0,0,0,60,32,74,2,0,0,0,0,64,32,75,2,0,0,0,0,72,32,76,2,0,0,0,0,80,32,77,2,0,0,0,0,88,32,78,2,0,0,0,0,96,32,79,2,0,0,0,0,104,32,66,8,0,0,0,0,112,32,81,2,0,0,0,0,120,32,82,2,0,0,0,0,121,32,83,2,0,0,0,0,122,32,67,8,0,0,0,0,123,32,85,2,0,0,0,0,124,32,86,2,0,0,0,0,128,32,87,2,0,0,0,0,136,32,88,2,0,0,0,0,144,32,89,2,0,0,0,0,152,32,90,2,0,0,0,0,160,32,91,2,0,0,0,0,168,32,68,8,0,0,0,0,176,32,93,2,0,0,0,0,184,32,94,2,0,0,0,0,185,32,95,2,0,0,0,0,186,32,69,8,0,0,0,0,187,32,97,2,0,0,0,0,188,32,98,2,0,0,0,0,192,32,99,2,0,0,0,0,200,32,100,2,0,0,0,0,208,32,101,2,0,0,0,0,216,32,102,2,0,0,0,0,224,32,103,2,0,0,0,0,232,32,70,8,0,0,0,0,240,32,105,2,0,0,0,0,248,32,106,2,0,0,0,0,249,32,107,2,0,0,0,0,250,32,71,8,0,0,0,0,251,32,109,2,0,0,0,0,252,32,110,2,0,0,0,0,0,33,111,2,0,0,0,0,8,33,112,2,0,0,0,0,16,33,113,2,0,0,0,0,24,33,114,2,0,0,0,0,32,33,115,2,0,0,0,0,40,33,72,8,0,0,0,0,48,33,117,2,0,0,0,0,56,33,118,2,0,0,0,0,57,33,119,2,0,0,0,0,58,33,73,8,0,0,0,0,59,33,121,2,0,0,0,0,60,33,122,2,0,0,0,0,64,33,123,2,0,0,0,0,72,33,124,2,0,0,0,0,80,33,125,2,0,0,0,0,88,33,126,2,0,0,0,0,96,33,127,2,0,0,0,0,104,33,74,8,0,0,0,0,112,33,129,2,0,0,0,0,120,33,130,2,0,0,0,0,121,33,131,2,0,0,0,0,122,33,75,8,0,0,0,0,123,33,133,2,0,0,0,0,124,33,76,8,0,0,0,0,128,33,77,8,0,0,0,0,136,33,78,8,0,0,0,0,144,33,79,8,0,0,0,0,152,33,80,8,0,0,0,0,160,33,81,8,0,0,0,0,168,33,82,8,0,0,0,0,176,33,83,8,0,0,0,0,184,33,84,8,0,0,0,0,185,33,85,8,0,0,0,0,186,33,86,8,0,0,0,0,187,33,87,8,0,0,0,0,188,33,146,2,0,0,0,0,192,33,147,2,0,0,0,0,200,33,148,2,0,0,0,0,208,33,149,2,0,0,0,0,216,33,150,2,0,0,0,0,224,33,151,2,0,0,0,0,232,33,88,8,0,0,0,0,240,33,153,2,0,0,0,0,248,33,154,2,0,0,0,0,249,33,155,2,0,0,0,0,250,33,89,8,0,0,0,0,251,33,157,2,0,0,0,0,252,33,158,2,0,0,0,0,192,35,159,2,0,0,0,0,200,35,160,2,0,0,0,0,208,35,161,2,0,0,0,0,216,35,162,2,0,0,0,0,224,35,163,2,0,0,0,0,232,35,90,8,0,0,0,0,240,35,165,2,0,0,0,0,248,35,166,2,0,0,0,0,249,35,167,2,0,0,0,0,250,35,91,8,0,0,0,0,251,35,169,2,0,0,0,0,252,35,170,2,0,0,0,0,0,48,171,2,0,0,0,0,8,48,172,2,0,0,0,0,16,48,173,2,0,0,0,0,24,48,174,2,0,0,0,0,32,48,175,2,0,0,0,0,40,48,92,8,0,0,0,0,48,48,177,2,0,0,0,0,56,48,178,2,0,0,0,0,57,48,179,2,0,0,0,0,58,48,93,8,0,0,0,0,59,48,181,2,0,0,0,0,60,48,182,2,0,0,0,0,64,48,183,2,0,0,0,0,72,48,184,2,0,0,0,0,80,48,185,2,0,0,0,0,88,48,186,2,0,0,0,0,96,48,187,2,0,0,0,0,104,48,94,8,0,0,0,0,112,48,189,2,0,0,0,0,120,48,190,2,0,0,0,0,121,48,191,2,0,0,0,0,122,48,95,8,0,0,0,0,123,48,193,2,0,0,0,0,124,48,194,2,0,0,0,0,128,48,195,2,0,0,0,0,136,48,196,2,0,0,0,0,144,48,197,2,0,0,0,0,152,48,198,2,0,0,0,0,160,48,199,2,0,0,0,0,168,48,96,8,0,0,0,0,176,48,201,2,0,0,0,0,184,48,202,2,0,0,0,0,185,48,203,2,0,0,0,0,186,48,97,8,0,0,0,0,187,48,205,2,0,0,0,0,188,48,206,2,0,0,0,0,192,48,207,2,0,0,0,0,200,48,208,2,0,0,0,0,208,48,209,2,0,0,0,0,216,48,210,2,0,0,0,0,224,48,211,2,0,0,0,0,232,48,98,8,0,0,0,0,240,48,213,2,0,0,0,0,248,48,214,2,0,0,0,0,249,48,215,2,0,0,0,0,250,48,99,8,0,0,0,0,251,48,217,2,0,0,0,0,252,48,218,2,0,0,0,0,0,49,219,2,0,0,0,0,8,49,220,2,0,0,0,0,16,49,221,2,0,0,0,0,24,49,222,2,0,0,0,0,32,49,223,2,0,0,0,0,40,49,100,8,0,0,0,0,48,49,225,2,0,0,0,0,56,49,226,2,0,0,0,0,57,49,227,2,0,0,0,0,58,49,101,8,0,0,0,0,59,49,229,2,0,0,0,0,60,49,230,2,0,0,0,0,64,49,231,2,0,0,0,0,72,49,232,2,0,0,0,0,80,49,233,2,0,0,0,0,88,49,234,2,0,0,0,0,96,49,235,2,0,0,0,0,104,49,102,8,0,0,0,0,112,49,237,2,0,0,0,0,120,49,238,2,0,0,0,0,121,49,239,2,0,0,0,0,122,49,103,8,0,0,0,0,123,49,241,2,0,0,0,0,124,49,104,8,0,0,0,0,128,49,105,8,0,0,0,0,136,49,106,8,0,0,0,0,144,49,107,8,0,0,0,0,152,49,108,8,0,0,0,0,160,49,109,8,0,0,0,0,168,49,110,8,0,0,0,0,176,49,111,8,0,0,0,0,184,49,112,8,0,0,0,0,185,49,113,8,0,0,0,0,186,49,114,8,0,0,0,0,187,49,115,8,0,0,0,0,188,49,254,2,0,0,0,0,192,49,255,2,0,0,0,0,200,49,0,3,0,0,0,0,208,49,1,3,0,0,0,0,216,49,2,3,0,0,0,0,224,49,3,3,0,0,0,0,232,49,116,8,0,0,0,0,240,49,5,3,0,0,0,0,248,49,6,3,0,0,0,0,249,49,7,3,0,0,0,0,250,49,117,8,0,0,0,0,251,49,9,3,0,0,0,0,252,49,10,3,0,0,0,0,192,51,11,3,0,0,0,0,200,51,12,3,0,0,0,0,208,51,13,3,0,0,0,0,216,51,14,3,0,0,0,0,224,51,15,3,0,0,0,0,232,51,118,8,0,0,0,0,240,51,17,3,0,0,0,0,248,51,18,3,0,0,0,0,249,51,19,3,0,0,0,0,250,51,119,8,0,0,0,0,251,51,21,3,0,0,0,0,252,51,22,3,0,0,0,0,0,64,23,3,0,0,0,0,16,64,24,3,0,0,0,0,24,64,25,3,0,0,0,0,32,64,26,3,0,0,0,0,40,64,120,8,0,0,0,0,48,64,28,3,0,0,0,0,56,64,29,3,0,0,0,0,57,64,30,3,0,0,0,0,64,64,31,3,0,0,0,0,80,64,32,3,0,0,0,0,88,64,33,3,0,0,0,0,96,64,34,3,0,0,0,0,104,64,121,8,0,0,0,0,112,64,36,3,0,0,0,0,120,64,37,3,0,0,0,0,121,64,38,3,0,0,0,0,128,64,39,3,0,0,0,0,144,64,40,3,0,0,0,0,152,64,41,3,0,0,0,0,160,64,42,3,0,0,0,0,168,64,122,8,0,0,0,0,176,64,44,3,0,0,0,0,184,64,45,3,0,0,0,0,185,64,18,9,0,0,0,0,192,64,19,9,0,0,0,0,208,64,20,9,0,0,0,0,216,64,21,9,0,0,0,0,224,64,22,9,0,0,0,0,232,64,23,9,0,0,0,0,240,64,24,9,0,0,0,0,248,64,25,9,0,0,0,0,249,64,54,3,0,0,0,0,0,65,55,3,0,0,0,0,16,65,56,3,0,0,0,0,24,65,57,3,0,0,0,0,32,65,58,3,0,0,0,0,40,65,124,8,0,0,0,0,48,65,60,3,0,0,0,0,56,65,61,3,0,0,0,0,57,65,62,3,0,0,0,0,58,65,125,8,0,0,0,0,59,65,64,3,0,0,0,0,60,65,65,3,0,0,0,0,128,65,66,3,0,0,0,0,144,65,67,3,0,0,0,0,152,65,68,3,0,0,0,0,160,65,69,3,0,0,0,0,168,65,126,8,0,0,0,0,176,65,71,3,0,0,0,0,184,65,72,3,0,0,0,0,185,65,73,3,0,0,0,0,186,65,127,8,0,0,0,0,187,65,75,3,0,0,0,0,188,65,76,3,0,0,0,0,208,65,77,3,0,0,0,0,232,65,128,8,0,0,0,0,240,65,79,3,0,0,0,0,248,65,80,3,0,0,0,0,249,65,81,3,0,0,0,0,250,65,129,8,0,0,0,0,251,65,83,3,0,0,0,0,0,66,84,3,0,0,0,0,16,66,85,3,0,0,0,0,24,66,86,3,0,0,0,0,32,66,87,3,0,0,0,0,40,66,130,8,0,0,0,0,48,66,89,3,0,0,0,0,56,66,90,3,0,0,0,0,57,66,91,3,0,0,0,0,64,66,92,3,0,0,0,0,80,66,93,3,0,0,0,0,88,66,94,3,0,0,0,0,96,66,95,3,0,0,0,0,104,66,131,8,0,0,0,0,112,66,97,3,0,0,0,0,120,66,98,3,0,0,0,0,121,66,99,3,0,0,0,0,128,66,100,3,0,0,0,0,144,66,101,3,0,0,0,0,152,66,102,3,0,0,0,0,160,66,103,3,0,0,0,0,168,66,132,8,0,0,0,0,176,66,105,3,0,0,0,0,184,66,106,3,0,0,0,0,185,66,115,3,0,0,0,0,0,68,116,3,0,0,0,0,16,68,117,3,0,0,0,0,24,68,118,3,0,0,0,0,32,68,119,3,0,0,0,0,40,68,134,8,0,0,0,0,48,68,121,3,0,0,0,0,56,68,122,3,0,0,0,0,57,68,123,3,0,0,0,0,64,68,124,3,0,0,0,0,80,68,125,3,0,0,0,0,88,68,126,3,0,0,0,0,96,68,127,3,0,0,0,0,104,68,135,8,0,0,0,0,112,68,129,3,0,0,0,0,120,68,130,3,0,0,0,0,121,68,131,3,0,0,0,0,128,68,132,3,0,0,0,0,144,68,133,3,0,0,0,0,152,68,134,3,0,0,0,0,160,68,135,3,0,0,0,0,168,68,136,8,0,0,0,0,176,68,137,3,0,0,0,0,184,68,138,3,0,0,0,0,185,68,139,3,0,0,0,0,192,68,140,3,0,0,0,0,208,68,141,3,0,0,0,0,216,68,142,3,0,0,0,0,224,68,143,3,0,0,0,0,232,68,137,8,0,0,0,0,240,68,145,3,0,0,0,0,248,68,146,3,0,0,0,0,249,68,147,3,0,0,0,0,250,68,138,8,0,0,0,0,251,68,149,3,0,0,0,0,252,68,150,3,0,0,0,0,0,70,151,3,0,0,0,0,16,70,152,3,0,0,0,0,24,70,153,3,0,0,0,0,32,70,154,3,0,0,0,0,40,70,139,8,0,0,0,0,48,70,156,3,0,0,0,0,56,70,157,3,0,0,0,0,57,70,158,3,0,0,0,0,64,70,159,3,0,0,0,0,80,70,160,3,0,0,0,0,88,70,161,3,0,0,0,0,96,70,162,3,0,0,0,0,104,70,140,8,0,0,0,0,112,70,164,3,0,0,0,0,120,70,165,3,0,0,0,0,121,70,166,3,0,0,0,0,128,70,167,3,0,0,0,0,144,70,168,3,0,0,0,0,152,70,169,3,0,0,0,0,160,70,170,3,0,0,0,0,168,70,141,8,0,0,0,0,176,70,172,3,0,0,0,0,184,70,173,3,0,0,0,0,185,70,174,3,0,0,0,0,192,70,175,3,0,0,0,0,208,70,176,3,0,0,0,0,216,70,177,3,0,0,0,0,224,70,178,3,0,0,0,0,232,70,142,8,0,0,0,0,240,70,180,3,0,0,0,0,248,70,181,3,0,0,0,0,249,70,182,3,0,0,0,0,250,70,143,8,0,0,0,0,251,70,184,3,0,0,0,0,252,70,246,7,0,0,0,0,0,72,247,7,0,0,0,0,16,72,248,7,0,0,0,0,24,72,249,7,0,0,0,0,32,72,250,7,0,0,0,0,40,72,144,8,0,0,0,0,48,72,252,7,0,0,0,0,56,72,253,7,0,0,0,0,57,72,194,3,0,0,0,0,64,72,196,3,0,0,0,0,80,72,197,3,0,0,0,0,104,72,145,8,0,0,0,0,112,72,199,3,0,0,0,0,120,72,200,3,0,0,0,0,121,72,201,3,0,0,0,0,122,72,146,8,0,0,0,0,123,72,203,3,0,0,0,0,128,72,204,3,0,0,0,0,144,72,205,3,0,0,0,0,160,72,206,3,0,0,0,0,168,72,147,8,0,0,0,0,176,72,208,3,0,0,0,0,184,72,209,3,0,0,0,0,185,72,210,3,0,0,0,0,192,72,211,3,0,0,0,0,208,72,212,3,0,0,0,0,224,72,213,3,0,0,0,0,232,72,148,8,0,0,0,0,240,72,215,3,0,0,0,0,248,72,216,3,0,0,0,0,249,72,217,3,0,0,0,0,192,73,218,3,0,0,0,0,0,74,219,3,0,0,0,0,16,74,220,3,0,0,0,0,24,74,221,3,0,0,0,0,32,74,222,3,0,0,0,0,40,74,149,8,0,0,0,0,48,74,224,3,0,0,0,0,56,74,225,3,0,0,0,0,57,74,226,3,0,0,0,0,58,74,150,8,0,0,0,0,59,74,228,3,0,0,0,0,60,74,229,3,0,0,0,0,64,74,230,3,0,0,0,0,72,74,231,3,0,0,0,0,80,74,232,3,0,0,0,0,88,74,233,3,0,0,0,0,96,74,234,3,0,0,0,0,104,74,151,8,0,0,0,0,112,74,236,3,0,0,0,0,120,74,237,3,0,0,0,0,121,74,238,3,0,0,0,0,122,74,152,8,0,0,0,0,123,74,240,3,0,0,0,0,124,74,241,3,0,0,0,0,128,74,242,3,0,0,0,0,136,74,243,3,0,0,0,0,144,74,244,3,0,0,0,0,152,74,245,3,0,0,0,0,160,74,246,3,0,0,0,0,168,74,153,8,0,0,0,0,176,74,248,3,0,0,0,0,184,74,249,3,0,0,0,0,185,74,250,3,0,0,0,0,186,74,154,8,0,0,0,0,187,74,252,3,0,0,0,0,188,74,253,3,0,0,0,0,192,74,254,3,0,0,0,0,208,74,255,3,0,0,0,0,216,74,0,4,0,0,0,0,224,74,1,4,0,0,0,0,232,74,155,8,0,0,0,0,240,74,3,4,0,0,0,0,248,74,4,4,0,0,0,0,249,74,27,4,0,0,0,0,144,76,28,4,0,0,0,0,152,76,29,4,0,0,0,0,168,76,156,8,0,0,0,0,176,76,31,4,0,0,0,0,184,76,32,4,0,0,0,0,185,76,33,4,0,0,0,0,186,76,157,8,0,0,0,0,187,76,35,4,0,0,0,0,208,76,36,4,0,0,0,0,216,76,37,4,0,0,0,0,232,76,158,8,0,0,0,0,240,76,39,4,0,0,0,0,248,76,40,4,0,0,0,0,249,76,41,4,0,0,0,0,250,76,159,8,0,0,0,0,251,76,43,4,0,0,0,0,64,78,44,4,0,0,0,0,80,78,45,4,0,0,0,0,88,78,46,4,0,0,0,0,96,78,47,4,0,0,0,0,104,78,48,4,0,0,0,0,112,78,49,4,0,0,0,0,113,78,50,4,0,0,0,0,114,78,26,9,0,0,0,0,115,78,52,4,0,0,0,0,116,78,53,4,0,0,0,0,117,78,54,4,0,0,0,0,118,78,55,4,0,0,0,0,119,78,58,4,0,0,0,0,144,78,59,4,0,0,0,0,168,78,160,8,0,0,0,0,176,78,61,4,0,0,0,0,184,78,62,4,0,0,0,0,185,78,63,4,0,0,0,0,186,78,161,8,0,0,0,0,187,78,65,4,0,0,0,0,208,78,66,4,0,0,0,0,232,78,162,8,0,0,0,0,240,78,68,4,0,0,0,0,248,78,69,4,0,0,0,0,249,78,70,4,0,0,0,0,250,78,163,8,0,0,0,0,251,78,72,4,0,0,0,0,0,80,73,4,0,0,0,0,16,80,74,4,0,0,0,0,24,80,75,4,0,0,0,0,32,80,76,4,0,0,0,0,40,80,164,8,0,0,0,0,48,80,78,4,0,0,0,0,56,80,79,4,0,0,0,0,57,80,80,4,0,0,0,0,64,80,81,4,0,0,0,0,72,80,82,4,0,0,0,0,80,80,83,4,0,0,0,0,88,80,84,4,0,0,0,0,96,80,85,4,0,0,0,0,104,80,165,8,0,0,0,0,112,80,87,4,0,0,0,0,120,80,88,4,0,0,0,0,121,80,89,4,0,0,0,0,128,80,90,4,0,0,0,0,136,80,91,4,0,0,0,0,144,80,92,4,0,0,0,0,152,80,93,4,0,0,0,0,160,80,94,4,0,0,0,0,168,80,166,8,0,0,0,0,176,80,96,4,0,0,0,0,184,80,97,4,0,0,0,0,185,80,98,4,0,0,0,0,192,80,99,4,0,0,0,0,200,80,100,4,0,0,0,0,208,80,101,4,0,0,0,0,216,80,102,4,0,0,0,0,224,80,103,4,0,0,0,0,232,80,167,8,0,0,0,0,240,80,105,4,0,0,0,0,248,80,106,4,0,0,0,0,249,80,110,4,0,0,0,0,0,81,111,4,0,0,0,0,16,81,112,4,0,0,0,0,24,81,113,4,0,0,0,0,32,81,114,4,0,0,0,0,40,81,168,8,0,0,0,0,48,81,116,4,0,0,0,0,56,81,117,4,0,0,0,0,57,81,118,4,0,0,0,0,64,81,119,4,0,0,0,0,72,81,120,4,0,0,0,0,80,81,121,4,0,0,0,0,88,81,122,4,0,0,0,0,96,81,123,4,0,0,0,0,104,81,169,8,0,0,0,0,112,81,125,4,0,0,0,0,120,81,126,4,0,0,0,0,121,81,127,4,0,0,0,0,128,81,128,4,0,0,0,0,136,81,129,4,0,0,0,0,144,81,130,4,0,0,0,0,152,81,131,4,0,0,0,0,160,81,132,4,0,0,0,0,168,81,170,8,0,0,0,0,176,81,134,4,0,0,0,0,184,81,135,4,0,0,0,0,185,81,136,4,0,0,0,0,192,81,137,4,0,0,0,0,200,81,138,4,0,0,0,0,208,81,139,4,0,0,0,0,216,81,140,4,0,0,0,0,224,81,141,4,0,0,0,0,232,81,171,8,0,0,0,0,240,81,143,4,0,0,0,0,248,81,144,4,0,0,0,0,249,81,148,4,0,0,0,0,192,82,149,4,0,0,0,0,200,82,150,4,0,0,0,0,208,82,151,4,0,0,0,0,216,82,152,4,0,0,0,0,224,82,153,4,0,0,0,0,232,82,172,8,0,0,0,0,240,82,155,4,0,0,0,0,248,82,156,4,0,0,0,0,249,82,160,4,0,0,0,0,192,83,161,4,0,0,0,0,200,83,162,4,0,0,0,0,208,83,163,4,0,0,0,0,216,83,164,4,0,0,0,0,224,83,165,4,0,0,0,0,232,83,173,8,0,0,0,0,240,83,167,4,0,0,0,0,248,83,168,4,0,0,0,0,249,83,172,4,0,0,0,0,192,84,173,4,0,0,0,0,200,84,174,4,0,0,0,0,208,84,175,4,0,0,0,0,216,84,176,4,0,0,0,0,224,84,177,4,0,0,0,0,232,84,174,8,0,0,0,0,240,84,179,4,0,0,0,0,248,84,180,4,0,0,0,0,249,84,184,4,0,0,0,0,192,85,185,4,0,0,0,0,200,85,186,4,0,0,0,0,208,85,187,4,0,0,0,0,216,85,188,4,0,0,0,0,224,85,189,4,0,0,0,0,232,85,175,8,0,0,0,0,240,85,191,4,0,0,0,0,248,85,192,4,0,0,0,0,249,85,196,4,0,0,0,0,192,86,197,4,0,0,0,0,200,86,198,4,0,0,0,0,208,86,199,4,0,0,0,0,216,86,200,4,0,0,0,0,224,86,201,4,0,0,0,0,232,86,176,8,0,0,0,0,240,86,203,4,0,0,0,0,248,86,204,4,0,0,0,0,249,86,208,4,0,0,0,0,192,87,209,4,0,0,0,0,200,87,210,4,0,0,0,0,208,87,211,4,0,0,0,0,216,87,212,4,0,0,0,0,224,87,213,4,0,0,0,0,232,87,177,8,0,0,0,0,240,87,215,4,0,0,0,0,248,87,216,4,0,0,0,0,249,87,220,4,0,0,0,0,192,88,221,4,0,0,0,0,200,88,222,4,0,0,0,0,208,88,223,4,0,0,0,0,216,88,224,4,0,0,0,0,224,88,225,4,0,0,0,0,232,88,178,8,0,0,0,0,240,88,227,4,0,0,0,0,248,88,228,4,0,0,0,0,249,88,232,4,0,0,0,0,192,89,233,4,0,0,0,0,200,89,234,4,0,0,0,0,208,89,235,4,0,0,0,0,216,89,236,4,0,0,0,0,224,89,237,4,0,0,0,0,232,89,179,8,0,0,0,0,240,89,239,4,0,0,0,0,248,89,240,4,0,0,0,0,249,89,244,4,0,0,0,0,192,90,245,4,0,0,0,0,200,90,246,4,0,0,0,0,208,90,247,4,0,0,0,0,216,90,248,4,0,0,0,0,224,90,249,4,0,0,0,0,232,90,180,8,0,0,0,0,240,90,251,4,0,0,0,0,248,90,252,4,0,0,0,0,249,90,0,5,0,0,0,0,192,91,1,5,0,0,0,0,200,91,2,5,0,0,0,0,208,91,3,5,0,0,0,0,216,91,4,5,0,0,0,0,224,91,5,5,0,0,0,0,232,91,181,8,0,0,0,0,240,91,7,5,0,0,0,0,248,91,8,5,0,0,0,0,249,91,12,5,0,0,0,0,192,92,13,5,0,0,0,0,200,92,14,5,0,0,0,0,208,92,15,5,0,0,0,0,216,92,16,5,0,0,0,0,224,92,17,5,0,0,0,0,232,92,182,8,0,0,0,0,240,92,19,5,0,0,0,0,248,92,20,5,0,0,0,0,249,92,24,5,0,0,0,0,192,93,25,5,0,0,0,0,200,93,26,5,0,0,0,0,208,93,27,5,0,0,0,0,216,93,28,5,0,0,0,0,224,93,29,5,0,0,0,0,232,93,183,8,0,0,0,0,240,93,31,5,0,0,0,0,248,93,32,5,0,0,0,0,249,93,36,5,0,0,0,0,192,94,37,5,0,0,0,0,200,94,38,5,0,0,0,0,208,94,39,5,0,0,0,0,216,94,40,5,0,0,0,0,224,94,41,5,0,0,0,0,232,94,184,8,0,0,0,0,240,94,43,5,0,0,0,0,248,94,44,5,0,0,0,0,249,94,48,5,0,0,0,0,192,95,49,5,0,0,0,0,200,95,50,5,0,0,0,0,208,95,51,5,0,0,0,0,216,95,52,5,0,0,0,0,224,95,53,5,0,0,0,0,232,95,185,8,0,0,0,0,240,95,55,5,0,0,0,0,248,95,56,5,0,0,0,0,249,95,60,5,0,0,0,0,0,96,61,5,0,0,0,0,1,96,186,8,0,0,0,0,255,96,63,5,0,0,0,0,0,97,64,5,0,0,0,0,1,97,65,5,0,0,0,0,255,97,66,5,0,0,0,0,0,98,67,5,0,0,0,0,1,98,187,8,0,0,0,0,255,98,69,5,0,0,0,0,0,99,70,5,0,0,0,0,1,99,188,8,0,0,0,0,255,99,72,5,0,0,0,0,0,100,73,5,0,0,0,0,1,100,189,8,0,0,0,0,255,100,75,5,0,0,0,0,0,101,76,5,0,0,0,0,1,101,190,8,0,0,0,0,255,101,78,5,0,0,0,0,0,102,79,5,0,0,0,0,1,102,191,8,0,0,0,0,255,102,81,5,0,0,0,0,0,103,82,5,0,0,0,0,1,103,192,8,0,0,0,0,255,103,84,5,0,0,0,0,0,104,85,5,0,0,0,0,1,104,193,8,0,0,0,0,255,104,87,5,0,0,0,0,0,105,88,5,0,0,0,0,1,105,194,8,0,0,0,0,255,105,90,5,0,0,0,0,0,106,91,5,0,0,0,0,1,106,195,8,0,0,0,0,255,106,93,5,0,0,0,0,0,107,94,5,0,0,0,0,1,107,196,8,0,0,0,0,255,107,96,5,0,0,0,0,0,108,97,5,0,0,0,0,1,108,197,8,0,0,0,0,255,108,99,5,0,0,0,0,0,109,100,5,0,0,0,0,1,109,198,8,0,0,0,0,255,109,102,5,0,0,0,0,0,110,103,5,0,0,0,0,1,110,199,8,0,0,0,0,255,110,105,5,0,0,0,0,0,111,106,5,0,0,0,0,1,111,200,8,0,0,0,0,255,111,108,5,0,0,0,0,0,112,109,5,0,0,0,0,0,113,110,5,0,0,0,0,1,113,111,5,0,0,0,0,0,128,112,5,0,0,0,0,16,128,113,5,0,0,0,0,24,128,114,5,0,0,0,0,32,128,115,5,0,0,0,0,40,128,201,8,0,0,0,0,48,128,117,5,0,0,0,0,56,128,118,5,0,0,0,0,57,128,119,5,0,0,0,0,58,128,202,8,0,0,0,0,59,128,121,5,0,0,0,0,60,128,122,5,0,0,0,0,64,128,123,5,0,0,0,0,80,128,124,5,0,0,0,0,88,128,125,5,0,0,0,0,96,128,126,5,0,0,0,0,104,128,203,8,0,0,0,0,112,128,128,5,0,0,0,0,120,128,129,5,0,0,0,0,121,128,130,5,0,0,0,0,122,128,204,8,0,0,0,0,123,128,132,5,0,0,0,0,124,128,133,5,0,0,0,0,128,128,134,5,0,0,0,0,144,128,135,5,0,0,0,0,152,128,136,5,0,0,0,0,160,128,137,5,0,0,0,0,168,128,205,8,0,0,0,0,176,128,139,5,0,0,0,0,184,128,140,5,0,0,0,0,185,128,141,5,0,0,0,0,186,128,206,8,0,0,0,0,187,128,143,5,0,0,0,0,188,128,144,5,0,0,0,0,192,128,145,5,0,0,0,0,208,128,146,5,0,0,0,0,216,128,147,5,0,0,0,0,224,128,148,5,0,0,0,0,232,128,207,8,0,0,0,0,240,128,150,5,0,0,0,0,248,128,151,5,0,0,0,0,249,128,152,5,0,0,0,0,250,128,208,8,0,0,0,0,251,128,154,5,0,0,0,0,252,128,254,7,0,0,0,0,0,129,255,7,0,0,0,0,8,129,157,5,0,0,0,0,16,129,158,5,0,0,0,0,24,129,159,5,0,0,0,0,32,129,160,5,0,0,0,0,40,129,209,8,0,0,0,0,48,129,162,5,0,0,0,0,56,129,163,5,0,0,0,0,57,129,166,5,0,0,0,0,80,129,167,5,0,0,0,0,88,129,168,5,0,0,0,0,96,129,169,5,0,0,0,0,104,129,210,8,0,0,0,0,112,129,171,5,0,0,0,0,120,129,172,5,0,0,0,0,121,129,175,5,0,0,0,0,144,129,176,5,0,0,0,0,152,129,177,5,0,0,0,0,160,129,178,5,0,0,0,0,168,129,211,8,0,0,0,0,176,129,180,5,0,0,0,0,184,129,181,5,0,0,0,0,185,129,182,5,0,0,0,0,192,129,183,5,0,0,0,0,208,129,184,5,0,0,0,0,216,129,185,5,0,0,0,0,224,129,186,5,0,0,0,0,232,129,212,8,0,0,0,0,240,129,188,5,0,0,0,0,248,129,189,5,0,0,0,0,249,129,190,5,0,0,0,0,250,129,213,8,0,0,0,0,251,129,192,5,0,0,0,0,252,129,193,5,0,0,0,0,0,144,194,5,0,0,0,0,16,144,195,5,0,0,0,0,24,144,196,5,0,0,0,0,32,144,197,5,0,0,0,0,40,144,214,8,0,0,0,0,48,144,199,5,0,0,0,0,56,144,200,5,0,0,0,0,57,144,201,5,0,0,0,0,58,144,215,8,0,0,0,0,59,144,203,5,0,0,0,0,60,144,204,5,0,0,0,0,64,144,205,5,0,0,0,0,72,144,206,5,0,0,0,0,80,144,207,5,0,0,0,0,88,144,208,5,0,0,0,0,96,144,209,5,0,0,0,0,104,144,216,8,0,0,0,0,112,144,211,5,0,0,0,0,120,144,212,5,0,0,0,0,121,144,213,5,0,0,0,0,122,144,217,8,0,0,0,0,123,144,215,5,0,0,0,0,124,144,216,5,0,0,0,0,128,144,217,5,0,0,0,0,136,144,218,5,0,0,0,0,144,144,219,5,0,0,0,0,152,144,220,5,0,0,0,0,160,144,221,5,0,0,0,0,168,144,218,8,0,0,0,0,176,144,223,5,0,0,0,0,184,144,224,5,0,0,0,0,185,144,225,5,0,0,0,0,186,144,219,8,0,0,0,0,187,144,227,5,0,0,0,0,188,144,228,5,0,0,0,0,192,144,229,5,0,0,0,0,200,144,230,5,0,0,0,0,208,144,231,5,0,0,0,0,216,144,232,5,0,0,0,0,224,144,233,5,0,0,0,0,232,144,220,8,0,0,0,0,240,144,235,5,0,0,0,0,248,144,236,5,0,0,0,0,249,144,237,5,0,0,0,0,250,144,221,8,0,0,0,0,251,144,239,5,0,0,0,0,252,144,240,5,0,0,0,0,0,145,241,5,0,0,0,0,8,145,242,5,0,0,0,0,16,145,243,5,0,0,0,0,24,145,244,5,0,0,0,0,32,145,245,5,0,0,0,0,40,145,222,8,0,0,0,0,48,145,247,5,0,0,0,0,56,145,248,5,0,0,0,0,57,145,249,5,0,0,0,0,64,145,250,5,0,0,0,0,72,145,251,5,0,0,0,0,80,145,252,5,0,0,0,0,88,145,253,5,0,0,0,0,96,145,254,5,0,0,0,0,104,145,223,8,0,0,0,0,112,145,0,6,0,0,0,0,120,145,1,6,0,0,0,0,121,145,2,6,0,0,0,0,128,145,3,6,0,0,0,0,136,145,4,6,0,0,0,0,144,145,5,6,0,0,0,0,152,145,6,6,0,0,0,0,160,145,7,6,0,0,0,0,168,145,224,8,0,0,0,0,176,145,9,6,0,0,0,0,184,145,10,6,0,0,0,0,185,145,11,6,0,0,0,0,192,145,12,6,0,0,0,0,200,145,13,6,0,0,0,0,208,145,14,6,0,0,0,0,216,145,15,6,0,0,0,0,224,145,16,6,0,0,0,0,232,145,225,8,0,0,0,0,240,145,18,6,0,0,0,0,248,145,19,6,0,0,0,0,249,145,20,6,0,0,0,0,250,145,226,8,0,0,0,0,251,145,22,6,0,0,0,0,252,145,23,6,0,0,0,0,0,176,24,6,0,0,0,0,16,176,25,6,0,0,0,0,24,176,26,6,0,0,0,0,32,176,27,6,0,0,0,0,40,176,227,8,0,0,0,0,48,176,29,6,0,0,0,0,56,176,30,6,0,0,0,0,57,176,31,6,0,0,0,0,58,176,228,8,0,0,0,0,59,176,33,6,0,0,0,0,60,176,34,6,0,0,0,0,64,176,35,6,0,0,0,0,72,176,36,6,0,0,0,0,80,176,37,6,0,0,0,0,88,176,38,6,0,0,0,0,96,176,39,6,0,0,0,0,104,176,229,8,0,0,0,0,112,176,41,6,0,0,0,0,120,176,42,6,0,0,0,0,121,176,43,6,0,0,0,0,122,176,230,8,0,0,0,0,123,176,45,6,0,0,0,0,124,176,46,6,0,0,0,0,128,176,47,6,0,0,0,0,136,176,48,6,0,0,0,0,144,176,49,6,0,0,0,0,152,176,50,6,0,0,0,0,160,176,51,6,0,0,0,0,168,176,231,8,0,0,0,0,176,176,53,6,0,0,0,0,184,176,54,6,0,0,0,0,185,176,55,6,0,0,0,0,186,176,232,8,0,0,0,0,187,176,57,6,0,0,0,0,188,176,58,6,0,0,0,0,192,176,59,6,0,0,0,0,200,176,60,6,0,0,0,0,208,176,61,6,0,0,0,0,216,176,62,6,0,0,0,0,224,176,63,6,0,0,0,0,232,176,233,8,0,0,0,0,240,176,65,6,0,0,0,0,248,176,66,6,0,0,0,0,249,176,67,6,0,0,0,0,250,176,234,8,0,0,0,0,251,176,69,6,0,0,0,0,252,176,70,6,0,0,0,0,0,177,71,6,0,0,0,0,8,177,72,6,0,0,0,0,16,177,73,6,0,0,0,0,24,177,74,6,0,0,0,0,32,177,75,6,0,0,0,0,40,177,235,8,0,0,0,0,48,177,77,6,0,0,0,0,56,177,78,6,0,0,0,0,57,177,79,6,0,0,0,0,64,177,80,6,0,0,0,0,72,177,81,6,0,0,0,0,80,177,82,6,0,0,0,0,88,177,83,6,0,0,0,0,96,177,84,6,0,0,0,0,104,177,236,8,0,0,0,0,112,177,86,6,0,0,0,0,120,177,87,6,0,0,0,0,121,177,88,6,0,0,0,0,128,177,89,6,0,0,0,0,136,177,90,6,0,0,0,0,144,177,91,6,0,0,0,0,152,177,92,6,0,0,0,0,160,177,93,6,0,0,0,0,168,177,237,8,0,0,0,0,176,177,95,6,0,0,0,0,184,177,96,6,0,0,0,0,185,177,97,6,0,0,0,0,192,177,98,6,0,0,0,0,200,177,99,6,0,0,0,0,208,177,100,6,0,0,0,0,216,177,101,6,0,0,0,0,224,177,102,6,0,0,0,0,232,177,238,8,0,0,0,0,240,177,104,6,0,0,0,0,248,177,105,6,0,0,0,0,249,177,106,6,0,0,0,0,250,177,239,8,0,0,0,0,251,177,108,6,0,0,0,0,252,177,109,6,0,0,0,0,0,192,110,6,0,0,0,0,16,192,111,6,0,0,0,0,24,192,112,6,0,0,0,0,32,192,113,6,0,0,0,0,40,192,240,8,0,0,0,0,48,192,115,6,0,0,0,0,56,192,116,6,0,0,0,0,57,192,117,6,0,0,0,0,58,192,241,8,0,0,0,0,59,192,119,6,0,0,0,0,60,192,120,6,0,0,0,0,64,192,121,6,0,0,0,0,80,192,122,6,0,0,0,0,88,192,123,6,0,0,0,0,96,192,124,6,0,0,0,0,104,192,242,8,0,0,0,0,112,192,126,6,0,0,0,0,120,192,127,6,0,0,0,0,121,192,128,6,0,0,0,0,122,192,243,8,0,0,0,0,123,192,130,6,0,0,0,0,124,192,131,6,0,0,0,0,128,192,132,6,0,0,0,0,144,192,133,6,0,0,0,0,152,192,134,6,0,0,0,0,160,192,135,6,0,0,0,0,168,192,244,8,0,0,0,0,176,192,137,6,0,0,0,0,184,192,138,6,0,0,0,0,185,192,139,6,0,0,0,0,186,192,245,8,0,0,0,0,187,192,141,6,0,0,0,0,188,192,142,6,0,0,0,0,192,192,143,6,0,0,0,0,208,192,144,6,0,0,0,0,216,192,145,6,0,0,0,0,224,192,146,6,0,0,0,0,232,192,246,8,0,0,0,0,240,192,148,6,0,0,0,0,248,192,149,6,0,0,0,0,249,192,150,6,0,0,0,0,250,192,247,8,0,0,0,0,251,192,152,6,0,0,0,0,252,192,0,8,0,0,0,0,0,193,1,8,0,0,0,0,8,193,155,6,0,0,0,0,16,193,156,6,0,0,0,0,24,193,157,6,0,0,0,0,32,193,158,6,0,0,0,0,40,193,248,8,0,0,0,0,48,193,160,6,0,0,0,0,56,193,161,6,0,0,0,0,57,193,162,6,0,0,0,0,64,193,163,6,0,0,0,0,72,193,164,6,0,0,0,0,80,193,165,6,0,0,0,0,88,193,166,6,0,0,0,0,96,193,167,6,0,0,0,0,104,193,249,8,0,0,0,0,112,193,169,6,0,0,0,0,120,193,170,6,0,0,0,0,121,193,171,6,0,0,0,0,136,193,172,6,0,0,0,0,144,193,173,6,0,0,0,0,152,193,174,6,0,0,0,0,160,193,175,6,0,0,0,0,168,193,250,8,0,0,0,0,176,193,177,6,0,0,0,0,184,193,178,6,0,0,0,0,185,193,179,6,0,0,0,0,192,193,180,6,0,0,0,0,208,193,181,6,0,0,0,0,216,193,182,6,0,0,0,0,224,193,183,6,0,0,0,0,232,193,251,8,0,0,0,0,240,193,185,6,0,0,0,0,248,193,186,6,0,0,0,0,249,193,187,6,0,0,0,0,250,193,252,8,0,0,0,0,251,193,189,6,0,0,0,0,252,193,190,6,0,0,0,0,0,208,191,6,0,0,0,0,16,208,192,6,0,0,0,0,24,208,193,6,0,0,0,0,32,208,194,6,0,0,0,0,40,208,253,8,0,0,0,0,48,208,196,6,0,0,0,0,56,208,197,6,0,0,0,0,57,208,198,6,0,0,0,0,58,208,254,8,0,0,0,0,59,208,200,6,0,0,0,0,60,208,201,6,0,0,0,0,64,208,202,6,0,0,0,0,72,208,203,6,0,0,0,0,80,208,204,6,0,0,0,0,88,208,205,6,0,0,0,0,96,208,206,6,0,0,0,0,104,208,255,8,0,0,0,0,112,208,208,6,0,0,0,0,120,208,209,6,0,0,0,0,121,208,210,6,0,0,0,0,122,208,0,9,0,0,0,0,123,208,212,6,0,0,0,0,124,208,213,6,0,0,0,0,128,208,214,6,0,0,0,0,136,208,215,6,0,0,0,0,144,208,216,6,0,0,0,0,152,208,217,6,0,0,0,0,160,208,218,6,0,0,0,0,168,208,1,9,0,0,0,0,176,208,220,6,0,0,0,0,184,208,221,6,0,0,0,0,185,208,222,6,0,0,0,0,186,208,2,9,0,0,0,0,187,208,224,6,0,0,0,0,188,208,225,6,0,0,0,0,192,208,226,6,0,0,0,0,200,208,227,6,0,0,0,0,208,208,228,6,0,0,0,0,216,208,229,6,0,0,0,0,224,208,230,6,0,0,0,0,232,208,3,9,0,0,0,0,240,208,232,6,0,0,0,0,248,208,233,6,0,0,0,0,249,208,234,6,0,0,0,0,250,208,4,9,0,0,0,0,251,208,236,6,0,0,0,0,252,208,237,6,0,0,0,0,0,209,238,6,0,0,0,0,8,209,239,6,0,0,0,0,16,209,240,6,0,0,0,0,24,209,241,6,0,0,0,0,32,209,242,6,0,0,0,0,40,209,5,9,0,0,0,0,48,209,244,6,0,0,0,0,56,209,245,6,0,0,0,0,57,209,246,6,0,0,0,0,64,209,247,6,0,0,0,0,72,209,248,6,0,0,0,0,80,209,249,6,0,0,0,0,88,209,250,6,0,0,0,0,96,209,251,6,0,0,0,0,104,209,6,9,0,0,0,0,112,209,253,6,0,0,0,0,120,209,254,6,0,0,0,0,121,209,255,6,0,0,0,0,128,209,0,7,0,0,0,0,136,209,1,7,0,0,0,0,144,209,2,7,0,0,0,0,152,209,3,7,0,0,0,0,160,209,4,7,0,0,0,0,168,209,7,9,0,0,0,0,176,209,6,7,0,0,0,0,184,209,7,7,0,0,0,0,185,209,8,7,0,0,0,0,192,209,9,7,0,0,0,0,200,209,10,7,0,0,0,0,208,209,11,7,0,0,0,0,216,209,12,7,0,0,0,0,224,209,13,7,0,0,0,0,232,209,8,9,0,0,0,0,240,209,15,7,0,0,0,0,248,209,16,7,0,0,0,0,249,209,17,7,0,0,0,0,250,209,9,9,0,0,0,0,251,209,19,7,0,0,0,0,252,209,20,7,0,0,0,0,0,224,21,7,0,0,0,0,8,224,22,7,0,0,0,0,16,224,23,7,0,0,0,0,24,224,24,7,0,0,0,0,32,224,25,7,0,0,0,0,40,224,26,7,0,0,0,0,48,224,27,7,0,0,0,0,56,224,28,7,0,0,0,0,64,224,29,7,0,0,0,0,72,224,30,7,0,0,0,0,80,224,31,7,0,0,0,0,88,224,32,7,0,0,0,0,96,224,33,7,0,0,0,0,104,224,34,7,0,0,0,0,112,224,35,7,0,0,0,0,120,224,36,7,0,0,0,0,128,224,37,7,0,0,0,0,136,224,38,7,0,0,0,0,144,224,39,7,0,0,0,0,152,224,40,7,0,0,0,0,160,224,41,7,0,0,0,0,168,224,42,7,0,0,0,0,176,224,43,7,0,0,0,0,184,224,44,7,0,0,0,0,208,224,45,7,0,0,0,0,216,224,46,7,0,0,0,0,224,224,47,7,0,0,0,0,232,224,10,9,0,0,0,0,240,224,49,7,0,0,0,0,248,224,50,7,0,0,0,0,249,224,51,7,0,0,0,0,0,225,52,7,0,0,0,0,8,225,53,7,0,0,0,0,16,225,54,7,0,0,0,0,24,225,55,7,0,0,0,0,32,225,56,7,0,0,0,0,40,225,57,7,0,0,0,0,48,225,58,7,0,0,0,0,56,225,59,7,0,0,0,0,64,225,60,7,0,0,0,0,72,225,61,7,0,0,0,0,80,225,62,7,0,0,0,0,88,225,63,7,0,0,0,0,96,225,64,7,0,0,0,0,104,225,65,7,0,0,0,0,112,225,66,7,0,0,0,0,120,225,67,7,0,0,0,0,128,225,68,7,0,0,0,0,136,225,69,7,0,0,0,0,144,225,70,7,0,0,0,0,152,225,71,7,0,0,0,0,160,225,72,7,0,0,0,0,168,225,73,7,0,0,0,0,176,225,74,7,0,0,0,0,184,225,75,7,0,0,0,0,208,225,76,7,0,0,0,0,216,225,77,7,0,0,0,0,224,225,78,7,0,0,0,0,232,225,11,9,0,0,0,0,240,225,80,7,0,0,0,0,248,225,81,7,0,0,0,0,249,225,82,7,0,0,0,0,208,226,83,7,0,0,0,0,216,226,84,7,0,0,0,0,224,226,85,7,0,0,0,0,232,226,12,9,0,0,0,0,240,226,87,7,0,0,0,0,248,226,88,7,0,0,0,0,249,226,89,7,0,0,0,0,208,227,90,7,0,0,0,0,216,227,91,7,0,0,0,0,224,227,92,7,0,0,0,0,232,227,13,9,0,0,0,0,240,227,94,7,0,0,0,0,248,227,95,7,0,0,0,0,249,227,96,7,0,0,0,0,208,228,97,7,0,0,0,0,216,228,98,7,0,0,0,0,224,228,99,7,0,0,0,0,232,228,14,9,0,0,0,0,240,228,101,7,0,0,0,0,248,228,102,7,0,0,0,0,249,228,103,7,0,0,0,0,208,229,104,7,0,0,0,0,216,229,105,7,0,0,0,0,224,229,106,7,0,0,0,0,232,229,15,9,0,0,0,0,240,229,108,7,0,0,0,0,248,229,109,7,0,0,0,0,249,229,110,7,0,0,0,0,208,230,111,7,0,0,0,0,216,230,112,7,0,0,0,0,224,230,113,7,0,0,0,0,232,230,16,9,0,0,0,0,240,230,115,7,0,0,0,0,248,230,116,7,0,0,0,0,249,230,117,7,0,0,0,0,208,231,118,7,0,0,0,0,216,231,119,7,0,0,0,0,224,231,120,7,0,0,0,0,232,231,17,9,0,0,0,0,240,231,122,7,0,0,0,0,248,231,123,7,0,0,0,0,249,231,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,120,160,1,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,0,0,131,160,1,0,192,0,0,0,8,0,0,0,17,17,11,11,11,12,12,12,0,0,0,0,0,0,0,0,192,249,0,0,2,0,0,0,0,0,0,0,9,0,0,0,41,0,0,0,1,0,0,0,41,0,0,0,1,0,0,0,4,17,0,0,142,160,1,0,0,0,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,182,160,1,0,60,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,202,160,1,0,124,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,0,0,213,160,1,0,0,2,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,224,160,1,0,0,4,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,244,160,1,0,0,6,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,8,161,1,0,192,6,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,0,16,0,0,28,161,1,0,192,6,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,16,0,0,65,161,1,0,0,8,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,17,0,0,86,161,1,0,64,8,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,106,161,1,0,128,8,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,131,161,1,0,192,8,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,156,161,1,0,60,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,181,161,1,0,124,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,0,0,192,161,1,0,0,10,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,203,161,1,0,0,12,0,0,8,0,0,0,17,17,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,17,0,0,223,161,1,0,192,10,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,248,161,1,0,192,12,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,32,162,1,0,252,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,16,0,0,72,162,1,0,0,14,0,0,8,0,0,0,17,17,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,255,0,0,2,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,19,0,0,83,162,1,0,192,14,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,123,162,1,0,252,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,16,0,0,163,162,1,0,0,1,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,174,162,1,0,64,1,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,198,162,1,0,128,1,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,222,162,1,0,192,1,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,246,162,1,0,0,1,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,17,0,0,14,163,1,0,64,1,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,34,163,1,0,128,1,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,59,163,1,0,192,1,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,84,163,1,0,0,16,0,0,12,0,0,0,14,14,14,13,13,13,11,11,11,12,12,12,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,18,0,0,109,163,1,0,0,32,0,0,12,0,0,0,14,14,14,13,13,13,11,11,11,12,12,12,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,128,163,1,0,0,32,0,0,12,0,0,0,14,14,14,13,13,13,11,11,11,12,12,12,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,18,0,0,146,163,1,0,0,48,0,0,12,0,0,0,14,14,14,13,13,13,11,11,11,12,12,12,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,165,163,1,0,0,48,0,0,12,0,0,0,14,14,14,13,13,13,11,11,11,12,12,12,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,18,0,0,183,163,1,0,0,64,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,33,0,0,0,1,0,0,0,0,48,0,0,202,163,1,0,192,64,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,1,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,4,16,0,0,219,163,1,0,0,66,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,17,0,0,0,25,0,0,0,17,0,0,0,17,0,0,0,0,32,0,0,236,163,1,0,192,66,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,1,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,0,16,0,0,253,163,1,0,0,68,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,48,0,0,14,164,1,0,192,68,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,16,0,0,31,164,1,0,0,70,0,0,8,0,0,0,17,17,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,48,0,0,48,164,1,0,192,70,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,0,0,65,164,1,0,8,72,0,0,3,0,0,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,49,0,0,82,164,1,0,0,72,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,0,0,0,0,0,0,0,41,0,0,0,1,0,0,0,0,48,0,0,96,164,1,0,72,72,0,0,3,0,0,0,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,16,0,0,113,164,1,0,64,72,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,48,0,0,124,164,1,0,64,72,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,140,164,1,0,128,72,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,48,0,0,177,164,1,0,128,72,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,2,0,0,193,164,1,0,192,72,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,48,0,0,223,164,1,0,192,72,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,2,0,0,239,164,1,0,192,73,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,48,0,0,13,165,1,0,0,74,0,0,8,0,0,0,17,17,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,16,0,0,29,165,1,0,192,74,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,48,0,0,39,165,1,0,252,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,0,0,0,56,165,1,0,0,76,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,64,165,1,0,64,76,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,4,19,0,0,84,165,1,0,128,76,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,1,0,0,104,165,1,0,192,76,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,1,0,0,139,165,1,0,64,78,0,0,4,0,0,0,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,240,255,0,0,0,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,0,16,0,0,174,165,1,0,80,78,0,0,3,0,0,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,49,0,0,185,165,1,0,88,78,0,0,3,0,0,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,48,0,0,199,165,1,0,96,78,0,0,3,0,0,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,0,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,16,0,0,210,165,1,0,104,78,0,0,3,0,0,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,0,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,32,0,0,223,165,1,0,112,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,0,0,0,236,165,1,0,113,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,0,0,0,242,165,1,0,114,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,4,16,0,0,246,165,1,0,115,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,7,0,0,0,1,166,1,0,116,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,3,16,0,0,5,166,1,0,117,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,3,0,0,0,16,166,1,0,118,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,4,0,0,0,20,166,1,0,119,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,3,0,0,0,26,166,1,0,122,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,1,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,16,0,0,30,166,1,0,123,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,1,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,16,0,0,41,166,1,0,128,78,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,2,128,0,0,52,166,1,0,0,65,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,41,0,0,0,41,0,0,0,41,0,0,0,4,17,0,0,89,166,1,0,128,65,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,41,0,0,0,41,0,0,0,41,0,0,0,4,17,0,0,109,166,1,0,192,78,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,2,128,0,0,129,166,1,0,192,65,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,2,0,0,166,166,1,0,64,80,0,0,9,0,0,0,7,7,7,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,206,166,1,0,128,80,0,0,9,0,0,0,7,7,7,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,225,166,1,0,0,80,0,0,11,0,0,0,7,7,7,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,244,166,1,0,64,81,0,0,9,0,0,0,7,7,7,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,8,167,1,0,128,81,0,0,9,0,0,0,7,7,7,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,27,167,1,0,0,81,0,0,11,0,0,0,7,7,7,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,46,167,1,0,200,80,0,0,7,0,0,0,2,2,2,2,15,15,15,0,0,0,0,0,0,0,0,0,248,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,1,49,0,0,66,167,1,0,192,80,0,0,10,0,0,0,2,2,2,2,13,13,13,14,14,14,0,0,0,0,0,0,192,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,0,32,0,0,80,167,1,0,250,80,0,0,4,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,0,2,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,4,16,0,0,97,167,1,0,251,80,0,0,4,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,0,2,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,4,16,0,0,108,167,1,0,252,80,0,0,4,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,0,2,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,4,0,0,0,119,167,1,0,0,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,1,64,0,0,126,167,1,0,0,97,0,0,8,0,0,0,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,1,64,0,0,137,167,1,0,255,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,1,64,0,0,148,167,1,0,0,96,0,0,4,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,1,64,0,0,159,167,1,0,0,96,0,0,12,0,0,0,3,3,3,3,6,6,6,6,6,6,6,6,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,1,64,0,0,170,167,1,0,255,96,0,0,4,0,0,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,1,64,0,0,181,167,1,0,0,112,0,0,11,0,0,0,15,15,15,5,5,5,5,5,5,5,5,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,18,0,0,192,167,1,0,0,128,0,0,11,0,0,0,15,15,15,17,17,11,11,11,12,12,12,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,206,167,1,0,192,128,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,4,19,0,0,226,167,1,0,0,129,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,33,0,0,0,1,0,0,0,0,19,0,0,246,167,1,0,0,129,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,33,0,0,0,1,0,0,0,0,19,0,0,9,168,1,0,0,129,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,34,168,1,0,64,129,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,2,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,59,168,1,0,64,129,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,2,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,78,168,1,0,128,129,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,2,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,103,168,1,0,128,129,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,2,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,122,168,1,0,192,129,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,4,19,0,0,147,168,1,0,0,144,0,0,11,0,0,0,15,15,15,17,17,11,11,11,12,12,12,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,167,168,1,0,192,144,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,180,168,1,0,0,145,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,193,168,1,0,0,145,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,212,168,1,0,0,145,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,237,168,1,0,192,145,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,6,169,1,0,0,176,0,0,11,0,0,0,15,15,15,17,17,11,11,11,12,12,12,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,17,0,0,19,169,1,0,192,176,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,17,0,0,32,169,1,0,192,177,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,17,0,0,45,169,1,0,0,177,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,17,0,0,58,169,1,0,0,177,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,83,169,1,0,0,192,0,0,11,0,0,0,15,15,15,17,17,11,11,11,12,12,12,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,103,169,1,0,192,192,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,123,169,1,0,0,193,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,33,0,0,0,1,0,0,0,0,19,0,0,143,169,1,0,0,193,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,0,0,0,0,0,0,0,33,0,0,0,1,0,0,0,0,19,0,0,162,169,1,0,0,193,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,187,169,1,0,64,193,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,51,0,0,212,169,1,0,64,193,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,51,0,0,231,169,1,0,128,193,0,0,9,0,0,0,15,15,15,13,13,13,14,14,14,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,51,0,0,250,169,1,0,192,193,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,13,170,1,0,0,208,0,0,11,0,0,0,15,15,15,17,17,11,11,11,12,12,12,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,33,170,1,0,192,208,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,46,170,1,0,0,209,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,59,170,1,0,0,209,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,78,170,1,0,0,209,0,0,11,0,0,0,15,15,15,17,17,13,13,13,14,14,14,0,0,0,0,0,0,241,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,103,170,1,0,192,209,0,0,9,0,0,0,15,15,15,11,11,11,12,12,12,0,0,0,0,0,0,0,192,241,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,19,0,0,128,170,1,0,0,224,0,0,9,0,0,0,7,7,7,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,141,170,1,0,8,224,0,0,9,0,0,0,7,7,7,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,155,170,1,0,16,224,0,0,9,0,0,0,7,7,7,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,169,170,1,0,24,224,0,0,9,0,0,0,7,7,7,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,183,170,1,0,32,224,0,0,9,0,0,0,15,15,15,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,197,170,1,0,40,224,0,0,9,0,0,0,15,15,15,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,211,170,1,0,48,224,0,0,9,0,0,0,15,15,15,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,225,170,1,0,56,224,0,0,9,0,0,0,15,15,15,4,17,17,16,16,16,0,0,0,0,0,0,0,56,240,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,239,170,1,0,192,224,0,0,7,0,0,0,4,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,192,254,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,19,0,0,253,170,1,0,192,226,0,0,7,0,0,0,4,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,192,254,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,19,171,1,0,192,228,0,0,7,0,0,0,4,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,192,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,41,171,1,0,192,230,0,0,7,0,0,0,4,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,192,254,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,1,0,0,0,0,19,0,0,63,171,1,0,192,232,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,17,0,0,85,171,1,0,192,233,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,17,0,0,120,171,1,0,192,234,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,155,171,1,0,192,235,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,17,0,0,200,171,1,0,192,236,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,235,171,1,0,192,237,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,17,0,0,24,172,1,0,192,238,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,59,172,1,0,192,239,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,2,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,1,0,0,0,17,0,0,0,17,0,0,0,0,19,0,0,104,172,1,0,0,242,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,17,0,0,149,172,1,0,64,242,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,1,17,0,0,163,172,1,0,64,242,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,17,0,0,188,172,1,0,122,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,16,0,0,224,172,1,0,123,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,16,0,0,236,172,1,0,124,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,0,0,0,248,172,1,0,128,242,0,0,6,0,0,0,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,1,17,0,0,0,173,1,0,192,242,0,0,6,0,0,0,10,10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,1,17,0,0,15,173,1,0,0,243,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,32,0,0,30,173,1,0,64,243,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,3,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,16,0,0,73,173,1,0,0,245,0,0,8,0,0,0,5,5,5,5,5,12,12,12,0,0,0,0,0,0,0,0,0,255,0,0,4,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,17,0,0,106,173,1,0,8,244,0,0,5,0,0,0,19,19,15,15,15,0,0,0,0,0,0,0,0,0,0,0,56,255,0,0,4,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,2,0,0,120,173,1,0,16,244,0,0,5,0,0,0,19,19,15,15,15,0,0,0,0,0,0,0,0,0,0,0,56,255,0,0,4,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,2,0,0,135,173,1,0,24,244,0,0,5,0,0,0,19,19,15,15,15,0,0,0,0,0,0,0,0,0,0,0,56,255,0,0,4,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,0,0,0,150,173,1,0,40,244,0,0,5,0,0,0,19,19,15,15,15,0,0,0,0,0,0,0,0,0,0,0,56,255,0,0,4,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,2,0,0,162,173,1,0,48,244,0,0,5,0,0,0,19,19,15,15,15,0,0,0,0,0,0,0,0,0,0,0,56,255,0,0,4,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,2,0,0,177,173,1,0,56,244,0,0,5,0,0,0,19,19,15,15,15,0,0,0,0,0,0,0,0,0,0,0,56,255,0,0,4,0,0,0,2,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,4,0,0,0,192,173,1,0,32,246,0,0,3,0,0,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,248,255,0,0,4,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,204,173,1,0,0,246,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,4,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,221,173,1,0,0,246,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,4,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,245,173,1,0,0,246,0,0,6,0,0,0,11,11,11,12,12,12,0,0,0,0,0,0,0,0,0,0,192,255,0,0,4,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,13,174,1,0,0,246,0,0,6,0,0,0,13,13,13,14,14,14,0,0,0,0,0,0,0,0,0,0,192,255,0,0,4,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,0,18,0,0,32,174,1,0,0,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,3,0,0,0,56,174,1,0,0,113,0,0,8,0,0,0,18,18,18,18,18,18,18,18,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,2,16,0,0,70,174,1,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,188,88,1,0,5,0,0,0,0,0,0,0,0,0,0,0,27,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,9,0,0,29,9,0,0,188,27,10,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,188,88,1,0,64,89,1,0,5,0,0,0,0,0,0,0,0,0,0,0,27,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,9,0,0,29,9,0,0,196,31,10,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,252,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,95,112,137,0,255,9,47,15,32,9,0,0,0,0,0,0,56,1,0,0,33,9,0,0,34,9,0,0,35,9,0,0,36,9,0,0,37,9,0,0,38,9,0,0,39,9,0,0,40,9,0,0,0,0,0,0,96,1,0,0,33,9,0,0,41,9,0,0,35,9,0,0,36,9,0,0,37,9,0,0,42,9,0,0,43,9,0,0,44,9,0,0,0,0,0,0,112,1,0,0,45,9,0,0,46,9,0,0,47,9,0,0,0,0,0,0,128,1,0,0,45,9,0,0,48,9,0,0,47,9,0,0,86,105,100,101,111,73,110,105,116,0,73,110,105,116,54,56,48,120,48,0,80,97,116,99,104,82,79,77,0,79,112,116,105,111,110,32,39,37,115,39,32,109,117,115,116,32,98,101,32,102,111,108,108,111,119,101,100,32,98,121,32,97,32,118,97,108,117,101,10,0,111,110,0,121,101,115,0,111,102,102,0,110,111,0,86,97,108,117,101,32,102,111,114,32,111,112,116,105,111,110,32,39,37,115,39,32,109,117,115,116,32,98,101,32,39,116,114,117,101,39,32,111,114,32,39,102,97,108,115,101,39,10,0,10,71,101,110,101,114,97,108,32,111,112,116,105,111,110,115,58,0,10,80,108,97,116,102,111,114,109,45,115,112,101,99,105,102,105,99,32,111,112,116,105,111,110,115,58,0,10,66,111,111,108,101,97,110,32,111,112,116,105,111,110,115,32,97,114,101,32,115,112,101,99,105,102,105,101,100,32,97,115,32,39,45,45,79,80,84,73,79,78,32,116,114,117,101,124,111,110,124,121,101,115,39,32,111,114,10,39,45,45,79,80,84,73,79,78,32,102,97,108,115,101,124,111,102,102,124,110,111,39,46,0,83,84,82,73,78,71,0,110,111,110,101,0,66,79,79,76,0,78,85,77,66,69,82,0,37,100,0,60,117,110,107,110,111,119,110,62,0,32,32,45,45,37,115,32,37,115,10,32,32,32,32,37,115,32,91,100,101,102,97,117,108,116,61,37,115,93,10,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,112,114,101,102,101,114,101,110,99,101,115,32,107,101,121,119,111,114,100,32,39,37,115,39,10,0,37,115,32,37,115,10,0,37,115,32,37,100,10,0,100,101,118,105,99,101,47,102,105,108,101,32,110,97,109,101,32,111,102,32,77,97,99,32,118,111,108,117,109,101,0,100,101,118,105,99,101,47,102,105,108,101,32,110,97,109,101,32,111,102,32,77,97,99,32,102,108,111,112,112,121,32,100,114,105,118,101,0,100,101,118,105,99,101,47,102,105,108,101,32,110,97,109,101,115,32,111,102,32,77,97,99,32,67,68,45,82,79,77,32,100,114,105,118,101,0,114,111,111,116,32,112,97,116,104,32,111,102,32,69,120,116,70,83,0,115,99,115,105,48,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,48,0,115,99,115,105,49,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,49,0,115,99,115,105,50,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,50,0,115,99,115,105,51,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,51,0,115,99,115,105,52,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,52,0,115,99,115,105,53,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,53,0,115,99,115,105,54,0,83,67,83,73,32,116,97,114,103,101,116,32,102,111,114,32,77,97,99,32,83,67,83,73,32,73,68,32,54,0,118,105,100,101,111,32,109,111,100,101,0,100,101,118,105,99,101,32,110,97,109,101,32,111,102,32,77,97,99,32,115,101,114,105,97,108,32,112,111,114,116,32,65,0,100,101,118,105,99,101,32,110,97,109,101,32,111,102,32,77,97,99,32,115,101,114,105,97,108,32,112,111,114,116,32,66,0,100,101,118,105,99,101,32,110,97,109,101,32,111,102,32,77,97,99,32,101,116,104,101,114,110,101,116,32,97,100,97,112,116,101,114,0,101,116,104,101,114,99,111,110,102,105,103,0,112,97,116,104,32,111,102,32,110,101,116,119,111,114,107,32,99,111,110,102,105,103,32,115,99,114,105,112,116,0,116,117,110,110,101,108,32,97,108,108,32,110,101,116,119,111,114,107,32,112,97,99,107,101,116,115,32,111,118,101,114,32,85,68,80,0,73,80,32,112,111,114,116,32,110,117,109,98,101,114,32,102,111,114,32,116,117,110,110,101,108,105,110,103,0,114,101,100,105,114,0,112,111,114,116,32,102,111,114,119,97,114,100,105,110,103,32,102,111,114,32,115,108,105,114,112,0,112,97,116,104,32,111,102,32,82,79,77,32,102,105,108,101,0,98,111,111,116,100,114,105,118,101,0,98,111,111,116,32,100,114,105,118,101,32,110,117,109,98,101,114,0,98,111,111,116,100,114,105,118,101,114,0,98,111,111,116,32,100,114,105,118,101,114,32,110,117,109,98,101,114,0,115,105,122,101,32,111,102,32,77,97,99,32,82,65,77,32,105,110,32,98,121,116,101,115,0,110,117,109,98,101,114,32,111,102,32,102,114,97,109,101,115,32,116,111,32,115,107,105,112,32,105,110,32,114,101,102,114,101,115,104,101,100,32,118,105,100,101,111,32,109,111,100,101,115,0,77,97,99,32,77,111,100,101,108,32,73,68,32,40,71,101,115,116,97,108,116,32,77,111,100,101,108,32,73,68,32,109,105,110,117,115,32,54,41,0,99,112,117,0,67,80,85,32,116,121,112,101,32,40,48,32,61,32,54,56,48,48,48,44,32,49,32,61,32,54,56,48,49,48,32,101,116,99,46,41,0,102,112,117,0,101,110,97,98,108,101,32,70,80,85,32,101,109,117,108,97,116,105,111,110,0,100,111,110,39,116,32,105,110,115,116,97,108,108,32,67,68,45,82,79,77,32,100,114,105,118,101,114,0,100,111,110,39,116,32,101,110,97,98,108,101,32,115,111,117,110,100,32,111,117,116,112,117,116,0,110,111,99,108,105,112,99,111,110,118,101,114,115,105,111,110,0,100,111,110,39,116,32,99,111,110,118,101,114,116,32,99,108,105,112,98,111,97,114,100,32,99,111,110,116,101,110,116,115,0,100,105,115,97,98,108,101,32,71,85,73,0,106,105,116,0,101,110,97,98,108,101,32,74,73,84,32,99,111,109,112,105,108,101,114,0,106,105,116,102,112,117,0,101,110,97,98,108,101,32,74,73,84,32,99,111,109,112,105,108,97,116,105,111,110,32,111,102,32,70,80,85,32,105,110,115,116,114,117,99,116,105,111,110,115,0,106,105,116,100,101,98,117,103,0,101,110,97,98,108,101,32,74,73,84,32,100,101,98,117,103,103,101,114,32,40,114,101,113,117,105,114,101,115,32,109,111,110,32,98,117,105,108,116,105,110,41,0,106,105,116,99,97,99,104,101,115,105,122,101,0,116,114,97,110,115,108,97,116,105,111,110,32,99,97,99,104,101,32,115,105,122,101,32,105,110,32,75,66,0,106,105,116,108,97,122,121,102,108,117,115,104,0,101,110,97,98,108,101,32,108,97,122,121,32,105,110,118,97,108,105,100,97,116,105,111,110,32,111,102,32,116,114,97,110,115,108,97,116,105,111,110,32,99,97,99,104,101,0,106,105,116,105,110,108,105,110,101,0,101,110,97,98,108,101,32,116,114,97,110,115,108,97,116,105,111,110,32,116,104,114,111,117,103,104,32,99,111,110,115,116,97,110,116,32,106,117,109,112,115,0,106,105,116,98,108,97,99,107,108,105,115,116,0,98,108,97,99,107,108,105,115,116,32,111,112,99,111,100,101,115,32,102,114,111,109,32,116,114,97,110,115,108,97,116,105,111,110,0,104,97,114,100,119,97,114,101,32,107,101,121,98,111,97,114,100,32,116,121,112,101,0,47,100,101,118,47,102,100,48,0,47,100,101,118,47,102,100,49,0,47,100,101,118,47,0,47,100,101,118,47,99,100,0,47,100,101,118,47,102,100,0,47,100,101,118,47,112,111,108,108,47,0,110,111,99,100,114,111,109,0,10,82,79,77,32,73,110,102,111,58,0,67,104,101,99,107,115,117,109,32,32,32,32,58,32,37,48,56,120,10,0,86,101,114,115,105,111,110,32,32,32,32,32,58,32,37,48,52,120,10,0,83,117,98,32,86,101,114,115,105,111,110,32,58,32,37,48,52,120,10,0,82,101,115,111,117,114,99,101,32,77,97,112,58,32,37,48,56,120,10,0,84,114,97,112,32,84,97,98,108,101,115,32,58,32,37,48,56,120,10,10,0,82,79,77,32,82,101,115,111,117,114,99,101,115,58,0,79,102,102,115,101,116,9,32,84,121,112,101,9,73,68,9,83,105,122,101,9,78,97,109,101,0,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,0,37,48,56,120,32,37,99,37,99,37,99,37,99,9,37,100,9,37,100,9,37,115,10,0,85,110,105,118,101,114,115,97,108,32,84,97,98,108,101,32,97,116,32,37,48,56,120,58,10,0,79,102,102,115,101,116,9,32,73,68,9,72,87,67,102,103,9,82,79,77,56,53,9,77,111,100,101,108,0,117,110,107,110,111,119,110,0,37,48,56,120,32,37,48,50,120,9,37,48,52,120,9,37,48,52,120,9,37,115,10,0,111,0,0,0,0,0,0,0,0,24,0,28,0,32,0,44,0,82,5,46,83,111,110,121,113,12,78,117,113,13,96,14,113,14,12,104,0,1,0,26,102,4,78,117,113,15,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,112,232,78,117,111,4,0,0,0,0,0,0,0,24,0,28,0,32,0,44,0,82,5,46,68,105,115,107,113,16,78,117,113,17,96,14,113,18,12,104,0,1,0,26,102,4,78,117,113,19,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,112,232,78,117,109,4,0,0,0,0,0,0,0,28,0,32,0,36,0,48,0,86,8,46,65,112,112,108,101,67,68,0,113,20,78,117,113,21,96,14,113,22,12,104,0,1,0,26,102,4,78,117,113,23,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,112,232,78,117,77,0,0,0,0,0,0,0,0,24,0,30,0,36,0,50,0,56,4,46,65,73,110,9,112,0,113,27,78,117,112,0,113,28,96,26,112,0,113,29,12,104,0,1,0,26,102,14,78,117,112,0,113,30,96,6,112,0,113,31,78,117,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,78,0,0,0,0,0,0,0,0,26,0,32,0,38,0,52,0,58,5,46,65,79,117,116,9,0,112,1,113,27,78,117,112,1,113,28,96,26,112,1,113,29,12,104,0,1,0,26,102,14,78,117,112,1,113,30,96,6,112,1,113,31,78,117,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,77,0,0,0,0,0,0,0,0,24,0,30,0,36,0,50,0,56,4,46,66,73,110,9,112,2,113,27,78,117,112,2,113,28,96,26,112,2,113,29,12,104,0,1,0,26,102,14,78,117,112,2,113,30,96,6,112,2,113,31,78,117,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,78,0,0,0,0,0,0,0,0,26,0,32,0,38,0,52,0,58,5,46,66,79,117,116,9,0,112,3,113,27,78,117,112,3,113,28,96,26,112,3,113,29,12,104,0,1,0,26,102,14,78,117,112,3,113,30,96,6,112,3,113,31,78,117,50,40,0,6,8,1,0,9,103,12,74,64,111,2,66,64,49,64,0,16,78,117,74,64,111,4,66,64,78,117,47,56,8,252,78,117,64,231,0,124,7,0,113,35,72,231,112,240,38,72,74,171,0,4,103,0,0,24,32,83,34,107,0,4,36,107,0,8,38,120,12,248,78,145,112,0,96,0,0,4,112,255,76,223,15,14,70,223,78,117,220,0,5,5,63,255,1,0,109,111,100,101,108,105,100,0,66,154,54,10,102,250,12,71,0,3,98,0,254,12,71,0,4,98,0,253,8,6,0,13,103,12,46,0,1,255,230,102,12,76,237,3,135,255,232,38,78,65,249,80,240,0,0,8,144,0,2,38,78,8,146,0,2,234,89,2,1,0,7,0,1,0,184,72,231,224,96,2,1,0,112,12,1,0,32,64,194,0,124,7,0,72,66,8,56,0,1,13,209,103,4,38,104,0,48,18,0,235,1,32,124,95,255,255,252,114,7,194,144,69,249,95,255,255,252,32,18,69,250,0,10,66,167,16,17,65,249,34,48,129,226,13,220,255,186,210,176,129,226,13,220,255,236,33,193,30,248,34,120,13,216,211,233,0,8,32,120,12,236,17,124,0,144,32,120,12,236,17,124,0,144,0,19,78,117,32,95,34,95,12,56,0,4,1,47,12,56,0,4,1,47,109,84,72,231,248,96,48,60,168,159,167,70,48,60,160,92,162,71,213,252,0,1,0,0,181,252,0,224,0,0,87,65,82,78,73,78,71,58,32,84,104,105,115,32,82,79,77,32,115,101,101,109,115,32,116,111,32,114,101,113,117,105,114,101,32,97,110,32,70,80,85,0,67,108,97,115,115,105,99,0,77,97,99,32,88,76,0,77,97,99,32,53,49,50,75,69,0,77,97,99,32,80,108,117,115,0,77,97,99,32,83,69,0,77,97,99,32,73,73,0,77,97,99,32,73,73,120,0,77,97,99,32,73,73,99,120,0,77,97,99,32,83,69,47,48,51,48,0,77,97,99,32,80,111,114,116,97,98,108,101,0,77,97,99,32,73,73,99,105,0,77,97,99,32,73,73,102,120,0,77,97,99,32,67,108,97,115,115,105,99,0,77,97,99,32,73,73,115,105,0,77,97,99,32,76,67,0,81,117,97,100,114,97,32,57,48,48,0,80,111,119,101,114,66,111,111,107,32,49,55,48,0,81,117,97,100,114,97,32,55,48,48,0,67,108,97,115,115,105,99,32,73,73,0,80,111,119,101,114,66,111,111,107,32,49,48,48,0,80,111,119,101,114,66,111,111,107,32,49,52,48,0,81,117,97,100,114,97,32,57,53,48,0,77,97,99,32,76,67,73,73,73,47,80,101,114,102,111,114,109,97,32,52,53,48,0,80,111,119,101,114,66,111,111,107,32,68,117,111,32,50,49,48,0,67,101,110,116,114,105,115,32,54,53,48,0,80,111,119,101,114,66,111,111,107,32,68,117,111,32,50,51,48,0,80,111,119,101,114,66,111,111,107,32,49,56,48,0,80,111,119,101,114,66,111,111,107,32,49,54,48,0,81,117,97,100,114,97,32,56,48,48,0,81,117,97,100,114,97,32,54,53,48,0,77,97,99,32,76,67,73,73,0,80,111,119,101,114,66,111,111,107,32,68,117,111,32,50,53,48,0,77,97,99,32,73,73,118,105,0,77,97,99,32,73,73,118,109,47,80,101,114,102,111,114,109,97,32,54,48,48,0,77,97,99,32,73,73,118,120,0,67,111,108,111,114,32,67,108,97,115,115,105,99,47,80,101,114,102,111,114,109,97,32,50,53,48,0,80,111,119,101,114,66,111,111,107,32,49,54,53,99,0,67,101,110,116,114,105,115,32,54,49,48,0,81,117,97,100,114,97,32,54,49,48,0,80,111,119,101,114,66,111,111,107,32,49,52,53,0,77,97,99,32,76,67,53,50,48,0,81,117,97,100,114,97,47,67,101,110,116,114,105,115,32,54,54,48,65,86,0,80,101,114,102,111,114,109,97,32,52,54,120,0,80,111,119,101,114,66,111,111,107,32,49,56,48,99,0,80,111,119,101,114,66,111,111,107,32,53,50,48,47,53,50,48,99,47,53,52,48,47,53,52,48,99,0,80,111,119,101,114,66,111,111,107,32,68,117,111,32,50,55,48,99,0,81,117,97,100,114,97,32,56,52,48,65,86,0,80,101,114,102,111,114,109,97,32,53,53,48,0,80,111,119,101,114,66,111,111,107,32,49,54,53,0,80,111,119,101,114,66,111,111,107,32,49,57,48,0,77,97,99,32,84,86,0,77,97,99,32,76,67,52,55,53,47,80,101,114,102,111,114,109,97,32,52,55,120,0,77,97,99,32,76,67,53,55,53,0,81,117,97,100,114,97,32,54,48,53,0,81,117,97,100,114,97,32,54,51,48,0,77,97,99,32,76,67,53,56,48,0,80,111,119,101,114,66,111,111,107,32,68,117,111,32,50,56,48,0,80,111,119,101,114,66,111,111,107,32,68,117,111,32,50,56,48,99,0,80,111,119,101,114,66,111,111,107,32,49,53,48,0,86,37,100,46,37,100,0,34,0,228,137,144,129,34,64,48,60,0,88,162,71,112,88,162,71,64,131,54,16,34,120,1,212,16,17,2,0,0,48,33,192,5,240,32,95,34,95,12,56,0,4,1,47,112,3,160,159,32,120,2,182,65,232,0,128,112,89,162,71,32,120,1,212,8,208,0,7,78,117,12,111,0,14,0,4,102,12,48,60,161,147,162,71,40,120,1,216,72,199,32,12,208,135,32,64,28,16,58,46,0,10,85,79,62,184,2,142,48,31,72,192,36,64,32,64,42,42,42,32,66,114,101,97,107,112,111,105,110,116,0,100,48,32,37,48,56,120,32,100,49,32,37,48,56,120,32,100,50,32,37,48,56,120,32,100,51,32,37,48,56,120,10,100,52,32,37,48,56,120,32,100,53,32,37,48,56,120,32,100,54,32,37,48,56,120,32,100,55,32,37,48,56,120,10,97,48,32,37,48,56,120,32,97,49,32,37,48,56,120,32,97,50,32,37,48,56,120,32,97,51,32,37,48,56,120,10,97,52,32,37,48,56,120,32,97,53,32,37,48,56,120,32,97,54,32,37,48,56,120,32,97,55,32,37,48,56,120,10,115,114,32,37,48,52,120,10,0,70,65,84,65,76,58,32,83,67,83,73,68,105,115,112,97,116,99,104,40,37,100,41,58,32,105,108,108,101,103,97,108,32,115,101,108,101,99,116,111,114,10,0,70,65,84,65,76,58,32,69,77,85,76,95,79,80,32,99,97,108,108,101,100,32,119,105,116,104,32,98,111,103,117,115,32,111,112,99,111,100,101,32,37,48,56,120,10,0,37,115,47,120,112,114,97,109,0,46,98,97,115,105,108,105,115,107,95,105,105,95,120,112,114,97,109,0,87,65,82,78,73,78,71,58,32,73,110,115,84,105,109,101,40,41,58,32,84,97,115,107,32,114,101,45,105,110,115,101,114,116,101,100,0,70,65,84,65,76,58,32,73,110,115,84,105,109,101,40,41,58,32,78,111,32,102,114,101,101,32,84,105,109,101,32,77,97,110,97,103,101,114,32,100,101,115,99,114,105,112,116,111,114,0,87,65,82,78,73,78,71,58,32,82,109,118,84,105,109,101,40,37,48,56,120,41,58,32,68,101,115,99,114,105,112,116,111,114,32,110,111,116,32,102,111,117,110,100,10,0,70,65,84,65,76,58,32,80,114,105,109,101,84,105,109,101,40,41,58,32,68,101,115,99,114,105,112,116,111,114,32,110,111,116,32,102,111,117,110,100,0,87,65,82,78,73,78,71,58,32,85,110,115,117,112,112,111,114,116,101,100,32,80,114,105,109,101,84,105,109,101,40,48,41,0,107,101,121,98,111,97,114,100,116,121,112,101,0,5,5,99,1,255,98,70,65,84,65,76,58,32,83,101,114,105,97,108,80,114,105,109,101,73,110,40,41,32,99,97,108,108,101,100,32,119,104,105,108,101,32,114,101,113,117,101,115,116,32,105,115,32,112,101,110,100,105,110,103,0,70,65,84,65,76,58,32,83,101,114,105,97,108,80,114,105,109,101,79,117,116,40,41,32,99,97,108,108,101,100,32,119,104,105,108,101,32,114,101,113,117,101,115,116,32,105,115,32,112,101,110,100,105,110,103,0,117,100,112,116,117,110,110,101,108,0,117,100,112,112,111,114,116,0,115,111,99,107,101,116,0,98,105,110,100,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,69,116,104,101,114,67,111,110,116,114,111,108,40,37,100,41,10,0,114,46,97,91,48,93,32,33,61,32,48,0,46,47,46,46,47,101,116,104,101,114,46,99,112,112,0,69,116,104,101,114,110,101,116,80,97,99,107,101,116,0,87,65,82,78,73,78,71,58,32,78,101,115,116,101,100,32,97,108,108,111,99,97,116,105,111,110,32,111,102,32,101,116,104,101,114,110,101,116,32,112,97,99,107,101,116,115,33,0,127,255,255,248,129,0,1,4,129,0,113,2,129,0,137,1,129,0,137,1,129,0,137,1,129,0,137,1,129,0,137,1,129,0,113,1,129,0,1,1,128,255,254,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,135,255,255,225,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,136,0,0,17,127,255,255,254,127,255,255,248,255,255,255,252,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,254,0,0,102,108,111,112,112,121,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,83,111,110,121,67,111,110,116,114,111,108,40,37,100,41,10,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,83,111,110,121,83,116,97,116,117,115,40,37,100,41,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,254,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,140,0,0,1,128,0,0,1,128,0,0,1,127,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,105,115,107,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,68,105,115,107,67,111,110,116,114,111,108,40,37,100,41,10,0,87,65,82,78,73,78,71,58,32,68,105,115,107,83,116,97,116,117,115,40,52,52,58,39,103,101,116,32,115,116,97,114,116,117,112,32,112,97,114,116,105,116,105,111,110,32,115,116,97,116,117,115,39,41,32,78,111,116,32,73,109,112,108,101,109,101,110,116,101,100,0,87,65,82,78,73,78,71,58,32,68,105,115,107,83,116,97,116,117,115,40,52,53,58,39,103,101,116,32,112,97,114,116,105,116,105,111,110,32,119,114,105,116,101,32,112,114,111,116,101,99,116,32,115,116,97,116,117,115,39,41,32,78,111,116,32,73,109,112,108,101,109,101,110,116,101,100,0,87,65,82,78,73,78,71,58,32,68,105,115,107,83,116,97,116,117,115,40,52,54,58,39,103,101,116,32,112,97,114,116,105,116,105,111,110,32,109,111,117,110,116,32,115,116,97,116,117,115,39,41,32,78,111,116,32,73,109,112,108,101,109,101,110,116,101,100,0,87,65,82,78,73,78,71,58,32,68,105,115,107,83,116,97,116,117,115,40,55,48,58,39,103,101,116,32,112,111,119,101,114,32,109,111,100,101,32,115,116,97,116,117,115,39,41,32,78,111,116,32,73,109,112,108,101,109,101,110,116,101,100,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,68,105,115,107,83,116,97,116,117,115,40,37,100,41,10,0,63,255,255,240,64,0,0,8,128,31,192,4,128,117,112,4,129,170,172,4,131,85,86,4,134,170,171,4,141,85,85,132,138,170,170,196,149,95,213,68,154,176,106,228,181,103,53,100,170,207,154,180,181,92,85,116,170,216,90,180,181,88,85,116,170,200,154,180,181,103,53,116,154,176,106,244,149,95,213,100,138,170,170,228,141,85,85,196,134,170,171,196,131,85,87,132,129,170,175,4,128,245,126,4,128,63,248,4,128,15,224,4,255,255,255,252,128,0,0,4,128,31,240,4,127,255,255,248,63,255,255,240,127,255,255,248,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,255,255,255,252,127,255,255,248,0,0,99,100,114,111,109,0,65,112,112,108,101,95,72,70,83,0,0,1,2,3,4,5,6,7,8,9,16,17,18,19,20,21,22,23,24,25,32,33,34,35,36,37,38,39,40,41,48,49,50,51,52,53,54,55,56,57,64,65,66,67,68,69,70,71,72,73,80,81,82,83,84,85,86,87,88,89,96,97,98,99,100,101,102,103,104,105,112,113,114,115,116,117,118,119,120,121,128,129,130,131,132,133,134,135,136,137,144,145,146,147,148,149,150,151,152,153,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,255,255,255,255,255,255,20,21,22,23,24,25,26,27,28,29,255,255,255,255,255,255,30,31,32,33,34,35,36,37,38,39,255,255,255,255,255,255,40,41,42,43,44,45,46,47,48,49,255,255,255,255,255,255,50,51,52,53,54,55,56,57,58,59,255,255,255,255,255,255,60,61,62,63,64,65,66,67,68,69,255,255,255,255,255,255,70,71,72,73,74,75,76,77,78,79,255,255,255,255,255,255,80,81,82,83,84,85,86,87,88,89,255,255,255,255,255,255,90,91,92,93,94,95,96,97,98,99,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,48,48,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,84,79,67,32,116,121,112,101,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,48,50,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,49,48,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,49,49,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,49,53,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,49,54,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,50,50,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,50,51,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,50,52,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,70,65,84,65,76,58,32,46,65,112,112,108,101,67,68,47,67,111,110,116,114,111,108,40,49,50,53,41,58,32,117,110,105,109,112,108,101,109,101,110,116,101,100,32,99,97,108,108,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,67,68,82,79,77,67,111,110,116,114,111,108,40,37,100,41,10,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,67,68,82,79,77,83,116,97,116,117,115,40,37,100,41,10,0,87,65,82,78,73,78,71,58,32,85,110,105,109,112,108,101,109,101,110,116,101,100,32,115,99,67,111,109,112,32,111,112,99,111,100,101,0,70,65,84,65,76,58,32,85,110,114,101,99,111,103,110,105,122,101,100,32,84,73,66,32,111,112,99,111,100,101,32,37,100,10,0,128,49,50,109,111,110,105,116,111,114,95,100,101,115,99,0,78,111,32,118,97,108,105,100,32,118,105,100,101,111,32,109,111,100,101,115,32,102,111,117,110,100,32,40,98,114,111,107,101,110,32,118,105,100,101,111,32,100,114,105,118,101,114,63,41,10,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,86,105,100,101,111,68,114,105,118,101,114,67,111,110,116,114,111,108,40,37,100,41,10,0,87,65,82,78,73,78,71,58,32,85,110,107,110,111,119,110,32,86,105,100,101,111,68,114,105,118,101,114,83,116,97,116,117,115,40,37,100,41,10,0,83,99,114,101,101,110,95,98,108,105,116,116,101,114,95,105,110,105,116,0,100,101,112,116,104,61,37,100,32,109,97,99,95,100,101,112,116,104,61,37,100,10,0,115,119,105,116,99,104,105,110,103,32,116,111,32,66,108,105,116,95,69,120,112,97,110,100,95,56,95,84,111,95,51,50,0,70,65,84,65,76,58,32,97,117,100,105,111,32,99,111,109,112,111,110,101,110,116,32,100,97,116,97,32,98,108,111,99,107,32,105,110,105,116,105,97,108,105,122,97,116,105,111,110,32,101,114,114,111,114,0,87,65,82,78,73,78,71,58,32,78,111,32,70,83,77,32,112,114,101,115,101,110,116,44,32,100,105,115,97,98,108,105,110,103,32,69,120,116,70,83,0,87,65,82,78,73,78,71,58,32,70,83,77,32,60,49,46,50,32,102,111,117,110,100,44,32,100,105,115,97,98,108,105,110,103,32,69,120,116,70,83,0,70,65,84,65,76,58,32,69,120,116,70,83,32,100,97,116,97,32,98,108,111,99,107,32,105,110,105,116,105,97,108,105,122,97,116,105,111,110,32,101,114,114,111,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,254,128,0,0,145,128,0,0,145,128,0,1,33,128,0,1,33,128,0,2,65,140,0,2,65,128,0,4,129,128,0,4,129,127,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,37,115,47,37,115,0,73,110,102,111,46,112,108,105,115,116,0,112,108,105,115,116,0,100,105,99,116,0,100,105,115,107,105,109,97,103,101,45,98,117,110,100,108,101,45,116,121,112,101,0,115,116,114,105,110,103,0,99,111,109,46,97,112,112,108,101,46,100,105,115,107,105,109,97,103,101,46,115,112,97,114,115,101,98,117,110,100,108,101,0,98,117,110,100,108,101,45,98,97,99,107,105,110,103,115,116,111,114,101,45,118,101,114,115,105,111,110,0,105,110,116,101,103,101,114,0,115,112,97,114,115,101,98,117,110,100,108,101,58,32,66,97,100,32,118,101,114,115,105,111,110,10,0,98,97,110,100,45,115,105,122,101,0,115,105,122,101,0,115,112,97,114,115,101,98,117,110,100,108,101,58,32,67,97,110,39,116,32,102,105,110,100,32,115,105,122,101,10,0,116,111,107,101,110,0,115,112,97,114,115,101,98,117,110,100,108,101,58,32,67,97,110,32,111,110,108,121,32,109,111,117,110,116,32,114,101,97,100,45,111,110,108,121,10,0,115,112,97,114,115,101,98,117,110,100,108,101,58,32,111,112,101,110,32,102,97,105,108,101,100,58,0,98,97,110,100,115,0,37,115,47,37,108,120,0,49,55,100,105,115,107,95,115,112,97,114,115,101,98,117,110,100,108,101,0,49,50,100,105,115,107,95,103,101,110,101,114,105,99,0,107,101,121,0,113,117,111,116,0,97,109,112,0,97,112,111,115,0,108,116,0,103,116,0,60,63,0,60,33,45,45,0,60,33,91,67,68,65,84,65,91,0,60,33,0,78,56,116,105,110,121,120,109,108,50,49,50,88,77,76,65,116,116,114,105,98,117,116,101,69,0,78,56,116,105,110,121,120,109,108,50,49,48,88,77,76,69,108,101,109,101,110,116,69,0,78,56,116,105,110,121,120,109,108,50,49,48,88,77,76,85,110,107,110,111,119,110,69,0,93,93,62,0,78,56,116,105,110,121,120,109,108,50,55,88,77,76,84,101,120,116,69,0,45,45,62,0,78,56,116,105,110,121,120,109,108,50,49,48,88,77,76,67,111,109,109,101,110,116,69,0,63,62,0,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,85,84,70,45,56,34,0,78,56,116,105,110,121,120,109,108,50,49,52,88,77,76,68,101,99,108,97,114,97,116,105,111,110,69,0,78,56,116,105,110,121,120,109,108,50,55,88,77,76,78,111,100,101,69,0,78,56,116,105,110,121,120,109,108,50,56,77,101,109,80,111,111,108,84,73,76,105,53,50,69,69,69,0,78,56,116,105,110,121,120,109,108,50,55,77,101,109,80,111,111,108,69,0,78,56,116,105,110,121,120,109,108,50,56,77,101,109,80,111,111,108,84,73,76,105,51,54,69,69,69,0,78,56,116,105,110,121,120,109,108,50,56,77,101,109,80,111,111,108,84,73,76,105,52,56,69,69,69,0,78,56,116,105,110,121,120,109,108,50,56,77,101,109,80,111,111,108,84,73,76,105,52,52,69,69,69,0,78,56,116,105,110,121,120,109,108,50,49,49,88,77,76,68,111,99,117,109,101,110,116,69,0,114,98,0,66,97,115,105,108,105,115,107,32,73,73,32,86,37,100,46,37,100,0,98,121,32,67,104,114,105,115,116,105,97,110,32,66,97,117,101,114,32,101,116,32,97,108,46,0,82,101,97,100,105,110,103,32,82,79,77,32,102,105,108,101,46,46,46,10,0,69,82,82,79,82,58,32,37,115,10,0,66,97,115,105,108,105,115,107,32,73,73,32,101,114,114,111,114,58,10,37,115,0,66,97,115,105,108,105,115,107,32,73,73,32,69,114,114,111,114,0,87,65,82,78,73,78,71,58,32,37,115,10,0,66,97,115,105,108,105,115,107,32,73,73,32,119,97,114,110,105,110,103,58,10,37,115,0,66,97,115,105,108,105,115,107,32,73,73,32,87,97,114,110,105,110,103,0,66,97,115,105,108,105,115,107,32,73,73,32,78,111,116,105,99,101,0,65,98,111,117,116,32,66,97,115,105,108,105,115,107,32,73,73,0,79,75,0,83,116,97,114,116,0,67,97,110,99,101,108,0,78,111,116,32,101,110,111,117,103,104,32,102,114,101,101,32,109,101,109,111,114,121,46,0,89,111,117,114,32,99,111,109,112,117,116,101,114,32,100,111,101,115,32,110,111,116,32,104,97,118,101,32,101,110,111,117,103,104,32,109,101,109,111,114,121,32,116,111,32,114,117,110,32,66,97,115,105,108,105,115,107,32,73,73,46,0,78,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,32,116,111,32,99,114,101,97,116,101,32,82,65,77,32,97,114,101,97,46,0,78,111,116,32,101,110,111,117,103,104,32,109,101,109,111,114,121,32,116,111,32,99,114,101,97,116,101,32,82,79,77,32,97,114,101,97,46,0,67,97,110,110,111,116,32,111,112,101,110,32,82,79,77,32,102,105,108,101,46,0,67,97,110,110,111,116,32,114,101,97,100,32,82,79,77,32,102,105,108,101,46,0,73,110,118,97,108,105,100,32,82,79,77,32,102,105,108,101,32,115,105,122,101,46,32,66,97,115,105,108,105,115,107,32,73,73,32,114,101,113,117,105,114,101,115,32,97,32,53,49,50,75,32,111,114,32,49,77,66,32,77,97,99,73,73,32,82,79,77,46,0,85,110,115,117,112,112,111,114,116,101,100,32,82,79,77,32,116,121,112,101,46,0,67,97,110,110,111,116,32,111,112,101,110,32,77,97,99,32,119,105,110,100,111,119,46,0,67,97,110,110,111,116,32,111,112,101,110,32,77,97,99,32,115,99,114,101,101,110,46,0,67,97,110,110,111,116,32,97,108,108,111,99,97,116,101,32,83,67,83,73,32,98,117,102,102,101,114,32,40,114,101,113,117,101,115,116,101,100,32,37,100,32,98,121,116,101,115,41,46,32,71,105,118,105,110,103,32,117,112,46,0,83,67,83,73,32,115,99,97,116,116,101,114,47,103,97,116,104,101,114,32,116,97,98,108,101,32,102,117,108,108,46,32,71,105,118,105,110,103,32,117,112,46,0,83,101,108,101,99,116,101,100,32,108,101,115,115,32,116,104,97,110,32,49,77,66,32,77,97,99,32,82,65,77,44,32,117,115,105,110,103,32,49,77,66,46,0,67,97,110,110,111,116,32,99,114,101,97,116,101,32,104,97,114,100,102,105,108,101,32,40,37,115,41,46,0,84,104,101,32,118,111,108,117,109,101,32,39,37,115,39,32,105,115,32,109,111,117,110,116,101,100,46,32,66,97,115,105,108,105,115,107,32,73,73,32,119,105,108,108,32,116,114,121,32,116,111,32,117,110,109,111,117,110,116,32,105,116,46,0,84,104,101,32,118,111,108,117,109,101,32,39,37,115,39,32,99,111,117,108,100,32,110,111,116,32,98,101,32,117,110,109,111,117,110,116,101,100,46,32,66,97,115,105,108,105,115,107,32,73,73,32,119,105,108,108,32,110,111,116,32,117,115,101,32,105,116,46,0,66,97,115,105,108,105,115,107,32,73,73,32,83,101,116,116,105,110,103,115,0,83,101,116,116,105,110,103,115,0,65,98,111,117,116,32,66,97,115,105,108,105,115,107,32,73,73,46,46,46,0,83,116,97,114,116,32,66,97,115,105,108,105,115,107,32,73,73,0,90,97,112,32,80,82,65,77,32,70,105,108,101,0,81,117,105,116,32,66,97,115,105,108,105,115,107,32,73,73,0,60,110,111,110,101,62,0,86,111,108,117,109,101,115,0,77,97,99,32,86,111,108,117,109,101,115,0,65,100,100,46,46,46,0,67,114,101,97,116,101,46,46,46,0,69,100,105,116,46,46,46,0,82,101,109,111,118,101,0,65,100,100,0,67,114,101,97,116,101,0,67,68,45,82,79,77,32,68,114,105,118,101,0,66,111,111,116,32,70,114,111,109,0,65,110,121,0,67,68,45,82,79,77,0,68,105,115,97,98,108,101,32,67,68,45,82,79,77,32,68,114,105,118,101,114,0,72,111,115,116,32,82,111,111,116,0,68,101,118,105,99,101,0,85,110,105,116,0,65,100,100,32,86,111,108,117,109,101,0,67,114,101,97,116,101,32,72,97,114,100,102,105,108,101,0,69,100,105,116,32,86,111,108,117,109,101,0,83,105,122,101,32,40,77,66,41,0,82,101,97,100,45,79,110,108,121,0,84,121,112,101,0,70,105,108,101,0,79,112,101,110,32,70,108,97,103,115,0,83,116,97,114,116,32,66,108,111,99,107,0,83,105,122,101,32,40,66,108,111,99,107,115,41,0,66,108,111,99,107,32,83,105,122,101,0,83,67,83,73,0,73,68,32,48,0,73,68,32,49,0,73,68,32,50,0,73,68,32,51,0,73,68,32,52,0,73,68,32,53,0,73,68,32,54,0,71,114,97,112,104,105,99,115,47,83,111,117,110,100,0,71,114,97,112,104,105,99,115,0,86,105,100,101,111,32,84,121,112,101,0,87,105,110,100,111,119,0,70,117,108,108,115,99,114,101,101,110,0,80,73,80,0,87,105,110,100,111,119,32,82,101,102,114,101,115,104,32,82,97,116,101,0,53,32,72,122,0,55,46,53,32,72,122,0,49,48,32,72,122,0,49,53,32,72,122,0,51,48,32,72,122,0,54,48,32,72,122,0,68,121,110,97,109,105,99,0,87,105,100,116,104,0,72,101,105,103,104,116,0,51,56,52,0,52,56,48,0,53,49,50,0,54,48,48,0,54,52,48,0,55,54,56,0,56,48,48,0,49,48,50,52,0,77,97,120,105,109,117,109,0,67,111,108,111,114,32,68,101,112,116,104,0,66,47,87,32,40,49,32,66,105,116,41,0,52,32,40,50,32,66,105,116,41,0,49,54,32,40,52,32,66,105,116,41,0,50,53,54,32,40,56,32,66,105,116,41,0,84,104,111,117,115,97,110,100,115,32,40,49,53,32,66,105,116,41,0,77,105,108,108,105,111,110,115,32,40,50,52,32,66,105,116,41,0,83,99,114,101,101,110,32,77,111,100,101,0,54,52,48,120,52,56,48,44,32,56,32,66,105,116,0,56,48,48,120,54,48,48,44,32,56,32,66,105,116,0,49,48,50,52,120,55,54,56,44,32,56,32,66,105,116,0,49,49,53,50,120,57,48,48,44,32,56,32,66,105,116,0,49,50,56,48,120,49,48,50,52,44,32,56,32,66,105,116,0,49,54,48,48,120,49,50,48,48,44,32,56,32,66,105,116,0,54,52,48,120,52,56,48,44,32,49,53,32,66,105,116,0,56,48,48,120,54,48,48,44,32,49,53,32,66,105,116,0,49,48,50,52,120,55,54,56,44,32,49,53,32,66,105,116,0,49,49,53,50,120,57,48,48,44,32,49,53,32,66,105,116,0,49,50,56,48,120,49,48,50,52,44,32,49,53,32,66,105,116,0,49,54,48,48,120,49,50,48,48,44,32,49,53,32,66,105,116,0,54,52,48,120,52,56,48,44,32,50,52,32,66,105,116,0,56,48,48,120,54,48,48,44,32,50,52,32,66,105,116,0,49,48,50,52,120,55,54,56,44,32,50,52,32,66,105,116,0,49,49,53,50,120,57,48,48,44,32,50,52,32,66,105,116,0,49,50,56,48,120,49,48,50,52,44,32,50,52,32,66,105,116,0,49,54,48,48,120,49,50,48,48,44,32,50,52,32,66,105,116,0,83,111,117,110,100,0,68,105,115,97,98,108,101,32,83,111,117,110,100,32,79,117,116,112,117,116,0,83,101,114,105,97,108,47,78,101,116,119,111,114,107,0,77,111,100,101,109,32,80,111,114,116,0,80,114,105,110,116,101,114,32,80,111,114,116,0,80,97,114,97,108,108,101,108,32,68,101,118,105,99,101,0,69,110,97,98,108,101,32,69,116,104,101,114,110,101,116,0,69,116,104,101,114,110,101,116,32,73,110,116,101,114,102,97,99,101,0,84,117,110,110,101,108,32,77,97,99,79,83,32,78,101,116,119,111,114,107,105,110,103,32,111,118,101,114,32,85,68,80,0,85,68,80,32,80,111,114,116,32,78,117,109,98,101,114,0,77,101,109,111,114,121,47,77,105,115,99,0,77,97,99,79,83,32,82,65,77,32,83,105,122,101,32,40,77,66,41,0,50,0,52,0,56,0,49,54,0,51,50,0,54,52,0,49,50,56,0,50,53,54,0,77,97,99,79,83,32,82,65,77,32,83,105,122,101,58,0,37,108,100,32,77,66,0,77,97,99,32,77,111,100,101,108,32,73,68,0,77,97,99,32,73,73,99,105,32,40,77,97,99,79,83,32,55,46,120,41,0,81,117,97,100,114,97,32,57,48,48,32,40,77,97,99,79,83,32,56,46,120,41,0,67,80,85,32,84,121,112,101,0,54,56,48,50,48,0,54,56,48,50,48,32,119,105,116,104,32,70,80,85,0,54,56,48,51,48,0,54,56,48,51,48,32,119,105,116,104,32,70,80,85,0,54,56,48,52,48,0,82,79,77,32,70,105,108,101,0,68,111,110,39,116,32,85,115,101,32,67,80,85,32,87,104,101,110,32,73,100,108,101,0,74,73,84,32,67,111,109,112,105,108,101,114,0,69,110,97,98,108,101,32,74,73,84,32,67,111,109,112,105,108,101,114,0,67,111,109,112,105,108,101,32,70,80,85,32,73,110,115,116,114,117,99,116,105,111,110,115,0,84,114,97,110,115,108,97,116,105,111,110,32,67,97,99,104,101,32,83,105,122,101,32,40,75,66,41,0,50,48,52,56,0,52,48,57,54,0,56,49,57,50,0,49,54,51,56,52,0,69,110,97,98,108,101,32,108,97,122,121,32,105,110,118,97,108,105,100,97,116,105,111,110,32,111,102,32,116,114,97,110,115,108,97,116,105,111,110,32,99,97,99,104,101,0,84,114,97,110,115,108,97,116,101,32,116,104,114,111,117,103,104,32,99,111,110,115,116,97,110,116,32,106,117,109,112,115,32,40,105,110,108,105,110,101,32,98,108,111,99,107,115,41,0,66,97,115,105,108,105,115,107,32,73,73,0,66,97,115,105,108,105,115,107,32,73,73,32,42,42,42,32,70,82,79,90,69,78,32,42,42,42,0,82,101,102,114,101,115,104,32,82,97,116,101,0,77,111,117,110,116,0,66,97,115,105,108,105,115,107,32,73,73,32,115,117,115,112,101,110,100,101,100,46,32,80,114,101,115,115,32,115,112,97,99,101,32,116,111,32,114,101,97,99,116,105,118,97,116,101,46,0,72,111,115,116,32,68,105,114,101,99,116,111,114,121,32,84,114,101,101,0,72,111,115,116,0,84,104,101,32,118,111,108,117,109,101,32,39,37,115,39,32,105,115,32,109,111,117,110,116,101,100,32,117,110,100,101,114,32,85,110,105,120,46,32,66,97,115,105,108,105,115,107,32,73,73,32,119,105,108,108,32,116,114,121,32,116,111,32,117,110,109,111,117,110,116,32,105,116,46,0,85,110,105,120,32,82,111,111,116,0,85,110,105,120,32,68,105,114,101,99,116,111,114,121,32,84,114,101,101,0,85,110,105,120,0,67,97,110,110,111,116,32,99,111,110,110,101,99,116,32,116,111,32,88,32,115,101,114,118,101,114,32,39,37,115,39,46,0,67,97,110,110,111,116,32,111,98,116,97,105,110,32,97,112,112,114,111,112,114,105,97,116,101,32,88,32,118,105,115,117,97,108,46,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,108,111,114,32,100,101,112,116,104,32,111,102,32,115,99,114,101,101,110,46,0,67,97,110,110,111,116,32,111,112,101,110,32,102,114,97,109,101,32,98,117,102,102,101,114,32,100,101,118,105,99,101,32,115,112,101,99,105,102,105,99,97,116,105,111,110,32,102,105,108,101,32,37,115,32,40,37,115,41,46,0,84,104,101,32,37,115,32,102,114,97,109,101,32,98,117,102,102,101,114,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,105,110,32,37,100,32,98,105,116,32,109,111,100,101,46,0,67,97,110,110,111,116,32,109,109,97,112,40,41,32,116,104,101,32,102,114,97,109,101,32,98,117,102,102,101,114,32,109,101,109,111,114,121,32,40,37,115,41,46,0,67,97,110,110,111,116,32,105,110,105,116,105,97,108,105,122,101,32,86,105,100,101,111,32,111,110,32,83,69,71,86,32,115,105,103,110,97,108,115,46,0,67,97,110,110,111,116,32,111,112,101,110,32,47,100,101,118,47,122,101,114,111,32,40,37,115,41,46,0,67,97,110,110,111,116,32,109,97,112,32,76,111,119,32,77,101,109,111,114,121,32,71,108,111,98,97,108,115,32,40,37,115,41,46,0,67,97,110,110,111,116,32,105,110,115,116,97,108,108,32,97,108,116,101,114,110,97,116,101,32,115,105,103,110,97,108,32,115,116,97,99,107,32,40,37,115,41,46,0,67,97,110,110,111,116,32,105,110,115,116,97,108,108,32,37,115,32,104,97,110,100,108,101,114,32,40,37,115,41,46,0,67,97,110,110,111,116,32,99,114,101,97,116,101,32,116,105,109,101,114,32,40,37,115,41,46,0,67,97,110,110,111,116,32,115,116,97,114,116,32,116,105,109,101,114,32,40,37,115,41,46,0,67,97,110,110,111,116,32,99,114,101,97,116,101,32,54,48,72,122,32,116,104,114,101,97,100,32,40,37,115,41,46,0,67,97,110,110,111,116,32,115,101,116,32,110,111,110,45,98,108,111,99,107,105,110,103,32,73,47,79,32,116,111,32,110,101,116,32,115,111,99,107,101,116,32,40,37,115,41,46,32,69,116,104,101,114,110,101,116,32,119,105,108,108,32,110,111,116,32,98,101,32,97,118,97,105,108,97,98,108,101,46,0,67,97,110,110,111,116,32,111,112,101,110,32,37,115,32,40,37,115,41,46,32,69,116,104,101,114,110,101,116,32,119,105,108,108,32,110,111,116,32,98,101,32,97,118,97,105,108,97,98,108,101,46,0,67,97,110,110,111,116,32,97,116,116,97,99,104,32,116,111,32,69,116,104,101,114,110,101,116,32,99,97,114,100,32,40,37,115,41,46,32,69,116,104,101,114,110,101,116,32,119,105,108,108,32,110,111,116,32,98,101,32,97,118,97,105,108,97,98,108,101,46,0,67,97,110,110,111,116,32,99,111,110,102,105,103,117,114,101,32,84,85,78,47,84,65,80,32,100,101,118,105,99,101,32,40,37,115,41,46,32,69,116,104,101,114,110,101,116,32,119,105,108,108,32,110,111,116,32,98,101,32,97,118,97,105,108,97,98,108,101,46,0,67,97,110,110,111,116,32,103,101,116,32,68,78,83,32,97,100,100,114,101,115,115,46,32,69,116,104,101,114,110,101,116,32,119,105,108,108,32,110,111,116,32,98,101,32,97,118,97,105,108,97,98,108,101,46,0,67,97,110,110,111,116,32,111,112,101,110,32,37,115,32,40,37,115,41,46,32,83,67,83,73,32,77,97,110,97,103,101,114,32,97,99,99,101,115,115,32,116,111,32,116,104,105,115,32,100,101,118,105,99,101,32,119,105,108,108,32,98,101,32,100,105,115,97,98,108,101,100,46,0,37,115,32,100,111,101,115,110,39,116,32,115,101,101,109,32,116,111,32,99,111,109,112,108,121,32,116,111,32,116,104,101,32,71,101,110,101,114,105,99,32,83,67,83,73,32,65,80,73,46,32,83,67,83,73,32,77,97,110,97,103,101,114,32,97,99,99,101,115,115,32,116,111,32,116,104,105,115,32,100,101,118,105,99,101,32,119,105,108,108,32,98,101,32,100,105,115,97,98,108,101,100,46,0,67,97,110,110,111,116,32,111,112,101,110,32,37,115,32,40,37,115,41,46,32,65,117,100,105,111,32,111,117,116,112,117,116,32,119,105,108,108,32,98,101,32,100,105,115,97,98,108,101,100,46,0,78,111,32,97,117,100,105,111,32,100,101,118,105,99,101,32,102,111,117,110,100,44,32,97,117,100,105,111,32,111,117,116,112,117,116,32,119,105,108,108,32,98,101,32,100,105,115,97,98,108,101,100,46,0,65,117,100,105,111,32,104,97,114,100,119,97,114,101,32,100,111,101,115,110,39,116,32,115,101,101,109,32,116,111,32,115,117,112,112,111,114,116,32,110,101,99,101,115,115,97,114,121,32,102,111,114,109,97,116,46,32,65,117,100,105,111,32,111,117,116,112,117,116,32,119,105,108,108,32,98,101,32,100,105,115,97,98,108,101,100,46,0,67,97,110,110,111,116,32,111,112,101,110,32,107,101,121,99,111,100,101,32,116,114,97,110,115,108,97,116,105,111,110,32,102,105,108,101,32,37,115,32,40,37,115,41,46,0,67,97,110,110,111,116,32,102,105,110,100,32,118,101,110,100,111,114,32,39,37,115,39,32,105,110,32,107,101,121,99,111,100,101,32,116,114,97,110,115,108,97,116,105,111,110,32,102,105,108,101,32,37,115,46,0,47,95,70,105,108,101,0,47,70,105,108,101,47,95,83,116,97,114,116,32,66,97,115,105,108,105,115,107,32,73,73,0,47,70,105,108,101,47,95,90,97,112,32,80,82,65,77,32,70,105,108,101,0,47,70,105,108,101,47,115,101,112,108,0,47,70,105,108,101,47,95,81,117,105,116,32,66,97,115,105,108,105,115,107,32,73,73,0,47,95,72,101,108,112,0,47,72,101,108,112,47,95,65,98,111,117,116,32,66,97,115,105,108,105,115,107,32,73,73,0,70,114,97,109,101,32,66,117,102,102,101,114,32,78,97,109,101,0,70,114,97,109,101,32,66,117,102,102,101,114,32,83,112,101,99,32,70,105,108,101,0,65,117,100,105,111,32,79,117,116,112,117,116,32,68,101,118,105,99,101,0,65,117,100,105,111,32,77,105,120,101,114,32,68,101,118,105,99,101,0,66,114,111,119,115,101,32,102,105,108,101,0,66,114,111,119,115,101,46,46,46,0,75,101,121,98,111,97,114,100,47,77,111,117,115,101,0,85,115,101,32,82,97,119,32,75,101,121,99,111,100,101,115,0,75,101,121,99,111,100,101,32,84,114,97,110,115,108,97,116,105,111,110,32,70,105,108,101,0,77,111,117,115,101,32,87,104,101,101,108,32,70,117,110,99,116,105,111,110,0,80,97,103,101,32,85,112,47,68,111,119,110,0,67,117,114,115,111,114,32,85,112,47,68,111,119,110,0,76,105,110,101,115,32,84,111,32,83,99,114,111,108,108,0,73,103,110,111,114,101,32,73,108,108,101,103,97,108,32,77,101,109,111,114,121,32,65,99,99,101,115,115,101,115,0,66,97,115,105,108,105,115,107,32,73,73,32,40,109,111,117,115,101,32,103,114,97,98,98,101,100,44,32,112,114,101,115,115,32,67,116,114,108,45,70,53,32,116,111,32,114,101,108,101,97,115,101,41,0,67,111,117,108,100,32,110,111,116,32,115,116,97,114,116,32,37,115,32,40,37,115,41,46,0,47,116,109,112,47,0,99,108,105,101,110,116,32,115,111,99,107,101,116,0,99,108,105,101,110,116,95,99,111,110,110,101,99,116,0,117,110,107,110,111,119,110,32,97,114,114,97,121,32,97,114,103,32,116,121,112,101,32,37,100,32,116,111,32,115,101,110,100,10,0,117,110,107,110,111,119,110,32,97,114,103,32,116,121,112,101,32,37,100,32,116,111,32,115,101,110,100,10,0,117,110,107,110,111,119,110,32,97,114,114,97,121,32,97,114,103,32,116,121,112,101,32,37,100,32,116,111,32,114,101,99,101,105,118,101,10,0,32,114,101,108,101,97,115,105,110,103,32,116,104,101,95,98,117,102,102,101,114,32,97,116,32,37,112,32,40,37,100,32,98,121,116,101,115,41,10,0,49,49,100,114,105,118,101,114,95,98,97,115,101,0,49,51,100,114,105,118,101,114,95,119,105,110,100,111,119,0,49,55,100,114,105,118,101,114,95,102,117,108,108,115,99,114,101,101,110,0,118,105,100,101,111,95,99,108,111,115,101,40,41,0,32,102,114,97,109,101,32,98,117,102,102,101,114,32,117,110,108,111,99,107,101,100,0,118,105,100,101,111,95,111,112,101,110,40,41,0,67,117,114,114,101,110,116,32,118,105,100,101,111,32,109,111,100,101,58,0,32,37,100,120,37,100,32,40,73,68,32,37,48,50,120,41,44,32,37,100,32,98,112,112,10,0,83,99,114,101,101,110,95,98,108,105,116,0,46,47,46,46,47,83,68,76,47,118,105,100,101,111,95,115,100,108,46,99,112,112,0,117,112,100,97,116,101,95,100,105,115,112,108,97,121,95,115,116,97,116,105,99,95,98,98,111,120,0,123,32,77,111,100,117,108,101,46,115,117,109,109,97,114,105,122,101,66,117,102,102,101,114,40,36,48,44,32,36,49,44,32,36,50,44,32,36,51,41,59,32,125,0,98,114,111,119,115,101,114,95,112,105,120,101,108,115,0,123,32,77,111,100,117,108,101,46,98,108,105,116,40,36,48,44,32,36,49,44,32,36,50,44,32,36,51,44,32,36,52,41,59,32,125,0,117,112,100,97,116,101,95,100,105,115,112,108,97,121,95,115,116,97,116,105,99,0,100,114,105,118,101,114,95,102,117,108,108,115,99,114,101,101,110,58,58,100,114,105,118,101,114,95,102,117,108,108,115,99,114,101,101,110,0,70,65,84,65,76,58,32,67,111,117,108,100,32,110,111,116,32,114,101,97,108,108,111,99,97,116,101,32,102,114,97,109,101,98,117,102,102,101,114,32,97,116,32,112,114,101,118,105,111,117,115,32,97,100,100,114,101,115,115,0,116,104,101,95,98,117,102,102,101,114,32,61,32,37,112,44,32,116,104,101,95,98,117,102,102,101,114,95,99,111,112,121,32,61,32,37,112,10,0,109,111,110,105,116,111,114,46,115,101,116,95,109,97,99,95,102,114,97,109,101,95,98,97,115,101,40,77,97,99,70,114,97,109,101,66,97,115,101,77,97,99,41,32,110,97,116,105,118,101,95,98,121,116,101,95,111,114,100,101,114,61,37,100,32,77,97,99,70,114,97,109,101,76,97,121,111,117,116,61,37,100,10,0,109,111,110,105,116,111,114,46,109,97,99,95,102,114,97,109,101,95,98,97,115,101,32,61,32,37,48,56,120,10,0,100,114,105,118,101,114,95,119,105,110,100,111,119,58,58,100,114,105,118,101,114,95,119,105,110,100,111,119,0,97,99,116,117,97,108,108,121,32,97,108,108,111,99,97,116,105,110,103,32,98,114,111,119,115,101,114,32,112,105,120,101,108,115,0,100,114,105,118,101,114,95,119,105,110,100,111,119,0,100,114,105,118,101,114,95,119,105,110,100,111,119,32,97,108,108,111,99,97,116,101,100,32,98,114,111,119,115,101,114,95,112,105,120,101,108,115,61,37,112,10,0,123,32,77,111,100,117,108,101,46,100,101,98,117,103,80,111,105,110,116,101,114,40,36,48,41,59,32,125,0,97,108,108,111,99,97,116,105,110,103,32,116,104,101,95,98,117,102,102,101,114,44,32,116,104,101,95,98,117,102,102,101,114,95,99,111,112,121,0,49,54,83,68,76,95,109,111,110,105,116,111,114,95,100,101,115,99,0,47,117,115,114,47,108,111,99,97,108,47,115,104,97,114,101,47,66,97,115,105,108,105,115,107,73,73,47,107,101,121,99,111,100,101,115,0,115,100,108,0,37,100,32,37,100,0,115,100,108,0,85,115,105,110,103,32,83,68,76,47,37,115,32,107,101,121,99,111,100,101,115,32,116,97,98,108,101,44,32,37,100,32,107,101,121,32,109,97,112,112,105,110,103,115,10,0,102,114,97,109,101,115,107,105,112,0,115,99,114,101,101,110,0,119,105,110,47,53,49,50,47,51,52,50,0,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,115,99,114,101,101,110,87,105,100,116,104,40,41,59,32,125,0,119,105,110,47,37,100,47,37,100,0,100,103,97,47,37,100,47,37,100,0,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,115,99,114,101,101,110,72,101,105,103,104,116,40,41,59,32,125,0,65,118,97,105,108,97,98,108,101,32,118,105,100,101,111,32,109,111,100,101,115,58,0,32,37,100,120,37,100,32,40,73,68,32,37,48,50,120,41,44,32,37,100,32,99,111,108,111,114,115,10,0,86,105,100,101,111,81,117,105,116,70,117,108,108,83,99,114,101,101,110,40,41,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,97,99,113,117,105,114,101,73,110,112,117,116,76,111,99,107,40,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,109,111,117,115,101,66,117,116,116,111,110,83,116,97,116,101,65,100,100,114,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,109,111,117,115,101,77,111,118,101,70,108,97,103,65,100,100,114,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,109,111,117,115,101,77,111,118,101,88,68,101,108,116,97,65,100,100,114,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,109,111,117,115,101,77,111,118,101,89,68,101,108,116,97,65,100,100,114,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,107,101,121,69,118,101,110,116,70,108,97,103,65,100,100,114,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,107,101,121,67,111,100,101,65,100,100,114,41,59,32,125,34,0,34,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,103,101,116,73,110,112,117,116,86,97,108,117,101,40,77,111,100,117,108,101,46,73,110,112,117,116,66,117,102,102,101,114,65,100,100,114,101,115,115,101,115,46,107,101,121,83,116,97,116,101,65,100,100,114,41,59,32,125,34,0,85,110,104,97,110,100,108,101,100,32,107,101,121,99,111,100,101,58,32,37,100,10,0,123,32,77,111,100,117,108,101,46,114,101,108,101,97,115,101,73,110,112,117,116,76,111,99,107,40,41,59,32,125,0,46,102,105,110,102,47,0,46,90,0,46,103,122,0,46,104,113,120,0,46,98,105,110,0,46,112,100,102,0,46,112,115,0,46,115,105,116,0,46,116,97,114,0,46,117,117,0,46,117,117,101,0,46,122,105,112,0,46,56,115,118,120,0,46,97,105,102,99,0,46,97,105,102,102,0,46,97,117,0,46,109,105,100,0,46,109,105,100,105,0,46,109,112,50,0,46,109,112,51,0,46,119,97,118,0,46,98,109,112,0,46,103,105,102,0,46,108,98,109,0,46,105,108,98,109,0,46,106,112,103,0,46,106,112,101,103,0,46,112,105,99,116,0,46,112,110,103,0,46,115,103,105,0,46,116,103,97,0,46,116,105,102,0,46,116,105,102,102,0,46,104,116,109,0,46,104,116,109,108,0,46,116,120,116,0,46,114,116,102,0,46,99,0,46,67,0,46,99,99,0,46,99,112,112,0,46,99,120,120,0,46,104,0,46,104,104,0,46,104,112,112,0,46,104,120,120,0,46,115,0,46,83,0,46,105,0,46,109,112,103,0,46,109,112,101,103,0,46,109,111,118,0,46,102,108,105,0,46,97,118,105,0,46,113,120,100,0,46,104,102,118,0,46,100,115,107,0,46,105,109,103,0,46,114,115,114,99,47,0,46,102,105,110,102,0,46,114,115,114,99,0,57,68,83,69,82,68,80,111,114,116,0,56,83,69,82,68,80,111,114,116,0,115,101,114,105,97,108,97,0,115,101,114,105,97,108,98,0,101,116,104,101,114,0,116,97,112,0,106,115,0,123,32,77,111,100,117,108,101,46,115,101,110,100,40,36,48,44,32,36,49,41,59,32,125,0,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,114,101,99,118,40,36,48,44,32,49,53,49,52,41,59,32,125,0,123,32,77,111,100,117,108,101,46,112,114,105,110,116,40,34,110,111,32,110,101,116,95,112,114,111,116,111,99,111,108,115,34,41,32,125,0,123,32,77,111,100,117,108,101,46,112,114,105,110,116,40,34,110,111,32,110,101,116,95,112,114,111,116,111,99,111,108,115,32,104,97,110,100,108,101,114,34,41,32,125,0,87,65,82,78,73,78,71,58,32,67,97,110,110,111,116,32,105,110,105,116,32,115,101,109,97,112,104,111,114,101,0,65,117,100,105,111,73,110,105,116,0,110,111,115,111,117,110,100,0,87,65,82,78,73,78,71,58,32,67,97,110,110,111,116,32,111,112,101,110,32,37,115,32,40,37,115,41,10,0,111,112,101,110,95,97,117,100,105,111,0,85,115,105,110,103,32,74,83,32,97,117,100,105,111,32,111,117,116,112,117,116,0,123,32,77,111,100,117,108,101,46,111,112,101,110,65,117,100,105,111,40,36,48,44,32,36,49,44,32,36,50,44,32,36,51,41,59,32,125,0,97,117,100,105,111,32,119,111,117,108,100,32,98,101,32,104,97,112,112,101,110,105,110,103,32,110,111,119,0,97,108,108,111,99,97,116,111,114,60,84,62,58,58,97,108,108,111,99,97,116,101,40,115,105,122,101,95,116,32,110,41,32,39,110,39,32,101,120,99,101,101,100,115,32,109,97,120,105,109,117,109,32,115,117,112,112,111,114,116,101,100,32,115,105,122,101,0,65,117,100,105,111,69,120,105,116,0,99,108,111,115,101,95,97,117,100,105,111,0,123,32,114,101,116,117,114,110,32,77,111,100,117,108,101,46,101,110,113,117,101,117,101,65,117,100,105,111,40,36,48,44,32,36,49,44,32,36,50,41,59,32,125,0,87,65,82,78,73,78,71,58,32,79,118,101,114,102,108,111,119,101,100,32,54,51,45,98,105,116,32,109,54,56,107,32,105,110,115,116,114,117,99,116,105,111,110,32,99,111,117,110,116,101,114,32,105,110,32,108,101,115,115,32,116,104,97,110,32,49,54,32,109,115,33,0,102,97,107,101,95,109,97,105,110,0,32,37,115,10,0,45,45,104,101,108,112,0,45,45,103,117,105,45,99,111,110,110,101,99,116,105,111,110,0,45,45,98,114,101,97,107,0,45,45,99,111,110,102,105,103,0,45,45,114,111,109,105,110,102,111,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,112,116,105,111,110,32,39,37,115,39,10,0,110,111,103,117,105,0,114,97,109,115,105,122,101,0,114,111,109,0,114,111,109,95,112,97,116,104,32,37,115,10,0,82,79,77,0,37,115,0,73,110,105,116,105,97,108,105,122,101,32,101,118,101,114,121,116,104,105,110,103,0,115,101,114,118,105,99,101,115,0,83,116,97,114,116,105,110,103,32,101,109,117,108,97,116,105,111,110,0,81,117,105,116,0,70,97,105,108,101,100,32,116,111,32,105,110,105,116,105,97,108,105,122,101,32,82,80,67,32,99,108,105,101,110,116,32,99,111,110,110,101,99,116,105,111,110,32,116,111,32,116,104,101,32,71,85,73,10,0,85,115,97,103,101,58,32,37,115,32,91,79,80,84,73,79,78,46,46,46,93,10,10,85,110,105,120,32,111,112,116,105,111,110,115,58,10,32,32,45,45,99,111,110,102,105,103,32,70,73,76,69,10,32,32,32,32,114,101,97,100,47,119,114,105,116,101,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,102,114,111,109,47,116,111,32,70,73,76,69,10,32,32,45,45,100,105,115,112,108,97,121,32,83,84,82,73,78,71,10,32,32,32,32,88,32,100,105,115,112,108,97,121,32,116,111,32,117,115,101,10,32,32,45,45,98,114,101,97,107,32,65,68,68,82,69,83,83,10,32,32,32,32,115,101,116,32,82,79,77,32,98,114,101,97,107,112,111,105,110,116,10,32,32,45,45,114,111,109,105,110,102,111,10,32,32,32,32,100,117,109,112,32,82,79,77,32,105,110,102,111,114,109,97,116,105,111,110,10,0,107,101,121,99,111,100,101,115,0,117,115,101,32,107,101,121,99,111,100,101,115,32,114,97,116,104,101,114,32,116,104,97,110,32,107,101,121,115,121,109,115,32,116,111,32,100,101,99,111,100,101,32,107,101,121,98,111,97,114,100,0,107,101,121,99,111,100,101,102,105,108,101,0,112,97,116,104,32,111,102,32,107,101,121,99,111,100,101,32,116,114,97,110,115,108,97,116,105,111,110,32,102,105,108,101,0,102,98,100,101,118,105,99,101,102,105,108,101,0,112,97,116,104,32,111,102,32,102,114,97,109,101,32,98,117,102,102,101,114,32,100,101,118,105,99,101,32,115,112,101,99,105,102,105,99,97,116,105,111,110,32,102,105,108,101,0,109,111,117,115,101,119,104,101,101,108,109,111,100,101,0,109,111,117,115,101,32,119,104,101,101,108,32,115,117,112,112,111,114,116,32,109,111,100,101,32,40,48,61,112,97,103,101,32,117,112,47,100,111,119,110,44,32,49,61,99,117,114,115,111,114,32,117,112,47,100,111,119,110,41,0,109,111,117,115,101,119,104,101,101,108,108,105,110,101,115,0,110,117,109,98,101,114,32,111,102,32,108,105,110,101,115,32,116,111,32,115,99,114,111,108,108,32,105,110,32,109,111,117,115,101,32,119,104,101,101,108,32,109,111,100,101,32,49,0,100,115,112,0,97,117,100,105,111,32,111,117,116,112,117,116,32,40,100,115,112,41,32,100,101,118,105,99,101,32,110,97,109,101,0,109,105,120,101,114,0,97,117,100,105,111,32,109,105,120,101,114,32,100,101,118,105,99,101,32,110,97,109,101,0,105,100,108,101,119,97,105,116,0,115,108,101,101,112,32,119,104,101,110,32,105,100,108,101,0,112,114,101,102,115,0,114,0,78,111,32,102,105,108,101,32,97,116,32,37,115,32,102,111,117,110,100,46,10,0,72,79,77,69,0,46,98,97,115,105,108,105,115,107,95,105,105,95,112,114,101,102,115,0,119,0,101,120,116,102,115,0,47,100,101,118,47,100,115,112,0,47,100,101,118,47,109,105,120,101,114,0,89,111,117,114,32,77,97,99,32,112,114,111,103,114,97,109,32,106,117,115,116,32,100,105,100,32,115,111,109,101,116,104,105,110,103,32,116,101,114,114,105,98,108,121,32,115,116,117,112,105,100,0,73,108,108,101,103,97,108,32,105,110,115,116,114,117,99,116,105,111,110,58,32,37,48,52,120,32,97,116,32,37,48,56,108,120,10,0,69,120,99,101,112,116,105,111,110,33,0,110,114,32,60,32,56,32,38,38,32,110,114,32,62,61,32,48,0,46,47,46,46,47,117,97,101,95,99,112,117,47,110,101,119,99,112,117,46,99,112,112,0,73,110,116,101,114,114,117,112,116,0,79,82,0,67,72,75,0,67,72,75,50,0,65,78,68,0,69,79,82,0,79,82,83,82,0,65,78,68,83,82,0,69,79,82,83,82,0,83,85,66,0,83,85,66,65,0,83,85,66,88,0,83,66,67,68,0,65,68,68,0,65,68,68,65,0,65,68,68,88,0,65,66,67,68,0,78,69,71,0,78,69,71,88,0,78,66,67,68,0,67,76,82,0,78,79,84,0,84,83,84,0,66,84,83,84,0,66,67,72,71,0,66,67,76,82,0,66,83,69,84,0,67,77,80,0,67,77,80,77,0,67,77,80,65,0,77,86,80,82,77,0,77,86,80,77,82,0,77,79,86,69,0,77,79,86,69,65,0,77,86,83,82,50,0,77,86,50,83,82,0,83,87,65,80,0,69,88,71,0,69,88,84,0,77,86,77,69,76,0,77,86,77,76,69,0,84,82,65,80,0,77,86,82,50,85,83,80,0,77,86,85,83,80,50,82,0,82,84,68,0,76,73,78,75,0,85,78,76,75,0,83,84,79,80,0,74,83,82,0,74,77,80,0,66,83,82,0,66,99,99,0,76,69,65,0,80,69,65,0,68,66,99,99,0,83,99,99,0,68,73,86,85,0,68,73,86,83,0,77,85,76,85,0,77,85,76,83,0,65,83,82,0,65,83,76,0,76,83,82,0,76,83,76,0,82,79,76,0,82,79,82,0,82,79,88,76,0,82,79,88,82,0,65,83,82,87,0,65,83,76,87,0,76,83,82,87,0,76,83,76,87,0,82,79,76,87,0,82,79,82,87,0,82,79,88,76,87,0,82,79,88,82,87,0,77,79,86,69,50,67,0,77,79,86,69,67,50,0,67,65,83,0,67,65,83,50,0,77,85,76,76,0,68,73,86,76,0,66,70,84,83,84,0,66,70,69,88,84,85,0,66,70,67,72,71,0,66,70,69,88,84,83,0,66,70,67,76,82,0,66,70,70,70,79,0,66,70,83,69,84,0,66,70,73,78,83,0,80,65,67,75,0,85,78,80,75,0,84,65,83,0,66,75,80,84,0,67,65,76,76,77,0,82,84,77,0,77,79,86,69,83,0,70,80,80,0,70,68,66,99,99,0,70,83,99,99,0,70,66,99,99,0,70,83,65,86,69,0,70,82,69,83,84,79,82,69,0,67,73,78,86,76,0,67,73,78,86,80,0,67,73,78,86,65,0,67,80,85,83,72,76,0,67,80,85,83,72,80,0,67,80,85,83,72,65,0,77,79,86,69,49,54,0,69,77,85,76,79,80,0,77,77,85,79,80,0,73,110,115,116,114,117,99,116,105,111,110,32,37,115,32,111,118,101,114,102,108,111,119,10,0,68,111,117,98,108,101,32,109,97,116,99,104,58,32,37,120,58,32,37,115,10,0,68,114,101,103,0,65,114,101,103,0,65,105,110,100,0,65,112,100,105,0,65,105,112,105,0,65,100,49,54,0,65,100,56,114,0,97,98,115,119,0,97,98,115,108,0,80,67,49,54,0,80,67,56,114,0,73,109,109,100,0,37,46,49,54,101,0,37,108,101,0,79,82,83,82,46,66,32,32,35,49,0,79,82,83,82,46,87,32,32,35,49,0,67,72,75,50,46,122,32,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,65,112,100,105,44,73,109,109,100,93,0,79,82,46,122,32,32,32,32,35,122,44,100,91,33,65,114,101,103,93,0,65,78,68,83,82,46,66,32,35,49,0,65,78,68,83,82,46,87,32,35,49,0,65,78,68,46,122,32,32,32,35,122,44,100,91,33,65,114,101,103,93,0,83,85,66,46,122,32,32,32,35,122,44,100,91,33,65,114,101,103,93,0,65,68,68,46,122,32,32,32,35,122,44,100,91,33,65,114,101,103,93,0,67,65,76,76,77,32,32,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,65,112,100,105,44,73,109,109,100,93,0,82,84,77,32,32,32,32,32,115,91,68,114,101,103,44,65,114,101,103,93,0,66,84,83,84,32,32,32,32,35,49,44,115,91,33,65,114,101,103,93,0,66,67,72,71,32,32,32,32,35,49,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,66,67,76,82,32,32,32,32,35,49,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,66,83,69,84,32,32,32,32,35,49,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,69,79,82,83,82,46,66,32,35,49,0,69,79,82,83,82,46,87,32,35,49,0,69,79,82,46,122,32,32,32,35,122,44,100,91,33,65,114,101,103,93,0,67,77,80,46,122,32,32,32,35,122,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,67,65,83,46,66,32,32,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,67,65,83,46,87,32,32,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,67,65,83,50,46,87,32,32,35,50,0,77,79,86,69,83,46,122,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,67,65,83,46,76,32,32,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,67,65,83,50,46,76,32,32,35,50,0,77,86,80,77,82,46,87,32,100,91,65,114,101,103,45,65,100,49,54,93,44,68,114,0,77,86,80,77,82,46,76,32,100,91,65,114,101,103,45,65,100,49,54,93,44,68,114,0,77,86,80,82,77,46,87,32,68,114,44,100,91,65,114,101,103,45,65,100,49,54,93,0,77,86,80,82,77,46,76,32,68,114,44,100,91,65,114,101,103,45,65,100,49,54,93,0,66,84,83,84,32,32,32,32,68,114,44,115,91,33,65,114,101,103,93,0,66,67,72,71,32,32,32,32,68,114,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,66,67,76,82,32,32,32,32,68,114,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,66,83,69,84,32,32,32,32,68,114,44,115,91,33,65,114,101,103,44,73,109,109,100,93,0,77,79,86,69,46,66,32,32,115,44,100,91,33,65,114,101,103,93,0,77,79,86,69,65,46,76,32,115,44,100,91,65,114,101,103,93,0,77,79,86,69,46,76,32,32,115,44,100,91,33,65,114,101,103,93,0,77,79,86,69,65,46,87,32,115,44,100,91,65,114,101,103,93,0,77,79,86,69,46,87,32,32,115,44,100,91,33,65,114,101,103,93,0,78,69,71,88,46,122,32,32,100,91,33,65,114,101,103,93,0,77,86,83,82,50,46,87,32,100,91,33,65,114,101,103,93,0,67,76,82,46,122,32,32,32,100,91,33,65,114,101,103,93,0,77,86,83,82,50,46,66,32,100,91,33,65,114,101,103,93,0,78,69,71,46,122,32,32,32,100,91,33,65,114,101,103,93,0,77,86,50,83,82,46,66,32,115,91,33,65,114,101,103,93,0,78,79,84,46,122,32,32,32,100,91,33,65,114,101,103,93,0,77,86,50,83,82,46,87,32,115,91,33,65,114,101,103,93,0,76,73,78,75,46,76,32,32,65,114,44,35,50,0,78,66,67,68,46,66,32,32,100,91,33,65,114,101,103,93,0,66,75,80,84,32,32,32,32,35,107,0,83,87,65,80,46,87,32,32,115,91,68,114,101,103,93,0,80,69,65,46,76,32,32,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,65,112,100,105,44,73,109,109,100,93,0,69,88,84,46,87,32,32,32,100,91,68,114,101,103,93,0,77,86,77,76,69,46,87,32,35,49,44,100,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,93,0,69,88,84,46,76,32,32,32,100,91,68,114,101,103,93,0,77,86,77,76,69,46,76,32,35,49,44,100,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,93,0,69,88,84,46,66,32,32,32,100,91,68,114,101,103,93,0,84,83,84,46,122,32,32,32,115,0,84,65,83,46,66,32,32,32,100,91,33,65,114,101,103,93,0,73,76,76,69,71,65,76,0,77,85,76,76,46,76,32,32,35,49,44,115,91,33,65,114,101,103,93,0,68,73,86,76,46,76,32,32,35,49,44,115,91,33,65,114,101,103,93,0,77,86,77,69,76,46,87,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,65,112,100,105,44,73,109,109,100,93,0,77,86,77,69,76,46,76,32,35,49,44,115,91,33,68,114,101,103,44,65,114,101,103,44,65,112,100,105,44,73,109,109,100,93,0,84,82,65,80,32,32,32,32,35,74,0,76,73,78,75,46,87,32,32,65,114,44,35,49,0,85,78,76,75,46,76,32,32,65,114,0,77,86,82,50,85,83,80,46,76,32,65,114,0,77,86,85,83,80,50,82,46,76,32,65,114,0,82,69,83,69,84,0,78,79,80,0,83,84,79,80,32,32,32,32,35,49,0,82,84,69,0,82,84,68,32,32,32,32,32,35,49,0,82,84,83,0,84,82,65,80,86,0,82,84,82,0,77,79,86,69,67,50,32,32,35,49,0,77,79,86,69,50,67,32,32,35,49,0,74,83,82,46,76,32,32,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,65,112,100,105,44,73,109,109,100,93,0,67,72,75,46,76,32,32,32,115,91,33,65,114,101,103,93,44,68,114,0,67,72,75,46,87,32,32,32,115,91,33,65,114,101,103,93,44,68,114,0,74,77,80,46,76,32,32,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,65,112,100,105,44,73,109,109,100,93,0,76,69,65,46,76,32,32,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,65,112,100,105,44,73,109,109,100,93,44,65,114,0,65,68,68,65,46,87,32,32,35,106,44,100,91,65,114,101,103,93,0,65,68,68,65,46,76,32,32,35,106,44,100,91,65,114,101,103,93,0,65,68,68,46,122,32,32,32,35,106,44,100,91,33,65,114,101,103,93,0,83,85,66,65,46,87,32,32,35,106,44,100,91,65,114,101,103,93,0,83,85,66,65,46,76,32,32,35,106,44,100,91,65,114,101,103,93,0,83,85,66,46,122,32,32,32,35,106,44,100,91,33,65,114,101,103,93,0,68,66,99,99,46,87,32,32,68,114,44,35,49,0,83,99,99,46,66,32,32,32,100,91,33,65,114,101,103,93,0,84,82,65,80,99,99,32,32,35,49,0,84,82,65,80,99,99,32,32,35,50,0,84,82,65,80,99,99,0,66,83,82,46,87,32,32,32,35,49,0,66,83,82,46,66,32,32,32,35,105,0,66,83,82,46,76,32,32,32,35,50,0,66,99,99,46,87,32,32,32,35,49,0,66,99,99,46,66,32,32,32,35,105,0,66,99,99,46,76,32,32,32,35,50,0,77,79,86,69,46,76,32,32,35,105,44,68,114,0,79,82,46,122,32,32,32,32,115,91,33,65,114,101,103,93,44,68,114,0,68,73,86,85,46,87,32,32,115,91,33,65,114,101,103,93,44,68,114,0,83,66,67,68,46,66,32,32,100,91,68,114,101,103,93,44,68,114,0,83,66,67,68,46,66,32,32,100,91,65,114,101,103,45,65,112,100,105,93,44,65,114,112,0,79,82,46,122,32,32,32,32,68,114,44,100,91,33,65,114,101,103,44,68,114,101,103,93,0,80,65,67,75,32,32,32,32,100,91,68,114,101,103,93,44,68,114,0,80,65,67,75,32,32,32,32,100,91,65,114,101,103,45,65,112,100,105,93,44,65,114,112,0,85,78,80,75,32,32,32,32,100,91,68,114,101,103,93,44,68,114,0,85,78,80,75,32,32,32,32,100,91,65,114,101,103,45,65,112,100,105,93,44,65,114,112,0,68,73,86,83,46,87,32,32,115,91,33,65,114,101,103,93,44,68,114,0,83,85,66,46,122,32,32,32,115,44,68,114,0,83,85,66,65,46,87,32,32,115,44,65,114,0,83,85,66,88,46,122,32,32,100,91,68,114,101,103,93,44,68,114,0,83,85,66,88,46,122,32,32,100,91,65,114,101,103,45,65,112,100,105,93,44,65,114,112,0,83,85,66,46,122,32,32,32,68,114,44,100,91,33,65,114,101,103,44,68,114,101,103,93,0,83,85,66,65,46,76,32,32,115,44,65,114,0,67,77,80,46,122,32,32,32,115,44,68,114,0,67,77,80,65,46,87,32,32,115,44,65,114,0,67,77,80,65,46,76,32,32,115,44,65,114,0,67,77,80,77,46,122,32,32,100,91,65,114,101,103,45,65,105,112,105,93,44,65,114,80,0,69,79,82,46,122,32,32,32,68,114,44,100,91,33,65,114,101,103,93,0,65,78,68,46,122,32,32,32,115,91,33,65,114,101,103,93,44,68,114,0,77,85,76,85,46,87,32,32,115,91,33,65,114,101,103,93,44,68,114,0,65,66,67,68,46,66,32,32,100,91,68,114,101,103,93,44,68,114,0,65,66,67,68,46,66,32,32,100,91,65,114,101,103,45,65,112,100,105,93,44,65,114,112,0,65,78,68,46,122,32,32,32,68,114,44,100,91,33,65,114,101,103,44,68,114,101,103,93,0,69,88,71,46,76,32,32,32,68,114,44,100,91,68,114,101,103,93,0,69,88,71,46,76,32,32,32,65,114,44,100,91,65,114,101,103,93,0,69,88,71,46,76,32,32,32,68,114,44,100,91,65,114,101,103,93,0,77,85,76,83,46,87,32,32,115,91,33,65,114,101,103,93,44,68,114,0,65,68,68,46,122,32,32,32,115,44,68,114,0,65,68,68,65,46,87,32,32,115,44,65,114,0,65,68,68,88,46,122,32,32,100,91,68,114,101,103,93,44,68,114,0,65,68,68,88,46,122,32,32,100,91,65,114,101,103,45,65,112,100,105,93,44,65,114,112,0,65,68,68,46,122,32,32,32,68,114,44,100,91,33,65,114,101,103,44,68,114,101,103,93,0,65,68,68,65,46,76,32,32,115,44,65,114,0,65,83,102,46,122,32,32,32,35,106,44,68,82,0,76,83,102,46,122,32,32,32,35,106,44,68,82,0,82,79,88,102,46,122,32,32,35,106,44,68,82,0,82,79,102,46,122,32,32,32,35,106,44,68,82,0,65,83,102,46,122,32,32,32,68,114,44,68,82,0,76,83,102,46,122,32,32,32,68,114,44,68,82,0,82,79,88,102,46,122,32,32,68,114,44,68,82,0,82,79,102,46,122,32,32,32,68,114,44,68,82,0,65,83,102,87,46,87,32,32,100,91,33,68,114,101,103,44,65,114,101,103,93,0,76,83,102,87,46,87,32,32,100,91,33,68,114,101,103,44,65,114,101,103,93,0,82,79,88,102,87,46,87,32,100,91,33,68,114,101,103,44,65,114,101,103,93,0,82,79,102,87,46,87,32,32,100,91,33,68,114,101,103,44,65,114,101,103,93,0,66,70,84,83,84,32,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,93,0,66,70,69,88,84,85,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,93,0,66,70,67,72,71,32,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,66,70,69,88,84,83,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,93,0,66,70,67,76,82,32,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,66,70,70,70,79,32,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,93,0,66,70,83,69,84,32,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,66,70,73,78,83,32,32,32,35,49,44,115,91,33,65,114,101,103,44,65,112,100,105,44,65,105,112,105,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,70,80,80,32,32,32,32,32,32,35,49,44,115,0,70,68,66,99,99,32,32,32,32,35,49,44,115,91,65,114,101,103,45,68,114,101,103,93,0,70,83,99,99,32,32,32,32,32,35,49,44,115,91,33,65,114,101,103,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,70,84,82,65,80,99,99,32,32,35,49,0,70,84,82,65,80,99,99,32,32,35,50,0,70,84,82,65,80,99,99,0,70,66,99,99,32,32,32,32,32,35,75,44,35,49,0,70,66,99,99,32,32,32,32,32,35,75,44,35,50,0,70,83,65,86,69,32,32,32,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,105,112,105,44,73,109,109,100,44,80,67,56,114,44,80,67,49,54,93,0,70,82,69,83,84,79,82,69,32,115,91,33,68,114,101,103,44,65,114,101,103,44,65,112,100,105,44,73,109,109,100,93,0,77,77,85,79,80,32,32,32,32,35,105,44,115,0,67,73,78,86,76,32,32,32,32,35,112,44,65,114,0,67,73,78,86,80,32,32,32,32,35,112,44,65,114,0,67,73,78,86,65,32,32,32,32,35,112,0,67,80,85,83,72,76,32,32,32,35,112,44,65,114,0,67,80,85,83,72,80,32,32,32,35,112,44,65,114,0,67,80,85,83,72,65,32,32,32,35,112,0,77,79,86,69,49,54,32,32,32,65,114,80,44,65,120,80,0,77,79,86,69,49,54,32,32,32,115,91,68,114,101,103,45,65,105,112,105,93,44,76,0,77,79,86,69,49,54,32,32,32,76,44,100,91,65,114,101,103,45,65,105,112,105,93,0,77,79,86,69,49,54,32,32,32,115,91,65,105,110,100,93,44,76,0,77,79,86,69,49,54,32,32,32,76,44,100,91,65,105,112,105,45,65,105,110,100,93,0,69,77,85,76,79,80,95,82,69,84,85,82,78,0,69,77,85,76,79,80,32,32,32,35,69,0,17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,78,65,78,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116,32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,47,112,114,111,99,47,115,101,108,102,47,102,100,47,0,105,110,102,105,110,105,116,121,0,110,97,110,0,114,119,97,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97,117,103,104,116,0,83,116,57,101,120,99,101,112,116,105,111,110,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,83,116,57,116,121,112,101,95,105,110,102,111,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,83,116,49,49,108,111,103,105,99,95,101,114,114,111,114,0,83,116,49,50,108,101,110,103,116,104,95,101,114,114,111,114,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,32,99,111,110,115,116,0,32,118,111,108,97,116,105,108,101,0,32,114,101,115,116,114,105,99,116,0,32,99,111,109,112,108,101,120,0,32,105,109,97,103,105,110,97,114,121,0,32,91,0,32,40,0,41,0,40,0,38,38,0,111,98,106,99,95,111,98,106,101,99,116,60,0,42,0,38,0,111,98,106,99,112,114,111,116,111,0,32,0,60,0,62,0,32,118,101,99,116,111,114,91,0,93,0,112,105,120,101,108,32,118,101,99,116,111,114,91,0,38,61,0,61,0,44,0,126,0,58,58,0,100,101,108,101,116,101,91,93,32,0,100,101,108,101,116,101,32,0,47,0,47,61,0,94,0,94,61,0,61,61,0,62,61,0,41,91,0,60,61,0,60,60,0,60,60,61,0,45,0,45,61,0,42,61,0,45,45,0,41,45,45,0,33,61,0,33,0,124,124,0,124,0,124,61,0,45,62,42,0,43,0,43,61,0,43,43,0,41,43,43,0,41,32,63,32,40,0,41,32,58,32,40,0,37,0,37,61,0,62,62,0,62,62,61,0,116,104,114,111,119,0,116,104,114,111,119,32,0,116,121,112,101,105,100,40,0,115,105,122,101,111,102,46,46,46,40,0,44,32,0,115,105,122,101,111,102,32,40,0,115,116,97,116,105,99,95,99,97,115,116,60,0,62,40,0,114,101,105,110,116,101,114,112,114,101,116,95,99,97,115,116,60,0,45,62,0,110,111,101,120,99,101,112,116,32,40,0,91,93,32,0,41,32,0,46,0,46,42,0,115,116,100,58,58,0,111,112,101,114,97,116,111,114,38,38,0,111,112,101,114,97,116,111,114,38,0,111,112,101,114,97,116,111,114,38,61,0,111,112,101,114,97,116,111,114,61,0,111,112,101,114,97,116,111,114,40,41,0,111,112,101,114,97,116,111,114,44,0,111,112,101,114,97,116,111,114,126,0,111,112,101,114,97,116,111,114,32,0,111,112,101,114,97,116,111,114,32,100,101,108,101,116,101,91,93,0,111,112,101,114,97,116,111,114,42,0,111,112,101,114,97,116,111,114,47,0,111,112,101,114,97,116,111,114,47,61,0,111,112,101,114,97,116,111,114,94,0,111,112,101,114,97,116,111,114,94,61,0,111,112,101,114,97,116,111,114,61,61,0,111,112,101,114,97,116,111,114,62,61,0,111,112,101,114,97,116,111,114,62,0,111,112,101,114,97,116,111,114,91,93,0,111,112,101,114,97,116,111,114,60,61,0,111,112,101,114,97,116,111,114,34,34,32,0,111,112,101,114,97,116,111,114,60,60,0,111,112,101,114,97,116,111,114,60,60,61,0,111,112,101,114,97,116,111,114,60,0,111,112,101,114,97,116,111,114,45,0,111,112,101,114,97,116,111,114,45,61,0,111,112,101,114,97,116,111,114,42,61,0,111,112,101,114,97,116,111,114,45,45,0,111,112,101,114,97,116,111,114,32,110,101,119,91,93,0,111,112,101,114,97,116,111,114,33,61,0,111,112,101,114,97,116,111,114,33,0,111,112,101,114,97,116,111,114,32,110,101,119,0,111,112,101,114,97,116,111,114,124,124,0,111,112,101,114,97,116,111,114,124,0,111,112,101,114,97,116,111,114,124,61,0,111,112,101,114,97,116,111,114,45,62,42,0,111,112,101,114,97,116,111,114,43,0,111,112,101,114,97,116,111,114,43,61,0,111,112,101,114,97,116,111,114,43,43,0,111,112,101,114,97,116,111,114,45,62,0,111,112,101,114,97,116,111,114,63,0,111,112,101,114,97,116,111,114,37,0,111,112,101,114,97,116,111,114,37,61,0,111,112,101,114,97,116,111,114,62,62,0,111,112,101,114,97,116,111,114,62,62,61,0,111,112,101,114,97,116,111,114,32,100,101,108,101,116,101,0,39,117,110,110,97,109,101,100,0,39,108,97,109,98,100,97,39,40,0,115,116,100,58,58,115,116,114,105,110,103,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,44,32,115,116,100,58,58,97,108,108,111,99,97,116,111,114,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,115,116,114,105,110,103,0,115,116,100,58,58,105,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,105,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,105,115,116,114,101,97,109,0,115,116,100,58,58,111,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,111,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,111,115,116,114,101,97,109,0,115,116,100,58,58,105,111,115,116,114,101,97,109,0,115,116,100,58,58,98,97,115,105,99,95,105,111,115,116,114,101,97,109,60,99,104,97,114,44,32,115,116,100,58,58,99,104,97,114,95,116,114,97,105,116,115,60,99,104,97,114,62,32,62,0,98,97,115,105,99,95,105,111,115,116,114,101,97,109,0,100,121,110,97,109,105,99,95,99,97,115,116,60,0,41,40,0,99,111,110,115,116,95,99,97,115,116,60,0,97,108,105,103,110,111,102,32,40,0,102,112,0,119,99,104,97,114,95,116,0,102,97,108,115,101,0,116,114,117,101,0,99,104,97,114,0,115,105,103,110,101,100,32,99,104,97,114,0,117,110,115,105,103,110,101,100,32,99,104,97,114,0,115,104,111,114,116,0,117,110,115,105,103,110,101,100,32,115,104,111,114,116,0,117,0,108,0,117,108,0,108,108,0,117,108,108,0,95,95,105,110,116,49,50,56,0,117,110,115,105,103,110,101,100,32,95,95,105,110,116,49,50,56,0,37,76,97,76,0,37,97,0,37,97,102,0,100,101,99,108,116,121,112,101,40,0,115,116,100,58,58,97,108,108,111,99,97,116,111,114,0,115,116,100,58,58,98,97,115,105,99,95,115,116,114,105,110,103,0,58,58,115,116,114,105,110,103,32,108,105,116,101,114,97,108,0,115,116,100,0,95,71,76,79,66,65,76,95,95,78,0,40,97,110,111,110,121,109,111,117,115,32,110,97,109,101,115,112,97,99,101,41,0,32,62,0,84,95,0,105,100,0,58,58,42,0,32,38,0,32,38,38,0,32,91,93,0,118,111,105,100,0,98,111,111,108,0,105,110,116,0,117,110,115,105,103,110,101,100,32,105,110,116,0,108,111,110,103,0,117,110,115,105,103,110,101,100,32,108,111,110,103,0,108,111,110,103,32,108,111,110,103,0,102,108,111,97,116,0,108,111,110,103,32,100,111,117,98,108,101,0,95,95,102,108,111,97,116,49,50,56,0,46,46,46,0,100,101,99,105,109,97,108,54,52,0,100,101,99,105,109,97,108,49,50,56,0,100,101,99,105,109,97,108,51,50,0,100,101,99,105,109,97,108,49,54,0,99,104,97,114,51,50,95,116,0,99,104,97,114,49,54,95,116,0,97,117,116,111,0,115,116,100,58,58,110,117,108,108,112,116,114,95,116,0,100,111,117,98,108,101,0,117,110,115,105,103,110,101,100,32,108,111,110,103,32,108,111,110,103,0,95,98,108,111,99,107,95,105,110,118,111,107,101,0,105,110,118,111,99,97,116,105,111,110,32,102,117,110,99,116,105,111,110,32,102,111,114,32,98,108,111,99,107,32,105,110,32,0,118,116,97,98,108,101,32,102,111,114,32,0,86,84,84,32,102,111,114,32,0,116,121,112,101,105,110,102,111,32,102,111,114,32,0,116,121,112,101,105,110,102,111,32,110,97,109,101,32,102,111,114,32,0,99,111,118,97,114,105,97,110,116,32,114,101,116,117,114,110,32,116,104,117,110,107,32,116,111,32,0,99,111,110,115,116,114,117,99,116,105,111,110,32,118,116,97,98,108,101,32,102,111,114,32,0,45,105,110,45,0,118,105,114,116,117,97,108,32,116,104,117,110,107,32,116,111,32,0,110,111,110,45,118,105,114,116,117,97,108,32,116,104,117,110,107,32,116,111,32,0,103,117,97,114,100,32,118,97,114,105,97,98,108,101,32,102,111,114,32,0,114,101,102,101,114,101,110,99,101,32,116,101,109,112,111,114,97,114,121,32,102,111,114,32,0], "i8", ALLOC_NONE, GLOBAL_BASE);





/* no memory initializer */
var tempDoublePtr = STATICTOP; STATICTOP += 16;

assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

}

function copyTempDouble(ptr) {

  HEAP8[tempDoublePtr] = HEAP8[ptr];

  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];

  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];

  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];

  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];

  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];

  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];

  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];

}

// {{PRE_LIBRARY}}


  
  
  
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};
  
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"File locking deadlock error",36:"File or path name too long",37:"No record locks available",38:"Function not implemented",39:"Directory not empty",40:"Too many symbolic links",42:"No message of desired type",43:"Identifier removed",44:"Channel number out of range",45:"Level 2 not synchronized",46:"Level 3 halted",47:"Level 3 reset",48:"Link number out of range",49:"Protocol driver not attached",50:"No CSI structure available",51:"Level 2 halted",52:"Invalid exchange",53:"Invalid request descriptor",54:"Exchange full",55:"No anode",56:"Invalid request code",57:"Invalid slot",59:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",72:"Multihop attempted",73:"Cross mount point (not really error)",74:"Trying to read unreadable message",75:"Value too large for defined data type",76:"Given log. name not unique",77:"f.d. invalid for this operation",78:"Remote address changed",79:"Can   access a needed shared lib",80:"Accessing a corrupted shared lib",81:".lib section in a.out corrupted",82:"Attempting to link in too many libs",83:"Attempting to exec a shared library",84:"Illegal byte sequence",86:"Streams pipe error",87:"Too many users",88:"Socket operation on non-socket",89:"Destination address required",90:"Message too long",91:"Protocol wrong type for socket",92:"Protocol not available",93:"Unknown protocol",94:"Socket type not supported",95:"Not supported",96:"Protocol family not supported",97:"Address family not supported by protocol family",98:"Address already in use",99:"Address not available",100:"Network interface is not configured",101:"Network is unreachable",102:"Connection reset by network",103:"Connection aborted",104:"Connection reset by peer",105:"No buffer space available",106:"Socket is already connected",107:"Socket is not connected",108:"Can't send after socket shutdown",109:"Too many references",110:"Connection timed out",111:"Connection refused",112:"Host is down",113:"Host is unreachable",114:"Socket already connected",115:"Connection already in progress",116:"Stale file handle",122:"Quota exceeded",123:"No medium (in tape drive)",125:"Operation canceled",130:"Previous owner died",131:"State not recoverable"};
  
  function ___setErrNo(value) {
      if (Module['___errno_location']) HEAP32[((Module['___errno_location']())>>2)]=value;
      else Module.printErr('failed to set errno from JS');
      return value;
    }
  
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up; up--) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var lastSlash = path.lastIndexOf('/');
        if (lastSlash === -1) return path;
        return path.substr(lastSlash+1);
      },extname:function (path) {
        return PATH.splitPath(path)[3];
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join('/'));
      },join2:function (l, r) {
        return PATH.normalize(l + '/' + r);
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            return ''; // an invalid portion invalidates the whole thing
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  
  var TTY={ttys:[],init:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // currently, FS.init does not distinguish if process.stdin is a file or TTY
        //   // device, it always assumes it's a TTY device. because of this, we're forcing
        //   // process.stdin to UTF8 encoding to at least make stdin reading compatible
        //   // with text files until FS.init can be refactored.
        //   process['stdin']['setEncoding']('utf8');
        // }
      },shutdown:function () {
        // https://github.com/kripken/emscripten/pull/1555
        // if (ENVIRONMENT_IS_NODE) {
        //   // inolen: any idea as to why node -e 'process.stdin.read()' wouldn't exit immediately (with process.stdin being a tty)?
        //   // isaacs: because now it's reading from the stream, you've expressed interest in it, so that read() kicks off a _read() which creates a ReadReq operation
        //   // inolen: I thought read() in that case was a synchronous operation that just grabbed some amount of buffered data if it exists?
        //   // isaacs: it is. but it also triggers a _read() call, which calls readStart() on the handle
        //   // isaacs: do process.stdin.pause() and i'd think it'd probably close the pending call
        //   process['stdin']['pause']();
        // }
      },register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          stream.tty.ops.flush(stream.tty);
        },flush:function (stream) {
          stream.tty.ops.flush(stream.tty);
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              // we will read data by chunks of BUFSIZE
              var BUFSIZE = 256;
              var buf = new Buffer(BUFSIZE);
              var bytesRead = 0;
  
              var isPosixPlatform = (process.platform != 'win32'); // Node doesn't offer a direct check, so test by exclusion
  
              var fd = process.stdin.fd;
              if (isPosixPlatform) {
                // Linux and Mac cannot use process.stdin.fd (which isn't set up as sync)
                var usingDevice = false;
                try {
                  fd = fs.openSync('/dev/stdin', 'r');
                  usingDevice = true;
                } catch (e) {}
              }
  
              try {
                bytesRead = fs.readSync(fd, buf, 0, BUFSIZE, null);
              } catch(e) {
                // Cross-platform differences: on Windows, reading EOF throws an exception, but on other OSes,
                // reading EOF returns 0. Uniformize behavior by treating the EOF exception to return 0.
                if (e.toString().indexOf('EOF') != -1) bytesRead = 0;
                else throw e;
              }
  
              if (usingDevice) { fs.closeSync(fd); }
              if (bytesRead > 0) {
                result = buf.slice(0, bytesRead).toString('utf-8');
              } else {
                result = null;
              }
  
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val); // val == 0 would cut text output off in the middle.
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['print'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          } else {
            if (val != 0) tty.output.push(val);
          }
        },flush:function (tty) {
          if (tty.output && tty.output.length > 0) {
            Module['printErr'](UTF8ArrayToString(tty.output, 0));
            tty.output = [];
          }
        }}};
  
  var MEMFS={ops_table:null,mount:function (mount) {
        return MEMFS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createNode:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (!MEMFS.ops_table) {
          MEMFS.ops_table = {
            dir: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                lookup: MEMFS.node_ops.lookup,
                mknod: MEMFS.node_ops.mknod,
                rename: MEMFS.node_ops.rename,
                unlink: MEMFS.node_ops.unlink,
                rmdir: MEMFS.node_ops.rmdir,
                readdir: MEMFS.node_ops.readdir,
                symlink: MEMFS.node_ops.symlink
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek
              }
            },
            file: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: {
                llseek: MEMFS.stream_ops.llseek,
                read: MEMFS.stream_ops.read,
                write: MEMFS.stream_ops.write,
                allocate: MEMFS.stream_ops.allocate,
                mmap: MEMFS.stream_ops.mmap,
                msync: MEMFS.stream_ops.msync
              }
            },
            link: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr,
                readlink: MEMFS.node_ops.readlink
              },
              stream: {}
            },
            chrdev: {
              node: {
                getattr: MEMFS.node_ops.getattr,
                setattr: MEMFS.node_ops.setattr
              },
              stream: FS.chrdev_stream_ops
            }
          };
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = MEMFS.ops_table.dir.node;
          node.stream_ops = MEMFS.ops_table.dir.stream;
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = MEMFS.ops_table.file.node;
          node.stream_ops = MEMFS.ops_table.file.stream;
          node.usedBytes = 0; // The actual number of bytes used in the typed array, as opposed to contents.length which gives the whole capacity.
          // When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
          // for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
          // penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
          node.contents = null; 
        } else if (FS.isLink(node.mode)) {
          node.node_ops = MEMFS.ops_table.link.node;
          node.stream_ops = MEMFS.ops_table.link.stream;
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = MEMFS.ops_table.chrdev.node;
          node.stream_ops = MEMFS.ops_table.chrdev.stream;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },getFileDataAsRegularArray:function (node) {
        if (node.contents && node.contents.subarray) {
          var arr = [];
          for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
          return arr; // Returns a copy of the original data.
        }
        return node.contents; // No-op, the file contents are already in a JS array. Return as-is.
      },getFileDataAsTypedArray:function (node) {
        if (!node.contents) return new Uint8Array;
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes); // Make sure to not return excess unused bytes.
        return new Uint8Array(node.contents);
      },expandFileStorage:function (node, newCapacity) {
        // If we are asked to expand the size of a file that already exists, revert to using a standard JS array to store the file
        // instead of a typed array. This makes resizing the array more flexible because we can just .push() elements at the back to
        // increase the size.
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
          node.contents = MEMFS.getFileDataAsRegularArray(node);
          node.usedBytes = node.contents.length; // We might be writing to a lazy-loaded file which had overridden this property, so force-reset it.
        }
  
        if (!node.contents || node.contents.subarray) { // Keep using a typed array if creating a new storage, or if old one was a typed array as well.
          var prevCapacity = node.contents ? node.contents.length : 0;
          if (prevCapacity >= newCapacity) return; // No need to expand, the storage was already large enough.
          // Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
          // For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
          // avoid overshooting the allocation cap by a very large margin.
          var CAPACITY_DOUBLING_MAX = 1024 * 1024;
          newCapacity = Math.max(newCapacity, (prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2.0 : 1.125)) | 0);
          if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256); // At minimum allocate 256b for each file when expanding.
          var oldContents = node.contents;
          node.contents = new Uint8Array(newCapacity); // Allocate new storage.
          if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0); // Copy old data over to the new storage.
          return;
        }
        // Not using a typed array to back the file storage. Use a standard JS array instead.
        if (!node.contents && newCapacity > 0) node.contents = [];
        while (node.contents.length < newCapacity) node.contents.push(0);
      },resizeFileStorage:function (node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
          node.contents = null; // Fully decommit when requesting a resize to zero.
          node.usedBytes = 0;
          return;
        }
        if (!node.contents || node.contents.subarray) { // Resize a typed array if that is being used as the backing store.
          var oldContents = node.contents;
          node.contents = new Uint8Array(new ArrayBuffer(newSize)); // Allocate new storage.
          if (oldContents) {
            node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes))); // Copy old data over to the new storage.
          }
          node.usedBytes = newSize;
          return;
        }
        // Backing with a JS array.
        if (!node.contents) node.contents = [];
        if (node.contents.length > newSize) node.contents.length = newSize;
        else while (node.contents.length < newSize) node.contents.push(0);
        node.usedBytes = newSize;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.usedBytes;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.resizeFileStorage(node, attr.size);
          }
        },lookup:function (parent, name) {
          throw FS.genericErrors[ERRNO_CODES.ENOENT];
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.createNode(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
          old_node.parent = new_dir;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.createNode(parent, newname, 511 /* 0777 */ | 40960, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          if (position >= stream.node.usedBytes) return 0;
          var size = Math.min(stream.node.usedBytes - position, length);
          assert(size >= 0);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else {
            for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i];
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          if (!length) return 0;
          var node = stream.node;
          node.timestamp = Date.now();
  
          if (buffer.subarray && (!node.contents || node.contents.subarray)) { // This write is from a typed array to a typed array?
            if (canOwn) {
              assert(position === 0, 'canOwn must imply no weird position inside the file');
              node.contents = buffer.subarray(offset, offset + length);
              node.usedBytes = length;
              return length;
            } else if (node.usedBytes === 0 && position === 0) { // If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
              node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
              node.usedBytes = length;
              return length;
            } else if (position + length <= node.usedBytes) { // Writing to an already allocated and used subrange of the file?
              node.contents.set(buffer.subarray(offset, offset + length), position);
              return length;
            }
          }
  
          // Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
          MEMFS.expandFileStorage(node, position+length);
          if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position); // Use typed array write if available.
          else {
            for (var i = 0; i < length; i++) {
             node.contents[position + i] = buffer[offset + i]; // Or fall back to manual write if not.
            }
          }
          node.usedBytes = Math.max(node.usedBytes, position+length);
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.usedBytes;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.expandFileStorage(stream.node, offset + length);
          stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 2) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < stream.node.usedBytes) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        },msync:function (stream, buffer, offset, length, mmapFlags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          if (mmapFlags & 2) {
            // MAP_PRIVATE calls need not to be synced back to underlying fs
            return 0;
          }
  
          var bytesWritten = MEMFS.stream_ops.write(stream, buffer, 0, length, offset, false);
          // should we check if bytesWritten and length are the same?
          return 0;
        }}};
  
  var IDBFS={dbs:{},indexedDB:function () {
        if (typeof indexedDB !== 'undefined') return indexedDB;
        var ret = null;
        if (typeof window === 'object') ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        assert(ret, 'IDBFS used, but indexedDB not supported');
        return ret;
      },DB_VERSION:21,DB_STORE_NAME:"FILE_DATA",mount:function (mount) {
        // reuse all of the core MEMFS functionality
        return MEMFS.mount.apply(null, arguments);
      },syncfs:function (mount, populate, callback) {
        IDBFS.getLocalSet(mount, function(err, local) {
          if (err) return callback(err);
  
          IDBFS.getRemoteSet(mount, function(err, remote) {
            if (err) return callback(err);
  
            var src = populate ? remote : local;
            var dst = populate ? local : remote;
  
            IDBFS.reconcile(src, dst, callback);
          });
        });
      },getDB:function (name, callback) {
        // check the cache first
        var db = IDBFS.dbs[name];
        if (db) {
          return callback(null, db);
        }
  
        var req;
        try {
          req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION);
        } catch (e) {
          return callback(e);
        }
        if (!req) {
          return callback("Unable to connect to IndexedDB");
        }
        req.onupgradeneeded = function(e) {
          var db = e.target.result;
          var transaction = e.target.transaction;
  
          var fileStore;
  
          if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
            fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME);
          } else {
            fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME);
          }
  
          if (!fileStore.indexNames.contains('timestamp')) {
            fileStore.createIndex('timestamp', 'timestamp', { unique: false });
          }
        };
        req.onsuccess = function() {
          db = req.result;
  
          // add to the cache
          IDBFS.dbs[name] = db;
          callback(null, db);
        };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },getLocalSet:function (mount, callback) {
        var entries = {};
  
        function isRealDir(p) {
          return p !== '.' && p !== '..';
        };
        function toAbsolute(root) {
          return function(p) {
            return PATH.join2(root, p);
          }
        };
  
        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
  
        while (check.length) {
          var path = check.pop();
          var stat;
  
          try {
            stat = FS.stat(path);
          } catch (e) {
            return callback(e);
          }
  
          if (FS.isDir(stat.mode)) {
            check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)));
          }
  
          entries[path] = { timestamp: stat.mtime };
        }
  
        return callback(null, { type: 'local', entries: entries });
      },getRemoteSet:function (mount, callback) {
        var entries = {};
  
        IDBFS.getDB(mount.mountpoint, function(err, db) {
          if (err) return callback(err);
  
          try {
            var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readonly');
            transaction.onerror = function(e) {
              callback(this.error);
              e.preventDefault();
            };
  
            var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
            var index = store.index('timestamp');
  
            index.openKeyCursor().onsuccess = function(event) {
              var cursor = event.target.result;
  
              if (!cursor) {
                return callback(null, { type: 'remote', db: db, entries: entries });
              }
  
              entries[cursor.primaryKey] = { timestamp: cursor.key };
  
              cursor.continue();
            };
          } catch (e) {
            return callback(e);
          }
        });
      },loadLocalEntry:function (path, callback) {
        var stat, node;
  
        try {
          var lookup = FS.lookupPath(path);
          node = lookup.node;
          stat = FS.stat(path);
        } catch (e) {
          return callback(e);
        }
  
        if (FS.isDir(stat.mode)) {
          return callback(null, { timestamp: stat.mtime, mode: stat.mode });
        } else if (FS.isFile(stat.mode)) {
          // Performance consideration: storing a normal JavaScript array to a IndexedDB is much slower than storing a typed array.
          // Therefore always convert the file contents to a typed array first before writing the data to IndexedDB.
          node.contents = MEMFS.getFileDataAsTypedArray(node);
          return callback(null, { timestamp: stat.mtime, mode: stat.mode, contents: node.contents });
        } else {
          return callback(new Error('node type not supported'));
        }
      },storeLocalEntry:function (path, entry, callback) {
        try {
          if (FS.isDir(entry.mode)) {
            FS.mkdir(path, entry.mode);
          } else if (FS.isFile(entry.mode)) {
            FS.writeFile(path, entry.contents, { canOwn: true });
          } else {
            return callback(new Error('node type not supported'));
          }
  
          FS.chmod(path, entry.mode);
          FS.utime(path, entry.timestamp, entry.timestamp);
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },removeLocalEntry:function (path, callback) {
        try {
          var lookup = FS.lookupPath(path);
          var stat = FS.stat(path);
  
          if (FS.isDir(stat.mode)) {
            FS.rmdir(path);
          } else if (FS.isFile(stat.mode)) {
            FS.unlink(path);
          }
        } catch (e) {
          return callback(e);
        }
  
        callback(null);
      },loadRemoteEntry:function (store, path, callback) {
        var req = store.get(path);
        req.onsuccess = function(event) { callback(null, event.target.result); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },storeRemoteEntry:function (store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },removeRemoteEntry:function (store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = function() { callback(null); };
        req.onerror = function(e) {
          callback(this.error);
          e.preventDefault();
        };
      },reconcile:function (src, dst, callback) {
        var total = 0;
  
        var create = [];
        Object.keys(src.entries).forEach(function (key) {
          var e = src.entries[key];
          var e2 = dst.entries[key];
          if (!e2 || e.timestamp > e2.timestamp) {
            create.push(key);
            total++;
          }
        });
  
        var remove = [];
        Object.keys(dst.entries).forEach(function (key) {
          var e = dst.entries[key];
          var e2 = src.entries[key];
          if (!e2) {
            remove.push(key);
            total++;
          }
        });
  
        if (!total) {
          return callback(null);
        }
  
        var errored = false;
        var completed = 0;
        var db = src.type === 'remote' ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], 'readwrite');
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return callback(err);
            }
            return;
          }
          if (++completed >= total) {
            return callback(null);
          }
        };
  
        transaction.onerror = function(e) {
          done(this.error);
          e.preventDefault();
        };
  
        // sort paths in ascending order so directory entries are created
        // before the files inside them
        create.sort().forEach(function (path) {
          if (dst.type === 'local') {
            IDBFS.loadRemoteEntry(store, path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeLocalEntry(path, entry, done);
            });
          } else {
            IDBFS.loadLocalEntry(path, function (err, entry) {
              if (err) return done(err);
              IDBFS.storeRemoteEntry(store, path, entry, done);
            });
          }
        });
  
        // sort paths in descending order so files are deleted before their
        // parent directories
        remove.sort().reverse().forEach(function(path) {
          if (dst.type === 'local') {
            IDBFS.removeLocalEntry(path, done);
          } else {
            IDBFS.removeRemoteEntry(store, path, done);
          }
        });
      }};
  
  var NODEFS={isWindows:false,staticInit:function () {
        NODEFS.isWindows = !!process.platform.match(/^win/);
        var flags = process["binding"]("constants");
        // Node.js 4 compatibility: it has no namespaces for constants
        if (flags["fs"]) {
          flags = flags["fs"];
        }
        NODEFS.flagsForNodeMap = {
          "1024": flags["O_APPEND"],
          "64": flags["O_CREAT"],
          "128": flags["O_EXCL"],
          "0": flags["O_RDONLY"],
          "2": flags["O_RDWR"],
          "4096": flags["O_SYNC"],
          "512": flags["O_TRUNC"],
          "1": flags["O_WRONLY"]
        };
      },bufferFrom:function (arrayBuffer) {
        // Node.js < 4.5 compatibility: Buffer.from does not support ArrayBuffer
        // Buffer.from before 4.5 was just a method inherited from Uint8Array
        // Buffer.alloc has been added with Buffer.from together, so check it instead
        return Buffer.alloc ? Buffer.from(arrayBuffer) : new Buffer(arrayBuffer);
      },mount:function (mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, '/', NODEFS.getMode(mount.opts.root), 0);
      },createNode:function (parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node;
      },getMode:function (path) {
        var stat;
        try {
          stat = fs.lstatSync(path);
          if (NODEFS.isWindows) {
            // Node.js on Windows never represents permission bit 'x', so
            // propagate read bits to execute bits
            stat.mode = stat.mode | ((stat.mode & 292) >> 2);
          }
        } catch (e) {
          if (!e.code) throw e;
          throw new FS.ErrnoError(ERRNO_CODES[e.code]);
        }
        return stat.mode;
      },realPath:function (node) {
        var parts = [];
        while (node.parent !== node) {
          parts.push(node.name);
          node = node.parent;
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts);
      },flagsForNode:function (flags) {
        flags &= ~0x200000 /*O_PATH*/; // Ignore this flag from musl, otherwise node.js fails to open the file.
        flags &= ~0x800 /*O_NONBLOCK*/; // Ignore this flag from musl, otherwise node.js fails to open the file.
        flags &= ~0x8000 /*O_LARGEFILE*/; // Ignore this flag from musl, otherwise node.js fails to open the file.
        flags &= ~0x80000 /*O_CLOEXEC*/; // Some applications may pass it; it makes no sense for a single process.
        var newFlags = 0;
        for (var k in NODEFS.flagsForNodeMap) {
          if (flags & k) {
            newFlags |= NODEFS.flagsForNodeMap[k];
            flags ^= k;
          }
        }
  
        if (!flags) {
          return newFlags;
        } else {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
      },node_ops:{getattr:function (node) {
          var path = NODEFS.realPath(node);
          var stat;
          try {
            stat = fs.lstatSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          // node.js v0.10.20 doesn't report blksize and blocks on Windows. Fake them with default blksize of 4096.
          // See http://support.microsoft.com/kb/140365
          if (NODEFS.isWindows && !stat.blksize) {
            stat.blksize = 4096;
          }
          if (NODEFS.isWindows && !stat.blocks) {
            stat.blocks = (stat.size+stat.blksize-1)/stat.blksize|0;
          }
          return {
            dev: stat.dev,
            ino: stat.ino,
            mode: stat.mode,
            nlink: stat.nlink,
            uid: stat.uid,
            gid: stat.gid,
            rdev: stat.rdev,
            size: stat.size,
            atime: stat.atime,
            mtime: stat.mtime,
            ctime: stat.ctime,
            blksize: stat.blksize,
            blocks: stat.blocks
          };
        },setattr:function (node, attr) {
          var path = NODEFS.realPath(node);
          try {
            if (attr.mode !== undefined) {
              fs.chmodSync(path, attr.mode);
              // update the common node structure mode as well
              node.mode = attr.mode;
            }
            if (attr.timestamp !== undefined) {
              var date = new Date(attr.timestamp);
              fs.utimesSync(path, date, date);
            }
            if (attr.size !== undefined) {
              fs.truncateSync(path, attr.size);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },lookup:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          var mode = NODEFS.getMode(path);
          return NODEFS.createNode(parent, name, mode);
        },mknod:function (parent, name, mode, dev) {
          var node = NODEFS.createNode(parent, name, mode, dev);
          // create the backing node for this in the fs root as well
          var path = NODEFS.realPath(node);
          try {
            if (FS.isDir(node.mode)) {
              fs.mkdirSync(path, node.mode);
            } else {
              fs.writeFileSync(path, '', { mode: node.mode });
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
          return node;
        },rename:function (oldNode, newDir, newName) {
          var oldPath = NODEFS.realPath(oldNode);
          var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
          try {
            fs.renameSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },unlink:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.unlinkSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },rmdir:function (parent, name) {
          var path = PATH.join2(NODEFS.realPath(parent), name);
          try {
            fs.rmdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readdir:function (node) {
          var path = NODEFS.realPath(node);
          try {
            return fs.readdirSync(path);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },symlink:function (parent, newName, oldPath) {
          var newPath = PATH.join2(NODEFS.realPath(parent), newName);
          try {
            fs.symlinkSync(oldPath, newPath);
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },readlink:function (node) {
          var path = NODEFS.realPath(node);
          try {
            path = fs.readlinkSync(path);
            path = NODEJS_PATH.relative(NODEJS_PATH.resolve(node.mount.opts.root), path);
            return path;
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        }},stream_ops:{open:function (stream) {
          var path = NODEFS.realPath(stream.node);
          try {
            if (FS.isFile(stream.node.mode)) {
              stream.nfd = fs.openSync(path, NODEFS.flagsForNode(stream.flags));
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },close:function (stream) {
          try {
            if (FS.isFile(stream.node.mode) && stream.nfd) {
              fs.closeSync(stream.nfd);
            }
          } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },read:function (stream, buffer, offset, length, position) {
          // Node.js < 6 compatibility: node errors on 0 length reads
          if (length === 0) return 0;
          try {
            return fs.readSync(stream.nfd, NODEFS.bufferFrom(buffer.buffer), offset, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },write:function (stream, buffer, offset, length, position) {
          try {
            return fs.writeSync(stream.nfd, NODEFS.bufferFrom(buffer.buffer), offset, length, position);
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES[e.code]);
          }
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              try {
                var stat = fs.fstatSync(stream.nfd);
                position += stat.size;
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code]);
              }
            }
          }
  
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
  
          return position;
        }}};
  
  var WORKERFS={DIR_MODE:16895,FILE_MODE:33279,reader:null,mount:function (mount) {
        assert(ENVIRONMENT_IS_WORKER);
        if (!WORKERFS.reader) WORKERFS.reader = new FileReaderSync();
        var root = WORKERFS.createNode(null, '/', WORKERFS.DIR_MODE, 0);
        var createdParents = {};
        function ensureParent(path) {
          // return the parent node, creating subdirs as necessary
          var parts = path.split('/');
          var parent = root;
          for (var i = 0; i < parts.length-1; i++) {
            var curr = parts.slice(0, i+1).join('/');
            // Issue 4254: Using curr as a node name will prevent the node
            // from being found in FS.nameTable when FS.open is called on
            // a path which holds a child of this node,
            // given that all FS functions assume node names
            // are just their corresponding parts within their given path,
            // rather than incremental aggregates which include their parent's
            // directories.
            if (!createdParents[curr]) {
              createdParents[curr] = WORKERFS.createNode(parent, parts[i], WORKERFS.DIR_MODE, 0);
            }
            parent = createdParents[curr];
          }
          return parent;
        }
        function base(path) {
          var parts = path.split('/');
          return parts[parts.length-1];
        }
        // We also accept FileList here, by using Array.prototype
        Array.prototype.forEach.call(mount.opts["files"] || [], function(file) {
          WORKERFS.createNode(ensureParent(file.name), base(file.name), WORKERFS.FILE_MODE, 0, file, file.lastModifiedDate);
        });
        (mount.opts["blobs"] || []).forEach(function(obj) {
          WORKERFS.createNode(ensureParent(obj["name"]), base(obj["name"]), WORKERFS.FILE_MODE, 0, obj["data"]);
        });
        (mount.opts["packages"] || []).forEach(function(pack) {
          pack['metadata'].files.forEach(function(file) {
            var name = file.filename.substr(1); // remove initial slash
            WORKERFS.createNode(ensureParent(name), base(name), WORKERFS.FILE_MODE, 0, pack['blob'].slice(file.start, file.end));
          });
        });
        return root;
      },createNode:function (parent, name, mode, dev, contents, mtime) {
        var node = FS.createNode(parent, name, mode);
        node.mode = mode;
        node.node_ops = WORKERFS.node_ops;
        node.stream_ops = WORKERFS.stream_ops;
        node.timestamp = (mtime || new Date).getTime();
        assert(WORKERFS.FILE_MODE !== WORKERFS.DIR_MODE);
        if (mode === WORKERFS.FILE_MODE) {
          node.size = contents.size;
          node.contents = contents;
        } else {
          node.size = 4096;
          node.contents = {};
        }
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },node_ops:{getattr:function (node) {
          return {
            dev: 1,
            ino: undefined,
            mode: node.mode,
            nlink: 1,
            uid: 0,
            gid: 0,
            rdev: undefined,
            size: node.size,
            atime: new Date(node.timestamp),
            mtime: new Date(node.timestamp),
            ctime: new Date(node.timestamp),
            blksize: 4096,
            blocks: Math.ceil(node.size / 4096),
          };
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
        },lookup:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        },mknod:function (parent, name, mode, dev) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rename:function (oldNode, newDir, newName) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },unlink:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },rmdir:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readdir:function (node) {
          var entries = ['.', '..'];
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newName, oldPath) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        },readlink:function (node) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          if (position >= stream.node.size) return 0;
          var chunk = stream.node.contents.slice(position, position + length);
          var ab = WORKERFS.reader.readAsArrayBuffer(chunk);
          buffer.set(new Uint8Array(ab), offset);
          return chunk.size;
        },write:function (stream, buffer, offset, length, position) {
          throw new FS.ErrnoError(ERRNO_CODES.EIO);
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.size;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return position;
        }}};
  
  var _stdin=STATICTOP; STATICTOP += 16;;
  
  var _stdout=STATICTOP; STATICTOP += 16;;
  
  var _stderr=STATICTOP; STATICTOP += 16;;var FS={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,trackingDelegate:{},tracking:{openFlags:{READ:1,WRITE:2}},ErrnoError:null,genericErrors:{},filesystems:null,syncFSRequests:0,handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + stackTrace();
        return ___setErrNo(e.errno);
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};
  
        if (!path) return { path: '', node: null };
  
        var defaults = {
          follow_mount: true,
          recurse_count: 0
        };
        for (var key in defaults) {
          if (opts[key] === undefined) {
            opts[key] = defaults[key];
          }
        }
  
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
  
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
  
        // start at the root
        var current = FS.root;
        var current_path = '/';
  
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
  
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join2(current_path, parts[i]);
  
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            if (!islast || (islast && opts.follow_mount)) {
              current = current.mounted.root;
            }
          }
  
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
  
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
  
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
  
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            var mount = node.mount.mountpoint;
            if (!path) return mount;
            return mount[mount.length-1] !== '/' ? mount + '/' + path : mount + path;
          }
          path = path ? node.name + '/' + path : node.name;
          node = node.parent;
        }
      },hashName:function (parentid, name) {
        var hash = 0;
  
  
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.nameTable.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
          FS.nameTable[hash] = node.name_next;
        } else {
          var current = FS.nameTable[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err, parent);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
          var nodeName = node.name;
          if (node.parent.id === parent.id && nodeName === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        if (!FS.FSNode) {
          FS.FSNode = function(parent, name, mode, rdev) {
            if (!parent) {
              parent = this;  // root node sets parent to itself
            }
            this.parent = parent;
            this.mount = parent.mount;
            this.mounted = null;
            this.id = FS.nextInode++;
            this.name = name;
            this.mode = mode;
            this.node_ops = {};
            this.stream_ops = {};
            this.rdev = rdev;
          };
  
          FS.FSNode.prototype = {};
  
          // compatibility
          var readMode = 292 | 73;
          var writeMode = 146;
  
          // NOTE we must use Object.defineProperties instead of individual calls to
          // Object.defineProperty in order to make closure compiler happy
          Object.defineProperties(FS.FSNode.prototype, {
            read: {
              get: function() { return (this.mode & readMode) === readMode; },
              set: function(val) { val ? this.mode |= readMode : this.mode &= ~readMode; }
            },
            write: {
              get: function() { return (this.mode & writeMode) === writeMode; },
              set: function(val) { val ? this.mode |= writeMode : this.mode &= ~writeMode; }
            },
            isFolder: {
              get: function() { return FS.isDir(this.mode); }
            },
            isDevice: {
              get: function() { return FS.isChrdev(this.mode); }
            }
          });
        }
  
        var node = new FS.FSNode(parent, name, mode, rdev);
  
        FS.hashAddNode(node);
  
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return !!node.mounted;
      },isFile:function (mode) {
        return (mode & 61440) === 32768;
      },isDir:function (mode) {
        return (mode & 61440) === 16384;
      },isLink:function (mode) {
        return (mode & 61440) === 40960;
      },isChrdev:function (mode) {
        return (mode & 61440) === 8192;
      },isBlkdev:function (mode) {
        return (mode & 61440) === 24576;
      },isFIFO:function (mode) {
        return (mode & 61440) === 4096;
      },isSocket:function (mode) {
        return (mode & 49152) === 49152;
      },flagModes:{"r":0,"rs":1052672,"r+":2,"w":577,"wx":705,"xw":705,"w+":578,"wx+":706,"xw+":706,"a":1089,"ax":1217,"xa":1217,"a+":1090,"ax+":1218,"xa+":1218},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var perms = ['r', 'w', 'rw'][flag & 3];
        if ((flag & 512)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        var err = FS.nodePermissions(dir, 'x');
        if (err) return err;
        if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
        return 0;
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if (FS.flagsToPermissionString(flags) !== 'r' || // opening for write
              (flags & 512)) { // TODO: check for O_SEARCH? (== search for dir only)
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        if (!FS.FSStream) {
          FS.FSStream = function(){};
          FS.FSStream.prototype = {};
          // compatibility
          Object.defineProperties(FS.FSStream.prototype, {
            object: {
              get: function() { return this.node; },
              set: function(val) { this.node = val; }
            },
            isRead: {
              get: function() { return (this.flags & 2097155) !== 1; }
            },
            isWrite: {
              get: function() { return (this.flags & 2097155) !== 0; }
            },
            isAppend: {
              get: function() { return (this.flags & 1024); }
            }
          });
        }
        // clone it, so we can return an instance of FSStream
        var newStream = new FS.FSStream();
        for (var p in stream) {
          newStream[p] = stream[p];
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },getMounts:function (mount) {
        var mounts = [];
        var check = [mount];
  
        while (check.length) {
          var m = check.pop();
  
          mounts.push(m);
  
          check.push.apply(check, m.mounts);
        }
  
        return mounts;
      },syncfs:function (populate, callback) {
        if (typeof(populate) === 'function') {
          callback = populate;
          populate = false;
        }
  
        FS.syncFSRequests++;
  
        if (FS.syncFSRequests > 1) {
          console.log('warning: ' + FS.syncFSRequests + ' FS.syncfs operations in flight at once, probably just doing extra work');
        }
  
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;
  
        function doCallback(err) {
          assert(FS.syncFSRequests > 0);
          FS.syncFSRequests--;
          return callback(err);
        }
  
        function done(err) {
          if (err) {
            if (!done.errored) {
              done.errored = true;
              return doCallback(err);
            }
            return;
          }
          if (++completed >= mounts.length) {
            doCallback(null);
          }
        };
  
        // sync all mounts
        mounts.forEach(function (mount) {
          if (!mount.type.syncfs) {
            return done(null);
          }
          mount.type.syncfs(mount, populate, done);
        });
      },mount:function (type, opts, mountpoint) {
        var root = mountpoint === '/';
        var pseudo = !mountpoint;
        var node;
  
        if (root && FS.root) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        } else if (!root && !pseudo) {
          var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
          mountpoint = lookup.path;  // use the absolute path
          node = lookup.node;
  
          if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
          }
  
          if (!FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
          }
        }
  
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          mounts: []
        };
  
        // create a root node for the fs
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
  
        if (root) {
          FS.root = mountRoot;
        } else if (node) {
          // set as a mountpoint
          node.mounted = mount;
  
          // add the new mount to the current mount's children
          if (node.mount) {
            node.mount.mounts.push(mount);
          }
        }
  
        return mountRoot;
      },unmount:function (mountpoint) {
        var lookup = FS.lookupPath(mountpoint, { follow_mount: false });
  
        if (!FS.isMountpoint(lookup.node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
  
        // destroy the nodes for this mount, and all its child mounts
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
  
        Object.keys(FS.nameTable).forEach(function (hash) {
          var current = FS.nameTable[hash];
  
          while (current) {
            var next = current.name_next;
  
            if (mounts.indexOf(current.mount) !== -1) {
              FS.destroyNode(current);
            }
  
            current = next;
          }
        });
  
        // no longer a mountpoint
        node.mounted = null;
  
        // remove this mount from the child mounts
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1);
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === '.' || name === '..') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode = mode !== undefined ? mode : 438 /* 0666 */;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode = mode !== undefined ? mode : 511 /* 0777 */;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0);
      },mkdirTree:function (path, mode) {
        var dirs = path.split('/');
        var d = '';
        for (var i = 0; i < dirs.length; ++i) {
          if (!dirs[i]) continue;
          d += '/' + dirs[i];
          try {
            FS.mkdir(d, mode);
          } catch(e) {
            if (e.errno != ERRNO_CODES.EEXIST) throw e;
          }
        }
      },mkdev:function (path, mode, dev) {
        if (typeof(dev) === 'undefined') {
          dev = mode;
          mode = 438 /* 0666 */;
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        if (!parent) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        try {
          if (FS.trackingDelegate['willMovePath']) {
            FS.trackingDelegate['willMovePath'](old_path, new_path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
        try {
          if (FS.trackingDelegate['onMovePath']) FS.trackingDelegate['onMovePath'](old_path, new_path);
        } catch(e) {
          console.log("FS.trackingDelegate['onMovePath']('"+old_path+"', '"+new_path+"') threw an exception: " + e.message);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // According to POSIX, we should map EISDIR to EPERM, but
          // we instead do what Linux does (and we must, as we use
          // the musl linux libc).
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        try {
          if (FS.trackingDelegate['willDeletePath']) {
            FS.trackingDelegate['willDeletePath'](path);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['willDeletePath']('"+path+"') threw an exception: " + e.message);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
        try {
          if (FS.trackingDelegate['onDeletePath']) FS.trackingDelegate['onDeletePath'](path);
        } catch(e) {
          console.log("FS.trackingDelegate['onDeletePath']('"+path+"') threw an exception: " + e.message);
        }
      },readlink:function (path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return PATH.resolve(FS.getPath(link.parent), link.node_ops.readlink(link));
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        if (path === "") {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 438 /* 0666 */ : mode;
        if ((flags & 64)) {
          mode = (mode & 4095) | 32768;
        } else {
          mode = 0;
        }
        var node;
        if (typeof path === 'object') {
          node = path;
        } else {
          path = PATH.normalize(path);
          try {
            var lookup = FS.lookupPath(path, {
              follow: !(flags & 131072)
            });
            node = lookup.node;
          } catch (e) {
            // ignore
          }
        }
        // perhaps we need to create the node
        var created = false;
        if ((flags & 64)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 128)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
            created = true;
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~512;
        }
        // if asked only for a directory, then this must be one
        if ((flags & 65536) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        // check permissions, if this is not a file we just created now (it is ok to
        // create and write to a file with read-only permissions; it is read-only
        // for later use)
        if (!created) {
          var err = FS.mayOpen(node, flags);
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // do truncation if necessary
        if ((flags & 512)) {
          FS.truncate(node, 0);
        }
        // we've already handled these, don't pass down to the underlying vfs
        flags &= ~(128 | 512);
  
        // register the stream with the filesystem
        var stream = FS.createStream({
          node: node,
          path: FS.getPath(node),  // we want the absolute path to the node
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        if (Module['logReadFiles'] && !(flags & 1)) {
          if (!FS.readFiles) FS.readFiles = {};
          if (!(path in FS.readFiles)) {
            FS.readFiles[path] = 1;
            Module['printErr']('read file: ' + path);
          }
        }
        try {
          if (FS.trackingDelegate['onOpenFile']) {
            var trackingFlags = 0;
            if ((flags & 2097155) !== 1) {
              trackingFlags |= FS.tracking.openFlags.READ;
            }
            if ((flags & 2097155) !== 0) {
              trackingFlags |= FS.tracking.openFlags.WRITE;
            }
            FS.trackingDelegate['onOpenFile'](path, trackingFlags);
          }
        } catch(e) {
          console.log("FS.trackingDelegate['onOpenFile']('"+path+"', flags) threw an exception: " + e.message);
        }
        return stream;
      },close:function (stream) {
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (stream.getdents) stream.getdents = null; // free readdir state
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
        stream.fd = null;
      },isClosed:function (stream) {
        return stream.fd === null;
      },llseek:function (stream, offset, whence) {
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position;
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = typeof position !== 'undefined';
        if (!seeking) {
          position = stream.position;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if (stream.flags & 1024) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var seeking = typeof position !== 'undefined';
        if (!seeking) {
          position = stream.position;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        try {
          if (stream.path && FS.trackingDelegate['onWriteToFile']) FS.trackingDelegate['onWriteToFile'](stream.path);
        } catch(e) {
          console.log("FS.trackingDelegate['onWriteToFile']('"+path+"') threw an exception: " + e.message);
        }
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (FS.isClosed(stream)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 2097155) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 2097155) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      },msync:function (stream, buffer, offset, length, mmapFlags) {
        if (!stream || !stream.stream_ops.msync) {
          return 0;
        }
        return stream.stream_ops.msync(stream, buffer, offset, length, mmapFlags);
      },munmap:function (stream) {
        return 0;
      },ioctl:function (stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTTY);
        }
        return stream.stream_ops.ioctl(stream, cmd, arg);
      },readFile:function (path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'r';
        opts.encoding = opts.encoding || 'binary';
        if (opts.encoding !== 'utf8' && opts.encoding !== 'binary') {
          throw new Error('Invalid encoding type "' + opts.encoding + '"');
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === 'utf8') {
          ret = UTF8ArrayToString(buf, 0);
        } else if (opts.encoding === 'binary') {
          ret = buf;
        }
        FS.close(stream);
        return ret;
      },writeFile:function (path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || 'w';
        var stream = FS.open(path, opts.flags, opts.mode);
        if (typeof data === 'string') {
          var buf = new Uint8Array(lengthBytesUTF8(data)+1);
          var actualNumBytes = stringToUTF8Array(data, buf, 0, buf.length);
          FS.write(stream, buf, 0, actualNumBytes, undefined, opts.canOwn);
        } else if (ArrayBuffer.isView(data)) {
          FS.write(stream, data, 0, data.byteLength, undefined, opts.canOwn);
        } else {
          throw new Error('Unsupported data type');
        }
        FS.close(stream);
      },cwd:function () {
        return FS.currentPath;
      },chdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        if (lookup.node === null) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        if (!FS.isDir(lookup.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        var err = FS.nodePermissions(lookup.node, 'x');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        FS.currentPath = lookup.path;
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp');
        FS.mkdir('/home');
        FS.mkdir('/home/web_user');
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev');
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function(stream, buffer, offset, length, pos) { return length; }
        });
        FS.mkdev('/dev/null', FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', FS.makedev(6, 0));
        // setup /dev/[u]random
        var random_device;
        if (typeof crypto !== 'undefined') {
          // for modern web browsers
          var randomBuffer = new Uint8Array(1);
          random_device = function() { crypto.getRandomValues(randomBuffer); return randomBuffer[0]; };
        } else if (ENVIRONMENT_IS_NODE) {
          // for nodejs
          random_device = function() { return require('crypto')['randomBytes'](1)[0]; };
        } else {
          // default for ES5 platforms
          random_device = function() { return (Math.random()*256)|0; };
        }
        FS.createDevice('/dev', 'random', random_device);
        FS.createDevice('/dev', 'urandom', random_device);
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm');
        FS.mkdir('/dev/shm/tmp');
      },createSpecialDirectories:function () {
        // create /proc/self/fd which allows /proc/self/fd/6 => readlink gives the name of the stream for fd 6 (see test_unistd_ttyname)
        FS.mkdir('/proc');
        FS.mkdir('/proc/self');
        FS.mkdir('/proc/self/fd');
        FS.mount({
          mount: function() {
            var node = FS.createNode('/proc/self', 'fd', 16384 | 511 /* 0777 */, 73);
            node.node_ops = {
              lookup: function(parent, name) {
                var fd = +name;
                var stream = FS.getStream(fd);
                if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
                var ret = {
                  parent: null,
                  mount: { mountpoint: 'fake' },
                  node_ops: { readlink: function() { return stream.path } }
                };
                ret.parent = ret; // make it look like a simple root node
                return ret;
              }
            };
            return node;
          }
        }, {}, '/proc/self/fd');
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
  
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
  
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        assert(stdin.fd === 0, 'invalid handle for stdin (' + stdin.fd + ')');
  
        var stdout = FS.open('/dev/stdout', 'w');
        assert(stdout.fd === 1, 'invalid handle for stdout (' + stdout.fd + ')');
  
        var stderr = FS.open('/dev/stderr', 'w');
        assert(stderr.fd === 2, 'invalid handle for stderr (' + stderr.fd + ')');
      },ensureErrnoError:function () {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno, node) {
          //Module.printErr(stackTrace()); // useful for debugging
          this.node = node;
          this.setErrno = function(errno) {
            this.errno = errno;
            for (var key in ERRNO_CODES) {
              if (ERRNO_CODES[key] === errno) {
                this.code = key;
                break;
              }
            }
          };
          this.setErrno(errno);
          this.message = ERRNO_MESSAGES[errno];
          // Node.js compatibility: assigning on this.stack fails on Node 4 (but fixed on Node 8)
          if (this.stack) Object.defineProperty(this, "stack", { value: (new Error).stack, writable: true });
          if (this.stack) this.stack = demangleAll(this.stack);
        };
        FS.ErrnoError.prototype = new Error();
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        // Some errors may happen quite a bit, to avoid overhead we reuse them (and suffer a lack of stack info)
        [ERRNO_CODES.ENOENT].forEach(function(code) {
          FS.genericErrors[code] = new FS.ErrnoError(code);
          FS.genericErrors[code].stack = '<generic error, no stack>';
        });
      },staticInit:function () {
        FS.ensureErrnoError();
  
        FS.nameTable = new Array(4096);
  
        FS.mount(MEMFS, {}, '/');
  
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
        FS.createSpecialDirectories();
  
        FS.filesystems = {
          'MEMFS': MEMFS,
          'IDBFS': IDBFS,
          'NODEFS': NODEFS,
          'WORKERFS': WORKERFS,
        };
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
  
        FS.ensureErrnoError();
  
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
  
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        // force-flush all streams, so we get musl std streams printed out
        var fflush = Module['_fflush'];
        if (fflush) fflush(0);
        // close all of our streams
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join2(parent, part);
          try {
            FS.mkdir(current);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(node, mode | 146);
          var stream = FS.open(node, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(node, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
            obj.usedBytes = obj.contents.length;
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
        function LazyUint8Array() {
          this.lengthKnown = false;
          this.chunks = []; // Loaded chunks. Index is the chunk number
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
          if (idx > this.length-1 || idx < 0) {
            return undefined;
          }
          var chunkOffset = idx % this.chunkSize;
          var chunkNum = (idx / this.chunkSize)|0;
          return this.getter(chunkNum)[chunkOffset];
        }
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
          this.getter = getter;
        }
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
          // Find length
          var xhr = new XMLHttpRequest();
          xhr.open('HEAD', url, false);
          xhr.send(null);
          if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
          var datalength = Number(xhr.getResponseHeader("Content-length"));
          var header;
          var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
          var usesGzip = (header = xhr.getResponseHeader("Content-Encoding")) && header === "gzip";
  
          var chunkSize = 1024*1024; // Chunk size in bytes
  
          if (!hasByteServing) chunkSize = datalength;
  
          // Function to get a range from the remote URL.
          var doXHR = (function(from, to) {
            if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
            if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
  
            // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, false);
            if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
  
            // Some hints to the browser that we want binary data.
            if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
            if (xhr.overrideMimeType) {
              xhr.overrideMimeType('text/plain; charset=x-user-defined');
            }
  
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            if (xhr.response !== undefined) {
              return new Uint8Array(xhr.response || []);
            } else {
              return intArrayFromString(xhr.responseText || '', true);
            }
          });
          var lazyArray = this;
          lazyArray.setDataGetter(function(chunkNum) {
            var start = chunkNum * chunkSize;
            var end = (chunkNum+1) * chunkSize - 1; // including this byte
            end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
              lazyArray.chunks[chunkNum] = doXHR(start, end);
            }
            if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
            return lazyArray.chunks[chunkNum];
          });
  
          if (usesGzip || !datalength) {
            // if the server uses gzip or doesn't supply the length, we have to download the whole file to get the (uncompressed) length
            chunkSize = datalength = 1; // this will force getter(0)/doXHR do download the whole file
            datalength = this.getter(0).length;
            chunkSize = datalength;
            console.log("LazyFiles on gzip forces download of the whole file when length is accessed");
          }
  
          this._length = datalength;
          this._chunkSize = chunkSize;
          this.lengthKnown = true;
        }
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          var lazyArray = new LazyUint8Array();
          Object.defineProperties(lazyArray, {
            length: {
              get: function() {
                if(!this.lengthKnown) {
                  this.cacheLength();
                }
                return this._length;
              }
            },
            chunkSize: {
              get: function() {
                if(!this.lengthKnown) {
                  this.cacheLength();
                }
                return this._chunkSize;
              }
            }
          });
  
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
  
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // Add a function that defers querying the file size until it is asked the first time.
        Object.defineProperties(node, {
          usedBytes: {
            get: function() { return this.contents.length; }
          }
        });
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function forceLoadLazyFile() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          if (position >= contents.length)
            return 0;
          var size = Math.min(contents.length - position, length);
          assert(size >= 0);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn, preFinish) {
        Browser.init(); // XXX perhaps this method should move onto Browser?
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;
        var dep = getUniqueRunDependency('cp ' + fullname); // might have several active requests for the same fullname
        function processData(byteArray) {
          function finish(byteArray) {
            if (preFinish) preFinish();
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency(dep);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency(dep);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency(dep);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },indexedDB:function () {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
      },DB_NAME:function () {
        return 'EM_FS_' + window.location.pathname;
      },DB_VERSION:20,DB_STORE_NAME:"FILE_DATA",saveFilesToDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
          console.log('creating db');
          var db = openRequest.result;
          db.createObjectStore(FS.DB_STORE_NAME);
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          var transaction = db.transaction([FS.DB_STORE_NAME], 'readwrite');
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var putRequest = files.put(FS.analyzePath(path).object.contents, path);
            putRequest.onsuccess = function putRequest_onsuccess() { ok++; if (ok + fail == total) finish() };
            putRequest.onerror = function putRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      },loadFilesFromDB:function (paths, onload, onerror) {
        onload = onload || function(){};
        onerror = onerror || function(){};
        var indexedDB = FS.indexedDB();
        try {
          var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION);
        } catch (e) {
          return onerror(e);
        }
        openRequest.onupgradeneeded = onerror; // no database to load from
        openRequest.onsuccess = function openRequest_onsuccess() {
          var db = openRequest.result;
          try {
            var transaction = db.transaction([FS.DB_STORE_NAME], 'readonly');
          } catch(e) {
            onerror(e);
            return;
          }
          var files = transaction.objectStore(FS.DB_STORE_NAME);
          var ok = 0, fail = 0, total = paths.length;
          function finish() {
            if (fail == 0) onload(); else onerror();
          }
          paths.forEach(function(path) {
            var getRequest = files.get(path);
            getRequest.onsuccess = function getRequest_onsuccess() {
              if (FS.analyzePath(path).exists) {
                FS.unlink(path);
              }
              FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
              ok++;
              if (ok + fail == total) finish();
            };
            getRequest.onerror = function getRequest_onerror() { fail++; if (ok + fail == total) finish() };
          });
          transaction.onerror = onerror;
        };
        openRequest.onerror = onerror;
      }};
  
  
  
  function _emscripten_set_main_loop_timing(mode, value) {
      Browser.mainLoop.timingMode = mode;
      Browser.mainLoop.timingValue = value;
  
      if (!Browser.mainLoop.func) {
        console.error('emscripten_set_main_loop_timing: Cannot set timing mode for main loop since a main loop does not exist! Call emscripten_set_main_loop first to set one up.');
        return 1; // Return non-zero on failure, can't set timing mode when there is no main loop.
      }
  
      if (mode == 0 /*EM_TIMING_SETTIMEOUT*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setTimeout() {
          var timeUntilNextTick = Math.max(0, Browser.mainLoop.tickStartTime + value - _emscripten_get_now())|0;
          setTimeout(Browser.mainLoop.runner, timeUntilNextTick); // doing this each time means that on exception, we stop
        };
        Browser.mainLoop.method = 'timeout';
      } else if (mode == 1 /*EM_TIMING_RAF*/) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_rAF() {
          Browser.requestAnimationFrame(Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'rAF';
      } else if (mode == 2 /*EM_TIMING_SETIMMEDIATE*/) {
        if (typeof setImmediate === 'undefined') {
          // Emulate setImmediate. (note: not a complete polyfill, we don't emulate clearImmediate() to keep code size to minimum, since not needed)
          var setImmediates = [];
          var emscriptenMainLoopMessageId = 'setimmediate';
          function Browser_setImmediate_messageHandler(event) {
            // When called in current thread or Worker, the main loop ID is structured slightly different to accommodate for --proxy-to-worker runtime listening to Worker events,
            // so check for both cases.
            if (event.data === emscriptenMainLoopMessageId || event.data.target === emscriptenMainLoopMessageId) {
              event.stopPropagation();
              setImmediates.shift()();
            }
          }
          addEventListener("message", Browser_setImmediate_messageHandler, true);
          setImmediate = function Browser_emulated_setImmediate(func) {
            setImmediates.push(func);
            if (ENVIRONMENT_IS_WORKER) {
              if (Module['setImmediates'] === undefined) Module['setImmediates'] = [];
              Module['setImmediates'].push(func);
              postMessage({target: emscriptenMainLoopMessageId}); // In --proxy-to-worker, route the message via proxyClient.js
            } else postMessage(emscriptenMainLoopMessageId, "*"); // On the main thread, can just send the message to itself.
          }
        }
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler_setImmediate() {
          setImmediate(Browser.mainLoop.runner);
        };
        Browser.mainLoop.method = 'immediate';
      }
      return 0;
    }
  
  function _emscripten_get_now() { abort() }function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg, noSetTiming) {
      Module['noExitRuntime'] = true;
  
      assert(!Browser.mainLoop.func, 'emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.');
  
      Browser.mainLoop.func = func;
      Browser.mainLoop.arg = arg;
  
      var browserIterationFunc;
      if (typeof arg !== 'undefined') {
        browserIterationFunc = function() {
          Module['dynCall_vi'](func, arg);
        };
      } else {
        browserIterationFunc = function() {
          Module['dynCall_v'](func);
        };
      }
  
      var thisMainLoopId = Browser.mainLoop.currentlyRunningMainloop;
  
      Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
          var start = Date.now();
          var blocker = Browser.mainLoop.queue.shift();
          blocker.func(blocker.arg);
          if (Browser.mainLoop.remainingBlockers) {
            var remaining = Browser.mainLoop.remainingBlockers;
            var next = remaining%1 == 0 ? remaining-1 : Math.floor(remaining);
            if (blocker.counted) {
              Browser.mainLoop.remainingBlockers = next;
            } else {
              // not counted, but move the progress along a tiny bit
              next = next + 0.5; // do not steal all the next one's progress
              Browser.mainLoop.remainingBlockers = (8*remaining + next)/9;
            }
          }
          console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + ' ms'); //, left: ' + Browser.mainLoop.remainingBlockers);
          Browser.mainLoop.updateStatus();
          
          // catches pause/resume main loop from blocker execution
          if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
          
          setTimeout(Browser.mainLoop.runner, 0);
          return;
        }
  
        // catch pauses from non-main loop sources
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Implement very basic swap interval control
        Browser.mainLoop.currentFrameNumber = Browser.mainLoop.currentFrameNumber + 1 | 0;
        if (Browser.mainLoop.timingMode == 1/*EM_TIMING_RAF*/ && Browser.mainLoop.timingValue > 1 && Browser.mainLoop.currentFrameNumber % Browser.mainLoop.timingValue != 0) {
          // Not the scheduled time to render this frame - skip.
          Browser.mainLoop.scheduler();
          return;
        } else if (Browser.mainLoop.timingMode == 0/*EM_TIMING_SETTIMEOUT*/) {
          Browser.mainLoop.tickStartTime = _emscripten_get_now();
        }
  
        // Signal GL rendering layer that processing of a new frame is about to start. This helps it optimize
        // VBO double-buffering and reduce GPU stalls.
  
  
        if (Browser.mainLoop.method === 'timeout' && Module.ctx) {
          Module.printErr('Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!');
          Browser.mainLoop.method = ''; // just warn once per call to set main loop
        }
  
        Browser.mainLoop.runIter(browserIterationFunc);
  
        checkStackCookie();
  
        // catch pauses from the main loop itself
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
  
        // Queue new audio data. This is important to be right after the main loop invocation, so that we will immediately be able
        // to queue the newest produced audio samples.
        // TODO: Consider adding pre- and post- rAF callbacks so that GL.newRenderingFrameStarted() and SDL.audio.queueNewAudioData()
        //       do not need to be hardcoded into this function, but can be more generic.
        if (typeof SDL === 'object' && SDL.audio && SDL.audio.queueNewAudioData) SDL.audio.queueNewAudioData();
  
        Browser.mainLoop.scheduler();
      }
  
      if (!noSetTiming) {
        if (fps && fps > 0) _emscripten_set_main_loop_timing(0/*EM_TIMING_SETTIMEOUT*/, 1000.0 / fps);
        else _emscripten_set_main_loop_timing(1/*EM_TIMING_RAF*/, 1); // Do rAF by rendering each frame (no decimating)
  
        Browser.mainLoop.scheduler();
      }
  
      if (simulateInfiniteLoop) {
        throw 'SimulateInfiniteLoop';
      }
    }var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:function () {
          Browser.mainLoop.scheduler = null;
          Browser.mainLoop.currentlyRunningMainloop++; // Incrementing this signals the previous main loop that it's now become old, and it must return.
        },resume:function () {
          Browser.mainLoop.currentlyRunningMainloop++;
          var timingMode = Browser.mainLoop.timingMode;
          var timingValue = Browser.mainLoop.timingValue;
          var func = Browser.mainLoop.func;
          Browser.mainLoop.func = null;
          _emscripten_set_main_loop(func, 0, false, Browser.mainLoop.arg, true /* do not set timing and call scheduler, we will do it on the next lines */);
          _emscripten_set_main_loop_timing(timingMode, timingValue);
          Browser.mainLoop.scheduler();
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        },runIter:function (func) {
          if (ABORT) return;
          if (Module['preMainLoop']) {
            var preRet = Module['preMainLoop']();
            if (preRet === false) {
              return; // |return false| skips a frame
            }
          }
          try {
            func();
          } catch (e) {
            if (e instanceof ExitStatus) {
              return;
            } else {
              if (e && typeof e === 'object' && e.stack) Module.printErr('exception thrown: ' + [e, e.stack]);
              throw e;
            }
          }
          if (Module['postMainLoop']) Module['postMainLoop']();
        }},isFullscreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
  
        if (Browser.initted) return;
        Browser.initted = true;
  
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
  
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
  
        var imagePlugin = {};
        imagePlugin['canHandle'] = function imagePlugin_canHandle(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function imagePlugin_handle(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          assert(typeof url == 'string', 'createObjectURL must return a url as a string');
          var img = new Image();
          img.onload = function img_onload() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function img_onerror(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
  
        var audioPlugin = {};
        audioPlugin['canHandle'] = function audioPlugin_canHandle(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function audioPlugin_handle(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            assert(typeof url == 'string', 'createObjectURL must return a url as a string');
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function audio_onerror(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
  
        // Canvas event setup
  
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === Module['canvas'] ||
                                document['mozPointerLockElement'] === Module['canvas'] ||
                                document['webkitPointerLockElement'] === Module['canvas'] ||
                                document['msPointerLockElement'] === Module['canvas'];
        }
        var canvas = Module['canvas'];
        if (canvas) {
          // forced aspect ratio can be enabled by defining 'forcedAspectRatio' on Module
          // Module['forcedAspectRatio'] = 4 / 3;
          
          canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                      canvas['mozRequestPointerLock'] ||
                                      canvas['webkitRequestPointerLock'] ||
                                      canvas['msRequestPointerLock'] ||
                                      function(){};
          canvas.exitPointerLock = document['exitPointerLock'] ||
                                   document['mozExitPointerLock'] ||
                                   document['webkitExitPointerLock'] ||
                                   document['msExitPointerLock'] ||
                                   function(){}; // no-op if function does not exist
          canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
  
          document.addEventListener('pointerlockchange', pointerLockChange, false);
          document.addEventListener('mozpointerlockchange', pointerLockChange, false);
          document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
          document.addEventListener('mspointerlockchange', pointerLockChange, false);
  
          if (Module['elementPointerLock']) {
            canvas.addEventListener("click", function(ev) {
              if (!Browser.pointerLock && Module['canvas'].requestPointerLock) {
                Module['canvas'].requestPointerLock();
                ev.preventDefault();
              }
            }, false);
          }
        }
      },createContext:function (canvas, useWebGL, setInModule, webGLContextAttributes) {
        if (useWebGL && Module.ctx && canvas == Module.canvas) return Module.ctx; // no need to recreate GL context if it's already been created for this canvas.
  
        var ctx;
        var contextHandle;
        if (useWebGL) {
          // For GLES2/desktop GL compatibility, adjust a few defaults to be different to WebGL defaults, so that they align better with the desktop defaults.
          var contextAttributes = {
            antialias: false,
            alpha: false
          };
  
          if (webGLContextAttributes) {
            for (var attribute in webGLContextAttributes) {
              contextAttributes[attribute] = webGLContextAttributes[attribute];
            }
          }
  
          contextHandle = GL.createContext(canvas, contextAttributes);
          if (contextHandle) {
            ctx = GL.getContext(contextHandle).GLctx;
          }
        } else {
          ctx = canvas.getContext('2d');
        }
  
        if (!ctx) return null;
  
        if (setInModule) {
          if (!useWebGL) assert(typeof GLctx === 'undefined', 'cannot set in module if GLctx is used, but we are a non-GL context that would replace it');
  
          Module.ctx = ctx;
          if (useWebGL) GL.makeContextCurrent(contextHandle);
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullscreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullscreen:function (lockPointer, resizeCanvas, vrDevice) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        Browser.vrDevice = vrDevice;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        if (typeof Browser.vrDevice === 'undefined') Browser.vrDevice = null;
  
        var canvas = Module['canvas'];
        function fullscreenChange() {
          Browser.isFullscreen = false;
          var canvasContainer = canvas.parentNode;
          if ((document['fullscreenElement'] || document['mozFullScreenElement'] ||
               document['msFullscreenElement'] || document['webkitFullscreenElement'] ||
               document['webkitCurrentFullScreenElement']) === canvasContainer) {
            canvas.exitFullscreen = document['exitFullscreen'] ||
                                    document['cancelFullScreen'] ||
                                    document['mozCancelFullScreen'] ||
                                    document['msExitFullscreen'] ||
                                    document['webkitCancelFullScreen'] ||
                                    function() {};
            canvas.exitFullscreen = canvas.exitFullscreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullscreen = true;
            if (Browser.resizeCanvas) Browser.setFullscreenCanvasSize();
          } else {
            
            // remove the full screen specific parent of the canvas again to restore the HTML structure from before going full screen
            canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
            canvasContainer.parentNode.removeChild(canvasContainer);
            
            if (Browser.resizeCanvas) Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullscreen);
          if (Module['onFullscreen']) Module['onFullscreen'](Browser.isFullscreen);
          Browser.updateCanvasDimensions(canvas);
        }
  
        if (!Browser.fullscreenHandlersInstalled) {
          Browser.fullscreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullscreenChange, false);
          document.addEventListener('mozfullscreenchange', fullscreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullscreenChange, false);
          document.addEventListener('MSFullscreenChange', fullscreenChange, false);
        }
  
        // create a new parent to ensure the canvas has no siblings. this allows browsers to optimize full screen performance when its parent is the full screen root
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);
  
        // use parent of canvas as full screen root to allow aspect ratio correction (Firefox stretches the root to screen size)
        canvasContainer.requestFullscreen = canvasContainer['requestFullscreen'] ||
                                            canvasContainer['mozRequestFullScreen'] ||
                                            canvasContainer['msRequestFullscreen'] ||
                                           (canvasContainer['webkitRequestFullscreen'] ? function() { canvasContainer['webkitRequestFullscreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null) ||
                                           (canvasContainer['webkitRequestFullScreen'] ? function() { canvasContainer['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
  
        if (vrDevice) {
          canvasContainer.requestFullscreen({ vrDisplay: vrDevice });
        } else {
          canvasContainer.requestFullscreen();
        }
      },requestFullScreen:function (lockPointer, resizeCanvas, vrDevice) {
          Module.printErr('Browser.requestFullScreen() is deprecated. Please call Browser.requestFullscreen instead.');
          Browser.requestFullScreen = function(lockPointer, resizeCanvas, vrDevice) {
            return Browser.requestFullscreen(lockPointer, resizeCanvas, vrDevice);
          }
          return Browser.requestFullscreen(lockPointer, resizeCanvas, vrDevice);
      },nextRAF:0,fakeRequestAnimationFrame:function (func) {
        // try to keep 60fps between calls to here
        var now = Date.now();
        if (Browser.nextRAF === 0) {
          Browser.nextRAF = now + 1000/60;
        } else {
          while (now + 2 >= Browser.nextRAF) { // fudge a little, to avoid timer jitter causing us to do lots of delay:0
            Browser.nextRAF += 1000/60;
          }
        }
        var delay = Math.max(Browser.nextRAF - now, 0);
        setTimeout(func, delay);
      },requestAnimationFrame:function requestAnimationFrame(func) {
        if (typeof window === 'undefined') { // Provide fallback to setTimeout if window is undefined (e.g. in Node.js)
          Browser.fakeRequestAnimationFrame(func);
        } else {
          if (!window.requestAnimationFrame) {
            window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                           window['mozRequestAnimationFrame'] ||
                                           window['webkitRequestAnimationFrame'] ||
                                           window['msRequestAnimationFrame'] ||
                                           window['oRequestAnimationFrame'] ||
                                           Browser.fakeRequestAnimationFrame;
          }
          window.requestAnimationFrame(func);
        }
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:function () {
        Browser.allowAsyncCallbacks = false;
      },resumeAsyncCallbacks:function () { // marks future callbacks as ok to execute, and synchronously runs any remaining ones right now
        Browser.allowAsyncCallbacks = true;
        if (Browser.queuedAsyncCallbacks.length > 0) {
          var callbacks = Browser.queuedAsyncCallbacks;
          Browser.queuedAsyncCallbacks = [];
          callbacks.forEach(function(func) {
            func();
          });
        }
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        });
      },safeSetTimeout:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setTimeout(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } else {
            Browser.queuedAsyncCallbacks.push(func);
          }
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        Module['noExitRuntime'] = true;
        return setInterval(function() {
          if (ABORT) return;
          if (Browser.allowAsyncCallbacks) {
            func();
          } // drop it on the floor otherwise, next interval will kick in
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },getMouseWheelDelta:function (event) {
        var delta = 0;
        switch (event.type) {
          case 'DOMMouseScroll': 
            delta = event.detail;
            break;
          case 'mousewheel': 
            delta = event.wheelDelta;
            break;
          case 'wheel': 
            delta = event['deltaY'];
            break;
          default:
            throw 'unrecognized mouse wheel event: ' + event.type;
        }
        return delta;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          
          // check if SDL is available
          if (typeof SDL != "undefined") {
            Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
            Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
            // just add the mouse delta to the current absolut mouse position
            // FIXME: ideally this should be clamped against the canvas size and zero
            Browser.mouseX += Browser.mouseMovementX;
            Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
  
          // Neither .scrollX or .pageXOffset are defined in a spec, but
          // we prefer .scrollX because it is currently in a spec draft.
          // (see: http://www.w3.org/TR/2013/WD-cssom-view-20131217/)
          var scrollX = ((typeof window.scrollX !== 'undefined') ? window.scrollX : window.pageXOffset);
          var scrollY = ((typeof window.scrollY !== 'undefined') ? window.scrollY : window.pageYOffset);
          // If this assert lands, it's likely because the browser doesn't support scrollX or pageXOffset
          // and we have no viable fallback.
          assert((typeof scrollX !== 'undefined') && (typeof scrollY !== 'undefined'), 'Unable to retrieve scroll position, mouse positions likely broken.');
  
          if (event.type === 'touchstart' || event.type === 'touchend' || event.type === 'touchmove') {
            var touch = event.touch;
            if (touch === undefined) {
              return; // the "touch" property is only defined in SDL
  
            }
            var adjustedX = touch.pageX - (scrollX + rect.left);
            var adjustedY = touch.pageY - (scrollY + rect.top);
  
            adjustedX = adjustedX * (cw / rect.width);
            adjustedY = adjustedY * (ch / rect.height);
  
            var coords = { x: adjustedX, y: adjustedY };
            
            if (event.type === 'touchstart') {
              Browser.lastTouches[touch.identifier] = coords;
              Browser.touches[touch.identifier] = coords;
            } else if (event.type === 'touchend' || event.type === 'touchmove') {
              var last = Browser.touches[touch.identifier];
              if (!last) last = coords;
              Browser.lastTouches[touch.identifier] = last;
              Browser.touches[touch.identifier] = coords;
            } 
            return;
          }
  
          var x = event.pageX - (scrollX + rect.left);
          var y = event.pageY - (scrollY + rect.top);
  
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
  
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        var dep = !noRunDep ? getUniqueRunDependency('al ' + url) : '';
        Module['readAsync'](url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (dep) removeRunDependency(dep);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (dep) addRunDependency(dep);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullscreenCanvasSize:function () {
        // check if SDL is available   
        if (typeof SDL != "undefined") {
          var flags = HEAPU32[((SDL.screen)>>2)];
          flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
          HEAP32[((SDL.screen)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        // check if SDL is available       
        if (typeof SDL != "undefined") {
          var flags = HEAPU32[((SDL.screen)>>2)];
          flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
          HEAP32[((SDL.screen)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },updateCanvasDimensions:function (canvas, wNative, hNative) {
        if (wNative && hNative) {
          canvas.widthNative = wNative;
          canvas.heightNative = hNative;
        } else {
          wNative = canvas.widthNative;
          hNative = canvas.heightNative;
        }
        var w = wNative;
        var h = hNative;
        if (Module['forcedAspectRatio'] && Module['forcedAspectRatio'] > 0) {
          if (w/h < Module['forcedAspectRatio']) {
            w = Math.round(h * Module['forcedAspectRatio']);
          } else {
            h = Math.round(w / Module['forcedAspectRatio']);
          }
        }
        if (((document['fullscreenElement'] || document['mozFullScreenElement'] ||
             document['msFullscreenElement'] || document['webkitFullscreenElement'] ||
             document['webkitCurrentFullScreenElement']) === canvas.parentNode) && (typeof screen != 'undefined')) {
           var factor = Math.min(screen.width / w, screen.height / h);
           w = Math.round(w * factor);
           h = Math.round(h * factor);
        }
        if (Browser.resizeCanvas) {
          if (canvas.width  != w) canvas.width  = w;
          if (canvas.height != h) canvas.height = h;
          if (typeof canvas.style != 'undefined') {
            canvas.style.removeProperty( "width");
            canvas.style.removeProperty("height");
          }
        } else {
          if (canvas.width  != wNative) canvas.width  = wNative;
          if (canvas.height != hNative) canvas.height = hNative;
          if (typeof canvas.style != 'undefined') {
            if (w != wNative || h != hNative) {
              canvas.style.setProperty( "width", w + "px", "important");
              canvas.style.setProperty("height", h + "px", "important");
            } else {
              canvas.style.removeProperty( "width");
              canvas.style.removeProperty("height");
            }
          }
        }
      },wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:function () {
        var handle = Browser.nextWgetRequestHandle;
        Browser.nextWgetRequestHandle++;
        return handle;
      }};
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  var _environ=STATICTOP; STATICTOP += 16;;var ___environ=_environ;function ___buildEnvironment(env) {
      // WARNING: Arbitrary limit!
      var MAX_ENV_VALUES = 64;
      var TOTAL_ENV_SIZE = 1024;
  
      // Statically allocate memory for the environment.
      var poolPtr;
      var envPtr;
      if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        // Set default values. Use string keys for Closure Compiler compatibility.
        ENV['USER'] = ENV['LOGNAME'] = 'web_user';
        ENV['PATH'] = '/';
        ENV['PWD'] = '/';
        ENV['HOME'] = '/home/web_user';
        ENV['LANG'] = 'C.UTF-8';
        ENV['_'] = Module['thisProgram'];
        // Allocate memory.
        poolPtr = staticAlloc(TOTAL_ENV_SIZE);
        envPtr = staticAlloc(MAX_ENV_VALUES * 4);
        HEAP32[((envPtr)>>2)]=poolPtr;
        HEAP32[((_environ)>>2)]=envPtr;
      } else {
        envPtr = HEAP32[((_environ)>>2)];
        poolPtr = HEAP32[((envPtr)>>2)];
      }
  
      // Collect key=value lines.
      var strings = [];
      var totalSize = 0;
      for (var key in env) {
        if (typeof env[key] === 'string') {
          var line = key + '=' + env[key];
          strings.push(line);
          totalSize += line.length;
        }
      }
      if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error('Environment size exceeded TOTAL_ENV_SIZE!');
      }
  
      // Make new.
      var ptrSize = 4;
      for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        writeAsciiToMemory(line, poolPtr);
        HEAP32[(((envPtr)+(i * ptrSize))>>2)]=poolPtr;
        poolPtr += line.length + 1;
      }
      HEAP32[(((envPtr)+(strings.length * ptrSize))>>2)]=0;
    }var ENV={};function _getenv(name) {
      // char *getenv(const char *name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/getenv.html
      if (name === 0) return 0;
      name = Pointer_stringify(name);
      if (!ENV.hasOwnProperty(name)) return 0;
  
      if (_getenv.ret) _free(_getenv.ret);
      _getenv.ret = allocateUTF8(ENV[name]);
      return _getenv.ret;
    }
  
  function _putenv(string) {
      // int putenv(char *string);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/putenv.html
      // WARNING: According to the standard (and the glibc implementation), the
      //          string is taken by reference so future changes are reflected.
      //          We copy it instead, possibly breaking some uses.
      if (string === 0) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      }
      string = Pointer_stringify(string);
      var splitPoint = string.indexOf('=')
      if (string === '' || string.indexOf('=') === -1) {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return -1;
      }
      var name = string.slice(0, splitPoint);
      var value = string.slice(splitPoint + 1);
      if (!(name in ENV) || ENV[name] !== value) {
        ENV[name] = value;
        ___buildEnvironment(ENV);
      }
      return 0;
    }
  
  function _SDL_RWFromConstMem(mem, size) {
      var id = SDL.rwops.length; // TODO: recycle ids when they are null
      SDL.rwops.push({ bytes: mem, count: size });
      return id;
    }function _TTF_FontHeight(font) {
      var fontData = SDL.fonts[font];
      return fontData.size;
    }function _TTF_SizeText(font, text, w, h) {
      var fontData = SDL.fonts[font];
      if (w) {
        HEAP32[((w)>>2)]=SDL.estimateTextWidth(fontData, Pointer_stringify(text));
      }
      if (h) {
        HEAP32[((h)>>2)]=fontData.size;
      }
      return 0;
    }function _TTF_RenderText_Solid(font, text, color) {
      // XXX the font and color are ignored
      text = Pointer_stringify(text) || ' '; // if given an empty string, still return a valid surface
      var fontData = SDL.fonts[font];
      var w = SDL.estimateTextWidth(fontData, text);
      var h = fontData.size;
      color = SDL.loadColorToCSSRGB(color); // XXX alpha breaks fonts?
      var fontString = SDL.makeFontString(h, fontData.name);
      var surf = SDL.makeSurface(w, h, 0, false, 'text:' + text); // bogus numbers..
      var surfData = SDL.surfaces[surf];
      surfData.ctx.save();
      surfData.ctx.fillStyle = color;
      surfData.ctx.font = fontString;
      // use bottom alligment, because it works
      // same in all browsers, more info here:
      // https://bugzilla.mozilla.org/show_bug.cgi?id=737852
      surfData.ctx.textBaseline = 'bottom';
      surfData.ctx.fillText(text, 0, h|0);
      surfData.ctx.restore();
      return surf;
    }function _Mix_HaltMusic() {
      var audio = SDL.music.audio;
      if (audio) {
        audio.src = audio.src; // rewind <media> element
        audio.currentPosition = 0; // rewind Web Audio graph playback.
        audio.pause();
      }
      SDL.music.audio = null;
      if (SDL.hookMusicFinished) {
        Module['dynCall_v'](SDL.hookMusicFinished);
      }
      return 0;
    }function _Mix_PlayMusic(id, loops) {
      // Pause old music if it exists.
      if (SDL.music.audio) {
        if (!SDL.music.audio.paused) Module.printErr('Music is already playing. ' + SDL.music.source);
        SDL.music.audio.pause();
      }
      var info = SDL.audios[id];
      var audio;
      if (info.webAudio) { // Play via Web Audio API
        // Create an instance of the WebAudio object.
        audio = {};
        audio.resource = info; // This new webAudio object is an instance that refers to this existing resource.
        audio.paused = false;
        audio.currentPosition = 0;
        audio.play = function() { SDL.playWebAudio(this); }
        audio.pause = function() { SDL.pauseWebAudio(this); }
      } else if (info.audio) { // Play via the <audio> element
        audio = info.audio;
      }
      audio['onended'] = function() { if (SDL.music.audio == this) _Mix_HaltMusic(); } // will send callback
      audio.loop = loops != 0; // TODO: handle N loops for finite N
      audio.volume = SDL.music.volume;
      SDL.music.audio = audio;
      audio.play();
      return 0;
    }function _Mix_FreeChunk(id) {
      SDL.audios[id] = null;
    }function _Mix_LoadWAV_RW(rwopsID, freesrc) {
      var rwops = SDL.rwops[rwopsID];
  
  
      if (rwops === undefined)
        return 0;
  
      var filename = '';
      var audio;
      var webAudio;
      var bytes;
  
      if (rwops.filename !== undefined) {
        filename = PATH.resolve(rwops.filename);
        var raw = Module["preloadedAudios"][filename];
        if (!raw) {
          if (raw === null) Module.printErr('Trying to reuse preloaded audio, but freePreloadedMediaOnUse is set!');
          if (!Module.noAudioDecoding) warnOnce('Cannot find preloaded audio ' + filename);
  
          // see if we can read the file-contents from the in-memory FS
          try {
            bytes = FS.readFile(filename);
          } catch (e) {
            Module.printErr('Couldn\'t find file for: ' + filename);
            return 0;
          }
        }
        if (Module['freePreloadedMediaOnUse']) {
          Module["preloadedAudios"][filename] = null;
        }
        audio = raw;
      }
      else if (rwops.bytes !== undefined) {
        // For Web Audio context buffer decoding, we must make a clone of the audio data, but for <media> element,
        // a view to existing data is sufficient.
        if (SDL.webAudioAvailable()) bytes = HEAPU8.buffer.slice(rwops.bytes, rwops.bytes + rwops.count);
        else bytes = HEAPU8.subarray(rwops.bytes, rwops.bytes + rwops.count);
      }
      else {
        return 0;
      }
  
      var arrayBuffer = bytes ? bytes.buffer || bytes : bytes;
  
      // To allow user code to work around browser bugs with audio playback on <audio> elements an Web Audio, enable
      // the user code to hook in a callback to decide on a file basis whether each file should use Web Audio or <audio> for decoding and playback.
      // In particular, see https://bugzilla.mozilla.org/show_bug.cgi?id=654787 and ?id=1012801 for tradeoffs.
      var canPlayWithWebAudio = Module['SDL_canPlayWithWebAudio'] === undefined || Module['SDL_canPlayWithWebAudio'](filename, arrayBuffer);
  
      if (bytes !== undefined && SDL.webAudioAvailable() && canPlayWithWebAudio) {
        audio = undefined;
        webAudio = {};
        // The audio decoding process is asynchronous, which gives trouble if user code plays the audio data back immediately
        // after loading. Therefore prepare an array of callback handlers to run when this audio decoding is complete, which
        // will then start the playback (with some delay).
        webAudio.onDecodeComplete = []; // While this member array exists, decoding hasn't finished yet.
        function onDecodeComplete(data) {
          webAudio.decodedBuffer = data;
          // Call all handlers that were waiting for this decode to finish, and clear the handler list.
          webAudio.onDecodeComplete.forEach(function(e) { e(); });
          webAudio.onDecodeComplete = undefined; // Don't allow more callback handlers since audio has finished decoding.
        }
  
        SDL.audioContext['decodeAudioData'](arrayBuffer, onDecodeComplete);
      } else if (audio === undefined && bytes) {
        // Here, we didn't find a preloaded audio but we either were passed a filepath for
        // which we loaded bytes, or we were passed some bytes
        var blob = new Blob([bytes], {type: rwops.mimetype});
        var url = URL.createObjectURL(blob);
        audio = new Audio();
        audio.src = url;
        audio.mozAudioChannelType = 'content'; // bugzilla 910340
      }
  
      var id = SDL.audios.length;
      // Keep the loaded audio in the audio arrays, ready for playback
      SDL.audios.push({
        source: filename,
        audio: audio, // Points to the <audio> element, if loaded
        webAudio: webAudio // Points to a Web Audio -specific resource object, if loaded
      });
      return id;
    }function _Mix_PlayChannel(channel, id, loops) {
      // TODO: handle fixed amount of N loops. Currently loops either 0 or infinite times.
  
      // Get the audio element associated with the ID
      var info = SDL.audios[id];
      if (!info) return -1;
      if (!info.audio && !info.webAudio) return -1;
  
      // If the user asks us to allocate a channel automatically, get the first
      // free one.
      if (channel == -1) {
        for (var i = SDL.channelMinimumNumber; i < SDL.numChannels; i++) {
          if (!SDL.channels[i].audio) {
            channel = i;
            break;
          }
        }
        if (channel == -1) {
          Module.printErr('All ' + SDL.numChannels + ' channels in use!');
          return -1;
        }
      }
      var channelInfo = SDL.channels[channel];
      var audio;
      if (info.webAudio) {
        // Create an instance of the WebAudio object.
        audio = {};
        audio.resource = info; // This new object is an instance that refers to this existing resource.
        audio.paused = false;
        audio.currentPosition = 0;
        // Make our instance look similar to the instance of a <media> to make api simple.
        audio.play = function() { SDL.playWebAudio(this); }
        audio.pause = function() { SDL.pauseWebAudio(this); }
      } else {
        // We clone the audio node to utilize the preloaded audio buffer, since
        // the browser has already preloaded the audio file.
        audio = info.audio.cloneNode(true);
        audio.numChannels = info.audio.numChannels;
        audio.frequency = info.audio.frequency;
      }
      audio['onended'] = function SDL_audio_onended() { // TODO: cache these
        if (channelInfo.audio == this) { channelInfo.audio.paused = true; channelInfo.audio = null; }
        if (SDL.channelFinished) getFuncWrapper(SDL.channelFinished, 'vi')(channel);
      }
      channelInfo.audio = audio;
      // TODO: handle N loops. Behavior matches Mix_PlayMusic
      audio.loop = loops != 0;
      audio.volume = channelInfo.volume;
      audio.play();
      return channel;
    }function _SDL_PauseAudio(pauseOn) {
      if (!SDL.audio) {
        return;
      }
      if (pauseOn) {
        if (SDL.audio.timer !== undefined) {
          clearTimeout(SDL.audio.timer);
          SDL.audio.numAudioTimersPending = 0;
          SDL.audio.timer = undefined;
        }
      } else if (!SDL.audio.timer) {
        // Start the audio playback timer callback loop.
        SDL.audio.numAudioTimersPending = 1;
        SDL.audio.timer = Browser.safeSetTimeout(SDL.audio.caller, 1);
      }
      SDL.audio.paused = pauseOn;
    }function _SDL_CloseAudio() {
      if (SDL.audio) {
        _SDL_PauseAudio(1);
        _free(SDL.audio.buffer);
        SDL.audio = null;
        SDL.allocateChannels(0);
      }
    }function _SDL_LockSurface(surf) {
      var surfData = SDL.surfaces[surf];
  
      surfData.locked++;
      if (surfData.locked > 1) return 0;
  
      if (!surfData.buffer) {
        surfData.buffer = _malloc(surfData.width * surfData.height * 4);
        HEAP32[(((surf)+(20))>>2)]=surfData.buffer;
      }
  
      // Mark in C/C++-accessible SDL structure
      // SDL_Surface has the following fields: Uint32 flags, SDL_PixelFormat *format; int w, h; Uint16 pitch; void *pixels; ...
      // So we have fields all of the same size, and 5 of them before us.
      // TODO: Use macros like in library.js
      HEAP32[(((surf)+(20))>>2)]=surfData.buffer;
  
      if (surf == SDL.screen && Module.screenIsReadOnly && surfData.image) return 0;
  
      if (SDL.defaults.discardOnLock) {
        if (!surfData.image) {
          surfData.image = surfData.ctx.createImageData(surfData.width, surfData.height);
        }
        if (!SDL.defaults.opaqueFrontBuffer) return;
      } else {
        surfData.image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
      }
  
      // Emulate desktop behavior and kill alpha values on the locked surface. (very costly!) Set SDL.defaults.opaqueFrontBuffer = false
      // if you don't want this.
      if (surf == SDL.screen && SDL.defaults.opaqueFrontBuffer) {
        var data = surfData.image.data;
        var num = data.length;
        for (var i = 0; i < num/4; i++) {
          data[i*4+3] = 255; // opacity, as canvases blend alpha
        }
      }
  
      if (SDL.defaults.copyOnLock && !SDL.defaults.discardOnLock) {
        // Copy pixel data to somewhere accessible to 'C/C++'
        if (surfData.isFlagSet(0x00200000 /* SDL_HWPALETTE */)) {
          // If this is neaded then
          // we should compact the data from 32bpp to 8bpp index.
          // I think best way to implement this is use
          // additional colorMap hash (color->index).
          // Something like this:
          //
          // var size = surfData.width * surfData.height;
          // var data = '';
          // for (var i = 0; i<size; i++) {
          //   var color = SDL.translateRGBAToColor(
          //     surfData.image.data[i*4   ],
          //     surfData.image.data[i*4 +1],
          //     surfData.image.data[i*4 +2],
          //     255);
          //   var index = surfData.colorMap[color];
          //   HEAP8[(((surfData.buffer)+(i))>>0)]=index;
          // }
          throw 'CopyOnLock is not supported for SDL_LockSurface with SDL_HWPALETTE flag set' + new Error().stack;
        } else {
          HEAPU8.set(surfData.image.data, surfData.buffer);
        }
      }
  
      return 0;
    }
  
  function _SDL_FreeRW(rwopsID) {
      SDL.rwops[rwopsID] = null;
      while (SDL.rwops.length > 0 && SDL.rwops[SDL.rwops.length-1] === null) {
        SDL.rwops.pop();
      }
    }function _IMG_Load_RW(rwopsID, freeSrc) {
      try {
        // stb_image integration support
        var cleanup = function() {
          if (rwops && freeSrc) _SDL_FreeRW(rwopsID);
        }
        var addCleanup = function(func) {
          var old = cleanup;
          cleanup = function added_cleanup() {
            old();
            func();
          }
        }
        var callStbImage = function(func, params) {
          var x = Module['_malloc'](4);
          var y = Module['_malloc'](4);
          var comp = Module['_malloc'](4);
          addCleanup(function() {
            Module['_free'](x);
            Module['_free'](y);
            Module['_free'](comp);
            if (data) Module['_stbi_image_free'](data);
          });
          var data = Module['_' + func].apply(null, params.concat([x, y, comp, 0]));
          if (!data) return null;
          return {
            rawData: true,
            data: data,
            width: HEAP32[((x)>>2)],
            height: HEAP32[((y)>>2)],
            size: HEAP32[((x)>>2)] * HEAP32[((y)>>2)] * HEAP32[((comp)>>2)],
            bpp: HEAP32[((comp)>>2)]
          };
        }
  
        var rwops = SDL.rwops[rwopsID];
        if (rwops === undefined) {
          return 0;
        }
  
        var filename = rwops.filename;
        if (filename === undefined) {
          warnOnce('Only file names that have been preloaded are supported for IMG_Load_RW. Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins');
          return 0;
        }
  
        if (!raw) {
          filename = PATH.resolve(filename);
          var raw = Module["preloadedImages"][filename];
          if (!raw) {
            if (raw === null) Module.printErr('Trying to reuse preloaded image, but freePreloadedMediaOnUse is set!');
            warnOnce('Cannot find preloaded image ' + filename);
            warnOnce('Cannot find preloaded image ' + filename + '. Consider using STB_IMAGE=1 if you want synchronous image decoding (see settings.js), or package files with --use-preload-plugins');
            return 0;
          } else if (Module['freePreloadedMediaOnUse']) {
            Module["preloadedImages"][filename] = null;
          }
        }
  
        var surf = SDL.makeSurface(raw.width, raw.height, 0, false, 'load:' + filename);
        var surfData = SDL.surfaces[surf];
        surfData.ctx.globalCompositeOperation = "copy";
        if (!raw.rawData) {
          surfData.ctx.drawImage(raw, 0, 0, raw.width, raw.height, 0, 0, raw.width, raw.height);
        } else {
          var imageData = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
          if (raw.bpp == 4) {
            // rgba
            imageData.data.set(HEAPU8.subarray((raw.data),(raw.data+raw.size)));
          } else if (raw.bpp == 3) {
            // rgb
            var pixels = raw.size/3;
            var data = imageData.data;
            var sourcePtr = raw.data;
            var destPtr = 0;
            for (var i = 0; i < pixels; i++) {
              data[destPtr++] = HEAPU8[((sourcePtr++)>>0)];
              data[destPtr++] = HEAPU8[((sourcePtr++)>>0)];
              data[destPtr++] = HEAPU8[((sourcePtr++)>>0)];
              data[destPtr++] = 255;
            }
          } else if (raw.bpp == 2) {
            // grayscale + alpha
            var pixels = raw.size;
            var data = imageData.data;
            var sourcePtr = raw.data;
            var destPtr = 0;
            for (var i = 0; i < pixels; i++) {
              var gray = HEAPU8[((sourcePtr++)>>0)];
              var alpha = HEAPU8[((sourcePtr++)>>0)];
              data[destPtr++] = gray;
              data[destPtr++] = gray;
              data[destPtr++] = gray;
              data[destPtr++] = alpha;
            }
          } else if (raw.bpp == 1) {
            // grayscale
            var pixels = raw.size;
            var data = imageData.data;
            var sourcePtr = raw.data;
            var destPtr = 0;
            for (var i = 0; i < pixels; i++) {
              var value = HEAPU8[((sourcePtr++)>>0)];
              data[destPtr++] = value;
              data[destPtr++] = value;
              data[destPtr++] = value;
              data[destPtr++] = 255;
            }
          } else {
            Module.printErr('cannot handle bpp ' + raw.bpp);
            return 0;
          }
          surfData.ctx.putImageData(imageData, 0, 0);
        }
        surfData.ctx.globalCompositeOperation = "source-over";
        // XXX SDL does not specify that loaded images must have available pixel data, in fact
        //     there are cases where you just want to blit them, so you just need the hardware
        //     accelerated version. However, code everywhere seems to assume that the pixels
        //     are in fact available, so we retrieve it here. This does add overhead though.
        _SDL_LockSurface(surf);
        surfData.locked--; // The surface is not actually locked in this hack
        if (SDL.GL) {
          // After getting the pixel data, we can free the canvas and context if we do not need to do 2D canvas blitting
          surfData.canvas = surfData.ctx = null;
        }
        return surf;
      } finally {
        cleanup();
      }
    }
  
  function _SDL_RWFromFile(_name, mode) {
      var id = SDL.rwops.length; // TODO: recycle ids when they are null
      var name = Pointer_stringify(_name)
      SDL.rwops.push({ filename: name, mimetype: Browser.getMimetype(name) });
      return id;
    }function _IMG_Load(filename){
      var rwops = _SDL_RWFromFile(filename);
      var result = _IMG_Load_RW(rwops, 1);
      return result;
    }function _SDL_UpperBlitScaled(src, srcrect, dst, dstrect) {
      return SDL.blitSurface(src, srcrect, dst, dstrect, true);
    }function _SDL_UpperBlit(src, srcrect, dst, dstrect) {
      return SDL.blitSurface(src, srcrect, dst, dstrect, false);
    }function _SDL_GetTicks() {
      return (Date.now() - SDL.startTime)|0;
    }var SDL={defaults:{width:320,height:200,copyOnLock:true,discardOnLock:false,opaqueFrontBuffer:true},version:null,surfaces:{},canvasPool:[],events:[],fonts:[null],audios:[null],rwops:[null],music:{audio:null,volume:1},mixerFrequency:22050,mixerFormat:32784,mixerNumChannels:2,mixerChunkSize:1024,channelMinimumNumber:0,GL:false,glAttributes:{0:3,1:3,2:2,3:0,4:0,5:1,6:16,7:0,8:0,9:0,10:0,11:0,12:0,13:0,14:0,15:1,16:0,17:0,18:0},keyboardState:null,keyboardMap:{},canRequestFullscreen:false,isRequestingFullscreen:false,textInput:false,startTime:null,initFlags:0,buttonState:0,modState:0,DOMButtons:[0,0,0],DOMEventToSDLEvent:{},TOUCH_DEFAULT_ID:0,eventHandler:null,eventHandlerContext:null,eventHandlerTemp:0,keyCodes:{16:1249,17:1248,18:1250,20:1081,33:1099,34:1102,35:1101,36:1098,37:1104,38:1106,39:1103,40:1105,44:316,45:1097,46:127,91:1251,93:1125,96:1122,97:1113,98:1114,99:1115,100:1116,101:1117,102:1118,103:1119,104:1120,105:1121,106:1109,107:1111,109:1110,110:1123,111:1108,112:1082,113:1083,114:1084,115:1085,116:1086,117:1087,118:1088,119:1089,120:1090,121:1091,122:1092,123:1093,124:1128,125:1129,126:1130,127:1131,128:1132,129:1133,130:1134,131:1135,132:1136,133:1137,134:1138,135:1139,144:1107,160:94,161:33,162:34,163:35,164:36,165:37,166:38,167:95,168:40,169:41,170:42,171:43,172:124,173:45,174:123,175:125,176:126,181:127,182:129,183:128,188:44,190:46,191:47,192:96,219:91,220:92,221:93,222:39,224:1251},scanCodes:{8:42,9:43,13:40,27:41,32:44,35:204,39:53,44:54,46:55,47:56,48:39,49:30,50:31,51:32,52:33,53:34,54:35,55:36,56:37,57:38,58:203,59:51,61:46,91:47,92:49,93:48,96:52,97:4,98:5,99:6,100:7,101:8,102:9,103:10,104:11,105:12,106:13,107:14,108:15,109:16,110:17,111:18,112:19,113:20,114:21,115:22,116:23,117:24,118:25,119:26,120:27,121:28,122:29,127:76,305:224,308:226,316:70},loadRect:function (rect) {
        return {
          x: HEAP32[((rect + 0)>>2)],
          y: HEAP32[((rect + 4)>>2)],
          w: HEAP32[((rect + 8)>>2)],
          h: HEAP32[((rect + 12)>>2)]
        };
      },updateRect:function (rect, r) {
        HEAP32[((rect)>>2)]=r.x;
        HEAP32[(((rect)+(4))>>2)]=r.y;
        HEAP32[(((rect)+(8))>>2)]=r.w;
        HEAP32[(((rect)+(12))>>2)]=r.h;
      },intersectionOfRects:function (first, second) {
        var leftX = Math.max(first.x, second.x);
        var leftY = Math.max(first.y, second.y);
        var rightX = Math.min(first.x + first.w, second.x + second.w);
        var rightY = Math.min(first.y + first.h, second.y + second.h);
  
        return {
          x: leftX,
          y: leftY,
          w: Math.max(leftX, rightX) - leftX,
          h: Math.max(leftY, rightY) - leftY
        }
      },checkPixelFormat:function (fmt) {
        // Canvas screens are always RGBA.
        var format = HEAP32[((fmt)>>2)];
        if (format != -2042224636) {
          warnOnce('Unsupported pixel format!');
        }
      },loadColorToCSSRGB:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgb(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ')';
      },loadColorToCSSRGBA:function (color) {
        var rgba = HEAP32[((color)>>2)];
        return 'rgba(' + (rgba&255) + ',' + ((rgba >> 8)&255) + ',' + ((rgba >> 16)&255) + ',' + (((rgba >> 24)&255)/255) + ')';
      },translateColorToCSSRGBA:function (rgba) {
        return 'rgba(' + (rgba&0xff) + ',' + (rgba>>8 & 0xff) + ',' + (rgba>>16 & 0xff) + ',' + (rgba>>>24)/0xff + ')';
      },translateRGBAToCSSRGBA:function (r, g, b, a) {
        return 'rgba(' + (r&0xff) + ',' + (g&0xff) + ',' + (b&0xff) + ',' + (a&0xff)/255 + ')';
      },translateRGBAToColor:function (r, g, b, a) {
        return r | g << 8 | b << 16 | a << 24;
      },makeSurface:function (width, height, flags, usePageCanvas, source, rmask, gmask, bmask, amask) {
        flags = flags || 0;
        var is_SDL_HWSURFACE = flags & 0x00000001;
        var is_SDL_HWPALETTE = flags & 0x00200000;
        var is_SDL_OPENGL = flags & 0x04000000;
  
        var surf = _malloc(60);
        var pixelFormat = _malloc(44);
        //surface with SDL_HWPALETTE flag is 8bpp surface (1 byte)
        var bpp = is_SDL_HWPALETTE ? 1 : 4;
        var buffer = 0;
  
        // preemptively initialize this for software surfaces,
        // otherwise it will be lazily initialized inside of SDL_LockSurface
        if (!is_SDL_HWSURFACE && !is_SDL_OPENGL) {
          buffer = _malloc(width * height * 4);
        }
  
        HEAP32[((surf)>>2)]=flags;
        HEAP32[(((surf)+(4))>>2)]=pixelFormat;
        HEAP32[(((surf)+(8))>>2)]=width;
        HEAP32[(((surf)+(12))>>2)]=height;
        HEAP32[(((surf)+(16))>>2)]=width * bpp;  // assuming RGBA or indexed for now,
                                                                                          // since that is what ImageData gives us in browsers
        HEAP32[(((surf)+(20))>>2)]=buffer;
  
        HEAP32[(((surf)+(36))>>2)]=0;
        HEAP32[(((surf)+(40))>>2)]=0;
        HEAP32[(((surf)+(44))>>2)]=Module["canvas"].width;
        HEAP32[(((surf)+(48))>>2)]=Module["canvas"].height;
  
        HEAP32[(((surf)+(56))>>2)]=1;
  
        HEAP32[((pixelFormat)>>2)]=-2042224636;
        HEAP32[(((pixelFormat)+(4))>>2)]=0;// TODO
        HEAP8[(((pixelFormat)+(8))>>0)]=bpp * 8;
        HEAP8[(((pixelFormat)+(9))>>0)]=bpp;
  
        HEAP32[(((pixelFormat)+(12))>>2)]=rmask || 0x000000ff;
        HEAP32[(((pixelFormat)+(16))>>2)]=gmask || 0x0000ff00;
        HEAP32[(((pixelFormat)+(20))>>2)]=bmask || 0x00ff0000;
        HEAP32[(((pixelFormat)+(24))>>2)]=amask || 0xff000000;
  
        // Decide if we want to use WebGL or not
        SDL.GL = SDL.GL || is_SDL_OPENGL;
        var canvas;
        if (!usePageCanvas) {
          if (SDL.canvasPool.length > 0) {
            canvas = SDL.canvasPool.pop();
          } else {
            canvas = document.createElement('canvas');
          }
          canvas.width = width;
          canvas.height = height;
        } else {
          canvas = Module['canvas'];
        }
  
        var webGLContextAttributes = {
          antialias: ((SDL.glAttributes[13 /*SDL_GL_MULTISAMPLEBUFFERS*/] != 0) && (SDL.glAttributes[14 /*SDL_GL_MULTISAMPLESAMPLES*/] > 1)),
          depth: (SDL.glAttributes[6 /*SDL_GL_DEPTH_SIZE*/] > 0),
          stencil: (SDL.glAttributes[7 /*SDL_GL_STENCIL_SIZE*/] > 0),
          alpha: (SDL.glAttributes[3 /*SDL_GL_ALPHA_SIZE*/] > 0)
        };
  
        var ctx = Browser.createContext(canvas, is_SDL_OPENGL, usePageCanvas, webGLContextAttributes);
  
        SDL.surfaces[surf] = {
          width: width,
          height: height,
          canvas: canvas,
          ctx: ctx,
          surf: surf,
          buffer: buffer,
          pixelFormat: pixelFormat,
          alpha: 255,
          flags: flags,
          locked: 0,
          usePageCanvas: usePageCanvas,
          source: source,
  
          isFlagSet: function(flag) {
            return flags & flag;
          }
        };
  
        return surf;
      },copyIndexedColorData:function (surfData, rX, rY, rW, rH) {
        // HWPALETTE works with palette
        // setted by SDL_SetColors
        if (!surfData.colors) {
          return;
        }
  
        var fullWidth  = Module['canvas'].width;
        var fullHeight = Module['canvas'].height;
  
        var startX  = rX || 0;
        var startY  = rY || 0;
        var endX    = (rW || (fullWidth - startX)) + startX;
        var endY    = (rH || (fullHeight - startY)) + startY;
  
        var buffer  = surfData.buffer;
  
        if (!surfData.image.data32) {
          surfData.image.data32 = new Uint32Array(surfData.image.data.buffer);
        }
        var data32   = surfData.image.data32;
  
        var colors32 = surfData.colors32;
  
        for (var y = startY; y < endY; ++y) {
          var base = y * fullWidth;
          for (var x = startX; x < endX; ++x) {
            data32[base + x] = colors32[HEAPU8[((buffer + base + x)>>0)]];
          }
        }
      },freeSurface:function (surf) {
        var refcountPointer = surf + 56;
        var refcount = HEAP32[((refcountPointer)>>2)];
        if (refcount > 1) {
          HEAP32[((refcountPointer)>>2)]=refcount - 1;
          return;
        }
  
        var info = SDL.surfaces[surf];
        if (!info.usePageCanvas && info.canvas) SDL.canvasPool.push(info.canvas);
        if (info.buffer) _free(info.buffer);
        _free(info.pixelFormat);
        _free(surf);
        SDL.surfaces[surf] = null;
  
        if (surf === SDL.screen) {
          SDL.screen = null;
        }
      },blitSurface__deps:["SDL_LockSurface"],blitSurface:function (src, srcrect, dst, dstrect, scale) {
        var srcData = SDL.surfaces[src];
        var dstData = SDL.surfaces[dst];
        var sr, dr;
        if (srcrect) {
          sr = SDL.loadRect(srcrect);
        } else {
          sr = { x: 0, y: 0, w: srcData.width, h: srcData.height };
        }
        if (dstrect) {
          dr = SDL.loadRect(dstrect);
        } else {
          dr = { x: 0, y: 0, w: srcData.width, h: srcData.height };
        }
        if (dstData.clipRect) {
          var widthScale = (!scale || sr.w === 0) ? 1 : sr.w / dr.w;
          var heightScale = (!scale || sr.h === 0) ? 1 : sr.h / dr.h;
  
          dr = SDL.intersectionOfRects(dstData.clipRect, dr);
  
          sr.w = dr.w * widthScale;
          sr.h = dr.h * heightScale;
  
          if (dstrect) {
            SDL.updateRect(dstrect, dr);
          }
        }
        var blitw, blith;
        if (scale) {
          blitw = dr.w; blith = dr.h;
        } else {
          blitw = sr.w; blith = sr.h;
        }
        if (sr.w === 0 || sr.h === 0 || blitw === 0 || blith === 0) {
          return 0;
        }
        var oldAlpha = dstData.ctx.globalAlpha;
        dstData.ctx.globalAlpha = srcData.alpha/255;
        dstData.ctx.drawImage(srcData.canvas, sr.x, sr.y, sr.w, sr.h, dr.x, dr.y, blitw, blith);
        dstData.ctx.globalAlpha = oldAlpha;
        if (dst != SDL.screen) {
          // XXX As in IMG_Load, for compatibility we write out |pixels|
          warnOnce('WARNING: copying canvas data to memory for compatibility');
          _SDL_LockSurface(dst);
          dstData.locked--; // The surface is not actually locked in this hack
        }
        return 0;
      },downFingers:{},savedKeydown:null,receiveEvent:function (event) {
        function unpressAllPressedKeys() {
          // Un-press all pressed keys: TODO
          for (var code in SDL.keyboardMap) {
            SDL.events.push({
              type: 'keyup',
              keyCode: SDL.keyboardMap[code]
            });
          }
        };
        switch(event.type) {
          case 'touchstart': case 'touchmove': {
            event.preventDefault();
  
            var touches = [];
  
            // Clear out any touchstart events that we've already processed
            if (event.type === 'touchstart') {
              for (var i = 0; i < event.touches.length; i++) {
                var touch = event.touches[i];
                if (SDL.downFingers[touch.identifier] != true) {
                  SDL.downFingers[touch.identifier] = true;
                  touches.push(touch);
                }
              }
            } else {
              touches = event.touches;
            }
  
            var firstTouch = touches[0];
            if (firstTouch) {
              if (event.type == 'touchstart') {
                SDL.DOMButtons[0] = 1;
              }
              var mouseEventType;
              switch(event.type) {
                case 'touchstart': mouseEventType = 'mousedown'; break;
                case 'touchmove': mouseEventType = 'mousemove'; break;
              }
              var mouseEvent = {
                type: mouseEventType,
                button: 0,
                pageX: firstTouch.clientX,
                pageY: firstTouch.clientY
              };
              SDL.events.push(mouseEvent);
            }
  
            for (var i = 0; i < touches.length; i++) {
              var touch = touches[i];
              SDL.events.push({
                type: event.type,
                touch: touch
              });
            };
            break;
          }
          case 'touchend': {
            event.preventDefault();
  
            // Remove the entry in the SDL.downFingers hash
            // because the finger is no longer down.
            for(var i = 0; i < event.changedTouches.length; i++) {
              var touch = event.changedTouches[i];
              if (SDL.downFingers[touch.identifier] === true) {
                delete SDL.downFingers[touch.identifier];
              }
            }
  
            var mouseEvent = {
              type: 'mouseup',
              button: 0,
              pageX: event.changedTouches[0].clientX,
              pageY: event.changedTouches[0].clientY
            };
            SDL.DOMButtons[0] = 0;
            SDL.events.push(mouseEvent);
  
            for (var i = 0; i < event.changedTouches.length; i++) {
              var touch = event.changedTouches[i];
              SDL.events.push({
                type: 'touchend',
                touch: touch
              });
            };
            break;
          }
          case 'DOMMouseScroll': case 'mousewheel': case 'wheel':
            var delta = -Browser.getMouseWheelDelta(event); // Flip the wheel direction to translate from browser wheel direction (+:down) to SDL direction (+:up)
            delta = (delta == 0) ? 0 : (delta > 0 ? Math.max(delta, 1) : Math.min(delta, -1)); // Quantize to integer so that minimum scroll is at least +/- 1.
  
            // Simulate old-style SDL events representing mouse wheel input as buttons
            var button = delta > 0 ? 3 /*SDL_BUTTON_WHEELUP-1*/ : 4 /*SDL_BUTTON_WHEELDOWN-1*/; // Subtract one since JS->C marshalling is defined to add one back.
            SDL.events.push({ type: 'mousedown', button: button, pageX: event.pageX, pageY: event.pageY });
            SDL.events.push({ type: 'mouseup', button: button, pageX: event.pageX, pageY: event.pageY });
  
            // Pass a delta motion event.
            SDL.events.push({ type: 'wheel', deltaX: 0, deltaY: delta });
            event.preventDefault(); // If we don't prevent this, then 'wheel' event will be sent again by the browser as 'DOMMouseScroll' and we will receive this same event the second time.
            break;
          case 'mousemove':
            if (SDL.DOMButtons[0] === 1) {
              SDL.events.push({
                type: 'touchmove',
                touch: {
                  identifier: 0,
                  deviceID: -1,
                  pageX: event.pageX,
                  pageY: event.pageY
                }
              });
            }
            if (Browser.pointerLock) {
              // workaround for firefox bug 750111
              if ('mozMovementX' in event) {
                event['movementX'] = event['mozMovementX'];
                event['movementY'] = event['mozMovementY'];
              }
              // workaround for Firefox bug 782777
              if (event['movementX'] == 0 && event['movementY'] == 0) {
                // ignore a mousemove event if it doesn't contain any movement info
                // (without pointer lock, we infer movement from pageX/pageY, so this check is unnecessary)
                event.preventDefault();
                return;
              }
            }
            // fall through
          case 'keydown': case 'keyup': case 'keypress': case 'mousedown': case 'mouseup':
            // If we preventDefault on keydown events, the subsequent keypress events
            // won't fire. However, it's fine (and in some cases necessary) to
            // preventDefault for keys that don't generate a character. Otherwise,
            // preventDefault is the right thing to do in general.
            if (event.type !== 'keydown' || (!SDL.unicode && !SDL.textInput) || (event.keyCode === 8 /* backspace */ || event.keyCode === 9 /* tab */)) {
              event.preventDefault();
            }
  
            if (event.type == 'mousedown') {
              SDL.DOMButtons[event.button] = 1;
              SDL.events.push({
                type: 'touchstart',
                touch: {
                  identifier: 0,
                  deviceID: -1,
                  pageX: event.pageX,
                  pageY: event.pageY
                }
              });
            } else if (event.type == 'mouseup') {
              // ignore extra ups, can happen if we leave the canvas while pressing down, then return,
              // since we add a mouseup in that case
              if (!SDL.DOMButtons[event.button]) {
                return;
              }
  
              SDL.events.push({
                type: 'touchend',
                touch: {
                  identifier: 0,
                  deviceID: -1,
                  pageX: event.pageX,
                  pageY: event.pageY
                }
              });
              SDL.DOMButtons[event.button] = 0;
            }
  
            // We can only request fullscreen as the result of user input.
            // Due to this limitation, we toggle a boolean on keydown which
            // SDL_WM_ToggleFullScreen will check and subsequently set another
            // flag indicating for us to request fullscreen on the following
            // keyup. This isn't perfect, but it enables SDL_WM_ToggleFullScreen
            // to work as the result of a keypress (which is an extremely
            // common use case).
            if (event.type === 'keydown' || event.type === 'mousedown') {
              SDL.canRequestFullscreen = true;
            } else if (event.type === 'keyup' || event.type === 'mouseup') {
              if (SDL.isRequestingFullscreen) {
                Module['requestFullscreen'](/*lockPointer=*/true, /*resizeCanvas=*/true);
                SDL.isRequestingFullscreen = false;
              }
              SDL.canRequestFullscreen = false;
            }
  
            // SDL expects a unicode character to be passed to its keydown events.
            // Unfortunately, the browser APIs only provide a charCode property on
            // keypress events, so we must backfill in keydown events with their
            // subsequent keypress event's charCode.
            if (event.type === 'keypress' && SDL.savedKeydown) {
              // charCode is read-only
              SDL.savedKeydown.keypressCharCode = event.charCode;
              SDL.savedKeydown = null;
            } else if (event.type === 'keydown') {
              SDL.savedKeydown = event;
            }
  
            // Don't push keypress events unless SDL_StartTextInput has been called.
            if (event.type !== 'keypress' || SDL.textInput) {
              SDL.events.push(event);
            }
            break;
          case 'mouseout':
            // Un-press all pressed mouse buttons, because we might miss the release outside of the canvas
            for (var i = 0; i < 3; i++) {
              if (SDL.DOMButtons[i]) {
                SDL.events.push({
                  type: 'mouseup',
                  button: i,
                  pageX: event.pageX,
                  pageY: event.pageY
                });
                SDL.DOMButtons[i] = 0;
              }
            }
            event.preventDefault();
            break;
          case 'focus':
            SDL.events.push(event);
            event.preventDefault();
            break;
          case 'blur':
            SDL.events.push(event);
            unpressAllPressedKeys();
            event.preventDefault();
            break;
          case 'visibilitychange':
            SDL.events.push({
              type: 'visibilitychange',
              visible: !document.hidden
            });
            unpressAllPressedKeys();
            event.preventDefault();
            break;
          case 'unload':
            if (Browser.mainLoop.runner) {
              SDL.events.push(event);
              // Force-run a main event loop, since otherwise this event will never be caught!
              Browser.mainLoop.runner();
            }
            return;
          case 'resize':
            SDL.events.push(event);
            // manually triggered resize event doesn't have a preventDefault member
            if (event.preventDefault) {
              event.preventDefault();
            }
            break;
        }
        if (SDL.events.length >= 10000) {
          Module.printErr('SDL event queue full, dropping events');
          SDL.events = SDL.events.slice(0, 10000);
        }
        // If we have a handler installed, this will push the events to the app
        // instead of the app polling for them.
        SDL.flushEventsToHandler();
        return;
      },lookupKeyCodeForEvent:function (event) {
          var code = event.keyCode;
          if (code >= 65 && code <= 90) {
            code += 32; // make lowercase for SDL
          } else {
            code = SDL.keyCodes[event.keyCode] || event.keyCode;
            // If this is one of the modifier keys (224 | 1<<10 - 227 | 1<<10), and the event specifies that it is
            // a right key, add 4 to get the right key SDL key code.
            if (event.location === KeyboardEvent.DOM_KEY_LOCATION_RIGHT && code >= (224 | 1<<10) && code <= (227 | 1<<10)) {
              code += 4;
            }
          }
          return code;
      },handleEvent:function (event) {
        if (event.handled) return;
        event.handled = true;
  
        switch (event.type) {
          case 'touchstart': case 'touchend': case 'touchmove': {
            Browser.calculateMouseEvent(event);
            break;
          }
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            var code = SDL.lookupKeyCodeForEvent(event);
            HEAP8[(((SDL.keyboardState)+(code))>>0)]=down;
            // TODO: lmeta, rmeta, numlock, capslock, KMOD_MODE, KMOD_RESERVED
            SDL.modState = (HEAP8[(((SDL.keyboardState)+(1248))>>0)] ? 0x0040 : 0) | // KMOD_LCTRL
              (HEAP8[(((SDL.keyboardState)+(1249))>>0)] ? 0x0001 : 0) | // KMOD_LSHIFT
              (HEAP8[(((SDL.keyboardState)+(1250))>>0)] ? 0x0100 : 0) | // KMOD_LALT
              (HEAP8[(((SDL.keyboardState)+(1252))>>0)] ? 0x0080 : 0) | // KMOD_RCTRL
              (HEAP8[(((SDL.keyboardState)+(1253))>>0)] ? 0x0002 : 0) | // KMOD_RSHIFT
              (HEAP8[(((SDL.keyboardState)+(1254))>>0)] ? 0x0200 : 0); //  KMOD_RALT
            if (down) {
              SDL.keyboardMap[code] = event.keyCode; // save the DOM input, which we can use to unpress it during blur
            } else {
              delete SDL.keyboardMap[code];
            }
  
            break;
          }
          case 'mousedown': case 'mouseup':
            if (event.type == 'mousedown') {
              // SDL_BUTTON(x) is defined as (1 << ((x)-1)).  SDL buttons are 1-3,
              // and DOM buttons are 0-2, so this means that the below formula is
              // correct.
              SDL.buttonState |= 1 << event.button;
            } else if (event.type == 'mouseup') {
              SDL.buttonState &= ~(1 << event.button);
            }
            // fall through
          case 'mousemove': {
            Browser.calculateMouseEvent(event);
            break;
          }
        }
      },flushEventsToHandler:function () {
        if (!SDL.eventHandler) return;
  
        while (SDL.pollEvent(SDL.eventHandlerTemp)) {
          Module['dynCall_iii'](SDL.eventHandler, SDL.eventHandlerContext, SDL.eventHandlerTemp);
        }
      },pollEvent:function (ptr) {
        if (SDL.initFlags & 0x200 && SDL.joystickEventState) {
          // If SDL_INIT_JOYSTICK was supplied AND the joystick system is configured
          // to automatically query for events, query for joystick events.
          SDL.queryJoysticks();
        }
        if (ptr) {
          while (SDL.events.length > 0) {
            if (SDL.makeCEvent(SDL.events.shift(), ptr) !== false) return 1;
          }
          return 0;
        } else {
          // XXX: somewhat risky in that we do not check if the event is real or not (makeCEvent returns false) if no pointer supplied
          return SDL.events.length > 0;
        }
      },makeCEvent:function (event, ptr) {
        if (typeof event === 'number') {
          // This is a pointer to a copy of a native C event that was SDL_PushEvent'ed
          _memcpy(ptr, event, 28);
          _free(event); // the copy is no longer needed
          return;
        }
  
        SDL.handleEvent(event);
  
        switch (event.type) {
          case 'keydown': case 'keyup': {
            var down = event.type === 'keydown';
            //Module.print('Received key event: ' + event.keyCode);
            var key = SDL.lookupKeyCodeForEvent(event);
            var scan;
            if (key >= 1024) {
              scan = key - 1024;
            } else {
              scan = SDL.scanCodes[key] || key;
            }
  
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(8))>>0)]=down ? 1 : 0;
            HEAP8[(((ptr)+(9))>>0)]=0; // TODO
            HEAP32[(((ptr)+(12))>>2)]=scan;
            HEAP32[(((ptr)+(16))>>2)]=key;
            HEAP16[(((ptr)+(20))>>1)]=SDL.modState;
            // some non-character keys (e.g. backspace and tab) won't have keypressCharCode set, fill in with the keyCode.
            HEAP32[(((ptr)+(24))>>2)]=event.keypressCharCode || key;
  
            break;
          }
          case 'keypress': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            // Not filling in windowID for now
            var cStr = intArrayFromString(String.fromCharCode(event.charCode));
            for (var i = 0; i < cStr.length; ++i) {
              HEAP8[(((ptr)+(8 + i))>>0)]=cStr[i];
            }
            break;
          }
          case 'mousedown': case 'mouseup': case 'mousemove': {
            if (event.type != 'mousemove') {
              var down = event.type === 'mousedown';
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP32[(((ptr)+(4))>>2)]=0;
              HEAP32[(((ptr)+(8))>>2)]=0;
              HEAP32[(((ptr)+(12))>>2)]=0;
              HEAP8[(((ptr)+(16))>>0)]=event.button+1; // DOM buttons are 0-2, SDL 1-3
              HEAP8[(((ptr)+(17))>>0)]=down ? 1 : 0;
              HEAP32[(((ptr)+(20))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(24))>>2)]=Browser.mouseY;
            } else {
              HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
              HEAP32[(((ptr)+(4))>>2)]=0;
              HEAP32[(((ptr)+(8))>>2)]=0;
              HEAP32[(((ptr)+(12))>>2)]=0;
              HEAP32[(((ptr)+(16))>>2)]=SDL.buttonState;
              HEAP32[(((ptr)+(20))>>2)]=Browser.mouseX;
              HEAP32[(((ptr)+(24))>>2)]=Browser.mouseY;
              HEAP32[(((ptr)+(28))>>2)]=Browser.mouseMovementX;
              HEAP32[(((ptr)+(32))>>2)]=Browser.mouseMovementY;
            }
            break;
          }
          case 'wheel': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(16))>>2)]=event.deltaX;
            HEAP32[(((ptr)+(20))>>2)]=event.deltaY;
            break;
          }
          case 'touchstart': case 'touchend': case 'touchmove': {
            var touch = event.touch;
            if (!Browser.touches[touch.identifier]) break;
            var w = Module['canvas'].width;
            var h = Module['canvas'].height;
            var x = Browser.touches[touch.identifier].x / w;
            var y = Browser.touches[touch.identifier].y / h;
            var lx = Browser.lastTouches[touch.identifier].x / w;
            var ly = Browser.lastTouches[touch.identifier].y / h;
            var dx = x - lx;
            var dy = y - ly;
            if (touch['deviceID'] === undefined) touch.deviceID = SDL.TOUCH_DEFAULT_ID;
            if (dx === 0 && dy === 0 && event.type === 'touchmove') return false; // don't send these if nothing happened
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=_SDL_GetTicks();
            (tempI64 = [touch.deviceID>>>0,(tempDouble=touch.deviceID,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[(((ptr)+(8))>>2)]=tempI64[0],HEAP32[(((ptr)+(12))>>2)]=tempI64[1]);
            (tempI64 = [touch.identifier>>>0,(tempDouble=touch.identifier,(+(Math_abs(tempDouble))) >= 1.0 ? (tempDouble > 0.0 ? ((Math_min((+(Math_floor((tempDouble)/4294967296.0))), 4294967295.0))|0)>>>0 : (~~((+(Math_ceil((tempDouble - +(((~~(tempDouble)))>>>0))/4294967296.0)))))>>>0) : 0)],HEAP32[(((ptr)+(16))>>2)]=tempI64[0],HEAP32[(((ptr)+(20))>>2)]=tempI64[1]);
            HEAPF32[(((ptr)+(24))>>2)]=x;
            HEAPF32[(((ptr)+(28))>>2)]=y;
            HEAPF32[(((ptr)+(32))>>2)]=dx;
            HEAPF32[(((ptr)+(36))>>2)]=dy;
            if (touch.force !== undefined) {
              HEAPF32[(((ptr)+(40))>>2)]=touch.force;
            } else { // No pressure data, send a digital 0/1 pressure.
              HEAPF32[(((ptr)+(40))>>2)]=event.type == "touchend" ? 0 : 1;
            }
            break;
          }
          case 'unload': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            break;
          }
          case 'resize': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=event.w;
            HEAP32[(((ptr)+(8))>>2)]=event.h;
            break;
          }
          case 'joystick_button_up': case 'joystick_button_down': {
            var state = event.type === 'joystick_button_up' ? 0 : 1;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))>>0)]=event.index;
            HEAP8[(((ptr)+(5))>>0)]=event.button;
            HEAP8[(((ptr)+(6))>>0)]=state;
            break;
          }
          case 'joystick_axis_motion': {
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP8[(((ptr)+(4))>>0)]=event.index;
            HEAP8[(((ptr)+(5))>>0)]=event.axis;
            HEAP32[(((ptr)+(8))>>2)]=SDL.joystickAxisValueConversion(event.value);
            break;
          }
          case 'focus': {
            var SDL_WINDOWEVENT_FOCUS_GAINED = 12 /* SDL_WINDOWEVENT_FOCUS_GAINED */;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=0;
            HEAP8[(((ptr)+(8))>>0)]=SDL_WINDOWEVENT_FOCUS_GAINED;
            break;
          }
          case 'blur': {
            var SDL_WINDOWEVENT_FOCUS_LOST = 13 /* SDL_WINDOWEVENT_FOCUS_LOST */;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=0;
            HEAP8[(((ptr)+(8))>>0)]=SDL_WINDOWEVENT_FOCUS_LOST;
            break;
          }
          case 'visibilitychange': {
            var SDL_WINDOWEVENT_SHOWN  = 1 /* SDL_WINDOWEVENT_SHOWN */;
            var SDL_WINDOWEVENT_HIDDEN = 2 /* SDL_WINDOWEVENT_HIDDEN */;
            var visibilityEventID = event.visible ? SDL_WINDOWEVENT_SHOWN : SDL_WINDOWEVENT_HIDDEN;
            HEAP32[((ptr)>>2)]=SDL.DOMEventToSDLEvent[event.type];
            HEAP32[(((ptr)+(4))>>2)]=0;
            HEAP8[(((ptr)+(8))>>0)]=visibilityEventID;
            break;
          }
          default: throw 'Unhandled SDL event: ' + event.type;
        }
      },makeFontString:function (height, fontName) {
        if (fontName.charAt(0) != "'" && fontName.charAt(0) != '"') {
          // https://developer.mozilla.org/ru/docs/Web/CSS/font-family
          // Font family names containing whitespace should be quoted.
          // BTW, quote all font names is easier than searching spaces
          fontName = '"' + fontName + '"';
        }
        return height + 'px ' + fontName + ', serif';
      },estimateTextWidth:function (fontData, text) {
        var h = fontData.size;
        var fontString = SDL.makeFontString(h, fontData.name);
        var tempCtx = SDL.ttfContext;
        assert(tempCtx, 'TTF_Init must have been called');
        tempCtx.save();
        tempCtx.font = fontString;
        var ret = tempCtx.measureText(text).width | 0;
        tempCtx.restore();
        return ret;
      },allocateChannels:function (num) { // called from Mix_AllocateChannels and init
        if (SDL.numChannels && SDL.numChannels >= num && num != 0) return;
        SDL.numChannels = num;
        SDL.channels = [];
        for (var i = 0; i < num; i++) {
          SDL.channels[i] = {
            audio: null,
            volume: 1.0
          };
        }
      },setGetVolume:function (info, volume) {
        if (!info) return 0;
        var ret = info.volume * 128; // MIX_MAX_VOLUME
        if (volume != -1) {
          info.volume = Math.min(Math.max(volume, 0), 128) / 128;
          if (info.audio) {
            try {
              info.audio.volume = info.volume; // For <audio> element
              if (info.audio.webAudioGainNode) info.audio.webAudioGainNode['gain']['value'] = info.volume; // For WebAudio playback
            } catch(e) {
              Module.printErr('setGetVolume failed to set audio volume: ' + e);
            }
          }
        }
        return ret;
      },setPannerPosition:function (info, x, y, z) {
        if (!info) return;
        if (info.audio) {
          if (info.audio.webAudioPannerNode) {
            info.audio.webAudioPannerNode['setPosition'](x, y, z);
          }
        }
      },playWebAudio:function (audio) {
        if (!audio) return;
        if (audio.webAudioNode) return; // This instance is already playing, don't start again.
        if (!SDL.webAudioAvailable()) return;
        try {
          var webAudio = audio.resource.webAudio;
          audio.paused = false;
          if (!webAudio.decodedBuffer) {
            if (webAudio.onDecodeComplete === undefined) abort("Cannot play back audio object that was not loaded");
            webAudio.onDecodeComplete.push(function() { if (!audio.paused) SDL.playWebAudio(audio); });
            return;
          }
          audio.webAudioNode = SDL.audioContext['createBufferSource']();
          audio.webAudioNode['buffer'] = webAudio.decodedBuffer;
          audio.webAudioNode['loop'] = audio.loop;
          audio.webAudioNode['onended'] = function() { audio['onended'](); } // For <media> element compatibility, route the onended signal to the instance.
  
          audio.webAudioPannerNode = SDL.audioContext['createPanner']();
          // avoid Chrome bug
          // If posz = 0, the sound will come from only the right.
          // By posz = -0.5 (slightly ahead), the sound will come from right and left correctly.
          audio.webAudioPannerNode["setPosition"](0, 0, -.5);
          audio.webAudioPannerNode['panningModel'] = 'equalpower';
  
          // Add an intermediate gain node to control volume.
          audio.webAudioGainNode = SDL.audioContext['createGain']();
          audio.webAudioGainNode['gain']['value'] = audio.volume;
  
          audio.webAudioNode['connect'](audio.webAudioPannerNode);
          audio.webAudioPannerNode['connect'](audio.webAudioGainNode);
          audio.webAudioGainNode['connect'](SDL.audioContext['destination']);
  
          audio.webAudioNode['start'](0, audio.currentPosition);
          audio.startTime = SDL.audioContext['currentTime'] - audio.currentPosition;
        } catch(e) {
          Module.printErr('playWebAudio failed: ' + e);
        }
      },pauseWebAudio:function (audio) {
        if (!audio) return;
        if (audio.webAudioNode) {
          try {
            // Remember where we left off, so that if/when we resume, we can restart the playback at a proper place.
            audio.currentPosition = (SDL.audioContext['currentTime'] - audio.startTime) % audio.resource.webAudio.decodedBuffer.duration;
            // Important: When we reach here, the audio playback is stopped by the user. But when calling .stop() below, the Web Audio
            // graph will send the onended signal, but we don't want to process that, since pausing should not clear/destroy the audio
            // channel.
            audio.webAudioNode['onended'] = undefined;
            audio.webAudioNode.stop(0); // 0 is a default parameter, but WebKit is confused by it #3861
            audio.webAudioNode = undefined;
          } catch(e) {
            Module.printErr('pauseWebAudio failed: ' + e);
          }
        }
        audio.paused = true;
      },openAudioContext:function () {
        // Initialize Web Audio API if we haven't done so yet. Note: Only initialize Web Audio context ever once on the web page,
        // since initializing multiple times fails on Chrome saying 'audio resources have been exhausted'.
        if (!SDL.audioContext) {
          if (typeof(AudioContext) !== 'undefined') SDL.audioContext = new AudioContext();
          else if (typeof(webkitAudioContext) !== 'undefined') SDL.audioContext = new webkitAudioContext();
        }
      },webAudioAvailable:function () { return !!SDL.audioContext; },fillWebAudioBufferFromHeap:function (heapPtr, sizeSamplesPerChannel, dstAudioBuffer) {
        // The input audio data is interleaved across the channels, i.e. [L, R, L, R, L, R, ...] and is either 8-bit, 16-bit or float as
        // supported by the SDL API. The output audio wave data for Web Audio API must be in planar buffers of [-1,1]-normalized Float32 data,
        // so perform a buffer conversion for the data.
        var numChannels = SDL.audio.channels;
        for(var c = 0; c < numChannels; ++c) {
          var channelData = dstAudioBuffer['getChannelData'](c);
          if (channelData.length != sizeSamplesPerChannel) {
            throw 'Web Audio output buffer length mismatch! Destination size: ' + channelData.length + ' samples vs expected ' + sizeSamplesPerChannel + ' samples!';
          }
          if (SDL.audio.format == 0x8010 /*AUDIO_S16LSB*/) {
            for(var j = 0; j < sizeSamplesPerChannel; ++j) {
              channelData[j] = (HEAP16[(((heapPtr)+((j*numChannels + c)*2))>>1)]) / 0x8000;
            }
          } else if (SDL.audio.format == 0x0008 /*AUDIO_U8*/) {
            for(var j = 0; j < sizeSamplesPerChannel; ++j) {
              var v = (HEAP8[(((heapPtr)+(j*numChannels + c))>>0)]);
              channelData[j] = ((v >= 0) ? v-128 : v+128) /128;
            }
          } else if (SDL.audio.format == 0x8120 /*AUDIO_F32*/) {
            for(var j = 0; j < sizeSamplesPerChannel; ++j) {
              channelData[j] = (HEAPF32[(((heapPtr)+((j*numChannels + c)*4))>>2)]);
            }
          } else {
            throw 'Invalid SDL audio format ' + SDL.audio.format + '!';
          }
        }
      },debugSurface:function (surfData) {
        console.log('dumping surface ' + [surfData.surf, surfData.source, surfData.width, surfData.height]);
        var image = surfData.ctx.getImageData(0, 0, surfData.width, surfData.height);
        var data = image.data;
        var num = Math.min(surfData.width, surfData.height);
        for (var i = 0; i < num; i++) {
          console.log('   diagonal ' + i + ':' + [data[i*surfData.width*4 + i*4 + 0], data[i*surfData.width*4 + i*4 + 1], data[i*surfData.width*4 + i*4 + 2], data[i*surfData.width*4 + i*4 + 3]]);
        }
      },joystickEventState:1,lastJoystickState:{},joystickNamePool:{},recordJoystickState:function (joystick, state) {
        // Standardize button state.
        var buttons = new Array(state.buttons.length);
        for (var i = 0; i < state.buttons.length; i++) {
          buttons[i] = SDL.getJoystickButtonState(state.buttons[i]);
        }
  
        SDL.lastJoystickState[joystick] = {
          buttons: buttons,
          axes: state.axes.slice(0),
          timestamp: state.timestamp,
          index: state.index,
          id: state.id
        };
      },getJoystickButtonState:function (button) {
        if (typeof button === 'object') {
          // Current gamepad API editor's draft (Firefox Nightly)
          // https://dvcs.w3.org/hg/gamepad/raw-file/default/gamepad.html#idl-def-GamepadButton
          return button['pressed'];
        } else {
          // Current gamepad API working draft (Firefox / Chrome Stable)
          // http://www.w3.org/TR/2012/WD-gamepad-20120529/#gamepad-interface
          return button > 0;
        }
      },queryJoysticks:function () {
        for (var joystick in SDL.lastJoystickState) {
          var state = SDL.getGamepad(joystick - 1);
          var prevState = SDL.lastJoystickState[joystick];
          // If joystick was removed, state returns null.
          if (typeof state === 'undefined') return;
          // Check only if the timestamp has differed.
          // NOTE: Timestamp is not available in Firefox.
          if (typeof state.timestamp !== 'number' || state.timestamp !== prevState.timestamp) {
            var i;
            for (i = 0; i < state.buttons.length; i++) {
              var buttonState = SDL.getJoystickButtonState(state.buttons[i]);
              // NOTE: The previous state already has a boolean representation of
              //       its button, so no need to standardize its button state here.
              if (buttonState !== prevState.buttons[i]) {
                // Insert button-press event.
                SDL.events.push({
                  type: buttonState ? 'joystick_button_down' : 'joystick_button_up',
                  joystick: joystick,
                  index: joystick - 1,
                  button: i
                });
              }
            }
            for (i = 0; i < state.axes.length; i++) {
              if (state.axes[i] !== prevState.axes[i]) {
                // Insert axes-change event.
                SDL.events.push({
                  type: 'joystick_axis_motion',
                  joystick: joystick,
                  index: joystick - 1,
                  axis: i,
                  value: state.axes[i]
                });
              }
            }
  
            SDL.recordJoystickState(joystick, state);
          }
        }
      },joystickAxisValueConversion:function (value) {
        // Make sure value is properly clamped
        value = Math.min(1, Math.max(value, -1));
        // Ensures that 0 is 0, 1 is 32767, and -1 is 32768.
        return Math.ceil(((value+1) * 32767.5) - 32768);
      },getGamepads:function () {
        var fcn = navigator.getGamepads || navigator.webkitGamepads || navigator.mozGamepads || navigator.gamepads || navigator.webkitGetGamepads;
        if (fcn !== undefined) {
          // The function must be applied on the navigator object.
          return fcn.apply(navigator);
        } else {
          return [];
        }
      },getGamepad:function (deviceIndex) {
        var gamepads = SDL.getGamepads();
        if (gamepads.length > deviceIndex && deviceIndex >= 0) {
          return gamepads[deviceIndex];
        }
        return null;
      }};function _SDL_FreeSurface(surf) {
      if (surf) SDL.freeSurface(surf);
    }

  function _SDL_GetVideoInfo() {
      // %struct.SDL_VideoInfo = type { i32, i32, %struct.SDL_PixelFormat*, i32, i32 } - 5 fields of quantum size
      var ret = _malloc(5 * 4);
      HEAP32[((ret+0)>>2)]=0; // TODO
      HEAP32[((ret+4)>>2)]=0; // TODO
      HEAP32[((ret+8)>>2)]=0;
      HEAP32[((ret+12)>>2)]=Module["canvas"].width;
      HEAP32[((ret+16)>>2)]=Module["canvas"].height;
      return ret;
    }


  function _SDL_MapRGB(fmt, r, g, b) {
      SDL.checkPixelFormat(fmt);
      // We assume the machine is little-endian.
      return r&0xff|(g&0xff)<<8|(b&0xff)<<16|0xff000000;
    }

  function _SDL_PumpEvents(){
      SDL.events.forEach(function(event) {
        SDL.handleEvent(event);
      });
    }

  function _SDL_QuitSubSystem(flags) {
      Module.print('SDL_QuitSubSystem called (and ignored)');
    }

  
  var GL={counter:1,lastError:0,buffers:[],mappedBuffers:{},programs:[],framebuffers:[],renderbuffers:[],textures:[],uniforms:[],shaders:[],vaos:[],contexts:[],currentContext:null,offscreenCanvases:{},timerQueriesEXT:[],byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],programInfos:{},stringCache:{},tempFixedLengthArray:[],packAlignment:4,unpackAlignment:4,init:function () {
        GL.miniTempBuffer = new Float32Array(GL.MINI_TEMP_BUFFER_SIZE);
        for (var i = 0; i < GL.MINI_TEMP_BUFFER_SIZE; i++) {
          GL.miniTempBufferViews[i] = GL.miniTempBuffer.subarray(0, i+1);
        }
  
        // For functions such as glDrawBuffers, glInvalidateFramebuffer and glInvalidateSubFramebuffer that need to pass a short array to the WebGL API,
        // create a set of short fixed-length arrays to avoid having to generate any garbage when calling those functions.
        for (var i = 0; i < 32; i++) {
          GL.tempFixedLengthArray.push(new Array(i));
        }
      },recordError:function recordError(errorCode) {
        if (!GL.lastError) {
          GL.lastError = errorCode;
        }
      },getNewId:function (table) {
        var ret = GL.counter++;
        for (var i = table.length; i < ret; i++) {
          table[i] = null;
        }
        return ret;
      },MINI_TEMP_BUFFER_SIZE:256,miniTempBuffer:null,miniTempBufferViews:[0],getSource:function (shader, count, string, length) {
        var source = '';
        for (var i = 0; i < count; ++i) {
          var frag;
          if (length) {
            var len = HEAP32[(((length)+(i*4))>>2)];
            if (len < 0) {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
            } else {
              frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)], len);
            }
          } else {
            frag = Pointer_stringify(HEAP32[(((string)+(i*4))>>2)]);
          }
          source += frag;
        }
        return source;
      },createContext:function (canvas, webGLContextAttributes) {
        if (typeof webGLContextAttributes['majorVersion'] === 'undefined' && typeof webGLContextAttributes['minorVersion'] === 'undefined') {
          webGLContextAttributes['majorVersion'] = 1;
          webGLContextAttributes['minorVersion'] = 0;
        }
  
  
        var ctx;
        var errorInfo = '?';
        function onContextCreationError(event) {
          errorInfo = event.statusMessage || errorInfo;
        }
        try {
          canvas.addEventListener('webglcontextcreationerror', onContextCreationError, false);
          try {
            if (webGLContextAttributes['majorVersion'] == 1 && webGLContextAttributes['minorVersion'] == 0) {
              ctx = canvas.getContext("webgl", webGLContextAttributes) || canvas.getContext("experimental-webgl", webGLContextAttributes);
            } else if (webGLContextAttributes['majorVersion'] == 2 && webGLContextAttributes['minorVersion'] == 0) {
              ctx = canvas.getContext("webgl2", webGLContextAttributes);
            } else {
              throw 'Unsupported WebGL context version ' + majorVersion + '.' + minorVersion + '!'
            }
          } finally {
            canvas.removeEventListener('webglcontextcreationerror', onContextCreationError, false);
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas: ' + [errorInfo, e, JSON.stringify(webGLContextAttributes)]);
          return 0;
        }
  
        if (!ctx) return 0;
        var context = GL.registerContext(ctx, webGLContextAttributes);
        return context;
      },registerContext:function (ctx, webGLContextAttributes) {
        var handle = GL.getNewId(GL.contexts);
        var context = {
          handle: handle,
          attributes: webGLContextAttributes,
          version: webGLContextAttributes['majorVersion'],
          GLctx: ctx
        };
  
  
        // Store the created context object so that we can access the context given a canvas without having to pass the parameters again.
        if (ctx.canvas) ctx.canvas.GLctxObject = context;
        GL.contexts[handle] = context;
        if (typeof webGLContextAttributes['enableExtensionsByDefault'] === 'undefined' || webGLContextAttributes['enableExtensionsByDefault']) {
          GL.initExtensions(context);
        }
        return handle;
      },makeContextCurrent:function (contextHandle) {
        var context = GL.contexts[contextHandle];
        if (!context) return false;
        GLctx = Module.ctx = context.GLctx; // Active WebGL context object.
        GL.currentContext = context; // Active Emscripten GL layer context object.
        return true;
      },getContext:function (contextHandle) {
        return GL.contexts[contextHandle];
      },deleteContext:function (contextHandle) {
        if (GL.currentContext === GL.contexts[contextHandle]) GL.currentContext = null;
        if (typeof JSEvents === 'object') JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas); // Release all JS event handlers on the DOM element that the GL context is associated with since the context is now deleted.
        if (GL.contexts[contextHandle] && GL.contexts[contextHandle].GLctx.canvas) GL.contexts[contextHandle].GLctx.canvas.GLctxObject = undefined; // Make sure the canvas object no longer refers to the context object so there are no GC surprises.
        GL.contexts[contextHandle] = null;
      },initExtensions:function (context) {
        // If this function is called without a specific context object, init the extensions of the currently active context.
        if (!context) context = GL.currentContext;
  
        if (context.initExtensionsDone) return;
        context.initExtensionsDone = true;
  
        var GLctx = context.GLctx;
  
        context.maxVertexAttribs = GLctx.getParameter(GLctx.MAX_VERTEX_ATTRIBS);
  
        // Detect the presence of a few extensions manually, this GL interop layer itself will need to know if they exist.
  
        if (context.version < 2) {
          // Extension available from Firefox 26 and Google Chrome 30
          var instancedArraysExt = GLctx.getExtension('ANGLE_instanced_arrays');
          if (instancedArraysExt) {
            GLctx['vertexAttribDivisor'] = function(index, divisor) { instancedArraysExt['vertexAttribDivisorANGLE'](index, divisor); };
            GLctx['drawArraysInstanced'] = function(mode, first, count, primcount) { instancedArraysExt['drawArraysInstancedANGLE'](mode, first, count, primcount); };
            GLctx['drawElementsInstanced'] = function(mode, count, type, indices, primcount) { instancedArraysExt['drawElementsInstancedANGLE'](mode, count, type, indices, primcount); };
          }
  
          // Extension available from Firefox 25 and WebKit
          var vaoExt = GLctx.getExtension('OES_vertex_array_object');
          if (vaoExt) {
            GLctx['createVertexArray'] = function() { return vaoExt['createVertexArrayOES'](); };
            GLctx['deleteVertexArray'] = function(vao) { vaoExt['deleteVertexArrayOES'](vao); };
            GLctx['bindVertexArray'] = function(vao) { vaoExt['bindVertexArrayOES'](vao); };
            GLctx['isVertexArray'] = function(vao) { return vaoExt['isVertexArrayOES'](vao); };
          }
  
          var drawBuffersExt = GLctx.getExtension('WEBGL_draw_buffers');
          if (drawBuffersExt) {
            GLctx['drawBuffers'] = function(n, bufs) { drawBuffersExt['drawBuffersWEBGL'](n, bufs); };
          }
        }
  
        GLctx.disjointTimerQueryExt = GLctx.getExtension("EXT_disjoint_timer_query");
  
        // These are the 'safe' feature-enabling extensions that don't add any performance impact related to e.g. debugging, and
        // should be enabled by default so that client GLES2/GL code will not need to go through extra hoops to get its stuff working.
        // As new extensions are ratified at http://www.khronos.org/registry/webgl/extensions/ , feel free to add your new extensions
        // here, as long as they don't produce a performance impact for users that might not be using those extensions.
        // E.g. debugging-related extensions should probably be off by default.
        var automaticallyEnabledExtensions = [ "OES_texture_float", "OES_texture_half_float", "OES_standard_derivatives",
                                               "OES_vertex_array_object", "WEBGL_compressed_texture_s3tc", "WEBGL_depth_texture",
                                               "OES_element_index_uint", "EXT_texture_filter_anisotropic", "ANGLE_instanced_arrays",
                                               "OES_texture_float_linear", "OES_texture_half_float_linear", "WEBGL_compressed_texture_atc",
                                               "WEBKIT_WEBGL_compressed_texture_pvrtc", "WEBGL_compressed_texture_pvrtc",
                                               "EXT_color_buffer_half_float", "WEBGL_color_buffer_float", "EXT_frag_depth", "EXT_sRGB",
                                               "WEBGL_draw_buffers", "WEBGL_shared_resources", "EXT_shader_texture_lod", "EXT_color_buffer_float"];
  
        function shouldEnableAutomatically(extension) {
          var ret = false;
          automaticallyEnabledExtensions.forEach(function(include) {
            if (extension.indexOf(include) != -1) {
              ret = true;
            }
          });
          return ret;
        }
  
        var exts = GLctx.getSupportedExtensions();
        if (exts && exts.length > 0) {
          GLctx.getSupportedExtensions().forEach(function(ext) {
            if (automaticallyEnabledExtensions.indexOf(ext) != -1) {
              GLctx.getExtension(ext); // Calling .getExtension enables that extension permanently, no need to store the return value to be enabled.
            }
          });
        }
      },populateUniformTable:function (program) {
        var p = GL.programs[program];
        GL.programInfos[program] = {
          uniforms: {},
          maxUniformLength: 0, // This is eagerly computed below, since we already enumerate all uniforms anyway.
          maxAttributeLength: -1, // This is lazily computed and cached, computed when/if first asked, "-1" meaning not computed yet.
          maxUniformBlockNameLength: -1 // Lazily computed as well
        };
  
        var ptable = GL.programInfos[program];
        var utable = ptable.uniforms;
        // A program's uniform table maps the string name of an uniform to an integer location of that uniform.
        // The global GL.uniforms map maps integer locations to WebGLUniformLocations.
        var numUniforms = GLctx.getProgramParameter(p, GLctx.ACTIVE_UNIFORMS);
        for (var i = 0; i < numUniforms; ++i) {
          var u = GLctx.getActiveUniform(p, i);
  
          var name = u.name;
          ptable.maxUniformLength = Math.max(ptable.maxUniformLength, name.length+1);
  
          // Strip off any trailing array specifier we might have got, e.g. "[0]".
          if (name.indexOf(']', name.length-1) !== -1) {
            var ls = name.lastIndexOf('[');
            name = name.slice(0, ls);
          }
  
          // Optimize memory usage slightly: If we have an array of uniforms, e.g. 'vec3 colors[3];', then
          // only store the string 'colors' in utable, and 'colors[0]', 'colors[1]' and 'colors[2]' will be parsed as 'colors'+i.
          // Note that for the GL.uniforms table, we still need to fetch the all WebGLUniformLocations for all the indices.
          var loc = GLctx.getUniformLocation(p, name);
          if (loc != null)
          {
            var id = GL.getNewId(GL.uniforms);
            utable[name] = [u.size, id];
            GL.uniforms[id] = loc;
  
            for (var j = 1; j < u.size; ++j) {
              var n = name + '['+j+']';
              loc = GLctx.getUniformLocation(p, n);
              id = GL.getNewId(GL.uniforms);
  
              GL.uniforms[id] = loc;
            }
          }
        }
      }};function _SDL_SetVideoMode(width, height, depth, flags) {
      ['touchstart', 'touchend', 'touchmove', 'mousedown', 'mouseup', 'mousemove', 'DOMMouseScroll', 'mousewheel', 'wheel', 'mouseout'].forEach(function(event) {
        Module['canvas'].addEventListener(event, SDL.receiveEvent, true);
      });
  
      var canvas = Module['canvas'];
  
      // (0,0) means 'use fullscreen' in native; in Emscripten, use the current canvas size.
      if (width == 0 && height == 0) {
        width = canvas.width;
        height = canvas.height;
      }
  
      if (!SDL.addedResizeListener) {
        SDL.addedResizeListener = true;
        Browser.resizeListeners.push(function(w, h) {
          if (!SDL.settingVideoMode) {
            SDL.receiveEvent({
              type: 'resize',
              w: w,
              h: h
            });
          }
        });
      }
  
      if (width !== canvas.width || height !== canvas.height) {
        SDL.settingVideoMode = true; // SetVideoMode itself should not trigger resize events
        Browser.setCanvasSize(width, height);
        SDL.settingVideoMode = false;
      }
  
      // Free the old surface first if there is one
      if (SDL.screen) {
        SDL.freeSurface(SDL.screen);
        assert(!SDL.screen);
      }
  
      if (SDL.GL) flags = flags | 0x04000000; // SDL_OPENGL - if we are using GL, then later calls to SetVideoMode may not mention GL, but we do need it. Once in GL mode, we never leave it.
  
      SDL.screen = SDL.makeSurface(width, height, flags, true, 'screen');
  
      return SDL.screen;
    }

  function _SDL_ShowCursor(toggle) {
      switch (toggle) {
        case 0: // SDL_DISABLE
          if (Browser.isFullscreen) { // only try to lock the pointer when in full screen mode
            Module['canvas'].requestPointerLock();
            return 0;
          } else { // else return SDL_ENABLE to indicate the failure
            return 1;
          }
          break;
        case 1: // SDL_ENABLE
          Module['canvas'].exitPointerLock();
          return 1;
          break;
        case -1: // SDL_QUERY
          return !Browser.pointerLock;
          break;
        default:
          console.log( "SDL_ShowCursor called with unknown toggle parameter value: " + toggle + "." );
          break;
      }
    }

  function _SDL_UnlockSurface(surf) {
      assert(!SDL.GL); // in GL mode we do not keep around 2D canvases and contexts
  
      var surfData = SDL.surfaces[surf];
  
      if (!surfData.locked || --surfData.locked > 0) {
        return;
      }
  
      // Copy pixel data to image
      if (surfData.isFlagSet(0x00200000 /* SDL_HWPALETTE */)) {
        SDL.copyIndexedColorData(surfData);
      } else if (!surfData.colors) {
        var data = surfData.image.data;
        var buffer = surfData.buffer;
        assert(buffer % 4 == 0, 'Invalid buffer offset: ' + buffer);
        var src = buffer >> 2;
        var dst = 0;
        var isScreen = surf == SDL.screen;
        var num;
        if (typeof CanvasPixelArray !== 'undefined' && data instanceof CanvasPixelArray) {
          // IE10/IE11: ImageData objects are backed by the deprecated CanvasPixelArray,
          // not UInt8ClampedArray. These don't have buffers, so we need to revert
          // to copying a byte at a time. We do the undefined check because modern
          // browsers do not define CanvasPixelArray anymore.
          num = data.length;
          while (dst < num) {
            var val = HEAP32[src]; // This is optimized. Instead, we could do HEAP32[(((buffer)+(dst))>>2)];
            data[dst  ] = val & 0xff;
            data[dst+1] = (val >> 8) & 0xff;
            data[dst+2] = (val >> 16) & 0xff;
            data[dst+3] = isScreen ? 0xff : ((val >> 24) & 0xff);
            src++;
            dst += 4;
          }
        } else {
          var data32 = new Uint32Array(data.buffer);
          if (isScreen && SDL.defaults.opaqueFrontBuffer) {
            num = data32.length;
            // logically we need to do
            //      while (dst < num) {
            //          data32[dst++] = HEAP32[src++] | 0xff000000
            //      }
            // the following code is faster though, because
            // .set() is almost free - easily 10x faster due to
            // native memcpy efficiencies, and the remaining loop
            // just stores, not load + store, so it is faster
            data32.set(HEAP32.subarray(src, src + num));
            var data8 = new Uint8Array(data.buffer);
            var i = 3;
            var j = i + 4*num;
            if (num % 8 == 0) {
              // unrolling gives big speedups
              while (i < j) {
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
                data8[i] = 0xff;
                i = i + 4 | 0;
              }
             } else {
              while (i < j) {
                data8[i] = 0xff;
                i = i + 4 | 0;
              }
            }
          } else {
            data32.set(HEAP32.subarray(src, src + data32.length));
          }
        }
      } else {
        var width = Module['canvas'].width;
        var height = Module['canvas'].height;
        var s = surfData.buffer;
        var data = surfData.image.data;
        var colors = surfData.colors; // TODO: optimize using colors32
        for (var y = 0; y < height; y++) {
          var base = y*width*4;
          for (var x = 0; x < width; x++) {
            // See comment above about signs
            var val = HEAPU8[((s++)>>0)] * 4;
            var start = base + x*4;
            data[start]   = colors[val];
            data[start+1] = colors[val+1];
            data[start+2] = colors[val+2];
          }
          s += width*3;
        }
      }
      // Copy to canvas
      surfData.ctx.putImageData(surfData.image, 0, 0);
      // Note that we save the image, so future writes are fast. But, memory is not yet released
    }

  function _SDL_UpdateRect(surf, x, y, w, h) {
      // We actually do the whole screen in Unlock...
    }

  function _SDL_VideoDriverName(buf, max_size) {
      if (SDL.startTime === null) {
        return 0; //return NULL
      }
      //driverName - emscripten_sdl_driver
      var driverName = [101, 109, 115, 99, 114, 105, 112, 116, 101,
        110, 95, 115, 100, 108, 95, 100, 114, 105, 118, 101, 114];
  
      var index = 0;
      var size  = driverName.length;
  
      if (max_size <= size) {
        size = max_size - 1; //-1 cause null-terminator
      }
  
      while (index < size) {
          var value = driverName[index];
          HEAP8[(((buf)+(index))>>0)]=value;
          index++;
      }
  
      HEAP8[(((buf)+(index))>>0)]=0;
      return buf;
    }

  function _SDL_VideoModeOK(width, height, depth, flags) {
      // SDL_VideoModeOK returns 0 if the requested mode is not supported under any bit depth, or returns the
      // bits-per-pixel of the closest available mode with the given width, height and requested surface flags
      return depth; // all modes are ok.
    }

  function _SDL_WM_GrabInput() {}

  function _SDL_WM_SetCaption(title, icon) {
      if (title && typeof Module['setWindowTitle'] !== 'undefined') {
        Module['setWindowTitle'](Pointer_stringify(title));
      }
      icon = icon && Pointer_stringify(icon);
    }

  function _SDL_mutexP() { return 0 }

  function _SDL_mutexV() { return 0 }

  function ___assert_fail(condition, filename, line, func) {
      abort('Assertion failed: ' + Pointer_stringify(condition) + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function']);
    }

  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }

  
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  
  var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:function (adjusted) {
        if (!adjusted || EXCEPTIONS.infos[adjusted]) return adjusted;
        for (var key in EXCEPTIONS.infos) {
          var ptr = +key; // the iteration key is a string, and if we throw this, it must be an integer as that is what we look for
          var info = EXCEPTIONS.infos[ptr];
          if (info.adjusted === adjusted) {
            return ptr;
          }
        }
        return adjusted;
      },addRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        info.refcount++;
      },decRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        assert(info.refcount > 0);
        info.refcount--;
        // A rethrown exception can reach refcount 0; it must not be discarded
        // Its next handler will clear the rethrown flag and addRef it, prior to
        // final decRef and destruction here
        if (info.refcount === 0 && !info.rethrown) {
          if (info.destructor) {
            Module['dynCall_vi'](info.destructor, ptr);
          }
          delete EXCEPTIONS.infos[ptr];
          ___cxa_free_exception(ptr);
        }
      },clearRef:function (ptr) {
        if (!ptr) return;
        var info = EXCEPTIONS.infos[ptr];
        info.refcount = 0;
      }};function ___cxa_begin_catch(ptr) {
      var info = EXCEPTIONS.infos[ptr];
      if (info && !info.caught) {
        info.caught = true;
        __ZSt18uncaught_exceptionv.uncaught_exception--;
      }
      if (info) info.rethrown = false;
      EXCEPTIONS.caught.push(ptr);
      EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));
      return ptr;
    }

  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }

  
  
  function ___resumeException(ptr) {
      if (!EXCEPTIONS.last) { EXCEPTIONS.last = ptr; }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";
    }function ___cxa_find_matching_catch() {
      var thrown = EXCEPTIONS.last;
      if (!thrown) {
        // just pass through the null ptr
        return ((setTempRet0(0),0)|0);
      }
      var info = EXCEPTIONS.infos[thrown];
      var throwntype = info.type;
      if (!throwntype) {
        // just pass through the thrown ptr
        return ((setTempRet0(0),thrown)|0);
      }
      var typeArray = Array.prototype.slice.call(arguments);
  
      var pointer = Module['___cxa_is_pointer_type'](throwntype);
      // can_catch receives a **, add indirection
      if (!___cxa_find_matching_catch.buffer) ___cxa_find_matching_catch.buffer = _malloc(4);
      HEAP32[((___cxa_find_matching_catch.buffer)>>2)]=thrown;
      thrown = ___cxa_find_matching_catch.buffer;
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (typeArray[i] && Module['___cxa_can_catch'](typeArray[i], throwntype, thrown)) {
          thrown = HEAP32[((thrown)>>2)]; // undo indirection
          info.adjusted = thrown;
          return ((setTempRet0(typeArray[i]),thrown)|0);
        }
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      thrown = HEAP32[((thrown)>>2)]; // undo indirection
      return ((setTempRet0(throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      EXCEPTIONS.infos[ptr] = {
        ptr: ptr,
        adjusted: ptr,
        type: type,
        destructor: destructor,
        refcount: 0,
        caught: false,
        rethrown: false
      };
      EXCEPTIONS.last = ptr;
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";
    }

  
  
   
  
   
  
  var cttz_i8 = allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0], "i8", ALLOC_STATIC);   

  function ___gxx_personality_v0() {
    }

  function ___lock() {}

  
    

   

  
  var SYSCALLS={DEFAULT_POLLMASK:5,mappings:{},umask:511,calculateAt:function (dirfd, path) {
        if (path[0] !== '/') {
          // relative path
          var dir;
          if (dirfd === -100) {
            dir = FS.cwd();
          } else {
            var dirstream = FS.getStream(dirfd);
            if (!dirstream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
            dir = dirstream.path;
          }
          path = PATH.join2(dir, path);
        }
        return path;
      },doStat:function (func, path, buf) {
        try {
          var stat = func(path);
        } catch (e) {
          if (e && e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            // an error occurred while trying to look up the path; we should just report ENOTDIR
            return -ERRNO_CODES.ENOTDIR;
          }
          throw e;
        }
        HEAP32[((buf)>>2)]=stat.dev;
        HEAP32[(((buf)+(4))>>2)]=0;
        HEAP32[(((buf)+(8))>>2)]=stat.ino;
        HEAP32[(((buf)+(12))>>2)]=stat.mode;
        HEAP32[(((buf)+(16))>>2)]=stat.nlink;
        HEAP32[(((buf)+(20))>>2)]=stat.uid;
        HEAP32[(((buf)+(24))>>2)]=stat.gid;
        HEAP32[(((buf)+(28))>>2)]=stat.rdev;
        HEAP32[(((buf)+(32))>>2)]=0;
        HEAP32[(((buf)+(36))>>2)]=stat.size;
        HEAP32[(((buf)+(40))>>2)]=4096;
        HEAP32[(((buf)+(44))>>2)]=stat.blocks;
        HEAP32[(((buf)+(48))>>2)]=(stat.atime.getTime() / 1000)|0;
        HEAP32[(((buf)+(52))>>2)]=0;
        HEAP32[(((buf)+(56))>>2)]=(stat.mtime.getTime() / 1000)|0;
        HEAP32[(((buf)+(60))>>2)]=0;
        HEAP32[(((buf)+(64))>>2)]=(stat.ctime.getTime() / 1000)|0;
        HEAP32[(((buf)+(68))>>2)]=0;
        HEAP32[(((buf)+(72))>>2)]=stat.ino;
        return 0;
      },doMsync:function (addr, stream, len, flags) {
        var buffer = new Uint8Array(HEAPU8.subarray(addr, addr + len));
        FS.msync(stream, buffer, 0, len, flags);
      },doMkdir:function (path, mode) {
        // remove a trailing slash, if one - /a/b/ has basename of '', but
        // we want to create b in the context of this function
        path = PATH.normalize(path);
        if (path[path.length-1] === '/') path = path.substr(0, path.length-1);
        FS.mkdir(path, mode, 0);
        return 0;
      },doMknod:function (path, mode, dev) {
        // we don't want this in the JS API as it uses mknod to create all nodes.
        switch (mode & 61440) {
          case 32768:
          case 8192:
          case 24576:
          case 4096:
          case 49152:
            break;
          default: return -ERRNO_CODES.EINVAL;
        }
        FS.mknod(path, mode, dev);
        return 0;
      },doReadlink:function (path, buf, bufsize) {
        if (bufsize <= 0) return -ERRNO_CODES.EINVAL;
        var ret = FS.readlink(path);
  
        var len = Math.min(bufsize, lengthBytesUTF8(ret));
        var endChar = HEAP8[buf+len];
        stringToUTF8(ret, buf, bufsize+1);
        // readlink is one of the rare functions that write out a C string, but does never append a null to the output buffer(!)
        // stringToUTF8() always appends a null byte, so restore the character under the null byte after the write.
        HEAP8[buf+len] = endChar;
  
        return len;
      },doAccess:function (path, amode) {
        if (amode & ~7) {
          // need a valid mode
          return -ERRNO_CODES.EINVAL;
        }
        var node;
        var lookup = FS.lookupPath(path, { follow: true });
        node = lookup.node;
        var perms = '';
        if (amode & 4) perms += 'r';
        if (amode & 2) perms += 'w';
        if (amode & 1) perms += 'x';
        if (perms /* otherwise, they've just passed F_OK */ && FS.nodePermissions(node, perms)) {
          return -ERRNO_CODES.EACCES;
        }
        return 0;
      },doDup:function (path, flags, suggestFD) {
        var suggest = FS.getStream(suggestFD);
        if (suggest) FS.close(suggest);
        return FS.open(path, flags, 0, suggestFD, suggestFD).fd;
      },doReadv:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.read(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
          if (curr < len) break; // nothing more to read
        }
        return ret;
      },doWritev:function (stream, iov, iovcnt, offset) {
        var ret = 0;
        for (var i = 0; i < iovcnt; i++) {
          var ptr = HEAP32[(((iov)+(i*8))>>2)];
          var len = HEAP32[(((iov)+(i*8 + 4))>>2)];
          var curr = FS.write(stream, HEAP8,ptr, len, offset);
          if (curr < 0) return -1;
          ret += curr;
        }
        return ret;
      },varargs:0,get:function (varargs) {
        SYSCALLS.varargs += 4;
        var ret = HEAP32[(((SYSCALLS.varargs)-(4))>>2)];
        return ret;
      },getStr:function () {
        var ret = Pointer_stringify(SYSCALLS.get());
        return ret;
      },getStreamFromFD:function () {
        var stream = FS.getStream(SYSCALLS.get());
        if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return stream;
      },getSocketFromFD:function () {
        var socket = SOCKFS.getSocket(SYSCALLS.get());
        if (!socket) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        return socket;
      },getSocketAddress:function (allowNull) {
        var addrp = SYSCALLS.get(), addrlen = SYSCALLS.get();
        if (allowNull && addrp === 0) return null;
        var info = __read_sockaddr(addrp, addrlen);
        if (info.errno) throw new FS.ErrnoError(info.errno);
        info.addr = DNS.lookup_addr(info.addr) || info.addr;
        return info;
      },get64:function () {
        var low = SYSCALLS.get(), high = SYSCALLS.get();
        if (low >= 0) assert(high === 0);
        else assert(high === -1);
        return low;
      },getZero:function () {
        assert(SYSCALLS.get() === 0);
      }};function ___syscall10(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // unlink
      var path = SYSCALLS.getStr();
      FS.unlink(path);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  
  var SOCKFS={mount:function (mount) {
        // If Module['websocket'] has already been defined (e.g. for configuring
        // the subprotocol/url) use that, if not initialise it to a new object.
        Module['websocket'] = (Module['websocket'] && 
                               ('object' === typeof Module['websocket'])) ? Module['websocket'] : {};
  
        // Add the Event registration mechanism to the exported websocket configuration
        // object so we can register network callbacks from native JavaScript too.
        // For more documentation see system/include/emscripten/emscripten.h
        Module['websocket']._callbacks = {};
        Module['websocket']['on'] = function(event, callback) {
  	    if ('function' === typeof callback) {
  		  this._callbacks[event] = callback;
          }
  	    return this;
        };
  
        Module['websocket'].emit = function(event, param) {
  	    if ('function' === typeof this._callbacks[event]) {
  		  this._callbacks[event].call(this, param);
          }
        };
  
        // If debug is enabled register simple default logging callbacks for each Event.
  
        return FS.createNode(null, '/', 16384 | 511 /* 0777 */, 0);
      },createSocket:function (family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
          assert(streaming == (protocol == 6)); // if SOCK_STREAM, must be tcp
        }
  
        // create our internal socket structure
        var sock = {
          family: family,
          type: type,
          protocol: protocol,
          server: null,
          error: null, // Used in getsockopt for SOL_SOCKET/SO_ERROR test
          peers: {},
          pending: [],
          recv_queue: [],
          sock_ops: SOCKFS.websocket_sock_ops
        };
  
        // create the filesystem node to store the socket structure
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;
  
        // and the wrapping stream that enables library functions such
        // as read and write to indirectly interact with the socket
        var stream = FS.createStream({
          path: name,
          node: node,
          flags: FS.modeStringToFlags('r+'),
          seekable: false,
          stream_ops: SOCKFS.stream_ops
        });
  
        // map the new stream to the socket structure (sockets have a 1:1
        // relationship with a stream)
        sock.stream = stream;
  
        return sock;
      },getSocket:function (fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
          return null;
        }
        return stream.node.sock;
      },stream_ops:{poll:function (stream) {
          var sock = stream.node.sock;
          return sock.sock_ops.poll(sock);
        },ioctl:function (stream, request, varargs) {
          var sock = stream.node.sock;
          return sock.sock_ops.ioctl(sock, request, varargs);
        },read:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          var msg = sock.sock_ops.recvmsg(sock, length);
          if (!msg) {
            // socket is closed
            return 0;
          }
          buffer.set(msg.buffer, offset);
          return msg.buffer.length;
        },write:function (stream, buffer, offset, length, position /* ignored */) {
          var sock = stream.node.sock;
          return sock.sock_ops.sendmsg(sock, buffer, offset, length);
        },close:function (stream) {
          var sock = stream.node.sock;
          sock.sock_ops.close(sock);
        }},nextname:function () {
        if (!SOCKFS.nextname.current) {
          SOCKFS.nextname.current = 0;
        }
        return 'socket[' + (SOCKFS.nextname.current++) + ']';
      },websocket_sock_ops:{createPeer:function (sock, addr, port) {
          var ws;
  
          if (typeof addr === 'object') {
            ws = addr;
            addr = null;
            port = null;
          }
  
          if (ws) {
            // for sockets that've already connected (e.g. we're the server)
            // we can inspect the _socket property for the address
            if (ws._socket) {
              addr = ws._socket.remoteAddress;
              port = ws._socket.remotePort;
            }
            // if we're just now initializing a connection to the remote,
            // inspect the url property
            else {
              var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
              if (!result) {
                throw new Error('WebSocket URL must be in the format ws(s)://address:port');
              }
              addr = result[1];
              port = parseInt(result[2], 10);
            }
          } else {
            // create the actual websocket object and connect
            try {
              // runtimeConfig gets set to true if WebSocket runtime configuration is available.
              var runtimeConfig = (Module['websocket'] && ('object' === typeof Module['websocket']));
  
              // The default value is 'ws://' the replace is needed because the compiler replaces '//' comments with '#'
              // comments without checking context, so we'd end up with ws:#, the replace swaps the '#' for '//' again.
              var url = 'ws:#'.replace('#', '//');
  
              if (runtimeConfig) {
                if ('string' === typeof Module['websocket']['url']) {
                  url = Module['websocket']['url']; // Fetch runtime WebSocket URL config.
                }
              }
  
              if (url === 'ws://' || url === 'wss://') { // Is the supplied URL config just a prefix, if so complete it.
                var parts = addr.split('/');
                url = url + parts[0] + ":" + port + "/" + parts.slice(1).join('/');
              }
  
              // Make the WebSocket subprotocol (Sec-WebSocket-Protocol) default to binary if no configuration is set.
              var subProtocols = 'binary'; // The default value is 'binary'
  
              if (runtimeConfig) {
                if ('string' === typeof Module['websocket']['subprotocol']) {
                  subProtocols = Module['websocket']['subprotocol']; // Fetch runtime WebSocket subprotocol config.
                }
              }
  
              // The regex trims the string (removes spaces at the beginning and end, then splits the string by
              // <any space>,<any space> into an Array. Whitespace removal is important for Websockify and ws.
              subProtocols = subProtocols.replace(/^ +| +$/g,"").split(/ *, */);
  
              // The node ws library API for specifying optional subprotocol is slightly different than the browser's.
              var opts = ENVIRONMENT_IS_NODE ? {'protocol': subProtocols.toString()} : subProtocols;
  
              // some webservers (azure) does not support subprotocol header
              if (runtimeConfig && null === Module['websocket']['subprotocol']) {
                subProtocols = 'null';
                opts = undefined;
              }
  
              // If node we use the ws library.
              var WebSocketConstructor;
              if (ENVIRONMENT_IS_NODE) {
                WebSocketConstructor = require('ws');
              } else if (ENVIRONMENT_IS_WEB) {
                WebSocketConstructor = window['WebSocket'];
              } else {
                WebSocketConstructor = WebSocket;
              }
              ws = new WebSocketConstructor(url, opts);
              ws.binaryType = 'arraybuffer';
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH);
            }
          }
  
  
          var peer = {
            addr: addr,
            port: port,
            socket: ws,
            dgram_send_queue: []
          };
  
          SOCKFS.websocket_sock_ops.addPeer(sock, peer);
          SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
  
          // if this is a bound dgram socket, send the port number first to allow
          // us to override the ephemeral port reported to us by remotePort on the
          // remote end.
          if (sock.type === 2 && typeof sock.sport !== 'undefined') {
            peer.dgram_send_queue.push(new Uint8Array([
                255, 255, 255, 255,
                'p'.charCodeAt(0), 'o'.charCodeAt(0), 'r'.charCodeAt(0), 't'.charCodeAt(0),
                ((sock.sport & 0xff00) >> 8) , (sock.sport & 0xff)
            ]));
          }
  
          return peer;
        },getPeer:function (sock, addr, port) {
          return sock.peers[addr + ':' + port];
        },addPeer:function (sock, peer) {
          sock.peers[peer.addr + ':' + peer.port] = peer;
        },removePeer:function (sock, peer) {
          delete sock.peers[peer.addr + ':' + peer.port];
        },handlePeerEvents:function (sock, peer) {
          var first = true;
  
          var handleOpen = function () {
  
            Module['websocket'].emit('open', sock.stream.fd);
  
            try {
              var queued = peer.dgram_send_queue.shift();
              while (queued) {
                peer.socket.send(queued);
                queued = peer.dgram_send_queue.shift();
              }
            } catch (e) {
              // not much we can do here in the way of proper error handling as we've already
              // lied and said this data was sent. shut it down.
              peer.socket.close();
            }
          };
  
          function handleMessage(data) {
            assert(typeof data !== 'string' && data.byteLength !== undefined);  // must receive an ArrayBuffer
  
            // An empty ArrayBuffer will emit a pseudo disconnect event
            // as recv/recvmsg will return zero which indicates that a socket
            // has performed a shutdown although the connection has not been disconnected yet.
            if (data.byteLength == 0) {
              return;
            }
            data = new Uint8Array(data);  // make a typed array view on the array buffer
  
  
            // if this is the port message, override the peer's port with it
            var wasfirst = first;
            first = false;
            if (wasfirst &&
                data.length === 10 &&
                data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 &&
                data[4] === 'p'.charCodeAt(0) && data[5] === 'o'.charCodeAt(0) && data[6] === 'r'.charCodeAt(0) && data[7] === 't'.charCodeAt(0)) {
              // update the peer's port and it's key in the peer map
              var newport = ((data[8] << 8) | data[9]);
              SOCKFS.websocket_sock_ops.removePeer(sock, peer);
              peer.port = newport;
              SOCKFS.websocket_sock_ops.addPeer(sock, peer);
              return;
            }
  
            sock.recv_queue.push({ addr: peer.addr, port: peer.port, data: data });
            Module['websocket'].emit('message', sock.stream.fd);
          };
  
          if (ENVIRONMENT_IS_NODE) {
            peer.socket.on('open', handleOpen);
            peer.socket.on('message', function(data, flags) {
              if (!flags.binary) {
                return;
              }
              handleMessage((new Uint8Array(data)).buffer);  // copy from node Buffer -> ArrayBuffer
            });
            peer.socket.on('close', function() {
              Module['websocket'].emit('close', sock.stream.fd);
            });
            peer.socket.on('error', function(error) {
              // Although the ws library may pass errors that may be more descriptive than
              // ECONNREFUSED they are not necessarily the expected error code e.g. 
              // ENOTFOUND on getaddrinfo seems to be node.js specific, so using ECONNREFUSED
              // is still probably the most useful thing to do.
              sock.error = ERRNO_CODES.ECONNREFUSED; // Used in getsockopt for SOL_SOCKET/SO_ERROR test.
              Module['websocket'].emit('error', [sock.stream.fd, sock.error, 'ECONNREFUSED: Connection refused']);
              // don't throw
            });
          } else {
            peer.socket.onopen = handleOpen;
            peer.socket.onclose = function() {
              Module['websocket'].emit('close', sock.stream.fd);
            };
            peer.socket.onmessage = function peer_socket_onmessage(event) {
              handleMessage(event.data);
            };
            peer.socket.onerror = function(error) {
              // The WebSocket spec only allows a 'simple event' to be thrown on error,
              // so we only really know as much as ECONNREFUSED.
              sock.error = ERRNO_CODES.ECONNREFUSED; // Used in getsockopt for SOL_SOCKET/SO_ERROR test.
              Module['websocket'].emit('error', [sock.stream.fd, sock.error, 'ECONNREFUSED: Connection refused']);
            };
          }
        },poll:function (sock) {
          if (sock.type === 1 && sock.server) {
            // listen sockets should only say they're available for reading
            // if there are pending clients.
            return sock.pending.length ? (64 | 1) : 0;
          }
  
          var mask = 0;
          var dest = sock.type === 1 ?  // we only care about the socket state for connection-based sockets
            SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) :
            null;
  
          if (sock.recv_queue.length ||
              !dest ||  // connection-less sockets are always ready to read
              (dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {  // let recv return 0 once closed
            mask |= (64 | 1);
          }
  
          if (!dest ||  // connection-less sockets are always ready to write
              (dest && dest.socket.readyState === dest.socket.OPEN)) {
            mask |= 4;
          }
  
          if ((dest && dest.socket.readyState === dest.socket.CLOSING) ||
              (dest && dest.socket.readyState === dest.socket.CLOSED)) {
            mask |= 16;
          }
  
          return mask;
        },ioctl:function (sock, request, arg) {
          switch (request) {
            case 21531:
              var bytes = 0;
              if (sock.recv_queue.length) {
                bytes = sock.recv_queue[0].data.length;
              }
              HEAP32[((arg)>>2)]=bytes;
              return 0;
            default:
              return ERRNO_CODES.EINVAL;
          }
        },close:function (sock) {
          // if we've spawned a listen server, close it
          if (sock.server) {
            try {
              sock.server.close();
            } catch (e) {
            }
            sock.server = null;
          }
          // close any peer connections
          var peers = Object.keys(sock.peers);
          for (var i = 0; i < peers.length; i++) {
            var peer = sock.peers[peers[i]];
            try {
              peer.socket.close();
            } catch (e) {
            }
            SOCKFS.websocket_sock_ops.removePeer(sock, peer);
          }
          return 0;
        },bind:function (sock, addr, port) {
          if (typeof sock.saddr !== 'undefined' || typeof sock.sport !== 'undefined') {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already bound
          }
          sock.saddr = addr;
          sock.sport = port;
          // in order to emulate dgram sockets, we need to launch a listen server when
          // binding on a connection-less socket
          // note: this is only required on the server side
          if (sock.type === 2) {
            // close the existing server if it exists
            if (sock.server) {
              sock.server.close();
              sock.server = null;
            }
            // swallow error operation not supported error that occurs when binding in the
            // browser where this isn't supported
            try {
              sock.sock_ops.listen(sock, 0);
            } catch (e) {
              if (!(e instanceof FS.ErrnoError)) throw e;
              if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e;
            }
          }
        },connect:function (sock, addr, port) {
          if (sock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
  
          // TODO autobind
          // if (!sock.addr && sock.type == 2) {
          // }
  
          // early out if we're already connected / in the middle of connecting
          if (typeof sock.daddr !== 'undefined' && typeof sock.dport !== 'undefined') {
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
            if (dest) {
              if (dest.socket.readyState === dest.socket.CONNECTING) {
                throw new FS.ErrnoError(ERRNO_CODES.EALREADY);
              } else {
                throw new FS.ErrnoError(ERRNO_CODES.EISCONN);
              }
            }
          }
  
          // add the socket to our peer list and set our
          // destination address / port to match
          var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
          sock.daddr = peer.addr;
          sock.dport = peer.port;
  
          // always "fail" in non-blocking mode
          throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS);
        },listen:function (sock, backlog) {
          if (!ENVIRONMENT_IS_NODE) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
          }
          if (sock.server) {
             throw new FS.ErrnoError(ERRNO_CODES.EINVAL);  // already listening
          }
          var WebSocketServer = require('ws').Server;
          var host = sock.saddr;
          sock.server = new WebSocketServer({
            host: host,
            port: sock.sport
            // TODO support backlog
          });
          Module['websocket'].emit('listen', sock.stream.fd); // Send Event with listen fd.
  
          sock.server.on('connection', function(ws) {
            if (sock.type === 1) {
              var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
  
              // create a peer on the new socket
              var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
              newsock.daddr = peer.addr;
              newsock.dport = peer.port;
  
              // push to queue for accept to pick up
              sock.pending.push(newsock);
              Module['websocket'].emit('connection', newsock.stream.fd);
            } else {
              // create a peer on the listen socket so calling sendto
              // with the listen socket and an address will resolve
              // to the correct client
              SOCKFS.websocket_sock_ops.createPeer(sock, ws);
              Module['websocket'].emit('connection', sock.stream.fd);
            }
          });
          sock.server.on('closed', function() {
            Module['websocket'].emit('close', sock.stream.fd);
            sock.server = null;
          });
          sock.server.on('error', function(error) {
            // Although the ws library may pass errors that may be more descriptive than
            // ECONNREFUSED they are not necessarily the expected error code e.g. 
            // ENOTFOUND on getaddrinfo seems to be node.js specific, so using EHOSTUNREACH
            // is still probably the most useful thing to do. This error shouldn't
            // occur in a well written app as errors should get trapped in the compiled
            // app's own getaddrinfo call.
            sock.error = ERRNO_CODES.EHOSTUNREACH; // Used in getsockopt for SOL_SOCKET/SO_ERROR test.
            Module['websocket'].emit('error', [sock.stream.fd, sock.error, 'EHOSTUNREACH: Host is unreachable']);
            // don't throw
          });
        },accept:function (listensock) {
          if (!listensock.server) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          var newsock = listensock.pending.shift();
          newsock.stream.flags = listensock.stream.flags;
          return newsock;
        },getname:function (sock, peer) {
          var addr, port;
          if (peer) {
            if (sock.daddr === undefined || sock.dport === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            }
            addr = sock.daddr;
            port = sock.dport;
          } else {
            // TODO saddr and sport will be set for bind()'d UDP sockets, but what
            // should we be returning for TCP sockets that've been connect()'d?
            addr = sock.saddr || 0;
            port = sock.sport || 0;
          }
          return { addr: addr, port: port };
        },sendmsg:function (sock, buffer, offset, length, addr, port) {
          if (sock.type === 2) {
            // connection-less sockets will honor the message address,
            // and otherwise fall back to the bound destination address
            if (addr === undefined || port === undefined) {
              addr = sock.daddr;
              port = sock.dport;
            }
            // if there was no address to fall back to, error out
            if (addr === undefined || port === undefined) {
              throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ);
            }
          } else {
            // connection-based sockets will only use the bound
            addr = sock.daddr;
            port = sock.dport;
          }
  
          // find the peer for the destination address
          var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
  
          // early out if not connected with a connection-based socket
          if (sock.type === 1) {
            if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
            } else if (dest.socket.readyState === dest.socket.CONNECTING) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
  
          // create a copy of the incoming data to send, as the WebSocket API
          // doesn't work entirely with an ArrayBufferView, it'll just send
          // the entire underlying buffer
          if (ArrayBuffer.isView(buffer)) {
            offset += buffer.byteOffset;
            buffer = buffer.buffer;
          }
  
          var data;
            data = buffer.slice(offset, offset + length);
  
          // if we're emulating a connection-less dgram socket and don't have
          // a cached connection, queue the buffer to send upon connect and
          // lie, saying the data was sent now.
          if (sock.type === 2) {
            if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
              // if we're not connected, open a new connection
              if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
              }
              dest.dgram_send_queue.push(data);
              return length;
            }
          }
  
          try {
            // send the actual data
            dest.socket.send(data);
            return length;
          } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
        },recvmsg:function (sock, length) {
          // http://pubs.opengroup.org/onlinepubs/7908799/xns/recvmsg.html
          if (sock.type === 1 && sock.server) {
            // tcp servers should not be recv()'ing on the listen socket
            throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
          }
  
          var queued = sock.recv_queue.shift();
          if (!queued) {
            if (sock.type === 1) {
              var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
  
              if (!dest) {
                // if we have a destination address but are not connected, error out
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN);
              }
              else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                // return null if the socket has closed
                return null;
              }
              else {
                // else, our socket is in a valid state but truly has nothing available
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
            } else {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
          }
  
          // queued.data will be an ArrayBuffer if it's unadulterated, but if it's
          // requeued TCP data it'll be an ArrayBufferView
          var queuedLength = queued.data.byteLength || queued.data.length;
          var queuedOffset = queued.data.byteOffset || 0;
          var queuedBuffer = queued.data.buffer || queued.data;
          var bytesRead = Math.min(length, queuedLength);
          var res = {
            buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
            addr: queued.addr,
            port: queued.port
          };
  
  
          // push back any unread data for TCP connections
          if (sock.type === 1 && bytesRead < queuedLength) {
            var bytesRemaining = queuedLength - bytesRead;
            queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
            sock.recv_queue.unshift(queued);
          }
  
          return res;
        }}};
  
  
  function __inet_pton4_raw(str) {
      var b = str.split('.');
      for (var i = 0; i < 4; i++) {
        var tmp = Number(b[i]);
        if (isNaN(tmp)) return null;
        b[i] = tmp;
      }
      return (b[0] | (b[1] << 8) | (b[2] << 16) | (b[3] << 24)) >>> 0;
    }
  
  function __inet_pton6_raw(str) {
      var words;
      var w, offset, z, i;
      /* http://home.deds.nl/~aeron/regex/ */
      var valid6regx = /^((?=.*::)(?!.*::.+::)(::)?([\dA-F]{1,4}:(:|\b)|){5}|([\dA-F]{1,4}:){6})((([\dA-F]{1,4}((?!\3)::|:\b|$))|(?!\2\3)){2}|(((2[0-4]|1\d|[1-9])?\d|25[0-5])\.?\b){4})$/i
      var parts = [];
      if (!valid6regx.test(str)) {
        return null;
      }
      if (str === "::") {
        return [0, 0, 0, 0, 0, 0, 0, 0];
      }
      // Z placeholder to keep track of zeros when splitting the string on ":"
      if (str.indexOf("::") === 0) {
        str = str.replace("::", "Z:"); // leading zeros case
      } else {
        str = str.replace("::", ":Z:");
      }
  
      if (str.indexOf(".") > 0) {
        // parse IPv4 embedded stress
        str = str.replace(new RegExp('[.]', 'g'), ":");
        words = str.split(":");
        words[words.length-4] = parseInt(words[words.length-4]) + parseInt(words[words.length-3])*256;
        words[words.length-3] = parseInt(words[words.length-2]) + parseInt(words[words.length-1])*256;
        words = words.slice(0, words.length-2);
      } else {
        words = str.split(":");
      }
  
      offset = 0; z = 0;
      for (w=0; w < words.length; w++) {
        if (typeof words[w] === 'string') {
          if (words[w] === 'Z') {
            // compressed zeros - write appropriate number of zero words
            for (z = 0; z < (8 - words.length+1); z++) {
              parts[w+z] = 0;
            }
            offset = z-1;
          } else {
            // parse hex to field to 16-bit value and write it in network byte-order
            parts[w+offset] = _htons(parseInt(words[w],16));
          }
        } else {
          // parsed IPv4 words
          parts[w+offset] = words[w];
        }
      }
      return [
        (parts[1] << 16) | parts[0],
        (parts[3] << 16) | parts[2],
        (parts[5] << 16) | parts[4],
        (parts[7] << 16) | parts[6]
      ];
    }var DNS={address_map:{id:1,addrs:{},names:{}},lookup_name:function (name) {
        // If the name is already a valid ipv4 / ipv6 address, don't generate a fake one.
        var res = __inet_pton4_raw(name);
        if (res !== null) {
          return name;
        }
        res = __inet_pton6_raw(name);
        if (res !== null) {
          return name;
        }
  
        // See if this name is already mapped.
        var addr;
  
        if (DNS.address_map.addrs[name]) {
          addr = DNS.address_map.addrs[name];
        } else {
          var id = DNS.address_map.id++;
          assert(id < 65535, 'exceeded max address mappings of 65535');
  
          addr = '172.29.' + (id & 0xff) + '.' + (id & 0xff00);
  
          DNS.address_map.names[addr] = name;
          DNS.address_map.addrs[name] = addr;
        }
  
        return addr;
      },lookup_addr:function (addr) {
        if (DNS.address_map.names[addr]) {
          return DNS.address_map.names[addr];
        }
  
        return null;
      }};
  
  
  var Sockets={BUFFER_SIZE:10240,MAX_BUFFER_SIZE:10485760,nextFd:1,fds:{},nextport:1,maxport:65535,peer:null,connections:{},portmap:{},localAddr:4261412874,addrPool:[33554442,50331658,67108874,83886090,100663306,117440522,134217738,150994954,167772170,184549386,201326602,218103818,234881034]};
  
  function __inet_ntop4_raw(addr) {
      return (addr & 0xff) + '.' + ((addr >> 8) & 0xff) + '.' + ((addr >> 16) & 0xff) + '.' + ((addr >> 24) & 0xff)
    }
  
  function __inet_ntop6_raw(ints) {
      //  ref:  http://www.ietf.org/rfc/rfc2373.txt - section 2.5.4
      //  Format for IPv4 compatible and mapped  128-bit IPv6 Addresses
      //  128-bits are split into eight 16-bit words
      //  stored in network byte order (big-endian)
      //  |                80 bits               | 16 |      32 bits        |
      //  +-----------------------------------------------------------------+
      //  |               10 bytes               |  2 |      4 bytes        |
      //  +--------------------------------------+--------------------------+
      //  +               5 words                |  1 |      2 words        |
      //  +--------------------------------------+--------------------------+
      //  |0000..............................0000|0000|    IPv4 ADDRESS     | (compatible)
      //  +--------------------------------------+----+---------------------+
      //  |0000..............................0000|FFFF|    IPv4 ADDRESS     | (mapped)
      //  +--------------------------------------+----+---------------------+
      var str = "";
      var word = 0;
      var longest = 0;
      var lastzero = 0;
      var zstart = 0;
      var len = 0;
      var i = 0;
      var parts = [
        ints[0] & 0xffff,
        (ints[0] >> 16),
        ints[1] & 0xffff,
        (ints[1] >> 16),
        ints[2] & 0xffff,
        (ints[2] >> 16),
        ints[3] & 0xffff,
        (ints[3] >> 16)
      ];
  
      // Handle IPv4-compatible, IPv4-mapped, loopback and any/unspecified addresses
  
      var hasipv4 = true;
      var v4part = "";
      // check if the 10 high-order bytes are all zeros (first 5 words)
      for (i = 0; i < 5; i++) {
        if (parts[i] !== 0) { hasipv4 = false; break; }
      }
  
      if (hasipv4) {
        // low-order 32-bits store an IPv4 address (bytes 13 to 16) (last 2 words)
        v4part = __inet_ntop4_raw(parts[6] | (parts[7] << 16));
        // IPv4-mapped IPv6 address if 16-bit value (bytes 11 and 12) == 0xFFFF (6th word)
        if (parts[5] === -1) {
          str = "::ffff:";
          str += v4part;
          return str;
        }
        // IPv4-compatible IPv6 address if 16-bit value (bytes 11 and 12) == 0x0000 (6th word)
        if (parts[5] === 0) {
          str = "::";
          //special case IPv6 addresses
          if(v4part === "0.0.0.0") v4part = ""; // any/unspecified address
          if(v4part === "0.0.0.1") v4part = "1";// loopback address
          str += v4part;
          return str;
        }
      }
  
      // Handle all other IPv6 addresses
  
      // first run to find the longest contiguous zero words
      for (word = 0; word < 8; word++) {
        if (parts[word] === 0) {
          if (word - lastzero > 1) {
            len = 0;
          }
          lastzero = word;
          len++;
        }
        if (len > longest) {
          longest = len;
          zstart = word - longest + 1;
        }
      }
  
      for (word = 0; word < 8; word++) {
        if (longest > 1) {
          // compress contiguous zeros - to produce "::"
          if (parts[word] === 0 && word >= zstart && word < (zstart + longest) ) {
            if (word === zstart) {
              str += ":";
              if (zstart === 0) str += ":"; //leading zeros case
            }
            continue;
          }
        }
        // converts 16-bit words from big-endian to little-endian before converting to hex string
        str += Number(_ntohs(parts[word] & 0xffff)).toString(16);
        str += word < 7 ? ":" : "";
      }
      return str;
    }function __read_sockaddr(sa, salen) {
      // family / port offsets are common to both sockaddr_in and sockaddr_in6
      var family = HEAP16[((sa)>>1)];
      var port = _ntohs(HEAP16[(((sa)+(2))>>1)]);
      var addr;
  
      switch (family) {
        case 2:
          if (salen !== 16) {
            return { errno: ERRNO_CODES.EINVAL };
          }
          addr = HEAP32[(((sa)+(4))>>2)];
          addr = __inet_ntop4_raw(addr);
          break;
        case 10:
          if (salen !== 28) {
            return { errno: ERRNO_CODES.EINVAL };
          }
          addr = [
            HEAP32[(((sa)+(8))>>2)],
            HEAP32[(((sa)+(12))>>2)],
            HEAP32[(((sa)+(16))>>2)],
            HEAP32[(((sa)+(20))>>2)]
          ];
          addr = __inet_ntop6_raw(addr);
          break;
        default:
          return { errno: ERRNO_CODES.EAFNOSUPPORT };
      }
  
      return { family: family, addr: addr, port: port };
    }
  
  function __write_sockaddr(sa, family, addr, port) {
      switch (family) {
        case 2:
          addr = __inet_pton4_raw(addr);
          HEAP16[((sa)>>1)]=family;
          HEAP32[(((sa)+(4))>>2)]=addr;
          HEAP16[(((sa)+(2))>>1)]=_htons(port);
          break;
        case 10:
          addr = __inet_pton6_raw(addr);
          HEAP32[((sa)>>2)]=family;
          HEAP32[(((sa)+(8))>>2)]=addr[0];
          HEAP32[(((sa)+(12))>>2)]=addr[1];
          HEAP32[(((sa)+(16))>>2)]=addr[2];
          HEAP32[(((sa)+(20))>>2)]=addr[3];
          HEAP16[(((sa)+(2))>>1)]=_htons(port);
          HEAP32[(((sa)+(4))>>2)]=0;
          HEAP32[(((sa)+(24))>>2)]=0;
          break;
        default:
          return { errno: ERRNO_CODES.EAFNOSUPPORT };
      }
      // kind of lame, but let's match _read_sockaddr's interface
      return {};
    }function ___syscall102(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // socketcall
      var call = SYSCALLS.get(), socketvararg = SYSCALLS.get();
      // socketcalls pass the rest of the arguments in a struct
      SYSCALLS.varargs = socketvararg;
      switch (call) {
        case 1: { // socket
          var domain = SYSCALLS.get(), type = SYSCALLS.get(), protocol = SYSCALLS.get();
          var sock = SOCKFS.createSocket(domain, type, protocol);
          assert(sock.stream.fd < 64); // XXX ? select() assumes socket fd values are in 0..63
          return sock.stream.fd;
        }
        case 2: { // bind
          var sock = SYSCALLS.getSocketFromFD(), info = SYSCALLS.getSocketAddress();
          sock.sock_ops.bind(sock, info.addr, info.port);
          return 0;
        }
        case 3: { // connect
          var sock = SYSCALLS.getSocketFromFD(), info = SYSCALLS.getSocketAddress();
          sock.sock_ops.connect(sock, info.addr, info.port);
          return 0;
        }
        case 4: { // listen
          var sock = SYSCALLS.getSocketFromFD(), backlog = SYSCALLS.get();
          sock.sock_ops.listen(sock, backlog);
          return 0;
        }
        case 5: { // accept
          var sock = SYSCALLS.getSocketFromFD(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
          var newsock = sock.sock_ops.accept(sock);
          if (addr) {
            var res = __write_sockaddr(addr, newsock.family, DNS.lookup_name(newsock.daddr), newsock.dport);
            assert(!res.errno);
          }
          return newsock.stream.fd;
        }
        case 6: { // getsockname
          var sock = SYSCALLS.getSocketFromFD(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
          // TODO: sock.saddr should never be undefined, see TODO in websocket_sock_ops.getname
          var res = __write_sockaddr(addr, sock.family, DNS.lookup_name(sock.saddr || '0.0.0.0'), sock.sport);
          assert(!res.errno);
          return 0;
        }
        case 7: { // getpeername
          var sock = SYSCALLS.getSocketFromFD(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
          if (!sock.daddr) {
            return -ERRNO_CODES.ENOTCONN; // The socket is not connected.
          }
          var res = __write_sockaddr(addr, sock.family, DNS.lookup_name(sock.daddr), sock.dport);
          assert(!res.errno);
          return 0;
        }
        case 11: { // sendto
          var sock = SYSCALLS.getSocketFromFD(), message = SYSCALLS.get(), length = SYSCALLS.get(), flags = SYSCALLS.get(), dest = SYSCALLS.getSocketAddress(true);
          if (!dest) {
            // send, no address provided
            return FS.write(sock.stream, HEAP8,message, length);
          } else {
            // sendto an address
            return sock.sock_ops.sendmsg(sock, HEAP8,message, length, dest.addr, dest.port);
          }
        }
        case 12: { // recvfrom
          var sock = SYSCALLS.getSocketFromFD(), buf = SYSCALLS.get(), len = SYSCALLS.get(), flags = SYSCALLS.get(), addr = SYSCALLS.get(), addrlen = SYSCALLS.get();
          var msg = sock.sock_ops.recvmsg(sock, len);
          if (!msg) return 0; // socket is closed
          if (addr) {
            var res = __write_sockaddr(addr, sock.family, DNS.lookup_name(msg.addr), msg.port);
            assert(!res.errno);
          }
          HEAPU8.set(msg.buffer, buf);
          return msg.buffer.byteLength;
        }
        case 14: { // setsockopt
          return -ERRNO_CODES.ENOPROTOOPT; // The option is unknown at the level indicated.
        }
        case 15: { // getsockopt
          var sock = SYSCALLS.getSocketFromFD(), level = SYSCALLS.get(), optname = SYSCALLS.get(), optval = SYSCALLS.get(), optlen = SYSCALLS.get();
          // Minimal getsockopt aimed at resolving https://github.com/kripken/emscripten/issues/2211
          // so only supports SOL_SOCKET with SO_ERROR.
          if (level === 1) {
            if (optname === 4) {
              HEAP32[((optval)>>2)]=sock.error;
              HEAP32[((optlen)>>2)]=4;
              sock.error = null; // Clear the error (The SO_ERROR option obtains and then clears this field).
              return 0;
            }
          }
          return -ERRNO_CODES.ENOPROTOOPT; // The option is unknown at the level indicated.
        }
        case 16: { // sendmsg
          var sock = SYSCALLS.getSocketFromFD(), message = SYSCALLS.get(), flags = SYSCALLS.get();
          var iov = HEAP32[(((message)+(8))>>2)];
          var num = HEAP32[(((message)+(12))>>2)];
          // read the address and port to send to
          var addr, port;
          var name = HEAP32[((message)>>2)];
          var namelen = HEAP32[(((message)+(4))>>2)];
          if (name) {
            var info = __read_sockaddr(name, namelen);
            if (info.errno) return -info.errno;
            port = info.port;
            addr = DNS.lookup_addr(info.addr) || info.addr;
          }
          // concatenate scatter-gather arrays into one message buffer
          var total = 0;
          for (var i = 0; i < num; i++) {
            total += HEAP32[(((iov)+((8 * i) + 4))>>2)];
          }
          var view = new Uint8Array(total);
          var offset = 0;
          for (var i = 0; i < num; i++) {
            var iovbase = HEAP32[(((iov)+((8 * i) + 0))>>2)];
            var iovlen = HEAP32[(((iov)+((8 * i) + 4))>>2)];
            for (var j = 0; j < iovlen; j++) {  
              view[offset++] = HEAP8[(((iovbase)+(j))>>0)];
            }
          }
          // write the buffer
          return sock.sock_ops.sendmsg(sock, view, 0, total, addr, port);
        }
        case 17: { // recvmsg
          var sock = SYSCALLS.getSocketFromFD(), message = SYSCALLS.get(), flags = SYSCALLS.get();
          var iov = HEAP32[(((message)+(8))>>2)];
          var num = HEAP32[(((message)+(12))>>2)];
          // get the total amount of data we can read across all arrays
          var total = 0;
          for (var i = 0; i < num; i++) {
            total += HEAP32[(((iov)+((8 * i) + 4))>>2)];
          }
          // try to read total data
          var msg = sock.sock_ops.recvmsg(sock, total);
          if (!msg) return 0; // socket is closed
  
          // TODO honor flags:
          // MSG_OOB
          // Requests out-of-band data. The significance and semantics of out-of-band data are protocol-specific.
          // MSG_PEEK
          // Peeks at the incoming message.
          // MSG_WAITALL
          // Requests that the function block until the full amount of data requested can be returned. The function may return a smaller amount of data if a signal is caught, if the connection is terminated, if MSG_PEEK was specified, or if an error is pending for the socket.
  
          // write the source address out
          var name = HEAP32[((message)>>2)];
          if (name) {
            var res = __write_sockaddr(name, sock.family, DNS.lookup_name(msg.addr), msg.port);
            assert(!res.errno);
          }
          // write the buffer out to the scatter-gather arrays
          var bytesRead = 0;
          var bytesRemaining = msg.buffer.byteLength;
          for (var i = 0; bytesRemaining > 0 && i < num; i++) {
            var iovbase = HEAP32[(((iov)+((8 * i) + 0))>>2)];
            var iovlen = HEAP32[(((iov)+((8 * i) + 4))>>2)];
            if (!iovlen) {
              continue;
            }
            var length = Math.min(iovlen, bytesRemaining);
            var buf = msg.buffer.subarray(bytesRead, bytesRead + length);
            HEAPU8.set(buf, iovbase + bytesRead);
            bytesRead += length;
            bytesRemaining -= length;
          }
  
          // TODO set msghdr.msg_flags
          // MSG_EOR
          // End of record was received (if supported by the protocol).
          // MSG_OOB
          // Out-of-band data was received.
          // MSG_TRUNC
          // Normal data was truncated.
          // MSG_CTRUNC
  
          return bytesRead;
        }
        default: abort('unsupported socketcall syscall ' + call);
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall122(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // uname
      var buf = SYSCALLS.get();
      if (!buf) return -ERRNO_CODES.EFAULT
      var layout = {"sysname":0,"nodename":65,"domainname":325,"machine":260,"version":195,"release":130,"__size__":390};
      function copyString(element, value) {
        var offset = layout[element];
        writeAsciiToMemory(value, buf + offset);
      }
      copyString('sysname', 'Emscripten');
      copyString('nodename', 'emscripten');
      copyString('release', '1.0');
      copyString('version', '#1');
      copyString('machine', 'x86-JS');
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall140(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // llseek
      var stream = SYSCALLS.getStreamFromFD(), offset_high = SYSCALLS.get(), offset_low = SYSCALLS.get(), result = SYSCALLS.get(), whence = SYSCALLS.get();
      // NOTE: offset_high is unused - Emscripten's off_t is 32-bit
      var offset = offset_low;
      FS.llseek(stream, offset, whence);
      HEAP32[((result)>>2)]=stream.position;
      if (stream.getdents && offset === 0 && whence === 0) stream.getdents = null; // reset readdir state
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall142(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // newselect
      // readfds are supported,
      // writefds checks socket open status
      // exceptfds not supported
      // timeout is always 0 - fully async
      var nfds = SYSCALLS.get(), readfds = SYSCALLS.get(), writefds = SYSCALLS.get(), exceptfds = SYSCALLS.get(), timeout = SYSCALLS.get();
  
      assert(nfds <= 64, 'nfds must be less than or equal to 64');  // fd sets have 64 bits // TODO: this could be 1024 based on current musl headers
      assert(!exceptfds, 'exceptfds not supported');
  
      var total = 0;
      
      var srcReadLow = (readfds ? HEAP32[((readfds)>>2)] : 0),
          srcReadHigh = (readfds ? HEAP32[(((readfds)+(4))>>2)] : 0);
      var srcWriteLow = (writefds ? HEAP32[((writefds)>>2)] : 0),
          srcWriteHigh = (writefds ? HEAP32[(((writefds)+(4))>>2)] : 0);
      var srcExceptLow = (exceptfds ? HEAP32[((exceptfds)>>2)] : 0),
          srcExceptHigh = (exceptfds ? HEAP32[(((exceptfds)+(4))>>2)] : 0);
  
      var dstReadLow = 0,
          dstReadHigh = 0;
      var dstWriteLow = 0,
          dstWriteHigh = 0;
      var dstExceptLow = 0,
          dstExceptHigh = 0;
  
      var allLow = (readfds ? HEAP32[((readfds)>>2)] : 0) |
                   (writefds ? HEAP32[((writefds)>>2)] : 0) |
                   (exceptfds ? HEAP32[((exceptfds)>>2)] : 0);
      var allHigh = (readfds ? HEAP32[(((readfds)+(4))>>2)] : 0) |
                    (writefds ? HEAP32[(((writefds)+(4))>>2)] : 0) |
                    (exceptfds ? HEAP32[(((exceptfds)+(4))>>2)] : 0);
  
      function check(fd, low, high, val) {
        return (fd < 32 ? (low & val) : (high & val));
      }
  
      for (var fd = 0; fd < nfds; fd++) {
        var mask = 1 << (fd % 32);
        if (!(check(fd, allLow, allHigh, mask))) {
          continue;  // index isn't in the set
        }
  
        var stream = FS.getStream(fd);
        if (!stream) throw new FS.ErrnoError(ERRNO_CODES.EBADF);
  
        var flags = SYSCALLS.DEFAULT_POLLMASK;
  
        if (stream.stream_ops.poll) {
          flags = stream.stream_ops.poll(stream);
        }
  
        if ((flags & 1) && check(fd, srcReadLow, srcReadHigh, mask)) {
          fd < 32 ? (dstReadLow = dstReadLow | mask) : (dstReadHigh = dstReadHigh | mask);
          total++;
        }
        if ((flags & 4) && check(fd, srcWriteLow, srcWriteHigh, mask)) {
          fd < 32 ? (dstWriteLow = dstWriteLow | mask) : (dstWriteHigh = dstWriteHigh | mask);
          total++;
        }
        if ((flags & 2) && check(fd, srcExceptLow, srcExceptHigh, mask)) {
          fd < 32 ? (dstExceptLow = dstExceptLow | mask) : (dstExceptHigh = dstExceptHigh | mask);
          total++;
        }
      }
  
      if (readfds) {
        HEAP32[((readfds)>>2)]=dstReadLow;
        HEAP32[(((readfds)+(4))>>2)]=dstReadHigh;
      }
      if (writefds) {
        HEAP32[((writefds)>>2)]=dstWriteLow;
        HEAP32[(((writefds)+(4))>>2)]=dstWriteHigh;
      }
      if (exceptfds) {
        HEAP32[((exceptfds)>>2)]=dstExceptLow;
        HEAP32[(((exceptfds)+(4))>>2)]=dstExceptHigh;
      }
      
      return total;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall145(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // readv
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doReadv(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall146(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // writev
      var stream = SYSCALLS.getStreamFromFD(), iov = SYSCALLS.get(), iovcnt = SYSCALLS.get();
      return SYSCALLS.doWritev(stream, iov, iovcnt);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall194(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ftruncate64
      var fd = SYSCALLS.get(), zero = SYSCALLS.getZero(), length = SYSCALLS.get64();
      FS.ftruncate(fd, length);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall195(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // SYS_stat64
      var path = SYSCALLS.getStr(), buf = SYSCALLS.get();
      return SYSCALLS.doStat(FS.stat, path, buf);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall197(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // SYS_fstat64
      var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get();
      return SYSCALLS.doStat(FS.stat, stream.path, buf);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall220(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // SYS_getdents64
      var stream = SYSCALLS.getStreamFromFD(), dirp = SYSCALLS.get(), count = SYSCALLS.get();
      if (!stream.getdents) {
        stream.getdents = FS.readdir(stream.path);
      }
      var pos = 0;
      while (stream.getdents.length > 0 && pos + 268 <= count) {
        var id;
        var type;
        var name = stream.getdents.pop();
        if (name[0] === '.') {
          id = 1;
          type = 4; // DT_DIR
        } else {
          var child = FS.lookupNode(stream.node, name);
          id = child.id;
          type = FS.isChrdev(child.mode) ? 2 :  // DT_CHR, character device.
                 FS.isDir(child.mode) ? 4 :     // DT_DIR, directory.
                 FS.isLink(child.mode) ? 10 :   // DT_LNK, symbolic link.
                 8;                             // DT_REG, regular file.
        }
        HEAP32[((dirp + pos)>>2)]=id;
        HEAP32[(((dirp + pos)+(4))>>2)]=stream.position;
        HEAP16[(((dirp + pos)+(8))>>1)]=268;
        HEAP8[(((dirp + pos)+(10))>>0)]=type;
        stringToUTF8(name, dirp + pos + 11, 256);
        pos += 268;
      }
      return pos;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall221(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // fcntl64
      var stream = SYSCALLS.getStreamFromFD(), cmd = SYSCALLS.get();
      switch (cmd) {
        case 0: {
          var arg = SYSCALLS.get();
          if (arg < 0) {
            return -ERRNO_CODES.EINVAL;
          }
          var newStream;
          newStream = FS.open(stream.path, stream.flags, 0, arg);
          return newStream.fd;
        }
        case 1:
        case 2:
          return 0;  // FD_CLOEXEC makes no sense for a single process.
        case 3:
          return stream.flags;
        case 4: {
          var arg = SYSCALLS.get();
          stream.flags |= arg;
          return 0;
        }
        case 12:
        case 12: {
          var arg = SYSCALLS.get();
          var offset = 0;
          // We're always unlocked.
          HEAP16[(((arg)+(offset))>>1)]=2;
          return 0;
        }
        case 13:
        case 14:
        case 13:
        case 14:
          return 0; // Pretend that the locking is successful.
        case 16:
        case 8:
          return -ERRNO_CODES.EINVAL; // These are for sockets. We don't have them fully implemented yet.
        case 9:
          // musl trusts getown return values, due to a bug where they must be, as they overlap with errors. just return -1 here, so fnctl() returns that, and we set errno ourselves.
          ___setErrNo(ERRNO_CODES.EINVAL);
          return -1;
        default: {
          return -ERRNO_CODES.EINVAL;
        }
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall3(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // read
      var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get();
      return FS.read(stream, HEAP8,buf, count);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall33(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // access
      var path = SYSCALLS.getStr(), amode = SYSCALLS.get();
      return SYSCALLS.doAccess(path, amode);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall38(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // rename
      var old_path = SYSCALLS.getStr(), new_path = SYSCALLS.getStr();
      FS.rename(old_path, new_path);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall39(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // mkdir
      var path = SYSCALLS.getStr(), mode = SYSCALLS.get();
      return SYSCALLS.doMkdir(path, mode);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall4(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // write
      var stream = SYSCALLS.getStreamFromFD(), buf = SYSCALLS.get(), count = SYSCALLS.get();
      return FS.write(stream, HEAP8,buf, count);
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall40(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // rmdir
      var path = SYSCALLS.getStr();
      FS.rmdir(path);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall5(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // open
      var pathname = SYSCALLS.getStr(), flags = SYSCALLS.get(), mode = SYSCALLS.get() // optional TODO
      var stream = FS.open(pathname, flags, mode);
      return stream.fd;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall54(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // ioctl
      var stream = SYSCALLS.getStreamFromFD(), op = SYSCALLS.get();
      switch (op) {
        case 21509:
        case 21505: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0;
        }
        case 21510:
        case 21511:
        case 21512:
        case 21506:
        case 21507:
        case 21508: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0; // no-op, not actually adjusting terminal settings
        }
        case 21519: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          var argp = SYSCALLS.get();
          HEAP32[((argp)>>2)]=0;
          return 0;
        }
        case 21520: {
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return -ERRNO_CODES.EINVAL; // not supported
        }
        case 21531: {
          var argp = SYSCALLS.get();
          return FS.ioctl(stream, op, argp);
        }
        case 21523: {
          // TODO: in theory we should write to the winsize struct that gets
          // passed in, but for now musl doesn't read anything on it
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0;
        }
        case 21524: {
          // TODO: technically, this ioctl call should change the window size.
          // but, since emscripten doesn't have any concept of a terminal window
          // yet, we'll just silently throw it away as we do TIOCGWINSZ
          if (!stream.tty) return -ERRNO_CODES.ENOTTY;
          return 0;
        }
        default: abort('bad ioctl syscall ' + op);
      }
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

  function ___syscall6(which, varargs) {SYSCALLS.varargs = varargs;
  try {
   // close
      var stream = SYSCALLS.getStreamFromFD();
      FS.close(stream);
      return 0;
    } catch (e) {
    if (typeof FS === 'undefined' || !(e instanceof FS.ErrnoError)) abort(e);
    return -e.errno;
  }
  }

   

  function ___unlock() {}

   

  function _abort() {
      Module['abort']();
    }

   

   

  var _emscripten_asm_const_int=true;

  
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }


  function _gethostbyname(name) {
      name = Pointer_stringify(name);
  
      // generate hostent
      var ret = _malloc(20); // XXX possibly leaked, as are others here
      var nameBuf = _malloc(name.length+1);
      stringToUTF8(name, nameBuf, name.length+1);
      HEAP32[((ret)>>2)]=nameBuf;
      var aliasesBuf = _malloc(4);
      HEAP32[((aliasesBuf)>>2)]=0;
      HEAP32[(((ret)+(4))>>2)]=aliasesBuf;
      var afinet = 2;
      HEAP32[(((ret)+(8))>>2)]=afinet;
      HEAP32[(((ret)+(12))>>2)]=4;
      var addrListBuf = _malloc(12);
      HEAP32[((addrListBuf)>>2)]=addrListBuf+8;
      HEAP32[(((addrListBuf)+(4))>>2)]=0;
      HEAP32[(((addrListBuf)+(8))>>2)]=__inet_pton4_raw(DNS.lookup_name(name));
      HEAP32[(((ret)+(16))>>2)]=addrListBuf;
      return ret;
    }

  function _gettimeofday(ptr) {
      var now = Date.now();
      HEAP32[((ptr)>>2)]=(now/1000)|0; // seconds
      HEAP32[(((ptr)+(4))>>2)]=((now % 1000)*1000)|0; // microseconds
      return 0;
    }



   

   

  var _llvm_ceil_f64=Math_ceil;

  
  function _llvm_exp2_f32(x) {
      return Math.pow(2, x);
    }function _llvm_exp2_f64() {
  return _llvm_exp2_f32.apply(null, arguments)
  }

  var _llvm_fabs_f32=Math_abs;

  var _llvm_fabs_f64=Math_abs;

  var _llvm_floor_f64=Math_floor;

  var _llvm_pow_f64=Math_pow;

  function _llvm_trap() {
      abort('trap!');
    }

  
  var ___tm_current=STATICTOP; STATICTOP += 48;;
  
  
  var ___tm_timezone=allocate(intArrayFromString("GMT"), "i8", ALLOC_STATIC);
  
  
  var _tzname=STATICTOP; STATICTOP += 16;;
  
  var _daylight=STATICTOP; STATICTOP += 16;;
  
  var _timezone=STATICTOP; STATICTOP += 16;;function _tzset() {
      // TODO: Use (malleable) environment variables instead of system settings.
      if (_tzset.called) return;
      _tzset.called = true;
  
      // timezone is specified as seconds west of UTC ("The external variable
      // `timezone` shall be set to the difference, in seconds, between
      // Coordinated Universal Time (UTC) and local standard time."), the same
      // as returned by getTimezoneOffset().
      // See http://pubs.opengroup.org/onlinepubs/009695399/functions/tzset.html
      HEAP32[((_timezone)>>2)]=(new Date()).getTimezoneOffset() * 60;
  
      var winter = new Date(2000, 0, 1);
      var summer = new Date(2000, 6, 1);
      HEAP32[((_daylight)>>2)]=Number(winter.getTimezoneOffset() != summer.getTimezoneOffset());
  
      function extractZone(date) {
        var match = date.toTimeString().match(/\(([A-Za-z ]+)\)$/);
        return match ? match[1] : "GMT";
      };
      var winterName = extractZone(winter);
      var summerName = extractZone(summer);
      var winterNamePtr = allocate(intArrayFromString(winterName), 'i8', ALLOC_NORMAL);
      var summerNamePtr = allocate(intArrayFromString(summerName), 'i8', ALLOC_NORMAL);
      if (summer.getTimezoneOffset() < winter.getTimezoneOffset()) {
        // Northern hemisphere
        HEAP32[((_tzname)>>2)]=winterNamePtr;
        HEAP32[(((_tzname)+(4))>>2)]=summerNamePtr;
      } else {
        HEAP32[((_tzname)>>2)]=summerNamePtr;
        HEAP32[(((_tzname)+(4))>>2)]=winterNamePtr;
      }
    }function _localtime_r(time, tmPtr) {
      _tzset();
      var date = new Date(HEAP32[((time)>>2)]*1000);
      HEAP32[((tmPtr)>>2)]=date.getSeconds();
      HEAP32[(((tmPtr)+(4))>>2)]=date.getMinutes();
      HEAP32[(((tmPtr)+(8))>>2)]=date.getHours();
      HEAP32[(((tmPtr)+(12))>>2)]=date.getDate();
      HEAP32[(((tmPtr)+(16))>>2)]=date.getMonth();
      HEAP32[(((tmPtr)+(20))>>2)]=date.getFullYear()-1900;
      HEAP32[(((tmPtr)+(24))>>2)]=date.getDay();
  
      var start = new Date(date.getFullYear(), 0, 1);
      var yday = ((date.getTime() - start.getTime()) / (1000 * 60 * 60 * 24))|0;
      HEAP32[(((tmPtr)+(28))>>2)]=yday;
      HEAP32[(((tmPtr)+(36))>>2)]=-(date.getTimezoneOffset() * 60);
  
      // Attention: DST is in December in South, and some regions don't have DST at all.
      var summerOffset = new Date(2000, 6, 1).getTimezoneOffset();
      var winterOffset = start.getTimezoneOffset();
      var dst = (summerOffset != winterOffset && date.getTimezoneOffset() == Math.min(winterOffset, summerOffset))|0;
      HEAP32[(((tmPtr)+(32))>>2)]=dst;
  
      var zonePtr = HEAP32[(((_tzname)+(dst ? 4 : 0))>>2)];
      HEAP32[(((tmPtr)+(40))>>2)]=zonePtr;
  
      return tmPtr;
    }function _localtime(time) {
      return _localtime_r(time, ___tm_current);
    }

  
  function _emscripten_memcpy_big(dest, src, num) {
      HEAPU8.set(HEAPU8.subarray(src, src+num), dest);
      return dest;
    } 

   

   

  
  var PTHREAD_SPECIFIC={};function _pthread_getspecific(key) {
      return PTHREAD_SPECIFIC[key] || 0;
    }

  
  var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key, destructor) {
      if (key == 0) {
        return ERRNO_CODES.EINVAL;
      }
      HEAP32[((key)>>2)]=PTHREAD_SPECIFIC_NEXT_KEY;
      // values start at 0
      PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY] = 0;
      PTHREAD_SPECIFIC_NEXT_KEY++;
      return 0;
    }

  function _pthread_once(ptr, func) {
      if (!_pthread_once.seen) _pthread_once.seen = {};
      if (ptr in _pthread_once.seen) return;
      Module['dynCall_v'](func);
      _pthread_once.seen[ptr] = 1;
    }

  function _pthread_setspecific(key, value) {
      if (!(key in PTHREAD_SPECIFIC)) {
        return ERRNO_CODES.EINVAL;
      }
      PTHREAD_SPECIFIC[key] = value;
      return 0;
    }

   

  function _sem_destroy() {}

  function _sem_init() {}

  function _sem_post() {}

  function _sem_wait() {}

  function _time(ptr) {
      var ret = (Date.now()/1000)|0;
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret;
      }
      return ret;
    }


  function _usleep(useconds) {
      // int usleep(useconds_t useconds);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/usleep.html
      // We're single-threaded, so use a busy loop. Super-ugly.
      var msec = useconds / 1000;
      if ((ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) && self['performance'] && self['performance']['now']) {
        var start = self['performance']['now']();
        while (self['performance']['now']() - start < msec) {
          // Do nothing.
        }
      } else {
        var start = Date.now();
        while (Date.now() - start < msec) {
          // Do nothing.
        }
      }
      return 0;
    }
  Module["_usleep"] = _usleep;

FS.staticInit();__ATINIT__.unshift(function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() });__ATMAIN__.push(function() { FS.ignorePermissions = false });__ATEXIT__.push(function() { FS.quit() });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;Module["FS_unlink"] = FS.unlink;;
__ATINIT__.unshift(function() { TTY.init() });__ATEXIT__.push(function() { TTY.shutdown() });;
if (ENVIRONMENT_IS_NODE) { var fs = require("fs"); var NODEJS_PATH = require("path"); NODEFS.staticInit(); };
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas, vrDevice) { Module.printErr("Module.requestFullScreen is deprecated. Please call Module.requestFullscreen instead."); Module["requestFullScreen"] = Module["requestFullscreen"]; Browser.requestFullScreen(lockPointer, resizeCanvas, vrDevice) };
  Module["requestFullscreen"] = function Module_requestFullscreen(lockPointer, resizeCanvas, vrDevice) { Browser.requestFullscreen(lockPointer, resizeCanvas, vrDevice) };
  Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function Module_pauseMainLoop() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function Module_resumeMainLoop() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function Module_getUserMedia() { Browser.getUserMedia() }
  Module["createContext"] = function Module_createContext(canvas, useWebGL, setInModule, webGLContextAttributes) { return Browser.createContext(canvas, useWebGL, setInModule, webGLContextAttributes) };
if (ENVIRONMENT_IS_NODE) {
    _emscripten_get_now = function _emscripten_get_now_actual() {
      var t = process['hrtime']();
      return t[0] * 1e3 + t[1] / 1e6;
    };
  } else if (typeof dateNow !== 'undefined') {
    _emscripten_get_now = dateNow;
  } else if (typeof self === 'object' && self['performance'] && typeof self['performance']['now'] === 'function') {
    _emscripten_get_now = function() { return self['performance']['now'](); };
  } else if (typeof performance === 'object' && typeof performance['now'] === 'function') {
    _emscripten_get_now = function() { return performance['now'](); };
  } else {
    _emscripten_get_now = Date.now;
  };
___buildEnvironment(ENV);;
var GLctx; GL.init();
__ATINIT__.push(function() { SOCKFS.root = FS.mount(SOCKFS, {}, null); });;
DYNAMICTOP_PTR = staticAlloc(4);

STACK_BASE = STACKTOP = alignMemory(STATICTOP);

STACK_MAX = STACK_BASE + TOTAL_STACK;

DYNAMIC_BASE = alignMemory(STACK_MAX);

HEAP32[DYNAMICTOP_PTR>>2] = DYNAMIC_BASE;

staticSealed = true; // seal the static portion of memory

assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");

var ASSERTIONS = true;

/** @type {function(string, boolean=, number=)} */
function intArrayFromString(stringy, dontAddNull, length) {
  var len = length > 0 ? length : lengthBytesUTF8(stringy)+1;
  var u8array = new Array(len);
  var numBytesWritten = stringToUTF8Array(stringy, u8array, 0, u8array.length);
  if (dontAddNull) u8array.length = numBytesWritten;
  return u8array;
}

function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      if (ASSERTIONS) {
        assert(false, 'Character code ' + chr + ' (' + String.fromCharCode(chr) + ')  at offset ' + i + ' not in 0x00-0xFF.');
      }
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}



var debug_table_ii = ["0", "0", "0", "0", "0", "0", "__ZN17disk_sparsebundle12is_read_onlyEv", "0", "0", "__ZN17disk_sparsebundle4sizeEv", "__ZN8tinyxml27XMLNode9ToElementEv", "__ZN8tinyxml27XMLNode6ToTextEv", "__ZN8tinyxml27XMLNode9ToCommentEv", "__ZN8tinyxml27XMLNode10ToDocumentEv", "__ZN8tinyxml27XMLNode13ToDeclarationEv", "__ZN8tinyxml27XMLNode9ToUnknownEv", "__ZNK8tinyxml27XMLNode9ToElementEv", "__ZNK8tinyxml27XMLNode6ToTextEv", "__ZNK8tinyxml27XMLNode9ToCommentEv", "__ZNK8tinyxml27XMLNode10ToDocumentEv", "__ZNK8tinyxml27XMLNode13ToDeclarationEv", "__ZNK8tinyxml27XMLNode9ToUnknownEv", "0", "0", "0", "__ZN8tinyxml214XMLDeclaration13ToDeclarationEv", "__ZNK8tinyxml214XMLDeclaration13ToDeclarationEv", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLComment9ToCommentEv", "__ZNK8tinyxml210XMLComment9ToCommentEv", "0", "0", "0", "0", "0", "__ZN8tinyxml27XMLText6ToTextEv", "__ZNK8tinyxml27XMLText6ToTextEv", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLUnknown9ToUnknownEv", "__ZNK8tinyxml210XMLUnknown9ToUnknownEv", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLElement9ToElementEv", "__ZNK8tinyxml210XMLElement9ToElementEv", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml211XMLDocument10ToDocumentEv", "__ZNK8tinyxml211XMLDocument10ToDocumentEv", "0", "0", "0", "0", "0", "0", "0", "__ZNK8tinyxml28MemPoolTILi44EE8ItemSizeEv", "__ZN8tinyxml28MemPoolTILi44EE5AllocEv", "0", "0", "0", "0", "__ZNK8tinyxml28MemPoolTILi48EE8ItemSizeEv", "__ZN8tinyxml28MemPoolTILi48EE5AllocEv", "0", "0", "0", "0", "__ZNK8tinyxml28MemPoolTILi36EE8ItemSizeEv", "__ZN8tinyxml28MemPoolTILi36EE5AllocEv", "0", "0", "0", "0", "__ZNK8tinyxml28MemPoolTILi52EE8ItemSizeEv", "__ZN8tinyxml28MemPoolTILi52EE5AllocEv", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN9DSERDPort5closeEv", "__ZL10dummy_lgetj", "__ZL10dummy_wgetj", "__ZL10dummy_bgetj", "0", "0", "0", "__Z13default_xlatej", "__ZL8ram_lgetj", "__ZL8ram_wgetj", "__ZL8ram_bgetj", "0", "0", "0", "__ZL9ram_xlatej", "__ZL10ram24_lgetj", "__ZL10ram24_wgetj", "__ZL10ram24_bgetj", "0", "0", "0", "__ZL11ram24_xlatej", "__ZL8rom_lgetj", "__ZL8rom_wgetj", "__ZL8rom_bgetj", "0", "0", "0", "__ZL9rom_xlatej", "__ZL10rom24_lgetj", "__ZL10rom24_wgetj", "__ZL10rom24_bgetj", "__ZL11rom24_xlatej", "__ZL17frame_direct_lgetj", "__ZL17frame_direct_wgetj", "__ZL17frame_direct_bgetj", "0", "0", "0", "__ZL11frame_xlatej", "__ZL19frame_host_555_lgetj", "__ZL19frame_host_555_wgetj", "0", "0", "__ZL19frame_host_565_lgetj", "__ZL19frame_host_565_wgetj", "0", "0", "__ZL19frame_host_888_lgetj", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "___stdio_close", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZNKSt11logic_error4whatEv", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_iii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZNK8tinyxml214XMLDeclaration12ShallowCloneEPNS_11XMLDocumentE", "__ZNK8tinyxml214XMLDeclaration12ShallowEqualEPKNS_7XMLNodeE", "__ZNK8tinyxml214XMLDeclaration6AcceptEPNS_10XMLVisitorE", "0", "0", "0", "0", "__ZNK8tinyxml210XMLComment12ShallowCloneEPNS_11XMLDocumentE", "__ZNK8tinyxml210XMLComment12ShallowEqualEPKNS_7XMLNodeE", "__ZNK8tinyxml210XMLComment6AcceptEPNS_10XMLVisitorE", "0", "0", "0", "0", "__ZNK8tinyxml27XMLText12ShallowCloneEPNS_11XMLDocumentE", "__ZNK8tinyxml27XMLText12ShallowEqualEPKNS_7XMLNodeE", "__ZNK8tinyxml27XMLText6AcceptEPNS_10XMLVisitorE", "0", "0", "0", "0", "__ZNK8tinyxml210XMLUnknown12ShallowCloneEPNS_11XMLDocumentE", "__ZNK8tinyxml210XMLUnknown12ShallowEqualEPKNS_7XMLNodeE", "__ZNK8tinyxml210XMLUnknown6AcceptEPNS_10XMLVisitorE", "0", "0", "0", "0", "__ZNK8tinyxml210XMLElement12ShallowCloneEPNS_11XMLDocumentE", "__ZNK8tinyxml210XMLElement12ShallowEqualEPKNS_7XMLNodeE", "__ZNK8tinyxml210XMLElement6AcceptEPNS_10XMLVisitorE", "0", "0", "0", "0", "0", "0", "0", "__ZNK8tinyxml211XMLDocument12ShallowCloneEPS0_", "__ZNK8tinyxml211XMLDocument12ShallowEqualEPKNS_7XMLNodeE", "__ZNK8tinyxml211XMLDocument6AcceptEPNS_10XMLVisitorE", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN9DSERDPort4openEt", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_iiii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml27XMLNode9ParseDeepEPcPNS_7StrPairE", "0", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml214XMLDeclaration9ParseDeepEPcPNS_7StrPairE", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLComment9ParseDeepEPcPNS_7StrPairE", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml27XMLText9ParseDeepEPcPNS_7StrPairE", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLUnknown9ParseDeepEPcPNS_7StrPairE", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLElement9ParseDeepEPcPNS_7StrPairE", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN9DSERDPort8prime_inEjj", "__ZN9DSERDPort9prime_outEjj", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "___stdout_write", "___stdio_seek", "___stdio_write", "_sn_write", "0", "0", "0", "0", "0", "__ZNK10__cxxabiv117__class_type_info9can_catchEPKNS_16__shim_type_infoERPv", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "___stdio_read", "_do_read", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_iiiii = ["0", "0", "0", "0", "0", "0", "0", "__ZN17disk_sparsebundle4readEPvij", "__ZN17disk_sparsebundle5writeEPvij", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN9DSERDPort7controlEjjt", "__ZN9DSERDPort6statusEjjt", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_v = ["0", "0", "0", "___cxa_pure_virtual", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZL25default_terminate_handlerv", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZL27video_refresh_window_staticv", "__ZL17video_refresh_dgav", "0", "0", "0", "__ZN10__cxxabiv112_GLOBAL__N_110construct_Ev", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_vi = ["0", "__ZN12monitor_descD2Ev", "__ZN12monitor_descD0Ev", "0", "__ZN17disk_sparsebundleD2Ev", "__ZN17disk_sparsebundleD0Ev", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml27XMLNodeD2Ev", "__ZN8tinyxml27XMLNodeD0Ev", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml214XMLDeclarationD0Ev", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLCommentD0Ev", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml27XMLTextD0Ev", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLUnknownD0Ev", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml210XMLElementD2Ev", "__ZN8tinyxml210XMLElementD0Ev", "__ZN8tinyxml212XMLAttributeD2Ev", "__ZN8tinyxml212XMLAttributeD0Ev", "0", "0", "0", "0", "0", "__ZN8tinyxml211XMLDocumentD2Ev", "__ZN8tinyxml211XMLDocumentD0Ev", "__ZN8tinyxml28MemPoolTILi44EED2Ev", "__ZN8tinyxml28MemPoolTILi44EED0Ev", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi44EE10SetTrackedEv", "__ZN8tinyxml28MemPoolTILi48EED2Ev", "__ZN8tinyxml28MemPoolTILi48EED0Ev", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi48EE10SetTrackedEv", "__ZN8tinyxml28MemPoolTILi36EED2Ev", "__ZN8tinyxml28MemPoolTILi36EED0Ev", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi36EE10SetTrackedEv", "__ZN8tinyxml28MemPoolTILi52EED2Ev", "__ZN8tinyxml28MemPoolTILi52EED0Ev", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi52EE10SetTrackedEv", "__ZN11driver_baseD2Ev", "__ZN11driver_baseD0Ev", "__ZN11driver_base14update_paletteEv", "__ZN11driver_base7suspendEv", "__ZN11driver_base6resumeEv", "__ZN11driver_base17toggle_mouse_grabEv", "0", "__ZN11driver_base10grab_mouseEv", "__ZN11driver_base12ungrab_mouseEv", "__ZN13driver_windowD0Ev", "__ZN13driver_window17toggle_mouse_grabEv", "0", "__ZN13driver_window10grab_mouseEv", "__ZN13driver_window12ungrab_mouseEv", "__ZN17driver_fullscreenD2Ev", "__ZN17driver_fullscreenD0Ev", "__ZN16SDL_monitor_descD0Ev", "__ZN16SDL_monitor_desc22switch_to_current_modeEv", "0", "__ZN8SERDPortD2Ev", "__ZN9DSERDPortD0Ev", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__Z9op_0_0_ffj", "__Z10op_10_0_ffj", "__Z10op_18_0_ffj", "__Z10op_20_0_ffj", "__Z10op_28_0_ffj", "__Z10op_30_0_ffj", "__Z10op_38_0_ffj", "__Z10op_39_0_ffj", "__Z10op_3c_0_ffj", "__Z10op_40_0_ffj", "__Z10op_50_0_ffj", "__Z10op_58_0_ffj", "__Z10op_60_0_ffj", "__Z10op_68_0_ffj", "__Z10op_70_0_ffj", "__Z10op_78_0_ffj", "__Z10op_79_0_ffj", "__Z10op_7c_0_ffj", "__Z10op_80_0_ffj", "__Z10op_90_0_ffj", "__Z10op_98_0_ffj", "__Z10op_a0_0_ffj", "__Z10op_a8_0_ffj", "__Z10op_b0_0_ffj", "__Z10op_b8_0_ffj", "__Z10op_b9_0_ffj", "__Z10op_d0_0_ffj", "__Z10op_e8_0_ffj", "__Z10op_f0_0_ffj", "__Z10op_f8_0_ffj", "__Z10op_f9_0_ffj", "__Z10op_fa_0_ffj", "__Z10op_fb_0_ffj", "__Z11op_100_0_ffj", "__Z11op_108_0_ffj", "__Z11op_110_0_ffj", "__Z11op_118_0_ffj", "__Z11op_120_0_ffj", "__Z11op_128_0_ffj", "__Z11op_130_0_ffj", "__Z11op_138_0_ffj", "__Z11op_139_0_ffj", "__Z11op_13a_0_ffj", "__Z11op_13b_0_ffj", "__Z11op_13c_0_ffj", "__Z11op_140_0_ffj", "__Z11op_148_0_ffj", "__Z11op_150_0_ffj", "__Z11op_158_0_ffj", "__Z11op_160_0_ffj", "__Z11op_168_0_ffj", "__Z11op_170_0_ffj", "__Z11op_178_0_ffj", "__Z11op_179_0_ffj", "__Z11op_17a_0_ffj", "__Z11op_17b_0_ffj", "__Z11op_180_0_ffj", "__Z11op_188_0_ffj", "__Z11op_190_0_ffj", "__Z11op_198_0_ffj", "__Z11op_1a0_0_ffj", "__Z11op_1a8_0_ffj", "__Z11op_1b0_0_ffj", "__Z11op_1b8_0_ffj", "__Z11op_1b9_0_ffj", "__Z11op_1ba_0_ffj", "__Z11op_1bb_0_ffj", "__Z11op_1c0_0_ffj", "__Z11op_1c8_0_ffj", "__Z11op_1d0_0_ffj", "__Z11op_1d8_0_ffj", "__Z11op_1e0_0_ffj", "__Z11op_1e8_0_ffj", "__Z11op_1f0_0_ffj", "__Z11op_1f8_0_ffj", "__Z11op_1f9_0_ffj", "__Z11op_1fa_0_ffj", "__Z11op_1fb_0_ffj", "__Z11op_200_0_ffj", "__Z11op_210_0_ffj", "__Z11op_218_0_ffj", "__Z11op_220_0_ffj", "__Z11op_228_0_ffj", "__Z11op_230_0_ffj", "__Z11op_238_0_ffj", "__Z11op_239_0_ffj", "__Z11op_23c_0_ffj", "__Z11op_240_0_ffj", "__Z11op_250_0_ffj", "__Z11op_258_0_ffj", "__Z11op_260_0_ffj", "__Z11op_268_0_ffj", "__Z11op_270_0_ffj", "__Z11op_278_0_ffj", "__Z11op_279_0_ffj", "__Z11op_27c_0_ffj", "__Z11op_280_0_ffj", "__Z11op_290_0_ffj", "__Z11op_298_0_ffj", "__Z11op_2a0_0_ffj", "__Z11op_2a8_0_ffj", "__Z11op_2b0_0_ffj", "__Z11op_2b8_0_ffj", "__Z11op_2b9_0_ffj", "__Z11op_2d0_0_ffj", "__Z11op_2e8_0_ffj", "__Z11op_2f0_0_ffj", "__Z11op_2f8_0_ffj", "__Z11op_2f9_0_ffj", "__Z11op_2fa_0_ffj", "__Z11op_2fb_0_ffj", "__Z11op_400_0_ffj", "__Z11op_410_0_ffj", "__Z11op_418_0_ffj", "__Z11op_420_0_ffj", "__Z11op_428_0_ffj", "__Z11op_430_0_ffj", "__Z11op_438_0_ffj", "__Z11op_439_0_ffj", "__Z11op_440_0_ffj", "__Z11op_450_0_ffj", "__Z11op_458_0_ffj", "__Z11op_460_0_ffj", "__Z11op_468_0_ffj", "__Z11op_470_0_ffj", "__Z11op_478_0_ffj", "__Z11op_479_0_ffj", "__Z11op_480_0_ffj", "__Z11op_490_0_ffj", "__Z11op_498_0_ffj", "__Z11op_4a0_0_ffj", "__Z11op_4a8_0_ffj", "__Z11op_4b0_0_ffj", "__Z11op_4b8_0_ffj", "__Z11op_4b9_0_ffj", "__Z11op_4d0_0_ffj", "__Z11op_4e8_0_ffj", "__Z11op_4f0_0_ffj", "__Z11op_4f8_0_ffj", "__Z11op_4f9_0_ffj", "__Z11op_4fa_0_ffj", "__Z11op_4fb_0_ffj", "__Z11op_600_0_ffj", "__Z11op_610_0_ffj", "__Z11op_618_0_ffj", "__Z11op_620_0_ffj", "__Z11op_628_0_ffj", "__Z11op_630_0_ffj", "__Z11op_638_0_ffj", "__Z11op_639_0_ffj", "__Z11op_640_0_ffj", "__Z11op_650_0_ffj", "__Z11op_658_0_ffj", "__Z11op_660_0_ffj", "__Z11op_668_0_ffj", "__Z11op_670_0_ffj", "__Z11op_678_0_ffj", "__Z11op_679_0_ffj", "__Z11op_680_0_ffj", "__Z11op_690_0_ffj", "__Z11op_698_0_ffj", "__Z11op_6a0_0_ffj", "__Z11op_6a8_0_ffj", "__Z11op_6b0_0_ffj", "__Z11op_6b8_0_ffj", "__Z11op_6b9_0_ffj", "__Z11op_6c0_0_ffj", "__Z11op_6c8_0_ffj", "__Z11op_6d0_0_ffj", "__Z11op_6e8_0_ffj", "__Z11op_6f0_0_ffj", "__Z11op_6f8_0_ffj", "__Z11op_6f9_0_ffj", "__Z11op_6fa_0_ffj", "__Z11op_6fb_0_ffj", "__Z11op_800_0_ffj", "__Z11op_810_0_ffj", "__Z11op_818_0_ffj", "__Z11op_820_0_ffj", "__Z11op_828_0_ffj", "__Z11op_830_0_ffj", "__Z11op_838_0_ffj", "__Z11op_839_0_ffj", "__Z11op_83a_0_ffj", "__Z11op_83b_0_ffj", "__Z11op_83c_0_ffj", "__Z11op_840_0_ffj", "__Z11op_850_0_ffj", "__Z11op_858_0_ffj", "__Z11op_860_0_ffj", "__Z11op_868_0_ffj", "__Z11op_870_0_ffj", "__Z11op_878_0_ffj", "__Z11op_879_0_ffj", "__Z11op_87a_0_ffj", "__Z11op_87b_0_ffj", "__Z11op_880_0_ffj", "__Z11op_890_0_ffj", "__Z11op_898_0_ffj", "__Z11op_8a0_0_ffj", "__Z11op_8a8_0_ffj", "__Z11op_8b0_0_ffj", "__Z11op_8b8_0_ffj", "__Z11op_8b9_0_ffj", "__Z11op_8ba_0_ffj", "__Z11op_8bb_0_ffj", "__Z11op_8c0_0_ffj", "__Z11op_8d0_0_ffj", "__Z11op_8d8_0_ffj", "__Z11op_8e0_0_ffj", "__Z11op_8e8_0_ffj", "__Z11op_8f0_0_ffj", "__Z11op_8f8_0_ffj", "__Z11op_8f9_0_ffj", "__Z11op_8fa_0_ffj", "__Z11op_8fb_0_ffj", "__Z11op_a00_0_ffj", "__Z11op_a10_0_ffj", "__Z11op_a18_0_ffj", "__Z11op_a20_0_ffj", "__Z11op_a28_0_ffj", "__Z11op_a30_0_ffj", "__Z11op_a38_0_ffj", "__Z11op_a39_0_ffj", "__Z11op_a3c_0_ffj", "__Z11op_a40_0_ffj", "__Z11op_a50_0_ffj", "__Z11op_a58_0_ffj", "__Z11op_a60_0_ffj", "__Z11op_a68_0_ffj", "__Z11op_a70_0_ffj", "__Z11op_a78_0_ffj", "__Z11op_a79_0_ffj", "__Z11op_a7c_0_ffj", "__Z11op_a80_0_ffj", "__Z11op_a90_0_ffj", "__Z11op_a98_0_ffj", "__Z11op_aa0_0_ffj", "__Z11op_aa8_0_ffj", "__Z11op_ab0_0_ffj", "__Z11op_ab8_0_ffj", "__Z11op_ab9_0_ffj", "__Z11op_ad0_0_ffj", "__Z11op_ad8_0_ffj", "__Z11op_ae0_0_ffj", "__Z11op_ae8_0_ffj", "__Z11op_af0_0_ffj", "__Z11op_af8_0_ffj", "__Z11op_af9_0_ffj", "__Z11op_c00_0_ffj", "__Z11op_c10_0_ffj", "__Z11op_c18_0_ffj", "__Z11op_c20_0_ffj", "__Z11op_c28_0_ffj", "__Z11op_c30_0_ffj", "__Z11op_c38_0_ffj", "__Z11op_c39_0_ffj", "__Z11op_c3a_0_ffj", "__Z11op_c3b_0_ffj", "__Z11op_c40_0_ffj", "__Z11op_c50_0_ffj", "__Z11op_c58_0_ffj", "__Z11op_c60_0_ffj", "__Z11op_c68_0_ffj", "__Z11op_c70_0_ffj", "__Z11op_c78_0_ffj", "__Z11op_c79_0_ffj", "__Z11op_c7a_0_ffj", "__Z11op_c7b_0_ffj", "__Z11op_c80_0_ffj", "__Z11op_c90_0_ffj", "__Z11op_c98_0_ffj", "__Z11op_ca0_0_ffj", "__Z11op_ca8_0_ffj", "__Z11op_cb0_0_ffj", "__Z11op_cb8_0_ffj", "__Z11op_cb9_0_ffj", "__Z11op_cba_0_ffj", "__Z11op_cbb_0_ffj", "__Z11op_cd0_0_ffj", "__Z11op_cd8_0_ffj", "__Z11op_ce0_0_ffj", "__Z11op_ce8_0_ffj", "__Z11op_cf0_0_ffj", "__Z11op_cf8_0_ffj", "__Z11op_cf9_0_ffj", "__Z11op_cfc_0_ffj", "__Z11op_e10_0_ffj", "__Z11op_e18_0_ffj", "__Z11op_e20_0_ffj", "__Z11op_e28_0_ffj", "__Z11op_e30_0_ffj", "__Z11op_e38_0_ffj", "__Z11op_e39_0_ffj", "__Z11op_e50_0_ffj", "__Z11op_e58_0_ffj", "__Z11op_e60_0_ffj", "__Z11op_e68_0_ffj", "__Z11op_e70_0_ffj", "__Z11op_e78_0_ffj", "__Z11op_e79_0_ffj", "__Z11op_e90_0_ffj", "__Z11op_e98_0_ffj", "__Z11op_ea0_0_ffj", "__Z11op_ea8_0_ffj", "__Z11op_eb0_0_ffj", "__Z11op_eb8_0_ffj", "__Z11op_eb9_0_ffj", "__Z11op_ed0_0_ffj", "__Z11op_ed8_0_ffj", "__Z11op_ee0_0_ffj", "__Z11op_ee8_0_ffj", "__Z11op_ef0_0_ffj", "__Z11op_ef8_0_ffj", "__Z11op_ef9_0_ffj", "__Z11op_efc_0_ffj", "__Z12op_1000_0_ffj", "__Z12op_1010_0_ffj", "__Z12op_1018_0_ffj", "__Z12op_1020_0_ffj", "__Z12op_1028_0_ffj", "__Z12op_1030_0_ffj", "__Z12op_1038_0_ffj", "__Z12op_1039_0_ffj", "__Z12op_103a_0_ffj", "__Z12op_103b_0_ffj", "__Z12op_103c_0_ffj", "__Z12op_1080_0_ffj", "__Z12op_1090_0_ffj", "__Z12op_1098_0_ffj", "__Z12op_10a0_0_ffj", "__Z12op_10a8_0_ffj", "__Z12op_10b0_0_ffj", "__Z12op_10b8_0_ffj", "__Z12op_10b9_0_ffj", "__Z12op_10ba_0_ffj", "__Z12op_10bb_0_ffj", "__Z12op_10bc_0_ffj", "__Z12op_10c0_0_ffj", "__Z12op_10d0_0_ffj", "__Z12op_10d8_0_ffj", "__Z12op_10e0_0_ffj", "__Z12op_10e8_0_ffj", "__Z12op_10f0_0_ffj", "__Z12op_10f8_0_ffj", "__Z12op_10f9_0_ffj", "__Z12op_10fa_0_ffj", "__Z12op_10fb_0_ffj", "__Z12op_10fc_0_ffj", "__Z12op_1100_0_ffj", "__Z12op_1110_0_ffj", "__Z12op_1118_0_ffj", "__Z12op_1120_0_ffj", "__Z12op_1128_0_ffj", "__Z12op_1130_0_ffj", "__Z12op_1138_0_ffj", "__Z12op_1139_0_ffj", "__Z12op_113a_0_ffj", "__Z12op_113b_0_ffj", "__Z12op_113c_0_ffj", "__Z12op_1140_0_ffj", "__Z12op_1150_0_ffj", "__Z12op_1158_0_ffj", "__Z12op_1160_0_ffj", "__Z12op_1168_0_ffj", "__Z12op_1170_0_ffj", "__Z12op_1178_0_ffj", "__Z12op_1179_0_ffj", "__Z12op_117a_0_ffj", "__Z12op_117b_0_ffj", "__Z12op_117c_0_ffj", "__Z12op_1180_0_ffj", "__Z12op_1190_0_ffj", "__Z12op_1198_0_ffj", "__Z12op_11a0_0_ffj", "__Z12op_11a8_0_ffj", "__Z12op_11b0_0_ffj", "__Z12op_11b8_0_ffj", "__Z12op_11b9_0_ffj", "__Z12op_11ba_0_ffj", "__Z12op_11bb_0_ffj", "__Z12op_11bc_0_ffj", "__Z12op_11c0_0_ffj", "__Z12op_11d0_0_ffj", "__Z12op_11d8_0_ffj", "__Z12op_11e0_0_ffj", "__Z12op_11e8_0_ffj", "__Z12op_11f0_0_ffj", "__Z12op_11f8_0_ffj", "__Z12op_11f9_0_ffj", "__Z12op_11fa_0_ffj", "__Z12op_11fb_0_ffj", "__Z12op_11fc_0_ffj", "__Z12op_13c0_0_ffj", "__Z12op_13d0_0_ffj", "__Z12op_13d8_0_ffj", "__Z12op_13e0_0_ffj", "__Z12op_13e8_0_ffj", "__Z12op_13f0_0_ffj", "__Z12op_13f8_0_ffj", "__Z12op_13f9_0_ffj", "__Z12op_13fa_0_ffj", "__Z12op_13fb_0_ffj", "__Z12op_13fc_0_ffj", "__Z12op_2000_0_ffj", "__Z12op_2008_0_ffj", "__Z12op_2010_0_ffj", "__Z12op_2018_0_ffj", "__Z12op_2020_0_ffj", "__Z12op_2028_0_ffj", "__Z12op_2030_0_ffj", "__Z12op_2038_0_ffj", "__Z12op_2039_0_ffj", "__Z12op_203a_0_ffj", "__Z12op_203b_0_ffj", "__Z12op_203c_0_ffj", "__Z12op_2040_0_ffj", "__Z12op_2048_0_ffj", "__Z12op_2050_0_ffj", "__Z12op_2058_0_ffj", "__Z12op_2060_0_ffj", "__Z12op_2068_0_ffj", "__Z12op_2070_0_ffj", "__Z12op_2078_0_ffj", "__Z12op_2079_0_ffj", "__Z12op_207a_0_ffj", "__Z12op_207b_0_ffj", "__Z12op_207c_0_ffj", "__Z12op_2080_0_ffj", "__Z12op_2088_0_ffj", "__Z12op_2090_0_ffj", "__Z12op_2098_0_ffj", "__Z12op_20a0_0_ffj", "__Z12op_20a8_0_ffj", "__Z12op_20b0_0_ffj", "__Z12op_20b8_0_ffj", "__Z12op_20b9_0_ffj", "__Z12op_20ba_0_ffj", "__Z12op_20bb_0_ffj", "__Z12op_20bc_0_ffj", "__Z12op_20c0_0_ffj", "__Z12op_20c8_0_ffj", "__Z12op_20d0_0_ffj", "__Z12op_20d8_0_ffj", "__Z12op_20e0_0_ffj", "__Z12op_20e8_0_ffj", "__Z12op_20f0_0_ffj", "__Z12op_20f8_0_ffj", "__Z12op_20f9_0_ffj", "__Z12op_20fa_0_ffj", "__Z12op_20fb_0_ffj", "__Z12op_20fc_0_ffj", "__Z12op_2100_0_ffj", "__Z12op_2108_0_ffj", "__Z12op_2110_0_ffj", "__Z12op_2118_0_ffj", "__Z12op_2120_0_ffj", "__Z12op_2128_0_ffj", "__Z12op_2130_0_ffj", "__Z12op_2138_0_ffj", "__Z12op_2139_0_ffj", "__Z12op_213a_0_ffj", "__Z12op_213b_0_ffj", "__Z12op_213c_0_ffj", "__Z12op_2140_0_ffj", "__Z12op_2148_0_ffj", "__Z12op_2150_0_ffj", "__Z12op_2158_0_ffj", "__Z12op_2160_0_ffj", "__Z12op_2168_0_ffj", "__Z12op_2170_0_ffj", "__Z12op_2178_0_ffj", "__Z12op_2179_0_ffj", "__Z12op_217a_0_ffj", "__Z12op_217b_0_ffj", "__Z12op_217c_0_ffj", "__Z12op_2180_0_ffj", "__Z12op_2188_0_ffj", "__Z12op_2190_0_ffj", "__Z12op_2198_0_ffj", "__Z12op_21a0_0_ffj", "__Z12op_21a8_0_ffj", "__Z12op_21b0_0_ffj", "__Z12op_21b8_0_ffj", "__Z12op_21b9_0_ffj", "__Z12op_21ba_0_ffj", "__Z12op_21bb_0_ffj", "__Z12op_21bc_0_ffj", "__Z12op_21c0_0_ffj", "__Z12op_21c8_0_ffj", "__Z12op_21d0_0_ffj", "__Z12op_21d8_0_ffj", "__Z12op_21e0_0_ffj", "__Z12op_21e8_0_ffj", "__Z12op_21f0_0_ffj", "__Z12op_21f8_0_ffj", "__Z12op_21f9_0_ffj", "__Z12op_21fa_0_ffj", "__Z12op_21fb_0_ffj", "__Z12op_21fc_0_ffj", "__Z12op_23c0_0_ffj", "__Z12op_23c8_0_ffj", "__Z12op_23d0_0_ffj", "__Z12op_23d8_0_ffj", "__Z12op_23e0_0_ffj", "__Z12op_23e8_0_ffj", "__Z12op_23f0_0_ffj", "__Z12op_23f8_0_ffj", "__Z12op_23f9_0_ffj", "__Z12op_23fa_0_ffj", "__Z12op_23fb_0_ffj", "__Z12op_23fc_0_ffj", "__Z12op_3000_0_ffj", "__Z12op_3008_0_ffj", "__Z12op_3010_0_ffj", "__Z12op_3018_0_ffj", "__Z12op_3020_0_ffj", "__Z12op_3028_0_ffj", "__Z12op_3030_0_ffj", "__Z12op_3038_0_ffj", "__Z12op_3039_0_ffj", "__Z12op_303a_0_ffj", "__Z12op_303b_0_ffj", "__Z12op_303c_0_ffj", "__Z12op_3040_0_ffj", "__Z12op_3048_0_ffj", "__Z12op_3050_0_ffj", "__Z12op_3058_0_ffj", "__Z12op_3060_0_ffj", "__Z12op_3068_0_ffj", "__Z12op_3070_0_ffj", "__Z12op_3078_0_ffj", "__Z12op_3079_0_ffj", "__Z12op_307a_0_ffj", "__Z12op_307b_0_ffj", "__Z12op_307c_0_ffj", "__Z12op_3080_0_ffj", "__Z12op_3088_0_ffj", "__Z12op_3090_0_ffj", "__Z12op_3098_0_ffj", "__Z12op_30a0_0_ffj", "__Z12op_30a8_0_ffj", "__Z12op_30b0_0_ffj", "__Z12op_30b8_0_ffj", "__Z12op_30b9_0_ffj", "__Z12op_30ba_0_ffj", "__Z12op_30bb_0_ffj", "__Z12op_30bc_0_ffj", "__Z12op_30c0_0_ffj", "__Z12op_30c8_0_ffj", "__Z12op_30d0_0_ffj", "__Z12op_30d8_0_ffj", "__Z12op_30e0_0_ffj", "__Z12op_30e8_0_ffj", "__Z12op_30f0_0_ffj", "__Z12op_30f8_0_ffj", "__Z12op_30f9_0_ffj", "__Z12op_30fa_0_ffj", "__Z12op_30fb_0_ffj", "__Z12op_30fc_0_ffj", "__Z12op_3100_0_ffj", "__Z12op_3108_0_ffj", "__Z12op_3110_0_ffj", "__Z12op_3118_0_ffj", "__Z12op_3120_0_ffj", "__Z12op_3128_0_ffj", "__Z12op_3130_0_ffj", "__Z12op_3138_0_ffj", "__Z12op_3139_0_ffj", "__Z12op_313a_0_ffj", "__Z12op_313b_0_ffj", "__Z12op_313c_0_ffj", "__Z12op_3140_0_ffj", "__Z12op_3148_0_ffj", "__Z12op_3150_0_ffj", "__Z12op_3158_0_ffj", "__Z12op_3160_0_ffj", "__Z12op_3168_0_ffj", "__Z12op_3170_0_ffj", "__Z12op_3178_0_ffj", "__Z12op_3179_0_ffj", "__Z12op_317a_0_ffj", "__Z12op_317b_0_ffj", "__Z12op_317c_0_ffj", "__Z12op_3180_0_ffj", "__Z12op_3188_0_ffj", "__Z12op_3190_0_ffj", "__Z12op_3198_0_ffj", "__Z12op_31a0_0_ffj", "__Z12op_31a8_0_ffj", "__Z12op_31b0_0_ffj", "__Z12op_31b8_0_ffj", "__Z12op_31b9_0_ffj", "__Z12op_31ba_0_ffj", "__Z12op_31bb_0_ffj", "__Z12op_31bc_0_ffj", "__Z12op_31c0_0_ffj", "__Z12op_31c8_0_ffj", "__Z12op_31d0_0_ffj", "__Z12op_31d8_0_ffj", "__Z12op_31e0_0_ffj", "__Z12op_31e8_0_ffj", "__Z12op_31f0_0_ffj", "__Z12op_31f8_0_ffj", "__Z12op_31f9_0_ffj", "__Z12op_31fa_0_ffj", "__Z12op_31fb_0_ffj", "__Z12op_31fc_0_ffj", "__Z12op_33c0_0_ffj", "__Z12op_33c8_0_ffj", "__Z12op_33d0_0_ffj", "__Z12op_33d8_0_ffj", "__Z12op_33e0_0_ffj", "__Z12op_33e8_0_ffj", "__Z12op_33f0_0_ffj", "__Z12op_33f8_0_ffj", "__Z12op_33f9_0_ffj", "__Z12op_33fa_0_ffj", "__Z12op_33fb_0_ffj", "__Z12op_33fc_0_ffj", "__Z12op_4000_0_ffj", "__Z12op_4010_0_ffj", "__Z12op_4018_0_ffj", "__Z12op_4020_0_ffj", "__Z12op_4028_0_ffj", "__Z12op_4030_0_ffj", "__Z12op_4038_0_ffj", "__Z12op_4039_0_ffj", "__Z12op_4040_0_ffj", "__Z12op_4050_0_ffj", "__Z12op_4058_0_ffj", "__Z12op_4060_0_ffj", "__Z12op_4068_0_ffj", "__Z12op_4070_0_ffj", "__Z12op_4078_0_ffj", "__Z12op_4079_0_ffj", "__Z12op_4080_0_ffj", "__Z12op_4090_0_ffj", "__Z12op_4098_0_ffj", "__Z12op_40a0_0_ffj", "__Z12op_40a8_0_ffj", "__Z12op_40b0_0_ffj", "__Z12op_40b8_0_ffj", "__Z12op_40b9_0_ffj", "__Z12op_40c0_0_ffj", "__Z12op_40d0_0_ffj", "__Z12op_40d8_0_ffj", "__Z12op_40e0_0_ffj", "__Z12op_40e8_0_ffj", "__Z12op_40f0_0_ffj", "__Z12op_40f8_0_ffj", "__Z12op_40f9_0_ffj", "__Z12op_4100_0_ffj", "__Z12op_4110_0_ffj", "__Z12op_4118_0_ffj", "__Z12op_4120_0_ffj", "__Z12op_4128_0_ffj", "__Z12op_4130_0_ffj", "__Z12op_4138_0_ffj", "__Z12op_4139_0_ffj", "__Z12op_413a_0_ffj", "__Z12op_413b_0_ffj", "__Z12op_413c_0_ffj", "__Z12op_4180_0_ffj", "__Z12op_4190_0_ffj", "__Z12op_4198_0_ffj", "__Z12op_41a0_0_ffj", "__Z12op_41a8_0_ffj", "__Z12op_41b0_0_ffj", "__Z12op_41b8_0_ffj", "__Z12op_41b9_0_ffj", "__Z12op_41ba_0_ffj", "__Z12op_41bb_0_ffj", "__Z12op_41bc_0_ffj", "__Z12op_41d0_0_ffj", "__Z12op_41e8_0_ffj", "__Z12op_41f0_0_ffj", "__Z12op_41f8_0_ffj", "__Z12op_41f9_0_ffj", "__Z12op_41fa_0_ffj", "__Z12op_41fb_0_ffj", "__Z12op_4200_0_ffj", "__Z12op_4210_0_ffj", "__Z12op_4218_0_ffj", "__Z12op_4220_0_ffj", "__Z12op_4228_0_ffj", "__Z12op_4230_0_ffj", "__Z12op_4238_0_ffj", "__Z12op_4239_0_ffj", "__Z12op_4240_0_ffj", "__Z12op_4250_0_ffj", "__Z12op_4258_0_ffj", "__Z12op_4260_0_ffj", "__Z12op_4268_0_ffj", "__Z12op_4270_0_ffj", "__Z12op_4278_0_ffj", "__Z12op_4279_0_ffj", "__Z12op_4280_0_ffj", "__Z12op_4290_0_ffj", "__Z12op_4298_0_ffj", "__Z12op_42a0_0_ffj", "__Z12op_42a8_0_ffj", "__Z12op_42b0_0_ffj", "__Z12op_42b8_0_ffj", "__Z12op_42b9_0_ffj", "__Z12op_42c0_0_ffj", "__Z12op_42d0_0_ffj", "__Z12op_42d8_0_ffj", "__Z12op_42e0_0_ffj", "__Z12op_42e8_0_ffj", "__Z12op_42f0_0_ffj", "__Z12op_42f8_0_ffj", "__Z12op_42f9_0_ffj", "__Z12op_4400_0_ffj", "__Z12op_4410_0_ffj", "__Z12op_4418_0_ffj", "__Z12op_4420_0_ffj", "__Z12op_4428_0_ffj", "__Z12op_4430_0_ffj", "__Z12op_4438_0_ffj", "__Z12op_4439_0_ffj", "__Z12op_4440_0_ffj", "__Z12op_4450_0_ffj", "__Z12op_4458_0_ffj", "__Z12op_4460_0_ffj", "__Z12op_4468_0_ffj", "__Z12op_4470_0_ffj", "__Z12op_4478_0_ffj", "__Z12op_4479_0_ffj", "__Z12op_4480_0_ffj", "__Z12op_4490_0_ffj", "__Z12op_4498_0_ffj", "__Z12op_44a0_0_ffj", "__Z12op_44a8_0_ffj", "__Z12op_44b0_0_ffj", "__Z12op_44b8_0_ffj", "__Z12op_44b9_0_ffj", "__Z12op_44c0_0_ffj", "__Z12op_44d0_0_ffj", "__Z12op_44d8_0_ffj", "__Z12op_44e0_0_ffj", "__Z12op_44e8_0_ffj", "__Z12op_44f0_0_ffj", "__Z12op_44f8_0_ffj", "__Z12op_44f9_0_ffj", "__Z12op_44fa_0_ffj", "__Z12op_44fb_0_ffj", "__Z12op_44fc_0_ffj", "__Z12op_4600_0_ffj", "__Z12op_4610_0_ffj", "__Z12op_4618_0_ffj", "__Z12op_4620_0_ffj", "__Z12op_4628_0_ffj", "__Z12op_4630_0_ffj", "__Z12op_4638_0_ffj", "__Z12op_4639_0_ffj", "__Z12op_4640_0_ffj", "__Z12op_4650_0_ffj", "__Z12op_4658_0_ffj", "__Z12op_4660_0_ffj", "__Z12op_4668_0_ffj", "__Z12op_4670_0_ffj", "__Z12op_4678_0_ffj", "__Z12op_4679_0_ffj", "__Z12op_4680_0_ffj", "__Z12op_4690_0_ffj", "__Z12op_4698_0_ffj", "__Z12op_46a0_0_ffj", "__Z12op_46a8_0_ffj", "__Z12op_46b0_0_ffj", "__Z12op_46b8_0_ffj", "__Z12op_46b9_0_ffj", "__Z12op_46c0_0_ffj", "__Z12op_46d0_0_ffj", "__Z12op_46d8_0_ffj", "__Z12op_46e0_0_ffj", "__Z12op_46e8_0_ffj", "__Z12op_46f0_0_ffj", "__Z12op_46f8_0_ffj", "__Z12op_46f9_0_ffj", "__Z12op_46fa_0_ffj", "__Z12op_46fb_0_ffj", "__Z12op_46fc_0_ffj", "__Z12op_4800_0_ffj", "__Z12op_4808_0_ffj", "__Z12op_4810_0_ffj", "__Z12op_4818_0_ffj", "__Z12op_4820_0_ffj", "__Z12op_4828_0_ffj", "__Z12op_4830_0_ffj", "__Z12op_4838_0_ffj", "__Z12op_4839_0_ffj", "__Z12op_4840_0_ffj", "__Z12op_4848_0_ffj", "__Z12op_4850_0_ffj", "__Z12op_4868_0_ffj", "__Z12op_4870_0_ffj", "__Z12op_4878_0_ffj", "__Z12op_4879_0_ffj", "__Z12op_487a_0_ffj", "__Z12op_487b_0_ffj", "__Z12op_4880_0_ffj", "__Z12op_4890_0_ffj", "__Z12op_48a0_0_ffj", "__Z12op_48a8_0_ffj", "__Z12op_48b0_0_ffj", "__Z12op_48b8_0_ffj", "__Z12op_48b9_0_ffj", "__Z12op_48c0_0_ffj", "__Z12op_48d0_0_ffj", "__Z12op_48e0_0_ffj", "__Z12op_48e8_0_ffj", "__Z12op_48f0_0_ffj", "__Z12op_48f8_0_ffj", "__Z12op_48f9_0_ffj", "__Z12op_49c0_0_ffj", "__Z12op_4a00_0_ffj", "__Z12op_4a10_0_ffj", "__Z12op_4a18_0_ffj", "__Z12op_4a20_0_ffj", "__Z12op_4a28_0_ffj", "__Z12op_4a30_0_ffj", "__Z12op_4a38_0_ffj", "__Z12op_4a39_0_ffj", "__Z12op_4a3a_0_ffj", "__Z12op_4a3b_0_ffj", "__Z12op_4a3c_0_ffj", "__Z12op_4a40_0_ffj", "__Z12op_4a48_0_ffj", "__Z12op_4a50_0_ffj", "__Z12op_4a58_0_ffj", "__Z12op_4a60_0_ffj", "__Z12op_4a68_0_ffj", "__Z12op_4a70_0_ffj", "__Z12op_4a78_0_ffj", "__Z12op_4a79_0_ffj", "__Z12op_4a7a_0_ffj", "__Z12op_4a7b_0_ffj", "__Z12op_4a7c_0_ffj", "__Z12op_4a80_0_ffj", "__Z12op_4a88_0_ffj", "__Z12op_4a90_0_ffj", "__Z12op_4a98_0_ffj", "__Z12op_4aa0_0_ffj", "__Z12op_4aa8_0_ffj", "__Z12op_4ab0_0_ffj", "__Z12op_4ab8_0_ffj", "__Z12op_4ab9_0_ffj", "__Z12op_4aba_0_ffj", "__Z12op_4abb_0_ffj", "__Z12op_4abc_0_ffj", "__Z12op_4ac0_0_ffj", "__Z12op_4ad0_0_ffj", "__Z12op_4ad8_0_ffj", "__Z12op_4ae0_0_ffj", "__Z12op_4ae8_0_ffj", "__Z12op_4af0_0_ffj", "__Z12op_4af8_0_ffj", "__Z12op_4af9_0_ffj", "__Z12op_4c00_0_ffj", "__Z12op_4c10_0_ffj", "__Z12op_4c18_0_ffj", "__Z12op_4c20_0_ffj", "__Z12op_4c28_0_ffj", "__Z12op_4c30_0_ffj", "__Z12op_4c38_0_ffj", "__Z12op_4c39_0_ffj", "__Z12op_4c3a_0_ffj", "__Z12op_4c3b_0_ffj", "__Z12op_4c3c_0_ffj", "__Z12op_4c40_0_ffj", "__Z12op_4c50_0_ffj", "__Z12op_4c58_0_ffj", "__Z12op_4c60_0_ffj", "__Z12op_4c68_0_ffj", "__Z12op_4c70_0_ffj", "__Z12op_4c78_0_ffj", "__Z12op_4c79_0_ffj", "__Z12op_4c7a_0_ffj", "__Z12op_4c7b_0_ffj", "__Z12op_4c7c_0_ffj", "__Z12op_4c90_0_ffj", "__Z12op_4c98_0_ffj", "__Z12op_4ca8_0_ffj", "__Z12op_4cb0_0_ffj", "__Z12op_4cb8_0_ffj", "__Z12op_4cb9_0_ffj", "__Z12op_4cba_0_ffj", "__Z12op_4cbb_0_ffj", "__Z12op_4cd0_0_ffj", "__Z12op_4cd8_0_ffj", "__Z12op_4ce8_0_ffj", "__Z12op_4cf0_0_ffj", "__Z12op_4cf8_0_ffj", "__Z12op_4cf9_0_ffj", "__Z12op_4cfa_0_ffj", "__Z12op_4cfb_0_ffj", "__Z12op_4e40_0_ffj", "__Z12op_4e50_0_ffj", "__Z12op_4e58_0_ffj", "__Z12op_4e60_0_ffj", "__Z12op_4e68_0_ffj", "__Z12op_4e70_0_ffj", "__Z12op_4e71_0_ffj", "__Z12op_4e72_0_ffj", "__Z12op_4e73_0_ffj", "__Z12op_4e74_0_ffj", "__Z12op_4e75_0_ffj", "__Z12op_4e76_0_ffj", "__Z12op_4e77_0_ffj", "__Z12op_4e7a_0_ffj", "__Z12op_4e7b_0_ffj", "__Z12op_4e90_0_ffj", "__Z12op_4ea8_0_ffj", "__Z12op_4eb0_0_ffj", "__Z12op_4eb8_0_ffj", "__Z12op_4eb9_0_ffj", "__Z12op_4eba_0_ffj", "__Z12op_4ebb_0_ffj", "__Z12op_4ed0_0_ffj", "__Z12op_4ee8_0_ffj", "__Z12op_4ef0_0_ffj", "__Z12op_4ef8_0_ffj", "__Z12op_4ef9_0_ffj", "__Z12op_4efa_0_ffj", "__Z12op_4efb_0_ffj", "__Z12op_5000_0_ffj", "__Z12op_5010_0_ffj", "__Z12op_5018_0_ffj", "__Z12op_5020_0_ffj", "__Z12op_5028_0_ffj", "__Z12op_5030_0_ffj", "__Z12op_5038_0_ffj", "__Z12op_5039_0_ffj", "__Z12op_5040_0_ffj", "__Z12op_5048_0_ffj", "__Z12op_5050_0_ffj", "__Z12op_5058_0_ffj", "__Z12op_5060_0_ffj", "__Z12op_5068_0_ffj", "__Z12op_5070_0_ffj", "__Z12op_5078_0_ffj", "__Z12op_5079_0_ffj", "__Z12op_5080_0_ffj", "__Z12op_5088_0_ffj", "__Z12op_5090_0_ffj", "__Z12op_5098_0_ffj", "__Z12op_50a0_0_ffj", "__Z12op_50a8_0_ffj", "__Z12op_50b0_0_ffj", "__Z12op_50b8_0_ffj", "__Z12op_50b9_0_ffj", "__Z12op_50c0_0_ffj", "__Z12op_50c8_0_ffj", "__Z12op_50d0_0_ffj", "__Z12op_50d8_0_ffj", "__Z12op_50e0_0_ffj", "__Z12op_50e8_0_ffj", "__Z12op_50f0_0_ffj", "__Z12op_50f8_0_ffj", "__Z12op_50f9_0_ffj", "__Z12op_50fa_0_ffj", "__Z12op_50fb_0_ffj", "__Z12op_50fc_0_ffj", "__Z12op_5100_0_ffj", "__Z12op_5110_0_ffj", "__Z12op_5118_0_ffj", "__Z12op_5120_0_ffj", "__Z12op_5128_0_ffj", "__Z12op_5130_0_ffj", "__Z12op_5138_0_ffj", "__Z12op_5139_0_ffj", "__Z12op_5140_0_ffj", "__Z12op_5148_0_ffj", "__Z12op_5150_0_ffj", "__Z12op_5158_0_ffj", "__Z12op_5160_0_ffj", "__Z12op_5168_0_ffj", "__Z12op_5170_0_ffj", "__Z12op_5178_0_ffj", "__Z12op_5179_0_ffj", "__Z12op_5180_0_ffj", "__Z12op_5188_0_ffj", "__Z12op_5190_0_ffj", "__Z12op_5198_0_ffj", "__Z12op_51a0_0_ffj", "__Z12op_51a8_0_ffj", "__Z12op_51b0_0_ffj", "__Z12op_51b8_0_ffj", "__Z12op_51b9_0_ffj", "__Z12op_51c0_0_ffj", "__Z12op_51c8_0_ffj", "__Z12op_51d0_0_ffj", "__Z12op_51d8_0_ffj", "__Z12op_51e0_0_ffj", "__Z12op_51e8_0_ffj", "__Z12op_51f0_0_ffj", "__Z12op_51f8_0_ffj", "__Z12op_51f9_0_ffj", "__Z12op_51fa_0_ffj", "__Z12op_51fb_0_ffj", "__Z12op_51fc_0_ffj", "__Z12op_52c0_0_ffj", "__Z12op_52c8_0_ffj", "__Z12op_52d0_0_ffj", "__Z12op_52d8_0_ffj", "__Z12op_52e0_0_ffj", "__Z12op_52e8_0_ffj", "__Z12op_52f0_0_ffj", "__Z12op_52f8_0_ffj", "__Z12op_52f9_0_ffj", "__Z12op_52fa_0_ffj", "__Z12op_52fb_0_ffj", "__Z12op_52fc_0_ffj", "__Z12op_53c0_0_ffj", "__Z12op_53c8_0_ffj", "__Z12op_53d0_0_ffj", "__Z12op_53d8_0_ffj", "__Z12op_53e0_0_ffj", "__Z12op_53e8_0_ffj", "__Z12op_53f0_0_ffj", "__Z12op_53f8_0_ffj", "__Z12op_53f9_0_ffj", "__Z12op_53fa_0_ffj", "__Z12op_53fb_0_ffj", "__Z12op_53fc_0_ffj", "__Z12op_54c0_0_ffj", "__Z12op_54c8_0_ffj", "__Z12op_54d0_0_ffj", "__Z12op_54d8_0_ffj", "__Z12op_54e0_0_ffj", "__Z12op_54e8_0_ffj", "__Z12op_54f0_0_ffj", "__Z12op_54f8_0_ffj", "__Z12op_54f9_0_ffj", "__Z12op_54fa_0_ffj", "__Z12op_54fb_0_ffj", "__Z12op_54fc_0_ffj", "__Z12op_55c0_0_ffj", "__Z12op_55c8_0_ffj", "__Z12op_55d0_0_ffj", "__Z12op_55d8_0_ffj", "__Z12op_55e0_0_ffj", "__Z12op_55e8_0_ffj", "__Z12op_55f0_0_ffj", "__Z12op_55f8_0_ffj", "__Z12op_55f9_0_ffj", "__Z12op_55fa_0_ffj", "__Z12op_55fb_0_ffj", "__Z12op_55fc_0_ffj", "__Z12op_56c0_0_ffj", "__Z12op_56c8_0_ffj", "__Z12op_56d0_0_ffj", "__Z12op_56d8_0_ffj", "__Z12op_56e0_0_ffj", "__Z12op_56e8_0_ffj", "__Z12op_56f0_0_ffj", "__Z12op_56f8_0_ffj", "__Z12op_56f9_0_ffj", "__Z12op_56fa_0_ffj", "__Z12op_56fb_0_ffj", "__Z12op_56fc_0_ffj", "__Z12op_57c0_0_ffj", "__Z12op_57c8_0_ffj", "__Z12op_57d0_0_ffj", "__Z12op_57d8_0_ffj", "__Z12op_57e0_0_ffj", "__Z12op_57e8_0_ffj", "__Z12op_57f0_0_ffj", "__Z12op_57f8_0_ffj", "__Z12op_57f9_0_ffj", "__Z12op_57fa_0_ffj", "__Z12op_57fb_0_ffj", "__Z12op_57fc_0_ffj", "__Z12op_58c0_0_ffj", "__Z12op_58c8_0_ffj", "__Z12op_58d0_0_ffj", "__Z12op_58d8_0_ffj", "__Z12op_58e0_0_ffj", "__Z12op_58e8_0_ffj", "__Z12op_58f0_0_ffj", "__Z12op_58f8_0_ffj", "__Z12op_58f9_0_ffj", "__Z12op_58fa_0_ffj", "__Z12op_58fb_0_ffj", "__Z12op_58fc_0_ffj", "__Z12op_59c0_0_ffj", "__Z12op_59c8_0_ffj", "__Z12op_59d0_0_ffj", "__Z12op_59d8_0_ffj", "__Z12op_59e0_0_ffj", "__Z12op_59e8_0_ffj", "__Z12op_59f0_0_ffj", "__Z12op_59f8_0_ffj", "__Z12op_59f9_0_ffj", "__Z12op_59fa_0_ffj", "__Z12op_59fb_0_ffj", "__Z12op_59fc_0_ffj", "__Z12op_5ac0_0_ffj", "__Z12op_5ac8_0_ffj", "__Z12op_5ad0_0_ffj", "__Z12op_5ad8_0_ffj", "__Z12op_5ae0_0_ffj", "__Z12op_5ae8_0_ffj", "__Z12op_5af0_0_ffj", "__Z12op_5af8_0_ffj", "__Z12op_5af9_0_ffj", "__Z12op_5afa_0_ffj", "__Z12op_5afb_0_ffj", "__Z12op_5afc_0_ffj", "__Z12op_5bc0_0_ffj", "__Z12op_5bc8_0_ffj", "__Z12op_5bd0_0_ffj", "__Z12op_5bd8_0_ffj", "__Z12op_5be0_0_ffj", "__Z12op_5be8_0_ffj", "__Z12op_5bf0_0_ffj", "__Z12op_5bf8_0_ffj", "__Z12op_5bf9_0_ffj", "__Z12op_5bfa_0_ffj", "__Z12op_5bfb_0_ffj", "__Z12op_5bfc_0_ffj", "__Z12op_5cc0_0_ffj", "__Z12op_5cc8_0_ffj", "__Z12op_5cd0_0_ffj", "__Z12op_5cd8_0_ffj", "__Z12op_5ce0_0_ffj", "__Z12op_5ce8_0_ffj", "__Z12op_5cf0_0_ffj", "__Z12op_5cf8_0_ffj", "__Z12op_5cf9_0_ffj", "__Z12op_5cfa_0_ffj", "__Z12op_5cfb_0_ffj", "__Z12op_5cfc_0_ffj", "__Z12op_5dc0_0_ffj", "__Z12op_5dc8_0_ffj", "__Z12op_5dd0_0_ffj", "__Z12op_5dd8_0_ffj", "__Z12op_5de0_0_ffj", "__Z12op_5de8_0_ffj", "__Z12op_5df0_0_ffj", "__Z12op_5df8_0_ffj", "__Z12op_5df9_0_ffj", "__Z12op_5dfa_0_ffj", "__Z12op_5dfb_0_ffj", "__Z12op_5dfc_0_ffj", "__Z12op_5ec0_0_ffj", "__Z12op_5ec8_0_ffj", "__Z12op_5ed0_0_ffj", "__Z12op_5ed8_0_ffj", "__Z12op_5ee0_0_ffj", "__Z12op_5ee8_0_ffj", "__Z12op_5ef0_0_ffj", "__Z12op_5ef8_0_ffj", "__Z12op_5ef9_0_ffj", "__Z12op_5efa_0_ffj", "__Z12op_5efb_0_ffj", "__Z12op_5efc_0_ffj", "__Z12op_5fc0_0_ffj", "__Z12op_5fc8_0_ffj", "__Z12op_5fd0_0_ffj", "__Z12op_5fd8_0_ffj", "__Z12op_5fe0_0_ffj", "__Z12op_5fe8_0_ffj", "__Z12op_5ff0_0_ffj", "__Z12op_5ff8_0_ffj", "__Z12op_5ff9_0_ffj", "__Z12op_5ffa_0_ffj", "__Z12op_5ffb_0_ffj", "__Z12op_5ffc_0_ffj", "__Z12op_6000_0_ffj", "__Z12op_6001_0_ffj", "__Z12op_60ff_0_ffj", "__Z12op_6100_0_ffj", "__Z12op_6101_0_ffj", "__Z12op_61ff_0_ffj", "__Z12op_6200_0_ffj", "__Z12op_6201_0_ffj", "__Z12op_62ff_0_ffj", "__Z12op_6300_0_ffj", "__Z12op_6301_0_ffj", "__Z12op_63ff_0_ffj", "__Z12op_6400_0_ffj", "__Z12op_6401_0_ffj", "__Z12op_64ff_0_ffj", "__Z12op_6500_0_ffj", "__Z12op_6501_0_ffj", "__Z12op_65ff_0_ffj", "__Z12op_6600_0_ffj", "__Z12op_6601_0_ffj", "__Z12op_66ff_0_ffj", "__Z12op_6700_0_ffj", "__Z12op_6701_0_ffj", "__Z12op_67ff_0_ffj", "__Z12op_6800_0_ffj", "__Z12op_6801_0_ffj", "__Z12op_68ff_0_ffj", "__Z12op_6900_0_ffj", "__Z12op_6901_0_ffj", "__Z12op_69ff_0_ffj", "__Z12op_6a00_0_ffj", "__Z12op_6a01_0_ffj", "__Z12op_6aff_0_ffj", "__Z12op_6b00_0_ffj", "__Z12op_6b01_0_ffj", "__Z12op_6bff_0_ffj", "__Z12op_6c00_0_ffj", "__Z12op_6c01_0_ffj", "__Z12op_6cff_0_ffj", "__Z12op_6d00_0_ffj", "__Z12op_6d01_0_ffj", "__Z12op_6dff_0_ffj", "__Z12op_6e00_0_ffj", "__Z12op_6e01_0_ffj", "__Z12op_6eff_0_ffj", "__Z12op_6f00_0_ffj", "__Z12op_6f01_0_ffj", "__Z12op_6fff_0_ffj", "__Z12op_7000_0_ffj", "__Z12op_7100_0_ffj", "__Z12op_7101_0_ffj", "__Z12op_8000_0_ffj", "__Z12op_8010_0_ffj", "__Z12op_8018_0_ffj", "__Z12op_8020_0_ffj", "__Z12op_8028_0_ffj", "__Z12op_8030_0_ffj", "__Z12op_8038_0_ffj", "__Z12op_8039_0_ffj", "__Z12op_803a_0_ffj", "__Z12op_803b_0_ffj", "__Z12op_803c_0_ffj", "__Z12op_8040_0_ffj", "__Z12op_8050_0_ffj", "__Z12op_8058_0_ffj", "__Z12op_8060_0_ffj", "__Z12op_8068_0_ffj", "__Z12op_8070_0_ffj", "__Z12op_8078_0_ffj", "__Z12op_8079_0_ffj", "__Z12op_807a_0_ffj", "__Z12op_807b_0_ffj", "__Z12op_807c_0_ffj", "__Z12op_8080_0_ffj", "__Z12op_8090_0_ffj", "__Z12op_8098_0_ffj", "__Z12op_80a0_0_ffj", "__Z12op_80a8_0_ffj", "__Z12op_80b0_0_ffj", "__Z12op_80b8_0_ffj", "__Z12op_80b9_0_ffj", "__Z12op_80ba_0_ffj", "__Z12op_80bb_0_ffj", "__Z12op_80bc_0_ffj", "__Z12op_80c0_0_ffj", "__Z12op_80d0_0_ffj", "__Z12op_80d8_0_ffj", "__Z12op_80e0_0_ffj", "__Z12op_80e8_0_ffj", "__Z12op_80f0_0_ffj", "__Z12op_80f8_0_ffj", "__Z12op_80f9_0_ffj", "__Z12op_80fa_0_ffj", "__Z12op_80fb_0_ffj", "__Z12op_80fc_0_ffj", "__Z12op_8100_0_ffj", "__Z12op_8108_0_ffj", "__Z12op_8110_0_ffj", "__Z12op_8118_0_ffj", "__Z12op_8120_0_ffj", "__Z12op_8128_0_ffj", "__Z12op_8130_0_ffj", "__Z12op_8138_0_ffj", "__Z12op_8139_0_ffj", "__Z12op_8140_0_ffj", "__Z12op_8148_0_ffj", "__Z12op_8150_0_ffj", "__Z12op_8158_0_ffj", "__Z12op_8160_0_ffj", "__Z12op_8168_0_ffj", "__Z12op_8170_0_ffj", "__Z12op_8178_0_ffj", "__Z12op_8179_0_ffj", "__Z12op_8180_0_ffj", "__Z12op_8188_0_ffj", "__Z12op_8190_0_ffj", "__Z12op_8198_0_ffj", "__Z12op_81a0_0_ffj", "__Z12op_81a8_0_ffj", "__Z12op_81b0_0_ffj", "__Z12op_81b8_0_ffj", "__Z12op_81b9_0_ffj", "__Z12op_81c0_0_ffj", "__Z12op_81d0_0_ffj", "__Z12op_81d8_0_ffj", "__Z12op_81e0_0_ffj", "__Z12op_81e8_0_ffj", "__Z12op_81f0_0_ffj", "__Z12op_81f8_0_ffj", "__Z12op_81f9_0_ffj", "__Z12op_81fa_0_ffj", "__Z12op_81fb_0_ffj", "__Z12op_81fc_0_ffj", "__Z12op_9000_0_ffj", "__Z12op_9010_0_ffj", "__Z12op_9018_0_ffj", "__Z12op_9020_0_ffj", "__Z12op_9028_0_ffj", "__Z12op_9030_0_ffj", "__Z12op_9038_0_ffj", "__Z12op_9039_0_ffj", "__Z12op_903a_0_ffj", "__Z12op_903b_0_ffj", "__Z12op_903c_0_ffj", "__Z12op_9040_0_ffj", "__Z12op_9048_0_ffj", "__Z12op_9050_0_ffj", "__Z12op_9058_0_ffj", "__Z12op_9060_0_ffj", "__Z12op_9068_0_ffj", "__Z12op_9070_0_ffj", "__Z12op_9078_0_ffj", "__Z12op_9079_0_ffj", "__Z12op_907a_0_ffj", "__Z12op_907b_0_ffj", "__Z12op_907c_0_ffj", "__Z12op_9080_0_ffj", "__Z12op_9088_0_ffj", "__Z12op_9090_0_ffj", "__Z12op_9098_0_ffj", "__Z12op_90a0_0_ffj", "__Z12op_90a8_0_ffj", "__Z12op_90b0_0_ffj", "__Z12op_90b8_0_ffj", "__Z12op_90b9_0_ffj", "__Z12op_90ba_0_ffj", "__Z12op_90bb_0_ffj", "__Z12op_90bc_0_ffj", "__Z12op_90c0_0_ffj", "__Z12op_90c8_0_ffj", "__Z12op_90d0_0_ffj", "__Z12op_90d8_0_ffj", "__Z12op_90e0_0_ffj", "__Z12op_90e8_0_ffj", "__Z12op_90f0_0_ffj", "__Z12op_90f8_0_ffj", "__Z12op_90f9_0_ffj", "__Z12op_90fa_0_ffj", "__Z12op_90fb_0_ffj", "__Z12op_90fc_0_ffj", "__Z12op_9100_0_ffj", "__Z12op_9108_0_ffj", "__Z12op_9110_0_ffj", "__Z12op_9118_0_ffj", "__Z12op_9120_0_ffj", "__Z12op_9128_0_ffj", "__Z12op_9130_0_ffj", "__Z12op_9138_0_ffj", "__Z12op_9139_0_ffj", "__Z12op_9140_0_ffj", "__Z12op_9148_0_ffj", "__Z12op_9150_0_ffj", "__Z12op_9158_0_ffj", "__Z12op_9160_0_ffj", "__Z12op_9168_0_ffj", "__Z12op_9170_0_ffj", "__Z12op_9178_0_ffj", "__Z12op_9179_0_ffj", "__Z12op_9180_0_ffj", "__Z12op_9188_0_ffj", "__Z12op_9190_0_ffj", "__Z12op_9198_0_ffj", "__Z12op_91a0_0_ffj", "__Z12op_91a8_0_ffj", "__Z12op_91b0_0_ffj", "__Z12op_91b8_0_ffj", "__Z12op_91b9_0_ffj", "__Z12op_91c0_0_ffj", "__Z12op_91c8_0_ffj", "__Z12op_91d0_0_ffj", "__Z12op_91d8_0_ffj", "__Z12op_91e0_0_ffj", "__Z12op_91e8_0_ffj", "__Z12op_91f0_0_ffj", "__Z12op_91f8_0_ffj", "__Z12op_91f9_0_ffj", "__Z12op_91fa_0_ffj", "__Z12op_91fb_0_ffj", "__Z12op_91fc_0_ffj", "__Z12op_b000_0_ffj", "__Z12op_b010_0_ffj", "__Z12op_b018_0_ffj", "__Z12op_b020_0_ffj", "__Z12op_b028_0_ffj", "__Z12op_b030_0_ffj", "__Z12op_b038_0_ffj", "__Z12op_b039_0_ffj", "__Z12op_b03a_0_ffj", "__Z12op_b03b_0_ffj", "__Z12op_b03c_0_ffj", "__Z12op_b040_0_ffj", "__Z12op_b048_0_ffj", "__Z12op_b050_0_ffj", "__Z12op_b058_0_ffj", "__Z12op_b060_0_ffj", "__Z12op_b068_0_ffj", "__Z12op_b070_0_ffj", "__Z12op_b078_0_ffj", "__Z12op_b079_0_ffj", "__Z12op_b07a_0_ffj", "__Z12op_b07b_0_ffj", "__Z12op_b07c_0_ffj", "__Z12op_b080_0_ffj", "__Z12op_b088_0_ffj", "__Z12op_b090_0_ffj", "__Z12op_b098_0_ffj", "__Z12op_b0a0_0_ffj", "__Z12op_b0a8_0_ffj", "__Z12op_b0b0_0_ffj", "__Z12op_b0b8_0_ffj", "__Z12op_b0b9_0_ffj", "__Z12op_b0ba_0_ffj", "__Z12op_b0bb_0_ffj", "__Z12op_b0bc_0_ffj", "__Z12op_b0c0_0_ffj", "__Z12op_b0c8_0_ffj", "__Z12op_b0d0_0_ffj", "__Z12op_b0d8_0_ffj", "__Z12op_b0e0_0_ffj", "__Z12op_b0e8_0_ffj", "__Z12op_b0f0_0_ffj", "__Z12op_b0f8_0_ffj", "__Z12op_b0f9_0_ffj", "__Z12op_b0fa_0_ffj", "__Z12op_b0fb_0_ffj", "__Z12op_b0fc_0_ffj", "__Z12op_b100_0_ffj", "__Z12op_b108_0_ffj", "__Z12op_b110_0_ffj", "__Z12op_b118_0_ffj", "__Z12op_b120_0_ffj", "__Z12op_b128_0_ffj", "__Z12op_b130_0_ffj", "__Z12op_b138_0_ffj", "__Z12op_b139_0_ffj", "__Z12op_b140_0_ffj", "__Z12op_b148_0_ffj", "__Z12op_b150_0_ffj", "__Z12op_b158_0_ffj", "__Z12op_b160_0_ffj", "__Z12op_b168_0_ffj", "__Z12op_b170_0_ffj", "__Z12op_b178_0_ffj", "__Z12op_b179_0_ffj", "__Z12op_b180_0_ffj", "__Z12op_b188_0_ffj", "__Z12op_b190_0_ffj", "__Z12op_b198_0_ffj", "__Z12op_b1a0_0_ffj", "__Z12op_b1a8_0_ffj", "__Z12op_b1b0_0_ffj", "__Z12op_b1b8_0_ffj", "__Z12op_b1b9_0_ffj", "__Z12op_b1c0_0_ffj", "__Z12op_b1c8_0_ffj", "__Z12op_b1d0_0_ffj", "__Z12op_b1d8_0_ffj", "__Z12op_b1e0_0_ffj", "__Z12op_b1e8_0_ffj", "__Z12op_b1f0_0_ffj", "__Z12op_b1f8_0_ffj", "__Z12op_b1f9_0_ffj", "__Z12op_b1fa_0_ffj", "__Z12op_b1fb_0_ffj", "__Z12op_b1fc_0_ffj", "__Z12op_c000_0_ffj", "__Z12op_c010_0_ffj", "__Z12op_c018_0_ffj", "__Z12op_c020_0_ffj", "__Z12op_c028_0_ffj", "__Z12op_c030_0_ffj", "__Z12op_c038_0_ffj", "__Z12op_c039_0_ffj", "__Z12op_c03a_0_ffj", "__Z12op_c03b_0_ffj", "__Z12op_c03c_0_ffj", "__Z12op_c040_0_ffj", "__Z12op_c050_0_ffj", "__Z12op_c058_0_ffj", "__Z12op_c060_0_ffj", "__Z12op_c068_0_ffj", "__Z12op_c070_0_ffj", "__Z12op_c078_0_ffj", "__Z12op_c079_0_ffj", "__Z12op_c07a_0_ffj", "__Z12op_c07b_0_ffj", "__Z12op_c07c_0_ffj", "__Z12op_c080_0_ffj", "__Z12op_c090_0_ffj", "__Z12op_c098_0_ffj", "__Z12op_c0a0_0_ffj", "__Z12op_c0a8_0_ffj", "__Z12op_c0b0_0_ffj", "__Z12op_c0b8_0_ffj", "__Z12op_c0b9_0_ffj", "__Z12op_c0ba_0_ffj", "__Z12op_c0bb_0_ffj", "__Z12op_c0bc_0_ffj", "__Z12op_c0c0_0_ffj", "__Z12op_c0d0_0_ffj", "__Z12op_c0d8_0_ffj", "__Z12op_c0e0_0_ffj", "__Z12op_c0e8_0_ffj", "__Z12op_c0f0_0_ffj", "__Z12op_c0f8_0_ffj", "__Z12op_c0f9_0_ffj", "__Z12op_c0fa_0_ffj", "__Z12op_c0fb_0_ffj", "__Z12op_c0fc_0_ffj", "__Z12op_c100_0_ffj", "__Z12op_c108_0_ffj", "__Z12op_c110_0_ffj", "__Z12op_c118_0_ffj", "__Z12op_c120_0_ffj", "__Z12op_c128_0_ffj", "__Z12op_c130_0_ffj", "__Z12op_c138_0_ffj", "__Z12op_c139_0_ffj", "__Z12op_c140_0_ffj", "__Z12op_c148_0_ffj", "__Z12op_c150_0_ffj", "__Z12op_c158_0_ffj", "__Z12op_c160_0_ffj", "__Z12op_c168_0_ffj", "__Z12op_c170_0_ffj", "__Z12op_c178_0_ffj", "__Z12op_c179_0_ffj", "__Z12op_c188_0_ffj", "__Z12op_c190_0_ffj", "__Z12op_c198_0_ffj", "__Z12op_c1a0_0_ffj", "__Z12op_c1a8_0_ffj", "__Z12op_c1b0_0_ffj", "__Z12op_c1b8_0_ffj", "__Z12op_c1b9_0_ffj", "__Z12op_c1c0_0_ffj", "__Z12op_c1d0_0_ffj", "__Z12op_c1d8_0_ffj", "__Z12op_c1e0_0_ffj", "__Z12op_c1e8_0_ffj", "__Z12op_c1f0_0_ffj", "__Z12op_c1f8_0_ffj", "__Z12op_c1f9_0_ffj", "__Z12op_c1fa_0_ffj", "__Z12op_c1fb_0_ffj", "__Z12op_c1fc_0_ffj", "__Z12op_d000_0_ffj", "__Z12op_d010_0_ffj", "__Z12op_d018_0_ffj", "__Z12op_d020_0_ffj", "__Z12op_d028_0_ffj", "__Z12op_d030_0_ffj", "__Z12op_d038_0_ffj", "__Z12op_d039_0_ffj", "__Z12op_d03a_0_ffj", "__Z12op_d03b_0_ffj", "__Z12op_d03c_0_ffj", "__Z12op_d040_0_ffj", "__Z12op_d048_0_ffj", "__Z12op_d050_0_ffj", "__Z12op_d058_0_ffj", "__Z12op_d060_0_ffj", "__Z12op_d068_0_ffj", "__Z12op_d070_0_ffj", "__Z12op_d078_0_ffj", "__Z12op_d079_0_ffj", "__Z12op_d07a_0_ffj", "__Z12op_d07b_0_ffj", "__Z12op_d07c_0_ffj", "__Z12op_d080_0_ffj", "__Z12op_d088_0_ffj", "__Z12op_d090_0_ffj", "__Z12op_d098_0_ffj", "__Z12op_d0a0_0_ffj", "__Z12op_d0a8_0_ffj", "__Z12op_d0b0_0_ffj", "__Z12op_d0b8_0_ffj", "__Z12op_d0b9_0_ffj", "__Z12op_d0ba_0_ffj", "__Z12op_d0bb_0_ffj", "__Z12op_d0bc_0_ffj", "__Z12op_d0c0_0_ffj", "__Z12op_d0c8_0_ffj", "__Z12op_d0d0_0_ffj", "__Z12op_d0d8_0_ffj", "__Z12op_d0e0_0_ffj", "__Z12op_d0e8_0_ffj", "__Z12op_d0f0_0_ffj", "__Z12op_d0f8_0_ffj", "__Z12op_d0f9_0_ffj", "__Z12op_d0fa_0_ffj", "__Z12op_d0fb_0_ffj", "__Z12op_d0fc_0_ffj", "__Z12op_d100_0_ffj", "__Z12op_d108_0_ffj", "__Z12op_d110_0_ffj", "__Z12op_d118_0_ffj", "__Z12op_d120_0_ffj", "__Z12op_d128_0_ffj", "__Z12op_d130_0_ffj", "__Z12op_d138_0_ffj", "__Z12op_d139_0_ffj", "__Z12op_d140_0_ffj", "__Z12op_d148_0_ffj", "__Z12op_d150_0_ffj", "__Z12op_d158_0_ffj", "__Z12op_d160_0_ffj", "__Z12op_d168_0_ffj", "__Z12op_d170_0_ffj", "__Z12op_d178_0_ffj", "__Z12op_d179_0_ffj", "__Z12op_d180_0_ffj", "__Z12op_d188_0_ffj", "__Z12op_d190_0_ffj", "__Z12op_d198_0_ffj", "__Z12op_d1a0_0_ffj", "__Z12op_d1a8_0_ffj", "__Z12op_d1b0_0_ffj", "__Z12op_d1b8_0_ffj", "__Z12op_d1b9_0_ffj", "__Z12op_d1c0_0_ffj", "__Z12op_d1c8_0_ffj", "__Z12op_d1d0_0_ffj", "__Z12op_d1d8_0_ffj", "__Z12op_d1e0_0_ffj", "__Z12op_d1e8_0_ffj", "__Z12op_d1f0_0_ffj", "__Z12op_d1f8_0_ffj", "__Z12op_d1f9_0_ffj", "__Z12op_d1fa_0_ffj", "__Z12op_d1fb_0_ffj", "__Z12op_d1fc_0_ffj", "__Z12op_e000_0_ffj", "__Z12op_e008_0_ffj", "__Z12op_e010_0_ffj", "__Z12op_e018_0_ffj", "__Z12op_e020_0_ffj", "__Z12op_e028_0_ffj", "__Z12op_e030_0_ffj", "__Z12op_e038_0_ffj", "__Z12op_e040_0_ffj", "__Z12op_e048_0_ffj", "__Z12op_e050_0_ffj", "__Z12op_e058_0_ffj", "__Z12op_e060_0_ffj", "__Z12op_e068_0_ffj", "__Z12op_e070_0_ffj", "__Z12op_e078_0_ffj", "__Z12op_e080_0_ffj", "__Z12op_e088_0_ffj", "__Z12op_e090_0_ffj", "__Z12op_e098_0_ffj", "__Z12op_e0a0_0_ffj", "__Z12op_e0a8_0_ffj", "__Z12op_e0b0_0_ffj", "__Z12op_e0b8_0_ffj", "__Z12op_e0d0_0_ffj", "__Z12op_e0d8_0_ffj", "__Z12op_e0e0_0_ffj", "__Z12op_e0e8_0_ffj", "__Z12op_e0f0_0_ffj", "__Z12op_e0f8_0_ffj", "__Z12op_e0f9_0_ffj", "__Z12op_e100_0_ffj", "__Z12op_e108_0_ffj", "__Z12op_e110_0_ffj", "__Z12op_e118_0_ffj", "__Z12op_e120_0_ffj", "__Z12op_e128_0_ffj", "__Z12op_e130_0_ffj", "__Z12op_e138_0_ffj", "__Z12op_e140_0_ffj", "__Z12op_e148_0_ffj", "__Z12op_e150_0_ffj", "__Z12op_e158_0_ffj", "__Z12op_e160_0_ffj", "__Z12op_e168_0_ffj", "__Z12op_e170_0_ffj", "__Z12op_e178_0_ffj", "__Z12op_e180_0_ffj", "__Z12op_e188_0_ffj", "__Z12op_e190_0_ffj", "__Z12op_e198_0_ffj", "__Z12op_e1a0_0_ffj", "__Z12op_e1a8_0_ffj", "__Z12op_e1b0_0_ffj", "__Z12op_e1b8_0_ffj", "__Z12op_e1d0_0_ffj", "__Z12op_e1d8_0_ffj", "__Z12op_e1e0_0_ffj", "__Z12op_e1e8_0_ffj", "__Z12op_e1f0_0_ffj", "__Z12op_e1f8_0_ffj", "__Z12op_e1f9_0_ffj", "__Z12op_e2d0_0_ffj", "__Z12op_e2d8_0_ffj", "__Z12op_e2e0_0_ffj", "__Z12op_e2e8_0_ffj", "__Z12op_e2f0_0_ffj", "__Z12op_e2f8_0_ffj", "__Z12op_e2f9_0_ffj", "__Z12op_e3d0_0_ffj", "__Z12op_e3d8_0_ffj", "__Z12op_e3e0_0_ffj", "__Z12op_e3e8_0_ffj", "__Z12op_e3f0_0_ffj", "__Z12op_e3f8_0_ffj", "__Z12op_e3f9_0_ffj", "__Z12op_e4d0_0_ffj", "__Z12op_e4d8_0_ffj", "__Z12op_e4e0_0_ffj", "__Z12op_e4e8_0_ffj", "__Z12op_e4f0_0_ffj", "__Z12op_e4f8_0_ffj", "__Z12op_e4f9_0_ffj", "__Z12op_e5d0_0_ffj", "__Z12op_e5d8_0_ffj", "__Z12op_e5e0_0_ffj", "__Z12op_e5e8_0_ffj", "__Z12op_e5f0_0_ffj", "__Z12op_e5f8_0_ffj", "__Z12op_e5f9_0_ffj", "__Z12op_e6d0_0_ffj", "__Z12op_e6d8_0_ffj", "__Z12op_e6e0_0_ffj", "__Z12op_e6e8_0_ffj", "__Z12op_e6f0_0_ffj", "__Z12op_e6f8_0_ffj", "__Z12op_e6f9_0_ffj", "__Z12op_e7d0_0_ffj", "__Z12op_e7d8_0_ffj", "__Z12op_e7e0_0_ffj", "__Z12op_e7e8_0_ffj", "__Z12op_e7f0_0_ffj", "__Z12op_e7f8_0_ffj", "__Z12op_e7f9_0_ffj", "__Z12op_e8c0_0_ffj", "__Z12op_e8d0_0_ffj", "__Z12op_e8e8_0_ffj", "__Z12op_e8f0_0_ffj", "__Z12op_e8f8_0_ffj", "__Z12op_e8f9_0_ffj", "__Z12op_e8fa_0_ffj", "__Z12op_e8fb_0_ffj", "__Z12op_e9c0_0_ffj", "__Z12op_e9d0_0_ffj", "__Z12op_e9e8_0_ffj", "__Z12op_e9f0_0_ffj", "__Z12op_e9f8_0_ffj", "__Z12op_e9f9_0_ffj", "__Z12op_e9fa_0_ffj", "__Z12op_e9fb_0_ffj", "__Z12op_eac0_0_ffj", "__Z12op_ead0_0_ffj", "__Z12op_eae8_0_ffj", "__Z12op_eaf0_0_ffj", "__Z12op_eaf8_0_ffj", "__Z12op_eaf9_0_ffj", "__Z12op_ebc0_0_ffj", "__Z12op_ebd0_0_ffj", "__Z12op_ebe8_0_ffj", "__Z12op_ebf0_0_ffj", "__Z12op_ebf8_0_ffj", "__Z12op_ebf9_0_ffj", "__Z12op_ebfa_0_ffj", "__Z12op_ebfb_0_ffj", "__Z12op_ecc0_0_ffj", "__Z12op_ecd0_0_ffj", "__Z12op_ece8_0_ffj", "__Z12op_ecf0_0_ffj", "__Z12op_ecf8_0_ffj", "__Z12op_ecf9_0_ffj", "__Z12op_edc0_0_ffj", "__Z12op_edd0_0_ffj", "__Z12op_ede8_0_ffj", "__Z12op_edf0_0_ffj", "__Z12op_edf8_0_ffj", "__Z12op_edf9_0_ffj", "__Z12op_edfa_0_ffj", "__Z12op_edfb_0_ffj", "__Z12op_eec0_0_ffj", "__Z12op_eed0_0_ffj", "__Z12op_eee8_0_ffj", "__Z12op_eef0_0_ffj", "__Z12op_eef8_0_ffj", "__Z12op_eef9_0_ffj", "__Z12op_efc0_0_ffj", "__Z12op_efd0_0_ffj", "__Z12op_efe8_0_ffj", "__Z12op_eff0_0_ffj", "__Z12op_eff8_0_ffj", "__Z12op_eff9_0_ffj", "__Z12op_f200_0_ffj", "__Z12op_f208_0_ffj", "__Z12op_f210_0_ffj", "__Z12op_f218_0_ffj", "__Z12op_f220_0_ffj", "__Z12op_f228_0_ffj", "__Z12op_f230_0_ffj", "__Z12op_f238_0_ffj", "__Z12op_f239_0_ffj", "__Z12op_f23a_0_ffj", "__Z12op_f23b_0_ffj", "__Z12op_f23c_0_ffj", "__Z12op_f240_0_ffj", "__Z12op_f248_0_ffj", "__Z12op_f250_0_ffj", "__Z12op_f258_0_ffj", "__Z12op_f260_0_ffj", "__Z12op_f268_0_ffj", "__Z12op_f270_0_ffj", "__Z12op_f278_0_ffj", "__Z12op_f279_0_ffj", "__Z12op_f27a_0_ffj", "__Z12op_f27b_0_ffj", "__Z12op_f27c_0_ffj", "__Z12op_f280_0_ffj", "__Z12op_f2c0_0_ffj", "__Z12op_f310_0_ffj", "__Z12op_f320_0_ffj", "__Z12op_f328_0_ffj", "__Z12op_f330_0_ffj", "__Z12op_f338_0_ffj", "__Z12op_f339_0_ffj", "__Z12op_f350_0_ffj", "__Z12op_f358_0_ffj", "__Z12op_f368_0_ffj", "__Z12op_f370_0_ffj", "__Z12op_f378_0_ffj", "__Z12op_f379_0_ffj", "__Z12op_f37a_0_ffj", "__Z12op_f37b_0_ffj", "__Z12op_f408_0_ffj", "__Z12op_f410_0_ffj", "__Z12op_f418_0_ffj", "__Z12op_f419_0_ffj", "__Z12op_f41a_0_ffj", "__Z12op_f41b_0_ffj", "__Z12op_f41c_0_ffj", "__Z12op_f41d_0_ffj", "__Z12op_f41e_0_ffj", "__Z12op_f41f_0_ffj", "__Z12op_f428_0_ffj", "__Z12op_f430_0_ffj", "__Z12op_f438_0_ffj", "__Z12op_f439_0_ffj", "__Z12op_f43a_0_ffj", "__Z12op_f43b_0_ffj", "__Z12op_f43c_0_ffj", "__Z12op_f43d_0_ffj", "__Z12op_f43e_0_ffj", "__Z12op_f43f_0_ffj", "__Z12op_f500_0_ffj", "__Z12op_f600_0_ffj", "__Z12op_f608_0_ffj", "__Z12op_f610_0_ffj", "__Z12op_f618_0_ffj", "__Z12op_f620_0_ffj", "__Z12op_4800_1_ffj", "__Z12op_4810_1_ffj", "__Z12op_4818_1_ffj", "__Z12op_4820_1_ffj", "__Z12op_4828_1_ffj", "__Z12op_4830_1_ffj", "__Z12op_4838_1_ffj", "__Z12op_4839_1_ffj", "__Z12op_8100_1_ffj", "__Z12op_8108_1_ffj", "__Z12op_c100_1_ffj", "__Z12op_c108_1_ffj", "__Z10op_30_3_ffj", "__Z10op_70_3_ffj", "__Z10op_b0_3_ffj", "__Z11op_130_3_ffj", "__Z11op_13b_3_ffj", "__Z11op_170_3_ffj", "__Z11op_17b_3_ffj", "__Z11op_1b0_3_ffj", "__Z11op_1bb_3_ffj", "__Z11op_1f0_3_ffj", "__Z11op_1fb_3_ffj", "__Z11op_230_3_ffj", "__Z11op_270_3_ffj", "__Z11op_2b0_3_ffj", "__Z11op_430_3_ffj", "__Z11op_470_3_ffj", "__Z11op_4b0_3_ffj", "__Z11op_630_3_ffj", "__Z11op_670_3_ffj", "__Z11op_6b0_3_ffj", "__Z11op_830_3_ffj", "__Z11op_83b_3_ffj", "__Z11op_870_3_ffj", "__Z11op_87b_3_ffj", "__Z11op_8b0_3_ffj", "__Z11op_8bb_3_ffj", "__Z11op_8f0_3_ffj", "__Z11op_8fb_3_ffj", "__Z11op_a30_3_ffj", "__Z11op_a70_3_ffj", "__Z11op_ab0_3_ffj", "__Z11op_c30_3_ffj", "__Z11op_c3b_3_ffj", "__Z11op_c70_3_ffj", "__Z11op_c7b_3_ffj", "__Z11op_cb0_3_ffj", "__Z11op_cbb_3_ffj", "__Z12op_1030_3_ffj", "__Z12op_103b_3_ffj", "__Z12op_10b0_3_ffj", "__Z12op_10bb_3_ffj", "__Z12op_10f0_3_ffj", "__Z12op_10fb_3_ffj", "__Z12op_1130_3_ffj", "__Z12op_113b_3_ffj", "__Z12op_1170_3_ffj", "__Z12op_117b_3_ffj", "__Z12op_1180_3_ffj", "__Z12op_1190_3_ffj", "__Z12op_1198_3_ffj", "__Z12op_11a0_3_ffj", "__Z12op_11a8_3_ffj", "__Z12op_11b0_3_ffj", "__Z12op_11b8_3_ffj", "__Z12op_11b9_3_ffj", "__Z12op_11ba_3_ffj", "__Z12op_11bb_3_ffj", "__Z12op_11bc_3_ffj", "__Z12op_11f0_3_ffj", "__Z12op_11fb_3_ffj", "__Z12op_13f0_3_ffj", "__Z12op_13fb_3_ffj", "__Z12op_2030_3_ffj", "__Z12op_203b_3_ffj", "__Z12op_2070_3_ffj", "__Z12op_207b_3_ffj", "__Z12op_20b0_3_ffj", "__Z12op_20bb_3_ffj", "__Z12op_20f0_3_ffj", "__Z12op_20fb_3_ffj", "__Z12op_2130_3_ffj", "__Z12op_213b_3_ffj", "__Z12op_2170_3_ffj", "__Z12op_217b_3_ffj", "__Z12op_2180_3_ffj", "__Z12op_2188_3_ffj", "__Z12op_2190_3_ffj", "__Z12op_2198_3_ffj", "__Z12op_21a0_3_ffj", "__Z12op_21a8_3_ffj", "__Z12op_21b0_3_ffj", "__Z12op_21b8_3_ffj", "__Z12op_21b9_3_ffj", "__Z12op_21ba_3_ffj", "__Z12op_21bb_3_ffj", "__Z12op_21bc_3_ffj", "__Z12op_21f0_3_ffj", "__Z12op_21fb_3_ffj", "__Z12op_23f0_3_ffj", "__Z12op_23fb_3_ffj", "__Z12op_3030_3_ffj", "__Z12op_303b_3_ffj", "__Z12op_3070_3_ffj", "__Z12op_307b_3_ffj", "__Z12op_30b0_3_ffj", "__Z12op_30bb_3_ffj", "__Z12op_30f0_3_ffj", "__Z12op_30fb_3_ffj", "__Z12op_3130_3_ffj", "__Z12op_313b_3_ffj", "__Z12op_3170_3_ffj", "__Z12op_317b_3_ffj", "__Z12op_3180_3_ffj", "__Z12op_3188_3_ffj", "__Z12op_3190_3_ffj", "__Z12op_3198_3_ffj", "__Z12op_31a0_3_ffj", "__Z12op_31a8_3_ffj", "__Z12op_31b0_3_ffj", "__Z12op_31b8_3_ffj", "__Z12op_31b9_3_ffj", "__Z12op_31ba_3_ffj", "__Z12op_31bb_3_ffj", "__Z12op_31bc_3_ffj", "__Z12op_31f0_3_ffj", "__Z12op_31fb_3_ffj", "__Z12op_33f0_3_ffj", "__Z12op_33fb_3_ffj", "__Z12op_4030_3_ffj", "__Z12op_4070_3_ffj", "__Z12op_40b0_3_ffj", "__Z12op_40f0_3_ffj", "__Z12op_4130_3_ffj", "__Z12op_413b_3_ffj", "__Z12op_41b0_3_ffj", "__Z12op_41bb_3_ffj", "__Z12op_41f0_3_ffj", "__Z12op_41fb_3_ffj", "__Z12op_4230_3_ffj", "__Z12op_4270_3_ffj", "__Z12op_42b0_3_ffj", "__Z12op_42f0_3_ffj", "__Z12op_4430_3_ffj", "__Z12op_4470_3_ffj", "__Z12op_44b0_3_ffj", "__Z12op_44f0_3_ffj", "__Z12op_44fb_3_ffj", "__Z12op_4630_3_ffj", "__Z12op_4670_3_ffj", "__Z12op_46b0_3_ffj", "__Z12op_46f0_3_ffj", "__Z12op_46fb_3_ffj", "__Z12op_4830_3_ffj", "__Z12op_4870_3_ffj", "__Z12op_487b_3_ffj", "__Z12op_48b0_3_ffj", "__Z12op_48f0_3_ffj", "__Z12op_4a30_3_ffj", "__Z12op_4a3b_3_ffj", "__Z12op_4a70_3_ffj", "__Z12op_4a7b_3_ffj", "__Z12op_4ab0_3_ffj", "__Z12op_4abb_3_ffj", "__Z12op_4af0_3_ffj", "__Z12op_4cb0_3_ffj", "__Z12op_4cbb_3_ffj", "__Z12op_4cf0_3_ffj", "__Z12op_4cfb_3_ffj", "__Z12op_4eb0_3_ffj", "__Z12op_4ebb_3_ffj", "__Z12op_4ef0_3_ffj", "__Z12op_4efb_3_ffj", "__Z12op_5030_3_ffj", "__Z12op_5070_3_ffj", "__Z12op_50b0_3_ffj", "__Z12op_50f0_3_ffj", "__Z12op_5130_3_ffj", "__Z12op_5170_3_ffj", "__Z12op_51b0_3_ffj", "__Z12op_51f0_3_ffj", "__Z12op_52f0_3_ffj", "__Z12op_53f0_3_ffj", "__Z12op_54f0_3_ffj", "__Z12op_55f0_3_ffj", "__Z12op_56f0_3_ffj", "__Z12op_57f0_3_ffj", "__Z12op_58f0_3_ffj", "__Z12op_59f0_3_ffj", "__Z12op_5af0_3_ffj", "__Z12op_5bf0_3_ffj", "__Z12op_5cf0_3_ffj", "__Z12op_5df0_3_ffj", "__Z12op_5ef0_3_ffj", "__Z12op_5ff0_3_ffj", "__Z12op_60ff_3_ffj", "__Z12op_62ff_3_ffj", "__Z12op_63ff_3_ffj", "__Z12op_64ff_3_ffj", "__Z12op_65ff_3_ffj", "__Z12op_66ff_3_ffj", "__Z12op_67ff_3_ffj", "__Z12op_68ff_3_ffj", "__Z12op_69ff_3_ffj", "__Z12op_6aff_3_ffj", "__Z12op_6bff_3_ffj", "__Z12op_6cff_3_ffj", "__Z12op_6dff_3_ffj", "__Z12op_6eff_3_ffj", "__Z12op_6fff_3_ffj", "__Z12op_8030_3_ffj", "__Z12op_803b_3_ffj", "__Z12op_8070_3_ffj", "__Z12op_807b_3_ffj", "__Z12op_80b0_3_ffj", "__Z12op_80bb_3_ffj", "__Z12op_80f0_3_ffj", "__Z12op_80fb_3_ffj", "__Z12op_8130_3_ffj", "__Z12op_8170_3_ffj", "__Z12op_81b0_3_ffj", "__Z12op_81f0_3_ffj", "__Z12op_81fb_3_ffj", "__Z12op_9030_3_ffj", "__Z12op_903b_3_ffj", "__Z12op_9070_3_ffj", "__Z12op_907b_3_ffj", "__Z12op_90b0_3_ffj", "__Z12op_90bb_3_ffj", "__Z12op_90f0_3_ffj", "__Z12op_90fb_3_ffj", "__Z12op_9130_3_ffj", "__Z12op_9170_3_ffj", "__Z12op_91b0_3_ffj", "__Z12op_91f0_3_ffj", "__Z12op_91fb_3_ffj", "__Z12op_b030_3_ffj", "__Z12op_b03b_3_ffj", "__Z12op_b070_3_ffj", "__Z12op_b07b_3_ffj", "__Z12op_b0b0_3_ffj", "__Z12op_b0bb_3_ffj", "__Z12op_b0f0_3_ffj", "__Z12op_b0fb_3_ffj", "__Z12op_b130_3_ffj", "__Z12op_b170_3_ffj", "__Z12op_b1b0_3_ffj", "__Z12op_b1f0_3_ffj", "__Z12op_b1fb_3_ffj", "__Z12op_c030_3_ffj", "__Z12op_c03b_3_ffj", "__Z12op_c070_3_ffj", "__Z12op_c07b_3_ffj", "__Z12op_c0b0_3_ffj", "__Z12op_c0bb_3_ffj", "__Z12op_c0f0_3_ffj", "__Z12op_c0fb_3_ffj", "__Z12op_c130_3_ffj", "__Z12op_c170_3_ffj", "__Z12op_c1b0_3_ffj", "__Z12op_c1f0_3_ffj", "__Z12op_c1fb_3_ffj", "__Z12op_d030_3_ffj", "__Z12op_d03b_3_ffj", "__Z12op_d070_3_ffj", "__Z12op_d07b_3_ffj", "__Z12op_d0b0_3_ffj", "__Z12op_d0bb_3_ffj", "__Z12op_d0f0_3_ffj", "__Z12op_d0fb_3_ffj", "__Z12op_d130_3_ffj", "__Z12op_d170_3_ffj", "__Z12op_d1b0_3_ffj", "__Z12op_d1f0_3_ffj", "__Z12op_d1fb_3_ffj", "__Z12op_e0f0_3_ffj", "__Z12op_e1f0_3_ffj", "__Z12op_e2f0_3_ffj", "__Z12op_e3f0_3_ffj", "__Z12op_e4f0_3_ffj", "__Z12op_e5f0_3_ffj", "__Z12op_e6f0_3_ffj", "__Z12op_e7f0_3_ffj", "__Z12op_40c0_4_ffj", "__Z12op_40d0_4_ffj", "__Z12op_40d8_4_ffj", "__Z12op_40e0_4_ffj", "__Z12op_40e8_4_ffj", "__Z12op_40f0_4_ffj", "__Z12op_40f8_4_ffj", "__Z12op_40f9_4_ffj", "__Z12op_4e73_4_ffj", "0", "0", "0", "0", "0", "0", "__ZN10__cxxabiv116__shim_type_infoD2Ev", "__ZN10__cxxabiv117__class_type_infoD0Ev", "__ZNK10__cxxabiv116__shim_type_info5noop1Ev", "__ZNK10__cxxabiv116__shim_type_info5noop2Ev", "0", "0", "0", "0", "__ZN10__cxxabiv120__si_class_type_infoD0Ev", "0", "0", "0", "__ZNSt11logic_errorD2Ev", "__ZNSt11logic_errorD0Ev", "0", "__ZNSt12length_errorD0Ev", "0", "0", "0", "0", "__Z9op_illg_1j", "0", "0", "0", "__ZN10__cxxabiv112_GLOBAL__N_19destruct_EPv", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_vii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi44EE4FreeEPv", "0", "0", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi48EE4FreeEPv", "0", "0", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi36EE4FreeEPv", "0", "0", "0", "0", "0", "__ZN8tinyxml28MemPoolTILi52EE4FreeEPv", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZL10dummy_lputjj", "__ZL10dummy_wputjj", "__ZL10dummy_bputjj", "0", "0", "0", "0", "__ZL8ram_lputjj", "__ZL8ram_wputjj", "__ZL8ram_bputjj", "0", "0", "0", "0", "__ZL10ram24_lputjj", "__ZL10ram24_wputjj", "__ZL10ram24_bputjj", "0", "0", "0", "0", "__ZL8rom_lputjj", "__ZL8rom_wputjj", "__ZL8rom_bputjj", "0", "0", "0", "0", "0", "0", "0", "0", "__ZL17frame_direct_lputjj", "__ZL17frame_direct_wputjj", "__ZL17frame_direct_bputjj", "0", "0", "0", "__ZL19frame_host_555_lputjj", "__ZL19frame_host_555_wputjj", "0", "0", "__ZL19frame_host_565_lputjj", "__ZL19frame_host_565_wputjj", "0", "__ZL19frame_host_888_lputjj", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_viii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZN11driver_base11mouse_movedEii", "0", "0", "0", "0", "__ZN13driver_window11mouse_movedEii", "0", "0", "0", "0", "0", "0", "__ZN16SDL_monitor_desc11set_paletteEPhi", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZL13Blit_Copy_RawPhPKhj", "__ZL19Blit_Expand_8_To_32PhPKhj", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_viiii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZNK10__cxxabiv117__class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi", "0", "0", "0", "__ZNK10__cxxabiv120__si_class_type_info27has_unambiguous_public_baseEPNS_19__dynamic_cast_infoEPvi", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_viiiii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZNK10__cxxabiv117__class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib", "0", "0", "0", "__ZNK10__cxxabiv120__si_class_type_info16search_below_dstEPNS_19__dynamic_cast_infoEPKvib", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
var debug_table_viiiiii = ["0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "__ZNK10__cxxabiv117__class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib", "0", "0", "0", "__ZNK10__cxxabiv120__si_class_type_info16search_above_dstEPNS_19__dynamic_cast_infoEPKvS4_ib", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"];
function nullFunc_ii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'ii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: iii: " + debug_table_iii[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viii: " + debug_table_viii[x] + "  v: " + debug_table_v[x] + "  viiii: " + debug_table_viiii[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  "); abort(x) }

function nullFunc_iii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'iii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: ii: " + debug_table_ii[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  viii: " + debug_table_viii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viiii: " + debug_table_viiii[x] + "  viiiii: " + debug_table_viiiii[x] + "  v: " + debug_table_v[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  "); abort(x) }

function nullFunc_iiii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'iiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: iii: " + debug_table_iii[x] + "  ii: " + debug_table_ii[x] + "  iiiii: " + debug_table_iiiii[x] + "  viii: " + debug_table_viii[x] + "  viiii: " + debug_table_viiii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  v: " + debug_table_v[x] + "  "); abort(x) }

function nullFunc_iiiii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'iiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: iiii: " + debug_table_iiii[x] + "  iii: " + debug_table_iii[x] + "  ii: " + debug_table_ii[x] + "  viiii: " + debug_table_viiii[x] + "  viii: " + debug_table_viii[x] + "  viiiii: " + debug_table_viiiii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  v: " + debug_table_v[x] + "  "); abort(x) }

function nullFunc_v(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'v'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: vi: " + debug_table_vi[x] + "  vii: " + debug_table_vii[x] + "  viii: " + debug_table_viii[x] + "  viiii: " + debug_table_viiii[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  ii: " + debug_table_ii[x] + "  iii: " + debug_table_iii[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  "); abort(x) }

function nullFunc_vi(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'vi'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: v: " + debug_table_v[x] + "  vii: " + debug_table_vii[x] + "  viii: " + debug_table_viii[x] + "  viiii: " + debug_table_viiii[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  ii: " + debug_table_ii[x] + "  iii: " + debug_table_iii[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  "); abort(x) }

function nullFunc_vii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'vii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: vi: " + debug_table_vi[x] + "  viii: " + debug_table_viii[x] + "  v: " + debug_table_v[x] + "  viiii: " + debug_table_viiii[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  ii: " + debug_table_ii[x] + "  iii: " + debug_table_iii[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  "); abort(x) }

function nullFunc_viii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'viii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viiii: " + debug_table_viiii[x] + "  v: " + debug_table_v[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  iii: " + debug_table_iii[x] + "  ii: " + debug_table_ii[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  "); abort(x) }

function nullFunc_viiii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'viiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: viii: " + debug_table_viii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viiiii: " + debug_table_viiiii[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  v: " + debug_table_v[x] + "  iiii: " + debug_table_iiii[x] + "  iii: " + debug_table_iii[x] + "  ii: " + debug_table_ii[x] + "  iiiii: " + debug_table_iiiii[x] + "  "); abort(x) }

function nullFunc_viiiii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'viiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: viii: " + debug_table_viii[x] + "  viiii: " + debug_table_viiii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  viiiiii: " + debug_table_viiiiii[x] + "  v: " + debug_table_v[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  iii: " + debug_table_iii[x] + "  ii: " + debug_table_ii[x] + "  "); abort(x) }

function nullFunc_viiiiii(x) { Module["printErr"]("Invalid function pointer '" + x + "' called with signature 'viiiiii'. Perhaps this is an invalid value (e.g. caused by calling a virtual method on a NULL pointer)? Or calling a function with an incorrect type, which will fail? (it is worth building your source files with -Werror (warnings are errors), as warnings can indicate undefined behavior which can cause this)");  Module["printErr"]("This pointer might make sense in another type signature: viii: " + debug_table_viii[x] + "  viiii: " + debug_table_viiii[x] + "  viiiii: " + debug_table_viiiii[x] + "  vii: " + debug_table_vii[x] + "  vi: " + debug_table_vi[x] + "  v: " + debug_table_v[x] + "  iiii: " + debug_table_iiii[x] + "  iiiii: " + debug_table_iiiii[x] + "  iii: " + debug_table_iii[x] + "  ii: " + debug_table_ii[x] + "  "); abort(x) }

function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    Module["setThrew"](1, 0);
  }
}

Module.asmGlobalArg = { "Math": Math, "Int8Array": Int8Array, "Int16Array": Int16Array, "Int32Array": Int32Array, "Uint8Array": Uint8Array, "Uint16Array": Uint16Array, "Uint32Array": Uint32Array, "Float32Array": Float32Array, "Float64Array": Float64Array, "NaN": NaN, "Infinity": Infinity };

Module.asmLibraryArg = { "abort": abort, "assert": assert, "enlargeMemory": enlargeMemory, "getTotalMemory": getTotalMemory, "abortOnCannotGrowMemory": abortOnCannotGrowMemory, "abortStackOverflow": abortStackOverflow, "nullFunc_ii": nullFunc_ii, "nullFunc_iii": nullFunc_iii, "nullFunc_iiii": nullFunc_iiii, "nullFunc_iiiii": nullFunc_iiiii, "nullFunc_v": nullFunc_v, "nullFunc_vi": nullFunc_vi, "nullFunc_vii": nullFunc_vii, "nullFunc_viii": nullFunc_viii, "nullFunc_viiii": nullFunc_viiii, "nullFunc_viiiii": nullFunc_viiiii, "nullFunc_viiiiii": nullFunc_viiiiii, "invoke_ii": invoke_ii, "invoke_iii": invoke_iii, "invoke_iiii": invoke_iiii, "invoke_iiiii": invoke_iiiii, "invoke_v": invoke_v, "invoke_vi": invoke_vi, "invoke_vii": invoke_vii, "invoke_viii": invoke_viii, "invoke_viiii": invoke_viiii, "invoke_viiiii": invoke_viiiii, "invoke_viiiiii": invoke_viiiiii, "_IMG_Load": _IMG_Load, "_IMG_Load_RW": _IMG_Load_RW, "_Mix_FreeChunk": _Mix_FreeChunk, "_Mix_HaltMusic": _Mix_HaltMusic, "_Mix_LoadWAV_RW": _Mix_LoadWAV_RW, "_Mix_PlayChannel": _Mix_PlayChannel, "_Mix_PlayMusic": _Mix_PlayMusic, "_SDL_CloseAudio": _SDL_CloseAudio, "_SDL_FreeRW": _SDL_FreeRW, "_SDL_FreeSurface": _SDL_FreeSurface, "_SDL_GetTicks": _SDL_GetTicks, "_SDL_GetVideoInfo": _SDL_GetVideoInfo, "_SDL_LockSurface": _SDL_LockSurface, "_SDL_MapRGB": _SDL_MapRGB, "_SDL_PauseAudio": _SDL_PauseAudio, "_SDL_PumpEvents": _SDL_PumpEvents, "_SDL_QuitSubSystem": _SDL_QuitSubSystem, "_SDL_RWFromConstMem": _SDL_RWFromConstMem, "_SDL_RWFromFile": _SDL_RWFromFile, "_SDL_SetVideoMode": _SDL_SetVideoMode, "_SDL_ShowCursor": _SDL_ShowCursor, "_SDL_UnlockSurface": _SDL_UnlockSurface, "_SDL_UpdateRect": _SDL_UpdateRect, "_SDL_UpperBlit": _SDL_UpperBlit, "_SDL_UpperBlitScaled": _SDL_UpperBlitScaled, "_SDL_VideoDriverName": _SDL_VideoDriverName, "_SDL_VideoModeOK": _SDL_VideoModeOK, "_SDL_WM_GrabInput": _SDL_WM_GrabInput, "_SDL_WM_SetCaption": _SDL_WM_SetCaption, "_SDL_mutexP": _SDL_mutexP, "_SDL_mutexV": _SDL_mutexV, "_TTF_FontHeight": _TTF_FontHeight, "_TTF_RenderText_Solid": _TTF_RenderText_Solid, "_TTF_SizeText": _TTF_SizeText, "__ZSt18uncaught_exceptionv": __ZSt18uncaught_exceptionv, "___assert_fail": ___assert_fail, "___buildEnvironment": ___buildEnvironment, "___cxa_allocate_exception": ___cxa_allocate_exception, "___cxa_begin_catch": ___cxa_begin_catch, "___cxa_find_matching_catch": ___cxa_find_matching_catch, "___cxa_pure_virtual": ___cxa_pure_virtual, "___cxa_throw": ___cxa_throw, "___gxx_personality_v0": ___gxx_personality_v0, "___lock": ___lock, "___resumeException": ___resumeException, "___setErrNo": ___setErrNo, "___syscall10": ___syscall10, "___syscall102": ___syscall102, "___syscall122": ___syscall122, "___syscall140": ___syscall140, "___syscall142": ___syscall142, "___syscall145": ___syscall145, "___syscall146": ___syscall146, "___syscall194": ___syscall194, "___syscall195": ___syscall195, "___syscall197": ___syscall197, "___syscall220": ___syscall220, "___syscall221": ___syscall221, "___syscall3": ___syscall3, "___syscall33": ___syscall33, "___syscall38": ___syscall38, "___syscall39": ___syscall39, "___syscall4": ___syscall4, "___syscall40": ___syscall40, "___syscall5": ___syscall5, "___syscall54": ___syscall54, "___syscall6": ___syscall6, "___unlock": ___unlock, "__exit": __exit, "__inet_ntop4_raw": __inet_ntop4_raw, "__inet_ntop6_raw": __inet_ntop6_raw, "__inet_pton4_raw": __inet_pton4_raw, "__inet_pton6_raw": __inet_pton6_raw, "__read_sockaddr": __read_sockaddr, "__write_sockaddr": __write_sockaddr, "_abort": _abort, "_emscripten_asm_const_i": _emscripten_asm_const_i, "_emscripten_asm_const_ii": _emscripten_asm_const_ii, "_emscripten_asm_const_iii": _emscripten_asm_const_iii, "_emscripten_asm_const_iiii": _emscripten_asm_const_iiii, "_emscripten_asm_const_iiiii": _emscripten_asm_const_iiiii, "_emscripten_asm_const_iiiiii": _emscripten_asm_const_iiiiii, "_emscripten_get_now": _emscripten_get_now, "_emscripten_memcpy_big": _emscripten_memcpy_big, "_emscripten_set_main_loop": _emscripten_set_main_loop, "_emscripten_set_main_loop_timing": _emscripten_set_main_loop_timing, "_exit": _exit, "_getenv": _getenv, "_gethostbyname": _gethostbyname, "_gettimeofday": _gettimeofday, "_llvm_ceil_f64": _llvm_ceil_f64, "_llvm_exp2_f32": _llvm_exp2_f32, "_llvm_exp2_f64": _llvm_exp2_f64, "_llvm_fabs_f32": _llvm_fabs_f32, "_llvm_fabs_f64": _llvm_fabs_f64, "_llvm_floor_f64": _llvm_floor_f64, "_llvm_pow_f64": _llvm_pow_f64, "_llvm_trap": _llvm_trap, "_localtime": _localtime, "_localtime_r": _localtime_r, "_pthread_getspecific": _pthread_getspecific, "_pthread_key_create": _pthread_key_create, "_pthread_once": _pthread_once, "_pthread_setspecific": _pthread_setspecific, "_putenv": _putenv, "_sem_destroy": _sem_destroy, "_sem_init": _sem_init, "_sem_post": _sem_post, "_sem_wait": _sem_wait, "_time": _time, "_tzset": _tzset, "_usleep": _usleep, "DYNAMICTOP_PTR": DYNAMICTOP_PTR, "tempDoublePtr": tempDoublePtr, "ABORT": ABORT, "STACKTOP": STACKTOP, "STACK_MAX": STACK_MAX, "cttz_i8": cttz_i8 };
// EMSCRIPTEN_START_ASM
var asm = (/** @suppress {uselessCode} */ function(global, env, buffer) {
'use asm';


  var HEAP8 = new global.Int8Array(buffer);
  var HEAP16 = new global.Int16Array(buffer);
  var HEAP32 = new global.Int32Array(buffer);
  var HEAPU8 = new global.Uint8Array(buffer);
  var HEAPU16 = new global.Uint16Array(buffer);
  var HEAPU32 = new global.Uint32Array(buffer);
  var HEAPF32 = new global.Float32Array(buffer);
  var HEAPF64 = new global.Float64Array(buffer);

  var DYNAMICTOP_PTR=env.DYNAMICTOP_PTR|0;
  var tempDoublePtr=env.tempDoublePtr|0;
  var ABORT=env.ABORT|0;
  var STACKTOP=env.STACKTOP|0;
  var STACK_MAX=env.STACK_MAX|0;
  var cttz_i8=env.cttz_i8|0;

  var __THREW__ = 0;
  var threwValue = 0;
  var setjmpId = 0;
  var undef = 0;
  var nan = global.NaN, inf = global.Infinity;
  var tempInt = 0, tempBigInt = 0, tempBigIntS = 0, tempValue = 0, tempDouble = 0.0;
  var tempRet0 = 0;

  var Math_floor=global.Math.floor;
  var Math_abs=global.Math.abs;
  var Math_sqrt=global.Math.sqrt;
  var Math_pow=global.Math.pow;
  var Math_cos=global.Math.cos;
  var Math_sin=global.Math.sin;
  var Math_tan=global.Math.tan;
  var Math_acos=global.Math.acos;
  var Math_asin=global.Math.asin;
  var Math_atan=global.Math.atan;
  var Math_atan2=global.Math.atan2;
  var Math_exp=global.Math.exp;
  var Math_log=global.Math.log;
  var Math_ceil=global.Math.ceil;
  var Math_imul=global.Math.imul;
  var Math_min=global.Math.min;
  var Math_max=global.Math.max;
  var Math_clz32=global.Math.clz32;
  var abort=env.abort;
  var assert=env.assert;
  var enlargeMemory=env.enlargeMemory;
  var getTotalMemory=env.getTotalMemory;
  var abortOnCannotGrowMemory=env.abortOnCannotGrowMemory;
  var abortStackOverflow=env.abortStackOverflow;
  var nullFunc_ii=env.nullFunc_ii;
  var nullFunc_iii=env.nullFunc_iii;
  var nullFunc_iiii=env.nullFunc_iiii;
  var nullFunc_iiiii=env.nullFunc_iiiii;
  var nullFunc_v=env.nullFunc_v;
  var nullFunc_vi=env.nullFunc_vi;
  var nullFunc_vii=env.nullFunc_vii;
  var nullFunc_viii=env.nullFunc_viii;
  var nullFunc_viiii=env.nullFunc_viiii;
  var nullFunc_viiiii=env.nullFunc_viiiii;
  var nullFunc_viiiiii=env.nullFunc_viiiiii;
  var invoke_ii=env.invoke_ii;
  var invoke_iii=env.invoke_iii;
  var invoke_iiii=env.invoke_iiii;
  var invoke_iiiii=env.invoke_iiiii;
  var invoke_v=env.invoke_v;
  var invoke_vi=env.invoke_vi;
  var invoke_vii=env.invoke_vii;
  var invoke_viii=env.invoke_viii;
  var invoke_viiii=env.invoke_viiii;
  var invoke_viiiii=env.invoke_viiiii;
  var invoke_viiiiii=env.invoke_viiiiii;
  var _IMG_Load=env._IMG_Load;
  var _IMG_Load_RW=env._IMG_Load_RW;
  var _Mix_FreeChunk=env._Mix_FreeChunk;
  var _Mix_HaltMusic=env._Mix_HaltMusic;
  var _Mix_LoadWAV_RW=env._Mix_LoadWAV_RW;
  var _Mix_PlayChannel=env._Mix_PlayChannel;
  var _Mix_PlayMusic=env._Mix_PlayMusic;
  var _SDL_CloseAudio=env._SDL_CloseAudio;
  var _SDL_FreeRW=env._SDL_FreeRW;
  var _SDL_FreeSurface=env._SDL_FreeSurface;
  var _SDL_GetTicks=env._SDL_GetTicks;
  var _SDL_GetVideoInfo=env._SDL_GetVideoInfo;
  var _SDL_LockSurface=env._SDL_LockSurface;
  var _SDL_MapRGB=env._SDL_MapRGB;
  var _SDL_PauseAudio=env._SDL_PauseAudio;
  var _SDL_PumpEvents=env._SDL_PumpEvents;
  var _SDL_QuitSubSystem=env._SDL_QuitSubSystem;
  var _SDL_RWFromConstMem=env._SDL_RWFromConstMem;
  var _SDL_RWFromFile=env._SDL_RWFromFile;
  var _SDL_SetVideoMode=env._SDL_SetVideoMode;
  var _SDL_ShowCursor=env._SDL_ShowCursor;
  var _SDL_UnlockSurface=env._SDL_UnlockSurface;
  var _SDL_UpdateRect=env._SDL_UpdateRect;
  var _SDL_UpperBlit=env._SDL_UpperBlit;
  var _SDL_UpperBlitScaled=env._SDL_UpperBlitScaled;
  var _SDL_VideoDriverName=env._SDL_VideoDriverName;
  var _SDL_VideoModeOK=env._SDL_VideoModeOK;
  var _SDL_WM_GrabInput=env._SDL_WM_GrabInput;
  var _SDL_WM_SetCaption=env._SDL_WM_SetCaption;
  var _SDL_mutexP=env._SDL_mutexP;
  var _SDL_mutexV=env._SDL_mutexV;
  var _TTF_FontHeight=env._TTF_FontHeight;
  var _TTF_RenderText_Solid=env._TTF_RenderText_Solid;
  var _TTF_SizeText=env._TTF_SizeText;
  var __ZSt18uncaught_exceptionv=env.__ZSt18uncaught_exceptionv;
  var ___assert_fail=env.___assert_fail;
  var ___buildEnvironment=env.___buildEnvironment;
  var ___cxa_allocate_exception=env.___cxa_allocate_exception;
  var ___cxa_begin_catch=env.___cxa_begin_catch;
  var ___cxa_find_matching_catch=env.___cxa_find_matching_catch;
  var ___cxa_pure_virtual=env.___cxa_pure_virtual;
  var ___cxa_throw=env.___cxa_throw;
  var ___gxx_personality_v0=env.___gxx_personality_v0;
  var ___lock=env.___lock;
  var ___resumeException=env.___resumeException;
  var ___setErrNo=env.___setErrNo;
  var ___syscall10=env.___syscall10;
  var ___syscall102=env.___syscall102;
  var ___syscall122=env.___syscall122;
  var ___syscall140=env.___syscall140;
  var ___syscall142=env.___syscall142;
  var ___syscall145=env.___syscall145;
  var ___syscall146=env.___syscall146;
  var ___syscall194=env.___syscall194;
  var ___syscall195=env.___syscall195;
  var ___syscall197=env.___syscall197;
  var ___syscall220=env.___syscall220;
  var ___syscall221=env.___syscall221;
  var ___syscall3=env.___syscall3;
  var ___syscall33=env.___syscall33;
  var ___syscall38=env.___syscall38;
  var ___syscall39=env.___syscall39;
  var ___syscall4=env.___syscall4;
  var ___syscall40=env.___syscall40;
  var ___syscall5=env.___syscall5;
  var ___syscall54=env.___syscall54;
  var ___syscall6=env.___syscall6;
  var ___unlock=env.___unlock;
  var __exit=env.__exit;
  var __inet_ntop4_raw=env.__inet_ntop4_raw;
  var __inet_ntop6_raw=env.__inet_ntop6_raw;
  var __inet_pton4_raw=env.__inet_pton4_raw;
  var __inet_pton6_raw=env.__inet_pton6_raw;
  var __read_sockaddr=env.__read_sockaddr;
  var __write_sockaddr=env.__write_sockaddr;
  var _abort=env._abort;
  var _emscripten_asm_const_i=env._emscripten_asm_const_i;
  var _emscripten_asm_const_ii=env._emscripten_asm_const_ii;
  var _emscripten_asm_const_iii=env._emscripten_asm_const_iii;
  var _emscripten_asm_const_iiii=env._emscripten_asm_const_iiii;
  var _emscripten_asm_const_iiiii=env._emscripten_asm_const_iiiii;
  var _emscripten_asm_const_iiiiii=env._emscripten_asm_const_iiiiii;
  var _emscripten_get_now=env._emscripten_get_now;
  var _emscripten_memcpy_big=env._emscripten_memcpy_big;
  var _emscripten_set_main_loop=env._emscripten_set_main_loop;
  var _emscripten_set_main_loop_timing=env._emscripten_set_main_loop_timing;
  var _exit=env._exit;
  var _getenv=env._getenv;
  var _gethostbyname=env._gethostbyname;
  var _gettimeofday=env._gettimeofday;
  var _llvm_ceil_f64=env._llvm_ceil_f64;
  var _llvm_exp2_f32=env._llvm_exp2_f32;
  var _llvm_exp2_f64=env._llvm_exp2_f64;
  var _llvm_fabs_f32=env._llvm_fabs_f32;
  var _llvm_fabs_f64=env._llvm_fabs_f64;
  var _llvm_floor_f64=env._llvm_floor_f64;
  var _llvm_pow_f64=env._llvm_pow_f64;
  var _llvm_trap=env._llvm_trap;
  var _localtime=env._localtime;
  var _localtime_r=env._localtime_r;
  var _pthread_getspecific=env._pthread_getspecific;
  var _pthread_key_create=env._pthread_key_create;
  var _pthread_once=env._pthread_once;
  var _pthread_setspecific=env._pthread_setspecific;
  var _putenv=env._putenv;
  var _sem_destroy=env._sem_destroy;
  var _sem_init=env._sem_init;
  var _sem_post=env._sem_post;
  var _sem_wait=env._sem_wait;
  var _time=env._time;
  var _tzset=env._tzset;
  var _usleep=env._usleep;
  var tempFloat = 0.0;

// EMSCRIPTEN_START_FUNCS

function stackAlloc(size) {
  size = size|0;
  var ret = 0;
  ret = STACKTOP;
  STACKTOP = (STACKTOP + size)|0;
  STACKTOP = (STACKTOP + 15)&-16;
  if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(size|0);

  return ret|0;
}
function stackSave() {
  return STACKTOP|0;
}
function stackRestore(top) {
  top = top|0;
  STACKTOP = top;
}
function establishStackSpace(stackBase, stackMax) {
  stackBase = stackBase|0;
  stackMax = stackMax|0;
  STACKTOP = stackBase;
  STACK_MAX = stackMax;
}

function setThrew(threw, value) {
  threw = threw|0;
  value = value|0;
  if ((__THREW__|0) == 0) {
    __THREW__ = threw;
    threwValue = value;
  }
}

function setTempRet0(value) {
  value = value|0;
  tempRet0 = value;
}
function getTempRet0() {
  return tempRet0|0;
}

function __Z7InitAllPKc($0) {
 $0 = $0|0;
 var $$ = 0, $$$ = 0, $$$2 = 0, $$2 = 0, $$215 = 0, $$sink = 0, $$sink4 = 0, $$sink4$shrunk = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0;
 var $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0;
 var $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $narrow = 0, $narrow17 = 0, $or$cond = 0, $or$cond20 = 0;
 var $or$cond22 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $1 = (__Z8CheckROMv()|0); //@line 67 "./../main.cpp"
 if (!($1)) {
  $2 = (__Z9GetStringi(1007)|0); //@line 263 "./../main.cpp"
  __Z10ErrorAlertPKc($2); //@line 263 "./../main.cpp"
  $$215 = 0;
  return ($$215|0); //@line 206 "./../main.cpp"
 }
 $3 = HEAP16[327318]|0; //@line 74 "./../main.cpp"
 switch ($3<<16>>16) {
 case 630: case 117: case 0:  {
  HEAP32[31565] = 0; //@line 78 "./../main.cpp"
  $$sink = 1;$$sink4$shrunk = 0;
  label = 7;
  break;
 }
 case 376:  {
  $4 = (__Z14PrefsFindInt32PKc(90248)|0); //@line 83 "./../main.cpp"
  $5 = ($4|0)>(2); //@line 84 "./../main.cpp"
  $$ = $5 ? $4 : 2; //@line 84 "./../main.cpp"
  $6 = ($$|0)<(4); //@line 85 "./../main.cpp"
  $$$ = $6 ? $$ : 4; //@line 85 "./../main.cpp"
  HEAP32[31565] = $$$;
  $7 = (__Z13PrefsFindBoolPKc(90289)|0); //@line 86 "./../main.cpp"
  $8 = $7&1; //@line 86 "./../main.cpp"
  HEAP32[31566] = $8; //@line 86 "./../main.cpp"
  $9 = HEAP32[31565]|0; //@line 87 "./../main.cpp"
  $10 = ($9|0)==(4); //@line 87 "./../main.cpp"
  $narrow17 = $7 | $10; //@line 87 "./../main.cpp"
  $$sink = 1;$$sink4$shrunk = $narrow17;
  label = 7;
  break;
 }
 case 1660:  {
  $11 = (__Z14PrefsFindInt32PKc(90248)|0); //@line 91 "./../main.cpp"
  $12 = ($11|0)>(2); //@line 92 "./../main.cpp"
  $$2 = $12 ? $11 : 2; //@line 92 "./../main.cpp"
  $13 = ($$2|0)<(4); //@line 93 "./../main.cpp"
  $$$2 = $13 ? $$2 : 4; //@line 93 "./../main.cpp"
  HEAP32[31565] = $$$2;
  $14 = (__Z13PrefsFindBoolPKc(90289)|0); //@line 94 "./../main.cpp"
  $15 = $14&1; //@line 94 "./../main.cpp"
  HEAP32[31566] = $15; //@line 94 "./../main.cpp"
  $16 = HEAP32[31565]|0; //@line 95 "./../main.cpp"
  $17 = ($16|0)==(4); //@line 95 "./../main.cpp"
  $narrow = $14 | $17; //@line 95 "./../main.cpp"
  $$sink = 0;$$sink4$shrunk = $narrow;
  label = 7;
  break;
 }
 default: {
 }
 }
 if ((label|0) == 7) {
  $$sink4 = $$sink4$shrunk&1;
  HEAP32[31566] = $$sink4;
  HEAP8[662193] = $$sink;
 }
 __Z9XPRAMInitPKc($0); //@line 103 "./../main.cpp"
 $18 = HEAP8[(658753)>>0]|0; //@line 106 "./../main.cpp"
 $19 = ($18<<24>>24)==(78); //@line 106 "./../main.cpp"
 $20 = HEAP8[(658754)>>0]|0; //@line 106 "./../main.cpp"
 $21 = ($20<<24>>24)==(117); //@line 106 "./../main.cpp"
 $or$cond = $19 & $21; //@line 106 "./../main.cpp"
 $22 = HEAP8[(658755)>>0]|0; //@line 107 "./../main.cpp"
 $23 = ($22<<24>>24)==(77); //@line 107 "./../main.cpp"
 $or$cond20 = $or$cond & $23; //@line 106 "./../main.cpp"
 $24 = HEAP8[(658756)>>0]|0; //@line 107 "./../main.cpp"
 $25 = ($24<<24>>24)==(99); //@line 107 "./../main.cpp"
 $or$cond22 = $or$cond20 & $25; //@line 106 "./../main.cpp"
 if (!($or$cond22)) {
  _memset((658741|0),0,256)|0; //@line 109 "./../main.cpp"
  HEAP8[(658753)>>0] = 78; //@line 110 "./../main.cpp"
  HEAP8[(658754)>>0] = 117; //@line 111 "./../main.cpp"
  HEAP8[(658755)>>0] = 77; //@line 112 "./../main.cpp"
  HEAP8[(658756)>>0] = 99; //@line 113 "./../main.cpp"
  HEAP8[(658742)>>0] = -128; //@line 114 "./../main.cpp"
  HEAP8[(658757)>>0] = -88; //@line 115 "./../main.cpp"
  HEAP8[(658758)>>0] = 0; //@line 116 "./../main.cpp"
  HEAP8[(658759)>>0] = 0; //@line 117 "./../main.cpp"
  HEAP8[(658760)>>0] = 34; //@line 118 "./../main.cpp"
  HEAP8[(658761)>>0] = -52; //@line 119 "./../main.cpp"
  HEAP8[(658762)>>0] = 10; //@line 120 "./../main.cpp"
  HEAP8[(658763)>>0] = -52; //@line 121 "./../main.cpp"
  HEAP8[(658764)>>0] = 10; //@line 122 "./../main.cpp"
  HEAP8[(658769)>>0] = 0; //@line 123 "./../main.cpp"
  HEAP8[(658770)>>0] = 2; //@line 124 "./../main.cpp"
  HEAP8[(658771)>>0] = 99; //@line 125 "./../main.cpp"
  HEAP8[(658772)>>0] = 0; //@line 126 "./../main.cpp"
  HEAP8[(658749)>>0] = 19; //@line 127 "./../main.cpp"
  HEAP8[(658750)>>0] = -120; //@line 128 "./../main.cpp"
  HEAP8[(658751)>>0] = 0; //@line 129 "./../main.cpp"
  HEAP8[(658752)>>0] = -52; //@line 130 "./../main.cpp"
  HEAP8[(658859)>>0] = 0; //@line 131 "./../main.cpp"
  HEAP8[(658860)>>0] = 1; //@line 132 "./../main.cpp"
 }
 $26 = (__Z14PrefsFindInt32PKc(90075)|0); //@line 136 "./../main.cpp"
 $27 = $26 >>> 8; //@line 137 "./../main.cpp"
 $28 = $27&255; //@line 137 "./../main.cpp"
 HEAP8[(658861)>>0] = $28; //@line 137 "./../main.cpp"
 $29 = $26&255; //@line 138 "./../main.cpp"
 HEAP8[(658862)>>0] = $29; //@line 138 "./../main.cpp"
 $30 = (__Z14PrefsFindInt32PKc(90103)|0); //@line 139 "./../main.cpp"
 $31 = $30 >>> 8; //@line 140 "./../main.cpp"
 $32 = $31&255; //@line 140 "./../main.cpp"
 HEAP8[(658863)>>0] = $32; //@line 140 "./../main.cpp"
 $33 = $30&255; //@line 141 "./../main.cpp"
 HEAP8[(658864)>>0] = $33; //@line 141 "./../main.cpp"
 __Z8SonyInitv(); //@line 144 "./../main.cpp"
 __Z8DiskInitv(); //@line 145 "./../main.cpp"
 __Z9CDROMInitv(); //@line 146 "./../main.cpp"
 __Z8SCSIInitv(); //@line 147 "./../main.cpp"
 __Z9ExtFSInitv(); //@line 151 "./../main.cpp"
 __Z10SerialInitv(); //@line 155 "./../main.cpp"
 __Z9EtherInitv(); //@line 158 "./../main.cpp"
 __Z9TimerInitv(); //@line 161 "./../main.cpp"
 __Z7ADBInitv(); //@line 167 "./../main.cpp"
 __Z9AudioInitv(); //@line 170 "./../main.cpp"
 (_puts(89040)|0); //@line 172 "./../main.cpp"
 $34 = HEAP16[327318]|0; //@line 174 "./../main.cpp"
 switch ($34<<16>>16) {
 case 630: case 117: case 0:  {
  $35 = 1;
  break;
 }
 default: {
  $35 = 0;
 }
 }
 $36 = (__Z9VideoInitb($35)|0); //@line 174 "./../main.cpp"
 if (!($36)) {
  $$215 = 0;
  return ($$215|0); //@line 206 "./../main.cpp"
 }
 HEAP8[(658827)>>0] = 66; //@line 178 "./../main.cpp"
 HEAP8[(658828)>>0] = 50; //@line 179 "./../main.cpp"
 $37 = HEAP32[31231]|0; //@line 1496 "/home/ilya/emsdk/emscripten/1.37.40/system/include/libcxx/vector"
 $38 = HEAP32[$37>>2]|0; //@line 180 "./../main.cpp"
 $39 = ((($38)) + 16|0); //@line 1316 "/home/ilya/emsdk/emscripten/1.37.40/system/include/libcxx/iterator"
 $40 = HEAP32[$39>>2]|0; //@line 1316 "/home/ilya/emsdk/emscripten/1.37.40/system/include/libcxx/iterator"
 $41 = ((($40)) + 12|0); //@line 181 "./../main.cpp"
 $42 = HEAP32[$41>>2]|0; //@line 181 "./../main.cpp"
 $43 = (((($38)) + 824|0) + ($42<<1)|0); //@line 162 "./../include/video.h"
 $44 = HEAP16[$43>>1]|0; //@line 162 "./../include/video.h"
 $45 = $44&255; //@line 181 "./../main.cpp"
 HEAP8[(658829)>>0] = $45; //@line 181 "./../main.cpp"
 HEAP8[(658830)>>0] = 0; //@line 182 "./../main.cpp"
 (_puts(89050)|0); //@line 185 "./../main.cpp"
 $46 = (__Z9Init680x0v()|0); //@line 187 "./../main.cpp"
 if (!($46)) {
  $$215 = 0;
  return ($$215|0); //@line 206 "./../main.cpp"
 }
 (_puts(89060)|0); //@line 191 "./../main.cpp"
 $47 = (__Z8PatchROMv()|0); //@line 193 "./../main.cpp"
 if ($47) {
  $$215 = 1;
  return ($$215|0); //@line 206 "./../main.cpp"
 }
 $48 = (__Z9GetStringi(1007)|0); //@line 263 "./../main.cpp"
 __Z10ErrorAlertPKc($48); //@line 263 "./../main.cpp"
 $$215 = 0;
 return ($$215|0); //@line 206 "./../main.cpp"
}
function __Z10ErrorAlerti($0) {
 $0 = $0|0;
 var $1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $1 = (__Z9GetStringi($0)|0); //@line 263 "./../main.cpp"
 __Z10ErrorAlertPKc($1); //@line 263 "./../main.cpp"
 return; //@line 264 "./../main.cpp"
}
function __Z7ExitAllv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 __Z9XPRAMExitv(); //@line 221 "./../main.cpp"
 __Z9VideoExitv(); //@line 224 "./../main.cpp"
 __Z9AudioExitv(); //@line 227 "./../main.cpp"
 __Z7ADBExitv(); //@line 230 "./../main.cpp"
 __Z10SerialExitv(); //@line 239 "./../main.cpp"
 __Z9EtherExitv(); //@line 242 "./../main.cpp"
 __Z9ExtFSExitv(); //@line 246 "./../main.cpp"
 __Z9CDROMExitv(); //@line 251 "./../main.cpp"
 __Z8DiskExitv(); //@line 252 "./../main.cpp"
 __Z8SonyExitv(); //@line 253 "./../main.cpp"
 return; //@line 254 "./../main.cpp"
}
function __Z9PrefsInitPKcRiRPPc($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$0$i = 0, $$0$i$i = 0, $$0$i$i103 = 0, $$0$i$i84 = 0, $$0$i$i93 = 0, $$0116 = 0, $$014$i$i = 0, $$014$i$i100 = 0, $$014$i$i90 = 0, $$01416$i$i = 0, $$01416$i$i87 = 0, $$01416$i$i97 = 0, $$01418$i$i = 0, $$01418$i$i88 = 0, $$01418$i$i98 = 0, $$06$i$i = 0, $$06$i5$i = 0, $$078$lcssa = 0, $$078113 = 0, $$079121 = 0;
 var $$080123 = 0, $$2 = 0, $$sink$i$i = 0, $$sink$i$i105 = 0, $$sink$i$i86 = 0, $$sink$i$i95 = 0, $10 = 0, $100 = 0, $101 = 0, $102 = 0, $103 = 0, $104 = 0, $105 = 0, $106 = 0, $107 = 0, $108 = 0, $109 = 0, $11 = 0, $110 = 0, $111 = 0;
 var $112 = 0, $113 = 0, $114 = 0, $115 = 0, $116 = 0, $117 = 0, $118 = 0, $119 = 0, $12 = 0, $120 = 0, $121 = 0, $122 = 0, $123 = 0, $124 = 0, $125 = 0, $126 = 0, $127 = 0, $128 = 0, $129 = 0, $13 = 0;
 var $130 = 0, $131 = 0, $132 = 0, $133 = 0, $134 = 0, $135 = 0, $136 = 0, $137 = 0, $138 = 0, $139 = 0, $14 = 0, $140 = 0, $141 = 0, $142 = 0, $143 = 0, $144 = 0, $145 = 0, $146 = 0, $147 = 0, $148 = 0;
 var $149 = 0, $15 = 0, $150 = 0, $151 = 0, $152 = 0, $153 = 0, $154 = 0, $155 = 0, $156 = 0, $157 = 0, $158 = 0, $159 = 0, $16 = 0, $160 = 0, $161 = 0, $162 = 0, $163 = 0, $164 = 0, $17 = 0, $18 = 0;
 var $19 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0;
 var $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0;
 var $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0;
 var $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $86 = 0, $87 = 0, $88 = 0, $89 = 0, $9 = 0, $90 = 0, $91 = 0;
 var $92 = 0, $93 = 0, $94 = 0, $95 = 0, $96 = 0, $97 = 0, $98 = 0, $99 = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 16|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(16|0);
 $vararg_buffer1 = sp + 8|0; //@line 50 "./../prefs.cpp"
 $vararg_buffer = sp; //@line 50 "./../prefs.cpp"
 __Z16AddPrefsDefaultsv(); //@line 53 "./../prefs.cpp"
 __Z24AddPlatformPrefsDefaultsv(); //@line 54 "./../prefs.cpp"
 __Z9LoadPrefsPKc($0); //@line 57 "./../prefs.cpp"
 $3 = HEAP32[$1>>2]|0; //@line 60 "./../prefs.cpp"
 $4 = ($3|0)>(1); //@line 60 "./../prefs.cpp"
 if (!($4)) {
  STACKTOP = sp;return; //@line 129 "./../prefs.cpp"
 }
 $5 = HEAP32[22095]|0;
 $$080123 = 1;$40 = $3;
 while(1) {
  $8 = HEAP32[$2>>2]|0; //@line 63 "./../prefs.cpp"
  $9 = (($8) + ($$080123<<2)|0); //@line 63 "./../prefs.cpp"
  $10 = HEAP32[$9>>2]|0; //@line 63 "./../prefs.cpp"
  $11 = ($10|0)==(0|0); //@line 64 "./../prefs.cpp"
  L6: do {
   if ($11) {
    $$2 = $$080123;
   } else {
    $12 = (_strlen($10)|0); //@line 64 "./../prefs.cpp"
    $13 = ($12>>>0)<(3); //@line 64 "./../prefs.cpp"
    if ($13) {
     $$2 = $$080123;
    } else {
     $14 = HEAP8[$10>>0]|0; //@line 64 "./../prefs.cpp"
     $15 = ($14<<24>>24)==(45); //@line 64 "./../prefs.cpp"
     if ($15) {
      $16 = ((($10)) + 1|0); //@line 64 "./../prefs.cpp"
      $17 = HEAP8[$16>>0]|0; //@line 64 "./../prefs.cpp"
      $18 = ($17<<24>>24)==(45); //@line 64 "./../prefs.cpp"
      if ($18) {
       $19 = ((($10)) + 2|0); //@line 66 "./../prefs.cpp"
       $20 = HEAP32[(436)>>2]|0; //@line 212 "./../prefs.cpp"
       $21 = ($20|0)==(3); //@line 212 "./../prefs.cpp"
       L11: do {
        if ($21) {
         label = 11;
        } else {
         $$06$i$i = 432;
         while(1) {
          $22 = HEAP32[$$06$i$i>>2]|0; //@line 213 "./../prefs.cpp"
          $23 = (_strcmp($22,$19)|0); //@line 213 "./../prefs.cpp"
          $24 = ($23|0)==(0); //@line 213 "./../prefs.cpp"
          if ($24) {
           $$0$i = $$06$i$i;
           break L11;
          }
          $25 = ((($$06$i$i)) + 16|0); //@line 215 "./../prefs.cpp"
          $26 = ((($$06$i$i)) + 20|0); //@line 212 "./../prefs.cpp"
          $27 = HEAP32[$26>>2]|0; //@line 212 "./../prefs.cpp"
          $28 = ($27|0)==(3); //@line 212 "./../prefs.cpp"
          if ($28) {
           label = 11;
           break;
          } else {
           $$06$i$i = $25;
          }
         }
        }
       } while(0);
       L15: do {
        if ((label|0) == 11) {
         label = 0;
         $29 = HEAP32[(5364)>>2]|0; //@line 212 "./../prefs.cpp"
         $30 = ($29|0)==(3); //@line 212 "./../prefs.cpp"
         if ($30) {
          $$2 = $$080123;
          break L6;
         } else {
          $$06$i5$i = 5360;
         }
         while(1) {
          $31 = HEAP32[$$06$i5$i>>2]|0; //@line 213 "./../prefs.cpp"
          $32 = (_strcmp($31,$19)|0); //@line 213 "./../prefs.cpp"
          $33 = ($32|0)==(0); //@line 213 "./../prefs.cpp"
          if ($33) {
           $$0$i = $$06$i5$i;
           break L15;
          }
          $34 = ((($$06$i5$i)) + 16|0); //@line 215 "./../prefs.cpp"
          $35 = ((($$06$i5$i)) + 20|0); //@line 212 "./../prefs.cpp"
          $36 = HEAP32[$35>>2]|0; //@line 212 "./../prefs.cpp"
          $37 = ($36|0)==(3); //@line 212 "./../prefs.cpp"
          if ($37) {
           $$2 = $$080123;
           break L6;
          } else {
           $$06$i5$i = $34;
          }
         }
        }
       } while(0);
       HEAP32[$9>>2] = 0; //@line 72 "./../prefs.cpp"
       $38 = (($$080123) + 1)|0; //@line 75 "./../prefs.cpp"
       $39 = ($38|0)<($40|0); //@line 76 "./../prefs.cpp"
       if (!($39)) {
        HEAP32[$vararg_buffer>>2] = $10; //@line 77 "./../prefs.cpp"
        (_fprintf($5,89069,$vararg_buffer)|0); //@line 77 "./../prefs.cpp"
        $$2 = $38;
        break;
       }
       $41 = HEAP32[$2>>2]|0; //@line 80 "./../prefs.cpp"
       $42 = (($41) + ($38<<2)|0); //@line 80 "./../prefs.cpp"
       $43 = HEAP32[$42>>2]|0; //@line 80 "./../prefs.cpp"
       HEAP32[$42>>2] = 0; //@line 81 "./../prefs.cpp"
       $44 = ((($$0$i)) + 4|0); //@line 84 "./../prefs.cpp"
       $45 = HEAP32[$44>>2]|0; //@line 84 "./../prefs.cpp"
       switch ($45|0) {
       case 0:  {
        $46 = ((($$0$i)) + 8|0); //@line 86 "./../prefs.cpp"
        $47 = HEAP8[$46>>0]|0; //@line 86 "./../prefs.cpp"
        $48 = ($47<<24>>24)==(0); //@line 86 "./../prefs.cpp"
        if ($48) {
         __Z18PrefsReplaceStringPKcS0_i($19,$43,0); //@line 89 "./../prefs.cpp"
         $$2 = $38;
         break L6;
        }
        $49 = (_strlen($43)|0); //@line 255 "./../prefs.cpp"
        $50 = (($49) + 1)|0; //@line 255 "./../prefs.cpp"
        $51 = (_malloc($50)|0); //@line 235 "./../prefs.cpp"
        $52 = ($51|0)==(0|0); //@line 236 "./../prefs.cpp"
        if ($52) {
         $$2 = $38;
         break L6;
        }
        _memcpy(($51|0),($43|0),($50|0))|0; //@line 238 "./../prefs.cpp"
        $53 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
        HEAP32[$53>>2] = 0; //@line 240 "./../prefs.cpp"
        $54 = (___strdup($19)|0); //@line 241 "./../prefs.cpp"
        $55 = ((($53)) + 4|0); //@line 241 "./../prefs.cpp"
        HEAP32[$55>>2] = $54; //@line 241 "./../prefs.cpp"
        $56 = ((($53)) + 8|0); //@line 242 "./../prefs.cpp"
        HEAP32[$56>>2] = 0; //@line 242 "./../prefs.cpp"
        $57 = ((($53)) + 12|0); //@line 243 "./../prefs.cpp"
        HEAP32[$57>>2] = $51; //@line 243 "./../prefs.cpp"
        $58 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
        $59 = ($58|0)==(0|0); //@line 244 "./../prefs.cpp"
        if ($59) {
         $$sink$i$i = 115536;
        } else {
         $$0$i$i = $58;
         while(1) {
          $60 = HEAP32[$$0$i$i>>2]|0; //@line 246 "./../prefs.cpp"
          $61 = ($60|0)==(0|0); //@line 246 "./../prefs.cpp"
          if ($61) {
           break;
          } else {
           $$0$i$i = $60;
          }
         }
         $$sink$i$i = $$0$i$i;
        }
        HEAP32[$$sink$i$i>>2] = $53;
        $$2 = $38;
        break L6;
        break;
       }
       case 1:  {
        $62 = (_strcmp($43,114711)|0); //@line 93 "./../prefs.cpp"
        $63 = ($62|0)==(0); //@line 93 "./../prefs.cpp"
        if (!($63)) {
         $64 = (_strcmp($43,89110)|0); //@line 93 "./../prefs.cpp"
         $65 = ($64|0)==(0); //@line 93 "./../prefs.cpp"
         if (!($65)) {
          $66 = (_strcmp($43,89113)|0); //@line 93 "./../prefs.cpp"
          $67 = ($66|0)==(0); //@line 93 "./../prefs.cpp"
          if (!($67)) {
           $90 = (_strcmp($43,114705)|0); //@line 95 "./../prefs.cpp"
           $91 = ($90|0)==(0); //@line 95 "./../prefs.cpp"
           if (!($91)) {
            $92 = (_strcmp($43,89117)|0); //@line 95 "./../prefs.cpp"
            $93 = ($92|0)==(0); //@line 95 "./../prefs.cpp"
            if (!($93)) {
             $94 = (_strcmp($43,89121)|0); //@line 95 "./../prefs.cpp"
             $95 = ($94|0)==(0); //@line 95 "./../prefs.cpp"
             if (!($95)) {
              HEAP32[$vararg_buffer1>>2] = $10; //@line 98 "./../prefs.cpp"
              (_fprintf($5,89124,$vararg_buffer1)|0); //@line 98 "./../prefs.cpp"
              $$2 = $38;
              break L6;
             }
            }
           }
           $$01416$i$i87 = HEAP32[28884]|0;
           $96 = ($$01416$i$i87|0)==(0|0); //@line 277 "./../prefs.cpp"
           L45: do {
            if (!($96)) {
             $$01418$i$i88 = $$01416$i$i87;
             while(1) {
              $97 = ((($$01418$i$i88)) + 8|0); //@line 278 "./../prefs.cpp"
              $98 = HEAP32[$97>>2]|0; //@line 278 "./../prefs.cpp"
              $99 = ($98|0)==(1); //@line 278 "./../prefs.cpp"
              if ($99) {
               $100 = ((($$01418$i$i88)) + 4|0); //@line 278 "./../prefs.cpp"
               $101 = HEAP32[$100>>2]|0; //@line 278 "./../prefs.cpp"
               $102 = (_strcmp($101,$19)|0); //@line 278 "./../prefs.cpp"
               $103 = ($102|0)==(0); //@line 278 "./../prefs.cpp"
               if ($103) {
                break;
               }
              }
              $$014$i$i90 = HEAP32[$$01418$i$i88>>2]|0;
              $104 = ($$014$i$i90|0)==(0|0); //@line 277 "./../prefs.cpp"
              if ($104) {
               break L45;
              } else {
               $$01418$i$i88 = $$014$i$i90;
              }
             }
             $105 = ((($$01418$i$i88)) + 12|0); //@line 303 "./../prefs.cpp"
             $106 = HEAP32[$105>>2]|0; //@line 303 "./../prefs.cpp"
             HEAP8[$106>>0] = 0; //@line 303 "./../prefs.cpp"
             $$2 = $38;
             break L6;
            }
           } while(0);
           $107 = (_malloc(1)|0); //@line 235 "./../prefs.cpp"
           $108 = ($107|0)==(0|0); //@line 236 "./../prefs.cpp"
           if ($108) {
            $$2 = $38;
            break L6;
           }
           HEAP8[$107>>0] = 0; //@line 238 "./../prefs.cpp"
           $109 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
           HEAP32[$109>>2] = 0; //@line 240 "./../prefs.cpp"
           $110 = (___strdup($19)|0); //@line 241 "./../prefs.cpp"
           $111 = ((($109)) + 4|0); //@line 241 "./../prefs.cpp"
           HEAP32[$111>>2] = $110; //@line 241 "./../prefs.cpp"
           $112 = ((($109)) + 8|0); //@line 242 "./../prefs.cpp"
           HEAP32[$112>>2] = 1; //@line 242 "./../prefs.cpp"
           $113 = ((($109)) + 12|0); //@line 243 "./../prefs.cpp"
           HEAP32[$113>>2] = $107; //@line 243 "./../prefs.cpp"
           $114 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
           $115 = ($114|0)==(0|0); //@line 244 "./../prefs.cpp"
           if ($115) {
            $$sink$i$i95 = 115536;
           } else {
            $$0$i$i93 = $114;
            while(1) {
             $116 = HEAP32[$$0$i$i93>>2]|0; //@line 246 "./../prefs.cpp"
             $117 = ($116|0)==(0|0); //@line 246 "./../prefs.cpp"
             if ($117) {
              break;
             } else {
              $$0$i$i93 = $116;
             }
            }
            $$sink$i$i95 = $$0$i$i93;
           }
           HEAP32[$$sink$i$i95>>2] = $109;
           $$2 = $38;
           break L6;
          }
         }
        }
        $$01416$i$i = HEAP32[28884]|0;
        $68 = ($$01416$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
        L60: do {
         if (!($68)) {
          $$01418$i$i = $$01416$i$i;
          while(1) {
           $69 = ((($$01418$i$i)) + 8|0); //@line 278 "./../prefs.cpp"
           $70 = HEAP32[$69>>2]|0; //@line 278 "./../prefs.cpp"
           $71 = ($70|0)==(1); //@line 278 "./../prefs.cpp"
           if ($71) {
            $72 = ((($$01418$i$i)) + 4|0); //@line 278 "./../prefs.cpp"
            $73 = HEAP32[$72>>2]|0; //@line 278 "./../prefs.cpp"
            $74 = (_strcmp($73,$19)|0); //@line 278 "./../prefs.cpp"
            $75 = ($74|0)==(0); //@line 278 "./../prefs.cpp"
            if ($75) {
             break;
            }
           }
           $$014$i$i = HEAP32[$$01418$i$i>>2]|0;
           $76 = ($$014$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
           if ($76) {
            break L60;
           } else {
            $$01418$i$i = $$014$i$i;
           }
          }
          $77 = ((($$01418$i$i)) + 12|0); //@line 303 "./../prefs.cpp"
          $78 = HEAP32[$77>>2]|0; //@line 303 "./../prefs.cpp"
          HEAP8[$78>>0] = 1; //@line 303 "./../prefs.cpp"
          $$2 = $38;
          break L6;
         }
        } while(0);
        $79 = (_malloc(1)|0); //@line 235 "./../prefs.cpp"
        $80 = ($79|0)==(0|0); //@line 236 "./../prefs.cpp"
        if ($80) {
         $$2 = $38;
         break L6;
        }
        HEAP8[$79>>0] = 1; //@line 238 "./../prefs.cpp"
        $81 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
        HEAP32[$81>>2] = 0; //@line 240 "./../prefs.cpp"
        $82 = (___strdup($19)|0); //@line 241 "./../prefs.cpp"
        $83 = ((($81)) + 4|0); //@line 241 "./../prefs.cpp"
        HEAP32[$83>>2] = $82; //@line 241 "./../prefs.cpp"
        $84 = ((($81)) + 8|0); //@line 242 "./../prefs.cpp"
        HEAP32[$84>>2] = 1; //@line 242 "./../prefs.cpp"
        $85 = ((($81)) + 12|0); //@line 243 "./../prefs.cpp"
        HEAP32[$85>>2] = $79; //@line 243 "./../prefs.cpp"
        $86 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
        $87 = ($86|0)==(0|0); //@line 244 "./../prefs.cpp"
        if ($87) {
         $$sink$i$i86 = 115536;
        } else {
         $$0$i$i84 = $86;
         while(1) {
          $88 = HEAP32[$$0$i$i84>>2]|0; //@line 246 "./../prefs.cpp"
          $89 = ($88|0)==(0|0); //@line 246 "./../prefs.cpp"
          if ($89) {
           break;
          } else {
           $$0$i$i84 = $88;
          }
         }
         $$sink$i$i86 = $$0$i$i84;
        }
        HEAP32[$$sink$i$i86>>2] = $81;
        $$2 = $38;
        break L6;
        break;
       }
       case 2:  {
        $118 = (_atoi($43)|0); //@line 103 "./../prefs.cpp"
        $$01416$i$i97 = HEAP32[28884]|0;
        $119 = ($$01416$i$i97|0)==(0|0); //@line 277 "./../prefs.cpp"
        L75: do {
         if (!($119)) {
          $$01418$i$i98 = $$01416$i$i97;
          while(1) {
           $120 = ((($$01418$i$i98)) + 8|0); //@line 278 "./../prefs.cpp"
           $121 = HEAP32[$120>>2]|0; //@line 278 "./../prefs.cpp"
           $122 = ($121|0)==(2); //@line 278 "./../prefs.cpp"
           if ($122) {
            $123 = ((($$01418$i$i98)) + 4|0); //@line 278 "./../prefs.cpp"
            $124 = HEAP32[$123>>2]|0; //@line 278 "./../prefs.cpp"
            $125 = (_strcmp($124,$19)|0); //@line 278 "./../prefs.cpp"
            $126 = ($125|0)==(0); //@line 278 "./../prefs.cpp"
            if ($126) {
             break;
            }
           }
           $$014$i$i100 = HEAP32[$$01418$i$i98>>2]|0;
           $127 = ($$014$i$i100|0)==(0|0); //@line 277 "./../prefs.cpp"
           if ($127) {
            break L75;
           } else {
            $$01418$i$i98 = $$014$i$i100;
           }
          }
          $128 = ((($$01418$i$i98)) + 12|0); //@line 312 "./../prefs.cpp"
          $129 = HEAP32[$128>>2]|0; //@line 312 "./../prefs.cpp"
          HEAP32[$129>>2] = $118; //@line 312 "./../prefs.cpp"
          $$2 = $38;
          break L6;
         }
        } while(0);
        $130 = (_malloc(4)|0); //@line 235 "./../prefs.cpp"
        $131 = ($130|0)==(0|0); //@line 236 "./../prefs.cpp"
        if ($131) {
         $$2 = $38;
         break L6;
        }
        HEAP8[$130>>0]=$118&255;HEAP8[$130+1>>0]=($118>>8)&255;HEAP8[$130+2>>0]=($118>>16)&255;HEAP8[$130+3>>0]=$118>>24; //@line 238 "./../prefs.cpp"
        $132 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
        HEAP32[$132>>2] = 0; //@line 240 "./../prefs.cpp"
        $133 = (___strdup($19)|0); //@line 241 "./../prefs.cpp"
        $134 = ((($132)) + 4|0); //@line 241 "./../prefs.cpp"
        HEAP32[$134>>2] = $133; //@line 241 "./../prefs.cpp"
        $135 = ((($132)) + 8|0); //@line 242 "./../prefs.cpp"
        HEAP32[$135>>2] = 2; //@line 242 "./../prefs.cpp"
        $136 = ((($132)) + 12|0); //@line 243 "./../prefs.cpp"
        HEAP32[$136>>2] = $130; //@line 243 "./../prefs.cpp"
        $137 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
        $138 = ($137|0)==(0|0); //@line 244 "./../prefs.cpp"
        if ($138) {
         $$sink$i$i105 = 115536;
        } else {
         $$0$i$i103 = $137;
         while(1) {
          $139 = HEAP32[$$0$i$i103>>2]|0; //@line 246 "./../prefs.cpp"
          $140 = ($139|0)==(0|0); //@line 246 "./../prefs.cpp"
          if ($140) {
           break;
          } else {
           $$0$i$i103 = $139;
          }
         }
         $$sink$i$i105 = $$0$i$i103;
        }
        HEAP32[$$sink$i$i105>>2] = $132;
        $$2 = $38;
        break L6;
        break;
       }
       default: {
        $$2 = $38;
        break L6;
       }
       }
      } else {
       $$2 = $$080123;
      }
     } else {
      $$2 = $$080123;
     }
    }
   }
  } while(0);
  $141 = (($$2) + 1)|0; //@line 60 "./../prefs.cpp"
  $6 = HEAP32[$1>>2]|0; //@line 60 "./../prefs.cpp"
  $142 = ($141|0)<($6|0); //@line 60 "./../prefs.cpp"
  if ($142) {
   $$080123 = $141;$40 = $6;
  } else {
   break;
  }
 }
 $7 = ($6|0)>(1); //@line 112 "./../prefs.cpp"
 if ($7) {
  $$079121 = 1;$144 = $6;
 } else {
  STACKTOP = sp;return; //@line 129 "./../prefs.cpp"
 }
 while(1) {
  $143 = ($$079121|0)<($144|0); //@line 114 "./../prefs.cpp"
  if ($143) {
   $145 = HEAP32[$2>>2]|0;
   $$078113 = $$079121;
   while(1) {
    $146 = (($145) + ($$078113<<2)|0); //@line 115 "./../prefs.cpp"
    $147 = HEAP32[$146>>2]|0; //@line 115 "./../prefs.cpp"
    $148 = ($147|0)==(0|0); //@line 115 "./../prefs.cpp"
    if (!($148)) {
     $$078$lcssa = $$078113;
     break;
    }
    $149 = (($$078113) + 1)|0; //@line 114 "./../prefs.cpp"
    $150 = ($149|0)<($144|0); //@line 114 "./../prefs.cpp"
    if ($150) {
     $$078113 = $149;
    } else {
     $$078$lcssa = $149;
     break;
    }
   }
   $151 = ($$078$lcssa|0)>($$079121|0); //@line 117 "./../prefs.cpp"
   if ($151) {
    $152 = (($$078$lcssa) - ($$079121))|0; //@line 118 "./../prefs.cpp"
    $153 = ($$078$lcssa|0)<($144|0); //@line 119 "./../prefs.cpp"
    if ($153) {
     $$0116 = $$078$lcssa;
     while(1) {
      $155 = HEAP32[$2>>2]|0; //@line 120 "./../prefs.cpp"
      $156 = (($155) + ($$0116<<2)|0); //@line 120 "./../prefs.cpp"
      $157 = HEAP32[$156>>2]|0; //@line 120 "./../prefs.cpp"
      $158 = (($$0116) - ($152))|0; //@line 120 "./../prefs.cpp"
      $159 = (($155) + ($158<<2)|0); //@line 120 "./../prefs.cpp"
      HEAP32[$159>>2] = $157; //@line 120 "./../prefs.cpp"
      $160 = (($$0116) + 1)|0; //@line 119 "./../prefs.cpp"
      $161 = ($160|0)<($144|0); //@line 119 "./../prefs.cpp"
      if ($161) {
       $$0116 = $160;
      } else {
       break;
      }
     }
    }
    $154 = (($144) - ($152))|0; //@line 121 "./../prefs.cpp"
    HEAP32[$1>>2] = $154; //@line 121 "./../prefs.cpp"
    $164 = $154;
   } else {
    $164 = $144;
   }
  } else {
   $164 = $144;
  }
  $162 = (($$079121) + 1)|0; //@line 112 "./../prefs.cpp"
  $163 = ($162|0)<($164|0); //@line 112 "./../prefs.cpp"
  if ($163) {
   $$079121 = $162;$144 = $164;
  } else {
   break;
  }
 }
 STACKTOP = sp;return; //@line 129 "./../prefs.cpp"
}
function __Z18PrefsReplaceStringPKcS0_i($0,$1,$2) {
 $0 = $0|0;
 $1 = $1|0;
 $2 = $2|0;
 var $$0$i = 0, $$014$i = 0, $$01416$i = 0, $$01418$i = 0, $$017$i = 0, $$1$i = 0, $$sink$i = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $$01416$i = HEAP32[28884]|0;
 $3 = ($$01416$i|0)==(0|0); //@line 277 "./../prefs.cpp"
 L1: do {
  if (!($3)) {
   $$01418$i = $$01416$i;$$017$i = 0;
   while(1) {
    $4 = ((($$01418$i)) + 8|0); //@line 278 "./../prefs.cpp"
    $5 = HEAP32[$4>>2]|0; //@line 278 "./../prefs.cpp"
    $6 = ($5|0)==(0); //@line 278 "./../prefs.cpp"
    if ($6) {
     $7 = ((($$01418$i)) + 4|0); //@line 278 "./../prefs.cpp"
     $8 = HEAP32[$7>>2]|0; //@line 278 "./../prefs.cpp"
     $9 = (_strcmp($8,$0)|0); //@line 278 "./../prefs.cpp"
     $10 = ($9|0)==(0); //@line 278 "./../prefs.cpp"
     if ($10) {
      $11 = ($$017$i|0)==($2|0); //@line 279 "./../prefs.cpp"
      if ($11) {
       break;
      }
      $12 = (($$017$i) + 1)|0; //@line 282 "./../prefs.cpp"
      $$1$i = $12;
     } else {
      $$1$i = $$017$i;
     }
    } else {
     $$1$i = $$017$i;
    }
    $$014$i = HEAP32[$$01418$i>>2]|0;
    $13 = ($$014$i|0)==(0|0); //@line 277 "./../prefs.cpp"
    if ($13) {
     break L1;
    } else {
     $$01418$i = $$014$i;$$017$i = $$1$i;
    }
   }
   $14 = ((($$01418$i)) + 12|0); //@line 293 "./../prefs.cpp"
   $15 = HEAP32[$14>>2]|0; //@line 293 "./../prefs.cpp"
   _free($15); //@line 293 "./../prefs.cpp"
   $16 = (___strdup($1)|0); //@line 294 "./../prefs.cpp"
   HEAP32[$14>>2] = $16; //@line 294 "./../prefs.cpp"
   return; //@line 297 "./../prefs.cpp"
  }
 } while(0);
 $17 = (_strlen($1)|0); //@line 296 "./../prefs.cpp"
 $18 = (($17) + 1)|0; //@line 296 "./../prefs.cpp"
 $19 = (_malloc($18)|0); //@line 235 "./../prefs.cpp"
 $20 = ($19|0)==(0|0); //@line 236 "./../prefs.cpp"
 if ($20) {
  return; //@line 297 "./../prefs.cpp"
 }
 _memcpy(($19|0),($1|0),($18|0))|0; //@line 238 "./../prefs.cpp"
 $21 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
 HEAP32[$21>>2] = 0; //@line 240 "./../prefs.cpp"
 $22 = (___strdup($0)|0); //@line 241 "./../prefs.cpp"
 $23 = ((($21)) + 4|0); //@line 241 "./../prefs.cpp"
 HEAP32[$23>>2] = $22; //@line 241 "./../prefs.cpp"
 $24 = ((($21)) + 8|0); //@line 242 "./../prefs.cpp"
 HEAP32[$24>>2] = 0; //@line 242 "./../prefs.cpp"
 $25 = ((($21)) + 12|0); //@line 243 "./../prefs.cpp"
 HEAP32[$25>>2] = $19; //@line 243 "./../prefs.cpp"
 $26 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
 $27 = ($26|0)==(0|0); //@line 244 "./../prefs.cpp"
 if ($27) {
  $$sink$i = 115536;
 } else {
  $$0$i = $26;
  while(1) {
   $28 = HEAP32[$$0$i>>2]|0; //@line 246 "./../prefs.cpp"
   $29 = ($28|0)==(0|0); //@line 246 "./../prefs.cpp"
   if ($29) {
    break;
   } else {
    $$0$i = $28;
   }
  }
  $$sink$i = $$0$i;
 }
 HEAP32[$$sink$i>>2] = $21;
 return; //@line 297 "./../prefs.cpp"
}
function __Z14PrefsAddStringPKcS0_($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$0$i = 0, $$sink$i = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $2 = (_strlen($1)|0); //@line 255 "./../prefs.cpp"
 $3 = (($2) + 1)|0; //@line 255 "./../prefs.cpp"
 $4 = (_malloc($3)|0); //@line 235 "./../prefs.cpp"
 $5 = ($4|0)==(0|0); //@line 236 "./../prefs.cpp"
 if ($5) {
  return; //@line 256 "./../prefs.cpp"
 }
 _memcpy(($4|0),($1|0),($3|0))|0; //@line 238 "./../prefs.cpp"
 $6 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
 HEAP32[$6>>2] = 0; //@line 240 "./../prefs.cpp"
 $7 = (___strdup($0)|0); //@line 241 "./../prefs.cpp"
 $8 = ((($6)) + 4|0); //@line 241 "./../prefs.cpp"
 HEAP32[$8>>2] = $7; //@line 241 "./../prefs.cpp"
 $9 = ((($6)) + 8|0); //@line 242 "./../prefs.cpp"
 HEAP32[$9>>2] = 0; //@line 242 "./../prefs.cpp"
 $10 = ((($6)) + 12|0); //@line 243 "./../prefs.cpp"
 HEAP32[$10>>2] = $4; //@line 243 "./../prefs.cpp"
 $11 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
 $12 = ($11|0)==(0|0); //@line 244 "./../prefs.cpp"
 if ($12) {
  $$sink$i = 115536;
 } else {
  $$0$i = $11;
  while(1) {
   $13 = HEAP32[$$0$i>>2]|0; //@line 246 "./../prefs.cpp"
   $14 = ($13|0)==(0|0); //@line 246 "./../prefs.cpp"
   if ($14) {
    break;
   } else {
    $$0$i = $13;
   }
  }
  $$sink$i = $$0$i;
 }
 HEAP32[$$sink$i>>2] = $6;
 return; //@line 256 "./../prefs.cpp"
}
function __Z16PrefsReplaceBoolPKcb($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$0$i = 0, $$014$i = 0, $$01416$i = 0, $$01418$i = 0, $$sink$i = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $24 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $2 = $1&1;
 $$01416$i = HEAP32[28884]|0;
 $3 = ($$01416$i|0)==(0|0); //@line 277 "./../prefs.cpp"
 L1: do {
  if (!($3)) {
   $$01418$i = $$01416$i;
   while(1) {
    $4 = ((($$01418$i)) + 8|0); //@line 278 "./../prefs.cpp"
    $5 = HEAP32[$4>>2]|0; //@line 278 "./../prefs.cpp"
    $6 = ($5|0)==(1); //@line 278 "./../prefs.cpp"
    if ($6) {
     $7 = ((($$01418$i)) + 4|0); //@line 278 "./../prefs.cpp"
     $8 = HEAP32[$7>>2]|0; //@line 278 "./../prefs.cpp"
     $9 = (_strcmp($8,$0)|0); //@line 278 "./../prefs.cpp"
     $10 = ($9|0)==(0); //@line 278 "./../prefs.cpp"
     if ($10) {
      break;
     }
    }
    $$014$i = HEAP32[$$01418$i>>2]|0;
    $11 = ($$014$i|0)==(0|0); //@line 277 "./../prefs.cpp"
    if ($11) {
     break L1;
    } else {
     $$01418$i = $$014$i;
    }
   }
   $12 = ((($$01418$i)) + 12|0); //@line 303 "./../prefs.cpp"
   $13 = HEAP32[$12>>2]|0; //@line 303 "./../prefs.cpp"
   HEAP8[$13>>0] = $2; //@line 303 "./../prefs.cpp"
   return; //@line 306 "./../prefs.cpp"
  }
 } while(0);
 $14 = (_malloc(1)|0); //@line 235 "./../prefs.cpp"
 $15 = ($14|0)==(0|0); //@line 236 "./../prefs.cpp"
 if ($15) {
  return; //@line 306 "./../prefs.cpp"
 }
 HEAP8[$14>>0] = $2; //@line 238 "./../prefs.cpp"
 $16 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
 HEAP32[$16>>2] = 0; //@line 240 "./../prefs.cpp"
 $17 = (___strdup($0)|0); //@line 241 "./../prefs.cpp"
 $18 = ((($16)) + 4|0); //@line 241 "./../prefs.cpp"
 HEAP32[$18>>2] = $17; //@line 241 "./../prefs.cpp"
 $19 = ((($16)) + 8|0); //@line 242 "./../prefs.cpp"
 HEAP32[$19>>2] = 1; //@line 242 "./../prefs.cpp"
 $20 = ((($16)) + 12|0); //@line 243 "./../prefs.cpp"
 HEAP32[$20>>2] = $14; //@line 243 "./../prefs.cpp"
 $21 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
 $22 = ($21|0)==(0|0); //@line 244 "./../prefs.cpp"
 if ($22) {
  $$sink$i = 115536;
 } else {
  $$0$i = $21;
  while(1) {
   $23 = HEAP32[$$0$i>>2]|0; //@line 246 "./../prefs.cpp"
   $24 = ($23|0)==(0|0); //@line 246 "./../prefs.cpp"
   if ($24) {
    break;
   } else {
    $$0$i = $23;
   }
  }
  $$sink$i = $$0$i;
 }
 HEAP32[$$sink$i>>2] = $16;
 return; //@line 306 "./../prefs.cpp"
}
function __Z17PrefsReplaceInt32PKci($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$0$i = 0, $$014$i = 0, $$01416$i = 0, $$01418$i = 0, $$sink$i = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0;
 var $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $$01416$i = HEAP32[28884]|0;
 $2 = ($$01416$i|0)==(0|0); //@line 277 "./../prefs.cpp"
 L1: do {
  if (!($2)) {
   $$01418$i = $$01416$i;
   while(1) {
    $3 = ((($$01418$i)) + 8|0); //@line 278 "./../prefs.cpp"
    $4 = HEAP32[$3>>2]|0; //@line 278 "./../prefs.cpp"
    $5 = ($4|0)==(2); //@line 278 "./../prefs.cpp"
    if ($5) {
     $6 = ((($$01418$i)) + 4|0); //@line 278 "./../prefs.cpp"
     $7 = HEAP32[$6>>2]|0; //@line 278 "./../prefs.cpp"
     $8 = (_strcmp($7,$0)|0); //@line 278 "./../prefs.cpp"
     $9 = ($8|0)==(0); //@line 278 "./../prefs.cpp"
     if ($9) {
      break;
     }
    }
    $$014$i = HEAP32[$$01418$i>>2]|0;
    $10 = ($$014$i|0)==(0|0); //@line 277 "./../prefs.cpp"
    if ($10) {
     break L1;
    } else {
     $$01418$i = $$014$i;
    }
   }
   $11 = ((($$01418$i)) + 12|0); //@line 312 "./../prefs.cpp"
   $12 = HEAP32[$11>>2]|0; //@line 312 "./../prefs.cpp"
   HEAP32[$12>>2] = $1; //@line 312 "./../prefs.cpp"
   return; //@line 315 "./../prefs.cpp"
  }
 } while(0);
 $13 = (_malloc(4)|0); //@line 235 "./../prefs.cpp"
 $14 = ($13|0)==(0|0); //@line 236 "./../prefs.cpp"
 if ($14) {
  return; //@line 315 "./../prefs.cpp"
 }
 HEAP8[$13>>0]=$1&255;HEAP8[$13+1>>0]=($1>>8)&255;HEAP8[$13+2>>0]=($1>>16)&255;HEAP8[$13+3>>0]=$1>>24; //@line 238 "./../prefs.cpp"
 $15 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
 HEAP32[$15>>2] = 0; //@line 240 "./../prefs.cpp"
 $16 = (___strdup($0)|0); //@line 241 "./../prefs.cpp"
 $17 = ((($15)) + 4|0); //@line 241 "./../prefs.cpp"
 HEAP32[$17>>2] = $16; //@line 241 "./../prefs.cpp"
 $18 = ((($15)) + 8|0); //@line 242 "./../prefs.cpp"
 HEAP32[$18>>2] = 2; //@line 242 "./../prefs.cpp"
 $19 = ((($15)) + 12|0); //@line 243 "./../prefs.cpp"
 HEAP32[$19>>2] = $13; //@line 243 "./../prefs.cpp"
 $20 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
 $21 = ($20|0)==(0|0); //@line 244 "./../prefs.cpp"
 if ($21) {
  $$sink$i = 115536;
 } else {
  $$0$i = $20;
  while(1) {
   $22 = HEAP32[$$0$i>>2]|0; //@line 246 "./../prefs.cpp"
   $23 = ($22|0)==(0|0); //@line 246 "./../prefs.cpp"
   if ($23) {
    break;
   } else {
    $$0$i = $22;
   }
  }
  $$sink$i = $$0$i;
 }
 HEAP32[$$sink$i>>2] = $15;
 return; //@line 315 "./../prefs.cpp"
}
function __Z9PrefsExitv() {
 var $$in910 = 0, $0 = 0, $1 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $0 = HEAP32[28884]|0; //@line 144 "./../prefs.cpp"
 $1 = ($0|0)==(0|0); //@line 145 "./../prefs.cpp"
 if ($1) {
  HEAP32[28884] = 0; //@line 152 "./../prefs.cpp"
  return; //@line 153 "./../prefs.cpp"
 } else {
  $$in910 = $0;
 }
 while(1) {
  $2 = HEAP32[$$in910>>2]|0; //@line 146 "./../prefs.cpp"
  $3 = ((($$in910)) + 4|0); //@line 147 "./../prefs.cpp"
  $4 = HEAP32[$3>>2]|0; //@line 147 "./../prefs.cpp"
  _free($4); //@line 147 "./../prefs.cpp"
  $5 = ((($$in910)) + 12|0); //@line 148 "./../prefs.cpp"
  $6 = HEAP32[$5>>2]|0; //@line 148 "./../prefs.cpp"
  _free($6); //@line 148 "./../prefs.cpp"
  __ZdlPv($$in910); //@line 149 "./../prefs.cpp"
  $7 = ($2|0)==(0|0); //@line 145 "./../prefs.cpp"
  if ($7) {
   break;
  } else {
   $$in910 = $2;
  }
 }
 HEAP32[28884] = 0; //@line 152 "./../prefs.cpp"
 return; //@line 153 "./../prefs.cpp"
}
function __Z15PrefsPrintUsagev() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 (_puts(89173)|0); //@line 198 "./../prefs.cpp"
 __ZL13print_optionsPK10prefs_desc(432); //@line 199 "./../prefs.cpp"
 (_puts(89191)|0); //@line 200 "./../prefs.cpp"
 __ZL13print_optionsPK10prefs_desc(5360); //@line 201 "./../prefs.cpp"
 (_puts(89219)|0); //@line 202 "./../prefs.cpp"
 return; //@line 203 "./../prefs.cpp"
}
function __ZL13print_optionsPK10prefs_desc($0) {
 $0 = $0|0;
 var $$ = 0, $$0 = 0, $$0$i = 0, $$0$i29 = 0, $$014$i$i = 0, $$014$i$i21 = 0, $$014$i$i27 = 0, $$01416$i$i = 0, $$01416$i$i18 = 0, $$01416$i$i24 = 0, $$01418$i$i = 0, $$01418$i$i19 = 0, $$01418$i$i25 = 0, $$015 = 0, $$01634 = 0, $$30 = 0, $$pre = 0, $$pre$phiZ2D = 0, $1 = 0, $10 = 0;
 var $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0;
 var $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0;
 var $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_ptr4 = 0, $vararg_ptr5 = 0, $vararg_ptr6 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 64|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(64|0);
 $vararg_buffer1 = sp + 8|0;
 $vararg_buffer = sp;
 $1 = sp + 24|0;
 $2 = ((($0)) + 4|0); //@line 162 "./../prefs.cpp"
 $3 = HEAP32[$2>>2]|0; //@line 162 "./../prefs.cpp"
 $4 = ($3|0)==(3); //@line 162 "./../prefs.cpp"
 if ($4) {
  STACKTOP = sp;return; //@line 194 "./../prefs.cpp"
 }
 $$01634 = $0;$8 = $3;
 while(1) {
  $5 = ((($$01634)) + 12|0); //@line 163 "./../prefs.cpp"
  $6 = HEAP32[$5>>2]|0; //@line 163 "./../prefs.cpp"
  $7 = ($6|0)==(0|0); //@line 163 "./../prefs.cpp"
  if (!($7)) {
   L8: do {
    switch ($8|0) {
    case 0:  {
     $9 = HEAP32[$$01634>>2]|0; //@line 169 "./../prefs.cpp"
     $$01416$i$i = HEAP32[28884]|0;
     $10 = ($$01416$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
     L11: do {
      if ($10) {
       $$0$i = 0;
      } else {
       $$01418$i$i = $$01416$i$i;
       while(1) {
        $11 = ((($$01418$i$i)) + 8|0); //@line 278 "./../prefs.cpp"
        $12 = HEAP32[$11>>2]|0; //@line 278 "./../prefs.cpp"
        $13 = ($12|0)==(0); //@line 278 "./../prefs.cpp"
        if ($13) {
         $14 = ((($$01418$i$i)) + 4|0); //@line 278 "./../prefs.cpp"
         $15 = HEAP32[$14>>2]|0; //@line 278 "./../prefs.cpp"
         $16 = (_strcmp($15,$9)|0); //@line 278 "./../prefs.cpp"
         $17 = ($16|0)==(0); //@line 278 "./../prefs.cpp"
         if ($17) {
          break;
         }
        }
        $$014$i$i = HEAP32[$$01418$i$i>>2]|0;
        $18 = ($$014$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
        if ($18) {
         $$0$i = 0;
         break L11;
        } else {
         $$01418$i$i = $$014$i$i;
        }
       }
       $19 = ((($$01418$i$i)) + 12|0); //@line 326 "./../prefs.cpp"
       $20 = HEAP32[$19>>2]|0; //@line 326 "./../prefs.cpp"
       $$0$i = $20;
      }
     } while(0);
     $21 = ($$0$i|0)==(0|0); //@line 170 "./../prefs.cpp"
     $$ = $21 ? 89311 : $$0$i; //@line 170 "./../prefs.cpp"
     $$0 = $$;$$015 = 89304;$$pre$phiZ2D = $$01634;$50 = $6;
     break;
    }
    case 1:  {
     $22 = HEAP32[$$01634>>2]|0; //@line 175 "./../prefs.cpp"
     $$01416$i$i18 = HEAP32[28884]|0;
     $23 = ($$01416$i$i18|0)==(0|0); //@line 277 "./../prefs.cpp"
     if ($23) {
      $$0 = 114705;$$015 = 89316;$$pre$phiZ2D = $$01634;$50 = $6;
     } else {
      $$01418$i$i19 = $$01416$i$i18;
      while(1) {
       $24 = ((($$01418$i$i19)) + 8|0); //@line 278 "./../prefs.cpp"
       $25 = HEAP32[$24>>2]|0; //@line 278 "./../prefs.cpp"
       $26 = ($25|0)==(1); //@line 278 "./../prefs.cpp"
       if ($26) {
        $27 = ((($$01418$i$i19)) + 4|0); //@line 278 "./../prefs.cpp"
        $28 = HEAP32[$27>>2]|0; //@line 278 "./../prefs.cpp"
        $29 = (_strcmp($28,$22)|0); //@line 278 "./../prefs.cpp"
        $30 = ($29|0)==(0); //@line 278 "./../prefs.cpp"
        if ($30) {
         break;
        }
       }
       $$014$i$i21 = HEAP32[$$01418$i$i19>>2]|0;
       $31 = ($$014$i$i21|0)==(0|0); //@line 277 "./../prefs.cpp"
       if ($31) {
        $$0 = 114705;$$015 = 89316;$$pre$phiZ2D = $$01634;$50 = $6;
        break L8;
       } else {
        $$01418$i$i19 = $$014$i$i21;
       }
      }
      $32 = ((($$01418$i$i19)) + 12|0); //@line 335 "./../prefs.cpp"
      $33 = HEAP32[$32>>2]|0; //@line 335 "./../prefs.cpp"
      $34 = HEAP8[$33>>0]|0; //@line 335 "./../prefs.cpp"
      $35 = ($34<<24>>24)!=(0); //@line 335 "./../prefs.cpp"
      $$30 = $35 ? 114711 : 114705; //@line 176 "./../prefs.cpp"
      $$0 = $$30;$$015 = 89316;$$pre$phiZ2D = $$01634;$50 = $6;
     }
     break;
    }
    case 2:  {
     $36 = HEAP32[$$01634>>2]|0; //@line 182 "./../prefs.cpp"
     $$01416$i$i24 = HEAP32[28884]|0;
     $37 = ($$01416$i$i24|0)==(0|0); //@line 277 "./../prefs.cpp"
     L27: do {
      if ($37) {
       $$0$i29 = 0;
      } else {
       $$01418$i$i25 = $$01416$i$i24;
       while(1) {
        $38 = ((($$01418$i$i25)) + 8|0); //@line 278 "./../prefs.cpp"
        $39 = HEAP32[$38>>2]|0; //@line 278 "./../prefs.cpp"
        $40 = ($39|0)==(2); //@line 278 "./../prefs.cpp"
        if ($40) {
         $41 = ((($$01418$i$i25)) + 4|0); //@line 278 "./../prefs.cpp"
         $42 = HEAP32[$41>>2]|0; //@line 278 "./../prefs.cpp"
         $43 = (_strcmp($42,$36)|0); //@line 278 "./../prefs.cpp"
         $44 = ($43|0)==(0); //@line 278 "./../prefs.cpp"
         if ($44) {
          break;
         }
        }
        $$014$i$i27 = HEAP32[$$01418$i$i25>>2]|0;
        $45 = ($$014$i$i27|0)==(0|0); //@line 277 "./../prefs.cpp"
        if ($45) {
         $$0$i29 = 0;
         break L27;
        } else {
         $$01418$i$i25 = $$014$i$i27;
        }
       }
       $46 = ((($$01418$i$i25)) + 12|0); //@line 344 "./../prefs.cpp"
       $47 = HEAP32[$46>>2]|0; //@line 344 "./../prefs.cpp"
       $48 = HEAP32[$47>>2]|0; //@line 344 "./../prefs.cpp"
       $$0$i29 = $48;
      }
     } while(0);
     HEAP32[$vararg_buffer>>2] = $$0$i29; //@line 182 "./../prefs.cpp"
     (_sprintf($1,89328,$vararg_buffer)|0); //@line 182 "./../prefs.cpp"
     $$pre = HEAP32[$5>>2]|0;
     $$0 = $1;$$015 = 89321;$$pre$phiZ2D = $$01634;$50 = $$pre;
     break;
    }
    default: {
     $$0 = 89311;$$015 = 89331;$$pre$phiZ2D = $$01634;$50 = $6;
    }
    }
   } while(0);
   $49 = HEAP32[$$pre$phiZ2D>>2]|0; //@line 190 "./../prefs.cpp"
   HEAP32[$vararg_buffer1>>2] = $49; //@line 190 "./../prefs.cpp"
   $vararg_ptr4 = ((($vararg_buffer1)) + 4|0); //@line 190 "./../prefs.cpp"
   HEAP32[$vararg_ptr4>>2] = $$015; //@line 190 "./../prefs.cpp"
   $vararg_ptr5 = ((($vararg_buffer1)) + 8|0); //@line 190 "./../prefs.cpp"
   HEAP32[$vararg_ptr5>>2] = $50; //@line 190 "./../prefs.cpp"
   $vararg_ptr6 = ((($vararg_buffer1)) + 12|0); //@line 190 "./../prefs.cpp"
   HEAP32[$vararg_ptr6>>2] = $$0; //@line 190 "./../prefs.cpp"
   (_printf(89341,$vararg_buffer1)|0); //@line 190 "./../prefs.cpp"
  }
  $51 = ((($$01634)) + 16|0); //@line 192 "./../prefs.cpp"
  $52 = ((($$01634)) + 20|0); //@line 162 "./../prefs.cpp"
  $53 = HEAP32[$52>>2]|0; //@line 162 "./../prefs.cpp"
  $54 = ($53|0)==(3); //@line 162 "./../prefs.cpp"
  if ($54) {
   break;
  } else {
   $$01634 = $51;$8 = $53;
  }
 }
 STACKTOP = sp;return; //@line 194 "./../prefs.cpp"
}
function __Z12PrefsAddBoolPKcb($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$0$i = 0, $$sink$i = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $2 = (_malloc(1)|0); //@line 235 "./../prefs.cpp"
 $3 = ($2|0)==(0|0); //@line 236 "./../prefs.cpp"
 if ($3) {
  return; //@line 261 "./../prefs.cpp"
 }
 $4 = $1&1;
 HEAP8[$2>>0] = $4; //@line 238 "./../prefs.cpp"
 $5 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
 HEAP32[$5>>2] = 0; //@line 240 "./../prefs.cpp"
 $6 = (___strdup($0)|0); //@line 241 "./../prefs.cpp"
 $7 = ((($5)) + 4|0); //@line 241 "./../prefs.cpp"
 HEAP32[$7>>2] = $6; //@line 241 "./../prefs.cpp"
 $8 = ((($5)) + 8|0); //@line 242 "./../prefs.cpp"
 HEAP32[$8>>2] = 1; //@line 242 "./../prefs.cpp"
 $9 = ((($5)) + 12|0); //@line 243 "./../prefs.cpp"
 HEAP32[$9>>2] = $2; //@line 243 "./../prefs.cpp"
 $10 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
 $11 = ($10|0)==(0|0); //@line 244 "./../prefs.cpp"
 if ($11) {
  $$sink$i = 115536;
 } else {
  $$0$i = $10;
  while(1) {
   $12 = HEAP32[$$0$i>>2]|0; //@line 246 "./../prefs.cpp"
   $13 = ($12|0)==(0|0); //@line 246 "./../prefs.cpp"
   if ($13) {
    break;
   } else {
    $$0$i = $12;
   }
  }
  $$sink$i = $$0$i;
 }
 HEAP32[$$sink$i>>2] = $5;
 return; //@line 261 "./../prefs.cpp"
}
function __Z13PrefsAddInt32PKci($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$0$i = 0, $$sink$i = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $2 = (_malloc(4)|0); //@line 235 "./../prefs.cpp"
 $3 = ($2|0)==(0|0); //@line 236 "./../prefs.cpp"
 if ($3) {
  return; //@line 266 "./../prefs.cpp"
 }
 HEAP8[$2>>0]=$1&255;HEAP8[$2+1>>0]=($1>>8)&255;HEAP8[$2+2>>0]=($1>>16)&255;HEAP8[$2+3>>0]=$1>>24; //@line 238 "./../prefs.cpp"
 $4 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
 HEAP32[$4>>2] = 0; //@line 240 "./../prefs.cpp"
 $5 = (___strdup($0)|0); //@line 241 "./../prefs.cpp"
 $6 = ((($4)) + 4|0); //@line 241 "./../prefs.cpp"
 HEAP32[$6>>2] = $5; //@line 241 "./../prefs.cpp"
 $7 = ((($4)) + 8|0); //@line 242 "./../prefs.cpp"
 HEAP32[$7>>2] = 2; //@line 242 "./../prefs.cpp"
 $8 = ((($4)) + 12|0); //@line 243 "./../prefs.cpp"
 HEAP32[$8>>2] = $2; //@line 243 "./../prefs.cpp"
 $9 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
 $10 = ($9|0)==(0|0); //@line 244 "./../prefs.cpp"
 if ($10) {
  $$sink$i = 115536;
 } else {
  $$0$i = $9;
  while(1) {
   $11 = HEAP32[$$0$i>>2]|0; //@line 246 "./../prefs.cpp"
   $12 = ($11|0)==(0|0); //@line 246 "./../prefs.cpp"
   if ($12) {
    break;
   } else {
    $$0$i = $11;
   }
  }
  $$sink$i = $$0$i;
 }
 HEAP32[$$sink$i>>2] = $4;
 return; //@line 266 "./../prefs.cpp"
}
function __Z15PrefsFindStringPKci($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$0 = 0, $$014$i = 0, $$01416$i = 0, $$01418$i = 0, $$017$i = 0, $$1$i = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0;
 var sp = 0;
 sp = STACKTOP;
 $$01416$i = HEAP32[28884]|0;
 $2 = ($$01416$i|0)==(0|0); //@line 277 "./../prefs.cpp"
 if ($2) {
  $$0 = 0;
  return ($$0|0); //@line 329 "./../prefs.cpp"
 } else {
  $$01418$i = $$01416$i;$$017$i = 0;
 }
 while(1) {
  $3 = ((($$01418$i)) + 8|0); //@line 278 "./../prefs.cpp"
  $4 = HEAP32[$3>>2]|0; //@line 278 "./../prefs.cpp"
  $5 = ($4|0)==(0); //@line 278 "./../prefs.cpp"
  if ($5) {
   $6 = ((($$01418$i)) + 4|0); //@line 278 "./../prefs.cpp"
   $7 = HEAP32[$6>>2]|0; //@line 278 "./../prefs.cpp"
   $8 = (_strcmp($7,$0)|0); //@line 278 "./../prefs.cpp"
   $9 = ($8|0)==(0); //@line 278 "./../prefs.cpp"
   if ($9) {
    $10 = ($$017$i|0)==($1|0); //@line 279 "./../prefs.cpp"
    if ($10) {
     break;
    }
    $11 = (($$017$i) + 1)|0; //@line 282 "./../prefs.cpp"
    $$1$i = $11;
   } else {
    $$1$i = $$017$i;
   }
  } else {
   $$1$i = $$017$i;
  }
  $$014$i = HEAP32[$$01418$i>>2]|0;
  $12 = ($$014$i|0)==(0|0); //@line 277 "./../prefs.cpp"
  if ($12) {
   $$0 = 0;
   label = 8;
   break;
  } else {
   $$01418$i = $$014$i;$$017$i = $$1$i;
  }
 }
 if ((label|0) == 8) {
  return ($$0|0); //@line 329 "./../prefs.cpp"
 }
 $13 = ((($$01418$i)) + 12|0); //@line 326 "./../prefs.cpp"
 $14 = HEAP32[$13>>2]|0; //@line 326 "./../prefs.cpp"
 $$0 = $14;
 return ($$0|0); //@line 329 "./../prefs.cpp"
}
function __Z13PrefsFindBoolPKc($0) {
 $0 = $0|0;
 var $$0 = 0, $$014$i = 0, $$01416$i = 0, $$01418$i = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $$01416$i = HEAP32[28884]|0;
 $1 = ($$01416$i|0)==(0|0); //@line 277 "./../prefs.cpp"
 if ($1) {
  $$0 = 0;
  return ($$0|0); //@line 338 "./../prefs.cpp"
 } else {
  $$01418$i = $$01416$i;
 }
 while(1) {
  $2 = ((($$01418$i)) + 8|0); //@line 278 "./../prefs.cpp"
  $3 = HEAP32[$2>>2]|0; //@line 278 "./../prefs.cpp"
  $4 = ($3|0)==(1); //@line 278 "./../prefs.cpp"
  if ($4) {
   $5 = ((($$01418$i)) + 4|0); //@line 278 "./../prefs.cpp"
   $6 = HEAP32[$5>>2]|0; //@line 278 "./../prefs.cpp"
   $7 = (_strcmp($6,$0)|0); //@line 278 "./../prefs.cpp"
   $8 = ($7|0)==(0); //@line 278 "./../prefs.cpp"
   if ($8) {
    break;
   }
  }
  $$014$i = HEAP32[$$01418$i>>2]|0;
  $9 = ($$014$i|0)==(0|0); //@line 277 "./../prefs.cpp"
  if ($9) {
   $$0 = 0;
   label = 6;
   break;
  } else {
   $$01418$i = $$014$i;
  }
 }
 if ((label|0) == 6) {
  return ($$0|0); //@line 338 "./../prefs.cpp"
 }
 $10 = ((($$01418$i)) + 12|0); //@line 335 "./../prefs.cpp"
 $11 = HEAP32[$10>>2]|0; //@line 335 "./../prefs.cpp"
 $12 = HEAP8[$11>>0]|0; //@line 335 "./../prefs.cpp"
 $13 = ($12<<24>>24)!=(0); //@line 335 "./../prefs.cpp"
 $$0 = $13;
 return ($$0|0); //@line 338 "./../prefs.cpp"
}
function __Z14PrefsFindInt32PKc($0) {
 $0 = $0|0;
 var $$0 = 0, $$014$i = 0, $$01416$i = 0, $$01418$i = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $2 = 0, $3 = 0, $4 = 0, $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 $$01416$i = HEAP32[28884]|0;
 $1 = ($$01416$i|0)==(0|0); //@line 277 "./../prefs.cpp"
 if ($1) {
  $$0 = 0;
  return ($$0|0); //@line 347 "./../prefs.cpp"
 } else {
  $$01418$i = $$01416$i;
 }
 while(1) {
  $2 = ((($$01418$i)) + 8|0); //@line 278 "./../prefs.cpp"
  $3 = HEAP32[$2>>2]|0; //@line 278 "./../prefs.cpp"
  $4 = ($3|0)==(2); //@line 278 "./../prefs.cpp"
  if ($4) {
   $5 = ((($$01418$i)) + 4|0); //@line 278 "./../prefs.cpp"
   $6 = HEAP32[$5>>2]|0; //@line 278 "./../prefs.cpp"
   $7 = (_strcmp($6,$0)|0); //@line 278 "./../prefs.cpp"
   $8 = ($7|0)==(0); //@line 278 "./../prefs.cpp"
   if ($8) {
    break;
   }
  }
  $$014$i = HEAP32[$$01418$i>>2]|0;
  $9 = ($$014$i|0)==(0|0); //@line 277 "./../prefs.cpp"
  if ($9) {
   $$0 = 0;
   label = 6;
   break;
  } else {
   $$01418$i = $$014$i;
  }
 }
 if ((label|0) == 6) {
  return ($$0|0); //@line 347 "./../prefs.cpp"
 }
 $10 = ((($$01418$i)) + 12|0); //@line 344 "./../prefs.cpp"
 $11 = HEAP32[$10>>2]|0; //@line 344 "./../prefs.cpp"
 $12 = HEAP32[$11>>2]|0; //@line 344 "./../prefs.cpp"
 $$0 = $12;
 return ($$0|0); //@line 347 "./../prefs.cpp"
}
function __Z19LoadPrefsFromStreamP8_IO_FILE($0) {
 $0 = $0|0;
 var $$0$i = 0, $$0$i$i = 0, $$0$i$i31 = 0, $$0$lcssa = 0, $$014$i$i = 0, $$01416$i$i = 0, $$01418$i$i = 0, $$06$i$i = 0, $$06$i5$i = 0, $$1 = 0, $$lcssa = 0, $$pre = 0, $$sink$i$i = 0, $$sink$i$i33 = 0, $1 = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0;
 var $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0;
 var $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0;
 var $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0, $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0;
 var $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $77 = 0, $78 = 0, $79 = 0, $8 = 0, $80 = 0, $81 = 0, $82 = 0, $83 = 0, $84 = 0, $85 = 0, $9 = 0, $vararg_buffer = 0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 272|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(272|0);
 $vararg_buffer = sp;
 $1 = sp + 8|0;
 $2 = (_fgets($1,255,$0)|0); //@line 385 "./../prefs.cpp"
 $3 = ($2|0)==(0|0); //@line 385 "./../prefs.cpp"
 if ($3) {
  STACKTOP = sp;return; //@line 432 "./../prefs.cpp"
 }
 $4 = ((($1)) + 1|0);
 while(1) {
  $5 = (_strlen($1)|0); //@line 387 "./../prefs.cpp"
  $6 = ($5|0)==(0); //@line 388 "./../prefs.cpp"
  L6: do {
   if (!($6)) {
    $7 = (($5) + -1)|0; //@line 390 "./../prefs.cpp"
    $8 = (($1) + ($7)|0); //@line 390 "./../prefs.cpp"
    HEAP8[$8>>0] = 0; //@line 390 "./../prefs.cpp"
    $9 = HEAP8[$1>>0]|0; //@line 393 "./../prefs.cpp"
    switch ($9<<24>>24) {
    case 59: case 35:  {
     break L6;
     break;
    }
    default: {
    }
    }
    $10 = $9 << 24 >> 24; //@line 398 "./../prefs.cpp"
    $11 = (_isspace($10)|0); //@line 398 "./../prefs.cpp"
    $12 = ($11|0)==(0); //@line 398 "./../prefs.cpp"
    if ($12) {
     $13 = $4;
     while(1) {
      $$pre = HEAP8[$13>>0]|0;
      $14 = $$pre << 24 >> 24; //@line 398 "./../prefs.cpp"
      $15 = (_isspace($14)|0); //@line 398 "./../prefs.cpp"
      $16 = ($15|0)==(0); //@line 398 "./../prefs.cpp"
      $17 = ((($13)) + 1|0);
      if ($16) {
       $13 = $17;
      } else {
       $$0$lcssa = $13;$$lcssa = $17;
       break;
      }
     }
    } else {
     $$0$lcssa = $1;$$lcssa = $4;
    }
    HEAP8[$$0$lcssa>>0] = 0; //@line 399 "./../prefs.cpp"
    $$1 = $$lcssa;
    while(1) {
     $18 = HEAP8[$$1>>0]|0; //@line 402 "./../prefs.cpp"
     $19 = $18 << 24 >> 24; //@line 402 "./../prefs.cpp"
     $20 = (_isspace($19)|0); //@line 402 "./../prefs.cpp"
     $21 = ($20|0)==(0); //@line 402 "./../prefs.cpp"
     $22 = ((($$1)) + 1|0); //@line 402 "./../prefs.cpp"
     if ($21) {
      break;
     } else {
      $$1 = $22;
     }
    }
    $23 = (_atol($$1)|0); //@line 405 "./../prefs.cpp"
    $24 = HEAP32[(436)>>2]|0; //@line 212 "./../prefs.cpp"
    $25 = ($24|0)==(3); //@line 212 "./../prefs.cpp"
    L16: do {
     if ($25) {
      label = 12;
     } else {
      $$06$i$i = 432;
      while(1) {
       $26 = HEAP32[$$06$i$i>>2]|0; //@line 213 "./../prefs.cpp"
       $27 = (_strcmp($26,$1)|0); //@line 213 "./../prefs.cpp"
       $28 = ($27|0)==(0); //@line 213 "./../prefs.cpp"
       if ($28) {
        $$0$i = $$06$i$i;
        break L16;
       }
       $29 = ((($$06$i$i)) + 16|0); //@line 215 "./../prefs.cpp"
       $30 = ((($$06$i$i)) + 20|0); //@line 212 "./../prefs.cpp"
       $31 = HEAP32[$30>>2]|0; //@line 212 "./../prefs.cpp"
       $32 = ($31|0)==(3); //@line 212 "./../prefs.cpp"
       if ($32) {
        label = 12;
        break;
       } else {
        $$06$i$i = $29;
       }
      }
     }
    } while(0);
    L20: do {
     if ((label|0) == 12) {
      label = 0;
      $33 = HEAP32[(5364)>>2]|0; //@line 212 "./../prefs.cpp"
      $34 = ($33|0)==(3); //@line 212 "./../prefs.cpp"
      if (!($34)) {
       $$06$i5$i = 5360;
       while(1) {
        $35 = HEAP32[$$06$i5$i>>2]|0; //@line 213 "./../prefs.cpp"
        $36 = (_strcmp($35,$1)|0); //@line 213 "./../prefs.cpp"
        $37 = ($36|0)==(0); //@line 213 "./../prefs.cpp"
        if ($37) {
         $$0$i = $$06$i5$i;
         break L20;
        }
        $38 = ((($$06$i5$i)) + 16|0); //@line 215 "./../prefs.cpp"
        $39 = ((($$06$i5$i)) + 20|0); //@line 212 "./../prefs.cpp"
        $40 = HEAP32[$39>>2]|0; //@line 212 "./../prefs.cpp"
        $41 = ($40|0)==(3); //@line 212 "./../prefs.cpp"
        if ($41) {
         break;
        } else {
         $$06$i5$i = $38;
        }
       }
      }
      HEAP32[$vararg_buffer>>2] = $1; //@line 410 "./../prefs.cpp"
      (_printf(89372,$vararg_buffer)|0); //@line 410 "./../prefs.cpp"
      break L6;
     }
    } while(0);
    $44 = ((($$0$i)) + 4|0); //@line 415 "./../prefs.cpp"
    $45 = HEAP32[$44>>2]|0; //@line 415 "./../prefs.cpp"
    switch ($45|0) {
    case 0:  {
     $46 = ((($$0$i)) + 8|0); //@line 417 "./../prefs.cpp"
     $47 = HEAP8[$46>>0]|0; //@line 417 "./../prefs.cpp"
     $48 = ($47<<24>>24)==(0); //@line 417 "./../prefs.cpp"
     if ($48) {
      __Z18PrefsReplaceStringPKcS0_i($1,$$1,0); //@line 420 "./../prefs.cpp"
      break L6;
     }
     $49 = (_strlen($$1)|0); //@line 255 "./../prefs.cpp"
     $50 = (($49) + 1)|0; //@line 255 "./../prefs.cpp"
     $51 = (_malloc($50)|0); //@line 235 "./../prefs.cpp"
     $52 = ($51|0)==(0|0); //@line 236 "./../prefs.cpp"
     if ($52) {
      break L6;
     }
     _memcpy(($51|0),($$1|0),($50|0))|0; //@line 238 "./../prefs.cpp"
     $53 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
     HEAP32[$53>>2] = 0; //@line 240 "./../prefs.cpp"
     $54 = (___strdup($1)|0); //@line 241 "./../prefs.cpp"
     $55 = ((($53)) + 4|0); //@line 241 "./../prefs.cpp"
     HEAP32[$55>>2] = $54; //@line 241 "./../prefs.cpp"
     $56 = ((($53)) + 8|0); //@line 242 "./../prefs.cpp"
     HEAP32[$56>>2] = 0; //@line 242 "./../prefs.cpp"
     $57 = ((($53)) + 12|0); //@line 243 "./../prefs.cpp"
     HEAP32[$57>>2] = $51; //@line 243 "./../prefs.cpp"
     $58 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
     $59 = ($58|0)==(0|0); //@line 244 "./../prefs.cpp"
     if ($59) {
      $$sink$i$i = 115536;
     } else {
      $$0$i$i = $58;
      while(1) {
       $60 = HEAP32[$$0$i$i>>2]|0; //@line 246 "./../prefs.cpp"
       $61 = ($60|0)==(0|0); //@line 246 "./../prefs.cpp"
       if ($61) {
        break;
       } else {
        $$0$i$i = $60;
       }
      }
      $$sink$i$i = $$0$i$i;
     }
     HEAP32[$$sink$i$i>>2] = $53;
     break L6;
     break;
    }
    case 1:  {
     $62 = (_strcmp($$1,114711)|0); //@line 423 "./../prefs.cpp"
     $63 = ($62|0)==(0); //@line 423 "./../prefs.cpp"
     __Z16PrefsReplaceBoolPKcb($1,$63); //@line 423 "./../prefs.cpp"
     break L6;
     break;
    }
    case 2:  {
     $$01416$i$i = HEAP32[28884]|0;
     $64 = ($$01416$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
     L41: do {
      if (!($64)) {
       $$01418$i$i = $$01416$i$i;
       while(1) {
        $65 = ((($$01418$i$i)) + 8|0); //@line 278 "./../prefs.cpp"
        $66 = HEAP32[$65>>2]|0; //@line 278 "./../prefs.cpp"
        $67 = ($66|0)==(2); //@line 278 "./../prefs.cpp"
        if ($67) {
         $68 = ((($$01418$i$i)) + 4|0); //@line 278 "./../prefs.cpp"
         $69 = HEAP32[$68>>2]|0; //@line 278 "./../prefs.cpp"
         $70 = (_strcmp($69,$1)|0); //@line 278 "./../prefs.cpp"
         $71 = ($70|0)==(0); //@line 278 "./../prefs.cpp"
         if ($71) {
          break;
         }
        }
        $$014$i$i = HEAP32[$$01418$i$i>>2]|0;
        $72 = ($$014$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
        if ($72) {
         break L41;
        } else {
         $$01418$i$i = $$014$i$i;
        }
       }
       $73 = ((($$01418$i$i)) + 12|0); //@line 312 "./../prefs.cpp"
       $74 = HEAP32[$73>>2]|0; //@line 312 "./../prefs.cpp"
       HEAP32[$74>>2] = $23; //@line 312 "./../prefs.cpp"
       break L6;
      }
     } while(0);
     $75 = (_malloc(4)|0); //@line 235 "./../prefs.cpp"
     $76 = ($75|0)==(0|0); //@line 236 "./../prefs.cpp"
     if ($76) {
      break L6;
     }
     HEAP8[$75>>0]=$23&255;HEAP8[$75+1>>0]=($23>>8)&255;HEAP8[$75+2>>0]=($23>>16)&255;HEAP8[$75+3>>0]=$23>>24; //@line 238 "./../prefs.cpp"
     $77 = (__Znwj(16)|0); //@line 239 "./../prefs.cpp"
     HEAP32[$77>>2] = 0; //@line 240 "./../prefs.cpp"
     $78 = (___strdup($1)|0); //@line 241 "./../prefs.cpp"
     $79 = ((($77)) + 4|0); //@line 241 "./../prefs.cpp"
     HEAP32[$79>>2] = $78; //@line 241 "./../prefs.cpp"
     $80 = ((($77)) + 8|0); //@line 242 "./../prefs.cpp"
     HEAP32[$80>>2] = 2; //@line 242 "./../prefs.cpp"
     $81 = ((($77)) + 12|0); //@line 243 "./../prefs.cpp"
     HEAP32[$81>>2] = $75; //@line 243 "./../prefs.cpp"
     $82 = HEAP32[28884]|0; //@line 244 "./../prefs.cpp"
     $83 = ($82|0)==(0|0); //@line 244 "./../prefs.cpp"
     if ($83) {
      $$sink$i$i33 = 115536;
     } else {
      $$0$i$i31 = $82;
      while(1) {
       $84 = HEAP32[$$0$i$i31>>2]|0; //@line 246 "./../prefs.cpp"
       $85 = ($84|0)==(0|0); //@line 246 "./../prefs.cpp"
       if ($85) {
        break;
       } else {
        $$0$i$i31 = $84;
       }
      }
      $$sink$i$i33 = $$0$i$i31;
     }
     HEAP32[$$sink$i$i33>>2] = $77;
     break L6;
     break;
    }
    default: {
     break L6;
    }
    }
   }
  } while(0);
  $42 = (_fgets($1,255,$0)|0); //@line 385 "./../prefs.cpp"
  $43 = ($42|0)==(0|0); //@line 385 "./../prefs.cpp"
  if ($43) {
   break;
  }
 }
 STACKTOP = sp;return; //@line 432 "./../prefs.cpp"
}
function __Z17SavePrefsToStreamP8_IO_FILE($0) {
 $0 = $0|0;
 var label = 0, sp = 0;
 sp = STACKTOP;
 __ZL11write_prefsP8_IO_FILEPK10prefs_desc($0,432); //@line 465 "./../prefs.cpp"
 __ZL11write_prefsP8_IO_FILEPK10prefs_desc($0,5360); //@line 466 "./../prefs.cpp"
 return; //@line 467 "./../prefs.cpp"
}
function __ZL11write_prefsP8_IO_FILEPK10prefs_desc($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$ = 0, $$0 = 0, $$0$i28 = 0, $$014$i$i = 0, $$014$i$i20 = 0, $$014$i$i26 = 0, $$01416$i$i = 0, $$01416$i$i17 = 0, $$01416$i$i23 = 0, $$01416$i$i33 = 0, $$01416$i$i35 = 0, $$01418$i$i = 0, $$01418$i$i18 = 0, $$01418$i$i24 = 0, $$01634 = 0, $$017$i$i = 0, $$1$i$i = 0, $10 = 0, $11 = 0, $12 = 0;
 var $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0, $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0;
 var $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0, $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0;
 var $5 = 0, $6 = 0, $7 = 0, $8 = 0, $9 = 0, $vararg_buffer = 0, $vararg_buffer2 = 0, $vararg_buffer6 = 0, $vararg_ptr1 = 0, $vararg_ptr5 = 0, $vararg_ptr9 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 32|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(32|0);
 $vararg_buffer6 = sp + 16|0; //@line 439 "./../prefs.cpp"
 $vararg_buffer2 = sp + 8|0; //@line 439 "./../prefs.cpp"
 $vararg_buffer = sp; //@line 439 "./../prefs.cpp"
 $$0 = $1;
 L1: while(1) {
  $2 = ((($$0)) + 4|0); //@line 441 "./../prefs.cpp"
  $3 = HEAP32[$2>>2]|0; //@line 441 "./../prefs.cpp"
  L3: do {
   switch ($3|0) {
   case 3:  {
    break L1;
    break;
   }
   case 0:  {
    $$01416$i$i33 = HEAP32[28884]|0;
    $4 = ($$01416$i$i33|0)==(0|0); //@line 277 "./../prefs.cpp"
    if (!($4)) {
     $$01416$i$i35 = $$01416$i$i33;$$01634 = 0;
     while(1) {
      $5 = HEAP32[$$0>>2]|0; //@line 446 "./../prefs.cpp"
      $$01418$i$i = $$01416$i$i35;$$017$i$i = 0;
      while(1) {
       $6 = ((($$01418$i$i)) + 8|0); //@line 278 "./../prefs.cpp"
       $7 = HEAP32[$6>>2]|0; //@line 278 "./../prefs.cpp"
       $8 = ($7|0)==(0); //@line 278 "./../prefs.cpp"
       if ($8) {
        $9 = ((($$01418$i$i)) + 4|0); //@line 278 "./../prefs.cpp"
        $10 = HEAP32[$9>>2]|0; //@line 278 "./../prefs.cpp"
        $11 = (_strcmp($10,$5)|0); //@line 278 "./../prefs.cpp"
        $12 = ($11|0)==(0); //@line 278 "./../prefs.cpp"
        if ($12) {
         $13 = ($$017$i$i|0)==($$01634|0); //@line 279 "./../prefs.cpp"
         if ($13) {
          break;
         }
         $14 = (($$017$i$i) + 1)|0; //@line 282 "./../prefs.cpp"
         $$1$i$i = $14;
        } else {
         $$1$i$i = $$017$i$i;
        }
       } else {
        $$1$i$i = $$017$i$i;
       }
       $$014$i$i = HEAP32[$$01418$i$i>>2]|0;
       $15 = ($$014$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
       if ($15) {
        break L3;
       } else {
        $$01418$i$i = $$014$i$i;$$017$i$i = $$1$i$i;
       }
      }
      $16 = ((($$01418$i$i)) + 12|0); //@line 326 "./../prefs.cpp"
      $17 = HEAP32[$16>>2]|0; //@line 326 "./../prefs.cpp"
      $18 = ($17|0)==(0|0); //@line 446 "./../prefs.cpp"
      if ($18) {
       break L3;
      }
      $19 = (($$01634) + 1)|0; //@line 446 "./../prefs.cpp"
      HEAP32[$vararg_buffer>>2] = $5; //@line 447 "./../prefs.cpp"
      $vararg_ptr1 = ((($vararg_buffer)) + 4|0); //@line 447 "./../prefs.cpp"
      HEAP32[$vararg_ptr1>>2] = $17; //@line 447 "./../prefs.cpp"
      (_fprintf($0,89415,$vararg_buffer)|0); //@line 447 "./../prefs.cpp"
      $$01416$i$i = HEAP32[28884]|0;
      $20 = ($$01416$i$i|0)==(0|0); //@line 277 "./../prefs.cpp"
      if ($20) {
       break;
      } else {
       $$01416$i$i35 = $$01416$i$i;$$01634 = $19;
      }
     }
    }
    break;
   }
   case 1:  {
    $21 = HEAP32[$$0>>2]|0; //@line 451 "./../prefs.cpp"
    $$01416$i$i17 = HEAP32[28884]|0;
    $22 = ($$01416$i$i17|0)==(0|0); //@line 277 "./../prefs.cpp"
    L17: do {
     if ($22) {
      $35 = 114705;
     } else {
      $$01418$i$i18 = $$01416$i$i17;
      while(1) {
       $23 = ((($$01418$i$i18)) + 8|0); //@line 278 "./../prefs.cpp"
       $24 = HEAP32[$23>>2]|0; //@line 278 "./../prefs.cpp"
       $25 = ($24|0)==(1); //@line 278 "./../prefs.cpp"
       if ($25) {
        $26 = ((($$01418$i$i18)) + 4|0); //@line 278 "./../prefs.cpp"
        $27 = HEAP32[$26>>2]|0; //@line 278 "./../prefs.cpp"
        $28 = (_strcmp($27,$21)|0); //@line 278 "./../prefs.cpp"
        $29 = ($28|0)==(0); //@line 278 "./../prefs.cpp"
        if ($29) {
         break;
        }
       }
       $$014$i$i20 = HEAP32[$$01418$i$i18>>2]|0;
       $30 = ($$014$i$i20|0)==(0|0); //@line 277 "./../prefs.cpp"
       if ($30) {
        $35 = 114705;
        break L17;
       } else {
        $$01418$i$i18 = $$014$i$i20;
       }
      }
      $31 = ((($$01418$i$i18)) + 12|0); //@line 335 "./../prefs.cpp"
      $32 = HEAP32[$31>>2]|0; //@line 335 "./../prefs.cpp"
      $33 = HEAP8[$32>>0]|0; //@line 335 "./../prefs.cpp"
      $34 = ($33<<24>>24)!=(0); //@line 335 "./../prefs.cpp"
      $$ = $34 ? 114711 : 114705; //@line 451 "./../prefs.cpp"
      $35 = $$;
     }
    } while(0);
    HEAP32[$vararg_buffer2>>2] = $21; //@line 451 "./../prefs.cpp"
    $vararg_ptr5 = ((($vararg_buffer2)) + 4|0); //@line 451 "./../prefs.cpp"
    HEAP32[$vararg_ptr5>>2] = $35; //@line 451 "./../prefs.cpp"
    (_fprintf($0,89415,$vararg_buffer2)|0); //@line 451 "./../prefs.cpp"
    break;
   }
   case 2:  {
    $36 = HEAP32[$$0>>2]|0; //@line 454 "./../prefs.cpp"
    $$01416$i$i23 = HEAP32[28884]|0;
    $37 = ($$01416$i$i23|0)==(0|0); //@line 277 "./../prefs.cpp"
    L26: do {
     if ($37) {
      $$0$i28 = 0;
     } else {
      $$01418$i$i24 = $$01416$i$i23;
      while(1) {
       $38 = ((($$01418$i$i24)) + 8|0); //@line 278 "./../prefs.cpp"
       $39 = HEAP32[$38>>2]|0; //@line 278 "./../prefs.cpp"
       $40 = ($39|0)==(2); //@line 278 "./../prefs.cpp"
       if ($40) {
        $41 = ((($$01418$i$i24)) + 4|0); //@line 278 "./../prefs.cpp"
        $42 = HEAP32[$41>>2]|0; //@line 278 "./../prefs.cpp"
        $43 = (_strcmp($42,$36)|0); //@line 278 "./../prefs.cpp"
        $44 = ($43|0)==(0); //@line 278 "./../prefs.cpp"
        if ($44) {
         break;
        }
       }
       $$014$i$i26 = HEAP32[$$01418$i$i24>>2]|0;
       $45 = ($$014$i$i26|0)==(0|0); //@line 277 "./../prefs.cpp"
       if ($45) {
        $$0$i28 = 0;
        break L26;
       } else {
        $$01418$i$i24 = $$014$i$i26;
       }
      }
      $46 = ((($$01418$i$i24)) + 12|0); //@line 344 "./../prefs.cpp"
      $47 = HEAP32[$46>>2]|0; //@line 344 "./../prefs.cpp"
      $48 = HEAP32[$47>>2]|0; //@line 344 "./../prefs.cpp"
      $$0$i28 = $48;
     }
    } while(0);
    HEAP32[$vararg_buffer6>>2] = $36; //@line 454 "./../prefs.cpp"
    $vararg_ptr9 = ((($vararg_buffer6)) + 4|0); //@line 454 "./../prefs.cpp"
    HEAP32[$vararg_ptr9>>2] = $$0$i28; //@line 454 "./../prefs.cpp"
    (_fprintf($0,89422,$vararg_buffer6)|0); //@line 454 "./../prefs.cpp"
    break;
   }
   default: {
   }
   }
  } while(0);
  $49 = ((($$0)) + 16|0); //@line 459 "./../prefs.cpp"
  $$0 = $49;
 }
 STACKTOP = sp;return; //@line 461 "./../prefs.cpp"
}
function __Z16AddPrefsDefaultsv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 __Z12PrefsAddBoolPKcb(93650,0); //@line 81 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(93660,6066); //@line 82 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(90103,0); //@line 83 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(90075,0); //@line 84 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(104939,8388608); //@line 85 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(103111,6); //@line 86 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(91872,5); //@line 87 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(90248,3); //@line 88 "./../prefs_items.cpp"
 __Z12PrefsAddBoolPKcb(90289,0); //@line 89 "./../prefs_items.cpp"
 __Z12PrefsAddBoolPKcb(90831,0); //@line 90 "./../prefs_items.cpp"
 __Z12PrefsAddBoolPKcb(104497,0); //@line 91 "./../prefs_items.cpp"
 __Z12PrefsAddBoolPKcb(90368,0); //@line 92 "./../prefs_items.cpp"
 __Z12PrefsAddBoolPKcb(104933,0); //@line 93 "./../prefs_items.cpp"
 __Z12PrefsAddBoolPKcb(90430,0); //@line 104 "./../prefs_items.cpp"
 __Z13PrefsAddInt32PKci(93520,5); //@line 107 "./../prefs_items.cpp"
 return; //@line 108 "./../prefs_items.cpp"
}
function __Z7SysInitv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return; //@line 137 "sys_unix.cpp"
}
function __Z7SysExitv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return; //@line 150 "sys_unix.cpp"
}
function __Z17SysAddFloppyPrefsv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 __Z14PrefsAddStringPKcS0_(94063,90780); //@line 304 "sys_unix.cpp"
 __Z14PrefsAddStringPKcS0_(94063,90789); //@line 305 "sys_unix.cpp"
 return; //@line 307 "sys_unix.cpp"
}
function __Z15SysAddDiskPrefsv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return; //@line 342 "sys_unix.cpp"
}
function __Z16SysAddCDROMPrefsv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return; //@line 382 "sys_unix.cpp"
}
function __Z17SysAddSerialPrefsv() {
 var label = 0, sp = 0;
 sp = STACKTOP;
 return; //@line 417 "sys_unix.cpp"
}
function __Z8Sys_openPKcb($0,$1) {
 $0 = $0|0;
 $1 = $1|0;
 var $$082$off095$ph = 0, $$084 = 0, $$183$off0 = 0, $$3$ph = 0, $$6 = 0, $$cast = 0, $10 = 0, $11 = 0, $12 = 0, $13 = 0, $14 = 0, $15 = 0, $16 = 0, $17 = 0, $18 = 0, $19 = 0, $2 = 0, $20 = 0, $21 = 0, $22 = 0;
 var $23 = 0, $24 = 0, $25 = 0, $26 = 0, $27 = 0, $28 = 0, $29 = 0, $3 = 0, $30 = 0, $31 = 0, $32 = 0, $33 = 0, $34 = 0, $35 = 0, $36 = 0, $37 = 0, $38 = 0, $39 = 0, $4 = 0, $40 = 0;
 var $41 = 0, $42 = 0, $43 = 0, $44 = 0, $45 = 0, $46 = 0, $47 = 0, $48 = 0, $49 = 0, $5 = 0, $50 = 0, $51 = 0, $52 = 0, $53 = 0, $54 = 0, $55 = 0, $56 = 0, $57 = 0, $58 = 0, $59 = 0;
 var $6 = 0, $60 = 0, $61 = 0, $62 = 0, $63 = 0, $64 = 0, $65 = 0, $66 = 0, $67 = 0, $68 = 0, $69 = 0, $7 = 0, $70 = 0, $71 = 0, $72 = 0, $73 = 0, $74 = 0, $75 = 0, $76 = 0, $8 = 0;
 var $9 = 0, $brmerge92 = 0, $brmerge93 = 0, $narrow = 0, $or$cond = 0, $vararg_buffer = 0, $vararg_buffer1 = 0, $vararg_buffer3 = 0, $vararg_ptr5 = 0, label = 0, sp = 0;
 sp = STACKTOP;
 STACKTOP = STACKTOP + 368|0; if ((STACKTOP|0) >= (STACK_MAX|0)) abortStackOverflow(368|0);
 $vararg_buffer3 = sp + 16|0;
 $vararg_buffer1 = sp + 8|0;
 $vararg_buffer = sp;
 $2 = sp + 100|0;
 $3 = sp + 104|0;
 $4 = sp + 24|0;
 $5 = (_strncmp($0,90798,5)|0); //@line 543 "sys_unix.cpp"
 $6 = ($5|0)!=(0); //@line 543 "sys_unix.cpp"
 $7 = $6&1; //@line 543 "sys_unix.cpp"
 $8 = (_strncmp($0,90804,7)|0); //@line 548 "sys_unix.cpp"
 $9 = ($8|0)==(0); //@line 548 "sys_unix.cpp"
 $10 = $9&1; //@line 548 "sys_unix.cpp"
 $11 = (_strncmp($0,90812,7)|0); //@line 550 "sys_unix.cpp"
 $12 = ($11|0)==(0); //@line 550 "sys_unix.cpp"
 $13 = $12&1; //@line 550 "sys_unix.cpp"
 $14 = (_strncmp($0,90820,10)|0); //@line 552 "sys_unix.cpp"
 $15 = ($14|0)==(0); //@line 552 "sys_unix.cpp"
 $narrow = $12 | $15; //@line 553 "sys_unix.cpp"
 if ($1) {
  $$082$off095$ph = 1;
 } else {
  $16 = (_access($0,2)|0); //@line 575 "sys_unix.cpp"
  $17 = ($16|0)!=(0); //@line 575 "sys_unix.cpp"
  $$082$off095$ph = $17;
 }
 $18 = (__Z25disk_sparsebundle_factoryPKcbPP12disk_generic($0,$$082$off095$ph,$2)|0); //@line 612 "sys_unix.cpp"
 switch ($18|0) {
 case 1:  {
  $$3$ph = 0;
  break;
 }
 case 2:  {
  $19 = (__Znwj(28)|0); //@line 529 "sys_unix.cpp"
  $20 = ((($19)) + 8|0);
  ;HEAP32[$20>>2]=0|0;HEAP32[$20+4>>2]=0|0;HEAP32[$20+8>>2]=0|0;HEAP32[$20+12>>2]=0|0; //@line 530 "sys_unix.cpp"
  $21 = (___strdup($0)|0); //@line 531 "sys_unix.cpp"
  HEAP32[$19>>2] = $21; //@line 531 "sys_unix.cpp"
  $22 = ((($19)) + 4|0); //@line 532 "sys_unix.cpp"
  HEAP32[$22>>2] = -1; //@line 532 "sys_unix.cpp"
  $23 = ((($19)) + 24|0); //@line 533 "sys_unix.cpp"
  $24 = 