![Logo](https://dev-to-uploads.s3.amazonaws.com/uploads/articles/th5xamgrr6se0x5ro4g6.png)

# My Project

A brief description of this project and who it's for.

## Installation

Install my-project with npm

```bash
  npm install my-project
```

## Run Locally

Clone the project

```bash
  git clone https://link-to-project
```

Go to the project directory

```bash
  cd my-project
```

Install dependencies

```bash
  npm install
```

Start the server

```bash
  npm run start
```

## Screenshots

![App Screenshot](https://dev-to-uploads.s3.amazonaws.com/uploads/articles/thnlpymky4kq5n54t4np.png)

## Environment Variables

To run this project, you will need to add the following environment variables to your .env file

`API_KEY`

`ANOTHER_API_KEY`

## Features

- Light/dark mode toggle
- Live previews
- Fullscreen mode
- Cross platform

## Usage/Examples

```javascript
import Component from 'my-project'

function App() {
  return <Component />
}
```

## API Reference

#### Get all items

```http
  GET /api/items
```

| Parameter | Type     | Description                |
| :-------- | :------- | :------------------------- |
| `api_key` | `string` | **Required**. Your API key |

#### Get item

```http
  GET /api/items/${id}
```

| Parameter | Type     | Description                       |
| :-------- | :------- | :-------------------------------- |
| `id`      | `string` | **Required**. Id of item to fetch |

#### add(num1, num2)

Takes two numbers and returns the sum.

## Contributing

Contributions are always welcome!

See `contributing.md` for ways to get started.

Please adhere to this project's `code of conduct`.

## Running Tests

To run tests, run the following command

```bash
  npm run test
```

## License

[MIT](https://choosealicense.com/licenses/mit/)

## Badges

Add badges from somewhere like: [shields.io](https://shields.io/)

[![MIT License](https://img.shields.io/apm/l/atomic-design-ui.svg?)](https://github.com/tterb/atomic-design-ui/blob/master/LICENSEs)
[![GPLv3 License](https://img.shields.io/badge/License-GPL%20v3-yellow.svg)](https://opensource.org/licenses/)
[![AGPL License](https://img.shields.io/badge/license-AGPL-blue.svg)](http://www.gnu.org/licenses/agpl-3.0)

## Roadmap

- [x] Additional browser support

- [ ] Add more integrations

## Authors and Acknowledgement

- [@octokatherine](https://www.github.com/octokatherine) for development and design.

## Support

For support, email fake@fake.com or join our Slack channel.

## Feedback

Any questions or suggestions? Please reach out to us at fake@fake.com

## Related

Here are some related projects

[Awesome README](https://github.com/matiassingers/awesome-readme)

## Demo

Insert gif or link to demo

## Tech Stack

**Client:** React, Redux, TailwindCSS

**Server:** Node, Express

## Optimizations

What optimizations did you make in your code? E.g. refactors, performance improvements, accessibility

## Lessons Learned

What did you learn while building this project? What challenges did you face and how did you overcome them?

## FAQ

#### Question 1

Answer 1

#### Question 2

Answer 2

## Used By

This project is used by the following companies:

- Company 1
- Company 2

## Documentation

[Documentation](https://linktodocumentation)

## Deployment

To deploy this project run

```bash
  npm run deploy
```

## Appendix

Any additional information goes here
