export const pt_BR = [
  {
    slug: 'title-and-description',
    name: 'Título e Descrição',
    markdown: `
# Título do Projeto

Uma breve descrição sobre o que esse projeto faz e para quem ele é

`,
  },
  {
    slug: 'installation',
    name: 'Instalação',
    markdown: `
## Instalação

Instale my-project com npm

\`\`\`bash
  npm install my-project
  cd my-project
\`\`\`
    `,
  },
  {
    slug: 'logo',
    name: 'Logo',
    markdown: `
![Logo](https://dev-to-uploads.s3.amazonaws.com/uploads/articles/th5xamgrr6se0x5ro4g6.png)

`,
  },
  {
    slug: 'run-locally',
    name: 'Rodando localmente',
    markdown: `
## Rodando localmente

Clone o projeto

\`\`\`bash
  git clone https://link-para-o-projeto
\`\`\`

Entre no diretório do projeto

\`\`\`bash
  cd my-project
\`\`\`

Instale as dependências

\`\`\`bash
  npm install
\`\`\`

Inicie o servidor

\`\`\`bash
  npm run start
\`\`\`

`,
  },
  {
    slug: 'screenshots',
    name: 'Screenshots',
    markdown: `
## Screenshots

![App Screenshot](https://via.placeholder.com/468x300?text=App+Screenshot+Here)

`,
  },
  {
    slug: 'env-variables',
    name: 'Variáveis de Ambiente',
    markdown: `
## Variáveis de Ambiente

Para rodar esse projeto, você vai precisar adicionar as seguintes variáveis de ambiente no seu .env

\`API_KEY\`

\`ANOTHER_API_KEY\`

`,
  },
  {
    slug: 'features',
    name: 'Funcionalidades',
    markdown: `
## Funcionalidades

- Temas dark e light
- Preview em tempo real
- Modo tela cheia
- Multiplataforma

`,
  },
  {
    slug: 'usage-examples',
    name: 'Uso/Exemplos',
    markdown: `
## Uso/Exemplos

\`\`\`javascript
import Component from 'my-project'

function App() {
  return <Component />
}
\`\`\`

`,
  },
  {
    slug: 'api',
    name: 'Documentação da API',
    markdown: `
## Documentação da API

#### Retorna todos os itens

\`\`\`http
  GET /api/items
\`\`\`

| Parâmetro   | Tipo       | Descrição                           |
| :---------- | :--------- | :---------------------------------- |
| \`api_key\` | \`string\` | **Obrigatório**. A chave da sua API |

#### Retorna um item

\`\`\`http
  GET /api/items/$\{id}
\`\`\`

| Parâmetro   | Tipo       | Descrição                                   |
| :---------- | :--------- | :------------------------------------------ |
| \`id\`      | \`string\` | **Obrigatório**. O ID do item que você quer |

#### add(num1, num2)

Recebe dois números e retorna a sua soma.

`,
  },
  {
    slug: 'contributing',
    name: 'Contribuindo',
    markdown: `
## Contribuindo

Contribuições são sempre bem-vindas!

Veja \`contribuindo.md\` para saber como começar.

Por favor, siga o \`código de conduta\` desse projeto.

`,
  },
  {
    slug: 'tests',
    name: 'Rodando os testes',
    markdown: `
## Rodando os testes

Para rodar os testes, rode o seguinte comando

\`\`\`bash
  npm run test
\`\`\`

`,
  },
  {
    slug: 'license',
    name: 'Licença',
    markdown: `
## Licença

[MIT](https://choosealicense.com/licenses/mit/)

`,
  },
  {
    slug: 'badges',
    name: 'Etiquetas',
    markdown: `
## Etiquetas

Adicione etiquetas de algum lugar, como: [shields.io](https://shields.io/)

[![MIT License](https://img.shields.io/badge/License-MIT-green.svg)](https://choosealicense.com/licenses/mit/)
[![GPLv3 License](https://img.shields.io/badge/License-GPL%20v3-yellow.svg)](https://opensource.org/licenses/)
[![AGPL License](https://img.shields.io/badge/license-AGPL-blue.svg)](http://www.gnu.org/licenses/agpl-3.0)

`,
  },
  {
    slug: 'roadmap',
    name: 'Roadmap',
    markdown: `
## Roadmap

- Melhorar o suporte de navegadores

- Adicionar mais integrações

`,
  },
  {
    slug: 'authors',
    name: 'Autores',
    markdown: `
## Autores

- [@octokatherine](https://www.github.com/octokatherine)

`,
  },
  {
    slug: 'acknowledgement',
    name: 'Referência',
    markdown: `
## Referência

 - [Awesome Readme Templates](https://awesomeopensource.com/project/elangosundar/awesome-README-templates)
 - [Awesome README](https://github.com/matiassingers/awesome-readme)
 - [How to write a Good readme](https://bulldogjob.com/news/449-how-to-write-a-good-readme-for-your-github-project)

`,
  },
  {
    slug: 'support',
    name: 'Suporte',
    markdown: `
## Suporte

Para suporte, mande um email para fake@fake.com ou entre em nosso canal do Slack.

`,
  },
  {
    slug: 'feedback',
    name: 'Feedback',
    markdown: `
## Feedback

Se você tiver algum feedback, por favor nos deixe saber por meio de fake@fake.com

`,
  },
  {
    slug: 'related',
    name: 'Relacionados',
    markdown: `
## Relacionados

Segue alguns projetos relacionados

[Awesome README](https://github.com/matiassingers/awesome-readme)

`,
  },
  {
    slug: 'demo',
    name: 'Demonstração',
    markdown: `
## Demonstração

Insira um gif ou um link de alguma demonstração

`,
  },
  {
    slug: 'tech',
    name: 'Stack utilizada',
    markdown: `
## Stack utilizada

**Front-end:** React, Redux, TailwindCSS

**Back-end:** Node, Express

`,
  },
  {
    slug: 'optimizations',
    name: 'Melhorias',
    markdown: `
## Melhorias

Que melhorias você fez no seu código? Ex: refatorações, melhorias de performance, acessibilidade, etc

`,
  },
  {
    slug: 'lessons',
    name: 'Aprendizados',
    markdown: `
## Aprendizados

O que você aprendeu construindo esse projeto? Quais desafios você enfrentou e como você superou-os?

`,
  },
  {
    slug: 'faq',
    name: 'FAQ',
    markdown: `
## FAQ

#### Questão 1

Resposta 1

#### Questão 2

Resposta 2

`,
  },
  {
    slug: 'used-by',
    name: 'Usado por',
    markdown: `
## Usado por

Esse projeto é usado pelas seguintes empresas:

- Empresa 1
- Empresa 2

`,
  },
  {
    slug: 'documentation',
    name: 'Documentação',
    markdown: `
## Documentação

[Documentação](https://link-da-documentação)

`,
  },
  {
    slug: 'deployment',
    name: 'Deploy',
    markdown: `
## Deploy

Para fazer o deploy desse projeto rode

\`\`\`bash
  npm run deploy
\`\`\`

`,
  },
  {
    slug: 'appendix',
    name: 'Apêndice',
    markdown: `
## Apêndice

Coloque qualquer informação adicional aqui

`,
  },
  {
    slug: 'github-profile-intro',
    name: 'Perfil do GitHub - Introdução',
    markdown: `
# Olá, eu sou a Katherine! 👋

`,
  },
  {
    slug: 'github-profile-about-me',
    name: 'Perfil do GitHub - Sobre mim',
    markdown: `
## 🚀 Sobre mim
Eu sou uma pessoa desenvolvedora full-stack...

`,
  },
  {
    slug: 'github-profile-skills',
    name: 'Perfil do GitHub - Habilidades',
    markdown: `
## 🛠 Habilidades
Javascript, HTML, CSS...

`,
  },
  {
    slug: 'github-profile-links',
    name: 'Perfil do GitHub - Links',
    markdown: `
## 🔗 Links
[![portfolio](https://img.shields.io/badge/my_portfolio-000?style=for-the-badge&logo=ko-fi&logoColor=white)](https://katherineoelsner.com/)
[![linkedin](https://img.shields.io/badge/linkedin-0A66C2?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/)
[![twitter](https://img.shields.io/badge/twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)](https://twitter.com/)

`,
  },
  {
    slug: 'github-profile-other',
    name: 'Perfil do GitHub - Outros',
    markdown: `
## Outras seções comuns em perfis do GitHub
👩‍💻 Trabalho atualmente na/no...

🧠 Estou aprendendo...

👯‍♀️ Procuro colaborar em...

🤔 Procuro ajuda com...

💬 Me pergunte sobre...

📫 Como entrar em contato comigo...

😄 Pronomes...

⚡️ Fatos engraçados...

`,
  },
  {
    slug: 'colorreference',
    name: 'Documentação de cores',
    markdown: `## Documentação de cores

| Cor               | Hexadecimal                                                |
| ----------------- | ---------------------------------------------------------------- |
| Cor exemplo       | ![#0a192f](https://via.placeholder.com/10/0a192f?text=+) #0a192f |
| Cor exemplo       | ![#f8f8f8](https://via.placeholder.com/10/f8f8f8?text=+) #f8f8f8 |
| Cor exemplo       | ![#00b48a](https://via.placeholder.com/10/00b48a?text=+) #00b48a |
| Cor exemplo       | ![#00d1a0](https://via.placeholder.com/10/00b48a?text=+) #00d1a0 |

`,
  },
]
