# powerflow-display

![sample-gif](https://raw.githubusercontent.com/octera/powerflow-display/main/sample.gif)
[](sample.gif)

Aimed to display house power flow on a reduced size screen, like Raspberry PI hat, with a resolution of 480x320.

Strongly inspired and based on the work done for Home Assistant on this repo : https://github.com/reptilex/tesla-style-solar-power-card

Build with [Qwik](https://qwik.builder.io/), it's my first attemp with this framework, feel free to raise issue if you have any advices

## How it works
This project connect to a MQTT broker through websocket (usually disabled by default).
Broker configuration can be modified in `src/routes/index.tsx`

It expects the following messages on MQTT :
* `powerinfo/grid` : the power consumed or injected to the grid (negative if injected)
* `powerinfo/house` : the power consumed on the house
* `powerinfo/solar` : the power produced by solar panel
* `powerinfo/heat`: the power consumed by heating

## Project Structure

This project is using Qwik with [QwikCity](https://qwik.builder.io/qwikcity/overview/). QwikCity is just a extra set of tools on top of Qwik to make it easier to build a full site, including directory-based routing, layouts, and more.

Inside your project, you'll see the following directory structure:

```
├── public/
│   └── ...
└── src/
    ├── components/
    │   └── ...
    └── routes/
        └── ...
```

- `src/routes`: Provides the directory based routing, which can include a hierarchy of `layout.tsx` layout files, and an `index.tsx` file as the page. Additionally, `index.ts` files are endpoints. Please see the [routing docs](https://qwik.builder.io/qwikcity/routing/overview/) for more info.

- `src/components`: Recommended directory for components.

- `public`: Any static assets, like images, can be placed in the public directory. Please see the [Vite public directory](https://vitejs.dev/guide/assets.html#the-public-directory) for more info.

## Add Integrations and deployment

Use the `yarn qwik add` command to add additional integrations. Some examples of integrations include: Cloudflare, Netlify or Express server, and the [Static Site Generator (SSG)](https://qwik.builder.io/qwikcity/static-site-generation/static-site-config/).

```shell
yarn qwik add # or `yarn qwik add`
```

## Development

Development mode uses [Vite's development server](https://vitejs.dev/). During development, the `dev` command will server-side render (SSR) the output.

```shell
npm start # or `yarn start`
```

> Note: during dev mode, Vite may request a significant number of `.js` files. This does not represent a Qwik production build.

## Preview

The preview command will create a production build of the client modules, a production build of `src/entry.preview.tsx`, and run a local server. The preview server is only for convenience to locally preview a production build, and it should not be used as a production server.

```shell
yarn preview # or `yarn preview`
```

## Production

The production build will generate client and server modules by running both client and server build commands. Additionally, the build command will use Typescript to run a type check on the source code.

```shell
yarn build # or `yarn build`
```

## Express Server

This app has a minimal [Express server](https://expressjs.com/) implementation. After running a full build, you can preview the build using the command:

```
npm run serve
```

Then visit [http://localhost:8080/](http://localhost:8080/)
