# Builtin Toolchains

Occlum provides multiple builtin toolchains or libraries in the Occlum development docker image to ease the porting or developing effort for users. Part of them are toolchains used to recompile or repackage the applications to make them runnable in Occlum TEE environment. The others are some frequently-used auxiliary libraries which can be directly used or linked by applications running in Occlum.

All the build scripts could be found on [github](https://github.com/occlum/occlum/tree/master/tools/toolchains).

## Toolchains

Generally, Occlum supports both musl-libc and glibc based toolchains. It is up to the users to descide which one to be chosen.

* Less memory footprint, perhaps musl-libc based.
* More compatible to existed applications, maybe glibc based.

### glibc

To support running glibc based application in Occlum, a customized [glibc](https://github.com/occlum/glibc) is provided in the Occlum development docker image.

|    libc   |  Compatible Version in Occlum  | Path in Occlum Docker Image |
| --------- | ------------------------------ | --------------------------- |
|   glibc   | <=2.31<br>(default version in Ubuntu:20.04)  |  /opt/occlum/glibc/lib/ |

The main changes on top of general glibc are as below:

* Redirect syscalls into Occlum
* Support posix_spawn syscall for Occlum
* Modify vdso to calling syscalls in Occlum

To users, all the glibc libraries to be used in Occlum need to be replaced by the ones in ```/opt/occlum/glibc/lib/```.

Thus, Occlum can support `gcc` compilation with **PIE** enabled, which make it compatible to popular compile systems.

### golang
 
To support compiling and running Golang in Occlum LibOS, a customized [go](https://github.com/occlum/go) is provided in the Occlum development docker image, path `/opt/occlum/toolchains/golang`. Every Golang to be executed in Occlum needs to be recompiled by **occlum-go** (a wrapper of go).

Currently Occlum supports two versions of Golang, 1.16 and 1.18 (default one in Occlum development docker image) which are both linked to musl-libc in default. But users can easily configure the **occlum-go** to use **gcc** like below.
```bash
# CC=gcc occlum-go build
```

### java

There are three JAVA versions provided in the Occlum development docker image, path `/opt/occlum/toolchains/jvm`.

|    JDK   |  libc  | Path in Occlum Docker Image |
| --------- | ------ | --------------------------- |
| openjdk8 |  musl-libc |  /opt/occlum/toolchains/jvm/java-1.8-openjdk |
| openjdk11 |  musl-libc |  /opt/occlum/toolchains/jvm/java-11-openjdk |
| dragonwell-jdk11 |  musl-libc |  /opt/occlum/toolchains/jvm/java-11-alibaba-dragonwell |

Both the unmodified openjdk 8/11 in the table are directly imported from Alpine:3.11.

The dragonwell-jdk11 for enclave is a musl-based JDK version compatible with the Alpine Linux and Occlum, and it's an open source project, see [Alibaba Dragonwell](https://github.com/alibaba/dragonwell11/tree/dragonwell-for-enclave).

By default Occlum uses Dragonwell JDK11 as the default JDK. Thus `occlum-java` and `occlum-javac` (provided in the Docker image path **/opt/occlum/toolchains/jvm/bin/**) use Dragonwell JDK11. 

Besides the musl-libc based JDK (less memory footprint), glibc based JDK are also supported. Users are free to change to other JDK version by setting the `JAVA_HOME` to point to the installation directory of OpenJDK and copying it into Occlum instance.

### musl-gcc

To support compiling and running musl-libc based application in Occlum, a customized [musl](https://github.com/occlum/musl) is provided in the Occlum development docker image.

|    libc   |  Compatible Version in Occlum  | Path in Occlum Docker Image |
| --------- | ------------------------------ | --------------------------- |
| musl libc | <=1.1.24<br>(default version in Alpine:3.11) | /usr/local/occlum/x86_64-linux-musl/lib/ |

To users, all the musl-libc libraries to be used in Occlum need to be replaced by the ones in ```/usr/local/occlum/x86_64-linux-musl/lib/```.

Moreover, wrapped **occlum-gcc**, **occlum-g++** and **occlum-ld** are provided as well to do the recompiling if necessary. Any applications generated by these wrapped tools, are expected to run successfully in Occlum.

### rust

Occlum supports general glibc based rust tools such as **cargo** and **rustc**.

Wrapped **occlum-cargo** and **occlum-rustc** are also provided to do musl-libc based rust compilation, which can be found on the path `/opt/occlum/toolchains/rust/bin/` in the Occlum development docker image.

## Auxiliary Libraries

Besides toolchains, several auxiliary libraries to be used in Occlum are provided as well to ease the development effort.

### bash

To support running bash shell script in Occlum, a customized [bash](https://github.com/occlum/bash) is provided in the Occlum development docker image. Both musl-libc and glibc versions are provided in the path `/opt/occlum/toolchains/bash`. Users can use it directly for application in Occlum, details could refer to demo [bash](https://github.com/occlum/occlum/tree/master/demos/bash).

### busybox

To support running general CLI commands in Occlum, a prebuilt busybox is provided in the Occlum development docker image. Both musl-libc and glibc versions are provided in the path `/opt/occlum/toolchains/busybox`. Users can use it directly for application in Occlum, details could refer to demo [bash](https://github.com/occlum/occlum/tree/master/demos/bash).

### DCAP library

Occlum provides wrapped library `libocclum_dcap` for `DCAP` remote attestion applications.
Both musl-libc and glibc versions are provided in the path `/opt/occlum/toolchains/dcap_lib`

```
.
|-- glibc
|   |-- dcap_test
|   |-- libocclum_dcap.a
|   `-- libocclum_dcap.so
|-- inc
|   `-- occlum_dcap.h
`-- musl
    |-- dcap_test
    |-- libocclum_dcap.a
    `-- libocclum_dcap.so
```

Two versions (glibc and musl-libc), including static and dynamic libraries are provided to meet different scenarios. Unified header file `occlum_dcap.h` is provided as well in which defines the exported APIs for DCAP quote generation and verification.

In short, applications can link to the prebuilt `libocclum_dcap.so` and use the APIs defined in `occlum_dcap.h` for their usage.

For details how to use the library, please refer to the [demo](https://github.com/occlum/occlum/tree/master/demos/remote_attestation/dcap).

The source code of the library is in the [path](https://github.com/occlum/occlum/tools/toolchains/dcap_lib/).
