# Quick Start

## Environment 

### Supported HW

First, please make sure the baremetal or VM machine support SGX. Otherwise, users can only try SW simulation mode.

To have best user experience, SGX2 or SGX1 with [FLC](https://www.intel.com/content/www/us/en/developer/articles/technical/an-update-on-3rd-party-attestation.html)(Flexible Launch Control) feature are required. 

Users can use command `cpuid` to detect if the HW satisfy Occlum requirements.

* SGX2, ```cpuid | grep SGX2```
* FLC, ```cpuid | grep SGX_LC```

### Prerequisites

#### Kernel Version

To use SGX in-tree driver, Linux kernel 5.10+ is expected.

For example, in the Ubuntu 20.04 OS (Occlum default development OS), users could update the kernel with below command to get all Occlum required kernel features.
```
$ sudo apt install --install-recommends linux-generic-hwe-20.04
```

#### Start the Occlum dev container
To give Occlum a quick try, one can use the Occlum docker image by following below steps:

Step 1 is to be done on the host OS (Linux).
Step 2-3 are to be done on the guest OS running inside the Docker container.

1. Run the Occlum docker container, which has Occlum and its demos preinstalled:
    ```bash
    # 1. Create softlinks on host
    mkdir -p /dev/sgx
    ln -sf ../sgx_enclave /dev/sgx/enclave
    ln -sf ../sgx_provision /dev/sgx/provision

    # 2. Create container in two methods:
    # (1) With privileged mode
    docker run -it --privileged -v /dev/sgx:/dev/sgx occlum/occlum:[version]-ubuntu20.04

    # (1) With non-privileged mode
    docker run -it --device /dev/sgx/enclave --device /dev/sgx/provision occlum/occlum:[version]-ubuntu20.04
    ```

2. (Optional) Try the sample code of Intel SGX SDK to make sure that SGX is working
    ```
    cd /opt/intel/sgxsdk/SampleCode/SampleEnclave && make && ./app
    ```
3. Check out Occlum's demos preinstalled at `/root/demos`. Or you can try to build and run your own SGX-protected applications using Occlum as shown in the demos.

## Hello World

If you were to write an SGX Hello World project using some SGX SDK, the project would consist of hundreds of lines of code. And to do that, you have to spend a great deal of time to learn the APIs, the programming model, and the build system of the SGX SDK.

Thanks to Occlum, you can be freed from writing any extra SGX-aware code and only need to type some simple commands to protect your application with SGX transparently --- in four easy steps.

**Step 1. Compile the user program with the Occlum toolchain (e.g., `occlum-gcc`)**
```
$ occlum-gcc -o hello_world hello_world.c
$ ./hello_world
Hello World
```
And Occlum can support `gcc` compile as well. The difference is that the binaries generated by `occlum-gcc` are musl-libc based, but are glibc based if compiled by `gcc`.

Note that the Occlum toolchain is not cross-compiling in the traditional sense: the binaries built by the Occlum toolchain is also runnable on Linux. This property makes it convenient to compile, debug, and test user programs intended for Occlum.

**Step 2. Initialize a directory as the Occlum instance via `occlum init` or `occlum new`**
```
$ mkdir occlum_instance && cd occlum_instance
$ occlum init
```
or
```
$ occlum new occlum_instance
```
The `occlum init` command creates the compile-time and run-time state of Occlum in the current working directory. The `occlum new` command does basically the same thing but in a new instance directory. Each Occlum instance directory should be used for a single instance of an application; multiple applications or different instances of a single application should use different Occlum instances.

**Step 3. Generate a secure Occlum FS image and Occlum SGX enclave via `occlum build`**
```
$ cp ../hello_world image/bin/
$ occlum build
```
The content of the `image` directory is initialized by the `occlum init` command. The structure of the `image` directory mimics that of an ordinary UNIX FS, containing directories like `/bin`, `/lib`, `/root`, `/tmp`, etc. After copying the user program `hello_world` into `image/bin/`, the `image` directory is packaged by the `occlum build` command to generate a secure Occlum FS image as well as the Occlum SGX enclave.

For platforms that don't support SGX, it is also possible to run Occlum in SGX simulation mode. To switch to the simulation mode, `occlum build` command must be given an extra argument or an environment variable as shown below:
```
$ occlum build --sgx-mode SIM
```
or
```
$ SGX_MODE=SIM occlum build
```

**Step 4. Run the user program inside an SGX enclave via `occlum run`**
```
$ occlum run /bin/hello_world
Hello World!
```
The `occlum run` command starts up an Occlum SGX enclave, which, behind the scene, verifies and loads the associated Occlum FS image, spawns a new LibOS process to execute `/bin/hello_world`, and eventually prints the message.
