# SGX DCAP Remote Attestation Demo

This project demonstrates how to do Intel SGX DCAP (Datacenter Attestation
Primitives) remote attestation on Occlum. Occlum provides SGX capabilities to
applications through ioctls on device `/dev/sgx`.

## Prerequisites

- Platform: Intel SGX enabled platform with DCAP installed. Follow [DCAP
  Quick Install
  Guide](https://software.intel.com/content/www/us/en/develop/articles/intel-software-guard-extensions-data-center-attestation-primitives-quick-install-guide.html)
  for the detailed installation procedure.

- Occlum: Compile Occlum on a DCAP-installed platform by invoking `make`. The
  compilation will look for the needed DCAP libraries. The needed libraries
  include `libsgx_quote_ex, libsgx_quote_ex_sim, libsgx_dcap_tvl,
  libsgx_dcap_ql and libsgx_dcap_quoteverify`.

You can simply start a Occlum develop container to meet above two.
A valid PCCS service should be accessible in your environment. This demo is verified in Aliyun, thus `https://sgx-dcap-server.cn-shanghai.aliyuncs.com/sgx/certification/v3/` is used as the PCCS URL. For example, 

* Start the Occlum develop container
```
docker run --rm -it \
     --device /dev/sgx/enclave --device /dev/sgx/provision \
     occlum/occlum:latest-ubuntu20.04 bash
```

In the container, update the **pccs_url** in the file `/etc/sgx_default_qcnl.conf` with the valid address.

## Run this demo on Occlum

You can run the DCAP quote generation and verification demo, including rust test demo and C test demo on Occlum via
```
./run_dcap_quote_on_occlum.sh
```

Or if musl-libc version is expected, run
```
./run_dcap_quote_on_occlum.sh musl
```

## Preinstalled DCAP package in Ubuntu 18.04 and CentOS 8.1
The DCAP package has been preinstalled in the Occlum official docker images
including Ubuntu 18.04 and CentOS 8.1 since Occlum 0.19.0. The versions of DCAP
package and PCCS should keep the same to avoid incompatibility. The demo is verified
in Occlum 0.23.1 in which the DCAP version is 1.10, so PCCS should also be version 1.10
to work with the preinstalled DCAP package. Remember to configure `/etc/sgx_default_qcnl.conf`
in the container according to your PCCS setting after running the docker image.

As DCAP 1.10 is not the latest, the demo application running in the container of
the official image will output a warning: `WARN: App: Verification completed
with Non-terminal result: a002`. The `a002` of type `sgx_ql_qv_result_t` in the
warning indicates the quote is good but TCB level of the platform is out of
date.
