import 'dotenv/config';

import { db, type Product } from '.';

const getRandomPrice = () => {
	const PRICES = [9.99, 19.99, 29.99, 39.99, 49.99];
	return PRICES[Math.floor(Math.random() * PRICES.length)];
};

const COLORS = ['white', 'beige', 'blue', 'green', 'purple'] as const;
const SIZES = ['S', 'M', 'L'] as const;

(async () => {
	const products: Product[] = [];

	for (let i = 0; i < 3; i++) {
		for (let j = 0; j < COLORS.length; j++) {
			for (let k = 0; k < SIZES.length; k++) {
				const color = COLORS[j];
				const size = SIZES[k];

				products.push({
					id: `${color}-${size}-${i + 1}`,
					imageUrl: `/images/${color}_${i + 1}.png`,
					color,
					name: `${
						color.slice(0, 1).toUpperCase() + color.slice(1)
					} shirt ${i + 1}`,
					size,
					price: getRandomPrice(),
				});
			}
		}
	}

	const SIZE_MAP = {
		S: 0,
		M: 1,
		L: 2,
	};

	const COLOR_MAP = {
		white: 0,
		beige: 1,
		blue: 2,
		green: 3,
		purple: 4,
	};

	await db.upsert(
		products.map((product) => ({
			id: product.id,
			vector: [COLOR_MAP[product.color], SIZE_MAP[product.size], product.price],
			metadata: product,
		})),
	);
})();
