# Security

Please email [@ljharb](https://github.com/ljharb) or see https://tidelift.com/security if you have a potential security vulnerability to report.

## OpenSSF CII Best Practices

[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/684/badge)](https://bestpractices.coreinfrastructure.org/projects/684)

There are three “tiers”: passing, silver, and gold.

### Passing
We meet 100% of the “passing” criteria.

### Silver
We meet 95% of the “silver” criteria. The gaps are as follows:
  - we do not have a DCO or a CLA process for contributions.
  - because we only have one maintainer, the project has no way to continue if that maintainer stops being active.
  - we do not currently document “what the user can and cannot expect in terms of security” for our project. This is planned to be completed in 2023.

### Gold
We meet 65% of the “gold” criteria. The gaps are as follows:
  - we do not yet have the “silver” badge; see all the gaps above.
  - We do not include a copyright or license statement in each source file. Efforts are underway to change this archaic practice into a suggestion instead of a hard requirement.

## Threat Model

See [THREAT_MODEL.md](./THREAT_MODEL.md).
