---
title: Server
description: 'Learn how to migrate from Nuxt 2 to Nuxt 3 server.'
---

In a built Nuxt 3 application, there is no runtime Nuxt dependency. That means your site will be highly performant, and ultra-slim. But it also means you can no longer hook into runtime Nuxt server hooks.

:read-more{to="/docs/guide/concepts/server-engine"}

## Steps

1. Remove the `render` key in your `nuxt.config`.
2. Any files in `~/server/api` and `~/server/middleware` will be automatically registered; you can remove them from your `serverMiddleware` array.
3. Update any other items in your `serverMiddleware` array to point to files or npm packages directly, rather than using inline functions.

:read-more{to="/docs/guide/directory-structure/server"}
:read-more{to="/docs/guide/going-further/hooks#server-hooks-runtime"}
