---
title: Overview
description: Reduce the differences with Nuxt 3 and reduce the burden of migration to Nuxt 3.
---

::note
If you're starting a fresh Nuxt 3 project, please skip this section and go to [Nuxt 3 Installation](/docs/getting-started/introduction).
::

::warning
Nuxt Bridge provides identical features to Nuxt 3 ([docs](/docs/guide/concepts/auto-imports)) but there are some limitations, notably that [`useAsyncData`](/docs/api/composables/use-async-data) and [`useFetch`](/docs/api/composables/use-fetch) composables are not available. Please read the rest of this page for details.
::

Bridge is a forward-compatibility layer that allows you to experience many of the new Nuxt 3 features by simply installing and enabling a Nuxt module.

Using Nuxt Bridge, you can make sure your project is (almost) ready for Nuxt 3 and you can gradually proceed with the transition to Nuxt 3.

## First Step

### Upgrade Nuxt 2

Make sure your dev server (`nuxt dev`) isn't running, remove any package lock files (`package-lock.json` and `yarn.lock`), and install the latest Nuxt 2 version:

```diff [package.json]
- "nuxt": "^2.16.3"
+ "nuxt": "^2.17.3"
```

Then, reinstall your dependencies:

::package-managers

```bash [npm]
npm install
```

```bash [yarn]
yarn install
```
::

::note
Once the installation is complete, make sure both development and production builds are working as expected before proceeding.
::

### Install Nuxt Bridge

Install `@nuxt/bridge` and `nuxi` as development dependencies:

::package-managers

```bash [npm]
npm install -D @nuxt/bridge nuxi
```

```bash [yarn]
yarn add --dev @nuxt/bridge nuxi
```

::

### Update `nuxt.config`

Please make sure to avoid any CommonJS syntax such as `module.exports`, `require` or `require.resolve` in your config file. It will soon be deprecated and unsupported.

You can use static `import`, dynamic `import()` and `export default` instead. Using TypeScript by renaming to [`nuxt.config.ts`](/docs/guide/directory-structure/nuxt-config) is also possible and recommended.

```ts [nuxt.config.ts]
import { defineNuxtConfig } from '@nuxt/bridge'

export default defineNuxtConfig({
  bridge: false
})
```

### Update Commands

The `nuxt` command should now be changed to the `nuxt2` command.

```diff
{
  "scripts": {
-   "dev": "nuxt",
+   "dev": "nuxt2",
-   "build": "nuxt build",
+   "build": "nuxt2 build",
-   "start": "nuxt start",
+   "start": "nuxt2 start"
  }
}
```

Try running `nuxt2` once here. You will see that the application works as before.

(If 'bridge' is set to false, your application will operate without any changes as before.)

## Upgrade Steps

With Nuxt Bridge, the migration to Nuxt 3 can proceed in steps.
The below `Upgrade Steps` does not need to be done all at once.

- [TypeScript](/docs/bridge/typescript)

- [Migrate Legacy Composition API](/docs/bridge/bridge-composition-api)

- [Plugins and Middleware](/docs/bridge/plugins-and-middleware)

- [Migrate New Composition API](/docs/bridge/nuxt3-compatible-api)

- [Meta Tags](/docs/bridge/meta)

- [Runtime Config](/docs/bridge/runtime-config)

- [Nitro](/docs/bridge/nitro)

- [Vite](/docs/bridge/vite)

## Migrate from CommonJS to ESM

Nuxt 3 natively supports TypeScript and ECMAScript Modules. Please check [Native ES Modules](/docs/guide/concepts/esm) for more info and upgrading.
