---
title: 'Roadmap'
description: 'Nuxt is constantly evolving, with new features and modules being added all the time.'
navigation.icon: i-ph-map-trifold
---

::read-more{to="/blog"}
See our blog for the latest framework and ecosystem announcements.
::

## Status Reports

::read-more{icon="i-simple-icons-github" color="gray" to="https://github.com/nuxt/nuxt/issues/13653" target="_blank"}
Documentation Progress
::
::read-more{icon="i-simple-icons-github" color="gray" to="https://github.com/nuxt/nuxt/discussions/16119" target="_blank"}
Rendering Optimizations: Today and Tomorrow
::
::read-more{icon="i-simple-icons-github" color="gray" to="https://github.com/nuxt/image/discussions/563" target="_blank"}
Nuxt Image: Performance and Status
::

## Roadmap

In roadmap below are some features we are planning or working on at the moment.

::tip
Check [Discussions](https://github.com/nuxt/nuxt/discussions) and [RFCs](https://github.com/nuxt/nuxt/discussions/categories/rfcs) for more upcoming features and ideas.
::

Milestone    | Expected date | Notes                                                                  | Description
-------------|---------------|------------------------------------------------------------------------|-----------------------
SEO & PWA    | 2024          | [nuxt/nuxt#18395](https://github.com/nuxt/nuxt/discussions/18395)      | Migrating from [nuxt-community/pwa-module](https://github.com/nuxt-community/pwa-module) for built-in SEO utils and service worker support
Assets       | 2024          | [nuxt/nuxt#22012](https://github.com/nuxt/nuxt/discussions/22012)      | Allow developers and modules to handle loading third-party assets.
Translations | -             | [nuxt/translations#4](https://github.com/nuxt/translations/discussions/4) ([request access](https://github.com/nuxt/nuxt/discussions/16054)) | A collaborative project for a stable translation process for Nuxt docs. Currently pending for ideas and documentation tooling support (content v2 with remote sources).

## Core Modules Roadmap

In addition to the Nuxt framework, there are modules that are vital for the ecosystem. Their status will be updated below.

Module                              | Status              | Nuxt Support | Repository | Description
------------------------------------|---------------------|--------------|------------|-------------------
[Scripts](https://scripts.nuxt.com) | Public Beta         | 3.x          | [nuxt/scripts](https://github.com/nuxt/scripts) | Easy 3rd party script management.
A11y                                | Planned             | 3.x          | `nuxt/a11y` to be announced | Accessibility hinting and utilities [nuxt/nuxt#23255](https://github.com/nuxt/nuxt/issues/23255)
Auth                                | Planned             | 3.x          | `nuxt/auth` to be announced | Support is planned after session support.
Hints                               | Planned             | 3.x          | `nuxt/hints` to be announced | Guidance and suggestions for enhancing development practices.

## Release Cycle

Since January 2023, we've adopted a consistent release cycle for **Nuxt 3**, following [semver](https://semver.org). We aim for major framework releases every year, with an expectation of patch releases every week or so and minor releases every month or so. They should never contain breaking changes except within options clearly marked as `experimental`.

### Ongoing Support for Nuxt

Going forward from v3, we commit to support each major version of Nuxt for a minimum of a year after the last release, and to providing an upgrade path for current users at that point.

### Current Packages

The current active version of [Nuxt](https://nuxt.com) is **v3** which is available as `nuxt` on npm with the `latest` tag.

Nuxt 2 is in maintenance mode and is available on npm with the `2x` tag. It will reach End of Life (EOL) on June 30, 2024.

Each active version has its own nightly releases which are generated automatically. For more about enabling the Nuxt nightly release channel, see [the nightly release channel docs](/docs/guide/going-further/nightly-release-channel).

Release                                 |                                                                                                  | Initial release | End Of Life  | Docs
----------------------------------------|---------------------------------------------------------------------------------------------------|-----------------|--------------|-------
**4.x** (scheduled)                     |                                                                                           | 2024 Q3         |              | &nbsp;
**3.x** (stable)           | <a href="https://npmjs.com/package/nuxt"><img alt="Nuxt latest 3.x version" src="https://flat.badgen.net/npm/v/nuxt?label=" class="not-prose"></a>            | 2022-11-16      | TBA          | [nuxt.com](/docs)
**2.x** (unsupported)      | <a href="https://www.npmjs.com/package/nuxt?activeTab=versions"><img alt="Nuxt 2.x version" src="https://flat.badgen.net/npm/v/nuxt/2x?label=" class="not-prose"></a>         | 2018-09-21      | 2024-06-30   | [v2.nuxt.com](https://v2.nuxt.com/docs)
**1.x** (unsupported)      | <a href="https://www.npmjs.com/package/nuxt?activeTab=versions"><img alt="Nuxt 1.x version" src="https://flat.badgen.net/npm/v/nuxt/1x?label=" class="not-prose"></a>         | 2018-01-08      | 2019-09-21 | &nbsp;

### Support Status

Status      | Description
------------|----------------------------------------------------------------------------------
Unsupported | This version is not maintained any more and will not receive security patches
Maintenance | This version will only receive security patches
Stable      | This version is being developed for and will receive security patches
Development | This version could be unstable
Scheduled   | This version does not exist yet but is planned
