---
title: 'Framework'
navigation.icon: i-ph-github-logo
description: Some specific points about contributions to the framework repository.
---

Once you've read the [general contribution guide](/docs/community/contribution), here are some specific points to make about contributions to the [`nuxt/nuxt`](https://github.com/nuxt/nuxt) repository.

## Monorepo Guide

- `packages/kit`: Toolkit for authoring Nuxt Modules, published as [`@nuxt/kit`](https://npmjs.com/package/@nuxt/kit).
- `packages/nuxt`: The core of Nuxt, published as [`nuxt`](https://npmjs.com/package/nuxt).
- `packages/schema`: Cross-version Nuxt typedefs and defaults, published as [`@nuxt/schema`](https://npmjs.com/package/@nuxt/schema).
- `packages/test-utils`: Test utilities for Nuxt, published as [`@nuxt/test-utils`](https://npmjs.com/package/@nuxt/test-utils).
- `packages/vite`: The [Vite](https://vitejs.dev) bundler for Nuxt, published as [`@nuxt/vite-builder`](https://npmjs.com/package/@nuxt/vite-builder).
- `packages/webpack`: The [webpack](https://webpack.js.org) bundler for Nuxt 3, published as [`@nuxt/webpack-builder`](https://npmjs.com/package/@nuxt/webpack-builder).

## Setup

To contribute to Nuxt, you need to set up a local environment.

1. [Fork](https://help.github.com/articles/fork-a-repo) the [`nuxt/nuxt`](https://github.com/nuxt/nuxt)  repository to your own GitHub account and then [clone](https://help.github.com/articles/cloning-a-repository) it to your local device.
2. Ensure using the latest [Node.js](https://nodejs.org/en) (20.x)
3. Enable [Corepack](https://github.com/nodejs/corepack) to have `pnpm` and `yarn`
    ```bash [Terminal]
    corepack enable
    ```
4. Run `pnpm install --frozen-lockfile` to Install the dependencies with pnpm:
    ```bash [Terminal]
    pnpm install --frozen-lockfile
    ```
    ::note
    If you are adding a dependency, please use `pnpm add`. :br
    The `pnpm-lock.yaml` file is the source of truth for all Nuxt dependencies.
    ::
5. Activate the passive development system
    ```bash [Terminal]
    pnpm dev:prepare
    ```
6. Check out a branch where you can work and commit your changes:
    ```bash [Terminal]
    git checkout -b my-new-branch
    ```

Then, test your changes against the [playground](#playground) and [test](#testing) your changes before submitting a pull request.

### Playground

While working on a pull request, you will likely want to check if your changes are working correctly.

You can modify the example app in `playground/`, and run:

```bash [Terminal]
pnpm dev
```

::important
Please make sure not to commit it to your branch, but it could be helpful to add some example code to your PR description. This can help reviewers and other Nuxt users understand the feature you've built in-depth.
::

### Testing

Every new feature should have a corresponding unit test (if possible). The `test/` directory in this repository is currently a work in progress, but do your best to create a new test following the example of what's already there.

Before creating a PR or marking it as ready-to-review, ensure that all tests pass by running:

```bash [Terminal]
pnpm test
```

### Linting

You might have noticed already that we use ESLint to enforce a coding standard.

Before committing your changes, to verify that the code style is correct, run:

```bash [Terminal]
pnpm lint
```

::note
You can use `pnpm lint --fix` to fix most of the style changes. :br
If there are still errors left, you must correct them manually.
::

### Documentation

If you are adding a new feature or refactoring or changing the behavior of Nuxt in any other manner, you'll likely want to document the changes. Please include any changes to the docs in the same PR. You don't have to write documentation up on the first commit (but please do so as soon as your pull request is mature enough).

::important
Make sure to make changes according to the [Documentation Style Guide](/docs/community/contribution#documentation-style-guide).
::

### Final Checklist

When submitting your PR, there is a simple template that you have to fill out. Please tick all appropriate "answers" in the checklists.

## Documentation Guide

If you spot an area where we can improve documentation or error messages, please do open a PR - even if it's just to fix a typo!

::important
Make sure to make changes according to the [Documentation Style Guide](/docs/community/contribution#documentation-style-guide).
::

### Quick Edits

If you spot a typo or want to rephrase a sentence, you can click on the **Edit this page** link located on the right aside in the **Community** section.

Make the change directly in the GitHub interface and open a Pull Request.

### Longer Edits

The documentation content is inside the `docs/` directory of the [nuxt/nuxt](https://github.com/nuxt/nuxt) repository and written in markdown.

::note
To preview the docs locally, follow the steps on [nuxt/nuxt.com](https://github.com/nuxt/nuxt.com) repository.
::

::note
We recommend that you install the [MDC extension](https://marketplace.visualstudio.com/items?itemName=Nuxt.mdc) for VS Code.
::

### Linting Docs

Documentation is linted using [MarkdownLint](https://github.com/DavidAnson/markdownlint) and [case police](https://github.com/antfu/case-police) to keep the documentation cohesive.

```bash [Terminal]
pnpm lint:docs
```

::note
You can also run `pnpm lint:docs:fix` to highlight and resolve any lint issues.
::

### Open a PR

Please make sure your PR title adheres to the [conventional commits](https://www.conventionalcommits.org) guidelines.

```bash [Example of PR title]
docs: update the section about the nuxt.config.ts file
```
