---
title: "Layout"
description: "Nuxt Kit provides a set of utilities to help you work with layouts."
links:
  - label: Source
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/kit/src/layout.ts
    size: xs
---

Layouts is used to be a wrapper around your pages. It can be used to wrap your pages with common components, for example, a header and a footer. Layouts can be registered using `addLayout` utility.

## `addLayout`

Register template as layout and add it to the layouts.

::note
In Nuxt 2 `error` layout can also be registered using this utility. In Nuxt 3+ `error` layout [replaced](/docs/getting-started/error-handling#rendering-an-error-page) with `error.vue` page in project root.
::

### Type

```ts
function addLayout (layout: NuxtTemplate | string, name: string): void

interface NuxtTemplate {
  src?: string
  filename?: string
  dst?: string
  options?: Record<string, any>
  getContents?: (data: Record<string, any>) => string | Promise<string>
  write?: boolean
}
```

### Parameters

#### `layout`

**Type**: `NuxtTemplate | string`

**Required**: `true`

A template object or a string with the path to the template. If a string is provided, it will be converted to a template object with `src` set to the string value. If a template object is provided, it must have the following properties:

- `src` (optional)

  **Type**: `string`

  Path to the template. If `src` is not provided, `getContents` must be provided instead.

- `filename` (optional)

  **Type**: `string`

  Filename of the template. If `filename` is not provided, it will be generated from the `src` path. In this case, the `src` option is required.

- `dst` (optional)

  **Type**: `string`

  Path to the destination file. If `dst` is not provided, it will be generated from the `filename` path and nuxt `buildDir` option.

- `options` (optional)

  **Type**: `Options`

  Options to pass to the template.

- `getContents` (optional)

  **Type**: `(data: Options) => string | Promise<string>`

  A function that will be called with the `options` object. It should return a string or a promise that resolves to a string. If `src` is provided, this function will be ignored.

- `write` (optional)

    **Type**: `boolean`

    If set to `true`, the template will be written to the destination file. Otherwise, the template will be used only in virtual filesystem.
