---
title: "Compatibility"
description: Nuxt Kit provides a set of utilities to help you check the compatibility of your modules with different Nuxt versions.
links:
  - label: Source
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/kit/src/compatibility.ts
    size: xs
---

Nuxt Kit utilities can be used in Nuxt 3, Nuxt 2 with Bridge and even Nuxt 2 without Bridge. To make sure your module is compatible with all versions, you can use the `checkNuxtCompatibility`, `assertNuxtCompatibility` and `hasNuxtCompatibility` functions. They will check if the current Nuxt version meets the constraints you provide. Also you can use `isNuxt2`, `isNuxt3` and `getNuxtVersion` functions for more granular checks.

## `checkNuxtCompatibility`

Checks if constraints are met for the current Nuxt version. If not, returns an array of messages. Nuxt 2 version also checks for `bridge` support.

### Type

```ts
async function checkNuxtCompatibility(
  constraints: NuxtCompatibility,
  nuxt?: Nuxt
): Promise<NuxtCompatibilityIssues>;

interface NuxtCompatibility {
  nuxt?: string;
  bridge?: boolean;
  builder?: {
    // Set `false` if your module is not compatible with a builder
    // or a semver-compatible string version constraint
    vite?: false | string;
    webpack?: false | string;
  };
}

interface NuxtCompatibilityIssue {
  name: string;
  message: string;
}

interface NuxtCompatibilityIssues extends Array<NuxtCompatibilityIssue> {
  toString(): string;
}
```

### Parameters

#### `constraints`

**Type**: `NuxtCompatibility`

**Default**: `{}`

Constraints to check for. It accepts the following properties:

- `nuxt` (optional)

  **Type**: `string`

  Nuxt version in semver format. Versions may be defined in Node.js way, for example: `>=2.15.0 <3.0.0`.

- `bridge` (optional)

  **Type**: `boolean`

  If set to `true`, it will check if the current Nuxt version supports `bridge`.

#### `nuxt`

**Type**: `Nuxt`

**Default**: `useNuxt()`

Nuxt instance. If not provided, it will be retrieved from the context via `useNuxt()` call.

## `assertNuxtCompatibility`

Asserts that constraints are met for the current Nuxt version. If not, throws an error with the list of issues as string.

### Type

```ts
async function assertNuxtCompatibility(
  constraints: NuxtCompatibility,
  nuxt?: Nuxt
): Promise<true>;

interface NuxtCompatibility {
  nuxt?: string;
  bridge?: boolean;
}
```

### Parameters

#### `constraints`

**Type**: `NuxtCompatibility`

**Default**: `{}`

Constraints to check for. It accepts the following properties:

- `nuxt` (optional)

  **Type**: `string`

  Nuxt version in semver format. Versions may be defined in Node.js way, for example: `>=2.15.0 <3.0.0`.

- `bridge` (optional)

  **Type**: `boolean`

  If set to `true`, it will check if the current Nuxt version supports `bridge`.

#### `nuxt`

**Type**: `Nuxt`

**Default**: `useNuxt()`

Nuxt instance. If not provided, it will be retrieved from the context via `useNuxt()` call.

## `hasNuxtCompatibility`

Checks if constraints are met for the current Nuxt version. Return `true` if all constraints are met, otherwise returns `false`. Nuxt 2 version also checks for `bridge` support.

### Type

```ts
async function hasNuxtCompatibility(
  constraints: NuxtCompatibility,
  nuxt?: Nuxt
): Promise<boolean>;

interface NuxtCompatibility {
  nuxt?: string;
  bridge?: boolean;
}
```

### Parameters

#### `constraints`

**Type**: `NuxtCompatibility`

**Default**: `{}`

Constraints to check for. It accepts the following properties:

- `nuxt` (optional)

  **Type**: `string`

  Nuxt version in semver format. Versions may be defined in Node.js way, for example: `>=2.15.0 <3.0.0`.

- `bridge` (optional)

  **Type**: `boolean`

  If set to `true`, it will check if the current Nuxt version supports `bridge`.

#### `nuxt`

**Type**: `Nuxt`

**Default**: `useNuxt()`

Nuxt instance. If not provided, it will be retrieved from the context via `useNuxt()` call.

## `isNuxt2`

Checks if the current Nuxt version is 2.x.

### Type

```ts
function isNuxt2(nuxt?: Nuxt): boolean;
```

### Parameters

#### `nuxt`

**Type**: `Nuxt`

**Default**: `useNuxt()`

Nuxt instance. If not provided, it will be retrieved from the context via `useNuxt()` call.

## `isNuxt3`

Checks if the current Nuxt version is 3.x.

### Type

```ts
function isNuxt3(nuxt?: Nuxt): boolean;
```

### Parameters

#### `nuxt`

**Type**: `Nuxt`

**Default**: `useNuxt()`

Nuxt instance. If not provided, it will be retrieved from the context via `useNuxt()` call.

## `getNuxtVersion`

Returns the current Nuxt version.

### Type

```ts
function getNuxtVersion(nuxt?: Nuxt): string;
```

### Parameters

#### `nuxt`

**Type**: `Nuxt`

**Default**: `useNuxt()`

Nuxt instance. If not provided, it will be retrieved from the context via `useNuxt()` call.
