---
title: "Programmatic Usage"
description: Nuxt Kit provides a set of utilities to help you work with Nuxt programmatically. These functions allow you to load Nuxt, build Nuxt, and load Nuxt configuration.
links:
  - label: Source
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/kit/src/loader
    size: xs
---

Programmatic usage can be helpful when you want to use Nuxt programmatically, for example, when building a [CLI tool](https://github.com/nuxt/cli) or [test utils](https://github.com/nuxt/nuxt/tree/main/packages/test-utils).

## `loadNuxt`

Load Nuxt programmatically. It will load the Nuxt configuration, instantiate and return the promise with Nuxt instance.

### Type

```ts
async function loadNuxt (loadOptions?: LoadNuxtOptions): Promise<Nuxt>

interface LoadNuxtOptions extends LoadNuxtConfigOptions {
  dev?: boolean
  ready?: boolean
}
```

### Parameters

#### `loadOptions`

**Type**: `LoadNuxtOptions`

**Default**: `{}`

Loading conditions for Nuxt. `loadNuxt` uses [`c12`](https://github.com/unjs/c12) under the hood, so it accepts the same options as `c12.loadConfig` with some additional options:

- `dev` (optional)

  **Type**: `boolean`

  **Default**: `false`

  If set to `true`, Nuxt will be loaded in development mode.

- `ready` (optional)
  
  **Type**: `boolean`
  
  **Default**: `true`
  
  If set to `true`, Nuxt will be ready to use after the `loadNuxt` call. If set to `false`, you will need to call `nuxt.ready()` to make sure Nuxt is ready to use.

## `buildNuxt`

Build Nuxt programmatically. It will invoke the builder (currently [@nuxt/vite-builder](https://github.com/nuxt/nuxt/tree/main/packages/vite) or [@nuxt/webpack-builder](https://github.com/nuxt/nuxt/tree/main/packages/webpack)) to bundle the application.

### Type

```ts
async function buildNuxt (nuxt: Nuxt): Promise<any>
```

### Parameters

#### `nuxt`

**Type**: `Nuxt`

**Required**: `true`

Nuxt instance to build. It can be retrieved from the context via `useNuxt()` call.

## `loadNuxtConfig`

Load Nuxt configuration. It will return the promise with the configuration object.

### Type

```ts
async function loadNuxtConfig (options: LoadNuxtConfigOptions): Promise<NuxtOptions>
```

### Parameters

#### `options`

**Type**: `LoadNuxtConfigOptions`

**Required**: `true`

Options to pass in [`c12`](https://github.com/unjs/c12#options) `loadConfig` call.

## `writeTypes`

Generates tsconfig.json and writes it to the project buildDir.

### Type

```ts
function writeTypes (nuxt?: Nuxt): void

interface Nuxt {
  options: NuxtOptions
  hooks: Hookable<NuxtHooks>
  hook: Nuxt['hooks']['hook']
  callHook: Nuxt['hooks']['callHook']
  addHooks: Nuxt['hooks']['addHooks']
  ready: () => Promise<void>
  close: () => Promise<void>
  server?: any
  vfs: Record<string, string>
  apps: Record<string, NuxtApp>
}
```

### Parameters

#### `nuxt`

**Type**: `Nuxt`

**Required**: `true`

Nuxt instance to build. It can be retrieved from the context via `useNuxt()` call.
