---
title: "Logging"
description: Nuxt Kit provides a set of utilities to help you work with logging. These functions allow you to log messages with extra features.
links:
  - label: Source
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/kit/src/logger.ts
    size: xs
---

Nuxt provides a logger instance that you can use to log messages with extra features. `useLogger` allows you to get a logger instance.

## `useLogger`

Returns a logger instance. It uses [consola](https://github.com/unjs/consola) under the hood.

### Type

```ts
function useLogger (tag?: string, options?: Partial<ConsolaOptions>): ConsolaInstance
```

### Parameters

#### `tag`

**Type**: `string`

***Optional**: `true`

A tag to prefix all log messages with.

#### `options`

**Type**: `Partial<ConsolaOptions>`

***Optional**: `true`

Consola configuration options

### Examples

```ts
import { defineNuxtModule, useLogger } from '@nuxt/kit'

export default defineNuxtModule({
  setup(options, nuxt) {
    const logger = useLogger('my-module')

    logger.info('Hello from my module!')
  }
})
```

```ts
import { defineNuxtModule, useLogger } from '@nuxt/kit'

export default defineNuxtModule({
  setup(options, nuxt) {
    const logger = useLogger('my-module', { level: options.quiet ? 0 : 3 })

    logger.info('Hello from my module!')
  }
})
```
