---
title: "<NuxtErrorBoundary>"
description: The <NuxtErrorBoundary> component handles client-side errors happening in its default slot.
links:
  - label: Source
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/nuxt/src/app/components/nuxt-error-boundary.ts
    size: xs
---

::tip
The `<NuxtErrorBoundary>` uses Vue's [`onErrorCaptured`](https://vuejs.org/api/composition-api-lifecycle.html#onerrorcaptured) hook under the hood.
::

## Events

- `@error`: Event emitted when the default slot of the component throws an error.

  ```vue
  <template>
    <NuxtErrorBoundary @error="logSomeError">
      <!-- ... -->
    </NuxtErrorBoundary>
  </template>
  ```

## Slots

- `#error`: Specify a fallback content to display in case of error.

  ```vue
    <template>
      <NuxtErrorBoundary>
        <!-- ... -->
        <template #error="{ error }">
          <p>An error occurred: {{ error }}</p>
        </template>
      </NuxtErrorBoundary>
    </template>
  ```

:read-more{to="/docs/getting-started/error-handling"}
