---
title: "<NuxtClientFallback>"
description: "Nuxt provides the <NuxtClientFallback> component to render its content on the client if any of its children trigger an error in SSR"
links:
  - label: Source (client)
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/nuxt/src/app/components/client-fallback.client.ts
    size: xs
  - label: Source (server)
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/nuxt/src/app/components/client-fallback.server.ts
    size: xs
---

Nuxt provides the `<NuxtClientFallback>` component to render its content on the client if any of its children trigger an error in SSR.

::note{to="/docs/guide/going-further/experimental-features#clientfallback"}
This component is experimental and in order to use it you must enable the `experimental.clientFallback` option in your `nuxt.config`.
::

```vue [pages/example.vue]
<template>
  <div>
    <Sidebar />
    <!-- this component will be rendered on client-side -->
    <NuxtClientFallback fallback-tag="span">
      <Comments />
      <BrokeInSSR />
    </NuxtClientFallback>
  </div>
</template>
```

## Events

- `@ssr-error`: Event emitted when a child triggers an error in SSR. Note that this will only be triggered on the server.

  ```vue
  <template>
    <NuxtClientFallback @ssr-error="logSomeError">
      <!-- ... -->
    </NuxtClientFallback>
  </template>
  ```

## Props

- `placeholderTag` | `fallbackTag`: Specify a fallback tag to be rendered if the slot fails to render on the server.
  - **type**: `string`
  - **default**: `div`
- `placeholder` | `fallback`: Specify fallback content to be rendered if the slot fails to render.
  - **type**: `string`
- `keepFallback`: Keep the fallback content if it failed to render server-side.
  - **type**: `boolean`
  - **default**: `false`

```vue
  <template>
    <!-- render <span>Hello world</span> server-side if the default slot fails to render -->
    <NuxtClientFallback fallback-tag="span" fallback="Hello world">
      <BrokeInSsr />
    </NuxtClientFallback>
  </template>
```

## Slots

- `#fallback`: specify content to be displayed server-side if the slot fails to render.

```vue
<template>
  <NuxtClientFallback>
    <!-- ... -->
    <template #fallback>
      <!-- this will be rendered on server side if the default slot fails to render in ssr -->
      <p>Hello world</p>
    </template>
  </NuxtClientFallback>
</template>
```
