---
navigation.title: 'Vite Plugins'
title: Using Vite Plugins in Nuxt
description: Learn how to integrate Vite plugins into your Nuxt project.
---

While Nuxt modules offer extensive functionality, sometimes a specific Vite plugin might meet your needs more directly.

First, we need to install the Vite plugin, for our example, we'll use `@rollup/plugin-yaml`:

::package-managers

  ```bash [npm]
  npm install @rollup/plugin-yaml
  ```

  ```bash [yarn]
  yarn add @rollup/plugin-yaml
  ```

  ```bash [pnpm]
  pnpm add @rollup/plugin-yaml
  ```

  ```bash [bun]
  bun add @rollup/plugin-yaml
  ```

::

Next, we need to import and add it to our [`nuxt.config.ts`](/docs/guide/directory-structure/nuxt-config) file:

```ts [nuxt.config.ts]
import yaml from '@rollup/plugin-yaml'

export default defineNuxtConfig({
  vite: {
    plugins: [
      yaml()
    ]
  }
})
```

Now we installed and configured our Vite plugin, we can start using YAML files directly in our project.

For example, we can have a `config.yaml` that stores configuration data and import this data in our Nuxt components:

::code-group

```yaml [data/hello.yaml]
greeting: "Hello, Nuxt with Vite!"
```

```vue [components/Hello.vue]
<script setup>
import config from '~/data/hello.yaml'
</script>

<template>
  <h1>{{ config.greeting }}</h1>
</template>
```

::
