---
title: "NuxtApp"
description: "In Nuxt 3, you can access runtime app context within composables, components and plugins."
links:
  - label: Source
    icon: i-simple-icons-github
    to: https://github.com/nuxt/nuxt/blob/main/packages/nuxt/src/app/nuxt.ts
---

In Nuxt 3, you can access runtime app context within composables, components and plugins.

::read-more{to="https://v2.nuxt.com/docs/internals-glossary/context#the-context" target="_blank"}
In Nuxt 2, this was referred to as **Nuxt context**.
::

## Nuxt App Interface

::read-more{to="/docs/guide/going-further/internals#the-nuxtapp-interface"}
Jump over the `NuxtApp` interface documentation.
::

## The Nuxt Context

Many composables and utilities, both built-in and user-made, may require access to the Nuxt instance. This doesn't exist everywhere on your application, because a fresh instance is created on every request.

Currently, the Nuxt context is only accessible in [plugins](/docs/guide/directory-structure/plugins), [Nuxt hooks](/docs/guide/going-further/hooks), [Nuxt middleware](/docs/guide/directory-structure/middleware), and [setup functions](https://vuejs.org/api/composition-api-setup.html) (in pages and components).

If a composable is called without access to the context, you may get an error stating that 'A composable that requires access to the Nuxt instance was called outside of a plugin, Nuxt hook, Nuxt middleware, or Vue setup function.' In that case, you can also explicitly call functions within this context by using [`nuxtApp.runWithContext`](/docs/api/composables/use-nuxt-app#runwithcontext).

## Accessing NuxtApp

Within composables, plugins and components you can access `nuxtApp` with [`useNuxtApp()`](/docs/api/composables/use-nuxt-app):

```ts [composables/useMyComposable.ts]
export function useMyComposable () {
  const nuxtApp = useNuxtApp()
  // access runtime nuxt app instance
}
```

If your composable does not always need `nuxtApp` or you simply want to check if it is present or not, since [`useNuxtApp`](/docs/api/composables/use-nuxt-app) throws an exception, you can use [`tryUseNuxtApp`](/docs/api/composables/use-nuxt-app#tryusenuxtapp) instead.

Plugins also receive `nuxtApp` as the first argument for convenience.

:read-more{to="/docs/guide/directory-structure/plugins"}

## Providing Helpers

You can provide helpers to be usable across all composables and application. This usually happens within a Nuxt plugin.

```ts
const nuxtApp = useNuxtApp()
nuxtApp.provide('hello', (name) => `Hello ${name}!`)

console.log(nuxtApp.$hello('name')) // Prints "Hello name!"
```

::read-more{to="/docs/guide/directory-structure/plugins#providing-helpers"}
It is possible to inject helpers by returning an object with a `provide` key in plugins.
::

::read-more{to="https://v2.nuxt.com/docs/directory-structure/plugins#inject-in-root--context" target="_blank"}
In Nuxt 2 plugins, this was referred to as **inject function**.
::
