---
title: "Nuxt Kit"
description: "@nuxt/kit provides features for module authors."
---

Nuxt Kit provides composable utilities to make interacting with [Nuxt Hooks](/docs/api/advanced/hooks), the [Nuxt Interface](/docs/guide/going-further/internals#the-nuxt-interface) and developing [Nuxt Modules](/docs/guide/going-further/modules) super easy.

::read-more{to="/docs/api/kit"}
Discover all Nuxt Kit utilities.
::

## Usage

### Install Dependency

You can install the latest Nuxt Kit by adding it to the `dependencies` section of your `package.json`. However, please consider always explicitly installing the `@nuxt/kit` package even if it is already installed by Nuxt.

::note
`@nuxt/kit` and `@nuxt/schema` are key dependencies for Nuxt. If you are installing it separately, make sure that the versions of `@nuxt/kit` and `@nuxt/schema` are equal to or greater than your `nuxt` version to avoid any unexpected behavior.
::

```json [package.json]
{
  "dependencies": {
    "@nuxt/kit": "npm:@nuxt/kit-nightly@latest"
  }
}
```

### Import Kit Utilities

```js [test.mjs]
import { useNuxt } from '@nuxt/kit'
```

:read-more{to="/docs/api/kit"}

::note
Nuxt Kit utilities are only available for modules and not meant to be imported in runtime (components, Vue composables, pages, plugins, or server routes).
::

Nuxt Kit is an [esm-only package](/docs/guide/concepts/esm) meaning that you **cannot** `require('@nuxt/kit')`. As a workaround, use dynamic import in the CommonJS context:

```js [test.cjs]
// This does NOT work!
// const kit = require('@nuxt/kit')
async function main() {
  const kit = await import('@nuxt/kit')
}
main()
```
