---
title: "Nightly Release Channel"
description: "The nightly release channel allows using Nuxt built directly from the latest commits to the repository."
---

Nuxt lands commits, improvements, and bug fixes every day. You can opt in to test them earlier before the next release.

After a commit is merged into the `main` branch of [nuxt/nuxt](https://github.com/nuxt/nuxt) and **passes all tests**, we trigger an automated npm release, using GitHub Actions.

You can use these 'nightly' releases to beta test new features and changes.

The build and publishing method and quality of these 'nightly' releases are the same as stable ones. The only difference is that you should often check the GitHub repository for updates. There is a slight chance of regressions not being caught during the review process and by the automated tests. Therefore, we internally use this channel to double-check everything before each release.

::note
Features that are only available on the nightly release channel are marked with an alert in the documentation.
::

::alert{type="warning"}
The `latest` nightly release channel is currently tracking the Nuxt v4 branch, meaning that it is particularly likely to have breaking changes right now - be careful!

You can opt in to the 3.x branch nightly releases with `"nuxt": "npm:nuxt-nightly@3x"`.
::

## Opting In

Update `nuxt` dependency inside `package.json`:

```diff [package.json]
{
  "devDependencies": {
--    "nuxt": "^3.0.0"
++    "nuxt": "npm:nuxt-nightly@latest"
  }
}
```

Remove lockfile (`package-lock.json`, `yarn.lock`, `pnpm-lock.yaml`, or `bun.lockb`) and reinstall dependencies.

## Opting Out

Update `nuxt` dependency inside `package.json`:

```diff [package.json]
{
  "devDependencies": {
--    "nuxt": "npm:nuxt-nightly@latest"
++    "nuxt": "^3.0.0"
  }
}
```

Remove lockfile (`package-lock.json`, `yarn.lock`, `pnpm-lock.yaml`, or `bun.lockb`) and reinstall dependencies.

## Using Nightly `nuxi`

::note
All cli dependencies are bundled because of the building method for reducing `nuxi` package size. :br You can get dependency updates and CLI improvements using the nightly release channel.
::

To try the latest version of [nuxt/cli](https://github.com/nuxt/cli):

```bash [Terminal]
npx nuxi-nightly@latest [command]
```

::read-more{to="/docs/api/commands"}
Read more about the available commands.
::
