---
title: "app.vue"
description: "The app.vue file is the main component of your Nuxt application."
head.title: "app.vue"
navigation.icon: i-ph-file
---

## Minimal Usage

With Nuxt 3, the [`pages/`](/docs/guide/directory-structure/pages) directory is optional. If not present, Nuxt won't include [vue-router](https://router.vuejs.org) dependency. This is useful when working on a landing page or an application that does not need routing.

```vue [app.vue]
<template>
  <h1>Hello World!</h1>
</template>
```

:link-example{to="/docs/examples/hello-world"}

## Usage with Pages

If you have a [`pages/`](/docs/guide/directory-structure/pages) directory, to display the current page, use the [`<NuxtPage>`](/docs/api/components/nuxt-page) component:

```vue [app.vue]
<template>
  <div>
    <NuxtLayout>
      <NuxtPage/>
    </NuxtLayout>
  </div>
</template>
```

::warning
Since [`<NuxtPage>`](/docs/api/components/nuxt-page) internally uses Vue's [`<Suspense>`](https://vuejs.org/guide/built-ins/suspense.html#suspense) component, it cannot be set as a root element.
::

::note
Remember that `app.vue` acts as the main component of your Nuxt application. Anything you add to it (JS and CSS) will be global and included in every page.
::

::read-more{to="/docs/guide/directory-structure/layouts"}
If you want to have the possibility to customize the structure around the page between pages, check out the `layouts/` directory.
::
