---
title: 'Layers'
description: Nuxt provides a powerful system that allows you to extend the default files, configs, and much more.
navigation.icon: i-ph-stack
---

One of the core features of Nuxt is the layers and extending support. You can extend a default Nuxt application to reuse components, utils, and configuration. The layers structure is almost identical to a standard Nuxt application which makes them easy to author and maintain.

## Use Cases

- Share reusable configuration presets across projects using `nuxt.config` and `app.config`
- Create a component library using [`components/`](/docs/guide/directory-structure/components) directory
- Create utility and composable library using [`composables/`](/docs/guide/directory-structure/composables) and [`utils/`](/docs/guide/directory-structure/utils) directories
- Create Nuxt module presets
- Share standard setup across projects
- Create Nuxt themes
- Enhance code organization by implementing a modular architecture and support Domain-Driven Design (DDD) pattern in large scale projects.

## Usage

By default, any layers within your project in the `~/layers` directory will be automatically registered as layers in your project

::note
Layer auto-registration was introduced in Nuxt v3.12.0
::

In addition, you can extend from a layer by adding the [extends](/docs/api/nuxt-config#extends) property to your [`nuxt.config`](/docs/guide/directory-structure/nuxt-config) file.

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  extends: [
    '../base',                     // Extend from a local layer
    '@my-themes/awesome',          // Extend from an installed npm package
    'github:my-themes/awesome#v1', // Extend from a git repository
  ]
})
```

You can also pass an authentication token if you are extending from a private GitHub repository:

```ts [nuxt.config.ts]
export default defineNuxtConfig({
  extends: [
    // per layer configuration
    ['github:my-themes/private-awesome', { auth: process.env.GITHUB_TOKEN }]
  ]
})
```

Nuxt uses [unjs/c12](https://c12.unjs.io) and [unjs/giget](https://giget.unjs.io) for extending remote layers. Check the documentation for more information and all available options.

::read-more{to="/docs/guide/going-further/layers"}
Read more about layers in the **Layer Author Guide**.
::

::tip{icon="i-ph-video" to="https://www.youtube.com/watch?v=lnFCM7c9f7I" target="_blank"}
Watch a video from Learn Vue about Nuxt Layers.
::

::tip{icon="i-ph-video" to="https://www.youtube.com/watch?v=fr5yo3aVkfA" target="_blank"}
Watch a video from Alexander Lichter about Nuxt Layers.
::

## Examples

::card-group
  ::card
  ---
  icon: i-simple-icons-github
  title: Content Wind Theme
  to: https://github.com/Atinux/content-wind
  target: _blank
  ui.icon.base: text-black dark:text-white
  ---
  A lightweight Nuxt theme to build a Markdown driven website. Powered by Nuxt Content, TailwindCSS and Iconify.
  ::
::
