---
title: 'Installation'
description: 'Get started with Nuxt quickly with our online starters or start locally with your terminal.'
navigation.icon: i-ph-play
---

## Play Online

If you just want to play around with Nuxt in your browser without setting up a project, you can use one of our online sandboxes:

::card-group
  :card{title="Open on StackBlitz" icon="i-simple-icons-stackblitz" to="https://nuxt.new/s/v3" target="_blank"}
  :card{title="Open on CodeSandbox" icon="i-simple-icons-codesandbox" to="https://nuxt.new/c/v3" target="_blank"}
::

Or follow the steps below to set up a new Nuxt project on your computer.

## New Project

<!-- TODO: need to fix upstream in nuxt/nuxt.com -->
<!-- markdownlint-disable-next-line MD001 -->
#### Prerequisites

- **Node.js** - [`v18.0.0`](https://nodejs.org/en) or newer
- **Text editor** - We recommend [Visual Studio Code](https://code.visualstudio.com/) with the [official Vue extension](https://marketplace.visualstudio.com/items?itemName=Vue.volar) (previously known as Volar)
- **Terminal** - In order to run Nuxt commands

::note
  ::details
  :summary[Additional notes for an optimal setup:]
  - **Node.js**: Make sure to use an even numbered version (18, 20, etc)
  - **Nuxtr**: Install the community-developed [Nuxtr extension](https://marketplace.visualstudio.com/items?itemName=Nuxtr.nuxtr-vscode)
  ::
::

Open a terminal (if you're using [Visual Studio Code](https://code.visualstudio.com), you can open an [integrated terminal](https://code.visualstudio.com/docs/editor/integrated-terminal)) and use the following command to create a new starter project:

::package-managers

```bash [npm]
npx nuxi@latest init <project-name>
```

```bash [yarn]
yarn dlx nuxi@latest init <project-name>
```

```bash [pnpm]
pnpm dlx nuxi@latest init <project-name>
```

```bash [bun]
bun x nuxi@latest init <project-name>
```

::

::tip
Alternatively, you can find other starters or themes by opening [nuxt.new](https://nuxt.new) and following the instructions there.
::

Open your project folder in Visual Studio Code:

```bash [Terminal]
code <project-name>
```

Or change directory into your new project from your terminal:

```bash
cd <project-name>
```

## Development Server

Now you'll be able to start your Nuxt app in development mode:

::package-managers

```bash [npm]
npm run dev -- -o
```

```bash [yarn]
yarn dev --open
```

```bash [pnpm]
pnpm dev -o
```

```bash [bun]
bun run dev -o
```
::

::tip{icon="i-ph-check-circle"}
Well done! A browser window should automatically open for <http://localhost:3000>.
::

## Next Steps

Now that you've created your Nuxt project, you are ready to start building your application.

:read-more{title="Nuxt Concepts" to="/docs/guide/concepts"}
