package probes

type Probe struct {
	Name string
	Payloads []string
	Port []int
}

var Probes = []Probe{
	{
		Name: "ard",
		Payloads: []string{"0014000103"},
		Port: []int{3283},
	},
	{
		Name: "bacnet",
		Payloads: []string{"810A001101040005D60C0C023FFFFF194B4C", "810A002501040205010E0C020000001E090C091C092C09380939093A0946094D097809791F"},
		Port: []int{47808},
	},
	{
		Name: "chargen",
		Payloads: []string{"01"},
		Port: []int{19},
	},
	{
		Name: "citrix",
		Payloads: []string{"1E00013002FDA8E300000000000000000000000000000000000000000000"},
		Port: []int{1604},
	},
	{
		Name: "coap",
		Payloads: []string{"40017D70BB2E77656C6C2D6B6E6F776E04636F7265"},
		Port: []int{5683},
	},
	{
		Name: "db",
		Payloads: []string{"444232474554414444520053514C303930313000", "444232474554414444520053514C303530303000"},
		Port: []int{523},
	},
	{
		Name: "digi",
		Payloads: []string{"4449474900010006FFFFFFFFFFFF", "44564B5400010006FFFFFFFFFFFF", "4447445000010006FFFFFFFFFFFF"},
		Port: []int{2362},
	},
	{
		Name: "dns",
		Payloads: []string{"34EF010000010000000000000756455253494F4E0442494E440000100003", "AE0D010000010000000000000377777706676F6F676C6503636F6D0000010001"},
		Port: []int{53},
	},
	{
		Name: "ipmi",
		Payloads: []string{"0600FF07000000000000000000092018C88100388E04B5"},
		Port: []int{623},
	},
	{
		Name: "ldap",
		Payloads: []string{"30840000002D02010163840000002404000A01000A0100020100020100010100870B6F626A656374636C617373308400000000000A"},
		Port: []int{389},
	},
	{
		Name: "mdns",
		Payloads: []string{"000000000001000000000000095F7365727669636573075F646E732D7364045F756470056C6F63616C00000C0001"},
		Port: []int{5353},
	},
	{
		Name: "memcache",
		Payloads: []string{"5A4D0000000100007374617473206974656D730D0A"},
		Port: []int{11211},
	},
	{
		Name: "mssql",
		Payloads: []string{"02"},
		Port: []int{1434},
	},
	{
		Name: "nat",
		Payloads: []string{"0000000000000000000000000000E3B3E483", "00000000"},
		Port: []int{5351},
	},
	{
		Name: "netbios",
		Payloads: []string{"E5D80000000100000000000020434B4141414141414141414141414141414141414141414141414141414141410000210001"},
		Port: []int{137},
	},
	{
		Name: "netis",
		Payloads: []string{"0A000000000000000000000000009E21BDAD"},
		Port: []int{53413},
	},
	{
		Name: "ntp",
		Payloads: []string{"E30004FA000100000001000000000000000000000000000000000000000000000000000000000000C54F234B71B152F3", "1700032A0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"},
		Port: []int{123},
	},
	{
		Name: "openvpn",
		Payloads: []string{"381212121212121212000000000038B126DE"},
		Port: []int{1194},
	},
	{
		Name: "pca",
		Payloads: []string{"4E51", "5354", "4E5100000000000000000000000041F4BFA6"},
		Port: []int{5632},
	},
	{
		Name: "portmap",
		Payloads: []string{"1AA9FFE10000000000000002000186A0000000020000000400000000000000000000000000000000"},
		Port: []int{111},
	},
	{
		Name: "qotd",
		Payloads: []string{"0D0A"},
		Port: []int{17},
	},
	{
		Name: "rdp",
		Payloads: []string{"00000000000000FF00000000000000005406"},
		Port: []int{3389},
	},
	{
		Name: "ripv",
		Payloads: []string{"010100000000000000000000000000000000000000001000"},
		Port: []int{520},
	},
	{
		Name: "sentinel",
		Payloads: []string{"7A0000000000"},
		Port: []int{5093},
	},
	{
		Name: "sip",
		Payloads: []string{"4F5054494F4E53"},
		Port: []int{5060},
	},
	{
		Name: "snmp",
		Payloads: []string{"302902010004067075626C6963A01C0204565ADC5D020100020100300E300C06082B060102010101000500", "302602010104067075626C6963A1190204DC63C29A020100020100300B300906052B060102010500", "303A020103300F02024A69020300FFE30401040201030410300E0400020100020100040004000400301204000400A00C020237F00201000201003000"},
		Port: []int{161},
	},
	{
		Name: "ssdp",
		Payloads: []string{"4D2D534541524348202A20485454502F312E310D0A484F53543A3233392E3235352E3235352E3235303A313930300D0A53543A737364703A616C6C0D0A4D414E3A22737364703A646973636F766572220D0A0D0A"},
		Port: []int{1900},
	},
	{
		Name: "tftp",
		Payloads: []string{"00012F61006E6574617363696900"},
		Port: []int{69},
	},
	{
		Name: "ubiquiti",
		Payloads: []string{"01000000000000000000000000001F7FA366", "01000000", "02080000"},
		Port: []int{10001},
	},
	{
		Name: "upnp",
		Payloads: []string{"4D2D534541524348202A20485454502F312E310D0A486F73743A3233392E3235352E3235352E3235303A313930300D0A53543A75706E703A726F6F746465766963650D0A4D616E3A22737364703A646973636F766572220D0A4D583A330D0A0D0A0D0A"},
		Port: []int{1900},
	},
	{
		Name: "valve",
		Payloads: []string{"FFFFFFFF54536F7572636520456E67696E6520517565727900"},
		Port: []int{27015},
	},
	{
		Name: "wdbrpc",
		Payloads: []string{"1A09FABA000000000000000255555555000000010000000100000000000000000000000000000000FFFF55120000003C00000001000000020000000000000000"},
		Port: []int{17185},
	},
	{
		Name: "wsd",
		Payloads: []string{"3C3A2F3E0A", "3C3F786D6C2076657273696F6E3D22312E302220656E636F64696E673D227574662D38223F3E0A3C736F61703A456E76656C6F706520786D6C6E733A736F61703D22687474703A2F2F7777772E77332E6F72672F323030332F30352F736F61702D656E76656C6F70652220786D6C6E733A7773613D22687474703A2F2F736368656D61732E786D6C736F61702E6F72672F77732F323030342F30382F61646472657373696E672220786D6C6E733A7773643D22687474703A2F2F736368656D61732E786D6C736F61702E6F72672F77732F323030352F30342F646973636F766572792220786D6C6E733A777364703D22687474703A2F2F736368656D61732E786D6C736F61702E6F72672F77732F323030362F30322F64657670726F66223E0A3C736F61703A4865616465723E3C7773613A546F3E75726E3A736368656D61732D786D6C736F61702D6F72673A77733A323030353A30343A646973636F766572793C2F7773613A546F3E3C7773613A416374696F6E3E687474703A2F2F736368656D61732E786D6C736F61702E6F72672F77732F323030352F30342F646973636F766572792F50726F62653C2F7773613A416374696F6E3E3C7773613A4D65737361676549443E75726E3A757569643A63653034646164302D356432632D343032362D393134362D3161616266633165343131313C2F7773613A4D65737361676549443E3C2F736F61703A4865616465723E3C736F61703A426F64793E3C7773643A50726F62653E3C7773643A54797065733E777364703A4465766963653C2F7773643A54797065733E3C2F7773643A50726F62653E3C2F736F61703A426F64793E3C2F736F61703A456E76656C6F70653E0A"},
		Port: []int{3702},
	},
	{
		Name: "xdmcp",
		Payloads: []string{"00010002000100"},
		Port: []int{177},
	},
	{
		Name: "kerberos",
		Payloads: []string{"6A7A3078A103020105A20302010AA46C306AA00703050040000000A111300FA003020101A10830061B046E6D6170A2061B0474657374A3193017A003020102A110300E1B066B72627467741B0474657374A511180F32303232313131333231343530325AA7060204094A7681A80E300C020112020111020110020117"},
		Port: []int{88},
	},
	{
		Name: "ike",
		Payloads: []string{"5b5e64c03e99b51100000000000000000110020000000000000001500000013400000001000000010000012801010008030000240101"},
		Port: []int{500, 4500},
	},
	{
		Name: "radius",
		Payloads: []string{"0167005740b664dbf5d681b2adbd1769515118c8010773746576650212dbc6c4b758be14f005b3877c9e2fb6010406c0a8001c05060000007b50125f0f8647e8c89bd881364268fcd045324f0c0266000a017374657665"},
		Port: []int{1645, 1812},
	},
	{
		Name: "dtls",
		Payloads: []string{"0d31323334353637385139393900", "16feff00000000000000000036", "0100002a000000000000002a", "fefd", "0000", "0002002f", "0100"},
		Port: []int{80,443,853,3391,4433,4740,5349,5684,5868,6514,6636,8232,10161,10162,12346,12446,12546,12646,12746,12846,12946,13046},
	},
}

