/*
 * Copyright (C) 2023 nukeykt
 *
 * This file is part of Nuked-MD.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *  YM7101 emulator
 *  Thanks:
 *      Fritzchens Fritz:
 *          YM7101 decap and die shot.
 *      andkorzh:
 *          YM7101 deroute.
 *      org (ogamespec):
 *          early YM7101 decap and die shot.
 *      HardWareMan:
 *          help & support.
 *
 */

#pragma once
#include "common.h"

#pragma pack(push, 1)

typedef struct {
    int l1;
    int l2;
} dff_t;

typedef struct {
    int pal;
    int priority;
    int index;
} sprpixel_t;

typedef struct {
    int i_clk1;
    int i_clk2;
    int i_pal;
    int i_pen;
    int i_sel0;
    int i_as;
    int i_uds;
    int i_lds;
    int i_m1;
    int i_rd;
    int i_wr;
    int i_iorq;
    int i_mreq;
    int i_rw;
    int i_cpu_clk0;
    int i_cpu_clk1;
    int i_bg;
    int i_intak;
    int i_bgack;
    int i_reset;
    int i_dtack;
    int i_csync;
    int i_hsync;
    int i_vram_sd;
    int i_vram_rd;
    int i_vram_ad;
    int i_spa;
    // int i_data;
    // int i_address;
} vdp_i_state_t;

typedef struct {
    int mclk;
    int i_reset;
    int i_test_reset;
    int i_clk1;
    int i_edclk;
    int i_pal;
    int i_rs0; // 
    int i_rs1; // 
    int i_test_psg; // chip->reg_test1 & 1
    //int i_test_dclk; // chip->reg_test1 & 2
} vdp_prescaler_i_state_t;

typedef struct {
    vdp_prescaler_i_state_t input, input_old;
    dff_t mclk_prescaler_dff1;
    dff_t mclk_prescaler_dff2;
    int mclk_and1;
    dff_t mclk_prescaler_dff3;
    dff_t mclk_prescaler_dff4;
    int mclk_clk1;
    dff_t mclk_prescaler_dff5;
    dff_t mclk_prescaler_dff6;
    dff_t mclk_prescaler_dff7;
    int mclk_clk2;
    dff_t mclk_prescaler_dff8;
    dff_t mclk_prescaler_dff9;
    dff_t mclk_prescaler_dff10;
    dff_t mclk_prescaler_dff11;
    int mclk_clk3;
    dff_t mclk_prescaler_dff12;
    dff_t mclk_prescaler_dff13;
    dff_t mclk_prescaler_dff14;
    int mclk_clk4;
    dff_t mclk_prescaler_dff15;
    dff_t mclk_prescaler_dff16;
    dff_t mclk_prescaler_dff17;
    int mclk_clk5;
    int mclk_sbcr;
    int mclk_cpu_clk0;
    int mclk_cpu_clk1;
    int mclk_dclk;
    int o_clk0;
    int o_clk1;
    int o_sbcr;
    int o_edclk;
} vdp_prescaler_t;

typedef struct {
    int i_cpu_clk0;
    int i_reset; // reset_comb
    int i_write; // w111
    int i_data; // io_data;
    int i_test; // reg_test0
} vdp_psg_input_t;

typedef struct {
    vdp_psg_input_t input, input_old;

    int psg_clk1;
    int psg_clk2;
    int l631[2];
    int l632[2];
    int w1104;
    int w1105;
    int l633[2];
    int l634;
    int psg_hclk1;
    int psg_hclk2;
    int t43;
    int w1106;
    int l635[2];
    int l636[2];
    int l637[2];
    int t44;
    int l638[2];
    int w1107;
    int w1108;
    int w1109;
    int w1110;
    int l639[2];
    int w1111;
    int w1112;
    int w1113;
    int w1114;
    int w1115;
    int w1116;
    int w1117;
    int w1118;
    int l640[2];
    int w1119;
    int w1120;
    int l641[2];
    int l642[2];
    int l643[2];
    int l644[2];
    int w1121;
    int w1122;
    int w1123;
    int w1124;
    int w1125;
    int l645[2];
    int l646[2];
    int l647[2];
    int l648[2];
    int l649[2];
    int w1126;
    int w1127;
    int w1128;
    int w1129;
    int w1130;
    int w1131;
    int l650[2];
    int w1132;
    int l651[2];
    int w1133;
    int l652[2];
    int l653;
    int w1134;
    int l654;
    int w1135;
    int w1136;
    int w1137;
    int w1138;
    int w1139;
    int w1140;
    int w1141;
    int w1142;
    int w1143;
    int l655;
    int l656;
    int l657;
    int l658;
    int w1144;
    int l659;
    int l660;
    int l661;
    int l662;
    int w1145;
    int w1146;
    int w1147;
    int w1148;
    int w1149;
    int w1150;
    int w1151;
    int w1152;
    float psg_out;
    int o_psg_debug;
} vdp_psg_t;

typedef struct {
    int t;

    vdp_prescaler_t prescaler;
    vdp_psg_t psg;

    int dclk_prescaler_l1[2];
    int dclk_prescaler_l2;
    int dclk_prescaler_l3;
    dff_t dclk_prescaler_dff1;
    dff_t dclk_prescaler_dff2;

    int reset_comb;
    int reset_l1[2];
    int reset_l2[2];
    int reset_pulse;
    int reset_ext;

    int cpu_bg;
    int cpu_intak;
    int cpu_pal;
    int cpu_pen;


    dff_t io_m1_dff1;
    dff_t io_m1_dff2;
    dff_t io_m1_dff3;
    dff_t io_m1_dff4;
    int io_address;
    int io_address_22o;
    //int io_oe0;
    //int io_cas0;
    //int io_ras0;
    //int io_lwr;
    //int io_uwr;
    //int io_wr;
    //int io_ipl1;
    //int io_ipl2;
    int io_data;
    dff_t dff1;
    dff_t dff2;
    int t1;
    //int w3;
    //int w4;
    dff_t dff3;
    dff_t dff4;
    int t2;
    int t3;
    int t4;
    //int w5;
    int l1[2];
    int l2[2];
    int l3[2];
    //int w6;
    int l4[2];
    int l5[2];
    int l6;
    int l7;
    int l8;
    //int w9;
    //int w10;
    int w11;
    int w12;
    //int w14;
    //int w16;
    //int w17;
    //int w18;
    //int w19;
    //int w20;
    //int w21;
    //int w22;
    //int w23;
    //int w24;
    dff_t dff5;
    dff_t dff6;
    //int w26;
    dff_t dff7;
    //int w28;
    dff_t dff8;
    dff_t dff9;
    //int w29;
    //int w30;
    //int w31;
    dff_t dff10;
    dff_t dff11;
    //int w32;
    //int w33;
    //int w34;
    //int w35;
    //int w36;
    //int w37;
    dff_t dff12;
    //int w38;
    dff_t dff13;
    dff_t dff14;
    dff_t dff15;
    //int w39;
    //int w40;
    //int w41;
    dff_t dff16;
    dff_t dff17;
    dff_t dff18;
    dff_t dff19;
    dff_t dff20;
    dff_t dff21;
    dff_t dff22;
    int w42;
    dff_t dff23;
    dff_t dff24;
    dff_t dff25;
    dff_t dff26;
    dff_t dff27;
    dff_t dff28;
    dff_t dff29;
    //int w43;
    //int w44;
    //int w45;
    //int w46;
    int w47;
    int t5;
    //int w48;
    int l9[2];
    int l10;
    int l11;
    //int w49;
    //int w50;
    int t6;
    int l12[2];
    //int w51;
    int l13[2];
    int l14;
    //int w53;
    //int w54;
    dff_t dff30;
    dff_t dff31;
    //int w55;
    dff_t dff32;
    //int w56;
    //int w57;
    //int w58;
    int t7;
    int t8;
    //int w59;
    //int w60;
    //int w61;
    //int w62;
    //int w63;
    int w64;
    //int w65;
    //int w66;
    int t9;
    int t10;
    int t11;
    int cnt1[2];
    int l15[2];
    //int w70;
    int w71;
    int w72;
    int w73;
    //int w74;
    //int w75;
    //int w76;
    //int w77;
    //int w78;
    //int w79;
    //int w80;
    //int w81;
    //int w82;
    //int w83;
    //int w84;
    //int w85;
    int w86;
    int w87;
    int w88;
    int w89;
    int w90;
    int w91;
    int w92;
    int w93;
    int w94;
    int w95;
    int w96;
    int w97;
    int w98;
    int w99;
    int w100;
    //int w101;
    //int w102;
    //int w103;
    //int w104;
    int l16;
    //int w105;
    int w106;
    int w107;
    int w108;
    int w109;
    //int w110;
    int w111;
    //int w112;
    //int w113;
    int w114;
    //int w115;
    //int w116;
    int w117;
    //int w118;
    int l17;
    //int w119;
    //int w120;
    //int w121;
    int t12;
    //int w122;
    //int w123;
    //int w124;
    //int w125;
    //int w126;
    //int w127;
    //int w128;
    //int w129;
    //int w130;
    //int w131;
    //int w132;
    //int w133;
    int w134;
    //int w135;
    int t13;
    //int w136;
    //int w137;
    int t14;
    //int w138;
    //int w139;
    //int w140;
    //int w141;
    int w142;
    int l18;
    int l19;
    //int w143;
    int t15;
    int t15_n;
    int t16;
    int t16_n;
    int t17;
    //int w144;
    //int w145;
    int t18;
    int t18_n;
    //int w146;
    int t19;
    int t20;
    //int w147;
    //int w148;
    //int w149;
    int t21;
    //int w150;
    int w151;
    //int w152;
    //int w153;
    //int w154;
    //int w155;
    //int w156;
    //int w157;
    //int w158;
    //int w159;
    int w160;
    //int w161;
    int t22;
    //int w162;
    //int w163;
    //int w164;
    //int w165;
    //int w166;
    //int w167;
    //int w168;
    //int w169;
    //int w170;
    int t23;
    int t24;
    //int w171;
    //int w172;
    //int w173;
    //int w174;
    //int w175;
    int t25;
    //int w176;
    int w178;
    int w179;
    //int w180;
    int l20;
    //int w181;
    //int w182;
    //int w183;
    int l21;
    int l22;
    int l23;
    int l24;
    int l25;
    int l26;
    //int w185;
    int t26;
    int t26_n;
    int l27[2];
    //int w187;
    //int w188;
    //int w189;
    //int w190;
    //int w191;
    //int w192;
    //int w194;
    int w195;
    int l28[2];
    int t27;
    //int w197;
    //int w198;
    //int w199;
    //int w200;
    int w201;
    //int w202;
    int l29[2];
    int l30[2];
    //int w203;
    //int w204;
    int l31;
    int l32;
    int l33[2];
    int l34;
    //int w210;
    //int w211;
    //int w212;
    //int w213;
    //int w214;
    //int w215;
    //int w216;
    //int w217;
    int w218;
    int w219;
    int w220;
    int w221;
    int w222;
    int w223;
    int w224;
    int w225;
    int w226;
    //int w227;
    //int w228;
    //int w229;
    int w230;
    int w231;
    int w232;
    int w233;
    //int w234;
    //int w235;
    int l35; // 17 bits
    int l36; // 17 bits
    int l37; // 17 bits
    int l38; // 17 bits
    int l39; // 17 bits
#if 0
    int w236;
    int w237;
    int w238;
    int w239;
    int w240;
    int w241;
    int w242;
    int w243;
#endif
    //int w245;
    //int w246;
    //int w247;
    //int w248;
    int l40[2];
    //int w249;
    int l41;
    //int w250;
    int l42[2];
    int w252;
    int l43[2];
    int l44[2];
    int l45[2];
    //int w253;
    int l46[2];
    //int w256;
    //int w257;
    //int w258;
    //int w259;
    //int w260;
    //int w261;
    //int w262; // unused??
    int w263;
    //int w264;
    int w265;
    int l47;
    int l48[2];
    int w267;
    //int w268;
    int l49[2];
    //int w270;
    //int w271;
    int t28;
    int l50[2];
    //int w273;
    //int w274;
    //int w275;
    //int w276;
    //int w277;
    //int w278;
    //int w279;
    //int w280;
    //int w281;
    //int w282;
    int w283;
    int w284;
    //int w285;
    int w286;
    //int w287;
    int w288;
    //int w289;
    //int w290;
    int l51[2];
    //int w291;
    //int w292;
    //int w293;
    //int w294;
    //int w295;
    int l52[2];
    int l53[2];
    int l54[2];
    //int w298;
    //int w299;
    //int w300;
    int l55;
    int l56;
    int l57;
    int l58;
    int l59;
    int l60;
    int l61;
    int l62;
    int l63;
    int l64;
    int l65;
    int l66;
    int w301;
    int w302;
    int w303;
    //int w304;
    //int w306;
    //int w307;
    //int w308;
    //int w309;
    //int w310;
    int l67;
    int l68;
    int l69;
    int l70;
    int l71;
    int l72;
    int l73;
    int l74;
    int l75;
    int l76;
    int l77;
    int l78;
    //int w311;
    //int w312;
    //int w313;
    //int w314;
    //int w315;
    int w316;
    int w317;
    int w318;
    int w319;
    int w320;
    //int w321;
    //int w322;
    //int w324;
    //int w325;
    //int w326;
    //int w327;
    //int w328;
    //int w329;
    //int w330;
    //int w331;
    //int w332;
    //int w333;
    //int w334;
    int l79[2];
    int l80[2];
    int l81[2];
    //int w336;
    //int w337;
    //int w338;
    int l82[2];
    int l83[2];
    int l84[2];
    int l85[2];
    int l86[2];
    int l87[2];
    int l88[2];
    int l89[2];
    //int w345;
    //int w346;
    int l90;
    int l91;
    int w347;
    //int w348;
    int l92;
    //int w349;
    int l93;
    //int w350;
    int l94;
    int l95;
    int l96;
    int l97;
    //int unk_data;
    int l98;
    int l99;
    int l100;
    int l101;
    int l102;
    int l103;
    int l104[2];

    int l105[2]; // v counter
    int w355;
    int l106[2]; // h counter
    int l107[2];
    int l108[2];
    int l109[2];
    int l110[2];
    int w356;
    int w357;
    int w360;
    int l111[2];
    int l112[2];
    int w370;
    int l113[2];
    int l114[2];
    int l115[2];
    int l116[2];
    int w371;
    int w372;
    int l117[2];
    int l118[2];
    int l119[2];
    int l120[2];
    int l121[2];
    int l122[2];
    int l123[2];
    int w379;
    int w380;
    int w381;
    int w382;
    int w383;
    int w385;
    int l124[2];
    int l125[2];
    int l126[2];
    int l127[2];
    int w388;
    int l128[2];
    int w389;
    int l129[2];
    int l130[2];
    int t29;
    int l131[2];
    int w393;
    int l132[2];
    int w394;
    int l133[2];
    int l134[2];
    int l135[2];
    int l136[2];
    int t30;
    int l137[2];
    int l138[2];
    int w402;
    int l139[2];
    int l140[2];
    int l141[2];
    int l142[2];
    int t31;
    int l143[2];
    int l144[2];
    int l145[2];
    int l146[2];
    int l147[2];
    int l148[2];
    int l149[2];
    int l150[2];
    int l151[2];
    int t32;
    int l152[2];
    int l153[2];
    int w415;
    int w417;
    int w418;
    int w419;
    int l154[2];
    int l155[2];
    int l156[2];
    int l157[2];
    int w422;
    int l158[2];
    int t33;
    int w423;
    int w424;
    int l159[2];
    int l160[2];
    int l161[2];
    int l162[2];
    int w439;
    int l163[2];
    int t34;
    int l164[2];
    int t35;
    int l165[2];
    int l166[2];
    int t36;
    int w446;
    int l167[2];
    int l168[2];
    int l169[2];
    int t37;
    int l170[2];
    int w457;
    int t38;
    int l171[2];
    int l172[2];
    int t39;
    int l173[2];
    int l174[2];
    int l175[2];
    int l176[2];
    int l663[2];

    int l178[2];
    int l179;
    int l180; // 11 bits
    int l181[2];
    int l182[2];
    int l183[2];
    int l184;
    int l185;
    int l186[2];
    int reg_hsz;
    int reg_vsz;
    int reg_sa;
    int reg_nt; // m4
    int reg_sb;
    int reg_8e_b0;
    int reg_8e_b4;
    int reg_wd;
    int reg_hs;
    int reg_whp;
    int reg_rigt;
    int reg_wvp;
    int reg_down;
    int l187;
    int l188;
    int l189;
    int l190;
    int reg_88; // m4 scroll
    int l191;
    int l192;
    int l193;
    int l194;
    int l195;
    int l196[2];
    int l197[2];
    int l198[2];
    int l199[2];
    int l200[2];
    int l201[2];
    int l202[2];
    int l203[2];
    int l204[2];
    int l205[2];
    int l206[2];
    int l207[2];
    int l208[2];
    int l209[2];
    int l210[2];
    int l211[2];
    int l212[2]; // 6 bits
    int l213;
    int l214[2];
    int l215[2];
    int l216[2];
    int l217[2];
    int l218[2];
    int l219;
    int l220;
    int l221;
    int l222;
    int l223;
    int l224;
    int l225;
    int l226;
    int l227;
    int l228[2];
    int l229[2];
    int l230[2];
    int l231[2];
    int l232;
    int l233;
    int l234;
    int l235;
    int l236;
    int l237;
    int l238;
    int l239;
    int l240;
    int l241[2];
    int l242[2];
    int l243;
    int l244;
    int l245;
    int l246;
    int l247;
    int l248[2];
    int l249[2];
    int l250[2];
    int l251;
    int l252[2];
    int l253[2];
    int l254[2];
    int l255;
    int l256;
    int l257;
    int l258;
    int l259;
    int l260;
    int l261;
    int l262;
    int l263;
    int l264;
    int l265;
    int l266;
    int l267[2];
    int l268[2];
    int l269[2];
    int l270[2];
    int l271[2];
    int l272[2];
    int l273[2];
    int l274[2];
    int l275;
    int l276;
    int l277;
    int l278;
    int l279;
    int l280;
    int l281;
    int l282;
    int l283;
    int l284[2];
    int l285[2];
    int l286[2];
    int l287;
    int l288;
    int l289;
    int l290;
    int l291;
    int l292;
    int l293[2];
    int l294;
    int l295;
    int l296;
    int l297;
    int l298;
    int l299[2];
    int l300[2];
    int l301[2];
    int l302[2];
    int l303;
    int l304;
    int l305;
    int l306;
    int l307;
    int l308;
    int l309;
    int l310;
    int l311[2];
    int l312[2];
    int l313[2];
    int l314[2];
    int l315[2];
    int l316[2];
    int l317;
    int w646;
    int l318[2];
    int l319[2];
    int w648;
    int l320[2];
    int l321[2];
    int l322[2];
    int l323[2];
    int vsram[40];
    int vsram_out;
    int vsram_out_odd;
    int vsram_out_even;

    //int w650;
    int l324;
    int l325[2];
    int l326[2];
    int l327[2];
    int l328;
    //int w651;
    int l329[2];
    int l330[2];
    int l331[2];
    int l332;
    int l333;
    //int w652;
    //int w653;
    //int w654;
    //int w655;
    //int w656;
    //int w657;
    //int w658;
    //int w659;
    int l334;
    //int w660;
    int l335[2];
    //int w661;
    //int w662;
    int l336[2];
    int l337[2];
    int l338[2];
    int l339[2];
    //int w663;
    //int w664;
    //int w665;
    //int w666;
    int l340;
    int l341;
    //int w667;
    //int w668;
    //int w669;
    //int w670;
    //int w671;
    //int w672;
    int l342;
    int l343;
    int l344;
    //int w673;
    //int w674;
    //int w675;
    //int w676;
    //int w677;
    //int w678;
    //int w679;
    int l345[2];
    int l346;
    //int w680;
    int l347[2];
    int l348[2];
    int l349[2];
    int l350[2];
    //int w681;
    //int w682;
    int l351[2];
    //int w683;
    int l352[2];
    //int w684;
    int l353[2];
    int l354[2];
    //int w685;
    int l355[2];
    int l356[2];
    //int w686;
    int l357[2];
    int l358[2];
    int l359[2];
    //int w687;
    //int w688;
    //int w689;
    //int w690;
    //int w691;
    int l360[2];
    int l361[2];
    int l362[2];
    //int w692;
    //int w693;
    //int w694;
    int l363[2];
    int l364[2];
    //int w695;
    //int w696;
    int l365[4];
    int sat_cache_link[80];
    int sat_cache_size[80];
    int sat_cache_ypos[80];
    //int sat_link;
    //int sat_size;
    //int sat_ypos;
    int l366[2];
    //int w697;
    int l367[2];
    //int w698;
    int l368[2];
    int l369[2];
    int l370[2];
    //int w699;
    //int w700;
    int l371[2];
    int l372[2];
    //int w701;
    int l373[2];
    //int w702;
    //int w703;
    //int w704;
    //int w705;
    //int w706;
    //int w707;
    //int w708;
    //int w709;
    //int w710;
    //int w711;
    //int w712;
    //int w713;
    int l374[2];
    int l375[2];
    int l376[2];
    //int w714;
    //int w715;
    //int w716;
    int l377[2];
    //int w717;
    int l378[2];
    //int w718;
    int l379;
    int l380;
    //int w719;
    //int w720;
    //int w721;
    int l381[2];
    int t40;
    int t41;
    //int w722;
    //int w723;
    //int w724;
    //int w725;
    //int w726;
    int l382[2];
    int l383[2];
    //int w727;
    int l384[2];
    int l385[2];
    //int w728;
    //int w729;
    //int w730;
    //int yoff;
    int l386;
    int l387;
    //int w731;
    //int w732;
    int l388[2];
    int l389[2];
    int l390[2];
    int l391[2];
    //int w733;
    //int w734;
    //int w735;
    //int w736;
    //int w737;
    //int w738;
    //int w739;
    int reg_86_b2;
    int reg_86_b5;
    int reg_at;
    //int w740;
    //int w741;
    //int w742;
    //int w743;
    int l392[2];
    //int w744;
    //int w745;
    //int w746;
    int l393[2];
    int l394;
    //int w747;
    //int w748;
    int l395;
    //int w749;
    int l396[2];
    int l397[2];
    //int w750;
    int l398[2];
    int l399[2];
    int l400[2];
    //int w751;
    int l401[2];
    int l402[2];
    //int w752;
    //int w753;
    int l403[2];
    int l404[2];
    int l405[2];
    int l406[2];
    int l407[2];
    int l408[2];
    int l409[2];
    int l410[2];
    int l411[2];
    int l412[2];
    //int w754;
    //int w755;
    //int w756;
    //int w757;
    //int w758;
    //int w759;
    //int w760;
    //int w761;
    //int w763;
    //int w764;
    //int w766;
    //int w768;
    //int w769;
    int l413;
    int l414;
    int l415;
    int l416;
    int l417;
    int l418;
    int sprdata_pattern[20];
    int sprdata_hpos[20];
    int sprdata_hflip[20];
    int sprdata_pal[20];
    int sprdata_priority[20];
    int sprdata_xs[20];
    int sprdata_ys[20];
    int sprdata_yoffset[20];
    //int sprdata_pattern_o;
    //int sprdata_hpos_o;
    //int sprdata_hflip_o;
    //int sprdata_pal_o;
    //int sprdata_priority_o;
    //int sprdata_xs_o;
    //int sprdata_ys_o;
    //int sprdata_yoffset_o;
    int l419[2];
    int l420[2];
    //int w771;
    //int w772;
    int l421[2];
    int l422[2];
    int t42;
    int l423[2];
    //int w773;
    //int w774;
    int l424;
    //int w775;
    int l425;
    int l426[2];
    //int w776;
    //int w777;
    int l427[2]; // nc
    //int w778;
    //int w779;
    //int w780;
    int l428[2];
    //int w781;
    //int w782;
    int l429;
    int l430[2];
    //int w783;
    int l431[2];
    //int w784;
    int l432;
    int l433;
    //int w785;
    //int w786;
    //int w787;
    int l434[2];
    int l435;
    int l436;
    int l437;
    //int w788;
    int l438[2];
    int l439[11];
    int l440[11];
    int l441[11];
    int l442[11];
    int l443[11];
    int l444[2];
    //int w789;
    //int w790;
    int l445[2];
    //int w791;
    //int w792;
    //int w793;
    //int w794;
    //int w795;
    //int w796;
    //int w797;
    //int w798;
    //int w799;
    //int w800;
    int l446[2];
    int l447[2];
    //int w801;
    //int w802;
    //int w803;
    int l448;
    int l449[2];
    int l450;
    int l451;
    int l452;
    int l453;
    int l454;
    int l455[2];
    int l456[2];
    //int w804;
    //int w805;
    //int w806;
    int l457[2];
    //int w807;
    //int w808;
    //int w809;
    int l458[2];
    //int w810;
    //int w811;
    //int w812;
    int l459[2];
    int l460[2];
    //int w813;
    int l461;
    //int w814;
    int l462;
    //int w815;
    int l463[2];
    //int w816;
    int l464[2];
    //int w817;
    //int w818;
    int l465;
    //int w819;
    int l466;
    //int w820;
    int l467[2];
    int l468[2];
    int l469[2];
    //int w821;
    int l470[2];
    int l471[2];
    int l472[2];
    int l473;
    //int w822;
    //int w823;
    //int w824;
    int l474[2];
    int l475[2];
    //int w825;
    //int w827;
    //int w828;
    int l478;
    int l479;
    int l480;
    int l481;
    //int w829;
    int l482[2];
    int l483;
    //int w830;
    //int w831;
    //int w832;
    int l484;
    //int w833;
    int l485[2];
    //int w834;
    int l486;
    int l487;
    int l488;
    int l489[2];
    int l490[2];
    //int w835;
    int l491;
    int l492;
    int l493;
    int l494;
    int l495[2];
    int l496[2];
    int l497[2];
    int l498[2];
    int l499;
    int l500;
    //int w836;
    int l501[2];
    //int w837;
    //int w838;
    //int w839;
    //int w840;
    //int w841;
    //int w842;
    //int w843;
    //int w844;
    int l502;
    //int w845;
    int l503[2];
    //int w846;
    int l504;
    int l505;
    int l506[2];
    //int w847;
    //int w848;
    int l507[2];
    int l508[2];
    int l509[2];
    int l510[2];
    //int w849;
    int l511[2];
    int l512;
    int l513[2];
    //int w850;
    int l514[2];
    //int w851;
    //int w852;
    //int w853;
    //int w854;
    //int w855;
    //int w856;
    //int w857;
    //int w858;
    //int w859;
    //int w860;
    //int w861;
    //int w862;
    //int w863;
    //int w864;
    //int w865;
    //int w866;
    //int w867;
    //int w868;
    //int w869;
    //int w870;
    //int w871;
    //int w872;
    //int w873;
    //int w874;
    //int w875;
    //int w876;
    //int w877;
    //int w878;
    //int w879;
    //int w880;
    //int w881;
    //int w882;
    //int w883;
    //int w884;
    int l515;
    int l516;
    int l517;
    int l518;
    int l519;
    int l520;
    int l521;
    int l522;
    //int w885;
    int l523;
    int l524;
    int l525;
    int l526;
    int l527;
    int l528;
    int l529;
    int l530;
    int l531;
    int l532;
    int l533;
    int l534;
    int l535;
    int l536;
    int l537;
    //int w886;
    //int w887;
    //int w888;
    //int w889;
    //int w890;
    //int w891;
    //int w892;
    //int w893;
    //int w894;
    //int w895;
    //int w896;
    //int w897;
    //int w898;
    //int w899;
    //int w900;
    //int w901;
    //int w902;
    //int w903;
    //int w904;
    //int w905;
    //int w906;
    //int w907;
    //int w908;
    //int w909;
    int l538;
    int l539;
    int l540;
    int l541;
    int l542;
    int l543;
    int l544;
    int l545;
    //int w910;
    //int w911;
    //int w912;
    //int w913;
    //int w914;
    //int w915;
    //int w916;
    //int w917;
    //int w918;
    //int w919;
    //int w920;
    //int w921;
    //int w922;
    //int w923;
    //int w924;
    //int w925;
    //int w926;
    //int w927;
    //int w928;
    //int w929;
    //int w930;
    //int w931;
    //int w932;
    //int w933;
    //int w934;
    //int w935;
    //int w936;
    //int w937;
    //int w938;
    //int w939;
    //int w940;
    //int w941;
    //int w942;
    //int w943;
    //int w944;
    //int w945;
    //int w946;
    //int w947;
    //int w948;
    //int w949;
    //int w950;
    //int w951;
    //int w952;
    //int w953;
    //int w954;
    //int w955;
    int l546[2];
    int l547[2];
    int l548[2];
    int l549[2];
    int l550[2];
    int l551[2];
    int l552[2];
    int l553[2];
    int l554[2];
    int l555[2];
    //int spr_pal;
    //int spr_priority;
    //int spr_index;
    //int w970;
    //int w971;
    //int w972;
    int l556[2];
    int l557[2];
    int l558[2];
    int l559[2];
    int l560[2];
    int l561[2];
    //int w974;
    int l562[2];
    int l563;
    //int w979;
    //int w980;
    //int w982;
    //int w983;
    int l600[2];
    //int w1020;
    int w973;
    int w975;
    int w976;
    int w977;
    int w978;
    int w1154;

    sprpixel_t linebuffer[40][8];
    sprpixel_t linebuffer_out[8];

    int l564;
    int l565[2];
    int l566;
    int l567;
    int w985;
    int w986;
    int w987;
    int w988;
    int w989;
    int w990;
    int l568[2];
    int w991;
    int w992;
    int l569;
    int l570;
    int l571[2];
    int w993;
    int l572;
    int l573;
    int l574[2];
    int l575;
    int l576[2];
    int l577;
    int l578;
    int l579;
    int w994;
    int l580;
    int l581[2];
    int w995;
    int w996;
    int w997;
    int l582[2];
    int w998;
    int l583[2];
    int l584[2];
    int w999;
    int l585[2];
    int w1000;
    int l586[2];
    int l587[2];
    int l588[2];
    int l589[2];
    int l590[2];
    int w1001;
    int w1002;
    int w1003;
    int w1004;
    int l591[2];
    int w1005;
    int w1006;
    int w1007;
    int w1008;
    int w1009;
    int w1010;
    int w1011;
    int w1012;
    int w1013;
    int l592;
    int w1014;
    int l593;
    int w1015;
    int l594;
    int w1016;
    int l595;
    int l596;
    int w1017;
    int l597;
    int l598;
    int l599;
    int w1018;
    int w1019;

    int w1021;
    int l601[2];
    int l602[2];
    int w1022;
    int w1023;
    int w1024;
    int w1025;
    int w1026;
    int w1027;
    int w1028;
    int w1029;
    int w1030;
    int w1031;
    int w1032;
    int w1033;
    int w1034;
    int w1035;
    int w1036;
    int w1037;
    int w1038;
    int w1039;
    int w1040;
    int w1041;
    int w1042;
    int w1043;
    int w1044;
    int w1045;
    int w1046;
    int w1047;
    int w1048;
    int w1049;
    int w1050;
    int w1051;
    int w1052;
    int w1053;
    int w1054;
    int w1055;
    int w1056;
    int w1057;
    int w1058;
    int w1059;
    int w1060;
    int w1061;
    int w1062;
    int l603[2];
    int l604[2];
    int l605[2];
    int l606[2];
    int w1063;
    int w1064;
    int w1065;
    int w1066;
    int l607[2];
    int w1067;
    int w1068;
    int l608[2];
    int w1069;
    int l609[2];
    int l610[2];
    int w1070;
    int l611[2];
    int l612[2];
    int w1071;
    int l613[2];
    int w1072;
    int w1073;
    int reg_col_index;
    int reg_col_pal;
    int reg_col_b6;
    int reg_col_b7;
    int l614[2];
    int l615[2];
    int w1074;
    int l616[2];
    int w1075;
    int w1076;
    int l617[2];
    int l618[2];
    int w1077;
    int l619[2];
    int l620[2];
    int w1078;
    int w1079;
    int color_ram[64];
    int color_ram_out;
    int l621;
    int l622[2];
    int l623[2];
    int w1080;
    int w1081;
    int l624[2];
    int l625[2];
    int w1082;
    int w1083;
    int w1084;
    int w1085;
    int w1086;
    int w1087;
    int w1088;
    int w1089;
    int w1090;
    int w1091;
    int w1092;
    int w1093;
    int w1094;
    int w1095;
    int w1096;
    int w1097;
    int w1098;
    int w1099;
    int w1100;
    int l626[2]; // r
    int l627[2]; // g
    int l628[2]; // b
    int l629[2];
    int l630[2];
    int w1101;
    int w1102;
    int w1103[3][17];
    int rgb_out[3];

    int reg_clk0_sel;
    int reg_test0;
    int reg_test_18;
    int reg_hit;
    int reg_test1;
    int reg_80_b7;
    int reg_80_b6;
    int reg_lcb;
    int reg_ie1;
    int reg_80_b3;
    int reg_80_b2;
    int reg_m3;
    int reg_80_b0;
    int reg_lsm0;
    int reg_lsm1;
    int reg_ste;
    int reg_8c_b4;
    int reg_8c_b5;
    int reg_8c_b6;
    int reg_rs0;
    int reg_rs1; // h40
    int reg_81_b0;
    int reg_81_b1;
    int reg_m5;
    int reg_m2;
    int reg_m1;
    int reg_ie0;
    int reg_disp;
    int reg_81_b7;
    int reg_lscr;
    int reg_hscr;
    int reg_vscr;
    int reg_ie2;
    int reg_8b_b4;
    int reg_8b_b5;
    int reg_8b_b6;
    int reg_8b_b7;
    int reg_lsm0_latch;
    int reg_lsm1_latch;
    int reg_code;
    int reg_addr;
    int reg_inc;
    dff_t reg_data;
    int reg_sa_high;
    int reg_dmd;
    int reg_lg[2];
    int reg_sa_low[2];

    int hclk1;
    int hclk2;

    vdp_i_state_t input, input_old;

    int o_vram_se1;
    int o_vram_se0;
    int o_vram_sc;
    int o_vram_ras;
    int o_vram_cas;
    int o_vram_we1;
    int o_vram_we0;
    int o_vram_oe1;
    int o_vram_rd;
    int o_vram_rd_z;
    int o_vram_ad;
    int o_vram_ad_z;
    int o_ys;
    int o_spa;
    int o_vsync;
    int o_csync;
    int o_hsync;
    int o_data;
    int o_data_z;
    int o_address;
    int o_address_z;
    int o_zint;
    int o_br;
    int o_bgack;
    int o_ipl1;
    int o_ipl2;
    int o_dtack;
    int o_uwr;
    int o_lwr;
    int o_oe0;
    int o_cas0;
    int o_ras0;
    int o_ram_addr;

    int vram_address; // 17 bits
    int vram_data; // 16 bits
    int vram_serial; // 8 bits

    int color_index;
    int color_pal;
    int color_priority;
} vdp_t;

#pragma pack(pop)

void VDP_ClockMCLK(vdp_prescaler_t *chip);
void VDP_ClockDCLK(vdp_t *chip, int clk1, int clk2);
void VDP_ClockPSG(vdp_psg_t *chip);

void VDP_ClockMCLK2(vdp_prescaler_t* chip, int mclk);
void VDP_ClockDCLK2(vdp_t *chip, int clk1, int clk2);
void VDP_ClockPSG2(vdp_psg_t* chip, int clk);

void VDP_UpdateBusOutput(vdp_t *chip);