# Misti Release Checklist

- [ ] Release new Misti version
  - [ ] Run: `yarn release --dry-run` to ensure everything works as expected
  - [ ] Run: `yarn release` and follow the instructions
- [ ] Create a GitHub release
- [ ] Prepare [documentation](https://github.com/nowarp/nowarp.github.io/):
  - [ ] Update the supported Tact version in the introduction page
  - [ ] Generate detectors documentation: `yarn detector-docs ../nowarp.github.io/docs/detectors/`
  - [ ] Update the `detectors.md` page
  - [ ] Update `sidebars.ts` adding new detectors
  - [ ] Check whether `configuration.md` and `cli.md` should be updated
  - [ ] Check if examples are updated according to API changes
  - [ ] Ensure that funding information is actual
  - [ ] Run: `yarn spell && yarn build` from the `nowarp.github.io` directory to ensure there are no errors
  - [ ] Release a new version of documentation: `npx docusaurus docs:version <VERSION>`
  - [ ] Run: `yarn build && yarn deploy` from the `nowarp.github.io` directory
- [ ] Update [`blueprint-misti`](https://github.com/nowarp/blueprint-misti):
  - [ ] Update Misti version and build the project
  - [ ] Release it in order to update the npm dependency
- [ ] Update [`tact-template`](https://github.com/tact-lang/tact-template):
  - [ ] Update the Misti version in `package.json`
  - [ ] Ensure the commands in `package.json` and the GitHub Actions workflow are up to date
- [ ] Create a post that highlights introduced changes
