/*
 * Notifo.io
 *
 * @license
 * Copyright (c) Sebastian Stehle. All rights reserved.
 * Author: alibildir
 */

/* eslint sort-keys-fix/sort-keys-fix: "error" */

export const TR = {
    app: {
        allowEmail: 'E-postaları İzin Ver',
        allowSms: 'SMS İzin Ver',
        apiDetails: 'API Kimlik Bilgileriniz',
        apiKey: 'API Anahtarı',
        confirmUrl: 'Onay URL\'si',
        emailSettings: 'E-posta Ayarları',
        emailVerificationHint: 'E-posta adresinizi doğrulamak için Amazon\'dan kısa bir süre sonra bir e-posta alacaksınız. Lütfen e-postadaki linke tıklayın',
        firebaseCredential: 'Kimlik Bilgisi',
        firebaseProject: 'Proje',
        firebaseSettings: 'Firebase Ayarları',
        smsSettings: 'SMS Ayarları',
        urls: 'URL Ayarları',
        webhookUrl: 'Webhook URL\'si',
        welcome: (app: string) => `Hoş Geldiniz ${app} Uygulamasına`,
    },
    apps: {
        createButton: 'Yeni Uygulama',
        createHeader: 'Yeni Uygulama Oluştur',
        createInfo: 'İsim, kullanıcı arayüzünde kullanılır ve daha sonra değiştirilebilir.',
        header: 'Uygulamalar',
        notFound: 'Uygulama Bulunamadı',
    },
    code: 'tr',
    common: {
        actions: 'Eylemler',
        add: 'Ekle',
        admin: 'Yönetici',
        after: 'sonra',
        allowedModes: {
            Allowed: 'İzinli',
            NotAllowed: 'İzinli Değil',
        },
        appId: 'Uygulama Kimliği',
        apps: 'Uygulamalar',
        attempt: 'Deneme',
        back: 'Geri',
        cancel: 'İptal',
        channel: 'Kanal',
        channels: 'Kanallar',
        close: 'Kapat',
        code: 'Kod',
        conditionModes: {
            Always: 'Her zaman',
            IfNotConfirmed: 'Onaylanmamışsa',
            IfNotSeen: 'Görülmemişse',
            Inherit: '-',
        },
        confirm: 'Onayla',
        confirmLink: 'Onayla Bağlantısı',
        confirmLinkHints: 'Düğmeye basıldıktan sonra açılacak URL.',
        confirmMode: 'Onay Modu',
        confirmModeHints: 'Açık modda bir bildirimi onaylamak için bir düğme gösterilecektir.',
        confirmModes: {
            Explicit: 'Açık',
            None: 'Hiçbiri',
        },
        confirmText: 'Onay Metni',
        confirmTextHints: 'Onay düğmesinin varsayılan metnini geçersiz kıl.',
        confirmed: 'Onaylandı',
        contributors: 'Katkıda Bulunanlar',
        count: 'Sayı',
        create: 'Oluştur',
        created: 'Oluşturuldu',
        dangerZone: 'Tehlike Bölgesi',
        dashboard: 'Anasayfa',
        data: 'Veri',
        dataHints: 'Kodunuzda kullanılabilecek isteğe bağlı veriler.',
        date: 'Tarih',
        delete: 'Sil',
        delivered: 'Teslim Edildi',
        demo: 'Demo',
        description: 'Açıklama',
        design: 'Tasarım',
        device: 'Cihaz',
        disabled: 'Devre Dışı Bırakıldı',
        edit: 'Düzenle',
        email: 'E-posta',
        emailAddress: 'E-posta Adresi',
        emailName: 'E-posta Adı',
        emailPlaceholder: 'ad@web-sitem.com',
        emailTemplate: 'E-posta Şablonu',
        emailVerificationStatus: 'E-posta doğrulama durumu',
        emails: 'E-postalar',
        emoji: 'Emoji',
        enabled: 'Etkin',
        error: 'Hata oluştu',
        failed: 'Başarısız',
        feedback: 'Geri bildirim',
        firstConfirmed: 'İlk Onaylanan',
        firstDelivered: 'İlk Teslim Edilen',
        firstSeen: 'İlk görülen',
        formatting: 'Biçimlendirme',
        fromEmail: 'Gönderen E-posta Adresi',
        fromName: 'Gönderen Adı',
        handled: 'İşlendi',
        history: 'Geçmiş',
        html: 'HTML',
        id: 'Kimlik',
        imageLarge: 'Büyük Resim',
        imageSmall: 'Küçük Resim',
        invite: 'Davet Et',
        inviteByEmail: 'Katkıda bulunmak için e-posta adresini girin.',
        language: 'Dil',
        languages: 'Diller',
        lastNotification: 'Son Bildirim',
        lastSeen: 'Son görülen',
        lastUpdate: 'Son Güncelleme',
        lastWakeup: 'Son Uyanma',
        linkText: 'Bağlantı Metni',
        linkTextHints: 'Bir bağlantı görüntülendiğinde gösterilecek metni ayarlayın.',
        linkUrl: 'Bağlantı URL\'si',
        linkUrlHints: 'Bildirim veya bağlantı tıklandığında açılacak URL.',
        loading: 'Yükleniyor',
        logout: 'Çıkış Yap',
        message: 'Mesaj',
        messageBody: 'İçerik',
        messageSubject: 'Konu',
        mobilePush: 'Mobil',
        mode: 'Mod',
        more: 'Daha Fazla',
        name: 'Ad',
        no: 'Hayır',
        noIntegration: 'Entegrasyon yapılandırılmamış.',
        noName: '-İsimsiz-',
        noTemplate: 'Adlandırılmış şablon bulunamadı.',
        notAvailable: 'Mevcut değil',
        notStarted: 'Başlamadı',
        notYet: 'Henüz',
        notificationSettings: 'Bildirim Ayarları',
        notifications: 'Bildirimler',
        overview: 'Genel Bakış',
        pagination: (start: number, end: number, total: number) => `${start} ile ${end} arasında ${total}`,
        password: 'Şifre',
        passwordConfirm: 'Şifreyi Onayla',
        passwordsDoNotMatch: 'Şifreler eşleşmiyor.',
        pending: 'Bekleyen',
        phoneNumber: 'Telefon Numarası',
        preview: 'Önizleme',
        primary: 'Birincil',
        prio: 'Öncelik',
        profile: 'Profil',
        profileSettings: 'Ayarlarınız',
        propability: 'Olasılık',
        properties: 'Properties',
        property: 'Özellik',
        publish: 'Yayımla',
        refresh: 'Yenile',
        requiredModes: {
            Inherit: '-',
            NotRequired: 'Zorunlu değil',
            Required: 'Zorunlu',
        },
        roles: 'Roller',
        rules: 'Kurallar',
        sampleSubject: '-- Henüz Başlık Atanmadı --',
        save: 'Kaydet',
        secondsShort: 'sn.',
        seen: 'Görüldü',
        select: 'Seç',
        send: 'Gönder',
        sendModes: {
            Inherit: '-',
            NotAllowed: 'İzin verme',
            NotSending: 'Gönderme',
            Send: 'Gönder',
        },
        sent: 'Gönderilen',
        settings: 'Ayarlar',
        showDetails: 'Detayları göster',
        silent: 'Sessiz',
        skipped: 'Atlandı',
        sms: 'SMS',
        smsTemplate: 'SMS Şablonu',
        statisticsInfo: 'Her 5 saniyede güncellenir (yenileme gereklidir)',
        statisticsLabelFn: (name: string) => `${name} (İşlenen / Deneme / Başarısız)`,
        status: 'Durum',
        subject: 'Konu',
        system: 'Sistem',
        template: 'Şablon',
        templateCode: 'Şablon Kodu',
        templateCodeHints: 'Bir şablon kullanılıyorsa tüm özellikler (konu, gövde vb.) şablondan alınır, ancak gerektiğinde geçersiz kılınabilir.',
        templateMode: 'Şablon kullan?',
        templates: 'Şablonlar',
        text: 'Metin',
        timeOfDay: 'Günün Zamanı',
        timeToLive: 'Saniye cinsinden yaşam süresi',
        timestamp: 'Zaman Damgası',
        timezone: 'Zaman dilimi',
        token: 'Anahtar',
        topic: 'Konu',
        topicPath: 'Konu Adı',
        uploadButton: 'Dosya(lar) seç',
        uploadText: 'Varolan öğenin üzerine yeni bir sürümle değiştirmek için dosyayı bırakın.',
        urlPlaceholder: 'https://sitem.com/yol',
        users: 'Kullanıcılar',
        variants: 'Farklılar',
        verified: 'Doğrulandı',
        via: 'üzerinden',
        webPlugin: 'Web Eklentisi',
        webPluginHint: 'Web uygulamanıza Notifo\'yu entegre etmek için Pluginimizi kullanın',
        webPush: 'Web Anlık İleti',
        weekDay: 'Hafta Günü',
        weekDays: {
            friday: 'Cuma',
            monday: 'Pazartesi',
            saturday: 'Cumartesi',
            sunday: 'Pazar',
            thursday: 'Perşembe',
            tuesday: 'Salı',
            wednesday: 'Çarşamba',
        },
        welcome: 'Hoşgeldiniz',
        when: 'öyle ise',
        with: 'ile',
        yes: 'Evet',
    },
    demo: {
        featureButton: 'Varsayılan bildirim düğmesi.',
        featureSubscribe: (topic: string, icon: string) => `\`${topic}\` konusuna \`${icon}\` simgesi ile abone olma.`,
        title: 'Notifo Demo Sayfası',
    },
    emailTemplates: {
        bodyHtml: 'HTML Gövde',
        bodyHtmlValid: 'HTML Gövdesi gerekli ve geçerli bir şablon olmalıdır',
        bodyText: 'Metin Gövde',
        bodyTextValid: 'Metin Gövdesi gerekli ve geçerli bir şablon olmalıdır',
        confirmDelete: 'Şablonu gerçekten silmek istiyor musunuz?',
        create: 'Oluştur',
        createWithInterpolation: 'MJML (Eski)',
        createWithLiquid: 'MJML + Liquid',
        header: 'E-posta Şablonları',
        name: 'Şablon Adı',
        notFound: 'Hiçbir e-posta şablonu bulunamadı',
        notFoundButton: 'Şablon oluştur',
        notFoundLanguage: 'Bu dil için e-posta şablonu bulunamadı.',
        subjectValid: 'Konu gerekli ve geçerli bir şablon olmalıdır',
    },
    events: {
        eventsNotFound: 'Eşleşen bir etkinlik bulunamadı',
        header: 'Etkinlikler',
        searchPlaceholder: 'Arama',
    },
    integrations: {
        condition: 'Koşul',
        conditionHints: 'Entegrasyonun ne zaman kullanılması gerektiği.',
        configured: 'Yapılandırıldı',
        confirmDelete: 'Entegrasyonu gerçekten silmek istiyor musunuz?',
        enabledHints: 'Entegrasyonu silmeden devre dışı bırakın.',
        header: 'Entegrasyonlar',
        modeProduction: 'PROD',
        modeTest: 'TEST',
        priority: 'Öncelik',
        priorityHints: 'Aynı kanal için birden fazla entegrasyon yapılandırdığınızda bir öncelik belirleyin, örneğin MobilePush.',
        supported: 'Desteklenen',
        test: 'Test Modu',
        testHints: 'Bu entegrasyonu yalnızca üretim veya geliştirme modu için kullanın.',
    },
    log: {
        header: 'Log',
        logEntriesNotFound: 'Eşleşen günlük girişi bulunamadı',
        searchPlaceholder: 'Arama',
        userHeader: 'Kullanıcı Günlüğü',
    },
    media: {
        confirmDelete: 'Ortamı gerçekten silmek istiyor musunuz?',
        header: 'Ortam',
        mediaNotFound: 'Eşleşen ortam bulunamadı',
        searchPlaceholder: 'Arama',
    },
    messagingTemplates: {
        confirmDelete: 'Şablonu gerçekten silmek istiyor musunuz?',
        create: 'Oluştur',
        header: 'Mesaj Şablonları',
        name: 'Şablon Adı',
        notFound: 'Hiçbir mesaj şablonu bulunamadı',
        notFoundButton: 'Şablon oluştur',
        singleHeader: 'Mesaj Şablonu',
    },
    notificationSettings: {
        channelGroupKey: 'Grup Anahtarı',
        channelGroupKeyHints: 'Sadece bu belirli kanal için bildirimleri gruplamak için kullanılan paylaşılan bir anahtarı tanımlayın. Grup içindeki son bildirim saklanır ve diğer bildirimler çocuk bildirimler olarak eklenir ve biçimlendirme için kullanılabilir. Tüm bildirimler izlenir. Gruplama kullanmak için bir gecikme tanımlamanız gerekmektedir.',
        delayInSeconds: 'Saniye cinsinden gecikme',
        delayInSecondsHints: 'Bu zaman aralığında oluşturulan tüm bildirimler birlikte gönderilir.',
        email: {
            name: 'E-posta',
            send: 'E-posta olarak gönder',
            title: 'E-posta',
        },
        fromEmailHints: 'Gönderen e-posta adresini geçersiz kıl.',
        fromNameHints: 'Gönderen e-posta adını geçersiz kıl.',
        groupKey: 'Grup Anahtarı',
        groupKeyHints: 'Bildirimleri gruplamak için kullanılan paylaşılan bir anahtar tanımlayın. Grup içindeki son bildirim saklanır ve diğer bildirimler çocuk bildirimler olarak eklenir ve biçimlendirme için kullanılabilir. Bu bildirimler daha fazla izlenmez. Gruplama kullanmak için bir zamanlama tanımlamanız gerekmektedir.',
        messaging: {
            name: 'Mesajlaşma',
            send: 'Mesajlaşma yoluyla gönder (Threema, ...)',
            title: 'Mesajlaşma',
        },
        mobilepush: {
            name: 'Mobil Bildirim',
            send: 'Mobil Bildirim olarak gönder',
            title: 'Mobil Bildirim',
        },
        required: 'Gerekli',
        requiredHints: 'Bir kanal gereklidir ve (örneğin Mobil Token gibi) bir yapılandırma yoksa, bir günlük mesajı oluşturulur.',
        scheduling: 'Zamanlama',
        schedulingInfo: 'Ya net bir gün belirleyin ya da haftanın bir sonraki gününü belirleyin.',
        schedulingToggle: 'Bildirimi belirli bir saatte gönderin',
        schedulingTypes: {
            userTime: 'Kullanıcı saat dilimi',
            utc: 'UTC',
        },
        settingsInfo: 'Bildirim ayarları aşağıdaki sırayla birleştirilecektir:\n\n1. Kullanıcı ayarları.\n2. Konu ayarları tarafından geçersiz kılınmıştır.\n3. Bildirim ayarları tarafından geçersiz kılınmıştır.',
        sms: {
            name: 'SMS',
            send: 'SMS olarak gönder',
            title: 'SMS',
        },
        templateHints: 'Bu kanal için şablonu seçin. Burada yalnızca bir adı olan şablonlar görüntülenecektir. Eğer bir şablon tanımlanmamışsa birincil şablon kullanılır.',
        web: {
            name: 'Web',
            send: 'Web Sayfası Üzerinden Gönder',
            title: 'Web',
        },
        webhook: {
            name: 'Webhook',
            send: 'Başka bir Sunucuya Gönder',
            title: 'Webhook',
        },
        webhookHints: 'Bu kanal için webhook entegrasyonunu seçin. Burada yalnızca bir adı olan webhooklar görüntülenecektir. Eğer bir webhook tanımlanmamışsa tüm webhooklar kullanılır.',
        webpush: {
            name: 'Web Push',
            send: 'Web Push Olarak Gönder',
            title: 'Web Push',
        },
    },
    notifications: {
        header: 'Bildirimler',
        notificationsNotFound: 'Eşleşen bildirim bulunamadı',
        searchPlaceholder: 'Ara',
    },
    publish: {
        header: 'Yayımla',
        success: 'Etkinlik yayımlandı.',
    },
    smsTemplates: {
        confirmDelete: 'Şablonu gerçekten silmek istiyor musunuz?',
        create: 'Oluştur',
        header: 'SMS Şablonları',
        name: 'Şablon Adı',
        notFound: 'Hiçbir SMS şablonu bulunamadı',
        notFoundButton: 'Şablon oluştur',
        singleHeader: 'SMS Şablonu',
    },
    subscriptions: {
        confirmDelete: 'Aboneliği gerçekten silmek istiyor musunuz?',
        createButton: 'Abone Ol',
        createHeader: 'Yeni Abonelik Oluştur',
        editHeader: 'Aboneliği Düzenle',
        header: 'Abonelikler',
        searchPlaceholder: 'Ara',
        subscriptionsNotFound: 'Eşleşen abonelik bulunamadı',
    },
    systemUsers: {
        createHeader: 'Yeni Kullanıcı Oluştur',
        editHeader: 'Kullanıcıyı Düzenle',
        header: 'Sistem Kullanıcıları',
        searchPlaceholder: 'Ara',
    },
    templates: {
        confirmDelete: 'Şablonu gerçekten silmek istiyor musunuz?',
        createButton: 'Yeni',
        header: 'Şablonlar',
        templateEdit: 'Düzenle',
        templateNew: 'Yeni Şablon',
        templatesNotFound: 'Eşleşen şablon bulunamadı',
    },
    topics: {
        all: 'Tüm Konular',
        createButton: 'Yeni Konu',
        createHeader: 'Yeni Konu',
        descriptionPlaceholder: 'Bu konunun amacını ve içeriğini açıklayın.',
        explicit: 'Açık',
        header: 'Konular',
        implicit: 'Örtük',
        namePlaceholder: 'Konuya bir isim verin.',
        searchPlaceholder: 'Ara',
        showAutomatically: 'Otomatik göster',
        showAutomaticallyHints: 'Kullanıcıya frontend\'i ilk kez kullandığında abone olmasını isteyin.',
        topicsNotFound: 'Eşleşen konu bulunamadı',
    },
    users: {
        confirmDelete: 'Kullanıcıyı gerçekten silmek istiyor musunuz?',
        createButton: 'Yeni Kullanıcı',
        createHeader: 'Yeni Kullanıcı Oluştur',
        editHeader: 'Kullanıcıyı Düzenle',
        header: 'Kullanıcılar',
        lock: 'Kilitle',
        logs: 'Kullanıcı Günlüğünü Görüntüle',
        searchPlaceholder: 'Ara',
        unlock: 'Kilidi Aç',
        userDetails: 'Kullanıcı Detayları',
        userNotFound: 'Kullanıcı bulunamadı',
        usersNotFound: 'Eşleşen kullanıcı bulunamadı',
    },
    validation: {
        atLeastOnString: (p: { label?: string }) => `${p.label} en az bir değere sahip olmalıdır.`,
        emailFn: (p: { label?: string }) => `${p.label} geçerli bir e-posta adresi olmalıdır.`,
        httpUrlFn: (p: { label?: string }) => `${p.label} geçerli bir HTTP URL'si olmalı (protokolü ekleyin - http veya https).`,
        lessThanFn: (p: { label?: string; less: number }) => `${p.label} ${p.less || 0}\`dan küçük olmalıdır.`,
        maxFn: (p: { label?: string; max: number }) => `${p.label} ${p.max}\`dan büyük olmamalıdır.`,
        maxItemsFn: (p: { label?: string; max: number }) => `${p.label} en fazla ${p.max} öğeye sahip olmalıdır.`,
        maxLengthFn: (p: { label?: string; max: number }) => `${p.label} en fazla ${p.max} karakter olmalıdır.`,
        minFn: (p: { label?: string; min: number }) => `${p.label} en az ${p.min} olmalıdır.`,
        minItemsFn: (p: { label?: string; min: number }) => `${p.label} en az ${p.min || 0} öğeye sahip olmalıdır.`,
        minLengthFn: (p: { label?: string; min: number }) => `${p.label} en az ${p.min} karakter olmalıdır.`,
        moreThanFn: (p: { label?: string; more: number }) => `${p.label} ${p.more || 0}\`dan büyük olmalıdır.`,
        patternFn: (p: { label?: string }) => `${p.label} geçerli bir formatta değil.`,
        requiredFn: (p: { label?: string }) => `${p.label} zorunludur.`,
        topicFn: (p: { label?: string }) => `${p.label} geçerli bir konu olmalıdır.`,
    },
};
