//----------------------
// <auto-generated>
//     Generated using the NSwag toolchain v14.0.3.0 (NJsonSchema v11.0.0.0 (Newtonsoft.Json v13.0.0.0)) (http://NSwag.org)
// </auto-generated>
//----------------------

/* tslint:disable */
/* eslint-disable */
// ReSharper disable InconsistentNaming

export class UserClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Get the current user.
     * @return User returned.
     */
    getUser(signal?: AbortSignal): Promise<ProfileDto> {
        let url_ = this.baseUrl + "/api/me";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetUser(_response);
        });
    }

    protected processGetUser(response: Response): Promise<ProfileDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ProfileDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ProfileDto>(null as any);
    }

    /**
     * Update the user.
     * @param request The upsert request.
     * @return Users upserted.
     */
    postUser(request: UpdateProfileDto, signal?: AbortSignal): Promise<ProfileDto> {
        let url_ = this.baseUrl + "/api/me";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostUser(_response);
        });
    }

    protected processPostUser(response: Response): Promise<ProfileDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ProfileDto;
            return result200;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ProfileDto>(null as any);
    }

    /**
     * Get the current admin user.
     * @return User returned.
     */
    getAdminUser(signal?: AbortSignal): Promise<AdminProfileDto> {
        let url_ = this.baseUrl + "/api/me/admin";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetAdminUser(_response);
        });
    }

    protected processGetAdminUser(response: Response): Promise<AdminProfileDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AdminProfileDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AdminProfileDto>(null as any);
    }

    /**
     * Query the user topics.
     * @param language (optional) The optional language.
     * @return User subscriptions returned.
     */
    getTopics(language?: string | null | undefined, signal?: AbortSignal): Promise<UserTopicDto[]> {
        let url_ = this.baseUrl + "/api/me/topics?";
        if (language !== undefined && language !== null)
            url_ += "language=" + encodeURIComponent("" + language) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTopics(_response);
        });
    }

    protected processGetTopics(response: Response): Promise<UserTopicDto[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as UserTopicDto[];
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<UserTopicDto[]>(null as any);
    }

    /**
     * Query the user subscriptions.
     * @param topics (optional) The topics we are interested in.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return User subscriptions returned.
     */
    getMySubscriptions(topics?: string | null | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfSubscriptionDto> {
        let url_ = this.baseUrl + "/api/me/subscriptions?";
        if (topics !== undefined && topics !== null)
            url_ += "Topics=" + encodeURIComponent("" + topics) + "&";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMySubscriptions(_response);
        });
    }

    protected processGetMySubscriptions(response: Response): Promise<ListResponseDtoOfSubscriptionDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfSubscriptionDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfSubscriptionDto>(null as any);
    }

    /**
     * Upserts or deletes my subscriptions.
     * @param request The subscription settings.
     * @return User subscribed.
     */
    postMySubscriptions(request: SubscribeManyDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/me/subscriptions";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostMySubscriptions(_response);
        });
    }

    protected processPostMySubscriptions(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Gets a user subscription.
     * @param topic The topic path.
     * @return Subscription exists.
     */
    getMySubscription(topic: string, signal?: AbortSignal): Promise<SubscriptionDto> {
        let url_ = this.baseUrl + "/api/me/subscriptions/{topic}";
        if (topic === undefined || topic === null)
            throw new Error("The parameter 'topic' must be defined.");
        url_ = url_.replace("{topic}", encodeURIComponent("" + topic));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMySubscription(_response);
        });
    }

    protected processGetMySubscription(response: Response): Promise<SubscriptionDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as SubscriptionDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Subscription does not exist.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SubscriptionDto>(null as any);
    }

    /**
     * Remove my subscription.
     * @param prefix The topic prefix.
     * @return User unsubscribed.
     */
    deleteSubscription(prefix: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/me/subscriptions/{prefix}";
        if (prefix === undefined || prefix === null)
            throw new Error("The parameter 'prefix' must be defined.");
        url_ = url_.replace("{prefix}", encodeURIComponent("" + prefix));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "POST",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteSubscription(_response);
        });
    }

    protected processDeleteSubscription(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class UsersClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query users.
     * @param appId The app where the users belongs to.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @param withDetails (optional) Provide extra details, might be expensive.
     * @return Users returned.
     */
    getUsers(appId: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, withDetails?: boolean | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfUserDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        if (withDetails === null)
            throw new Error("The parameter 'withDetails' cannot be null.");
        else if (withDetails !== undefined)
            url_ += "withDetails=" + encodeURIComponent("" + withDetails) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetUsers(_response);
        });
    }

    protected processGetUsers(response: Response): Promise<ListResponseDtoOfUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfUserDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfUserDto>(null as any);
    }

    /**
     * Upsert users.
     * @param appId The app where the users belong to.
     * @param request The upsert request.
     * @return Users upserted.
     */
    postUsers(appId: string, request: UpsertUsersDto, signal?: AbortSignal): Promise<UserDto[]> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostUsers(_response);
        });
    }

    protected processPostUsers(response: Response): Promise<UserDto[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as UserDto[];
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<UserDto[]>(null as any);
    }

    /**
     * Get a user.
     * @param appId The app where the user belongs to.
     * @param id The user ID.
     * @param withDetails (optional) Provide extra details, might be expensive.
     * @return User returned.
     */
    getUser(appId: string, id: string, withDetails?: boolean | undefined, signal?: AbortSignal): Promise<UserDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (withDetails === null)
            throw new Error("The parameter 'withDetails' cannot be null.");
        else if (withDetails !== undefined)
            url_ += "withDetails=" + encodeURIComponent("" + withDetails) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetUser(_response);
        });
    }

    protected processGetUser(response: Response): Promise<UserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as UserDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<UserDto>(null as any);
    }

    /**
     * Delete a user.
     * @param appId The app where the users belongs to.
     * @param id The user id to delete.
     * @return User deleted.
     */
    deleteUser(appId: string, id: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteUser(_response);
        });
    }

    protected processDeleteUser(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Query user subscriptions.
     * @param appId The app where the user belongs to.
     * @param id The user ID.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return User subscriptions returned.
     */
    getSubscriptions(appId: string, id: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfSubscriptionDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/subscriptions?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetSubscriptions(_response);
        });
    }

    protected processGetSubscriptions(response: Response): Promise<ListResponseDtoOfSubscriptionDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfSubscriptionDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfSubscriptionDto>(null as any);
    }

    /**
     * Upserts or deletes multiple user subscriptions.
     * @param appId The app where the user belongs to.
     * @param id The user ID.
     * @param request The subscription object.
     * @return User subscribed.
     */
    postSubscriptions(appId: string, id: string, request: SubscribeManyDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/subscriptions";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostSubscriptions(_response);
        });
    }

    protected processPostSubscriptions(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Unsubscribes a user from a subscription.
     * @param appId The app where the user belongs to.
     * @param id The user ID.
     * @param prefix The topic prefix.
     * @return User unsubscribed.
     */
    deleteSubscription(appId: string, id: string, prefix: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/subscriptions/{prefix}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (prefix === undefined || prefix === null)
            throw new Error("The parameter 'prefix' must be defined.");
        url_ = url_.replace("{prefix}", encodeURIComponent("" + prefix));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteSubscription(_response);
        });
    }

    protected processDeleteSubscription(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Add an allowed topic.
     * @param appId The app where the users belong to.
     * @param id The user ID.
     * @param request The upsert request.
     * @return User updated.
     */
    postAllowedTopic(appId: string, id: string, request: AddAllowedTopicDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/allowed-topics";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostAllowedTopic(_response);
        });
    }

    protected processPostAllowedTopic(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Remove an allowed topic.
     * @param appId The app where the users belong to.
     * @param id The user ID.
     * @param prefix The topic prefix.
     * @return User updated.
     */
    deleteAllowedTopic(appId: string, id: string, prefix: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/allowed-topics/{prefix}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (prefix === undefined || prefix === null)
            throw new Error("The parameter 'prefix' must be defined.");
        url_ = url_.replace("{prefix}", encodeURIComponent("" + prefix));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteAllowedTopic(_response);
        });
    }

    protected processDeleteAllowedTopic(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Remove an web push token.
     * @param appId The app where the users belong to.
     * @param id The user ID.
     * @param token The token.
     * @return User updated.
     */
    deleteMobilePushToken(appId: string, id: string, token: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/mobilepush/{token}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteMobilePushToken(_response);
        });
    }

    protected processDeleteMobilePushToken(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Remove an web push subscription.
     * @param appId The app where the users belong to.
     * @param id The user ID.
     * @param endpoint The endpoint.
     * @return User updated.
     */
    deleteWebPushSubscription(appId: string, id: string, endpoint: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/webpush/{endpoint}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (endpoint === undefined || endpoint === null)
            throw new Error("The parameter 'endpoint' must be defined.");
        url_ = url_.replace("{endpoint}", encodeURIComponent("" + endpoint));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteWebPushSubscription(_response);
        });
    }

    protected processDeleteWebPushSubscription(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class TopicsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query topics.
     * @param appId The app where the topics belongs to.
     * @param scope (optional) The scope of the query.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Topics returned.
     */
    getTopics(appId: string, scope?: TopicQueryScope | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfTopicDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/topics?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (scope === null)
            throw new Error("The parameter 'scope' cannot be null.");
        else if (scope !== undefined)
            url_ += "Scope=" + encodeURIComponent("" + scope) + "&";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTopics(_response);
        });
    }

    protected processGetTopics(response: Response): Promise<ListResponseDtoOfTopicDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfTopicDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfTopicDto>(null as any);
    }

    /**
     * Upsert topics.
     * @param appId The app where the topics belong to.
     * @param request The upsert request.
     * @return Named topics upserted.
     */
    postTopics(appId: string, request: UpsertTopicsDto, signal?: AbortSignal): Promise<TopicDto[]> {
        let url_ = this.baseUrl + "/api/apps/{appId}/topics";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTopics(_response);
        });
    }

    protected processPostTopics(response: Response): Promise<TopicDto[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as TopicDto[];
            return result200;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<TopicDto[]>(null as any);
    }

    /**
     * Delete a topic.
     * @param appId The app where the topics belong to.
     * @param path The path of the topic to delete.
     * @return Topic deleted.
     */
    deleteTopic(appId: string, path: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/topics/{path}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (path === undefined || path === null)
            throw new Error("The parameter 'path' must be defined.");
        url_ = url_.replace("{path}", encodeURIComponent("" + path));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTopic(_response);
        });
    }

    protected processDeleteTopic(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class TemplatesClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query templates.
     * @param appId The app where the templates belongs to.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Templates returned.
     */
    getTemplates(appId: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/templates?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplates(_response);
        });
    }

    protected processGetTemplates(response: Response): Promise<ListResponseDtoOfTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfTemplateDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfTemplateDto>(null as any);
    }

    /**
     * Upsert templates.
     * @param appId The app where the templates belong to.
     * @param request The upsert request.
     * @return Templates upserted.
     */
    postTemplates(appId: string, request: UpsertTemplatesDto, signal?: AbortSignal): Promise<TemplateDto[]> {
        let url_ = this.baseUrl + "/api/apps/{appId}/templates";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplates(_response);
        });
    }

    protected processPostTemplates(response: Response): Promise<TemplateDto[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as TemplateDto[];
            return result200;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<TemplateDto[]>(null as any);
    }

    /**
     * Delete a template.
     * @param appId The app where the templates belong to.
     * @param code The template code to delete.
     * @return Template deleted.
     */
    deleteTemplate(appId: string, code: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplate(_response);
        });
    }

    protected processDeleteTemplate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class SystemUsersClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query users.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Users returned.
     */
    getUsers(query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfSystemUserDto> {
        let url_ = this.baseUrl + "/api/system-users?";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetUsers(_response);
        });
    }

    protected processGetUsers(response: Response): Promise<ListResponseDtoOfSystemUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfSystemUserDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfSystemUserDto>(null as any);
    }

    /**
     * Create a user.
     * @param request The create request.
     * @return User created.
     */
    postUser(request: CreateSystemUserDto, signal?: AbortSignal): Promise<SystemUserDto> {
        let url_ = this.baseUrl + "/api/system-users";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostUser(_response);
        });
    }

    protected processPostUser(response: Response): Promise<SystemUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 201) {
            return response.text().then((_responseText) => {
            let result201: any = null;
            result201 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as SystemUserDto;
            return result201;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SystemUserDto>(null as any);
    }

    /**
     * Get a user.
     * @param id The user ID.
     * @return User returned.
     */
    getUser(id: string, signal?: AbortSignal): Promise<SystemUserDto> {
        let url_ = this.baseUrl + "/api/system-users/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetUser(_response);
        });
    }

    protected processGetUser(response: Response): Promise<SystemUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as SystemUserDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SystemUserDto>(null as any);
    }

    /**
     * Update the user.
     * @param id The user ID.
     * @param request The update request.
     * @return User updated.
     */
    putUser(id: string, request: UpdateSystemUserDto, signal?: AbortSignal): Promise<SystemUserDto> {
        let url_ = this.baseUrl + "/api/system-users/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutUser(_response);
        });
    }

    protected processPutUser(response: Response): Promise<SystemUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as SystemUserDto;
            return result200;
            });
        } else if (status === 403) {
            return response.text().then((_responseText) => {
            let result403: any = null;
            result403 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("User cannot be updated.", status, _responseText, _headers, result403);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SystemUserDto>(null as any);
    }

    /**
     * Delete the user.
     * @param id The user ID.
     * @return User deleted.
     */
    deleteUser(id: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/system-users/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteUser(_response);
        });
    }

    protected processDeleteUser(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 403) {
            return response.text().then((_responseText) => {
            let result403: any = null;
            result403 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("User cannot be deleted.", status, _responseText, _headers, result403);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Lock the user.
     * @param id The user ID.
     * @return User locked.
     */
    lockUser(id: string, signal?: AbortSignal): Promise<SystemUserDto> {
        let url_ = this.baseUrl + "/api/system-users/{id}/lock";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "PUT",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processLockUser(_response);
        });
    }

    protected processLockUser(response: Response): Promise<SystemUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as SystemUserDto;
            return result200;
            });
        } else if (status === 403) {
            return response.text().then((_responseText) => {
            let result403: any = null;
            result403 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("User cannot be locked.", status, _responseText, _headers, result403);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SystemUserDto>(null as any);
    }

    /**
     * Unlock the user.
     * @param id The user ID.
     * @return User unlocked.
     */
    unlockUser(id: string, signal?: AbortSignal): Promise<SystemUserDto> {
        let url_ = this.baseUrl + "/api/system-users/{id}/unlock";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "PUT",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processUnlockUser(_response);
        });
    }

    protected processUnlockUser(response: Response): Promise<SystemUserDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as SystemUserDto;
            return result200;
            });
        } else if (status === 403) {
            return response.text().then((_responseText) => {
            let result403: any = null;
            result403 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("User cannot be unlocked.", status, _responseText, _headers, result403);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SystemUserDto>(null as any);
    }
}

export class PingClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Get ping status of the API.
     * @return Service ping successful.
     * @deprecated
     */
    getOldPing(signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/ping";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetOldPing(_response);
        });
    }

    protected processGetOldPing(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Get ping status of the API.
     * @return Service ping successful.
     */
    getPing(signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/ping";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetPing(_response);
        });
    }

    protected processGetPing(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Get some info about the API.
     */
    getInfo(signal?: AbortSignal): Promise<InfoDto> {
        let url_ = this.baseUrl + "/api/info";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetInfo(_response);
        });
    }

    protected processGetInfo(response: Response): Promise<InfoDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as InfoDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<InfoDto>(null as any);
    }
}

export class NotificationsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query notifications.
     * @param appId The app where the user belongs to.
     * @param channels (optional) The active channels.
     * @param channel (optional) The source channel.
     * @param correlationId (optional) The correlation ID, that can be used to query notifications.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return User notifications returned.
     */
    getAllNotifications(appId: string, channels?: string[] | null | undefined, channel?: string | null | undefined, correlationId?: string | null | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfUserNotificationDetailsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/notifications?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (channels !== undefined && channels !== null)
            channels && channels.forEach(item => { url_ += "Channels=" + encodeURIComponent("" + item) + "&"; });
        if (channel !== undefined && channel !== null)
            url_ += "Channel=" + encodeURIComponent("" + channel) + "&";
        if (correlationId !== undefined && correlationId !== null)
            url_ += "CorrelationId=" + encodeURIComponent("" + correlationId) + "&";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetAllNotifications(_response);
        });
    }

    protected processGetAllNotifications(response: Response): Promise<ListResponseDtoOfUserNotificationDetailsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfUserNotificationDetailsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfUserNotificationDetailsDto>(null as any);
    }

    /**
     * Query user notifications.
     * @param appId The app where the user belongs to.
     * @param id The user id.
     * @param channels (optional) The active channels.
     * @param channel (optional) The source channel.
     * @param correlationId (optional) The correlation ID, that can be used to query notifications.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return User notifications returned.
     */
    getNotifications(appId: string, id: string, channels?: string[] | null | undefined, channel?: string | null | undefined, correlationId?: string | null | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfUserNotificationDetailsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/users/{id}/notifications?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (channels !== undefined && channels !== null)
            channels && channels.forEach(item => { url_ += "Channels=" + encodeURIComponent("" + item) + "&"; });
        if (channel !== undefined && channel !== null)
            url_ += "Channel=" + encodeURIComponent("" + channel) + "&";
        if (correlationId !== undefined && correlationId !== null)
            url_ += "CorrelationId=" + encodeURIComponent("" + correlationId) + "&";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetNotifications(_response);
        });
    }

    protected processGetNotifications(response: Response): Promise<ListResponseDtoOfUserNotificationDetailsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfUserNotificationDetailsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("User or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfUserNotificationDetailsDto>(null as any);
    }

    /**
     * Query user notifications of the current user.
     * @param channels (optional) The active channels.
     * @param channel (optional) The source channel.
     * @param correlationId (optional) The correlation ID, that can be used to query notifications.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Notifications returned.
     */
    getMyNotifications(channels?: string[] | null | undefined, channel?: string | null | undefined, correlationId?: string | null | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfUserNotificationDto> {
        let url_ = this.baseUrl + "/api/me/notifications?";
        if (channels !== undefined && channels !== null)
            channels && channels.forEach(item => { url_ += "Channels=" + encodeURIComponent("" + item) + "&"; });
        if (channel !== undefined && channel !== null)
            url_ += "Channel=" + encodeURIComponent("" + channel) + "&";
        if (correlationId !== undefined && correlationId !== null)
            url_ += "CorrelationId=" + encodeURIComponent("" + correlationId) + "&";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMyNotifications(_response);
        });
    }

    protected processGetMyNotifications(response: Response): Promise<ListResponseDtoOfUserNotificationDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfUserNotificationDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfUserNotificationDto>(null as any);
    }

    /**
     * Query archived user notifications of the current user.
     * @param channel (optional) The tracking channel.
     * @return Notifications returned.
     */
    getMyArchive(channel?: string | null | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfUserNotificationDto> {
        let url_ = this.baseUrl + "/api/me/notifications/archive?";
        if (channel !== undefined && channel !== null)
            url_ += "channel=" + encodeURIComponent("" + channel) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMyArchive(_response);
        });
    }

    protected processGetMyArchive(response: Response): Promise<ListResponseDtoOfUserNotificationDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfUserNotificationDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfUserNotificationDto>(null as any);
    }

    /**
     * Query user notifications of the current user for a specific device.
     * @param deviceIdentifier (optional) The device identifier (aka mobile push token).
     * @param after (optional) The max age of the notifications.
     * @param scope (optional) The scope of the query.
     * @param take (optional) The number of notifications to query.
     * @return Notifications returned.
     */
    getMyDeviceNotifications(deviceIdentifier?: string | null | undefined, after?: string | undefined, scope?: DeviceNotificationsQueryScope | undefined, take?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfUserNotificationDto> {
        let url_ = this.baseUrl + "/api/me/notifications/device?";
        if (deviceIdentifier !== undefined && deviceIdentifier !== null)
            url_ += "DeviceIdentifier=" + encodeURIComponent("" + deviceIdentifier) + "&";
        if (after === null)
            throw new Error("The parameter 'after' cannot be null.");
        else if (after !== undefined)
            url_ += "After=" + encodeURIComponent("" + after) + "&";
        if (scope === null)
            throw new Error("The parameter 'scope' cannot be null.");
        else if (scope !== undefined)
            url_ += "Scope=" + encodeURIComponent("" + scope) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "Take=" + encodeURIComponent("" + take) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMyDeviceNotifications(_response);
        });
    }

    protected processGetMyDeviceNotifications(response: Response): Promise<ListResponseDtoOfUserNotificationDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfUserNotificationDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfUserNotificationDto>(null as any);
    }

    /**
     * Confirms the user notifications for the current user.
     * @param request The request object.
     * @return Notifications updated.
     */
    confirmMe(request: TrackNotificationDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/me/notifications/handled";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processConfirmMe(_response);
        });
    }

    protected processConfirmMe(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class MobilePushClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Returns the mobile push tokens.
     * @return Mobile push tokens returned.
     */
    getMyToken(signal?: AbortSignal): Promise<ListResponseDtoOfMobilePushTokenDto> {
        let url_ = this.baseUrl + "/api/me/mobilepush";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMyToken(_response);
        });
    }

    protected processGetMyToken(response: Response): Promise<ListResponseDtoOfMobilePushTokenDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfMobilePushTokenDto;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfMobilePushTokenDto>(null as any);
    }

    /**
     * Register a mobile push token for the current user.
     * @param request The request object.
     * @return Mobile push token registered.
     */
    postMyToken(request: RegisterMobileTokenDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/me/mobilepush";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostMyToken(_response);
        });
    }

    protected processPostMyToken(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Deletes a mobile push token for the current user.
     * @param token The token to remove.
     * @return Mobile push token removed.
     */
    deleteMyToken(token: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/me/mobilepush/{token}";
        if (token === undefined || token === null)
            throw new Error("The parameter 'token' must be defined.");
        url_ = url_.replace("{token}", encodeURIComponent("" + token));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteMyToken(_response);
        });
    }

    protected processDeleteMyToken(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class MediaClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query media items.
     * @param appId The app where the media belongs to.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Media returned.
     */
    getMedias(appId: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfMediaDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/media?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetMedias(_response);
        });
    }

    protected processGetMedias(response: Response): Promise<ListResponseDtoOfMediaDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfMediaDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfMediaDto>(null as any);
    }

    /**
     * Upload a media object.
     * @param appId The app id where the media belongs to.
     * @param file (optional) 
     * @return Media uploaded.
     */
    upload(appId: string, file?: FileParameter | undefined, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/media";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = new FormData();
        if (file === null || file === undefined)
            throw new Error("The parameter 'file' cannot be null.");
        else
            content_.append("file", file.data, file.fileName ? file.fileName : "file");

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processUpload(_response);
        });
    }

    protected processUpload(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 201) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Download a media object.
     * @param appId The app id where the media belongs to.
     * @param fileName The name of the media to download.
     * @param cache (optional) The cache duration.
     * @param download (optional) Set it to 1 to create a download response.
     * @param bg (optional) Optional background color.
     * @param width (optional) The target width when an image.
     * @param height (optional) The target height when an image.
     * @param quality (optional) The target quality when an image.
     * @param preset (optional) A preset dimension.
     * @param mode (optional) The resize mode.
     * @param focusX (optional) The x position of the focues point.
     * @param focusY (optional) The y position of the focues point.
     * @param force (optional) True to resize it and clear the cache.
     * @param emptyOnFailure (optional) True, to return an empty image on failure.
     * @return Media returned.
     */
    download(appId: string, fileName: string, cache?: number | undefined, download?: number | undefined, bg?: string | null | undefined, width?: number | null | undefined, height?: number | null | undefined, quality?: number | null | undefined, preset?: string | null | undefined, mode?: ResizeMode | null | undefined, focusX?: number | null | undefined, focusY?: number | null | undefined, force?: boolean | undefined, emptyOnFailure?: boolean | undefined, signal?: AbortSignal): Promise<FileResponse> {
        let url_ = this.baseUrl + "/api/apps/{appId}/media/{fileName}?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (fileName === undefined || fileName === null)
            throw new Error("The parameter 'fileName' must be defined.");
        url_ = url_.replace("{fileName}", encodeURIComponent("" + fileName));
        if (cache === null)
            throw new Error("The parameter 'cache' cannot be null.");
        else if (cache !== undefined)
            url_ += "cache=" + encodeURIComponent("" + cache) + "&";
        if (download === null)
            throw new Error("The parameter 'download' cannot be null.");
        else if (download !== undefined)
            url_ += "download=" + encodeURIComponent("" + download) + "&";
        if (bg !== undefined && bg !== null)
            url_ += "bg=" + encodeURIComponent("" + bg) + "&";
        if (width !== undefined && width !== null)
            url_ += "width=" + encodeURIComponent("" + width) + "&";
        if (height !== undefined && height !== null)
            url_ += "height=" + encodeURIComponent("" + height) + "&";
        if (quality !== undefined && quality !== null)
            url_ += "quality=" + encodeURIComponent("" + quality) + "&";
        if (preset !== undefined && preset !== null)
            url_ += "preset=" + encodeURIComponent("" + preset) + "&";
        if (mode !== undefined && mode !== null)
            url_ += "mode=" + encodeURIComponent("" + mode) + "&";
        if (focusX !== undefined && focusX !== null)
            url_ += "focusX=" + encodeURIComponent("" + focusX) + "&";
        if (focusY !== undefined && focusY !== null)
            url_ += "focusY=" + encodeURIComponent("" + focusY) + "&";
        if (force === null)
            throw new Error("The parameter 'force' cannot be null.");
        else if (force !== undefined)
            url_ += "force=" + encodeURIComponent("" + force) + "&";
        if (emptyOnFailure === null)
            throw new Error("The parameter 'emptyOnFailure' cannot be null.");
        else if (emptyOnFailure !== undefined)
            url_ += "emptyOnFailure=" + encodeURIComponent("" + emptyOnFailure) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDownload(_response);
        });
    }

    protected processDownload(response: Response): Promise<FileResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            let fileNameMatch = contentDisposition ? /filename\*=(?:(\\?['"])(.*?)\1|(?:[^\s]+'.*?')?([^;\n]*))/g.exec(contentDisposition) : undefined;
            let fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[3] || fileNameMatch[2] : undefined;
            if (fileName) {
                fileName = decodeURIComponent(fileName);
            } else {
                fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
                fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            }
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Media or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse>(null as any);
    }

    /**
     * Delete a media.
     * @param appId The app id where the media belongs to.
     * @param fileName The file name of the media.
     * @return Media deleted.
     */
    delete(appId: string, fileName: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/media/{fileName}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (fileName === undefined || fileName === null)
            throw new Error("The parameter 'fileName' must be defined.");
        url_ = url_.replace("{fileName}", encodeURIComponent("" + fileName));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDelete(_response);
        });
    }

    protected processDelete(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Download a media object.
     * @param appId The app id where the media belongs to.
     * @param fileName The name of the media to download.
     * @param cache (optional) The cache duration.
     * @param download (optional) Set it to 1 to create a download response.
     * @param bg (optional) Optional background color.
     * @param width (optional) The target width when an image.
     * @param height (optional) The target height when an image.
     * @param quality (optional) The target quality when an image.
     * @param preset (optional) A preset dimension.
     * @param mode (optional) The resize mode.
     * @param focusX (optional) The x position of the focues point.
     * @param focusY (optional) The y position of the focues point.
     * @param force (optional) True to resize it and clear the cache.
     * @param emptyOnFailure (optional) True, to return an empty image on failure.
     * @return Media returned.
     */
    download2(appId: string, fileName: string, cache?: number | undefined, download?: number | undefined, bg?: string | null | undefined, width?: number | null | undefined, height?: number | null | undefined, quality?: number | null | undefined, preset?: string | null | undefined, mode?: ResizeMode | null | undefined, focusX?: number | null | undefined, focusY?: number | null | undefined, force?: boolean | undefined, emptyOnFailure?: boolean | undefined, signal?: AbortSignal): Promise<FileResponse> {
        let url_ = this.baseUrl + "/api/asset/{appId}/{fileName}?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (fileName === undefined || fileName === null)
            throw new Error("The parameter 'fileName' must be defined.");
        url_ = url_.replace("{fileName}", encodeURIComponent("" + fileName));
        if (cache === null)
            throw new Error("The parameter 'cache' cannot be null.");
        else if (cache !== undefined)
            url_ += "cache=" + encodeURIComponent("" + cache) + "&";
        if (download === null)
            throw new Error("The parameter 'download' cannot be null.");
        else if (download !== undefined)
            url_ += "download=" + encodeURIComponent("" + download) + "&";
        if (bg !== undefined && bg !== null)
            url_ += "bg=" + encodeURIComponent("" + bg) + "&";
        if (width !== undefined && width !== null)
            url_ += "width=" + encodeURIComponent("" + width) + "&";
        if (height !== undefined && height !== null)
            url_ += "height=" + encodeURIComponent("" + height) + "&";
        if (quality !== undefined && quality !== null)
            url_ += "quality=" + encodeURIComponent("" + quality) + "&";
        if (preset !== undefined && preset !== null)
            url_ += "preset=" + encodeURIComponent("" + preset) + "&";
        if (mode !== undefined && mode !== null)
            url_ += "mode=" + encodeURIComponent("" + mode) + "&";
        if (focusX !== undefined && focusX !== null)
            url_ += "focusX=" + encodeURIComponent("" + focusX) + "&";
        if (focusY !== undefined && focusY !== null)
            url_ += "focusY=" + encodeURIComponent("" + focusY) + "&";
        if (force === null)
            throw new Error("The parameter 'force' cannot be null.");
        else if (force !== undefined)
            url_ += "force=" + encodeURIComponent("" + force) + "&";
        if (emptyOnFailure === null)
            throw new Error("The parameter 'emptyOnFailure' cannot be null.");
        else if (emptyOnFailure !== undefined)
            url_ += "emptyOnFailure=" + encodeURIComponent("" + emptyOnFailure) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDownload2(_response);
        });
    }

    protected processDownload2(response: Response): Promise<FileResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            let fileNameMatch = contentDisposition ? /filename\*=(?:(\\?['"])(.*?)\1|(?:[^\s]+'.*?')?([^;\n]*))/g.exec(contentDisposition) : undefined;
            let fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[3] || fileNameMatch[2] : undefined;
            if (fileName) {
                fileName = decodeURIComponent(fileName);
            } else {
                fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
                fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            }
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Media or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse>(null as any);
    }

    /**
     * Download a media object.
     * @param appId The app id where the media belongs to.
     * @param fileName The name of the media to download.
     * @param cache (optional) The cache duration.
     * @param download (optional) Set it to 1 to create a download response.
     * @param bg (optional) Optional background color.
     * @param width (optional) The target width when an image.
     * @param height (optional) The target height when an image.
     * @param quality (optional) The target quality when an image.
     * @param preset (optional) A preset dimension.
     * @param mode (optional) The resize mode.
     * @param focusX (optional) The x position of the focues point.
     * @param focusY (optional) The y position of the focues point.
     * @param force (optional) True to resize it and clear the cache.
     * @param emptyOnFailure (optional) True, to return an empty image on failure.
     * @return Media returned.
     */
    download3(appId: string, fileName: string, cache?: number | undefined, download?: number | undefined, bg?: string | null | undefined, width?: number | null | undefined, height?: number | null | undefined, quality?: number | null | undefined, preset?: string | null | undefined, mode?: ResizeMode | null | undefined, focusX?: number | null | undefined, focusY?: number | null | undefined, force?: boolean | undefined, emptyOnFailure?: boolean | undefined, signal?: AbortSignal): Promise<FileResponse> {
        let url_ = this.baseUrl + "/api/assets/{appId}/{fileName}?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (fileName === undefined || fileName === null)
            throw new Error("The parameter 'fileName' must be defined.");
        url_ = url_.replace("{fileName}", encodeURIComponent("" + fileName));
        if (cache === null)
            throw new Error("The parameter 'cache' cannot be null.");
        else if (cache !== undefined)
            url_ += "cache=" + encodeURIComponent("" + cache) + "&";
        if (download === null)
            throw new Error("The parameter 'download' cannot be null.");
        else if (download !== undefined)
            url_ += "download=" + encodeURIComponent("" + download) + "&";
        if (bg !== undefined && bg !== null)
            url_ += "bg=" + encodeURIComponent("" + bg) + "&";
        if (width !== undefined && width !== null)
            url_ += "width=" + encodeURIComponent("" + width) + "&";
        if (height !== undefined && height !== null)
            url_ += "height=" + encodeURIComponent("" + height) + "&";
        if (quality !== undefined && quality !== null)
            url_ += "quality=" + encodeURIComponent("" + quality) + "&";
        if (preset !== undefined && preset !== null)
            url_ += "preset=" + encodeURIComponent("" + preset) + "&";
        if (mode !== undefined && mode !== null)
            url_ += "mode=" + encodeURIComponent("" + mode) + "&";
        if (focusX !== undefined && focusX !== null)
            url_ += "focusX=" + encodeURIComponent("" + focusX) + "&";
        if (focusY !== undefined && focusY !== null)
            url_ += "focusY=" + encodeURIComponent("" + focusY) + "&";
        if (force === null)
            throw new Error("The parameter 'force' cannot be null.");
        else if (force !== undefined)
            url_ += "force=" + encodeURIComponent("" + force) + "&";
        if (emptyOnFailure === null)
            throw new Error("The parameter 'emptyOnFailure' cannot be null.");
        else if (emptyOnFailure !== undefined)
            url_ += "emptyOnFailure=" + encodeURIComponent("" + emptyOnFailure) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDownload3(_response);
        });
    }

    protected processDownload3(response: Response): Promise<FileResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            let fileNameMatch = contentDisposition ? /filename\*=(?:(\\?['"])(.*?)\1|(?:[^\s]+'.*?')?([^;\n]*))/g.exec(contentDisposition) : undefined;
            let fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[3] || fileNameMatch[2] : undefined;
            if (fileName) {
                fileName = decodeURIComponent(fileName);
            } else {
                fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
                fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            }
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Media or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse>(null as any);
    }

    /**
     * Download a media object.
     * @param url (optional) The app id where the media belongs to.
     * @param cache (optional) The cache duration.
     * @param download (optional) Set it to 1 to create a download response.
     * @param bg (optional) Optional background color.
     * @param width (optional) The target width when an image.
     * @param height (optional) The target height when an image.
     * @param quality (optional) The target quality when an image.
     * @param preset (optional) A preset dimension.
     * @param mode (optional) The resize mode.
     * @param focusX (optional) The x position of the focues point.
     * @param focusY (optional) The y position of the focues point.
     * @param force (optional) True to resize it and clear the cache.
     * @param emptyOnFailure (optional) True, to return an empty image on failure.
     * @return Media returned.
     */
    proxyImage(url?: string | undefined, cache?: number | undefined, download?: number | undefined, bg?: string | null | undefined, width?: number | null | undefined, height?: number | null | undefined, quality?: number | null | undefined, preset?: string | null | undefined, mode?: ResizeMode | null | undefined, focusX?: number | null | undefined, focusY?: number | null | undefined, force?: boolean | undefined, emptyOnFailure?: boolean | undefined, signal?: AbortSignal): Promise<FileResponse> {
        let url_ = this.baseUrl + "/api/assets/proxy?";
        if (url === null)
            throw new Error("The parameter 'url' cannot be null.");
        else if (url !== undefined)
            url_ += "url=" + encodeURIComponent("" + url) + "&";
        if (cache === null)
            throw new Error("The parameter 'cache' cannot be null.");
        else if (cache !== undefined)
            url_ += "cache=" + encodeURIComponent("" + cache) + "&";
        if (download === null)
            throw new Error("The parameter 'download' cannot be null.");
        else if (download !== undefined)
            url_ += "download=" + encodeURIComponent("" + download) + "&";
        if (bg !== undefined && bg !== null)
            url_ += "bg=" + encodeURIComponent("" + bg) + "&";
        if (width !== undefined && width !== null)
            url_ += "width=" + encodeURIComponent("" + width) + "&";
        if (height !== undefined && height !== null)
            url_ += "height=" + encodeURIComponent("" + height) + "&";
        if (quality !== undefined && quality !== null)
            url_ += "quality=" + encodeURIComponent("" + quality) + "&";
        if (preset !== undefined && preset !== null)
            url_ += "preset=" + encodeURIComponent("" + preset) + "&";
        if (mode !== undefined && mode !== null)
            url_ += "mode=" + encodeURIComponent("" + mode) + "&";
        if (focusX !== undefined && focusX !== null)
            url_ += "focusX=" + encodeURIComponent("" + focusX) + "&";
        if (focusY !== undefined && focusY !== null)
            url_ += "focusY=" + encodeURIComponent("" + focusY) + "&";
        if (force === null)
            throw new Error("The parameter 'force' cannot be null.");
        else if (force !== undefined)
            url_ += "force=" + encodeURIComponent("" + force) + "&";
        if (emptyOnFailure === null)
            throw new Error("The parameter 'emptyOnFailure' cannot be null.");
        else if (emptyOnFailure !== undefined)
            url_ += "emptyOnFailure=" + encodeURIComponent("" + emptyOnFailure) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processProxyImage(_response);
        });
    }

    protected processProxyImage(response: Response): Promise<FileResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            let fileNameMatch = contentDisposition ? /filename\*=(?:(\\?['"])(.*?)\1|(?:[^\s]+'.*?')?([^;\n]*))/g.exec(contentDisposition) : undefined;
            let fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[3] || fileNameMatch[2] : undefined;
            if (fileName) {
                fileName = decodeURIComponent(fileName);
            } else {
                fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
                fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            }
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Media or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse>(null as any);
    }
}

export class LogsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query log entries.
     * @param appId The app where the log entries belongs to.
     * @param systems (optional) The systems.
     * @param userId (optional) The user id.
     * @param eventCode (optional) The event code.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Log entries returned.
     */
    getLogs(appId: string, systems?: string[] | null | undefined, userId?: string | null | undefined, eventCode?: number | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfLogEntryDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/logs?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (systems !== undefined && systems !== null)
            systems && systems.forEach(item => { url_ += "Systems=" + encodeURIComponent("" + item) + "&"; });
        if (userId !== undefined && userId !== null)
            url_ += "UserId=" + encodeURIComponent("" + userId) + "&";
        if (eventCode === null)
            throw new Error("The parameter 'eventCode' cannot be null.");
        else if (eventCode !== undefined)
            url_ += "EventCode=" + encodeURIComponent("" + eventCode) + "&";
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetLogs(_response);
        });
    }

    protected processGetLogs(response: Response): Promise<ListResponseDtoOfLogEntryDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfLogEntryDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfLogEntryDto>(null as any);
    }
}

export class EventsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Query events.
     * @param appId The app where the events belongs to.
     * @param channels (optional) The active channels.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Events returned.
     */
    getEvents(appId: string, channels?: string[] | null | undefined, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfEventDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/events?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (channels !== undefined && channels !== null)
            channels && channels.forEach(item => { url_ += "Channels=" + encodeURIComponent("" + item) + "&"; });
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetEvents(_response);
        });
    }

    protected processGetEvents(response: Response): Promise<ListResponseDtoOfEventDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfEventDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfEventDto>(null as any);
    }

    /**
     * Publish events.
     * @param appId The app where the events belongs to.
     * @param request The publish request.
     * @return Events created.
     */
    postEvents(appId: string, request: PublishManyDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/events";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostEvents(_response);
        });
    }

    protected processPostEvents(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Cancels a scheduled event.
     * @param appId The app where the events belongs to.
     * @param request The cancel request.
     */
    cancelEvent(appId: string, request: CancelEventDto, signal?: AbortSignal): Promise<CancelResponseDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/events";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "DELETE",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processCancelEvent(_response);
        });
    }

    protected processCancelEvent(response: Response): Promise<CancelResponseDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as CancelResponseDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CancelResponseDto>(null as any);
    }

    /**
     * Publish an event for the current user.
     * @param request The publish request.
     * @return Event created.
     */
    postMyEvents(request: PublishDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/me/events";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostMyEvents(_response);
        });
    }

    protected processPostMyEvents(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class DiagnosticsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Creates a dump and writes it into storage..
     * @return Dump created successful.
     */
    getDump(signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/diagnostics/dump";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetDump(_response);
        });
    }

    protected processGetDump(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 501) {
            return response.text().then((_responseText) => {
            let result501: any = null;
            result501 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Not configured.", status, _responseText, _headers, result501);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Creates a gc dump and writes it into storage.
     * @return Dump created successful.
     */
    getGCDump(signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/diagnostics/gcdump";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetGCDump(_response);
        });
    }

    protected processGetGCDump(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 501) {
            return response.text().then((_responseText) => {
            let result501: any = null;
            result501 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Not configured.", status, _responseText, _headers, result501);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export class ConfigsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Get all supported timezones.
     * @return Timezones returned.
     */
    getTimezones(signal?: AbortSignal): Promise<string[]> {
        let url_ = this.baseUrl + "/api/timezones";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTimezones(_response);
        });
    }

    protected processGetTimezones(response: Response): Promise<string[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as string[];
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string[]>(null as any);
    }

    /**
     * Get all supported languages.
     * @return Languages returned.
     */
    getLanguages(signal?: AbortSignal): Promise<string[]> {
        let url_ = this.baseUrl + "/api/languages";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetLanguages(_response);
        });
    }

    protected processGetLanguages(response: Response): Promise<string[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as string[];
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string[]>(null as any);
    }
}

export class EmailTemplatesClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Gets the mjml schema.
     */
    getSchema(signal?: AbortSignal): Promise<MjmlSchema> {
        let url_ = this.baseUrl + "/api/mjml/schema";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetSchema(_response);
        });
    }

    protected processGetSchema(response: Response): Promise<MjmlSchema> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as MjmlSchema;
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<MjmlSchema>(null as any);
    }

    /**
     * Get the HTML preview for a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param id The template ID.
     * @return Channel template preview returned.
     */
    getPreview(appId: string, id: string, signal?: AbortSignal): Promise<FileResponse> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{id}/preview";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetPreview(_response);
        });
    }

    protected processGetPreview(response: Response): Promise<FileResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            let fileNameMatch = contentDisposition ? /filename\*=(?:(\\?['"])(.*?)\1|(?:[^\s]+'.*?')?([^;\n]*))/g.exec(contentDisposition) : undefined;
            let fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[3] || fileNameMatch[2] : undefined;
            if (fileName) {
                fileName = decodeURIComponent(fileName);
            } else {
                fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
                fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            }
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse>(null as any);
    }

    /**
     * Render a preview for a email template.
     * @param appId The ID of the app where the templates belong to.
     * @param request The template to render.
     * @return Template rendered.
     */
    postPreview(appId: string, request: EmailPreviewRequestDto, signal?: AbortSignal): Promise<EmailPreviewDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/render";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostPreview(_response);
        });
    }

    protected processPostPreview(response: Response): Promise<EmailPreviewDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as EmailPreviewDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<EmailPreviewDto>(null as any);
    }

    /**
     * Get the channel templates.
     * @param appId The ID of the app where the templates belong to.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Channel templates returned.
     */
    getTemplates(appId: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfChannelTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplates(_response);
        });
    }

    protected processGetTemplates(response: Response): Promise<ListResponseDtoOfChannelTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfChannelTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfChannelTemplateDto>(null as any);
    }

    /**
     * Create a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param request The request object.
     * @return Channel template created.
     */
    postTemplate(appId: string, request: CreateChannelTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplate(_response);
        });
    }

    protected processPostTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfEmailTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfEmailTemplateDto>(null as any);
    }

    /**
     * Get the template properties.
     * @param appId The id of the app where the templates belong to.
     * @return Channel templates properties returned.
     */
    getProperties(appId: string, signal?: AbortSignal): Promise<ListResponseDtoOfTemplatePropertyDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/properties";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetProperties(_response);
        });
    }

    protected processGetProperties(response: Response): Promise<ListResponseDtoOfTemplatePropertyDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfTemplatePropertyDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfTemplatePropertyDto>(null as any);
    }

    /**
     * Get the channel template by id.
     * @param appId The ID of the app where the templates belong to.
     * @param id The template ID.
     * @return Channel templates returned.
     */
    getTemplate(appId: string, id: string, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{id}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplate(_response);
        });
    }

    protected processGetTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfEmailTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfEmailTemplateDto>(null as any);
    }

    /**
     * Create an app template language.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param request The request object.
     * @return Channel template created.
     */
    postTemplateLanguage(appId: string, code: string, request: CreateChannelTemplateLanguageDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplateLanguage(_response);
        });
    }

    protected processPostTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfEmailTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfEmailTemplateDto>(null as any);
    }

    /**
     * Update an app template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param request The request object.
     */
    putTemplate(appId: string, code: string, request: UpdateChannelTemplateDtoOfEmailTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTemplate(_response);
        });
    }

    protected processPutTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfEmailTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfEmailTemplateDto>(null as any);
    }

    /**
     * Delete a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template ID.
     * @return Channel template deleted.
     */
    deleteTemplate(appId: string, code: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplate(_response);
        });
    }

    protected processDeleteTemplate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Update a channel template language.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param language The language.
     * @param request The request object.
     */
    putTemplateLanguage(appId: string, code: string, language: string, request: EmailTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{code}/{language}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        if (language === undefined || language === null)
            throw new Error("The parameter 'language' must be defined.");
        url_ = url_.replace("{language}", encodeURIComponent("" + language));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTemplateLanguage(_response);
        });
    }

    protected processPutTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfEmailTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfEmailTemplateDto>(null as any);
    }

    /**
     * Delete a language channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template ID.
     * @param language The language.
     */
    deleteTemplateLanguage(appId: string, code: string, language: string, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/email-templates/{code}/{language}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        if (language === undefined || language === null)
            throw new Error("The parameter 'language' must be defined.");
        url_ = url_.replace("{language}", encodeURIComponent("" + language));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplateLanguage(_response);
        });
    }

    protected processDeleteTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfEmailTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfEmailTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfEmailTemplateDto>(null as any);
    }
}

export class MessagingTemplatesClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Get the channel templates.
     * @param appId The ID of the app where the templates belong to.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Channel templates returned.
     */
    getTemplates(appId: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfChannelTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplates(_response);
        });
    }

    protected processGetTemplates(response: Response): Promise<ListResponseDtoOfChannelTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfChannelTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfChannelTemplateDto>(null as any);
    }

    /**
     * Create a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param request The request object.
     * @return Channel template created.
     */
    postTemplate(appId: string, request: CreateChannelTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplate(_response);
        });
    }

    protected processPostTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfMessagingTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfMessagingTemplateDto>(null as any);
    }

    /**
     * Get the template properties.
     * @param appId The id of the app where the templates belong to.
     * @return Channel templates properties returned.
     */
    getProperties(appId: string, signal?: AbortSignal): Promise<ListResponseDtoOfTemplatePropertyDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/properties";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetProperties(_response);
        });
    }

    protected processGetProperties(response: Response): Promise<ListResponseDtoOfTemplatePropertyDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfTemplatePropertyDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfTemplatePropertyDto>(null as any);
    }

    /**
     * Get the channel template by id.
     * @param appId The ID of the app where the templates belong to.
     * @param id The template ID.
     * @return Channel templates returned.
     */
    getTemplate(appId: string, id: string, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/{id}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplate(_response);
        });
    }

    protected processGetTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfMessagingTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfMessagingTemplateDto>(null as any);
    }

    /**
     * Create an app template language.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param request The request object.
     * @return Channel template created.
     */
    postTemplateLanguage(appId: string, code: string, request: CreateChannelTemplateLanguageDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplateLanguage(_response);
        });
    }

    protected processPostTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfMessagingTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfMessagingTemplateDto>(null as any);
    }

    /**
     * Update an app template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param request The request object.
     */
    putTemplate(appId: string, code: string, request: UpdateChannelTemplateDtoOfMessagingTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTemplate(_response);
        });
    }

    protected processPutTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfMessagingTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfMessagingTemplateDto>(null as any);
    }

    /**
     * Delete a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template ID.
     * @return Channel template deleted.
     */
    deleteTemplate(appId: string, code: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplate(_response);
        });
    }

    protected processDeleteTemplate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Update a channel template language.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param language The language.
     * @param request The request object.
     */
    putTemplateLanguage(appId: string, code: string, language: string, request: MessagingTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/{code}/{language}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        if (language === undefined || language === null)
            throw new Error("The parameter 'language' must be defined.");
        url_ = url_.replace("{language}", encodeURIComponent("" + language));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTemplateLanguage(_response);
        });
    }

    protected processPutTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfMessagingTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfMessagingTemplateDto>(null as any);
    }

    /**
     * Delete a language channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template ID.
     * @param language The language.
     */
    deleteTemplateLanguage(appId: string, code: string, language: string, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/messaging-templates/{code}/{language}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        if (language === undefined || language === null)
            throw new Error("The parameter 'language' must be defined.");
        url_ = url_.replace("{language}", encodeURIComponent("" + language));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplateLanguage(_response);
        });
    }

    protected processDeleteTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfMessagingTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfMessagingTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfMessagingTemplateDto>(null as any);
    }
}

export class SmsTemplatesClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Get the channel templates.
     * @param appId The ID of the app where the templates belong to.
     * @param query (optional) The optional query to search for items.
     * @param take (optional) The number of items to return.
     * @param skip (optional) The number of items to skip.
     * @return Channel templates returned.
     */
    getTemplates(appId: string, query?: string | null | undefined, take?: number | undefined, skip?: number | undefined, signal?: AbortSignal): Promise<ListResponseDtoOfChannelTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates?";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (query !== undefined && query !== null)
            url_ += "query=" + encodeURIComponent("" + query) + "&";
        if (take === null)
            throw new Error("The parameter 'take' cannot be null.");
        else if (take !== undefined)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (skip === null)
            throw new Error("The parameter 'skip' cannot be null.");
        else if (skip !== undefined)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplates(_response);
        });
    }

    protected processGetTemplates(response: Response): Promise<ListResponseDtoOfChannelTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfChannelTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfChannelTemplateDto>(null as any);
    }

    /**
     * Create a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param request The request object.
     * @return Channel template created.
     */
    postTemplate(appId: string, request: CreateChannelTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplate(_response);
        });
    }

    protected processPostTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfSmsTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfSmsTemplateDto>(null as any);
    }

    /**
     * Get the template properties.
     * @param appId The id of the app where the templates belong to.
     * @return Channel templates properties returned.
     */
    getProperties(appId: string, signal?: AbortSignal): Promise<ListResponseDtoOfTemplatePropertyDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/properties";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetProperties(_response);
        });
    }

    protected processGetProperties(response: Response): Promise<ListResponseDtoOfTemplatePropertyDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ListResponseDtoOfTemplatePropertyDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ListResponseDtoOfTemplatePropertyDto>(null as any);
    }

    /**
     * Get the channel template by id.
     * @param appId The ID of the app where the templates belong to.
     * @param id The template ID.
     * @return Channel templates returned.
     */
    getTemplate(appId: string, id: string, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/{id}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetTemplate(_response);
        });
    }

    protected processGetTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfSmsTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfSmsTemplateDto>(null as any);
    }

    /**
     * Create an app template language.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param request The request object.
     * @return Channel template created.
     */
    postTemplateLanguage(appId: string, code: string, request: CreateChannelTemplateLanguageDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostTemplateLanguage(_response);
        });
    }

    protected processPostTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfSmsTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfSmsTemplateDto>(null as any);
    }

    /**
     * Update an app template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param request The request object.
     */
    putTemplate(appId: string, code: string, request: UpdateChannelTemplateDtoOfSmsTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTemplate(_response);
        });
    }

    protected processPutTemplate(response: Response): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfSmsTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfSmsTemplateDto>(null as any);
    }

    /**
     * Delete a channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template ID.
     * @return Channel template deleted.
     */
    deleteTemplate(appId: string, code: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/{code}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplate(_response);
        });
    }

    protected processDeleteTemplate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Update a channel template language.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template code.
     * @param language The language.
     * @param request The request object.
     */
    putTemplateLanguage(appId: string, code: string, language: string, request: SmsTemplateDto, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/{code}/{language}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        if (language === undefined || language === null)
            throw new Error("The parameter 'language' must be defined.");
        url_ = url_.replace("{language}", encodeURIComponent("" + language));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutTemplateLanguage(_response);
        });
    }

    protected processPutTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfSmsTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfSmsTemplateDto>(null as any);
    }

    /**
     * Delete a language channel template.
     * @param appId The ID of the app where the templates belong to.
     * @param code The template ID.
     * @param language The language.
     */
    deleteTemplateLanguage(appId: string, code: string, language: string, signal?: AbortSignal): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/sms-templates/{code}/{language}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (code === undefined || code === null)
            throw new Error("The parameter 'code' must be defined.");
        url_ = url_.replace("{code}", encodeURIComponent("" + code));
        if (language === undefined || language === null)
            throw new Error("The parameter 'language' must be defined.");
        url_ = url_.replace("{language}", encodeURIComponent("" + language));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteTemplateLanguage(_response);
        });
    }

    protected processDeleteTemplateLanguage(response: Response): Promise<ChannelTemplateDetailsDtoOfSmsTemplateDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ChannelTemplateDetailsDtoOfSmsTemplateDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("Channel template or app not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ChannelTemplateDetailsDtoOfSmsTemplateDto>(null as any);
    }
}

export class AppsClient {
    private http: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> };
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, http?: { fetch(url: RequestInfo, init?: RequestInit): Promise<Response> }) {
        this.http = http ? http : window as any;
        this.baseUrl = baseUrl ?? "https://localhost:5002";
    }

    /**
     * Get the user apps.
     * @return Apps returned.
     */
    getApps(signal?: AbortSignal): Promise<AppDto[]> {
        let url_ = this.baseUrl + "/api/apps";
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetApps(_response);
        });
    }

    protected processGetApps(response: Response): Promise<AppDto[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AppDto[];
            return result200;
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDto[]>(null as any);
    }

    /**
     * Create an app.
     * @param request The request object.
     * @return App created.
     */
    postApp(request: UpsertAppDto, signal?: AbortSignal): Promise<AppDto> {
        let url_ = this.baseUrl + "/api/apps";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostApp(_response);
        });
    }

    protected processPostApp(response: Response): Promise<AppDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AppDto;
            return result200;
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDto>(null as any);
    }

    /**
     * Get app by ID.
     * @param appId The ID of the app.
     * @return App returned.
     */
    getApp(appId: string, signal?: AbortSignal): Promise<AppDetailsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetApp(_response);
        });
    }

    protected processGetApp(response: Response): Promise<AppDetailsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AppDetailsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDetailsDto>(null as any);
    }

    /**
     * Update an app.
     * @param appId The app id to update.
     * @param request The request object.
     * @return App updated.
     */
    putApp(appId: string, request: UpsertAppDto, signal?: AbortSignal): Promise<AppDetailsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutApp(_response);
        });
    }

    protected processPutApp(response: Response): Promise<AppDetailsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AppDetailsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDetailsDto>(null as any);
    }

    /**
     * Get app auth settings by ID.
     * @param appId The ID of the app.
     * @return App auth settings returned.
     */
    getAuthScheme(appId: string, signal?: AbortSignal): Promise<AuthSchemeValueDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/auth";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetAuthScheme(_response);
        });
    }

    protected processGetAuthScheme(response: Response): Promise<AuthSchemeValueDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AuthSchemeValueDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AuthSchemeValueDto>(null as any);
    }

    /**
     * Updates the auth settings of the app.
     * @param appId The ID of the app.
     * @param request The request object.
     * @return App auth settings returned.
     */
    upsertAuthScheme(appId: string, request: AuthSchemeValueDto, signal?: AbortSignal): Promise<AuthSchemeValueDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/auth";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processUpsertAuthScheme(_response);
        });
    }

    protected processUpsertAuthScheme(response: Response): Promise<AuthSchemeValueDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AuthSchemeValueDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AuthSchemeValueDto>(null as any);
    }

    /**
     * Add an app contributor.
     * @param appId The ID of the app.
     * @param request The request object.
     * @return Apps returned.
     */
    postContributor(appId: string, request: AddContributorDto, signal?: AbortSignal): Promise<AppDetailsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/contributors";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostContributor(_response);
        });
    }

    protected processPostContributor(response: Response): Promise<AppDetailsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AppDetailsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDetailsDto>(null as any);
    }

    /**
     * Delete an app contributor.
     * @param appId The ID of the app.
     * @param contributorId The contributor to remove.
     * @return Apps returned.
     */
    deleteContributor(appId: string, contributorId: string, signal?: AbortSignal): Promise<AppDetailsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/contributors/{contributorId}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (contributorId === undefined || contributorId === null)
            throw new Error("The parameter 'contributorId' must be defined.");
        url_ = url_.replace("{contributorId}", encodeURIComponent("" + contributorId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "POST",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteContributor(_response);
        });
    }

    protected processDeleteContributor(response: Response): Promise<AppDetailsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as AppDetailsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDetailsDto>(null as any);
    }

    /**
     * Get the app integrations.
     * @param appId The ID of the app where the integrations belong to.
     * @return App email templates returned.
     */
    getIntegrations(appId: string, signal?: AbortSignal): Promise<ConfiguredIntegrationsDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/integrations";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processGetIntegrations(_response);
        });
    }

    protected processGetIntegrations(response: Response): Promise<ConfiguredIntegrationsDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ConfiguredIntegrationsDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ConfiguredIntegrationsDto>(null as any);
    }

    /**
     * Create an app integrations.
     * @param appId The ID of the app where the integration belong to.
     * @param request The request object.
     * @return App integration created.
     */
    postIntegration(appId: string, request: CreateIntegrationDto, signal?: AbortSignal): Promise<IntegrationCreatedDto> {
        let url_ = this.baseUrl + "/api/apps/{appId}/integration";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPostIntegration(_response);
        });
    }

    protected processPostIntegration(response: Response): Promise<IntegrationCreatedDto> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            result200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as IntegrationCreatedDto;
            return result200;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<IntegrationCreatedDto>(null as any);
    }

    /**
     * Update an app integration.
     * @param appId The ID of the app where the integration belong to.
     * @param id The ID of the integration.
     * @param request The request object.
     * @return App integration updated.
     */
    putIntegration(appId: string, id: string, request: UpdateIntegrationDto, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/integrations/{id}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_: RequestInit = {
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processPutIntegration(_response);
        });
    }

    protected processPutIntegration(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }

    /**
     * Delete an app integration.
     * @param appId The ID of the app where the email templates belong to.
     * @param id The ID of the integration.
     * @return App integration deleted.
     */
    deleteIntegration(appId: string, id: string, signal?: AbortSignal): Promise<void> {
        let url_ = this.baseUrl + "/api/apps/{appId}/integrations/{id}";
        if (appId === undefined || appId === null)
            throw new Error("The parameter 'appId' must be defined.");
        url_ = url_.replace("{appId}", encodeURIComponent("" + appId));
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_: RequestInit = {
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.http.fetch(url_, options_).then((_response: Response) => {
            return this.processDeleteIntegration(_response);
        });
    }

    protected processDeleteIntegration(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 204) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status === 404) {
            return response.text().then((_responseText) => {
            return throwException("App not found.", status, _responseText, _headers);
            });
        } else if (status === 400) {
            return response.text().then((_responseText) => {
            let result400: any = null;
            result400 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Validation error.", status, _responseText, _headers, result400);
            });
        } else if (status === 500) {
            return response.text().then((_responseText) => {
            let result500: any = null;
            result500 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver) as ErrorDto;
            return throwException("Operation failed.", status, _responseText, _headers, result500);
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(null as any);
    }
}

export interface ProfileDto {
    /** The full name of the user. */
    fullName: string;
    /** The email of the user. */
    emailAddress: string;
    /** The phone number. */
    phoneNumber?: string | undefined;
    /** The allowed Topics. */
    allowedTopics: string[];
    /** The preferred language of the user. */
    preferredLanguage?: string | undefined;
    /** The timezone of the user. */
    preferredTimezone?: string | undefined;
    /** The supported languages. */
    supportedLanguages: string[];
    /** The supported timezones. */
    supportedTimezones: string[];
    /** Notification settings per channel. */
    settings: { [key: string]: ChannelSettingDto; };
}

export interface ChannelSettingDto {
    /** Defines if to send a notification through this channel. */
    send: ChannelSend;
    /** Defines when to send a notification through this channel. */
    condition: ChannelCondition;
    /** Defines the requirements for this channel. */
    required: ChannelRequired;
    /** The delay in seconds. */
    delayInSeconds?: number | undefined;
    /** The template if the channel supports it. */
    template?: string | undefined;
    /** The grouping key to combine notifications per channel. */
    groupKey?: string | undefined;
    /** Additional properties. */
    properties?: NotificationProperties | undefined;
}

export type ChannelSend = "Inherit" | "Send" | "NotSending" | "NotAllowed";

export type ChannelCondition = "Inherit" | "IfNotSeen" | "IfNotConfirmed" | "Always";

export type ChannelRequired = "Inherit" | "NotRequired" | "Required";

export interface NotificationProperties {

    [key: string]: string | any;
}

export interface ErrorDto {
    /** The error message. */
    message?: string | undefined;
    /** The error code. */
    errorCode?: string | undefined;
    /** The optional trace id. */
    traceId?: string | undefined;
    /** The error type, usually a link. */
    type?: string | undefined;
    /** Detailed error messages. */
    details?: string[] | undefined;
    /** Status code of the http response. */
    statusCode: number;
}

export interface AdminProfileDto {
    /** The token for the integrated app. */
    token?: string | undefined;
}

export interface UpdateProfileDto {
    /** The full name of the user. */
    fullName?: string | undefined;
    /** The email of the user. */
    emailAddress?: string | undefined;
    /** The phone number. */
    phoneNumber?: string | undefined;
    /** The preferred language of the user. */
    preferredLanguage?: string | undefined;
    /** The timezone of the user. */
    preferredTimezone?: string | undefined;
    /** Notification settings per channel. */
    settings?: { [key: string]: ChannelSettingDto; } | undefined;
}

export interface UserTopicDto {
    /** The path. */
    path: string;
    /** The name. */
    name: string;
    /** The optional description. */
    description?: string | undefined;
    /** True to show the topic automatically to new users, e.g. when he accepts push notifications. */
    showAutomatically: boolean;
    /** The channel options. */
    channels: { [key: string]: TopicChannel; };
}

export type TopicChannel = "NotAllowed" | "Allowed";

export interface ListResponseDtoOfSubscriptionDto {
    /** The items. */
    items: SubscriptionDto[];
    /** The total number of items. */
    total: number;
}

export interface SubscriptionDto {
    /** The topic to add. */
    topicPrefix: string;
    /** Notification settings per channel. */
    topicSettings: { [key: string]: ChannelSettingDto; };
    /** The scheduling settings. */
    scheduling?: SchedulingDto | undefined;
}

export interface SchedulingDto {
    /** The scheduling type. */
    type: SchedulingType;
    /** To schedule the event at the next day of the week. */
    nextWeekDay?: IsoDayOfWeek | undefined;
    /** The scheduling date. */
    date?: string | undefined;
    /** The scheduling time. */
    time: string;
    /** The delay relative to the server time. */
    delayInSeconds?: number | undefined;
}

export type SchedulingType = "UTC" | "UserTime";

/** Equates the days of the week with their numerical value according to ISO-8601. This corresponds with System.DayOfWeek except for Sunday, which is 7 in the ISO numbering and 0 in System.DayOfWeek. */
export type IsoDayOfWeek = "None" | "Monday" | "Tuesday" | "Wednesday" | "Thursday" | "Friday" | "Saturday" | "Sunday";

export interface SubscribeManyDto {
    /** A list of topics to create. */
    subscribe?: SubscribeDto[] | undefined;
    /** A list of topics to unsubscribe from. */
    unsubscribe?: string[] | undefined;
}

export interface SubscribeDto {
    /** The topic to add. */
    topicPrefix: string;
    /** Notification settings per channel. */
    topicSettings?: { [key: string]: ChannelSettingDto; } | undefined;
    /** The scheduling settings. */
    scheduling?: SchedulingDto | undefined;
    /** Indicates whether scheduling should be overriden. */
    hasScheduling?: boolean;
}

export interface ListResponseDtoOfUserDto {
    /** The items. */
    items: UserDto[];
    /** The total number of items. */
    total: number;
}

export interface UserDto {
    /** The ID of the user. */
    id: string;
    /** The unique api key for the user. */
    apiKey: string;
    /** The full name of the user. */
    fullName?: string | undefined;
    /** The email of the user. */
    emailAddress?: string | undefined;
    /** The phone number. */
    phoneNumber?: string | undefined;
    /** The preferred language of the user. */
    preferredLanguage?: string | undefined;
    /** The timezone of the user. */
    preferredTimezone?: string | undefined;
    /** The date time (ISO 8601) when the user has been created. */
    created: string;
    /** The date time (ISO 8601) when the user has been updated. */
    lastUpdate: string;
    /** The date time (ISO 8601) when the user has been received the last notification. */
    lastNotification?: string | undefined;
    /** True when only whitelisted topic are allowed. */
    requiresWhitelistedTopics: boolean;
    /** The user properties. */
    properties?: { [key: string]: string; } | undefined;
    /** The scheduling settings. */
    scheduling?: SchedulingDto | undefined;
    /** Notification settings per channel. */
    settings: { [key: string]: ChannelSettingDto; };
    /** The statistics counters. */
    counters: { [key: string]: number; };
    /** The mobile push tokens. */
    mobilePushTokens: MobilePushTokenDto[];
    /** The web push subscriptions. */
    webPushSubscriptions: WebPushSubscriptionDto[];
    /** The supported user properties. */
    userProperties?: UserPropertyDto[] | undefined;
}

export interface MobilePushTokenDto {
    /** The token. */
    token: string;
    /** The device type. */
    deviceType: MobileDeviceType;
    /** A unique identifier for the device. */
    deviceIdentifier?: string | undefined;
    /** The last time the device was woken up. */
    lastWakeup?: string | undefined;
}

export type MobileDeviceType = "Unknown" | "Android" | "iOS";

export interface WebPushSubscriptionDto {
    /** The endpoint. */
    endpoint: string;
}

export interface UserPropertyDto {
    /** The field name for the property. */
    name: string;
    /** The optional description. */
    editorDescription?: string | undefined;
    /** The optional label. */
    editorLabel?: string | undefined;
}

export interface UpsertUsersDto {
    /** The users to update. */
    requests: UpsertUserDto[];
}

export interface UpsertUserDto {
    /** The ID of the user. */
    id?: string | undefined;
    /** The full name of the user. */
    fullName?: string | undefined;
    /** The email of the user. */
    emailAddress?: string | undefined;
    /** The phone number. */
    phoneNumber?: string | undefined;
    /** The preferred language of the user. */
    preferredLanguage?: string | undefined;
    /** The timezone of the user. */
    preferredTimezone?: string | undefined;
    /** True when only whitelisted topic are allowed. */
    requiresWhitelistedTopics?: boolean | undefined;
    /** The user properties. */
    properties?: { [key: string]: string; } | undefined;
    /** Notification settings per channel. */
    settings?: { [key: string]: ChannelSettingDto; } | undefined;
    /** The scheduling settings. */
    scheduling?: SchedulingDto | undefined;
    /** Indicates whether scheduling should be overriden. */
    hasScheduling?: boolean;
}

export interface AddAllowedTopicDto {
    /** The topic to add. */
    prefix: string;
}

export interface ListResponseDtoOfTopicDto {
    /** The items. */
    items: TopicDto[];
    /** The total number of items. */
    total: number;
}

export interface TopicDto {
    /** The topic path. */
    path: string;
    /** The date time (ISO 8601) when the topic has been created. */
    created: string;
    /** The date time (ISO 8601) when the topic has been updated. */
    lastUpdate: string;
    /** True when the topic is explicit. */
    isExplicit: boolean;
    /** The name. */
    name?: LocalizedText | undefined;
    /** The description. */
    description?: LocalizedText | undefined;
    /** True to show the topic automatically to new users, e.g. when he accepts push notifications. */
    showAutomatically: boolean;
    /** The channel settings. */
    channels?: { [key: string]: TopicChannel; } | undefined;
    /** The statistics counters. */
    counters: { [key: string]: number; };
}

export interface LocalizedText {

    [key: string]: string | any;
}

export type TopicQueryScope = "All" | "Explicit" | "Implicit";

export interface UpsertTopicsDto {
    /** The topics to update. */
    requests: UpsertTopicDto[];
}

export interface UpsertTopicDto {
    /** The path of the topic. */
    path?: string;
    /** The name. */
    name?: LocalizedText | undefined;
    /** The description. */
    description?: LocalizedText | undefined;
    /** True to show the topic automatically to new users, e.g. when he accepts push notifications. */
    showAutomatically?: boolean | undefined;
    /** Settings per channel. */
    channels?: { [key: string]: TopicChannel; } | undefined;
}

export interface ListResponseDtoOfTemplateDto {
    /** The items. */
    items: TemplateDto[];
    /** The total number of items. */
    total: number;
}

export interface TemplateDto {
    /** The code of the template. */
    code: string;
    /** The date time (ISO 8601) when the template has been created. */
    created: string;
    /** The date time (ISO 8601) when the template has been updated. */
    lastUpdate: string;
    /** The formatting. */
    formatting: NotificationFormattingDto;
    /** Notification settings per channel. */
    settings: { [key: string]: ChannelSettingDto; };
}

export interface NotificationFormattingDto {
    /** The required subject with one entry per language. */
    subject: LocalizedText;
    /** The optional body with one entry per language. */
    body?: LocalizedText | undefined;
    /** The optional confirm link with one entry per language. */
    confirmLink?: LocalizedText | undefined;
    /** The optional confirm text with one entry per language. */
    confirmText?: LocalizedText | undefined;
    /** The optional small image with one entry per language. */
    imageSmall?: LocalizedText | undefined;
    /** The optional large image with one entry per language. */
    imageLarge?: LocalizedText | undefined;
    /** The optional link url with one entry per language. */
    linkUrl?: LocalizedText | undefined;
    /** The optional link name with one entry per language. */
    linkText?: LocalizedText | undefined;
    /** The confirmation mode. */
    confirmMode?: ConfirmMode | undefined;
}

export type ConfirmMode = "None" | "Explicit";

export interface UpsertTemplatesDto {
    /** The templates to update. */
    requests: UpsertTemplateDto[];
}

export interface UpsertTemplateDto {
    /** The code of the template. */
    code: string;
    /** The formatting. */
    formatting: NotificationFormattingDto;
    /** Notification settings per channel. */
    settings?: { [key: string]: ChannelSettingDto; } | undefined;
}

export interface ListResponseDtoOfSystemUserDto {
    /** The items. */
    items: SystemUserDto[];
    /** The total number of items. */
    total: number;
}

export interface SystemUserDto {
    /** The ID of the user. */
    id: string;
    /** The email of the user. Unique value. */
    email: string;
    /** Determines if the user is locked. */
    isLocked: boolean;
    /** Additional role for the user. */
    roles: string[];
    /** True if the user can be updated. */
    canUpdate: boolean;
}

export interface CreateSystemUserDto {
    /** The email of the user. Unique value. */
    email: string;
    /** The password of the user. */
    password?: string | undefined;
    /** Additional role for the user. */
    roles: string[];
}

export interface UpdateSystemUserDto {
    /** The email of the user. Unique value. */
    email: string;
    /** The password of the user. */
    password?: string | undefined;
    /** Additional role for the user. */
    roles?: string[] | undefined;
}

export interface InfoDto {
    /** The actual version. */
    version: string;
}

export interface ListResponseDtoOfUserNotificationDetailsDto {
    /** The items. */
    items: UserNotificationDetailsDto[];
    /** The total number of items. */
    total: number;
}

export interface UserNotificationBaseDto {
    /** The ID of the notification. */
    id: string;
    /** The subject of the notification in the language of the user. */
    subject: string;
    /** True when the notification is silent. */
    silent: boolean;
    /** The timestamp when the notification has been created. */
    created: string;
    /** The timestamp when the notification has been updated. */
    updated: string;
    /** The tracking token. */
    trackingToken?: string | undefined;
    /** The optional body text. */
    body?: string | undefined;
    /** The optional link to the small image. */
    imageSmall?: string | undefined;
    /** The optional link to the large image. */
    imageLarge?: string | undefined;
    /** The tracking url that needs to be invoked to mark the notification as seen. */
    trackSeenUrl?: string | undefined;
    /** The tracking url that needs to be invoked to mark the notification as delivered. */
    trackDeliveredUrl?: string | undefined;
    /** An optional link. */
    linkUrl?: string | undefined;
    /** The link text. */
    linkText?: string | undefined;
    /** The link after the confirm button. */
    confirmLink?: string | undefined;
    /** The text for the confirm button. */
    confirmText?: string | undefined;
    /** The tracking url that needs to be invoked to mark the notification as confirmed. */
    confirmUrl?: string | undefined;
    /** The correlation ID, that can be used to query notifications. */
    correlationId?: string | undefined;
    /** Optional data, usually a json object. */
    data?: string | undefined;
    /** Optional properties. */
    properties?: NotificationProperties | undefined;
}

export interface UserNotificationDetailsDto extends UserNotificationBaseDto {
    /** The channel details. */
    channels: { [key: string]: UserNotificationChannelDto; };
    /** The information when the notifcation was marked as deliverd. */
    firstDelivered?: HandledInfoDto | undefined;
    /** The information when the notifcation was marked as seen. */
    firstSeen?: HandledInfoDto | undefined;
    /** The information when the notifcation was marked as confirmed. */
    firstConfirmed?: HandledInfoDto | undefined;
}

export interface UserNotificationChannelDto {
    /** The notification settings. */
    setting: ChannelSettingDto;
    /** The status per token or configuration. */
    status: { [key: string]: ChannelSendInfoDto; };
    /** The first time the notification has been marked as delivered for this channel. */
    firstDelivered?: string | undefined;
    /** The first time the notification has been marked as seen for this channel. */
    firstSeen?: string | undefined;
    /** The first time the notification has been marked as confirmed for this channel. */
    firstConfirmed?: string | undefined;
}

export interface ChannelSendInfoDto {
    /** The send status. */
    status: DeliveryStatus;
    /** The configuration for the device. */
    configuration: SendConfiguration;
    /** The last update. */
    lastUpdate: string;
    /** The details. */
    detail?: string | undefined;
    /** The first time the notification has been marked as delivered for this identifier. */
    firstDelivered?: string | undefined;
    /** The first time the notification has been marked as seen for this identifier. */
    firstSeen?: string | undefined;
    /** The first time the notification has been marked as confirmed for this identifier. */
    firstConfirmed?: string | undefined;
}

export type DeliveryStatus = "Unknown" | "Skipped" | "Attempt" | "Failed" | "Sent" | "Handled";

export interface SendConfiguration {

    [key: string]: string | any;
}

export interface HandledInfoDto {
    /** The timestamp. */
    timestamp: string;
    /** The channel over which the notification was marked as seen or confirmed. */
    channel?: string | undefined;
}

export interface ListResponseDtoOfUserNotificationDto {
    /** The items. */
    items: UserNotificationDto[];
    /** The total number of items. */
    total: number;
}

export interface UserNotificationDto extends UserNotificationBaseDto {
    /** True when the notification has been seen at least once. */
    isSeen: boolean;
    /** True when the notification has been confirmed at least once. */
    isConfirmed: boolean;
}

export type DeviceNotificationsQueryScope = "Seen" | "Unseen" | "All";

export interface TrackNotificationDto {
    /** The ID of the noitifications to mark as confirmed. */
    confirmed?: string | undefined;
    /** The ID of the noitifications to mark as seen. */
    seen?: string[] | undefined;
    /** The channel name. */
    channel?: string | undefined;
    /** The configuration ID. */
    configurationId: string;
    /** The device identifier. */
    deviceIdentifier?: string | undefined;
}

export interface ListResponseDtoOfMobilePushTokenDto {
    /** The items. */
    items: MobilePushTokenDto2[];
    /** The total number of items. */
    total: number;
}

export interface MobilePushTokenDto2 {
    /** The device token. */
    token: string;
    /** The device type. */
    deviceType: MobileDeviceType;
    /** A unique identifier for the device. */
    deviceIdentifier?: string | undefined;
}

export interface RegisterMobileTokenDto {
    /** The device token. */
    token?: string;
    /** The device type. */
    deviceType?: MobileDeviceType;
    /** A unique identifier for the device. */
    deviceIdentifier?: string | undefined;
}

export interface ListResponseDtoOfMediaDto {
    /** The items. */
    items: MediaDto[];
    /** The total number of items. */
    total: number;
}

export interface MediaDto {
    /** The mime type. */
    mimeType: string;
    /** The file name. */
    fileName: string;
    /** Generated information about the file. */
    fileInfo: string;
    /** The url to the media item. */
    url: string;
    /** The size of the media file. */
    fileSize: number;
    /** The date time (ISO 8601) when the media has been created. */
    created: string;
    /** The date time (ISO 8601) when the media has been updated. */
    lastUpdate: string;
    /** The type of the media. */
    type: MediaType;
    /** Metadata about the media. */
    metadata: MediaMetadata;
}

export type MediaType = "Unknown" | "Image" | "Audio" | "Video";

export interface MediaMetadata {

    [key: string]: string | any;
}

export type ResizeMode = "Crop" | "CropUpsize" | "Pad" | "BoxPad" | "Max" | "Min" | "Stretch";

export interface ListResponseDtoOfLogEntryDto {
    /** The items. */
    items: LogEntryDto[];
    /** The total number of items. */
    total: number;
}

export interface LogEntryDto {
    /** The log message. */
    message: string;
    /** The system. */
    system: string;
    /** The first time this message has been seen. */
    firstSeen: string;
    /** The last time this message has been seen. */
    lastSeen: string;
    /** The event code. */
    eventCode: number;
    /** The number of items the message has been seen. */
    count: number;
}

export interface ListResponseDtoOfEventDto {
    /** The items. */
    items: EventDto[];
    /** The total number of items. */
    total: number;
}

export interface EventDto {
    /** The ID of the event. */
    id: string;
    /** The topic path. */
    topic: string;
    /** A custom id to identity the creator. */
    creatorId?: string | undefined;
    /** The display name. */
    displayName: string;
    /** Additional user defined data. */
    data?: string | undefined;
    /** The time when the event has been created. */
    created: string;
    /** The final formatting infos. */
    formatting: NotificationFormattingDto;
    /** Notification settings per channel. */
    settings: { [key: string]: ChannelSettingDto; };
    /** User defined properties. */
    properties: { [key: string]: string; };
    /** The scheduling options. */
    scheduling?: SchedulingDto | undefined;
    /** The statistics counters. */
    counters: { [key: string]: number; };
    /** True when silent. */
    silent: boolean;
    /** The time to live in seconds. */
    timeToLiveInSeconds?: number | undefined;
}

export interface PublishManyDto {
    /** The publish requests. */
    requests: PublishDto[];
}

export interface PublishDto {
    /** The topic path. */
    topic: string;
    /** A custom ID. */
    id?: string | undefined;
    /** A custom id to identity the creator. */
    creatorId?: string | undefined;
    /** The template code. */
    templateCode?: string | undefined;
    /** The correlation ID, that can be used to query notifications. */
    correlationId?: string | undefined;
    /** The grouping key to combine notifications. */
    groupKey?: string | undefined;
    /** The template variants with propability. */
    templateVariants?: { [key: string]: number; } | undefined;
    /** Additional user defined data. */
    data?: string | undefined;
    /** A custom timestamp. */
    timestamp?: string;
    /** Preformatting when no template is used. */
    preformatted?: NotificationFormattingDto | undefined;
    /** The notification settings. */
    settings?: { [key: string]: ChannelSettingDto; } | undefined;
    /** User defined properties. */
    properties?: NotificationProperties | undefined;
    /** The scheduling options. */
    scheduling?: SchedulingDto | undefined;
    /** True when silent. */
    silent?: boolean;
    /** True when using test integrations. */
    test?: boolean;
    /** The time to live in seconds. */
    timeToLiveInSeconds?: number | undefined;
}

export interface CancelResponseDto {
    /** True if something has been cancelled. */
    hasCancelled: boolean;
}

export interface CancelEventDto {
    /** The user ID for which the event was created. */
    userId: string;
    /** The event ID. */
    eventId: string;
    /** The grouping key to combine notifications. */
    groupKey?: string | undefined;
    /** True when using test integrations. */
    test?: boolean;
}

export interface MjmlSchema {
    "!top": string[];

    [key: string]: any;
}

export interface EmailPreviewDto {
    /** The rendered preview. */
    result?: string | undefined;
    /** The errors when rendering a preview. */
    errors?: EmailPreviewErrorDto[] | undefined;
}

export interface EmailPreviewErrorDto {
    /** The error message. */
    message: string;
    /** The line number. */
    lineNumber: number;
    /** The line column. */
    linePosition: number;
}

export interface EmailPreviewRequestDto {
    /** The preview to render. */
    template: string;
    /** The template type. */
    type?: EmailPreviewType;
}

export type EmailPreviewType = "Html" | "Text";

export interface ListResponseDtoOfChannelTemplateDto {
    /** The items. */
    items: ChannelTemplateDto[];
    /** The total number of items. */
    total: number;
}

export interface ChannelTemplateDto {
    /** The ID of the template. */
    id: string;
    /** The optional name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary: boolean;
    /** The last time the template has been updated. */
    lastUpdate: string;
}

export interface ListResponseDtoOfTemplatePropertyDto {
    /** The items. */
    items: TemplatePropertyDto[];
    /** The total number of items. */
    total: number;
}

export interface TemplatePropertyDto {
    /** The property path. */
    path: string;
    /** The data ty. */
    type: LiquidPropertyType;
    /** The optional description. */
    description?: string | undefined;
}

export type LiquidPropertyType = "Array" | "String" | "Number" | "Boolean" | "Object";

export interface ChannelTemplateDetailsDtoOfEmailTemplateDto {
    /** The ID of the template. */
    id: string;
    /** The optional name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary: boolean;
    /** The date time (ISO 8601) when the template has been created. */
    created: string;
    /** The date time (ISO 8601) when the template has been updated. */
    lastUpdate: string;
    /** The language specific templates. */
    languages: { [key: string]: EmailTemplateDto; };
}

export interface EmailTemplateDto {
    /** The subject text. */
    subject: string;
    /** The body html template. */
    bodyHtml: string;
    /** The body text template. */
    bodyText?: string | undefined;
    /** The optional from email. */
    fromEmail?: string | undefined;
    /** The optional from name. */
    fromName?: string | undefined;
}

export interface CreateChannelTemplateDto {
}

export interface CreateChannelTemplateLanguageDto {
    /** The new language. */
    language: string;
}

export interface UpdateChannelTemplateDtoOfEmailTemplateDto {
    /** The name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary?: boolean | undefined;
    /** The language specific templates. */
    languages?: { [key: string]: EmailTemplateDto; } | undefined;
}

export interface ChannelTemplateDetailsDtoOfMessagingTemplateDto {
    /** The ID of the template. */
    id: string;
    /** The optional name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary: boolean;
    /** The date time (ISO 8601) when the template has been created. */
    created: string;
    /** The date time (ISO 8601) when the template has been updated. */
    lastUpdate: string;
    /** The language specific templates. */
    languages: { [key: string]: MessagingTemplateDto; };
}

export interface MessagingTemplateDto {
    /** The template text. */
    text: string;
}

export interface UpdateChannelTemplateDtoOfMessagingTemplateDto {
    /** The name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary?: boolean | undefined;
    /** The language specific templates. */
    languages?: { [key: string]: MessagingTemplateDto; } | undefined;
}

export interface ChannelTemplateDetailsDtoOfSmsTemplateDto {
    /** The ID of the template. */
    id: string;
    /** The optional name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary: boolean;
    /** The date time (ISO 8601) when the template has been created. */
    created: string;
    /** The date time (ISO 8601) when the template has been updated. */
    lastUpdate: string;
    /** The language specific templates. */
    languages: { [key: string]: SmsTemplateDto; };
}

export interface SmsTemplateDto {
    /** The template text. */
    text: string;
}

export interface UpdateChannelTemplateDtoOfSmsTemplateDto {
    /** The name of the template. */
    name?: string | undefined;
    /** True, when the template is the primary template. */
    primary?: boolean | undefined;
    /** The language specific templates. */
    languages?: { [key: string]: SmsTemplateDto; } | undefined;
}

export interface AppDto {
    /** The ID of the app. */
    id: string;
    /** The app name. */
    name: string;
    /** The current role. */
    role: string;
    /** The date time (ISO 8601) when the app has been created. */
    created: string;
    /** The date time (ISO 8601) when the app has been updated. */
    lastUpdate: string;
    /** The supported languages. */
    languages: string[];
    /** The api keys. */
    apiKeys: { [key: string]: string; };
    /** The statistics counters. */
    counters: { [key: string]: number; };
}

export interface AppDetailsDto {
    /** The ID of the app. */
    id: string;
    /** The app name. */
    name: string;
    /** The current role. */
    role: string;
    /** The date time (ISO 8601) when the app has been created. */
    created: string;
    /** The date time (ISO 8601) when the app has been updated. */
    lastUpdate: string;
    /** The confirm URL. */
    confirmUrl?: string | undefined;
    /** The supported languages. */
    languages: string[];
    /** The api keys. */
    apiKeys: { [key: string]: string; };
    /** The contributors. */
    contributors: AppContributorDto[];
    /** The statistics counters. */
    counters: { [key: string]: number; };
}

export interface AppContributorDto {
    /** The ID of the user. */
    userId: string;
    /** The name of the user. */
    userName: string;
    /** The role. */
    role: string;
}

export interface AuthSchemeValueDto {
    /** The auth scheme if configured. */
    scheme?: AuthSchemeDto | undefined;
}

export interface AuthSchemeDto {
    /** The domain name of your user accounts. */
    domain: string;
    /** The display name for buttons. */
    displayName: string;
    /** The client ID. */
    clientId: string;
    /** The client secret. */
    clientSecret: string;
    /** The authority URL. */
    authority: string;
    /** The URL to redirect after a signout. */
    signoutRedirectUrl?: string | undefined;
}

export interface UpsertAppDto {
    /** The app name. */
    name?: string | undefined;
    /** The supported languages. */
    languages?: string[] | undefined;
    /** The sender email address. */
    emailAddress?: string | undefined;
    /** The sender email name. */
    emailName?: string | undefined;
    /** The firebase project ID. */
    firebaseProject?: string | undefined;
    /** The firebase credentials. */
    firebaseCredential?: string | undefined;
    /** The webhook URL. */
    webhookUrl?: string | undefined;
    /** The confirm URL. */
    confirmUrl?: string | undefined;
    /** True, when emails are allowed. */
    allowEmail?: boolean | undefined;
    /** True, when SMS are allowed. */
    allowSms?: boolean | undefined;
}

export interface AddContributorDto {
    /** The email of the new contributor. */
    email: string;
    /** The role. */
    role?: string | undefined;
}

export interface ConfiguredIntegrationsDto {
    /** The configured integrations. */
    configured: { [key: string]: ConfiguredIntegrationDto; };
    /** The supported integrations. */
    supported: { [key: string]: IntegrationDefinitionDto; };
}

export interface ConfiguredIntegrationDto {
    /** The integration type. */
    type: string;
    /** The configured properties. */
    properties: { [key: string]: string; };
    /** True when enabled. */
    enabled: boolean;
    /** True or false when only used for test or production mode. */
    test?: boolean | undefined;
    /** The javascript condition. */
    condition?: string | undefined;
    /** The priority in which order the integrations must run. */
    priority: number;
    /** The status of the integration. */
    status: IntegrationStatus;
}

export type IntegrationStatus = "Verified" | "VerificationFailed" | "Pending" | "Removed";

export interface IntegrationDefinitionDto {
    /** The title of the integration. */
    title: string;
    /** The logo for the integration. */
    logo: string;
    /** The optional description of the integration. */
    description?: string | undefined;
    /** The properties to configure. */
    properties: IntegrationPropertyDto[];
    /** The features of the integration. */
    capabilities: string[];
}

export interface IntegrationPropertyDto {
    /** The field name for the property. */
    name: string;
    /** The editor type. */
    type: PropertyType;
    /** The optional description. */
    editorDescription?: string | undefined;
    /** The optional label. */
    editorLabel?: string | undefined;
    /** True to show this property in the summary. */
    summary: boolean;
    /** The allowed values. */
    allowedValues?: string[] | undefined;
    /** True when required. */
    isRequired: boolean;
    /** The min value (for numbers). */
    minValue?: number | undefined;
    /** The max value (for numbers). */
    maxValue?: number | undefined;
    /** The min length (for strings). */
    minLength?: number | undefined;
    /** The min length (for strings). */
    maxLength?: number | undefined;
    /** The pattern (for strings). */
    pattern?: string | undefined;
    /** Format of the field, used to both validate the input and to provide hints to the user. */
    format: PropertyFormat;
    /** The default value. */
    defaultValue?: any | undefined;
}

export type PropertyType = "Text" | "Number" | "MultilineText" | "Password" | "Boolean";
export type PropertyFormat = "None" | "Email" | "HttpUrl";

export interface IntegrationCreatedDto {
    /** The ID of the integration. */
    id: string;
    /** The integration. */
    integration: ConfiguredIntegrationDto;
}

export interface CreateIntegrationDto {
    /** The integration type. */
    type: string;
    /** The configured properties. */
    properties: { [key: string]: string; };
    /** True when enabled. */
    enabled?: boolean | undefined;
    /** True when used for test events. */
    test?: boolean | undefined;
    /** The priority in which order the integrations must run. */
    priority?: number | undefined;
}

export interface UpdateIntegrationDto {
    /** The configured properties. */
    properties: { [key: string]: string; };
    /** True when enabled. */
    enabled?: boolean | undefined;
    /** True when used for test events. */
    test?: boolean | undefined;
    /** The javascript condition. */
    condition?: string | undefined;
    /** The priority in which order the integrations must run. */
    priority?: number | undefined;
}

export interface FileParameter {
    data: any;
    fileName: string;
}

export interface FileResponse {
    data: Blob;
    status: number;
    fileName?: string;
    headers?: { [name: string]: any };
}

export class ApiException extends Error {
    message: string;
    status: number;
    response: string;
    headers: { [key: string]: any; };
    result: any;

    constructor(message: string, status: number, response: string, headers: { [key: string]: any; }, result: any) {
        super();

        this.message = message;
        this.status = status;
        this.response = response;
        this.headers = headers;
        this.result = result;
    }

    protected isApiException = true;

    static isApiException(obj: any): obj is ApiException {
        return obj.isApiException === true;
    }
}

function throwException(message: string, status: number, response: string, headers: { [key: string]: any; }, result?: any): any {
    if (result !== null && result !== undefined)
        throw result;
    else
        throw new ApiException(message, status, response, headers, null);
}