/*
 * Notifo.io
 *
 * @license
 * Copyright (c) Sebastian Stehle. All rights reserved.
 */

import * as React from 'react';
import { FormatDate, Numbers } from '@app/framework';
import { LogEntryDto } from '@app/service';

export interface LogEntryRowProps {
    // The log entry.
    entry: LogEntryDto;
}

export const LogEntryRow = React.memo((props: LogEntryRowProps) => {
    const { entry } = props;

    return (
        <tr>
            <td>
                <span className='truncate'>{entry.eventCode}</span>
            </td>
            <td>
                <span className='truncate'>{entry.system}</span>
            </td>
            <td>
                <span>{entry.message}</span>
            </td>
            <td>
                <span className='truncate'>{Numbers.formatNumber(entry.count)}</span>
            </td>
            <td className='text-right'>
                <span className='truncate'>
                    <FormatDate date={entry.lastSeen} />
                </span>
            </td>
            <td className='text-right'>
                <span className='truncate'>
                    <FormatDate date={entry.firstSeen} />
                </span>
            </td>
        </tr>
    );
});
