﻿// ==========================================================================
//  Notifo.io
// ==========================================================================
//  Copyright (c) Sebastian Stehle
//  All rights reserved. Licensed under the MIT license.
// ==========================================================================

using Notifo.Domain.Channels.MobilePush;
using Notifo.Domain.Integrations;
using Notifo.Infrastructure.Reflection;

namespace Notifo.Areas.Api.Controllers.MobilePush.Dtos;

public sealed class MobilePushTokenDto
{
    /// <summary>
    /// The device token.
    /// </summary>
    public string Token { get; set; }

    /// <summary>
    /// The device type.
    /// </summary>
    public MobileDeviceType DeviceType { get; set; }

    /// <summary>
    /// A unique identifier for the device.
    /// </summary>
    public string? DeviceIdentifier { get; set; }

    public static MobilePushTokenDto FromDomainObject(MobilePushToken source)
    {
        return SimpleMapper.Map(source, new MobilePushTokenDto());
    }
}
