﻿// ==========================================================================
//  Notifo.io
// ==========================================================================
//  Copyright (c) Squidex UG (haftungsbeschränkt)
//  All rights reserved. Licensed under the MIT license.
// ==========================================================================
// <autogenerated/>

using System.CodeDom.Compiler;

namespace Notifo.Infrastructure;

[GeneratedCode("LanguagesGenerator", "1.0")]
public partial record Language
{
    private static readonly Dictionary<string, Language> AllLanguagesField = new Dictionary<string, Language>(StringComparer.OrdinalIgnoreCase);
    private static readonly Dictionary<string, string> AllLanguagesNames = new Dictionary<string, string>(StringComparer.OrdinalIgnoreCase);

    internal static Language AddLanguage(string iso2Code, string englishName)
    {
        AllLanguagesNames[iso2Code] = englishName;

        return AllLanguagesField.GetOrAdd(iso2Code, code => new Language(code));
    }

    public static readonly Language AA = AddLanguage("aa", "Afar");
    public static readonly Language AB = AddLanguage("ab", "Abkhazian");
    public static readonly Language AE = AddLanguage("ae", "Avestan");
    public static readonly Language AF = AddLanguage("af", "Afrikaans");
    public static readonly Language AK = AddLanguage("ak", "Akan");
    public static readonly Language AM = AddLanguage("am", "Amharic");
    public static readonly Language AN = AddLanguage("an", "Aragonese");
    public static readonly Language AR = AddLanguage("ar", "Arabic");
    public static readonly Language AS = AddLanguage("as", "Assamese");
    public static readonly Language AV = AddLanguage("av", "Avaric");
    public static readonly Language AY = AddLanguage("ay", "Aymara");
    public static readonly Language AZ = AddLanguage("az", "Azerbaijani");
    public static readonly Language BA = AddLanguage("ba", "Bashkir");
    public static readonly Language BE = AddLanguage("be", "Belarusian");
    public static readonly Language BG = AddLanguage("bg", "Bulgarian");
    public static readonly Language BH = AddLanguage("bh", "Bihari");
    public static readonly Language BI = AddLanguage("bi", "Bislama");
    public static readonly Language BM = AddLanguage("bm", "Bambara");
    public static readonly Language BN = AddLanguage("bn", "Bengali");
    public static readonly Language BO = AddLanguage("bo", "Tibetan");
    public static readonly Language BR = AddLanguage("br", "Breton");
    public static readonly Language BS = AddLanguage("bs", "Bosnian");
    public static readonly Language CA = AddLanguage("ca", "Catalan");
    public static readonly Language CE = AddLanguage("ce", "Chechen");
    public static readonly Language CH = AddLanguage("ch", "Chamorro");
    public static readonly Language CO = AddLanguage("co", "Corsican");
    public static readonly Language CR = AddLanguage("cr", "Cree");
    public static readonly Language CS = AddLanguage("cs", "Czech");
    public static readonly Language CV = AddLanguage("cv", "Chuvash");
    public static readonly Language CY = AddLanguage("cy", "Welsh");
    public static readonly Language DA = AddLanguage("da", "Danish");
    public static readonly Language DE = AddLanguage("de", "German");
    public static readonly Language DV = AddLanguage("dv", "Divehi");
    public static readonly Language DZ = AddLanguage("dz", "Dzongkha");
    public static readonly Language EE = AddLanguage("ee", "Ewe");
    public static readonly Language EL = AddLanguage("el", "Greek");
    public static readonly Language EN = AddLanguage("en", "English");
    public static readonly Language EO = AddLanguage("eo", "Esperanto");
    public static readonly Language ES = AddLanguage("es", "Spanish");
    public static readonly Language ET = AddLanguage("et", "Estonian");
    public static readonly Language EU = AddLanguage("eu", "Basque");
    public static readonly Language FA = AddLanguage("fa", "Persian");
    public static readonly Language FF = AddLanguage("ff", "Fulah");
    public static readonly Language FI = AddLanguage("fi", "Finnish");
    public static readonly Language FJ = AddLanguage("fj", "Fijian");
    public static readonly Language FO = AddLanguage("fo", "Faroese");
    public static readonly Language FR = AddLanguage("fr", "French");
    public static readonly Language FY = AddLanguage("fy", "Western Frisian");
    public static readonly Language GA = AddLanguage("ga", "Irish");
    public static readonly Language GD = AddLanguage("gd", "Gaelic");
    public static readonly Language GL = AddLanguage("gl", "Galician");
    public static readonly Language GN = AddLanguage("gn", "Guarani");
    public static readonly Language GU = AddLanguage("gu", "Gujarati");
    public static readonly Language GV = AddLanguage("gv", "Manx");
    public static readonly Language HA = AddLanguage("ha", "Hausa");
    public static readonly Language HE = AddLanguage("he", "Hebrew");
    public static readonly Language HI = AddLanguage("hi", "Hindi");
    public static readonly Language HO = AddLanguage("ho", "Hiri Motu");
    public static readonly Language HR = AddLanguage("hr", "Croatian");
    public static readonly Language HT = AddLanguage("ht", "Haitian");
    public static readonly Language HU = AddLanguage("hu", "Hungarian");
    public static readonly Language HY = AddLanguage("hy", "Armenian");
    public static readonly Language HZ = AddLanguage("hz", "Herero");
    public static readonly Language ID = AddLanguage("id", "Indonesian");
    public static readonly Language IG = AddLanguage("ig", "Igbo");
    public static readonly Language II = AddLanguage("ii", "Sichuan Yi");
    public static readonly Language IK = AddLanguage("ik", "Inupiaq");
    public static readonly Language IO = AddLanguage("io", "Ido");
    public static readonly Language IS = AddLanguage("is", "Icelandic");
    public static readonly Language IT = AddLanguage("it", "Italian");
    public static readonly Language IU = AddLanguage("iu", "Inuktitut");
    public static readonly Language JA = AddLanguage("ja", "Japanese");
    public static readonly Language JV = AddLanguage("jv", "Javanese");
    public static readonly Language KA = AddLanguage("ka", "Georgian");
    public static readonly Language KG = AddLanguage("kg", "Kongo");
    public static readonly Language KI = AddLanguage("ki", "Kikuyu");
    public static readonly Language KJ = AddLanguage("kj", "Kuanyama");
    public static readonly Language KK = AddLanguage("kk", "Kazakh");
    public static readonly Language KL = AddLanguage("kl", "Kalaallisut");
    public static readonly Language KM = AddLanguage("km", "Central Khmer");
    public static readonly Language KN = AddLanguage("kn", "Kannada");
    public static readonly Language KO = AddLanguage("ko", "Korean");
    public static readonly Language KR = AddLanguage("kr", "Kanuri");
    public static readonly Language KS = AddLanguage("ks", "Kashmiri");
    public static readonly Language KU = AddLanguage("ku", "Kurdish");
    public static readonly Language KV = AddLanguage("kv", "Komi");
    public static readonly Language KW = AddLanguage("kw", "Cornish");
    public static readonly Language KY = AddLanguage("ky", "Kirghiz");
    public static readonly Language LA = AddLanguage("la", "Latin");
    public static readonly Language LB = AddLanguage("lb", "Luxembourgish");
    public static readonly Language LG = AddLanguage("lg", "Ganda");
    public static readonly Language LI = AddLanguage("li", "Limburgan");
    public static readonly Language LN = AddLanguage("ln", "Lingala");
    public static readonly Language LO = AddLanguage("lo", "Lao");
    public static readonly Language LT = AddLanguage("lt", "Lithuanian");
    public static readonly Language LU = AddLanguage("lu", "Luba-Katanga");
    public static readonly Language LV = AddLanguage("lv", "Latvian");
    public static readonly Language MG = AddLanguage("mg", "Malagasy");
    public static readonly Language MH = AddLanguage("mh", "Marshallese");
    public static readonly Language MI = AddLanguage("mi", "Maori");
    public static readonly Language MK = AddLanguage("mk", "Macedonian");
    public static readonly Language ML = AddLanguage("ml", "Malayalam");
    public static readonly Language MN = AddLanguage("mn", "Mongolian");
    public static readonly Language MR = AddLanguage("mr", "Marathi");
    public static readonly Language MS = AddLanguage("ms", "Malay");
    public static readonly Language MT = AddLanguage("mt", "Maltese");
    public static readonly Language MY = AddLanguage("my", "Burmese");
    public static readonly Language NA = AddLanguage("na", "Nauru");
    public static readonly Language NB = AddLanguage("nb", "Bokmål");
    public static readonly Language ND = AddLanguage("nd", "Ndebele");
    public static readonly Language NE = AddLanguage("ne", "Nepali");
    public static readonly Language NG = AddLanguage("ng", "Ndonga");
    public static readonly Language NL = AddLanguage("nl", "Dutch");
    public static readonly Language NN = AddLanguage("nn", "Norwegian Nynorsk");
    public static readonly Language NO = AddLanguage("no", "Norwegian");
    public static readonly Language NR = AddLanguage("nr", "Ndebele");
    public static readonly Language NV = AddLanguage("nv", "Navajo");
    public static readonly Language OJ = AddLanguage("oj", "Ojibwa");
    public static readonly Language OM = AddLanguage("om", "Oromo");
    public static readonly Language OR = AddLanguage("or", "Oriya");
    public static readonly Language PI = AddLanguage("pi", "Pali");
    public static readonly Language PL = AddLanguage("pl", "Polish");
    public static readonly Language PS = AddLanguage("ps", "Pushto");
    public static readonly Language PT = AddLanguage("pt", "Portuguese");
    public static readonly Language QU = AddLanguage("qu", "Quechua");
    public static readonly Language RM = AddLanguage("rm", "Romansh");
    public static readonly Language RN = AddLanguage("rn", "Rundi");
    public static readonly Language RO = AddLanguage("ro", "Romanian");
    public static readonly Language RU = AddLanguage("ru", "Russian");
    public static readonly Language RW = AddLanguage("rw", "Kinyarwanda");
    public static readonly Language SA = AddLanguage("sa", "Sanskrit");
    public static readonly Language SC = AddLanguage("sc", "Sardinian");
    public static readonly Language SD = AddLanguage("sd", "Sindhi");
    public static readonly Language SE = AddLanguage("se", "Northern Sami");
    public static readonly Language SG = AddLanguage("sg", "Sango");
    public static readonly Language SI = AddLanguage("si", "Sinhala");
    public static readonly Language SK = AddLanguage("sk", "Slovak");
    public static readonly Language SL = AddLanguage("sl", "Slovenian");
    public static readonly Language SM = AddLanguage("sm", "Samoan");
    public static readonly Language SN = AddLanguage("sn", "Shona");
    public static readonly Language SO = AddLanguage("so", "Somali");
    public static readonly Language SQ = AddLanguage("sq", "Albanian");
    public static readonly Language SR = AddLanguage("sr", "Serbian");
    public static readonly Language SS = AddLanguage("ss", "Swati");
    public static readonly Language ST = AddLanguage("st", "Sotho");
    public static readonly Language SU = AddLanguage("su", "Sundanese");
    public static readonly Language SV = AddLanguage("sv", "Swedish");
    public static readonly Language SW = AddLanguage("sw", "Swahili");
    public static readonly Language TA = AddLanguage("ta", "Tamil");
    public static readonly Language TE = AddLanguage("te", "Telugu");
    public static readonly Language TG = AddLanguage("tg", "Tajik");
    public static readonly Language TH = AddLanguage("th", "Thai");
    public static readonly Language TI = AddLanguage("ti", "Tigrinya");
    public static readonly Language TK = AddLanguage("tk", "Turkmen");
    public static readonly Language TL = AddLanguage("tl", "Tagalog");
    public static readonly Language TN = AddLanguage("tn", "Tswana");
    public static readonly Language TO = AddLanguage("to", "Tonga");
    public static readonly Language TR = AddLanguage("tr", "Turkish");
    public static readonly Language TS = AddLanguage("ts", "Tsonga");
    public static readonly Language TT = AddLanguage("tt", "Tatar");
    public static readonly Language TW = AddLanguage("tw", "Twi");
    public static readonly Language TY = AddLanguage("ty", "Tahitian");
    public static readonly Language UG = AddLanguage("ug", "Uighur");
    public static readonly Language UK = AddLanguage("uk", "Ukrainian");
    public static readonly Language UR = AddLanguage("ur", "Urdu");
    public static readonly Language UZ = AddLanguage("uz", "Uzbek");
    public static readonly Language VE = AddLanguage("ve", "Venda");
    public static readonly Language VI = AddLanguage("vi", "Vietnamese");
    public static readonly Language VO = AddLanguage("vo", "Volapük");
    public static readonly Language WA = AddLanguage("wa", "Walloon");
    public static readonly Language WO = AddLanguage("wo", "Wolof");
    public static readonly Language XH = AddLanguage("xh", "Xhosa");
    public static readonly Language YI = AddLanguage("yi", "Yiddish");
    public static readonly Language YO = AddLanguage("yo", "Yoruba");
    public static readonly Language ZA = AddLanguage("za", "Zhuang");
    public static readonly Language ZH = AddLanguage("zh", "Chinese");
    public static readonly Language ZU = AddLanguage("zu", "Zulu");

    public static readonly Language AfarDjibouti = AddLanguage("aa-DJ", "Afar (Djibouti)");
    public static readonly Language AfarEritrea = AddLanguage("aa-ER", "Afar (Eritrea)");
    public static readonly Language AfarEthiopia = AddLanguage("aa-ET", "Afar (Ethiopia)");
    public static readonly Language AfrikaansNamibia = AddLanguage("af-NA", "Afrikaans (Namibia)");
    public static readonly Language AfrikaansSouthAfrica = AddLanguage("af-ZA", "Afrikaans (South Africa)");
    public static readonly Language AkanGhana = AddLanguage("ak-GH", "Akan (Ghana)");
    public static readonly Language AmharicEthiopia = AddLanguage("am-ET", "Amharic (Ethiopia)");
    public static readonly Language ArabicUnitedArabEmirates = AddLanguage("ar-AE", "Arabic (United Arab Emirates)");
    public static readonly Language ArabicBahrain = AddLanguage("ar-BH", "Arabic (Bahrain)");
    public static readonly Language ArabicDjibouti = AddLanguage("ar-DJ", "Arabic (Djibouti)");
    public static readonly Language ArabicAlgeria = AddLanguage("ar-DZ", "Arabic (Algeria)");
    public static readonly Language ArabicEgypt = AddLanguage("ar-EG", "Arabic (Egypt)");
    public static readonly Language ArabicEritrea = AddLanguage("ar-ER", "Arabic (Eritrea)");
    public static readonly Language ArabicIsrael = AddLanguage("ar-IL", "Arabic (Israel)");
    public static readonly Language ArabicIraq = AddLanguage("ar-IQ", "Arabic (Iraq)");
    public static readonly Language ArabicJordan = AddLanguage("ar-JO", "Arabic (Jordan)");
    public static readonly Language ArabicComoros = AddLanguage("ar-KM", "Arabic (Comoros)");
    public static readonly Language ArabicKuwait = AddLanguage("ar-KW", "Arabic (Kuwait)");
    public static readonly Language ArabicLebanon = AddLanguage("ar-LB", "Arabic (Lebanon)");
    public static readonly Language ArabicLibya = AddLanguage("ar-LY", "Arabic (Libya)");
    public static readonly Language ArabicMorocco = AddLanguage("ar-MA", "Arabic (Morocco)");
    public static readonly Language ArabicMauritania = AddLanguage("ar-MR", "Arabic (Mauritania)");
    public static readonly Language ArabicOman = AddLanguage("ar-OM", "Arabic (Oman)");
    public static readonly Language ArabicPalestinianAuthority = AddLanguage("ar-PS", "Arabic (Palestinian Authority)");
    public static readonly Language ArabicQatar = AddLanguage("ar-QA", "Arabic (Qatar)");
    public static readonly Language ArabicSaudiArabia = AddLanguage("ar-SA", "Arabic (Saudi Arabia)");
    public static readonly Language ArabicSudan = AddLanguage("ar-SD", "Arabic (Sudan)");
    public static readonly Language ArabicSomalia = AddLanguage("ar-SO", "Arabic (Somalia)");
    public static readonly Language ArabicSouthSudan = AddLanguage("ar-SS", "Arabic (South Sudan)");
    public static readonly Language ArabicSyria = AddLanguage("ar-SY", "Arabic (Syria)");
    public static readonly Language ArabicChad = AddLanguage("ar-TD", "Arabic (Chad)");
    public static readonly Language ArabicTunisia = AddLanguage("ar-TN", "Arabic (Tunisia)");
    public static readonly Language ArabicYemen = AddLanguage("ar-YE", "Arabic (Yemen)");
    public static readonly Language AssameseIndia = AddLanguage("as-IN", "Assamese (India)");
    public static readonly Language BashkirRussia = AddLanguage("ba-RU", "Bashkir (Russia)");
    public static readonly Language BelarusianBelarus = AddLanguage("be-BY", "Belarusian (Belarus)");
    public static readonly Language BulgarianBulgaria = AddLanguage("bg-BG", "Bulgarian (Bulgaria)");
    public static readonly Language BanglaBangladesh = AddLanguage("bn-BD", "Bangla (Bangladesh)");
    public static readonly Language BanglaIndia = AddLanguage("bn-IN", "Bangla (India)");
    public static readonly Language TibetanChina = AddLanguage("bo-CN", "Tibetan (China)");
    public static readonly Language TibetanIndia = AddLanguage("bo-IN", "Tibetan (India)");
    public static readonly Language BretonFrance = AddLanguage("br-FR", "Breton (France)");
    public static readonly Language CatalanAndorra = AddLanguage("ca-AD", "Catalan (Andorra)");
    public static readonly Language CatalanSpain = AddLanguage("ca-ES", "Catalan (Spain)");
    public static readonly Language CatalanFrance = AddLanguage("ca-FR", "Catalan (France)");
    public static readonly Language CatalanItaly = AddLanguage("ca-IT", "Catalan (Italy)");
    public static readonly Language ChechenRussia = AddLanguage("ce-RU", "Chechen (Russia)");
    public static readonly Language CorsicanFrance = AddLanguage("co-FR", "Corsican (France)");
    public static readonly Language CzechCzechia = AddLanguage("cs-CZ", "Czech (Czechia)");
    public static readonly Language WelshUnitedKingdom = AddLanguage("cy-GB", "Welsh (United Kingdom)");
    public static readonly Language DanishDenmark = AddLanguage("da-DK", "Danish (Denmark)");
    public static readonly Language DanishGreenland = AddLanguage("da-GL", "Danish (Greenland)");
    public static readonly Language GermanAustria = AddLanguage("de-AT", "German (Austria)");
    public static readonly Language GermanBelgium = AddLanguage("de-BE", "German (Belgium)");
    public static readonly Language GermanSwitzerland = AddLanguage("de-CH", "German (Switzerland)");
    public static readonly Language GermanGermany = AddLanguage("de-DE", "German (Germany)");
    public static readonly Language GermanItaly = AddLanguage("de-IT", "German (Italy)");
    public static readonly Language GermanLiechtenstein = AddLanguage("de-LI", "German (Liechtenstein)");
    public static readonly Language GermanLuxembourg = AddLanguage("de-LU", "German (Luxembourg)");
    public static readonly Language DivehiMaldives = AddLanguage("dv-MV", "Divehi (Maldives)");
    public static readonly Language DzongkhaBhutan = AddLanguage("dz-BT", "Dzongkha (Bhutan)");
    public static readonly Language EweGhana = AddLanguage("ee-GH", "Ewe (Ghana)");
    public static readonly Language EweTogo = AddLanguage("ee-TG", "Ewe (Togo)");
    public static readonly Language GreekCyprus = AddLanguage("el-CY", "Greek (Cyprus)");
    public static readonly Language GreekGreece = AddLanguage("el-GR", "Greek (Greece)");
    public static readonly Language EnglishAntiguaandBarbuda = AddLanguage("en-AG", "English (Antigua and Barbuda)");
    public static readonly Language EnglishAnguilla = AddLanguage("en-AI", "English (Anguilla)");
    public static readonly Language EnglishAmericanSamoa = AddLanguage("en-AS", "English (American Samoa)");
    public static readonly Language EnglishAustria = AddLanguage("en-AT", "English (Austria)");
    public static readonly Language EnglishAustralia = AddLanguage("en-AU", "English (Australia)");
    public static readonly Language EnglishBarbados = AddLanguage("en-BB", "English (Barbados)");
    public static readonly Language EnglishBelgium = AddLanguage("en-BE", "English (Belgium)");
    public static readonly Language EnglishBurundi = AddLanguage("en-BI", "English (Burundi)");
    public static readonly Language EnglishBermuda = AddLanguage("en-BM", "English (Bermuda)");
    public static readonly Language EnglishBahamas = AddLanguage("en-BS", "English (Bahamas)");
    public static readonly Language EnglishBotswana = AddLanguage("en-BW", "English (Botswana)");
    public static readonly Language EnglishBelize = AddLanguage("en-BZ", "English (Belize)");
    public static readonly Language EnglishCanada = AddLanguage("en-CA", "English (Canada)");
    public static readonly Language EnglishCocosKeelingIslands = AddLanguage("en-CC", "English (Cocos [Keeling] Islands)");
    public static readonly Language EnglishSwitzerland = AddLanguage("en-CH", "English (Switzerland)");
    public static readonly Language EnglishCookIslands = AddLanguage("en-CK", "English (Cook Islands)");
    public static readonly Language EnglishCameroon = AddLanguage("en-CM", "English (Cameroon)");
    public static readonly Language EnglishChristmasIsland = AddLanguage("en-CX", "English (Christmas Island)");
    public static readonly Language EnglishCyprus = AddLanguage("en-CY", "English (Cyprus)");
    public static readonly Language EnglishGermany = AddLanguage("en-DE", "English (Germany)");
    public static readonly Language EnglishDenmark = AddLanguage("en-DK", "English (Denmark)");
    public static readonly Language EnglishDominica = AddLanguage("en-DM", "English (Dominica)");
    public static readonly Language EnglishEritrea = AddLanguage("en-ER", "English (Eritrea)");
    public static readonly Language EnglishFinland = AddLanguage("en-FI", "English (Finland)");
    public static readonly Language EnglishFiji = AddLanguage("en-FJ", "English (Fiji)");
    public static readonly Language EnglishFalklandIslands = AddLanguage("en-FK", "English (Falkland Islands)");
    public static readonly Language EnglishMicronesia = AddLanguage("en-FM", "English (Micronesia)");
    public static readonly Language EnglishUnitedKingdom = AddLanguage("en-GB", "English (United Kingdom)");
    public static readonly Language EnglishGrenada = AddLanguage("en-GD", "English (Grenada)");
    public static readonly Language EnglishGuernsey = AddLanguage("en-GG", "English (Guernsey)");
    public static readonly Language EnglishGhana = AddLanguage("en-GH", "English (Ghana)");
    public static readonly Language EnglishGibraltar = AddLanguage("en-GI", "English (Gibraltar)");
    public static readonly Language EnglishGambia = AddLanguage("en-GM", "English (Gambia)");
    public static readonly Language EnglishGuam = AddLanguage("en-GU", "English (Guam)");
    public static readonly Language EnglishGuyana = AddLanguage("en-GY", "English (Guyana)");
    public static readonly Language EnglishHongKongSAR = AddLanguage("en-HK", "English (Hong Kong SAR)");
    public static readonly Language EnglishIreland = AddLanguage("en-IE", "English (Ireland)");
    public static readonly Language EnglishIsrael = AddLanguage("en-IL", "English (Israel)");
    public static readonly Language EnglishIsleofMan = AddLanguage("en-IM", "English (Isle of Man)");
    public static readonly Language EnglishIndia = AddLanguage("en-IN", "English (India)");
    public static readonly Language EnglishBritishIndianOceanTerritory = AddLanguage("en-IO", "English (British Indian Ocean Territory)");
    public static readonly Language EnglishJersey = AddLanguage("en-JE", "English (Jersey)");
    public static readonly Language EnglishJamaica = AddLanguage("en-JM", "English (Jamaica)");
    public static readonly Language EnglishKenya = AddLanguage("en-KE", "English (Kenya)");
    public static readonly Language EnglishKiribati = AddLanguage("en-KI", "English (Kiribati)");
    public static readonly Language EnglishSaintKittsandNevis = AddLanguage("en-KN", "English (Saint Kitts and Nevis)");
    public static readonly Language EnglishCaymanIslands = AddLanguage("en-KY", "English (Cayman Islands)");
    public static readonly Language EnglishSaintLucia = AddLanguage("en-LC", "English (Saint Lucia)");
    public static readonly Language EnglishLiberia = AddLanguage("en-LR", "English (Liberia)");
    public static readonly Language EnglishLesotho = AddLanguage("en-LS", "English (Lesotho)");
    public static readonly Language EnglishMadagascar = AddLanguage("en-MG", "English (Madagascar)");
    public static readonly Language EnglishMarshallIslands = AddLanguage("en-MH", "English (Marshall Islands)");
    public static readonly Language EnglishMacaoSAR = AddLanguage("en-MO", "English (Macao SAR)");
    public static readonly Language EnglishNorthernMarianaIslands = AddLanguage("en-MP", "English (Northern Mariana Islands)");
    public static readonly Language EnglishMontserrat = AddLanguage("en-MS", "English (Montserrat)");
    public static readonly Language EnglishMalta = AddLanguage("en-MT", "English (Malta)");
    public static readonly Language EnglishMauritius = AddLanguage("en-MU", "English (Mauritius)");
    public static readonly Language EnglishMalawi = AddLanguage("en-MW", "English (Malawi)");
    public static readonly Language EnglishMalaysia = AddLanguage("en-MY", "English (Malaysia)");
    public static readonly Language EnglishNamibia = AddLanguage("en-NA", "English (Namibia)");
    public static readonly Language EnglishNorfolkIsland = AddLanguage("en-NF", "English (Norfolk Island)");
    public static readonly Language EnglishNigeria = AddLanguage("en-NG", "English (Nigeria)");
    public static readonly Language EnglishNetherlands = AddLanguage("en-NL", "English (Netherlands)");
    public static readonly Language EnglishNauru = AddLanguage("en-NR", "English (Nauru)");
    public static readonly Language EnglishNiue = AddLanguage("en-NU", "English (Niue)");
    public static readonly Language EnglishNewZealand = AddLanguage("en-NZ", "English (New Zealand)");
    public static readonly Language EnglishPapuaNewGuinea = AddLanguage("en-PG", "English (Papua New Guinea)");
    public static readonly Language EnglishPhilippines = AddLanguage("en-PH", "English (Philippines)");
    public static readonly Language EnglishPakistan = AddLanguage("en-PK", "English (Pakistan)");
    public static readonly Language EnglishPitcairnIslands = AddLanguage("en-PN", "English (Pitcairn Islands)");
    public static readonly Language EnglishPuertoRico = AddLanguage("en-PR", "English (Puerto Rico)");
    public static readonly Language EnglishPalau = AddLanguage("en-PW", "English (Palau)");
    public static readonly Language EnglishRwanda = AddLanguage("en-RW", "English (Rwanda)");
    public static readonly Language EnglishSolomonIslands = AddLanguage("en-SB", "English (Solomon Islands)");
    public static readonly Language EnglishSeychelles = AddLanguage("en-SC", "English (Seychelles)");
    public static readonly Language EnglishSudan = AddLanguage("en-SD", "English (Sudan)");
    public static readonly Language EnglishSweden = AddLanguage("en-SE", "English (Sweden)");
    public static readonly Language EnglishSingapore = AddLanguage("en-SG", "English (Singapore)");
    public static readonly Language EnglishStHelenaAscensionTristandaCunha = AddLanguage("en-SH", "English (St Helena, Ascension, Tristan da Cunha)");
    public static readonly Language EnglishSlovenia = AddLanguage("en-SI", "English (Slovenia)");
    public static readonly Language EnglishSierraLeone = AddLanguage("en-SL", "English (Sierra Leone)");
    public static readonly Language EnglishSouthSudan = AddLanguage("en-SS", "English (South Sudan)");
    public static readonly Language EnglishSintMaarten = AddLanguage("en-SX", "English (Sint Maarten)");
    public static readonly Language EnglishEswatini = AddLanguage("en-SZ", "English (Eswatini)");
    public static readonly Language EnglishTurksandCaicosIslands = AddLanguage("en-TC", "English (Turks and Caicos Islands)");
    public static readonly Language EnglishTokelau = AddLanguage("en-TK", "English (Tokelau)");
    public static readonly Language EnglishTonga = AddLanguage("en-TO", "English (Tonga)");
    public static readonly Language EnglishTrinidadandTobago = AddLanguage("en-TT", "English (Trinidad and Tobago)");
    public static readonly Language EnglishTuvalu = AddLanguage("en-TV", "English (Tuvalu)");
    public static readonly Language EnglishTanzania = AddLanguage("en-TZ", "English (Tanzania)");
    public static readonly Language EnglishUganda = AddLanguage("en-UG", "English (Uganda)");
    public static readonly Language EnglishUSOutlyingIslands = AddLanguage("en-UM", "English (U.S. Outlying Islands)");
    public static readonly Language EnglishUnitedStates = AddLanguage("en-US", "English (United States)");
    public static readonly Language EnglishSaintVincentandGrenadines = AddLanguage("en-VC", "English (Saint Vincent and Grenadines)");
    public static readonly Language EnglishBritishVirginIslands = AddLanguage("en-VG", "English (British Virgin Islands)");
    public static readonly Language EnglishUSVirginIslands = AddLanguage("en-VI", "English (U.S. Virgin Islands)");
    public static readonly Language EnglishVanuatu = AddLanguage("en-VU", "English (Vanuatu)");
    public static readonly Language EnglishSamoa = AddLanguage("en-WS", "English (Samoa)");
    public static readonly Language EnglishSouthAfrica = AddLanguage("en-ZA", "English (South Africa)");
    public static readonly Language EnglishZambia = AddLanguage("en-ZM", "English (Zambia)");
    public static readonly Language EnglishZimbabwe = AddLanguage("en-ZW", "English (Zimbabwe)");
    public static readonly Language SpanishArgentina = AddLanguage("es-AR", "Spanish (Argentina)");
    public static readonly Language SpanishBolivia = AddLanguage("es-BO", "Spanish (Bolivia)");
    public static readonly Language SpanishBrazil = AddLanguage("es-BR", "Spanish (Brazil)");
    public static readonly Language SpanishBelize = AddLanguage("es-BZ", "Spanish (Belize)");
    public static readonly Language SpanishChile = AddLanguage("es-CL", "Spanish (Chile)");
    public static readonly Language SpanishColombia = AddLanguage("es-CO", "Spanish (Colombia)");
    public static readonly Language SpanishCostaRica = AddLanguage("es-CR", "Spanish (Costa Rica)");
    public static readonly Language SpanishCuba = AddLanguage("es-CU", "Spanish (Cuba)");
    public static readonly Language SpanishDominicanRepublic = AddLanguage("es-DO", "Spanish (Dominican Republic)");
    public static readonly Language SpanishEcuador = AddLanguage("es-EC", "Spanish (Ecuador)");
    public static readonly Language SpanishSpain = AddLanguage("es-ES", "Spanish (Spain)");
    public static readonly Language SpanishEquatorialGuinea = AddLanguage("es-GQ", "Spanish (Equatorial Guinea)");
    public static readonly Language SpanishGuatemala = AddLanguage("es-GT", "Spanish (Guatemala)");
    public static readonly Language SpanishHonduras = AddLanguage("es-HN", "Spanish (Honduras)");
    public static readonly Language SpanishMexico = AddLanguage("es-MX", "Spanish (Mexico)");
    public static readonly Language SpanishNicaragua = AddLanguage("es-NI", "Spanish (Nicaragua)");
    public static readonly Language SpanishPanama = AddLanguage("es-PA", "Spanish (Panama)");
    public static readonly Language SpanishPeru = AddLanguage("es-PE", "Spanish (Peru)");
    public static readonly Language SpanishPhilippines = AddLanguage("es-PH", "Spanish (Philippines)");
    public static readonly Language SpanishPuertoRico = AddLanguage("es-PR", "Spanish (Puerto Rico)");
    public static readonly Language SpanishParaguay = AddLanguage("es-PY", "Spanish (Paraguay)");
    public static readonly Language SpanishElSalvador = AddLanguage("es-SV", "Spanish (El Salvador)");
    public static readonly Language SpanishUnitedStates = AddLanguage("es-US", "Spanish (United States)");
    public static readonly Language SpanishUruguay = AddLanguage("es-UY", "Spanish (Uruguay)");
    public static readonly Language SpanishVenezuela = AddLanguage("es-VE", "Spanish (Venezuela)");
    public static readonly Language EstonianEstonia = AddLanguage("et-EE", "Estonian (Estonia)");
    public static readonly Language BasqueSpain = AddLanguage("eu-ES", "Basque (Spain)");
    public static readonly Language PersianIran = AddLanguage("fa-IR", "Persian (Iran)");
    public static readonly Language FinnishFinland = AddLanguage("fi-FI", "Finnish (Finland)");
    public static readonly Language FaroeseDenmark = AddLanguage("fo-DK", "Faroese (Denmark)");
    public static readonly Language FaroeseFaroeIslands = AddLanguage("fo-FO", "Faroese (Faroe Islands)");
    public static readonly Language FrenchBelgium = AddLanguage("fr-BE", "French (Belgium)");
    public static readonly Language FrenchBurkinaFaso = AddLanguage("fr-BF", "French (Burkina Faso)");
    public static readonly Language FrenchBurundi = AddLanguage("fr-BI", "French (Burundi)");
    public static readonly Language FrenchBenin = AddLanguage("fr-BJ", "French (Benin)");
    public static readonly Language FrenchSaintBarthélemy = AddLanguage("fr-BL", "French (Saint Barthélemy)");
    public static readonly Language FrenchCanada = AddLanguage("fr-CA", "French (Canada)");
    public static readonly Language FrenchCongoDRC = AddLanguage("fr-CD", "French (Congo [DRC])");
    public static readonly Language FrenchCentralAfricanRepublic = AddLanguage("fr-CF", "French (Central African Republic)");
    public static readonly Language FrenchCongo = AddLanguage("fr-CG", "French (Congo)");
    public static readonly Language FrenchSwitzerland = AddLanguage("fr-CH", "French (Switzerland)");
    public static readonly Language FrenchCôtedIvoire = AddLanguage("fr-CI", "French (Côte d’Ivoire)");
    public static readonly Language FrenchCameroon = AddLanguage("fr-CM", "French (Cameroon)");
    public static readonly Language FrenchDjibouti = AddLanguage("fr-DJ", "French (Djibouti)");
    public static readonly Language FrenchAlgeria = AddLanguage("fr-DZ", "French (Algeria)");
    public static readonly Language FrenchFrance = AddLanguage("fr-FR", "French (France)");
    public static readonly Language FrenchGabon = AddLanguage("fr-GA", "French (Gabon)");
    public static readonly Language FrenchFrenchGuiana = AddLanguage("fr-GF", "French (French Guiana)");
    public static readonly Language FrenchGuinea = AddLanguage("fr-GN", "French (Guinea)");
    public static readonly Language FrenchGuadeloupe = AddLanguage("fr-GP", "French (Guadeloupe)");
    public static readonly Language FrenchEquatorialGuinea = AddLanguage("fr-GQ", "French (Equatorial Guinea)");
    public static readonly Language FrenchHaiti = AddLanguage("fr-HT", "French (Haiti)");
    public static readonly Language FrenchComoros = AddLanguage("fr-KM", "French (Comoros)");
    public static readonly Language FrenchLuxembourg = AddLanguage("fr-LU", "French (Luxembourg)");
    public static readonly Language FrenchMorocco = AddLanguage("fr-MA", "French (Morocco)");
    public static readonly Language FrenchMonaco = AddLanguage("fr-MC", "French (Monaco)");
    public static readonly Language FrenchSaintMartin = AddLanguage("fr-MF", "French (Saint Martin)");
    public static readonly Language FrenchMadagascar = AddLanguage("fr-MG", "French (Madagascar)");
    public static readonly Language FrenchMali = AddLanguage("fr-ML", "French (Mali)");
    public static readonly Language FrenchMartinique = AddLanguage("fr-MQ", "French (Martinique)");
    public static readonly Language FrenchMauritania = AddLanguage("fr-MR", "French (Mauritania)");
    public static readonly Language FrenchMauritius = AddLanguage("fr-MU", "French (Mauritius)");
    public static readonly Language FrenchNewCaledonia = AddLanguage("fr-NC", "French (New Caledonia)");
    public static readonly Language FrenchNiger = AddLanguage("fr-NE", "French (Niger)");
    public static readonly Language FrenchFrenchPolynesia = AddLanguage("fr-PF", "French (French Polynesia)");
    public static readonly Language FrenchSaintPierreandMiquelon = AddLanguage("fr-PM", "French (Saint Pierre and Miquelon)");
    public static readonly Language FrenchRéunion = AddLanguage("fr-RE", "French (Réunion)");
    public static readonly Language FrenchRwanda = AddLanguage("fr-RW", "French (Rwanda)");
    public static readonly Language FrenchSeychelles = AddLanguage("fr-SC", "French (Seychelles)");
    public static readonly Language FrenchSenegal = AddLanguage("fr-SN", "French (Senegal)");
    public static readonly Language FrenchSyria = AddLanguage("fr-SY", "French (Syria)");
    public static readonly Language FrenchChad = AddLanguage("fr-TD", "French (Chad)");
    public static readonly Language FrenchTogo = AddLanguage("fr-TG", "French (Togo)");
    public static readonly Language FrenchTunisia = AddLanguage("fr-TN", "French (Tunisia)");
    public static readonly Language FrenchVanuatu = AddLanguage("fr-VU", "French (Vanuatu)");
    public static readonly Language FrenchWallisandFutuna = AddLanguage("fr-WF", "French (Wallis and Futuna)");
    public static readonly Language FrenchMayotte = AddLanguage("fr-YT", "French (Mayotte)");
    public static readonly Language WesternFrisianNetherlands = AddLanguage("fy-NL", "Western Frisian (Netherlands)");
    public static readonly Language IrishIreland = AddLanguage("ga-IE", "Irish (Ireland)");
    public static readonly Language ScottishGaelicUnitedKingdom = AddLanguage("gd-GB", "Scottish Gaelic (United Kingdom)");
    public static readonly Language GalicianSpain = AddLanguage("gl-ES", "Galician (Spain)");
    public static readonly Language GuaraniParaguay = AddLanguage("gn-PY", "Guarani (Paraguay)");
    public static readonly Language GujaratiIndia = AddLanguage("gu-IN", "Gujarati (India)");
    public static readonly Language ManxIsleofMan = AddLanguage("gv-IM", "Manx (Isle of Man)");
    public static readonly Language HebrewIsrael = AddLanguage("he-IL", "Hebrew (Israel)");
    public static readonly Language HindiIndia = AddLanguage("hi-IN", "Hindi (India)");
    public static readonly Language CroatianBosniaandHerzegovina = AddLanguage("hr-BA", "Croatian (Bosnia and Herzegovina)");
    public static readonly Language CroatianCroatia = AddLanguage("hr-HR", "Croatian (Croatia)");
    public static readonly Language HungarianHungary = AddLanguage("hu-HU", "Hungarian (Hungary)");
    public static readonly Language ArmenianArmenia = AddLanguage("hy-AM", "Armenian (Armenia)");
    public static readonly Language IndonesianIndonesia = AddLanguage("id-ID", "Indonesian (Indonesia)");
    public static readonly Language IgboNigeria = AddLanguage("ig-NG", "Igbo (Nigeria)");
    public static readonly Language YiChina = AddLanguage("ii-CN", "Yi (China)");
    public static readonly Language IcelandicIceland = AddLanguage("is-IS", "Icelandic (Iceland)");
    public static readonly Language ItalianSwitzerland = AddLanguage("it-CH", "Italian (Switzerland)");
    public static readonly Language ItalianItaly = AddLanguage("it-IT", "Italian (Italy)");
    public static readonly Language ItalianSanMarino = AddLanguage("it-SM", "Italian (San Marino)");
    public static readonly Language ItalianVaticanCity = AddLanguage("it-VA", "Italian (Vatican City)");
    public static readonly Language InuktitutCanada = AddLanguage("iu-CA", "Inuktitut (Canada)");
    public static readonly Language JapaneseJapan = AddLanguage("ja-JP", "Japanese (Japan)");
    public static readonly Language GeorgianGeorgia = AddLanguage("ka-GE", "Georgian (Georgia)");
    public static readonly Language KikuyuKenya = AddLanguage("ki-KE", "Kikuyu (Kenya)");
    public static readonly Language KazakhKazakhstan = AddLanguage("kk-KZ", "Kazakh (Kazakhstan)");
    public static readonly Language GreenlandicGreenland = AddLanguage("kl-GL", "Greenlandic (Greenland)");
    public static readonly Language KhmerCambodia = AddLanguage("km-KH", "Khmer (Cambodia)");
    public static readonly Language KannadaIndia = AddLanguage("kn-IN", "Kannada (India)");
    public static readonly Language KoreanNorthKorea = AddLanguage("ko-KP", "Korean (North Korea)");
    public static readonly Language KoreanKorea = AddLanguage("ko-KR", "Korean (Korea)");
    public static readonly Language CornishUnitedKingdom = AddLanguage("kw-GB", "Cornish (United Kingdom)");
    public static readonly Language KyrgyzKyrgyzstan = AddLanguage("ky-KG", "Kyrgyz (Kyrgyzstan)");
    public static readonly Language LuxembourgishLuxembourg = AddLanguage("lb-LU", "Luxembourgish (Luxembourg)");
    public static readonly Language GandaUganda = AddLanguage("lg-UG", "Ganda (Uganda)");
    public static readonly Language LingalaAngola = AddLanguage("ln-AO", "Lingala (Angola)");
    public static readonly Language LingalaCongoDRC = AddLanguage("ln-CD", "Lingala (Congo [DRC])");
    public static readonly Language LingalaCentralAfricanRepublic = AddLanguage("ln-CF", "Lingala (Central African Republic)");
    public static readonly Language LingalaCongo = AddLanguage("ln-CG", "Lingala (Congo)");
    public static readonly Language LaoLaos = AddLanguage("lo-LA", "Lao (Laos)");
    public static readonly Language LithuanianLithuania = AddLanguage("lt-LT", "Lithuanian (Lithuania)");
    public static readonly Language LubaKatangaCongoDRC = AddLanguage("lu-CD", "Luba-Katanga (Congo [DRC])");
    public static readonly Language LatvianLatvia = AddLanguage("lv-LV", "Latvian (Latvia)");
    public static readonly Language MalagasyMadagascar = AddLanguage("mg-MG", "Malagasy (Madagascar)");
    public static readonly Language MaoriNewZealand = AddLanguage("mi-NZ", "Maori (New Zealand)");
    public static readonly Language MacedonianMacedoniaFYRO = AddLanguage("mk-MK", "Macedonian (Macedonia, FYRO)");
    public static readonly Language MalayalamIndia = AddLanguage("ml-IN", "Malayalam (India)");
    public static readonly Language MongolianMongolia = AddLanguage("mn-MN", "Mongolian (Mongolia)");
    public static readonly Language MarathiIndia = AddLanguage("mr-IN", "Marathi (India)");
    public static readonly Language MalayBrunei = AddLanguage("ms-BN", "Malay (Brunei)");
    public static readonly Language MalayMalaysia = AddLanguage("ms-MY", "Malay (Malaysia)");
    public static readonly Language MalaySingapore = AddLanguage("ms-SG", "Malay (Singapore)");
    public static readonly Language MalteseMalta = AddLanguage("mt-MT", "Maltese (Malta)");
    public static readonly Language BurmeseMyanmar = AddLanguage("my-MM", "Burmese (Myanmar)");
    public static readonly Language NorwegianBokmålNorway = AddLanguage("nb-NO", "Norwegian Bokmål (Norway)");
    public static readonly Language NorwegianBokmålSvalbardandJanMayen = AddLanguage("nb-SJ", "Norwegian Bokmål (Svalbard and Jan Mayen)");
    public static readonly Language NorthNdebeleZimbabwe = AddLanguage("nd-ZW", "North Ndebele (Zimbabwe)");
    public static readonly Language NepaliIndia = AddLanguage("ne-IN", "Nepali (India)");
    public static readonly Language NepaliNepal = AddLanguage("ne-NP", "Nepali (Nepal)");
    public static readonly Language DutchAruba = AddLanguage("nl-AW", "Dutch (Aruba)");
    public static readonly Language DutchBelgium = AddLanguage("nl-BE", "Dutch (Belgium)");
    public static readonly Language DutchBonaireSintEustatiusandSaba = AddLanguage("nl-BQ", "Dutch (Bonaire, Sint Eustatius and Saba)");
    public static readonly Language DutchCuraçao = AddLanguage("nl-CW", "Dutch (Curaçao)");
    public static readonly Language DutchNetherlands = AddLanguage("nl-NL", "Dutch (Netherlands)");
    public static readonly Language DutchSuriname = AddLanguage("nl-SR", "Dutch (Suriname)");
    public static readonly Language DutchSintMaarten = AddLanguage("nl-SX", "Dutch (Sint Maarten)");
    public static readonly Language NorwegianNynorskNorway = AddLanguage("nn-NO", "Norwegian Nynorsk (Norway)");
    public static readonly Language SouthNdebeleSouthAfrica = AddLanguage("nr-ZA", "South Ndebele (South Africa)");
    public static readonly Language OromoEthiopia = AddLanguage("om-ET", "Oromo (Ethiopia)");
    public static readonly Language OromoKenya = AddLanguage("om-KE", "Oromo (Kenya)");
    public static readonly Language OdiaIndia = AddLanguage("or-IN", "Odia (India)");
    public static readonly Language PolishPoland = AddLanguage("pl-PL", "Polish (Poland)");
    public static readonly Language PashtoAfghanistan = AddLanguage("ps-AF", "Pashto (Afghanistan)");
    public static readonly Language PortugueseAngola = AddLanguage("pt-AO", "Portuguese (Angola)");
    public static readonly Language PortugueseBrazil = AddLanguage("pt-BR", "Portuguese (Brazil)");
    public static readonly Language PortugueseSwitzerland = AddLanguage("pt-CH", "Portuguese (Switzerland)");
    public static readonly Language PortugueseCaboVerde = AddLanguage("pt-CV", "Portuguese (Cabo Verde)");
    public static readonly Language PortugueseEquatorialGuinea = AddLanguage("pt-GQ", "Portuguese (Equatorial Guinea)");
    public static readonly Language PortugueseGuineaBissau = AddLanguage("pt-GW", "Portuguese (Guinea-Bissau)");
    public static readonly Language PortugueseLuxembourg = AddLanguage("pt-LU", "Portuguese (Luxembourg)");
    public static readonly Language PortugueseMacaoSAR = AddLanguage("pt-MO", "Portuguese (Macao SAR)");
    public static readonly Language PortugueseMozambique = AddLanguage("pt-MZ", "Portuguese (Mozambique)");
    public static readonly Language PortuguesePortugal = AddLanguage("pt-PT", "Portuguese (Portugal)");
    public static readonly Language PortugueseSãoToméandPríncipe = AddLanguage("pt-ST", "Portuguese (São Tomé and Príncipe)");
    public static readonly Language PortugueseTimorLeste = AddLanguage("pt-TL", "Portuguese (Timor-Leste)");
    public static readonly Language RomanshSwitzerland = AddLanguage("rm-CH", "Romansh (Switzerland)");
    public static readonly Language RundiBurundi = AddLanguage("rn-BI", "Rundi (Burundi)");
    public static readonly Language RomanianMoldova = AddLanguage("ro-MD", "Romanian (Moldova)");
    public static readonly Language RomanianRomania = AddLanguage("ro-RO", "Romanian (Romania)");
    public static readonly Language RussianBelarus = AddLanguage("ru-BY", "Russian (Belarus)");
    public static readonly Language RussianKyrgyzstan = AddLanguage("ru-KG", "Russian (Kyrgyzstan)");
    public static readonly Language RussianKazakhstan = AddLanguage("ru-KZ", "Russian (Kazakhstan)");
    public static readonly Language RussianMoldova = AddLanguage("ru-MD", "Russian (Moldova)");
    public static readonly Language RussianRussia = AddLanguage("ru-RU", "Russian (Russia)");
    public static readonly Language RussianUkraine = AddLanguage("ru-UA", "Russian (Ukraine)");
    public static readonly Language KinyarwandaRwanda = AddLanguage("rw-RW", "Kinyarwanda (Rwanda)");
    public static readonly Language SanskritIndia = AddLanguage("sa-IN", "Sanskrit (India)");
    public static readonly Language NorthernSamiFinland = AddLanguage("se-FI", "Northern Sami (Finland)");
    public static readonly Language NorthernSamiNorway = AddLanguage("se-NO", "Northern Sami (Norway)");
    public static readonly Language NorthernSamiSweden = AddLanguage("se-SE", "Northern Sami (Sweden)");
    public static readonly Language SangoCentralAfricanRepublic = AddLanguage("sg-CF", "Sango (Central African Republic)");
    public static readonly Language SinhalaSriLanka = AddLanguage("si-LK", "Sinhala (Sri Lanka)");
    public static readonly Language SlovakSlovakia = AddLanguage("sk-SK", "Slovak (Slovakia)");
    public static readonly Language SlovenianSlovenia = AddLanguage("sl-SI", "Slovenian (Slovenia)");
    public static readonly Language SomaliDjibouti = AddLanguage("so-DJ", "Somali (Djibouti)");
    public static readonly Language SomaliEthiopia = AddLanguage("so-ET", "Somali (Ethiopia)");
    public static readonly Language SomaliKenya = AddLanguage("so-KE", "Somali (Kenya)");
    public static readonly Language SomaliSomalia = AddLanguage("so-SO", "Somali (Somalia)");
    public static readonly Language AlbanianAlbania = AddLanguage("sq-AL", "Albanian (Albania)");
    public static readonly Language AlbanianMacedoniaFYRO = AddLanguage("sq-MK", "Albanian (Macedonia, FYRO)");
    public static readonly Language AlbanianKosovo = AddLanguage("sq-XK", "Albanian (Kosovo)");
    public static readonly Language siSwatiEswatini = AddLanguage("ss-SZ", "siSwati (Eswatini)");
    public static readonly Language siSwatiSouthAfrica = AddLanguage("ss-ZA", "siSwati (South Africa)");
    public static readonly Language SesothoLesotho = AddLanguage("st-LS", "Sesotho (Lesotho)");
    public static readonly Language SesothoSouthAfrica = AddLanguage("st-ZA", "Sesotho (South Africa)");
    public static readonly Language SwedishÅlandIslands = AddLanguage("sv-AX", "Swedish (Åland Islands)");
    public static readonly Language SwedishFinland = AddLanguage("sv-FI", "Swedish (Finland)");
    public static readonly Language SwedishSweden = AddLanguage("sv-SE", "Swedish (Sweden)");
    public static readonly Language KiswahiliCongoDRC = AddLanguage("sw-CD", "Kiswahili (Congo [DRC])");
    public static readonly Language KiswahiliKenya = AddLanguage("sw-KE", "Kiswahili (Kenya)");
    public static readonly Language KiswahiliTanzania = AddLanguage("sw-TZ", "Kiswahili (Tanzania)");
    public static readonly Language KiswahiliUganda = AddLanguage("sw-UG", "Kiswahili (Uganda)");
    public static readonly Language TamilIndia = AddLanguage("ta-IN", "Tamil (India)");
    public static readonly Language TamilSriLanka = AddLanguage("ta-LK", "Tamil (Sri Lanka)");
    public static readonly Language TamilMalaysia = AddLanguage("ta-MY", "Tamil (Malaysia)");
    public static readonly Language TamilSingapore = AddLanguage("ta-SG", "Tamil (Singapore)");
    public static readonly Language TeluguIndia = AddLanguage("te-IN", "Telugu (India)");
    public static readonly Language ThaiThailand = AddLanguage("th-TH", "Thai (Thailand)");
    public static readonly Language TigrinyaEritrea = AddLanguage("ti-ER", "Tigrinya (Eritrea)");
    public static readonly Language TigrinyaEthiopia = AddLanguage("ti-ET", "Tigrinya (Ethiopia)");
    public static readonly Language TurkmenTurkmenistan = AddLanguage("tk-TM", "Turkmen (Turkmenistan)");
    public static readonly Language SetswanaBotswana = AddLanguage("tn-BW", "Setswana (Botswana)");
    public static readonly Language SetswanaSouthAfrica = AddLanguage("tn-ZA", "Setswana (South Africa)");
    public static readonly Language TonganTonga = AddLanguage("to-TO", "Tongan (Tonga)");
    public static readonly Language TurkishCyprus = AddLanguage("tr-CY", "Turkish (Cyprus)");
    public static readonly Language TurkishTurkey = AddLanguage("tr-TR", "Turkish (Turkey)");
    public static readonly Language XitsongaSouthAfrica = AddLanguage("ts-ZA", "Xitsonga (South Africa)");
    public static readonly Language TatarRussia = AddLanguage("tt-RU", "Tatar (Russia)");
    public static readonly Language UyghurChina = AddLanguage("ug-CN", "Uyghur (China)");
    public static readonly Language UkrainianUkraine = AddLanguage("uk-UA", "Ukrainian (Ukraine)");
    public static readonly Language UrduIndia = AddLanguage("ur-IN", "Urdu (India)");
    public static readonly Language UrduPakistan = AddLanguage("ur-PK", "Urdu (Pakistan)");
    public static readonly Language VendaSouthAfrica = AddLanguage("ve-ZA", "Venda (South Africa)");
    public static readonly Language VietnameseVietnam = AddLanguage("vi-VN", "Vietnamese (Vietnam)");
    public static readonly Language WolofSenegal = AddLanguage("wo-SN", "Wolof (Senegal)");
    public static readonly Language isiXhosaSouthAfrica = AddLanguage("xh-ZA", "isiXhosa (South Africa)");
    public static readonly Language YorubaBenin = AddLanguage("yo-BJ", "Yoruba (Benin)");
    public static readonly Language YorubaNigeria = AddLanguage("yo-NG", "Yoruba (Nigeria)");
    public static readonly Language ChineseChina = AddLanguage("zh-CN", "Chinese (China)");
    public static readonly Language ChineseSingapore = AddLanguage("zh-SG", "Chinese (Singapore)");
    public static readonly Language ChineseHongKongSAR = AddLanguage("zh-HK", "Chinese (Hong Kong SAR)");
    public static readonly Language ChineseMacaoSAR = AddLanguage("zh-MO", "Chinese (Macao SAR)");
    public static readonly Language ChineseTaiwan = AddLanguage("zh-TW", "Chinese (Taiwan)");
    public static readonly Language isiZuluSouthAfrica = AddLanguage("zu-ZA", "isiZulu (South Africa)");
}
