﻿// ==========================================================================
//  Notifo.io
// ==========================================================================
//  Copyright (c) Sebastian Stehle
//  All rights reserved. Licensed under the MIT license.
// ==========================================================================

using Notifo.Domain.Integrations.Resources;

namespace Notifo.Domain.Integrations.Mailchimp;

public sealed partial class MailchimpIntegration : IIntegration
{
    private readonly IHttpClientFactory httpClientFactory;

    public static readonly IntegrationProperty ApiKeyProperty = new IntegrationProperty("apiKey", PropertyType.Password)
    {
        EditorLabel = Texts.Mailchimp_ApiKeyLabel,
        EditorDescription = null,
        IsRequired = true
    };

    public static readonly IntegrationProperty FromEmailProperty = new IntegrationProperty("fromEmail", PropertyType.Text)
    {
        EditorLabel = Texts.Email_FromEmailLabel,
        EditorDescription = Texts.Email_FromEmailDescription,
        IsRequired = true,
        Summary = true,
        Format = PropertyFormat.Email
    };

    public static readonly IntegrationProperty FromNameProperty = new IntegrationProperty("fromName", PropertyType.Text)
    {
        EditorLabel = Texts.Email_FromNameLabel,
        EditorDescription = Texts.Email_FromNameDescription,
        IsRequired = true
    };

    public IntegrationDefinition Definition { get; }
        = new IntegrationDefinition(
            "Mailchimp",
            Texts.Mailchimp_Name,
            "<svg id='Layer_1' style='enable-background:new 0 0 56.7 56.7;' version='1.1' viewBox='0 0 56.7 56.7' xml:space='preserve' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink'><g><path d='M51.1,35.8c-0.3-0.7-1-1.2-1.8-1.4c-0.3-1.3-0.7-1.9-0.7-2c0.1-0.2,0.3-0.3,0.3-0.4c1.2-1.4,0.4-3.5-1.6-4   c-1.1-1.1-2.1-1.6-3-2c-0.8-0.4-0.5-0.2-1.2-0.6c-0.2-1-0.3-3.2-0.6-4.8c-0.3-1.4-0.9-2.5-1.7-3.1c-0.4-0.8-0.8-1.5-1.4-2.1   c2.8-4.2,3.5-8.4,1.5-10.6c-0.9-1-2.2-1.4-3.8-1.4c-2.3,0-5,0.9-7.8,2.6c0,0-1.8-1.5-1.9-1.5c-7.8-6.1-29.9,21-22.1,26.9l2,1.5   c-1.3,3.5,0.5,7.7,4.2,9c0.8,0.3,1.7,0.4,2.6,0.4c0,0,5.9,10.8,18.4,10.8c14.4,0,18.1-14.1,18.1-14.2C50.5,39,51.7,37.2,51.1,35.8z    M5.8,29.6C4.3,26.9,7,21.5,9,18.3c4.8-7.7,12.9-13.8,16.6-12.9l1-0.4c0,0,2.7,2.3,2.8,2.3c1.9-1.1,4.3-2.3,6.5-2.5   c-1.4,0.3-3,1-5,2.2c0,0-4.7,3.2-7.5,6c-1.5,1.5-7.7,9-7.7,8.9c1.1-2.1,1.9-3.2,3.7-5.4c1-1.3,2.1-2.5,3.2-3.7c0.5-0.5,1-1,1.6-1.5   c0.4-0.3,0.7-0.7,1.1-1c0.2-0.1,0.3-0.3,0.5-0.4c0,0,0,0,0,0l-3.6-3l0.2,1.3l2.6,2.3c0,0-2.3,1.6-3.5,2.6c-4.7,4-9.2,10.1-10.9,16   l0.1,0c-0.8,0.5-1.7,1.2-2.4,2.2C8,31.4,6.1,30.1,5.8,29.6z M13.5,40.7c-2.8,0-5-2.4-5-5.3c0-2.9,2.3-5.3,5-5.3   c0.7,0,1.4,0.2,2,0.4c0,0,1.1,0.5,1.4,3.1c0,0,0,0,0,0c0,0,0,0,0,0c0.3-0.8,0.5-1.5,0.5-1.5c0.4,1.1,0.5,2.3,0.5,3.4l0,0v0   c0.3-0.4,0.6-1.1,0.6-1.1C19.1,37.8,16.7,40.7,13.5,40.7z M19.7,22L19.7,22c0,0,2.2-4.1,6.9-6.9c-0.4-0.1-1.2,0.1-1.4,0.1   c0.9-0.7,2.5-1.2,3.6-1.5c-0.3-0.2-1.1-0.3-1.5-0.3c-0.1,0-0.1,0-0.2,0c1-0.6,3-0.9,4.7-0.6c-0.2-0.3-0.7-0.5-1.1-0.6   c0,0-0.2,0-0.2,0s0.1,0,0.1,0c1.1-0.2,2.3,0,3.3,0.4c-0.1-0.3-0.4-0.6-0.6-0.8c0,0-0.1-0.1-0.1-0.1c1,0.2,2,0.7,2.8,1.2   c-0.1-0.2-0.3-0.5-0.5-0.7c1,0.3,2.1,1,2.6,2h0c0,0,0,0.1,0,0.1c0,0,0,0,0,0c-1.9-1.4-7.3-1-12.7,2.5C23,18.4,21.1,20.1,19.7,22z    M49.1,38.3c-0.1,0.1-0.7,3.8-4.7,6.9c-4.9,3.9-11.4,3.5-13.9,1.3c-1.3-1.2-1.9-3-1.9-3s-0.1,1-0.2,1.4c-1-1.7-0.9-3.7-0.9-3.7   s-0.5,1-0.8,1.5c-0.7-1.9-0.4-3.8-0.4-3.8l-0.6,0.9c0,0-0.3-2.1,0.4-3.8c0.7-1.9,2.1-3.2,2.4-3.4c-1-0.3-2.2-1.3-2.2-1.3   c0,0,0.5,0,0.8,0c0,0-2.1-1.5-2.5-3.8c0.3,0.4,0.9,0.8,0.9,0.8c-0.2-0.6-0.3-1.9-0.1-3.3l0,0c0.4-2.5,2.5-4.2,4.8-4.2   c2.5,0,4.2,0.5,6.3-1.4c0.4-0.4,0.8-0.8,1.4-0.9c0.1,0,0.2-0.1,0.6-0.1c0.3,0,0.7,0.1,1,0.3c1.1,0.7,1.4,2.5,1.5,3.8   c0.5,4.8,0.3,4,2.2,5c0.9,0.5,2,0.9,3.2,2.2c0,0,0,0,0,0s0,0,0,0c1,0,1.5,0.8,1.1,1.4c-3.4,4-8.1,5.9-13.3,6.1c-0.2,0-0.7,0-0.7,0   c-2.1,0.1-2.8,2.8-1.5,4.4c0.8,1,2.5,1.4,3.8,1.4l0,0c5.7,0.1,11.5-3.9,12.5-6.2c0,0,0.1-0.2,0.1-0.2c-0.2,0.3-5.8,5.5-12.6,5.3   c0,0-0.7,0-1.4-0.2c-0.9-0.2-1.6-0.6-1.9-1.5c0.6,0.1,1.3,0.2,2.1,0.2c4.9,0,8.4-2.2,8.1-2.3c0,0,0,0-0.1,0   c-0.6,0.1-6.5,2.4-10.2,1.2c0-0.1,0-0.2,0.1-0.3c0.3-1.1,0.9-1,1.9-1l0,0c3.4-0.1,6.1-1,8.2-1.9c2.2-1,3.9-2.4,4.5-3.1   c0.8,1.3,0.8,3,0.8,3s0.3-0.1,0.7-0.1C49.8,36,50,37.1,49.1,38.3z'/><polygon points='25.4,7.2 26.1,7.4 25.5,5.4 25.2,6.4  '/><path d='M28.4,7.9L27.3,7l0.4,1.4C27.9,8.2,28.1,8.1,28.4,7.9z'/><path d='M38.5,25.8c0.6,0,1.1,0.1,1.6,0.3c0-1.4-0.8-2.9-1.4-2.7l0,0c0,0,0,0,0,0l0,0c-0.4,0.1-0.4,0.7-0.4,1.1   C38.3,25,38.3,25.4,38.5,25.8z'/><path d='M27.2,8.7L24.9,8l1.5,1.3C26.7,9.1,26.9,8.9,27.2,8.7z'/><path d='M33.1,27.8c0.5,0.2,0.8,0.3,0.8,0.2c0,0,0-0.2-0.1-0.3c-0.3-0.4-0.8-0.8-1.3-0.9c-1.1-0.4-2.4-0.2-3.3,0.6   c-0.5,0.4-0.7,0.8-0.5,0.8c0.1,0,0.4-0.1,0.8-0.2C31.1,27.3,31.9,27.3,33.1,27.8z'/><path d='M33.2,29.1c0.3,0,0.5,0,0.5,0c0.1-0.2-0.6-0.7-1.7-0.6c-0.1,0-0.2,0.1-0.4,0.1c0,0-0.1,0-0.1,0c-0.2,0.1-0.5,0.2-0.7,0.4   c-0.2,0.2-0.3,0.4-0.2,0.5c0.1,0.1,0.2,0,0.5-0.1C32,29.1,32.6,29.1,33.2,29.1z'/><polygon points='10.4,35.7 10.4,35.7 10.4,35.7  '/><path d='M15.3,33.6c0.3,0.4,0.2,0.6,0.3,0.7c0,0,0.1,0.1,0.2,0c0.2-0.1,0.2-0.3,0.2-0.5h0c0,0,0,0,0,0h0c0-0.4-0.2-0.9-0.5-1.2   c0,0,0,0,0,0l0,0c-0.4-0.4-0.9-0.8-1.6-0.9c-0.6-0.1-1.2,0-1.3,0.1l0,0c-0.1,0-0.2,0-0.3,0.1c-1.6,0.6-2.3,2.2-2,3.7   c0.1,0.4,0.3,0.8,0.5,1.1v0c0,0,0,0,0,0v0c0.3,0.4,0.7,0.3,0.5,0c0-0.1-0.2-0.5-0.3-1.1c0-0.7,0.1-1.4,0.6-2   c0.3-0.4,0.7-0.6,0.8-0.6v0c0.1,0,0.1-0.1,0.2-0.1c0,0,0.1,0,0.1,0c0.2-0.1,0.1,0,0.3-0.1l0,0C14.2,32.6,15,33.1,15.3,33.6z'/><path d='M14.8,34.8c-0.1-0.1-0.2-0.2-0.2-0.3c0-0.2,0-0.3,0.2-0.4c0.1-0.1,0.2-0.1,0.2-0.2c0-0.1-0.4-0.2-0.8,0.1   c-0.3,0.3-0.3,0.9,0.1,1.3c0.5,0.5,1.2,0.6,1.3,1.2c0,0.1,0,0.2,0,0.3c0,0.1,0,0.3,0,0.3c-0.1,0.6-0.7,1.2-1.7,1   c-0.2,0-0.3,0-0.3,0c-0.1,0.1,0.3,0.6,1.1,0.5c1.1,0,1.9-1.1,1.7-2.3C16.3,35.3,15.2,35.1,14.8,34.8z'/><ellipse cx='40' cy='28' rx='0.7' ry='0.5' transform='matrix(0.1541 -0.9881 0.9881 0.1541 6.2187 63.2376)'/><ellipse cx='37.7' cy='28.8' rx='0.6' ry='0.8' transform='matrix(0.4806 -0.877 0.877 0.4806 -5.6797 48.0401)'/></g></svg>",
            [
                ApiKeyProperty,
                FromEmailProperty,
                FromNameProperty
            ],
            [],
            new HashSet<string>
            {
                Providers.Email
            })
        {
            Description = Texts.Mailchimp_Description
        };

    public MailchimpIntegration(IHttpClientFactory httpClientFactory)
    {
        this.httpClientFactory = httpClientFactory;
    }
}
