/** Removes an item from an array if it exists. It returns whether it was removed or not */
export const removeFromList = (item, list) => {
    if (!list)
        return false;
    const index = list.indexOf(item);
    if (index !== -1) {
        list.splice(index, 1);
        return true;
    }
    return false;
};
export const camelToDash = str => str.replace(/([A-Z])/g, val => `-${val.toLowerCase()}`);
export const isObject = (obj) => {
    return typeof obj === 'object' && !(obj instanceof Array);
};
export const isArray = (obj) => {
    return Object.prototype.toString.call(obj) === '[object Array]';
};
export const val = (val, ...args) => {
    if (typeof val === 'function') {
        return val(...args);
    }
    return val;
};
export const swapItems = (array, from, to) => {
    const temp = array[from];
    array[from] = array[to];
    array[to] = temp;
    return array;
};
export const arraysEqual = (a, b) => {
    if (a === b)
        return true;
    if (a == null || b == null)
        return false;
    if (a.length !== b.length)
        return false;
    // If you don't care about the order of the elements inside
    // the array, you should sort both arrays here.
    // Please note that calling sort on an array will modify that array.
    // you might want to clone your array first.
    for (let i = 0; i < a.length; ++i) {
        if (a[i] !== b[i])
            return false;
    }
    return true;
};
/* eslint-disable  */
/* istanbul ignore next */
export const deepEquals = (a, b) => {
    if (a === b)
        return true;
    if (a && b && a.length !== b.length)
        return false;
    if (a && b && typeof a == 'object' && typeof b == 'object') {
        if (a.constructor !== b.constructor)
            return false;
        var length, i, keys;
        if (Array.isArray(a)) {
            length = a.length;
            if (length != b.length)
                return false;
            for (i = length; i-- !== 0;)
                if (!deepEquals(a[i], b[i]))
                    return false;
            return true;
        }
        if (a.constructor === RegExp)
            return a.source === b.source && a.flags === b.flags;
        if (a.valueOf !== Object.prototype.valueOf)
            return a.valueOf() === b.valueOf();
        if (a.toString !== Object.prototype.toString)
            return a.toString() === b.toString();
        keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length)
            return false;
        for (i = length; i-- !== 0;)
            if (!Object.prototype.hasOwnProperty.call(b, keys[i]))
                return false;
        for (i = length; i-- !== 0;) {
            var key = keys[i];
            if (!deepEquals(a[key], b[key]))
                return false;
        }
        return true;
    }
    // true if both NaN, false otherwise
    return a !== a && b !== b;
};
//# sourceMappingURL=util.js.map