﻿# Прокси-сервер на `ASP.NET`

Этот проект реализует простой HTTP-сервер на ASP.NET для проксирования запросов к сторонним сервисам.

## Описание

Сервер принимает HTTP-запросы от клиентов, извлекает из них данные, отправляет запросы к сторонним сервисам, получает их ответы и возвращает результат клиенту в формате JSON. Запросы и ответы сохраняются локально в памяти.

## Формат входящего запроса

Сервер ожидает запрос в формате JSON с полями:

```
{
"method": "GET",
"url": "http://example.com",
"headers": { "Authorization": "Bearer your_access_token" }
}
```

## Формат ответа

Ответ клиенту должен быть в формате JSON с полями:

```
{
"id": "requestId",
"status": <HTTP-статус ответа стороннего сервиса>,
"headers": { "массив заголовков из ответа стороннего сервиса" },
"length": <длина содержимого ответа>
}
```

## Установка и запуск

### Требования

- .NET SDK 8.0 или выше
- Docker (для контейнеризации)

### Шаги установки:

1. Клонируйте репозиторий:
```
   git clone <URL репозитория>
   cd ProxyServer
```

3. Соберите проект:
```
   dotnet build
```

5. Запустите сервер:
```
   dotnet run
```

Сервер будет запущен на http://localhost:44331.

### Использование

Для использования сервера отправьте POST-запрос на http://localhost:44331/Proxy/proxy с JSON-телом, содержащим метод, URL и заголовки запроса:

```
{
"method": "GET",
"url": "http://example.com",
"headers": {
"Authorization": "Bearer your_access_token"
}
```

Сервер отправит запрос по указанному URL, получит ответ от стороннего сервиса и вернет JSON-ответ с информацией о запросе и ответе.

### Docker

Вы также можете запустить сервер в Docker контейнере.

#### Сборка и запуск Docker контейнера:

1. Соберите Docker образ:
```
   docker-compose build
```

3. Запустите Docker контейнер:
```
   docker-compose up -d
```

Сервер будет доступен на http://localhost:8080.

### Makefile

Для автоматизации команд используйте Makefile.

#### Команды Makefile:

- build: Сборка Docker образа
  
```
  make build
```


- run: Запуск Docker контейнера

```
  make run
```

- stop: Остановка Docker контейнера

```
  make stop
```

## Render link

<a href="https://proxy-server-zro1.onrender.com/Proxy/proxy">https://proxy-server-zro1.onrender.com/Proxy/proxy</a>

## Документация

Дополнительную информацию о проекте можно найти в [Wiki](https://github.com/nomadbala/proxy-server/wiki).

## Лицензия

Этот проект лицензирован под лицензией MIT. Подробности см. в файле LICENSE.
