/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package dev.navids.soottutorial;

import dev.navids.soottutorial.basicapi.BasicAPI;
import org.junit.Test;
import soot.*;
import soot.jimple.JimpleBody;

import java.io.File;
import java.util.Arrays;

import static org.junit.Assert.*;

public class BasicAPITest {
    @Test public void testClassFilesExist() {
        for(String extension: Arrays.asList(".class", ".java")){
            File fileName = new File(BasicAPI.sourceDirectory+File.separator+ BasicAPI.circleClassName+extension);
            assertTrue(fileName.exists());
        }
    }

    @Test public void testSetup() {
        BasicAPI.setupSoot();
        assertEquals(1, Scene.v().getApplicationClasses().size());
        for(SootClass sootClass : Scene.v().getApplicationClasses()){
            assertFalse(sootClass.isPhantom());
            for(SootMethod sootMethod : sootClass.getMethods()){
                assertFalse(sootMethod.isPhantom());
                assertTrue(sootMethod.hasActiveBody());
            }
        }
        SootClass circleClass = Scene.v().getSootClass(BasicAPI.circleClassName);
        assertNotNull(circleClass.getMethodByNameUnsafe("getCircleCount"));
        assertNotNull(circleClass.getFieldUnsafe("int radius"));
        assertNotNull(circleClass.getFieldUnsafe("double PI"));
        assertEquals(1, circleClass.getMethod("int area(boolean)").getActiveBody().getTraps().size());
    }
    @Test public void testCallGraph(){
        BasicAPI.setupSoot();
        SootClass circleClass = Scene.v().getSootClass(BasicAPI.circleClassName);
        SootMethod areaMethod = circleClass.getMethod("int area(boolean)");
        assertTrue(Scene.v().getCallGraph().edgesOutOf(areaMethod).hasNext());
    }
}
