/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source.parsers.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.android.source.parsers.xml.ResourceUtils;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.FieldSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class XMLSourceSinkParser
implements ISourceSinkDefinitionProvider {
    private static final Logger logger = LoggerFactory.getLogger(XMLSourceSinkParser.class);
    protected Map<String, IAccessPathBasedSourceSinkDefinition> sourcesAndSinks;
    protected Set<IAccessPathBasedSourceSinkDefinition> sources = new HashSet<IAccessPathBasedSourceSinkDefinition>();
    protected Set<IAccessPathBasedSourceSinkDefinition> sinks = new HashSet<IAccessPathBasedSourceSinkDefinition>();
    protected ICategoryFilter categoryFilter = null;
    protected final Map<CategoryDefinition, CategoryDefinition> categories = new HashMap<CategoryDefinition, CategoryDefinition>();
    protected static final String XSD_FILE_PATH = "schema/SourcesAndSinks.xsd";
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static XMLSourceSinkParser fromFile(String fileName) throws IOException {
        return XMLSourceSinkParser.fromFile(fileName, null);
    }

    public static XMLSourceSinkParser fromFile(String fileName, ICategoryFilter categoryFilter) throws IOException {
        logger.info(String.format("Loading sources and sinks from %s...", fileName));
        try (InputStream is = XMLSourceSinkParser.getStream(fileName);){
            XMLSourceSinkParser.verifyXML(is);
        }
        var3_3 = null;
        try (InputStream inputStream = XMLSourceSinkParser.getStream(fileName);){
            XMLSourceSinkParser xMLSourceSinkParser = XMLSourceSinkParser.fromStream(inputStream, categoryFilter);
            return xMLSourceSinkParser;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    protected static InputStream getStream(String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        return ResourceUtils.getResourceStream(fileName);
    }

    public static XMLSourceSinkParser fromStream(InputStream inputStream) throws IOException {
        return XMLSourceSinkParser.fromStream(inputStream, null);
    }

    public static XMLSourceSinkParser fromStream(InputStream inputStream, ICategoryFilter categoryFilter) throws IOException {
        XMLSourceSinkParser pmp = new XMLSourceSinkParser(categoryFilter);
        pmp.parseInputStream(inputStream);
        return pmp;
    }

    public Set<IAccessPathBasedSourceSinkDefinition> getSources() {
        return this.sources;
    }

    public Set<IAccessPathBasedSourceSinkDefinition> getSinks() {
        return this.sinks;
    }

    private CategoryDefinition getOrMakeCategory(CategoryDefinition.CATEGORY systemCategory, String customCategory, String customDescription) {
        CategoryDefinition keyDef = new CategoryDefinition(systemCategory, customCategory);
        CategoryDefinition newDef = new CategoryDefinition(systemCategory, customCategory, customDescription);
        CategoryDefinition existingDef = this.categories.putIfAbsent(keyDef, newDef);
        return existingDef == null ? newDef : existingDef;
    }

    protected XMLSourceSinkParser(ICategoryFilter categoryFilter) {
        this.sourcesAndSinks = new HashMap<String, IAccessPathBasedSourceSinkDefinition>();
        this.categoryFilter = categoryFilter;
    }

    protected void parseInputStream(InputStream stream) {
        SAXParserFactory pf = SAXParserFactory.newInstance();
        try {
            SAXParser parser = pf.newSAXParser();
            parser.parse(stream, (DefaultHandler)new SAXHandler());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buildSourceSinkLists();
    }

    protected void buildSourceSinkLists() {
        for (IAccessPathBasedSourceSinkDefinition def : this.sourcesAndSinks.values()) {
            MethodSourceSinkDefinition methodSink;
            IAccessPathBasedSourceSinkDefinition sinkDef;
            IAccessPathBasedSourceSinkDefinition sourceDef = def.getSourceOnlyDefinition();
            if (sourceDef != null && !sourceDef.isEmpty()) {
                MethodSourceSinkDefinition methodSrc;
                if (sourceDef instanceof MethodSourceSinkDefinition && (methodSrc = (MethodSourceSinkDefinition)sourceDef).getMethod() instanceof AndroidMethod) {
                    AndroidMethod am = (AndroidMethod)methodSrc.getMethod();
                    am.setSourceSinkType(am.getSourceSinkType().addType(SourceSinkType.Source));
                }
                this.sources.add(sourceDef);
            }
            if ((sinkDef = def.getSinkOnlyDefinition()) == null || sinkDef.isEmpty()) continue;
            if (sourceDef instanceof MethodSourceSinkDefinition && (methodSink = (MethodSourceSinkDefinition)sourceDef).getMethod() instanceof AndroidMethod) {
                AndroidMethod am = (AndroidMethod)methodSink.getMethod();
                am.setSourceSinkType(am.getSourceSinkType().addType(SourceSinkType.Sink));
            }
            this.sinks.add(sinkDef);
        }
        logger.info(String.format("Loaded %d sources and %d sinks from the XML file", this.sources.size(), this.sinks.size()));
    }

    private static void verifyXML(InputStream inp) throws IOException {
        SchemaFactory sf = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        StreamSource xsdFile = new StreamSource(ResourceUtils.getResourceStream(XSD_FILE_PATH));
        StreamSource xmlFile = new StreamSource(inp);
        try {
            Schema schema = sf.newSchema(xsdFile);
            Validator validator = schema.newValidator();
            try {
                validator.validate(xmlFile);
            }
            catch (IOException e) {
                throw new IOException("File isn't  valid against the xsd", e);
            }
        }
        catch (SAXException e) {
            throw new IOException("File isn't  valid against the xsd", e);
        }
        finally {
            xsdFile.getInputStream().close();
            xmlFile.getInputStream().close();
        }
    }

    public Set<IAccessPathBasedSourceSinkDefinition> getAllMethods() {
        HashSet<IAccessPathBasedSourceSinkDefinition> sourcesSinks = new HashSet<IAccessPathBasedSourceSinkDefinition>(this.sources.size() + this.sinks.size());
        sourcesSinks.addAll(this.sources);
        sourcesSinks.addAll(this.sinks);
        return sourcesSinks;
    }

    protected void addSourceSinkDefinition(String signature, IAccessPathBasedSourceSinkDefinition ssd) {
        if (this.sourcesAndSinks.containsKey(signature)) {
            this.sourcesAndSinks.get(signature).merge((ISourceSinkDefinition)ssd);
        } else {
            this.sourcesAndSinks.put(signature, ssd);
        }
    }

    protected IAccessPathBasedSourceSinkDefinition createMethodSourceSinkDefinition(AndroidMethod method, Set<AccessPathTuple> baseAPs, Set<AccessPathTuple>[] paramAPs, Set<AccessPathTuple> returnAPs, MethodSourceSinkDefinition.CallType callType) {
        return new MethodSourceSinkDefinition((SootMethodAndClass)method, baseAPs, (Set[])paramAPs, returnAPs, callType);
    }

    protected IAccessPathBasedSourceSinkDefinition createFieldSourceSinkDefinition(String signature, Set<AccessPathTuple> baseAPs) {
        return new FieldSourceSinkDefinition(signature, baseAPs);
    }

    protected class SAXHandler
    extends DefaultHandler {
        protected String methodSignature = null;
        protected String fieldSignature = null;
        protected CategoryDefinition category;
        protected boolean isSource;
        protected boolean isSink;
        protected List<String> pathElements;
        protected List<String> pathElementTypes;
        protected int paramIndex;
        protected List<String> paramTypes = new ArrayList<String>();
        protected MethodSourceSinkDefinition.CallType callType;
        protected String accessPathParentElement = "";
        protected String description = "";
        protected Set<AccessPathTuple> baseAPs = new HashSet<AccessPathTuple>();
        protected List<Set<AccessPathTuple>> paramAPs = new ArrayList<Set<AccessPathTuple>>();
        protected Set<AccessPathTuple> returnAPs = new HashSet<AccessPathTuple>();

        protected SAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String qNameLower;
            switch (qNameLower = qName.toLowerCase()) {
                case "category": {
                    String strCustomDescription;
                    String strSysCategory = attributes.getValue("id").trim();
                    String strCustomCategory = attributes.getValue("customId");
                    if (strCustomCategory != null && !strCustomCategory.isEmpty()) {
                        strCustomCategory = strCustomCategory.trim();
                    }
                    if ((strCustomDescription = attributes.getValue("description")) != null && !strCustomDescription.isEmpty()) {
                        strCustomDescription = strCustomDescription.trim();
                    }
                    this.category = XMLSourceSinkParser.this.getOrMakeCategory(CategoryDefinition.CATEGORY.valueOf(strSysCategory), strCustomCategory, strCustomDescription);
                    if (XMLSourceSinkParser.this.categoryFilter == null || XMLSourceSinkParser.this.categoryFilter.acceptsCategory(this.category)) break;
                    this.category = null;
                    break;
                }
                case "field": {
                    if (this.category == null || attributes == null) break;
                    this.fieldSignature = this.parseSignature(attributes);
                    this.accessPathParentElement = "base";
                    break;
                }
                case "method": {
                    if (this.category == null || attributes == null) break;
                    this.methodSignature = this.parseSignature(attributes);
                    this.callType = MethodSourceSinkDefinition.CallType.MethodCall;
                    String strCallType = attributes.getValue("callType");
                    if (strCallType == null || strCallType.isEmpty()) break;
                    if ((strCallType = strCallType.trim()).equalsIgnoreCase("MethodCall")) {
                        this.callType = MethodSourceSinkDefinition.CallType.MethodCall;
                        break;
                    }
                    if (!strCallType.equalsIgnoreCase("Callback")) break;
                    this.callType = MethodSourceSinkDefinition.CallType.Callback;
                    break;
                }
                case "accesspath": {
                    String newDesc;
                    if ((this.methodSignature == null || this.methodSignature.isEmpty()) && (this.fieldSignature == null || this.fieldSignature.isEmpty())) break;
                    this.pathElements = new ArrayList<String>();
                    this.pathElementTypes = new ArrayList<String>();
                    if (attributes == null) break;
                    String tempStr = attributes.getValue("isSource");
                    if (tempStr != null && !tempStr.isEmpty()) {
                        this.isSource = tempStr.equalsIgnoreCase("true");
                    }
                    if ((tempStr = attributes.getValue("isSink")) != null && !tempStr.isEmpty()) {
                        this.isSink = tempStr.equalsIgnoreCase("true");
                    }
                    if ((newDesc = attributes.getValue("description")) == null || newDesc.isEmpty()) break;
                    this.description = newDesc;
                    break;
                }
                case "base": {
                    this.accessPathParentElement = qNameLower;
                    this.description = attributes.getValue("description");
                    break;
                }
                case "return": {
                    this.accessPathParentElement = qNameLower;
                    this.description = attributes.getValue("description");
                    break;
                }
                case "param": {
                    if (this.methodSignature != null && attributes != null) {
                        String tempStr = attributes.getValue("index");
                        if (tempStr != null && !tempStr.isEmpty()) {
                            this.paramIndex = Integer.parseInt(tempStr);
                        }
                        if ((tempStr = attributes.getValue("type")) != null && !tempStr.isEmpty()) {
                            this.paramTypes.add(tempStr.trim());
                        }
                    }
                    this.accessPathParentElement = qNameLower;
                    this.description = attributes.getValue("description");
                    break;
                }
                case "pathelement": {
                    if (this.methodSignature == null || attributes == null) break;
                    String tempStr = attributes.getValue("field");
                    if (tempStr != null && !tempStr.isEmpty()) {
                        this.pathElements.add(tempStr);
                    }
                    if ((tempStr = attributes.getValue("type")) == null || tempStr.isEmpty()) break;
                    this.pathElementTypes.add(tempStr);
                }
            }
        }

        private String parseSignature(Attributes attributes) {
            String signature = attributes.getValue("signature").trim();
            if (signature != null && !signature.isEmpty() && !signature.startsWith("<")) {
                signature = "<" + signature + ">";
            }
            return signature;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String qNameLower;
            switch (qNameLower = qName.toLowerCase()) {
                case "category": {
                    this.category = null;
                    break;
                }
                case "method": {
                    if (this.methodSignature == null) break;
                    if (!(this.baseAPs.isEmpty() && this.paramAPs.isEmpty() && this.returnAPs.isEmpty())) {
                        AndroidMethod tempMeth = AndroidMethod.createFromSignature(this.methodSignature);
                        IAccessPathBasedSourceSinkDefinition ssd = XMLSourceSinkParser.this.createMethodSourceSinkDefinition(tempMeth, this.baseAPs, this.paramAPs.toArray(new Set[this.paramAPs.size()]), this.returnAPs, this.callType);
                        ssd.setCategory((ISourceSinkCategory)this.category);
                        XMLSourceSinkParser.this.addSourceSinkDefinition(this.methodSignature, ssd);
                    }
                    this.methodSignature = null;
                    this.fieldSignature = null;
                    this.baseAPs = new HashSet<AccessPathTuple>();
                    this.paramAPs = new ArrayList<Set<AccessPathTuple>>();
                    this.returnAPs = new HashSet<AccessPathTuple>();
                    this.description = null;
                    break;
                }
                case "field": {
                    if (!this.baseAPs.isEmpty()) {
                        IAccessPathBasedSourceSinkDefinition ssd = XMLSourceSinkParser.this.createFieldSourceSinkDefinition(this.fieldSignature, this.baseAPs);
                        XMLSourceSinkParser.this.addSourceSinkDefinition(this.fieldSignature, ssd);
                    }
                    this.methodSignature = null;
                    this.fieldSignature = null;
                    this.description = null;
                    break;
                }
                case "accesspath": {
                    if (this.isSource || this.isSink) {
                        if (this.pathElements != null && this.pathElements.isEmpty() && this.pathElementTypes != null && this.pathElementTypes.isEmpty()) {
                            this.pathElements = null;
                            this.pathElementTypes = null;
                        }
                        if (this.pathElements != null && this.pathElementTypes != null && this.pathElements.size() != this.pathElementTypes.size()) {
                            throw new RuntimeException(String.format("Length mismatch between path elements (%d) and their types (%d)", this.pathElements.size(), this.pathElementTypes.size()));
                        }
                        if ((this.pathElements == null || this.pathElements.isEmpty()) && this.pathElementTypes != null && !this.pathElementTypes.isEmpty()) {
                            throw new RuntimeException("Got types for path elements, but no elements (i.e., fields)");
                        }
                        SourceSinkType sstype = SourceSinkType.fromFlags((boolean)this.isSink, (boolean)this.isSource);
                        if (XMLSourceSinkParser.this.categoryFilter != null) {
                            sstype = XMLSourceSinkParser.this.categoryFilter.filter(this.category, sstype);
                        }
                        if (sstype != SourceSinkType.Neither) {
                            AccessPathTuple apt = AccessPathTuple.fromPathElements(this.pathElements, this.pathElementTypes, (SourceSinkType)sstype);
                            apt = apt.simplify();
                            if (this.description != null && !this.description.isEmpty()) {
                                apt.setDescription(this.description);
                            }
                            switch (this.accessPathParentElement) {
                                case "base": {
                                    this.baseAPs.add(apt);
                                    break;
                                }
                                case "return": {
                                    this.returnAPs.add(apt);
                                    break;
                                }
                                case "param": {
                                    while (this.paramAPs.size() <= this.paramIndex) {
                                        this.paramAPs.add(new HashSet());
                                    }
                                    this.paramAPs.get(this.paramIndex).add(apt);
                                }
                            }
                        }
                    }
                    this.pathElements = null;
                    this.pathElementTypes = null;
                    this.isSource = false;
                    this.isSink = false;
                    this.pathElements = null;
                    this.pathElementTypes = null;
                    this.description = null;
                    break;
                }
                case "base": {
                    this.accessPathParentElement = "";
                    break;
                }
                case "return": {
                    this.accessPathParentElement = "";
                    break;
                }
                case "param": {
                    this.accessPathParentElement = "";
                    this.paramIndex = -1;
                    this.paramTypes.clear();
                    break;
                }
            }
        }
    }

    public static interface ICategoryFilter {
        public boolean acceptsCategory(CategoryDefinition var1);

        public SourceSinkType filter(CategoryDefinition var1, SourceSinkType var2);
    }
}

