/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source;

import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.android.source.parsers.xml.XMLSourceSinkParser;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class ConfigurationBasedCategoryFilter
implements XMLSourceSinkParser.ICategoryFilter {
    private final InfoflowAndroidConfiguration.SourceSinkConfiguration config;

    public ConfigurationBasedCategoryFilter(InfoflowAndroidConfiguration.SourceSinkConfiguration config) {
        this.config = config;
    }

    @Override
    public boolean acceptsCategory(CategoryDefinition category) {
        category = category.getIdOnlyDescription();
        InfoflowConfiguration.CategoryMode sourceType = this.config.getSourceCategoriesAndModes().get(category);
        InfoflowConfiguration.CategoryMode sinkType = this.config.getSinkCategoriesAndModes().get(category);
        if (sourceType != null && sourceType == InfoflowConfiguration.CategoryMode.Exclude && sinkType != null && sinkType == InfoflowConfiguration.CategoryMode.Exclude) {
            return false;
        }
        if (this.config.getSinkFilterMode() == InfoflowConfiguration.SourceSinkFilterMode.UseOnlyIncluded) {
            if (sourceType != null && sourceType == InfoflowConfiguration.CategoryMode.Include) {
                return true;
            }
            return sinkType != null && sinkType == InfoflowConfiguration.CategoryMode.Include;
        }
        return true;
    }

    @Override
    public SourceSinkType filter(CategoryDefinition category, SourceSinkType sourceSinkType) {
        category = category.getIdOnlyDescription();
        InfoflowConfiguration.CategoryMode sourceMode = this.config.getSourceCategoriesAndModes().get(category);
        InfoflowConfiguration.CategoryMode sinkMode = this.config.getSinkCategoriesAndModes().get(category);
        if (this.config.getSourceFilterMode() == InfoflowConfiguration.SourceSinkFilterMode.UseAllButExcluded) {
            if ((sourceSinkType == SourceSinkType.Source || sourceSinkType == SourceSinkType.Both) && sourceMode != null && sourceMode == InfoflowConfiguration.CategoryMode.Exclude) {
                sourceSinkType = sourceSinkType.removeType(SourceSinkType.Source);
            }
            if ((sourceSinkType == SourceSinkType.Sink || sourceSinkType == SourceSinkType.Both) && sinkMode != null && sinkMode == InfoflowConfiguration.CategoryMode.Exclude) {
                sourceSinkType = sourceSinkType.removeType(SourceSinkType.Sink);
            }
        } else if (this.config.getSourceFilterMode() == InfoflowConfiguration.SourceSinkFilterMode.UseOnlyIncluded) {
            if (!(sourceSinkType != SourceSinkType.Source && sourceSinkType != SourceSinkType.Both || sourceMode != null && sourceMode == InfoflowConfiguration.CategoryMode.Include)) {
                sourceSinkType = sourceSinkType.removeType(SourceSinkType.Source);
            }
            if (!(sourceSinkType != SourceSinkType.Sink && sourceSinkType != SourceSinkType.Both || sourceMode != null && sinkMode == InfoflowConfiguration.CategoryMode.Include)) {
                sourceSinkType = sourceSinkType.removeType(SourceSinkType.Sink);
            }
        }
        return sourceSinkType;
    }
}

