/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.android.source.AndroidSourceSinkManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.FieldSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.StatementSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.SystemClassHandler;

public class AccessPathBasedSourceSinkManager
extends AndroidSourceSinkManager {
    public AccessPathBasedSourceSinkManager(Set<? extends ISourceSinkDefinition> sources, Set<? extends ISourceSinkDefinition> sinks, InfoflowAndroidConfiguration config) {
        super(sources, sinks, config);
    }

    public AccessPathBasedSourceSinkManager(Set<? extends ISourceSinkDefinition> sources, Set<? extends ISourceSinkDefinition> sinks, Set<AndroidCallbackDefinition> callbackMethods, InfoflowAndroidConfiguration config, Map<Integer, AndroidLayoutControl> layoutControls) {
        super(sources, sinks, callbackMethods, config, layoutControls);
    }

    protected SourceInfo createSourceInfo(Stmt sCallSite, InfoflowManager manager, ISourceSinkDefinition def) {
        HashSet<AccessPathTuple> apTuples;
        HashSet<AccessPath> aps;
        IAccessPathBasedSourceSinkDefinition apDef;
        block25: {
            block24: {
                if (null == def) {
                    return null;
                }
                if (!(def instanceof IAccessPathBasedSourceSinkDefinition)) {
                    return super.createSourceInfo(sCallSite, manager, def);
                }
                apDef = (IAccessPathBasedSourceSinkDefinition)def;
                if (apDef.isEmpty()) {
                    return super.createSourceInfo(sCallSite, manager, def);
                }
                aps = new HashSet<AccessPath>();
                apTuples = new HashSet<AccessPathTuple>();
                if (!(def instanceof MethodSourceSinkDefinition)) break block24;
                MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)def;
                switch (methodDef.getCallType()) {
                    case Callback: {
                        IdentityStmt is;
                        if (sCallSite instanceof IdentityStmt && (is = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef) {
                            ParameterRef paramRef = (ParameterRef)is.getRightOp();
                            if (methodDef.getParameters() != null && methodDef.getParameters().length > paramRef.getIndex()) {
                                for (AccessPathTuple apt : methodDef.getParameters()[paramRef.getIndex()]) {
                                    aps.add(apt.toAccessPath(is.getLeftOp(), manager, false));
                                    apTuples.add(apt);
                                }
                            }
                        }
                        break block25;
                    }
                    case MethodCall: {
                        if (sCallSite instanceof InvokeStmt && sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && methodDef.getBaseObjects() != null) {
                            Value baseVal = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
                            for (AccessPathTuple apt : methodDef.getBaseObjects()) {
                                if (!apt.getSourceSinkType().isSource()) continue;
                                aps.add(apt.toAccessPath(baseVal, manager, true));
                                apTuples.add(apt);
                            }
                        }
                        if (sCallSite instanceof DefinitionStmt && methodDef.getReturnValues() != null) {
                            Value returnVal = ((DefinitionStmt)sCallSite).getLeftOp();
                            for (AccessPathTuple apt : methodDef.getReturnValues()) {
                                if (!apt.getSourceSinkType().isSource()) continue;
                                aps.add(apt.toAccessPath(returnVal, manager, false));
                                apTuples.add(apt);
                            }
                        }
                        if (sCallSite.containsInvokeExpr() && methodDef.getParameters() != null && methodDef.getParameters().length > 0) {
                            for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                                if (methodDef.getParameters().length <= i) continue;
                                for (AccessPathTuple apt : methodDef.getParameters()[i]) {
                                    if (!apt.getSourceSinkType().isSource()) continue;
                                    aps.add(apt.toAccessPath(sCallSite.getInvokeExpr().getArg(i), manager, true));
                                    apTuples.add(apt);
                                }
                            }
                        }
                        break block25;
                    }
                    default: {
                        return null;
                    }
                }
            }
            if (def instanceof FieldSourceSinkDefinition) {
                FieldSourceSinkDefinition fieldDef = (FieldSourceSinkDefinition)def;
                if (sCallSite instanceof AssignStmt && fieldDef.getAccessPaths() != null) {
                    AssignStmt assignStmt = (AssignStmt)sCallSite;
                    for (AccessPathTuple apt : fieldDef.getAccessPaths()) {
                        if (!apt.getSourceSinkType().isSource()) continue;
                        aps.add(apt.toAccessPath(assignStmt.getLeftOp(), manager, false));
                        apTuples.add(apt);
                    }
                }
            } else if (def instanceof StatementSourceSinkDefinition) {
                StatementSourceSinkDefinition ssdef = (StatementSourceSinkDefinition)def;
                for (AccessPathTuple apt : ssdef.getAccessPaths()) {
                    if (!apt.getSourceSinkType().isSource()) continue;
                    aps.add(apt.toAccessPath((Value)ssdef.getLocal(), manager, true));
                    apTuples.add(apt);
                }
            }
        }
        if (aps.isEmpty()) {
            return null;
        }
        return new SourceInfo((ISourceSinkDefinition)apDef.filter(apTuples), aps);
    }

    public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath sourceAccessPath) {
        block14: {
            IAccessPathBasedSourceSinkDefinition apDef;
            ISourceSinkDefinition def;
            block15: {
                block13: {
                    def = this.getSinkDefinition(sCallSite, manager, sourceAccessPath);
                    if (def == null) {
                        return null;
                    }
                    if (!(def instanceof IAccessPathBasedSourceSinkDefinition)) {
                        return super.getSinkInfo(sCallSite, manager, sourceAccessPath);
                    }
                    apDef = (IAccessPathBasedSourceSinkDefinition)def;
                    if (apDef.isEmpty() && sCallSite.containsInvokeExpr()) {
                        if (SystemClassHandler.v().isTaintVisible(sourceAccessPath, sCallSite.getInvokeExpr().getMethod())) {
                            return new SinkInfo(def);
                        }
                        return null;
                    }
                    if (sourceAccessPath == null) {
                        return new SinkInfo(def);
                    }
                    if (!(def instanceof MethodSourceSinkDefinition)) break block13;
                    MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)def;
                    if (methodDef.getCallType() == MethodSourceSinkDefinition.CallType.Return) {
                        return new SinkInfo(def);
                    }
                    if (sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr && methodDef.getBaseObjects() != null) {
                        for (Object apt : methodDef.getBaseObjects()) {
                            if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, (AccessPathTuple)apt)) continue;
                            return new SinkInfo((ISourceSinkDefinition)apDef.filter(Collections.singleton(apt)));
                        }
                    }
                    if (methodDef.getParameters() == null || methodDef.getParameters().length <= 0) break block14;
                    for (int i = 0; i < sCallSite.getInvokeExpr().getArgCount(); ++i) {
                        if (sCallSite.getInvokeExpr().getArg(i) != sourceAccessPath.getPlainValue() || methodDef.getParameters().length <= i) continue;
                        for (AccessPathTuple apt : methodDef.getParameters()[i]) {
                            if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                            return new SinkInfo((ISourceSinkDefinition)apDef.filter(Collections.singleton(apt)));
                        }
                    }
                    break block14;
                }
                if (!(def instanceof FieldSourceSinkDefinition)) break block15;
                FieldSourceSinkDefinition fieldDef = (FieldSourceSinkDefinition)def;
                if (!(sCallSite instanceof AssignStmt) || fieldDef.getAccessPaths() == null) break block14;
                for (AccessPathTuple apt : fieldDef.getAccessPaths()) {
                    if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                    return new SinkInfo((ISourceSinkDefinition)apDef.filter(Collections.singleton(apt)));
                }
                break block14;
            }
            if (def instanceof StatementSourceSinkDefinition) {
                StatementSourceSinkDefinition ssdef = (StatementSourceSinkDefinition)def;
                for (AccessPathTuple apt : ssdef.getAccessPaths()) {
                    if (!apt.getSourceSinkType().isSink() || !this.accessPathMatches(sourceAccessPath, apt)) continue;
                    return new SinkInfo((ISourceSinkDefinition)apDef.filter(Collections.singleton(apt)));
                }
            }
        }
        return null;
    }

    private boolean accessPathMatches(AccessPath sourceAccessPath, AccessPathTuple apt) {
        if (apt.getFields() == null || apt.getFields().length == 0 || sourceAccessPath == null) {
            return true;
        }
        for (int i = 0; i < apt.getFields().length; ++i) {
            if (i >= sourceAccessPath.getFieldCount()) {
                return sourceAccessPath.getTaintSubFields();
            }
            if (sourceAccessPath.getFields()[i].getName().equals(apt.getFields()[i])) continue;
            return false;
        }
        return true;
    }
}

