/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.manifest;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlHandler;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.axml.ApkHandler;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.util.SystemClassHandler;

public class ProcessManifest
implements Closeable {
    protected ApkHandler apk = null;
    protected AXmlHandler axml;
    protected ARSCFileParser arscParser;
    protected AXmlNode manifest;
    protected AXmlNode application;
    protected List<AXmlNode> providers = null;
    protected List<AXmlNode> services = null;
    protected List<AXmlNode> activities = null;
    protected List<AXmlNode> aliasActivities = null;
    protected List<AXmlNode> receivers = null;
    private String cache_PackageName = null;

    public ProcessManifest(String apkPath) throws IOException, XmlPullParserException {
        this(new File(apkPath));
    }

    public ProcessManifest(File apkFile) throws IOException, XmlPullParserException {
        this(apkFile, ARSCFileParser.getInstance(apkFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessManifest(File apkFile, ARSCFileParser arscParser) throws IOException, XmlPullParserException {
        if (!apkFile.exists()) {
            throw new RuntimeException(String.format("The given APK file %s does not exist", apkFile.getCanonicalPath()));
        }
        this.apk = new ApkHandler(apkFile);
        this.arscParser = arscParser;
        try (InputStream is = null;){
            is = this.apk.getInputStream("AndroidManifest.xml");
            if (is == null) {
                throw new FileNotFoundException(String.format("The file %s does not contain an Android Manifest", apkFile.getAbsolutePath()));
            }
            this.handle(is);
        }
    }

    public ProcessManifest(InputStream manifestIS) throws IOException, XmlPullParserException {
        this.handle(manifestIS);
    }

    protected void handle(InputStream manifestIS) throws IOException, XmlPullParserException {
        this.axml = new AXmlHandler(manifestIS);
        List<AXmlNode> manifests = this.axml.getNodesWithTag("manifest");
        if (manifests.isEmpty()) {
            throw new RuntimeException("Manifest contains no manifest node");
        }
        if (manifests.size() > 1) {
            throw new RuntimeException("Manifest contains more than one manifest node");
        }
        this.manifest = manifests.get(0);
        List<AXmlNode> applications = this.manifest.getChildrenWithTag("application");
        if (applications.isEmpty()) {
            throw new RuntimeException("Manifest contains no application node");
        }
        if (applications.size() > 1) {
            throw new RuntimeException("Manifest contains more than one application node");
        }
        this.application = applications.get(0);
        this.providers = this.axml.getNodesWithTag("provider");
        this.services = this.axml.getNodesWithTag("service");
        this.activities = this.axml.getNodesWithTag("activity");
        this.aliasActivities = this.axml.getNodesWithTag("activity-alias");
        this.receivers = this.axml.getNodesWithTag("receiver");
    }

    private String expandClassName(String className) {
        String packageName = this.getPackageName();
        if (className.startsWith(".")) {
            return packageName + className;
        }
        if (!className.contains(".")) {
            return packageName + "." + className;
        }
        return className;
    }

    public AXmlHandler getAXml() {
        return this.axml;
    }

    public ApkHandler getApk() {
        return this.apk;
    }

    public AXmlNode getManifest() {
        return this.manifest;
    }

    public AXmlNode getApplication() {
        return this.application;
    }

    public List<AXmlNode> getProviders() {
        return this.providers == null ? Collections.emptyList() : new ArrayList<AXmlNode>(this.providers);
    }

    public List<AXmlNode> getServices() {
        return this.services == null ? Collections.emptyList() : new ArrayList<AXmlNode>(this.services);
    }

    public Set<String> getEntryPointClasses() {
        if (!this.isApplicationEnabled()) {
            return Collections.emptySet();
        }
        HashSet<String> entryPoints = new HashSet<String>();
        for (AXmlNode node : this.activities) {
            this.checkAndAddComponent(entryPoints, node);
        }
        for (AXmlNode node : this.providers) {
            this.checkAndAddComponent(entryPoints, node);
        }
        for (AXmlNode node : this.services) {
            this.checkAndAddComponent(entryPoints, node);
        }
        for (AXmlNode node : this.receivers) {
            this.checkAndAddComponent(entryPoints, node);
        }
        String appName = this.getApplicationName();
        if (appName != null && !appName.isEmpty()) {
            entryPoints.add(appName);
        }
        return entryPoints;
    }

    private void checkAndAddComponent(Set<String> entryPoints, AXmlNode node) {
        String packageName = this.getPackageName() + ".";
        AXmlAttribute<?> attrEnabled = node.getAttribute("enabled");
        if (attrEnabled == null || !attrEnabled.getValue().equals(Boolean.FALSE)) {
            AXmlAttribute<?> attr = node.getAttribute("name");
            if (attr != null) {
                String className = this.expandClassName((String)attr.getValue());
                if (className.startsWith(packageName) || !SystemClassHandler.v().isClassInSystemPackage(className)) {
                    entryPoints.add(className);
                }
            } else {
                for (Map.Entry<String, AXmlAttribute<?>> a : node.getAttributes().entrySet()) {
                    String name;
                    String attrValueName;
                    AXmlAttribute<?> attrValue = a.getValue();
                    if (attrValue == null || (attrValueName = attrValue.getName()) != null && !attrValueName.isEmpty() || attrValue.getType() != 3 || !this.isValidComponentName(name = (String)attrValue.getValue())) continue;
                    String expandedName = this.expandClassName(name);
                    if (SystemClassHandler.v().isClassInSystemPackage(expandedName)) continue;
                    entryPoints.add(expandedName);
                }
            }
        }
    }

    private boolean isValidComponentName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.equals("true") || name.equals("false")) {
            return false;
        }
        if (Character.isDigit(name.charAt(0))) {
            return false;
        }
        return name.startsWith(".");
    }

    public ComponentType getComponentType(String className) {
        for (AXmlNode node : this.activities) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.Activity;
        }
        for (AXmlNode node : this.services) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.Service;
        }
        for (AXmlNode node : this.receivers) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.BroadcastReceiver;
        }
        for (AXmlNode node : this.providers) {
            if (!node.getAttribute("name").getValue().equals(className)) continue;
            return ComponentType.ContentProvider;
        }
        return null;
    }

    public List<AXmlNode> getActivities() {
        return this.activities == null ? Collections.emptyList() : new ArrayList<AXmlNode>(this.activities);
    }

    public List<AXmlNode> getAliasActivities() {
        return new ArrayList<AXmlNode>(this.aliasActivities);
    }

    public List<AXmlNode> getReceivers() {
        return this.receivers == null ? Collections.emptyList() : new ArrayList<AXmlNode>(this.receivers);
    }

    public AXmlNode getProvider(String name) {
        return this.getNodeWithName(this.providers, name);
    }

    public AXmlNode getService(String name) {
        return this.getNodeWithName(this.services, name);
    }

    public AXmlNode getActivity(String name) {
        return this.getNodeWithName(this.activities, name);
    }

    public AXmlNode getAliasActivity(String name) {
        return this.getNodeWithName(this.aliasActivities, name);
    }

    public AXmlNode getReceiver(String name) {
        return this.getNodeWithName(this.receivers, name);
    }

    protected AXmlNode getNodeWithName(List<AXmlNode> list, String name) {
        for (AXmlNode node : list) {
            AXmlAttribute<?> attr = node.getAttributes().get("name");
            if (attr == null || !attr.getValue().equals(name)) continue;
            return node;
        }
        return null;
    }

    public AXmlNode getAliasActivityTarget(AXmlNode aliasActivity) {
        AXmlAttribute<?> targetActivityAttribute;
        if (ProcessManifest.isAliasActivity(aliasActivity) && (targetActivityAttribute = aliasActivity.getAttribute("targetActivity")) != null) {
            return this.getActivity((String)targetActivityAttribute.getValue());
        }
        return null;
    }

    public static boolean isAliasActivity(AXmlNode activity) {
        return activity.getTag().equals("activity-alias");
    }

    public ArrayList<AXmlNode> getAllActivities() {
        ArrayList<AXmlNode> allActivities = new ArrayList<AXmlNode>(this.activities);
        allActivities.addAll(this.aliasActivities);
        return allActivities;
    }

    public byte[] getOutput() {
        return this.axml.toByteArray();
    }

    public String getPackageName() {
        AXmlAttribute<?> attr;
        if (this.cache_PackageName == null && (attr = this.manifest.getAttribute("package")) != null && attr.getValue() != null) {
            this.cache_PackageName = (String)attr.getValue();
        }
        return this.cache_PackageName;
    }

    public int getVersionCode() {
        AXmlAttribute<?> attr = this.manifest.getAttribute("versionCode");
        return attr == null || attr.getValue() == null ? -1 : Integer.parseInt(attr.getValue().toString());
    }

    public String getVersionName() {
        AXmlAttribute<?> attr = this.manifest.getAttribute("versionName");
        return attr == null || attr.getValue() == null ? null : attr.getValue().toString();
    }

    public String getApplicationName() {
        Object value;
        AXmlAttribute<?> attr = this.application.getAttribute("name");
        if (attr != null && (value = attr.getValue()) != null) {
            ARSCFileParser.AbstractResource res;
            if (value instanceof String) {
                return this.expandClassName((String)attr.getValue());
            }
            if (value instanceof Integer && (res = this.arscParser.findResource((Integer)attr.getValue())) instanceof ARSCFileParser.StringResource) {
                ARSCFileParser.StringResource strRes = (ARSCFileParser.StringResource)res;
                return strRes.getValue();
            }
        }
        return null;
    }

    public boolean isApplicationEnabled() {
        AXmlAttribute<?> attr = this.application.getAttribute("enabled");
        return attr == null || attr.getValue() == null || !attr.getValue().equals(Boolean.FALSE);
    }

    public int getMinSdkVersion() {
        List<AXmlNode> usesSdk = this.manifest.getChildrenWithTag("uses-sdk");
        if (usesSdk == null || usesSdk.isEmpty()) {
            return -1;
        }
        AXmlAttribute<?> attr = usesSdk.get(0).getAttribute("minSdkVersion");
        if (attr == null || attr.getValue() == null) {
            return -1;
        }
        if (attr.getValue() instanceof Integer) {
            return (Integer)attr.getValue();
        }
        return Integer.parseInt(attr.getValue().toString());
    }

    public int targetSdkVersion() {
        List<AXmlNode> usesSdk = this.manifest.getChildrenWithTag("uses-sdk");
        if (usesSdk == null || usesSdk.isEmpty()) {
            return -1;
        }
        AXmlAttribute<?> attr = usesSdk.get(0).getAttribute("targetSdkVersion");
        if (attr == null || attr.getValue() == null) {
            return -1;
        }
        if (attr.getValue() instanceof Integer) {
            return (Integer)attr.getValue();
        }
        return Integer.parseInt(attr.getValue().toString());
    }

    public Set<String> getPermissions() {
        List<AXmlNode> usesPerms = this.manifest.getChildrenWithTag("uses-permission");
        HashSet<String> permissions = new HashSet<String>();
        for (AXmlNode perm : usesPerms) {
            AXmlAttribute<?> attr = perm.getAttribute("name");
            if (attr != null) {
                permissions.add((String)attr.getValue());
                continue;
            }
            for (AXmlAttribute<?> a : perm.getAttributes().values()) {
                if (a.getType() != 3 || !a.getName().isEmpty()) continue;
                permissions.add((String)a.getValue());
            }
        }
        return permissions;
    }

    public void addPermission(String permissionName) {
        AXmlNode permission = new AXmlNode("uses-permission", null, this.manifest);
        AXmlAttribute<String> permissionNameAttr = new AXmlAttribute<String>("name", permissionName, "http://schemas.android.com/apk/res/android");
        permission.addAttribute(permissionNameAttr);
    }

    public void addProvider(AXmlNode node) {
        if (this.providers.isEmpty()) {
            this.providers = new ArrayList<AXmlNode>();
        }
        this.providers.add(node);
    }

    public void addReceiver(AXmlNode node) {
        if (this.receivers.isEmpty()) {
            this.receivers = new ArrayList<AXmlNode>();
        }
        this.receivers.add(node);
    }

    public void addActivity(AXmlNode node) {
        if (this.activities.isEmpty()) {
            this.activities = new ArrayList<AXmlNode>();
        }
        this.activities.add(node);
    }

    public void addService(AXmlNode node) {
        if (this.services.isEmpty()) {
            this.services = new ArrayList<AXmlNode>();
        }
        this.services.add(node);
    }

    @Override
    public void close() {
        if (this.apk != null) {
            this.apk.close();
        }
    }

    public Set<AXmlNode> getLaunchableActivities() {
        LinkedHashSet<AXmlNode> allLaunchableActivities = new LinkedHashSet<AXmlNode>();
        for (AXmlNode activity : this.getAllActivities()) {
            for (AXmlNode activityChildren : activity.getChildren()) {
                if (!activityChildren.getTag().equals("intent-filter")) continue;
                boolean actionFilter = false;
                boolean categoryFilter = false;
                for (AXmlNode intentFilter : activityChildren.getChildren()) {
                    if (intentFilter.getTag().equals("action") && intentFilter.getAttribute("name").getValue().toString().equals("android.intent.action.MAIN")) {
                        actionFilter = true;
                        continue;
                    }
                    if (!intentFilter.getTag().equals("category") || !intentFilter.getAttribute("name").getValue().toString().equals("android.intent.category.LAUNCHER")) continue;
                    categoryFilter = true;
                }
                if (!actionFilter || !categoryFilter) continue;
                allLaunchableActivities.add(activity);
            }
        }
        return allLaunchableActivities;
    }

    public static enum ComponentType {
        Activity,
        Service,
        ContentProvider,
        BroadcastReceiver;

    }
}

