/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.jimple.infoflow.android.iccta.App;
import soot.jimple.infoflow.android.iccta.Ic3Data;
import soot.jimple.infoflow.android.iccta.LoggingPoint;

class Intent {
    private String component;
    private String componentPackage;
    private String componentClass;
    private String action;
    private Set<String> categories = new HashSet<String>();
    private Map<String, String> extras = new HashMap<String, String>();
    private String dataScheme;
    private String dataHost;
    private int dataPort = -1;
    private String dataPath;
    private String data;
    private int flags;
    private App app;
    private LoggingPoint point;
    private String authority;
    private String dataType;

    public Intent(App app, LoggingPoint point) {
        this.app = app;
        this.point = point;
    }

    public void seal() {
    }

    public LoggingPoint getLoggingPoint() {
        return this.point;
    }

    public boolean isImplicit() {
        return this.component == null || this.component.isEmpty() || this.component.contains("*") || this.component.contains("NULL-CONSTANT");
    }

    public Intent clone() {
        Intent intent = new Intent(this.app, this.point);
        intent.component = this.component;
        intent.componentPackage = this.componentPackage;
        intent.componentClass = this.componentClass;
        intent.action = this.action;
        HashSet<String> tmpCategories = new HashSet<String>();
        for (String str : this.categories) {
            tmpCategories.add(str);
        }
        intent.categories = tmpCategories;
        HashMap<String, String> tmpExtras = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.extras.entrySet()) {
            tmpExtras.put(entry.getKey(), entry.getValue());
        }
        intent.extras = tmpExtras;
        intent.dataScheme = this.dataScheme;
        intent.dataHost = this.dataHost;
        intent.dataPort = this.dataPort;
        intent.dataPath = this.dataPath;
        intent.data = this.data;
        intent.flags = this.flags;
        intent.app = this.app;
        return intent;
    }

    public String toString() {
        return "Intent [component=" + this.component + ", componentPackage=" + this.componentPackage + ", componentClass=" + this.componentClass + ", action=" + this.action + ", categories=" + this.categories + ", dataScheme=" + this.dataScheme + ", dataHost=" + this.dataHost + ", dataPort=" + this.dataPort + ", dataPath=" + this.dataPath + ", data=" + this.data + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
        if (component.contains("/") && !component.startsWith("/")) {
            this.setComponentPackage(component.split("/")[0]);
            if (!component.endsWith("/")) {
                this.setComponentClass(component.split("/")[1]);
            }
        }
    }

    public String getComponentPackage() {
        return this.componentPackage;
    }

    public void setComponentPackage(String componentPackage) {
        this.componentPackage = componentPackage;
    }

    public String getComponentClass() {
        return this.componentClass;
    }

    public void setComponentClass(String componentClass) {
        this.componentClass = componentClass;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        if (action.equals("<INTENT>")) {
            return;
        }
        this.action = action;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<String> categories) {
        categories.remove("<INTENT>");
        if (!categories.isEmpty()) {
            this.categories = categories;
        }
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public void setExtras(Map<String, String> extras) {
        this.extras = extras;
    }

    public String getDataScheme() {
        return this.dataScheme;
    }

    public void setDataScheme(String dataScheme) {
        if (dataScheme.equals("(.*)")) {
            return;
        }
        this.dataScheme = dataScheme;
    }

    public String getDataHost() {
        return this.dataHost;
    }

    public void setDataHost(String dataHost) {
        if (dataHost.equals("(.*)")) {
            return;
        }
        this.dataHost = dataHost;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public void setDataPort(int dataPort) {
        if (dataPort == 0) {
            dataPort = -1;
        }
        this.dataPort = dataPort;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public void setDataPath(String dataPath) {
        if (dataPath.equals("(.*)")) {
            return;
        }
        this.dataPath = dataPath;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        if (data.equals("(.*)")) {
            return;
        }
        this.data = data;
        if (data.contains("://")) {
            if (this.dataScheme == null) {
                this.dataScheme = data.substring(0, data.indexOf("://"));
                data = data.substring(data.indexOf("://") + 3);
                if (this.dataScheme.contains(".*")) {
                    this.dataScheme = null;
                }
            }
            if (!data.isEmpty()) {
                if (this.dataHost == null) {
                    this.dataHost = data.contains("/") ? data.substring(0, data.indexOf("/")) : data;
                    if (this.dataHost.contains(".*")) {
                        this.dataHost = null;
                    }
                }
                if (this.dataPath == null && !data.isEmpty()) {
                    this.dataPath = data.contains("/") ? data.substring(data.indexOf("/") + 1) : data;
                    if (this.dataPath.contains(".*")) {
                        this.dataPath = null;
                    }
                }
            }
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setAuthority(String value) {
        this.authority = value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public App getApp() {
        return this.app;
    }

    public boolean hasImpreciseValues() {
        String string = this.toString();
        return this.isImprecise(string);
    }

    private boolean isImprecise(String string) {
        if (string == null) {
            return false;
        }
        if (string.toLowerCase().contains("harvester")) {
            return true;
        }
        return string.contains(".*");
    }

    public boolean hasImportantImpreciseValues() {
        return this.isImprecise(this.getAction()) || this.isImprecise(this.authority);
    }

    public List<Ic3Data.Application.Component> resolve(List<Ic3Data.Application.Component> list) {
        boolean isImplicit = this.isImplicit();
        String packageName = this.getComponentPackage();
        String componentName = this.getComponent();
        if (componentName != null && componentName.contains("/")) {
            if (packageName == null) {
                packageName = componentName.substring(0, componentName.indexOf("/"));
            }
            componentName = componentName.substring(componentName.indexOf("/") + 1);
        }
        if (packageName != null && packageName.contains(".*")) {
            packageName = null;
        }
        if (componentName != null && componentName.contains(".*")) {
            componentName = null;
        }
        if (componentName != null && componentName.contains("NULL-CONSTANT")) {
            componentName = null;
        }
        ArrayList<Ic3Data.Application.Component> results = new ArrayList<Ic3Data.Application.Component>();
        block13: for (Ic3Data.Application.Component component : list) {
            if (packageName != null && !component.getApp().getAppName().equals(packageName)) continue;
            if (componentName != null && componentName.equals(component.getName())) {
                results.add(component);
                continue;
            }
            boolean exported = component.getIntentFiltersCount() > 0;
            if (component.hasExported()) {
                exported = component.getExported();
            }
            if (!exported && !component.getApp().getAppName().equals(this.getApp().getAppName()) || !isImplicit) continue;
            for (Ic3Data.Application.Component.IntentFilter filter : component.getIntentFiltersList()) {
                boolean passedActionPart;
                boolean intentFilterSpecifiesURI;
                boolean hasSpecifiedAnAction = false;
                boolean passedAction = false;
                boolean passedCategory = false;
                boolean passedData = false;
                ArrayList<String> schemes = new ArrayList<String>();
                ArrayList<String> hosts = new ArrayList<String>();
                ArrayList<String> paths = new ArrayList<String>();
                ArrayList<Integer> ports = new ArrayList<Integer>();
                ArrayList<String> authorities = new ArrayList<String>();
                ArrayList<String> types = new ArrayList<String>();
                if (this.getAction() == null) {
                    passedAction = true;
                }
                boolean categoryVisited = false;
                block15: for (Ic3Data.Attribute attribute : filter.getAttributesList()) {
                    switch (attribute.getKind()) {
                        case ACTION: {
                            hasSpecifiedAnAction = true;
                            if (!attribute.getValueList().contains(this.getAction())) continue block15;
                            passedAction = true;
                            continue block15;
                        }
                        case CATEGORY: {
                            passedCategory = attribute.getValueList().containsAll(this.getCategories());
                            categoryVisited = true;
                            continue block15;
                        }
                        case HOST: {
                            if (attribute.getValueCount() != 1) {
                                throw new RuntimeException("Valuecount != 1");
                            }
                            hosts.add(attribute.getValueList().get(0));
                            continue block15;
                        }
                        case SCHEME: {
                            if (attribute.getValueCount() != 1) {
                                throw new RuntimeException("Valuecount != 1");
                            }
                            schemes.add(attribute.getValueList().get(0));
                            continue block15;
                        }
                        case PORT: {
                            if (attribute.getValueCount() != 1) {
                                throw new RuntimeException("Valuecount != 1");
                            }
                            ports.add(Integer.parseInt(attribute.getValueList().get(0)));
                            continue block15;
                        }
                        case PATH: {
                            if (attribute.getValueCount() != 1) {
                                throw new RuntimeException("Valuecount != 1");
                            }
                            paths.add(attribute.getValueList().get(0));
                            continue block15;
                        }
                        case AUTHORITY: {
                            if (attribute.getValueCount() != 1) {
                                throw new RuntimeException("Valuecount != 1");
                            }
                            authorities.add(attribute.getValueList().get(0));
                            continue block15;
                        }
                        case TYPE: {
                            if (attribute.getValueCount() != 1) {
                                throw new RuntimeException("Valuecount != 1");
                            }
                            types.add(attribute.getValueList().get(0));
                            continue block15;
                        }
                        case PRIORITY: {
                            continue block15;
                        }
                        case EXTRA: {
                            continue block15;
                        }
                        case FLAG: {
                            continue block15;
                        }
                    }
                    throw new RuntimeException("Unexpected: " + attribute.getKind().toString());
                }
                if (!categoryVisited && this.getCategories().isEmpty()) {
                    passedCategory = true;
                }
                if (schemes.isEmpty() && hosts.isEmpty()) {
                    paths.clear();
                }
                if (schemes.isEmpty()) {
                    hosts.clear();
                }
                if (hosts.isEmpty()) {
                    ports.clear();
                }
                boolean matchesURI = false;
                if (!schemes.isEmpty()) {
                    matchesURI |= schemes.contains(this.getDataScheme());
                }
                if (!authorities.isEmpty()) {
                    matchesURI |= authorities.contains(this.getAuthority());
                }
                if (!paths.isEmpty()) {
                    for (String input : paths) {
                        String regex = ("\\Q" + input + "\\E").replace("*", "\\E.*\\Q");
                        String s = this.getDataPath();
                        if (s == null) {
                            s = "";
                        }
                        matchesURI |= s.matches(regex);
                    }
                }
                if (!hosts.isEmpty()) {
                    matchesURI |= hosts.contains(this.getDataHost());
                }
                if (!ports.isEmpty()) {
                    matchesURI |= ports.contains(this.getDataPort());
                }
                if (!types.isEmpty()) {
                    matchesURI |= types.contains(this.getType());
                }
                boolean bl = this.getDataScheme() != null;
                boolean bl2 = intentFilterSpecifiesURI = !schemes.isEmpty();
                if (this.getType() == null && this.getAuthority() == null && this.getDataScheme() == null && this.getDataPort() == -1 && this.getDataPath() == null && this.getDataHost() == null) {
                    boolean bl3 = passedData = ports.isEmpty() && paths.isEmpty() && hosts.isEmpty() && authorities.isEmpty() && schemes.isEmpty() && types.isEmpty();
                }
                if (bl && this.getType() == null) {
                    boolean bl4 = passedData = matchesURI && types.isEmpty();
                }
                if (this.getType() != null && !bl) {
                    if (this.getType() == null) {
                        passedData = !intentFilterSpecifiesURI;
                    } else {
                        boolean bl5 = passedData = types.contains(this.getType()) && !intentFilterSpecifiesURI;
                    }
                }
                if (this.getType() != null && bl) {
                    boolean mimetype = types.contains(this.getType());
                    boolean urlpart = matchesURI;
                    if (this.getDataScheme() != null) {
                        urlpart = urlpart || (this.getDataScheme().equals("content") || this.getDataScheme().equals("file")) && !intentFilterSpecifiesURI;
                    }
                    passedData = mimetype && urlpart;
                }
                if (!(passedActionPart = passedAction || !hasSpecifiedAnAction) || !passedCategory || !passedData) continue;
                results.add(component);
                continue block13;
            }
        }
        return results;
    }

    public void setType(String value) {
        if (value.isEmpty() || value.equals("(.*)")) {
            return;
        }
        this.dataType = value;
    }

    public String getType() {
        return this.dataType;
    }
}

