/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.iccta.IccLink;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.tagkit.Tag;

public class IccInstrumentDestination {
    private static IccInstrumentDestination s = null;
    private static RefType INTENT_TYPE = RefType.v((String)"android.content.Intent");
    private IccLink iccLink = null;

    private IccInstrumentDestination() {
    }

    public static IccInstrumentDestination v() {
        if (s == null) {
            s = new IccInstrumentDestination();
        }
        return s;
    }

    public SootClass instrumentDestinationForContentProvider(String destination) {
        return Scene.v().getSootClass(destination);
    }

    public SootMethod generateInitMethod(SootClass compSootClass, SootField intentSootField) {
        String name = "<init>";
        ArrayList<RefType> parameters = new ArrayList<RefType>();
        parameters.add(INTENT_TYPE);
        VoidType returnType = VoidType.v();
        int modifiers = 1;
        SootMethod newConstructor = new SootMethod(name, parameters, (Type)returnType, modifiers);
        compSootClass.addMethod(newConstructor);
        JimpleBody b = Jimple.v().newBody(newConstructor);
        newConstructor.setActiveBody((Body)b);
        LocalGenerator lg = new LocalGenerator((Body)b);
        Local thisLocal = lg.generateLocal((Type)compSootClass.getType());
        IdentityStmt thisU = Jimple.v().newIdentityStmt((Value)thisLocal, (Value)Jimple.v().newThisRef(compSootClass.getType()));
        Local intentParameterLocal = lg.generateLocal((Type)INTENT_TYPE);
        IdentityStmt intentParameterU = Jimple.v().newIdentityStmt((Value)intentParameterLocal, (Value)Jimple.v().newParameterRef((Type)INTENT_TYPE, 0));
        boolean noDefaultConstructMethod = false;
        InvokeStmt superU = null;
        try {
            superU = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(thisLocal, compSootClass.getMethod(name, new ArrayList(), (Type)VoidType.v()).makeRef()));
        }
        catch (Exception ex) {
            noDefaultConstructMethod = true;
        }
        if (noDefaultConstructMethod) {
            List sootMethods = compSootClass.getMethods();
            for (SootMethod sm : sootMethods) {
                ArrayList<Object> args;
                if (!sm.getName().equals("<init>")) continue;
                if (sm.getParameterCount() == 1 && sm.getParameterType(0).equals(INTENT_TYPE)) {
                    args = new ArrayList();
                    args.add(intentParameterLocal);
                    superU = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(thisLocal, sm.makeRef(), args));
                    continue;
                }
                args = new ArrayList<Object>();
                for (int i = 0; i < sm.getParameterCount(); ++i) {
                    args.add(NullConstant.v());
                }
                superU = Jimple.v().newInvokeStmt((Value)Jimple.v().newSpecialInvokeExpr(thisLocal, sm.makeRef(), args));
                break;
            }
        }
        AssignStmt storeIntentU = Jimple.v().newAssignStmt((Value)Jimple.v().newStaticFieldRef(intentSootField.makeRef()), (Value)intentParameterLocal);
        b.getUnits().add((Unit)thisU);
        b.getUnits().add((Unit)intentParameterU);
        b.getUnits().add((Unit)superU);
        b.getUnits().add((Unit)storeIntentU);
        b.getUnits().add((Unit)Jimple.v().newReturnVoidStmt());
        return newConstructor;
    }

    public SootField getMessageForIPCField() {
        SootClass sc = this.iccLink.fromSM.getDeclaringClass();
        if (!sc.declaresField("message_for_ipc_static", (Type)RefType.v((String)"android.os.Messenge"))) {
            this.fieldSendingMessage(this.iccLink.fromSM);
        }
        return sc.getFieldByName("message_for_ipc_static");
    }

    public Type extractBinderType(SootClass sootClass) {
        SootMethod onBindMethod = null;
        try {
            onBindMethod = sootClass.getMethodByName("onBind");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (null == onBindMethod) {
            return null;
        }
        Body body = onBindMethod.retrieveActiveBody();
        UnitPatchingChain units = body.getUnits();
        Iterator iter = units.snapshotIterator();
        while (iter.hasNext()) {
            Stmt stmt = (Stmt)iter.next();
            if (!(stmt instanceof ReturnStmt)) continue;
            ReturnStmt rtStmt = (ReturnStmt)stmt;
            Value rtValue = rtStmt.getOp();
            if (rtValue.toString().equals("null")) {
                return onBindMethod.getReturnType();
            }
            return rtValue.getType();
        }
        return onBindMethod.getReturnType();
    }

    public void fieldSendingMessage(SootMethod fromSM) {
        SootClass fromC = fromSM.getDeclaringClass();
        if (fromC.declaresField("message_for_ipc_static", (Type)RefType.v((String)"android.os.Message"))) {
            return;
        }
        int m = 9;
        SootField sf = Scene.v().makeSootField("message_for_ipc_static", (Type)RefType.v((String)"android.os.Message"), m);
        fromC.addField(sf);
        for (SootMethod sm : fromC.getMethods()) {
            if (!sm.isConcrete()) continue;
            Body body = sm.retrieveActiveBody();
            UnitPatchingChain units = body.getUnits();
            Iterator iter = units.snapshotIterator();
            while (iter.hasNext()) {
                SootMethod toBeCheckedMethod;
                Stmt stmt = (Stmt)iter.next();
                if (!stmt.containsInvokeExpr() || !(toBeCheckedMethod = stmt.getInvokeExpr().getMethod()).getName().equals("send") || !this.equalsOrSubclassOf(toBeCheckedMethod.getDeclaringClass(), Scene.v().getSootClass("android.os.Messenger"))) continue;
                Value arg0 = stmt.getInvokeExpr().getArg(0);
                AssignStmt assignUnit = Jimple.v().newAssignStmt((Value)Jimple.v().newStaticFieldRef(sf.makeRef()), arg0);
                assignUnit.addTag((Tag)SimulatedCodeElementTag.TAG);
                units.insertBefore((Unit)assignUnit, (Unit)stmt);
            }
        }
    }

    public boolean equalsOrSubclassOf(SootClass testClass, SootClass parentClass) {
        if (testClass.getName().equals(parentClass.getName())) {
            return true;
        }
        if (testClass.hasSuperclass()) {
            testClass = testClass.getSuperclass();
            return this.equalsOrSubclassOf(testClass, parentClass);
        }
        return false;
    }
}

