/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.android.iccta.App;
import soot.jimple.infoflow.android.iccta.Ic3Data;
import soot.jimple.infoflow.android.iccta.Intent;
import soot.jimple.infoflow.android.iccta.LoggingPoint;

public class Ic3ResultLoader {
    private static final Logger logger = LoggerFactory.getLogger(Ic3ResultLoader.class);

    public static App load(String resultConfigPath) {
        Ic3Data.Application application;
        try (FileInputStream inputStream = new FileInputStream(resultConfigPath);){
            if (resultConfigPath.endsWith(".dat")) {
                application = Ic3Data.Application.parseFrom(inputStream);
            } else {
                Ic3Data.Application.Builder builder = Ic3Data.Application.newBuilder();
                InputStreamReader reader = new InputStreamReader(inputStream);
                TextFormat.merge((Readable)reader, (Message.Builder)builder);
                application = builder.build();
            }
        }
        catch (IOException exception) {
            logger.error("Problem opening or reading from file " + resultConfigPath, (Throwable)exception);
            return null;
        }
        HashSet<LoggingPoint> loggingPoints = new HashSet<LoggingPoint>();
        App result = new App("IC3", application.getName());
        result.setComponentList(application.getComponentsList());
        for (Ic3Data.Application.Component component : application.getComponentsList()) {
            for (Ic3Data.Application.Component.ExitPoint exitPoint : component.getExitPointsList()) {
                LoggingPoint loggingPoint = new LoggingPoint(result);
                Ic3Data.Application.Component.Instruction instruction = exitPoint.getInstruction();
                loggingPoint.setCallerMethodSignature(instruction.getMethod());
                loggingPoint.setStmtSequence(instruction.getId());
                String stmt = instruction.getStatement();
                int startPos = stmt.indexOf("<");
                int endPos = stmt.lastIndexOf(">");
                loggingPoint.setCalleeMethodSignature(stmt.substring(startPos, endPos + 1));
                HashSet<Intent> intents = new HashSet<Intent>();
                loggingPoint.setIntents(intents);
                for (Ic3Data.Application.Component.ExitPoint.Intent intent : exitPoint.getIntentsList()) {
                    Intent destinationIntent = new Intent(result, loggingPoint);
                    String componentPackage = null;
                    String componentClass = null;
                    HashSet<String> categories = new HashSet<String>();
                    HashSet<String> extras = new HashSet<String>();
                    HashSet<Integer> flags = new HashSet<Integer>();
                    for (Ic3Data.Attribute attribute : intent.getAttributesList()) {
                        switch (attribute.getKind()) {
                            case PACKAGE: {
                                componentPackage = attribute.getValue(0);
                                destinationIntent.setComponent(componentPackage);
                                break;
                            }
                            case CLASS: {
                                componentClass = attribute.getValue(0).replace('/', '.');
                                destinationIntent.setComponentClass(componentClass.replace('/', '.'));
                                break;
                            }
                            case ACTION: {
                                destinationIntent.setAction(attribute.getValue(0));
                                break;
                            }
                            case CATEGORY: {
                                categories.addAll(attribute.getValueList());
                                break;
                            }
                            case EXTRA: {
                                extras.addAll(attribute.getValueList());
                                break;
                            }
                            case SCHEME: {
                                destinationIntent.setDataScheme(attribute.getValue(0));
                                break;
                            }
                            case HOST: {
                                destinationIntent.setDataHost(attribute.getValue(0));
                                break;
                            }
                            case PORT: {
                                destinationIntent.setDataPort(attribute.getIntValue(0));
                                break;
                            }
                            case PATH: {
                                destinationIntent.setDataPath(attribute.getValue(0));
                                break;
                            }
                            case URI: {
                                destinationIntent.setData(attribute.getValue(0));
                                break;
                            }
                            case FLAG: {
                                flags.addAll(attribute.getIntValueList());
                                break;
                            }
                            case AUTHORITY: {
                                destinationIntent.setAuthority(attribute.getValue(0));
                                break;
                            }
                            case PRIORITY: {
                                break;
                            }
                            case QUERY: {
                                break;
                            }
                            case SSP: {
                                break;
                            }
                            case TYPE: {
                                destinationIntent.setType(attribute.getValue(0));
                                break;
                            }
                        }
                    }
                    if (categories.size() != 0) {
                        destinationIntent.setCategories(categories);
                    }
                    if (extras.size() != 0) {
                        HashMap<String, String> extrasMap = new HashMap<String, String>();
                        for (String extra : extras) {
                            extrasMap.put(extra, "(.*)");
                        }
                        destinationIntent.setExtras(extrasMap);
                    }
                    if (flags.size() != 0) {
                        int flagsInteger = 0;
                        Iterator iterator = flags.iterator();
                        while (iterator.hasNext()) {
                            int flag = (Integer)iterator.next();
                            flagsInteger |= flag;
                        }
                        destinationIntent.setFlags(flagsInteger);
                    }
                    if (componentPackage != null && componentClass != null) {
                        destinationIntent.setComponent(componentPackage + "/" + componentClass);
                    }
                    intents.add(destinationIntent);
                }
                loggingPoints.add(loggingPoint);
            }
        }
        result.setAnalysisTime((int)(application.getAnalysisEnd() - application.getAnalysisStart()));
        result.setLoggingPoints(loggingPoints);
        return result;
    }
}

