/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators.components;

import java.util.Collections;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.android.entryPointCreators.components.AbstractComponentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointInfo;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceEntryPointInfo;
import soot.jimple.infoflow.android.manifest.ProcessManifest;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.tagkit.Tag;

public class ServiceEntryPointCreator
extends AbstractComponentEntryPointCreator {
    protected SootField binderField = null;

    public ServiceEntryPointCreator(SootClass component, SootClass applicationClass, ProcessManifest manifest) {
        super(component, applicationClass, manifest);
    }

    @Override
    protected void generateComponentLifecycle() {
        SootMethod sm;
        this.searchAndBuildMethod("void onCreate()", this.component, this.thisLocal);
        this.searchAndBuildMethod("void onStart(android.content.Intent,int)", this.component, this.thisLocal);
        NopStmt beforeStartCommand = Jimple.v().newNopStmt();
        NopStmt afterStartCommand = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)beforeStartCommand);
        this.createIfStmt((Unit)afterStartCommand);
        this.searchAndBuildMethod("int onStartCommand(android.content.Intent,int,int)", this.component, this.thisLocal);
        this.createIfStmt((Unit)beforeStartCommand);
        this.body.getUnits().add((Unit)afterStartCommand);
        NopStmt startWhileStmt = Jimple.v().newNopStmt();
        NopStmt endWhileStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)startWhileStmt);
        this.createIfStmt((Unit)endWhileStmt);
        AndroidEntryPointUtils.ComponentType componentType = this.entryPointUtils.getComponentType(this.component);
        boolean hasAdditionalMethods = false;
        if (componentType == AndroidEntryPointUtils.ComponentType.GCMBaseIntentService) {
            for (String sig : AndroidEntryPointConstants.getGCMIntentServiceMethods()) {
                sm = this.findMethod(this.component, sig);
                if (sm == null || sm.getDeclaringClass().getName().equals("com.google.android.gcm.GCMBaseIntentService") || !this.createPlainMethodCall(this.thisLocal, sm)) continue;
                hasAdditionalMethods = true;
            }
        } else if (componentType == AndroidEntryPointUtils.ComponentType.GCMListenerService) {
            for (String sig : AndroidEntryPointConstants.getGCMListenerServiceMethods()) {
                sm = this.findMethod(this.component, sig);
                if (sm == null || sm.getDeclaringClass().getName().equals("com.google.android.gms.gcm.GcmListenerService") || !this.createPlainMethodCall(this.thisLocal, sm)) continue;
                hasAdditionalMethods = true;
            }
        }
        this.addCallbackMethods();
        this.body.getUnits().add((Unit)endWhileStmt);
        if (hasAdditionalMethods) {
            this.createIfStmt((Unit)startWhileStmt);
        }
        this.searchAndBuildMethod("android.os.IBinder onBind(android.content.Intent)", this.component, this.thisLocal);
        NopStmt beforemethodsStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)beforemethodsStmt);
        NopStmt startWhile2Stmt = Jimple.v().newNopStmt();
        NopStmt endWhile2Stmt = Jimple.v().newNopStmt();
        this.body.getUnits().add((Unit)startWhile2Stmt);
        hasAdditionalMethods = false;
        if (componentType == AndroidEntryPointUtils.ComponentType.GCMBaseIntentService) {
            for (String sig : AndroidEntryPointConstants.getGCMIntentServiceMethods()) {
                SootMethod sm2 = this.findMethod(this.component, sig);
                if (sm2 == null || sm2.getName().equals("com.google.android.gcm.GCMBaseIntentService") || !this.createPlainMethodCall(this.thisLocal, sm2)) continue;
                hasAdditionalMethods = true;
            }
        }
        this.addCallbackMethods();
        this.body.getUnits().add((Unit)endWhile2Stmt);
        if (hasAdditionalMethods) {
            this.createIfStmt((Unit)startWhile2Stmt);
        }
        NopStmt onDestroyStmt = Jimple.v().newNopStmt();
        this.searchAndBuildMethod("boolean onUnbind(android.content.Intent)", this.component, this.thisLocal);
        this.createIfStmt((Unit)onDestroyStmt);
        this.searchAndBuildMethod("void onRebind(android.content.Intent)", this.component, this.thisLocal);
        this.createIfStmt((Unit)beforemethodsStmt);
        this.body.getUnits().add((Unit)onDestroyStmt);
        this.searchAndBuildMethod("void onDestroy()", this.component, this.thisLocal);
    }

    @Override
    protected void createAdditionalFields() {
        super.createAdditionalFields();
        String fieldName = "ipcIntent";
        int fieldIdx = 0;
        while (this.component.declaresFieldByName(fieldName)) {
            fieldName = "ipcBinder_" + fieldIdx++;
        }
        this.binderField = Scene.v().makeSootField(fieldName, (Type)RefType.v((String)"android.os.IBinder"), 1);
        this.component.addField(this.binderField);
    }

    protected void createAdditionalMethods() {
        super.createAdditionalMethods();
        this.instrumentOnBind();
        this.createGetIntentMethod();
    }

    private void instrumentOnBind() {
        SootMethod sm = this.component.getMethodUnsafe("android.os.IBinder onBind(android.content.Intent)");
        RefType intentType = RefType.v((String)"android.content.Intent");
        RefType binderType = RefType.v((String)"android.os.IBinder");
        if (sm == null || !sm.hasActiveBody()) {
            if (sm == null) {
                sm = Scene.v().makeSootMethod("onBind", Collections.singletonList(intentType), (Type)binderType, 1);
                this.component.addMethod(sm);
                sm.addTag((Tag)SimulatedCodeElementTag.TAG);
            }
            JimpleBody b = Jimple.v().newBody(sm);
            sm.setActiveBody((Body)b);
            b.insertIdentityStmts();
            Local thisLocal = b.getThisLocal();
            Local binderLocal = b.getParameterLocal(0);
            b.getUnits().add((Unit)Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, this.binderField.makeRef()), (Value)binderLocal));
            b.getUnits().add((Unit)Jimple.v().newReturnStmt((Value)binderLocal));
        } else {
            JimpleBody b = (JimpleBody)sm.getActiveBody();
            Stmt firstNonIdentityStmt = b.getFirstNonIdentityStmt();
            Local thisLocal = b.getThisLocal();
            Local binderLocal = b.getParameterLocal(0);
            AssignStmt assignStmt = Jimple.v().newAssignStmt((Value)Jimple.v().newInstanceFieldRef((Value)thisLocal, this.binderField.makeRef()), (Value)binderLocal);
            assignStmt.addTag((Tag)SimulatedCodeElementTag.TAG);
            b.getUnits().insertAfter((Unit)assignStmt, (Unit)firstNonIdentityStmt);
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.component.removeField(this.binderField);
        this.binderField = null;
    }

    @Override
    public ComponentEntryPointInfo getComponentInfo() {
        ServiceEntryPointInfo serviceInfo = new ServiceEntryPointInfo(this.mainMethod);
        serviceInfo.setIntentField(this.intentField);
        serviceInfo.setBinderField(this.binderField);
        return serviceInfo;
    }
}

